/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.stereo;

import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.opengl.math.FovHVHalves;
import com.jogamp.opengl.util.stereo.EyeParameter;
import com.jogamp.opengl.util.stereo.StereoDevice;
import com.jogamp.opengl.util.stereo.StereoDeviceFactory;
import com.jogamp.opengl.util.stereo.StereoDeviceRenderer;
import com.jogamp.opengl.util.stereo.StereoUtil;
import java.util.Arrays;
import jogamp.opengl.util.stereo.DistortionMesh;
import jogamp.opengl.util.stereo.GenericStereoDeviceRenderer;

public class GenericStereoDevice
implements StereoDevice {
    public static final Config config01Mono01;
    public static final Config config02StereoSBS01;
    public static final Config config03StereoSBSLense01;
    private static final Config[] configs;
    private final StereoDeviceFactory factory;
    public final int deviceIndex;
    public final Config config;
    public final Point surfacePos;
    private final FovHVHalves[] defaultEyeFov;
    private boolean sensorsStarted = false;

    public GenericStereoDevice(StereoDeviceFactory stereoDeviceFactory, int n, StereoDevice.Config config) {
        int n2;
        this.factory = stereoDeviceFactory;
        this.deviceIndex = n;
        this.config = config instanceof Config ? (Config)config : (null != configs[n2 = Math.min(n % 10, configs.length - 1)] ? configs[n2] : config02StereoSBS01);
        this.config.init();
        this.surfacePos = new Point(0, 0);
        this.defaultEyeFov = new FovHVHalves[this.config.defaultEyeParam.length];
        for (n2 = 0; n2 < this.defaultEyeFov.length; ++n2) {
            this.defaultEyeFov[n2] = this.config.defaultEyeParam[n2].fovhv;
        }
    }

    @Override
    public final StereoDeviceFactory getFactory() {
        return this.factory;
    }

    public String toString() {
        return "GenericStereoDevice[" + this.config + ", surfacePos " + this.surfacePos + "]";
    }

    public void setSurfacePosition(int n, int n2) {
        this.surfacePos.set(n, n2);
    }

    @Override
    public final void dispose() {
    }

    @Override
    public final PointImmutable getPosition() {
        return this.surfacePos;
    }

    @Override
    public final DimensionImmutable getSurfaceSize() {
        return this.config.surfaceSizeInPixels;
    }

    @Override
    public float[] getDefaultEyePositionOffset() {
        return this.config.defaultEyeParam[0].positionOffset;
    }

    @Override
    public final FovHVHalves[] getDefaultFOV() {
        return this.defaultEyeFov;
    }

    @Override
    public final boolean startSensors(boolean bl) {
        if (bl && !this.sensorsStarted) {
            if (this.startSensorsImpl(true)) {
                this.sensorsStarted = true;
                return true;
            }
            this.sensorsStarted = false;
            return false;
        }
        if (this.sensorsStarted) {
            if (this.startSensorsImpl(false)) {
                this.sensorsStarted = false;
                return true;
            }
            this.sensorsStarted = true;
            return false;
        }
        return true;
    }

    private boolean startSensorsImpl(boolean bl) {
        return bl;
    }

    @Override
    public boolean getSensorsStarted() {
        return this.sensorsStarted;
    }

    @Override
    public int[] getEyeRenderOrder() {
        return this.config.eyeRenderOrder;
    }

    @Override
    public int getSupportedDistortionBits() {
        return this.config.supportedDistortionBits;
    }

    @Override
    public int getRecommendedDistortionBits() {
        return this.config.recommendedDistortionBits;
    }

    @Override
    public int getMinimumDistortionBits() {
        return this.config.minimumDistortionBits;
    }

    @Override
    public final StereoDeviceRenderer createRenderer(int n, int n2, float[] fArray, FovHVHalves[] fovHVHalvesArray, float f, int n3) {
        DimensionImmutable dimensionImmutable;
        RectangleImmutable[] rectangleImmutableArray;
        int n4;
        EyeParameter[] eyeParameterArray = new EyeParameter[fovHVHalvesArray.length];
        for (n4 = 0; n4 < eyeParameterArray.length; ++n4) {
            rectangleImmutableArray = this.config.defaultEyeParam[n4];
            eyeParameterArray[n4] = new EyeParameter(n4, fArray, fovHVHalvesArray[n4], rectangleImmutableArray.distNoseToPupilX, rectangleImmutableArray.distMiddleToPupilY, rectangleImmutableArray.eyeReliefZ);
        }
        n4 = null != this.config.distortionMeshProducer && 0 != n ? 1 : 0;
        rectangleImmutableArray = new RectangleImmutable[eyeParameterArray.length];
        DimensionImmutable dimensionImmutable2 = this.config.eyeTextureSize;
        if (1 < eyeParameterArray.length) {
            dimensionImmutable = new Dimension(dimensionImmutable2.getWidth() * 2, dimensionImmutable2.getHeight());
            if (1 == n2) {
                rectangleImmutableArray[0] = new Rectangle(0, 0, dimensionImmutable2.getWidth(), dimensionImmutable2.getHeight());
                rectangleImmutableArray[1] = new Rectangle(dimensionImmutable2.getWidth(), 0, dimensionImmutable2.getWidth(), dimensionImmutable2.getHeight());
            } else {
                rectangleImmutableArray[0] = new Rectangle(0, 0, dimensionImmutable2.getWidth(), dimensionImmutable2.getHeight());
                rectangleImmutableArray[1] = n4 != 0 ? rectangleImmutableArray[0] : new Rectangle(dimensionImmutable2.getWidth(), 0, dimensionImmutable2.getWidth(), dimensionImmutable2.getHeight());
            }
        } else {
            dimensionImmutable = dimensionImmutable2;
            rectangleImmutableArray[0] = new Rectangle(0, 0, dimensionImmutable2.getWidth(), dimensionImmutable2.getHeight());
        }
        return new GenericStereoDeviceRenderer(this, n, n2, fArray, eyeParameterArray, f, n3, dimensionImmutable2, dimensionImmutable, rectangleImmutableArray);
    }

    static {
        FovHVHalves fovHVHalves;
        Object object;
        Object object2;
        float f;
        float[] fArray;
        Dimension dimension;
        float[] fArray2;
        block2: {
            fArray2 = new float[]{0.0f, 1.6f, -5.0f};
            float[] fArray3 = new float[]{0.0f, 0.3f, 3.0f};
            float[] fArray4 = new float[]{0.0f, 0.0f, 3.0f};
            dimension = new Dimension(1280, 800);
            fArray = new float[]{0.1498f, 0.0936f};
            f = fArray[1] / 2.0f;
            config01Mono01 = new Config("Def01Mono01", ShutterType.RollingTopToBottom, dimension, fArray, dimension, f, 0.0635f, new int[]{0}, new EyeParameter[]{new EyeParameter(0, fArray4, FovHVHalves.byFovyRadianAndAspect(0.7853982f, 1.6f), 0.0f, 0.0f, 0.0f)}, null, 0, 0, 0);
            object2 = new Dimension(dimension.getWidth() / 2, dimension.getHeight());
            object = Config.getHorizPupilCenterFromLeft(fArray[0], 0.0635f);
            float f2 = Config.getVertPupilCenterFromTop(fArray[1], f);
            float f3 = (float)object2.getWidth() / (float)object2.getHeight();
            FovHVHalves fovHVHalves2 = FovHVHalves.byFovyRadianAndAspect(0.7853982f, f2, f3, object[0]);
            fovHVHalves = FovHVHalves.byFovyRadianAndAspect(0.7853982f, f2, f3, object[1]);
            config02StereoSBS01 = new Config("Def02StereoSBS01", ShutterType.RollingTopToBottom, dimension, fArray, (DimensionImmutable)object2, f, 0.0635f, new int[]{0, 1}, new EyeParameter[]{new EyeParameter(0, fArray3, fovHVHalves2, 0.032f, 0.0f, 0.01f), new EyeParameter(1, fArray3, fovHVHalves, -0.032f, 0.0f, 0.01f)}, null, 0, 0, 0);
            object2 = null;
            try {
                object2 = (DistortionMesh.Producer)ReflectionUtil.createInstance((String)"jogamp.opengl.oculusvr.stereo.lense.DistortionMeshProducer", (ClassLoader)GenericStereoDevice.class.getClassLoader());
            }
            catch (Throwable throwable) {
                if (!StereoDevice.DEBUG) break block2;
                System.err.println("Caught: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        object = new Dimension(1122, 1553);
        float[] fArray5 = Config.getHorizPupilCenterFromLeft(fArray[0], 0.0635f);
        float f4 = Config.getVertPupilCenterFromTop(fArray[1], f);
        float f5 = (float)object.getWidth() / (float)object.getHeight();
        fovHVHalves = FovHVHalves.byFovyRadianAndAspect(2.2514746f, f4, f5, fArray5[0]);
        FovHVHalves fovHVHalves3 = FovHVHalves.byFovyRadianAndAspect(2.2514746f, f4, f5, fArray5[1]);
        config03StereoSBSLense01 = null == object2 ? null : new Config("Def03StereoSBSLense01", ShutterType.RollingTopToBottom, dimension, fArray, (DimensionImmutable)object, f, 0.0635f, new int[]{0, 1}, new EyeParameter[]{new EyeParameter(0, fArray2, fovHVHalves, 0.032f, 0.0f, 0.01f), new EyeParameter(1, fArray2, fovHVHalves3, -0.032f, 0.0f, 0.01f)}, (DistortionMesh.Producer)object2, 7, 7, 1);
        configs = new Config[]{config01Mono01, config02StereoSBS01, config03StereoSBSLense01};
    }

    public static class Config
    extends StereoDevice.Config {
        public final String name;
        public final ShutterType shutterType;
        public final DimensionImmutable surfaceSizeInPixels;
        public final float[] screenSizeInMeters;
        public final DimensionImmutable eyeTextureSize;
        public final float pupilCenterFromScreenTopInMeters;
        public final float interpupillaryDistanceInMeters;
        public final float[][] pupilCenterFromTopLeft;
        public final int[] eyeRenderOrder;
        public final EyeParameter[] defaultEyeParam;
        public final DistortionMesh.Producer distortionMeshProducer;
        public final int supportedDistortionBits;
        public final int recommendedDistortionBits;
        public final int minimumDistortionBits;

        public Config(String string, ShutterType shutterType, DimensionImmutable dimensionImmutable, float[] fArray, DimensionImmutable dimensionImmutable2, float f, float f2, int[] nArray, EyeParameter[] eyeParameterArray, DistortionMesh.Producer producer, int n, int n2, int n3) {
            this.name = string;
            this.shutterType = shutterType;
            this.surfaceSizeInPixels = dimensionImmutable;
            this.screenSizeInMeters = fArray;
            this.eyeTextureSize = dimensionImmutable2;
            this.pupilCenterFromScreenTopInMeters = f;
            this.interpupillaryDistanceInMeters = f2;
            this.eyeRenderOrder = nArray;
            this.defaultEyeParam = eyeParameterArray;
            this.distortionMeshProducer = producer;
            this.supportedDistortionBits = n;
            this.recommendedDistortionBits = n2;
            this.minimumDistortionBits = n3;
            this.pupilCenterFromTopLeft = new float[2][2];
            this.calcPupilCenterFromTopLeft();
        }

        public Config(Config config, DimensionImmutable dimensionImmutable, float[] fArray, DimensionImmutable dimensionImmutable2) {
            this.name = config.name;
            this.shutterType = config.shutterType;
            this.surfaceSizeInPixels = dimensionImmutable;
            this.screenSizeInMeters = fArray;
            this.eyeTextureSize = dimensionImmutable2;
            this.pupilCenterFromScreenTopInMeters = config.pupilCenterFromScreenTopInMeters;
            this.interpupillaryDistanceInMeters = config.interpupillaryDistanceInMeters;
            this.eyeRenderOrder = config.eyeRenderOrder;
            this.defaultEyeParam = config.defaultEyeParam;
            this.distortionMeshProducer = config.distortionMeshProducer;
            this.supportedDistortionBits = config.supportedDistortionBits;
            this.recommendedDistortionBits = config.recommendedDistortionBits;
            this.minimumDistortionBits = config.minimumDistortionBits;
            this.pupilCenterFromTopLeft = new float[2][2];
            this.calcPupilCenterFromTopLeft();
        }

        private void calcPupilCenterFromTopLeft() {
            float f = 0.5f * this.screenSizeInMeters[0];
            float f2 = (this.screenSizeInMeters[0] - this.interpupillaryDistanceInMeters) * 0.5f;
            float f3 = f2 + this.interpupillaryDistanceInMeters - f;
            this.pupilCenterFromTopLeft[0][0] = f2 / f;
            this.pupilCenterFromTopLeft[0][1] = this.pupilCenterFromScreenTopInMeters / this.screenSizeInMeters[1];
            this.pupilCenterFromTopLeft[1][0] = f3 / f;
            this.pupilCenterFromTopLeft[1][1] = this.pupilCenterFromTopLeft[0][1];
        }

        public static float getVertPupilCenterFromTop(float f, float f2) {
            return f2 / f;
        }

        public static float[] getHorizPupilCenterFromLeft(float f, float f2) {
            float f3 = 0.5f * f;
            float f4 = (f - f2) * 0.5f;
            float f5 = f4 + f2 - f3;
            return new float[]{f4 / f3, f5 / f3};
        }

        void init() {
            float[] fArray = new float[this.defaultEyeParam.length];
            if (0 < this.defaultEyeParam.length) {
                fArray[0] = this.defaultEyeParam[0].eyeReliefZ;
            }
            if (1 < this.defaultEyeParam.length) {
                fArray[1] = this.defaultEyeParam[1].eyeReliefZ;
            }
            if (null != this.distortionMeshProducer) {
                this.distortionMeshProducer.init(this, fArray);
            }
        }

        public String toString() {
            return "StereoConfig[" + this.name + ", shutter " + (Object)((Object)this.shutterType) + ", surfaceSize " + this.surfaceSizeInPixels + ", screenSize " + this.screenSizeInMeters[0] + " x " + this.screenSizeInMeters[0] + " [m], eyeTexSize " + this.eyeTextureSize + ", IPD " + this.interpupillaryDistanceInMeters + " [m], eyeParam " + Arrays.toString(this.defaultEyeParam) + ", distortionBits[supported [" + StereoUtil.distortionBitsToString(this.supportedDistortionBits) + "], recommended [" + StereoUtil.distortionBitsToString(this.recommendedDistortionBits) + "], minimum [" + StereoUtil.distortionBitsToString(this.minimumDistortionBits) + "]]]";
        }
    }

    public static enum ShutterType {
        Global,
        RollingLeftToRight,
        RollingRightToLeft,
        RollingTopToBottom;

    }
}

