/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.drm;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import jogamp.common.os.MachineDataInfoRuntime;
import jogamp.nativewindow.drm.drmModeModeInfo;

public class drmModeConnector {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] drmModeConnector_size = new int[]{60, 60, 60, 60, 60, 60, 60, 88, 88, 88};
    private static final int[] connector_id_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] encoder_id_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] connector_type_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] connector_type_id_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final int[] connection_offset = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] mmWidth_offset = new int[]{20, 20, 20, 20, 20, 20, 20, 20, 20, 20};
    private static final int[] mmHeight_offset = new int[]{24, 24, 24, 24, 24, 24, 24, 24, 24, 24};
    private static final int[] subpixel_offset = new int[]{28, 28, 28, 28, 28, 28, 28, 28, 28, 28};
    private static final int[] count_modes_offset = new int[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private static final int[] modes_offset = new int[]{36, 36, 36, 36, 36, 36, 36, 40, 40, 40};
    private static final int[] count_props_offset = new int[]{40, 40, 40, 40, 40, 40, 40, 48, 48, 48};
    private static final int[] count_encoders_offset = new int[]{52, 52, 52, 52, 52, 52, 52, 72, 72, 72};

    public static int size() {
        return drmModeConnector_size[mdIdx];
    }

    public static drmModeConnector create() {
        return drmModeConnector.create(Buffers.newDirectByteBuffer(drmModeConnector.size()));
    }

    public static drmModeConnector create(ByteBuffer byteBuffer) {
        return new drmModeConnector(byteBuffer);
    }

    drmModeConnector(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[drmModeConnector.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public drmModeConnector setConnector_id(int n) {
        this.accessor.setIntAt(connector_id_offset[mdIdx], n);
        return this;
    }

    public int getConnector_id() {
        return this.accessor.getIntAt(connector_id_offset[mdIdx]);
    }

    public drmModeConnector setEncoder_id(int n) {
        this.accessor.setIntAt(encoder_id_offset[mdIdx], n);
        return this;
    }

    public int getEncoder_id() {
        return this.accessor.getIntAt(encoder_id_offset[mdIdx]);
    }

    public drmModeConnector setConnector_type(int n) {
        this.accessor.setIntAt(connector_type_offset[mdIdx], n);
        return this;
    }

    public int getConnector_type() {
        return this.accessor.getIntAt(connector_type_offset[mdIdx]);
    }

    public drmModeConnector setConnector_type_id(int n) {
        this.accessor.setIntAt(connector_type_id_offset[mdIdx], n);
        return this;
    }

    public int getConnector_type_id() {
        return this.accessor.getIntAt(connector_type_id_offset[mdIdx]);
    }

    public drmModeConnector setConnection(int n) {
        this.accessor.setIntAt(connection_offset[mdIdx], n);
        return this;
    }

    public int getConnection() {
        return this.accessor.getIntAt(connection_offset[mdIdx]);
    }

    public drmModeConnector setMmWidth(int n) {
        this.accessor.setIntAt(mmWidth_offset[mdIdx], n);
        return this;
    }

    public int getMmWidth() {
        return this.accessor.getIntAt(mmWidth_offset[mdIdx]);
    }

    public drmModeConnector setMmHeight(int n) {
        this.accessor.setIntAt(mmHeight_offset[mdIdx], n);
        return this;
    }

    public int getMmHeight() {
        return this.accessor.getIntAt(mmHeight_offset[mdIdx]);
    }

    public drmModeConnector setSubpixel(int n) {
        this.accessor.setIntAt(subpixel_offset[mdIdx], n);
        return this;
    }

    public int getSubpixel() {
        return this.accessor.getIntAt(subpixel_offset[mdIdx]);
    }

    public drmModeConnector setCount_modes(int n) {
        this.accessor.setIntAt(count_modes_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getCount_modes() {
        return this.accessor.getIntAt(count_modes_offset[mdIdx], this.md.intSizeInBytes());
    }

    private native ByteBuffer getModes0(ByteBuffer var1, int var2);

    public drmModeModeInfo[] getModes(int n, drmModeModeInfo[] drmModeModeInfoArray) {
        int n2 = this.getCount_modes();
        if (n + drmModeModeInfoArray.length > n2) {
            throw new IndexOutOfBoundsException("offset " + n + " + result.length " + drmModeModeInfoArray.length + " > array-length " + n2);
        }
        ByteBuffer byteBuffer = this.getBuffer();
        for (int i = 0; i < drmModeModeInfoArray.length; ++i) {
            ByteBuffer byteBuffer2 = this.getModes0(byteBuffer, n + i);
            if (byteBuffer2 == null) {
                return null;
            }
            drmModeModeInfoArray[i] = drmModeModeInfo.create(byteBuffer2);
        }
        return drmModeModeInfoArray;
    }

    public drmModeConnector setCount_props(int n) {
        this.accessor.setIntAt(count_props_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getCount_props() {
        return this.accessor.getIntAt(count_props_offset[mdIdx], this.md.intSizeInBytes());
    }

    private native ByteBuffer getProps0(ByteBuffer var1, int var2);

    public IntBuffer getProps() {
        int n = this.getCount_props();
        ByteBuffer byteBuffer = this.getProps0(this.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        return Buffers.nativeOrder(byteBuffer).asIntBuffer();
    }

    private native ByteBuffer getProp_values0(ByteBuffer var1, int var2);

    public LongBuffer getProp_values() {
        int n = this.getCount_props();
        ByteBuffer byteBuffer = this.getProp_values0(this.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        return Buffers.nativeOrder(byteBuffer).asLongBuffer();
    }

    public drmModeConnector setCount_encoders(int n) {
        this.accessor.setIntAt(count_encoders_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getCount_encoders() {
        return this.accessor.getIntAt(count_encoders_offset[mdIdx], this.md.intSizeInBytes());
    }

    private native ByteBuffer getEncoders0(ByteBuffer var1, int var2);

    public IntBuffer getEncoders() {
        int n = this.getCount_encoders();
        ByteBuffer byteBuffer = this.getEncoders0(this.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        return Buffers.nativeOrder(byteBuffer).asIntBuffer();
    }
}

