/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLImageFormat;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.impl.CLTLInfoAccessor;
import com.jogamp.opencl.llb.CL;
import java.nio.Buffer;

public abstract class CLImage<B extends Buffer>
extends CLMemory<B> {
    protected CLImageFormat format;
    final CLTLInfoAccessor imageInfo;
    public final int width;
    public final int height;

    protected CLImage(CLContext cLContext, B b, CLImageFormat cLImageFormat, int n, int n2, long l, int n3) {
        this(cLContext, b, cLImageFormat, CLImage.createAccessor(cLContext, l), n, n2, l, n3);
    }

    protected CLImage(CLContext cLContext, B b, CLImageFormat cLImageFormat, CLImageInfoAccessor cLImageInfoAccessor, int n, int n2, long l, int n3) {
        super(cLContext, b, CLImage.getSizeImpl(cLContext, l), l, n3);
        this.imageInfo = cLImageInfoAccessor;
        this.format = cLImageFormat;
        this.width = n;
        this.height = n2;
    }

    private static CLImageInfoAccessor createAccessor(CLContext cLContext, long l) {
        return new CLImageInfoAccessor(cLContext.getPlatform().getCLBinding(), l);
    }

    protected static CLImageFormat createUninitializedImageFormat() {
        return new CLImageFormat();
    }

    public CLImageFormat getFormat() {
        return this.format;
    }

    @Override
    public int getElementSize() {
        return (int)this.imageInfo.getLong(4369);
    }

    public int getRowPitch() {
        return (int)this.imageInfo.getLong(4370);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected static final class CLImageInfoAccessor
    extends CLTLInfoAccessor {
        private final long id;
        private final CL cl;

        public CLImageInfoAccessor(CL cL, long l) {
            this.cl = cL;
            this.id = l;
        }

        @Override
        public int getInfo(int n, long l, Buffer buffer, PointerBuffer pointerBuffer) {
            return this.cl.clGetImageInfo(this.id, n, l, buffer, pointerBuffer);
        }
    }
}

