/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.oculusvr;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.oculusvr.ovrRecti;
import com.jogamp.oculusvr.ovrSizei;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class ovrTextureHeader {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] ovrTextureHeader_size = new int[]{28, 28, 28, 28, 28, 28, 28, 28, 28, 28};
    private static final int[] API_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] TextureSize_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] TextureSize_size = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] RenderViewport_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final int[] RenderViewport_size = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};

    public static int size() {
        return ovrTextureHeader_size[mdIdx];
    }

    public static ovrTextureHeader create() {
        return ovrTextureHeader.create(Buffers.newDirectByteBuffer(ovrTextureHeader.size()));
    }

    public static ovrTextureHeader create(ByteBuffer byteBuffer) {
        return new ovrTextureHeader(byteBuffer);
    }

    ovrTextureHeader(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[ovrTextureHeader.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public ovrTextureHeader setAPI(int n) {
        this.accessor.setIntAt(API_offset[mdIdx], n);
        return this;
    }

    public int getAPI() {
        return this.accessor.getIntAt(API_offset[mdIdx]);
    }

    public ovrSizei getTextureSize() {
        return ovrSizei.create(this.accessor.slice(TextureSize_offset[mdIdx], TextureSize_size[mdIdx]));
    }

    public ovrRecti getRenderViewport() {
        return ovrRecti.create(this.accessor.slice(RenderViewport_offset[mdIdx], RenderViewport_size[mdIdx]));
    }
}

