/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.oculusvr;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.oculusvr.ovrVector3f;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class ovrSensorData {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] ovrSensorData_size = new int[]{44, 44, 44, 44, 44, 44, 44, 44, 44, 44};
    private static final int[] Accelerometer_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] Accelerometer_size = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final int[] Gyro_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final int[] Gyro_size = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final int[] Magnetometer_offset = new int[]{24, 24, 24, 24, 24, 24, 24, 24, 24, 24};
    private static final int[] Magnetometer_size = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final int[] Temperature_offset = new int[]{36, 36, 36, 36, 36, 36, 36, 36, 36, 36};
    private static final int[] TimeInSeconds_offset = new int[]{40, 40, 40, 40, 40, 40, 40, 40, 40, 40};

    public static int size() {
        return ovrSensorData_size[mdIdx];
    }

    public static ovrSensorData create() {
        return ovrSensorData.create(Buffers.newDirectByteBuffer(ovrSensorData.size()));
    }

    public static ovrSensorData create(ByteBuffer byteBuffer) {
        return new ovrSensorData(byteBuffer);
    }

    ovrSensorData(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[ovrSensorData.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public ovrVector3f getAccelerometer() {
        return ovrVector3f.create(this.accessor.slice(Accelerometer_offset[mdIdx], Accelerometer_size[mdIdx]));
    }

    public ovrVector3f getGyro() {
        return ovrVector3f.create(this.accessor.slice(Gyro_offset[mdIdx], Gyro_size[mdIdx]));
    }

    public ovrVector3f getMagnetometer() {
        return ovrVector3f.create(this.accessor.slice(Magnetometer_offset[mdIdx], Magnetometer_size[mdIdx]));
    }

    public ovrSensorData setTemperature(float f) {
        this.accessor.setFloatAt(Temperature_offset[mdIdx], f);
        return this;
    }

    public float getTemperature() {
        return this.accessor.getFloatAt(Temperature_offset[mdIdx]);
    }

    public ovrSensorData setTimeInSeconds(float f) {
        this.accessor.setFloatAt(TimeInSeconds_offset[mdIdx], f);
        return this;
    }

    public float getTimeInSeconds() {
        return this.accessor.getFloatAt(TimeInSeconds_offset[mdIdx]);
    }
}

