/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.net.AssetURLContext;
import com.jogamp.common.net.Uri;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.Permission;
import java.util.regex.Pattern;
import jogamp.common.Debug;
import jogamp.common.os.AndroidUtils;
import jogamp.common.os.PlatformPropsImpl;

public class IOUtil {
    public static final boolean DEBUG = Debug.debug("IOUtil");
    private static final String java_io_tmpdir_propkey = "java.io.tmpdir";
    private static final String user_home_propkey = "user.home";
    private static final String XDG_CACHE_HOME_envkey = "XDG_CACHE_HOME";
    public static final String tmpSubDir = "jogamp";
    private static final Pattern patternSingleBS = Pattern.compile("\\\\{1}");
    public static final Pattern patternSpaceEnc = Pattern.compile("%20");
    private static final Object exeTestBytesLock = new Object();
    private static WeakReference<byte[]> exeTestBytesRef = null;
    private static File tempRootExec = null;
    private static File tempRootNoexec = null;
    private static volatile boolean tempRootSet = false;

    private IOUtil() {
    }

    private static final Constructor<?> getFOSCtor() {
        Throwable throwable;
        Constructor<?> constructor;
        try {
            constructor = ReflectionUtil.getConstructor("java.io.FileOutputStream", new Class[]{File.class}, true, IOUtil.class.getClassLoader());
            throwable = null;
        }
        catch (Throwable throwable2) {
            constructor = null;
            throwable = throwable2;
        }
        if (DEBUG) {
            System.err.println("IOUtil: java.io.FileOutputStream available: " + (null != constructor));
            if (null != throwable) {
                throwable.printStackTrace();
            }
        }
        return constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyURLConn2File(URLConnection uRLConnection, File file) throws IOException {
        uRLConnection.connect();
        int n = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            n = IOUtil.copyStream2File(bufferedInputStream, file, uRLConnection.getContentLength());
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyStream2File(InputStream inputStream, File file, int n) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            n = IOUtil.copyStream2Stream(inputStream, bufferedOutputStream, n);
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
        return n;
    }

    public static int copyStream2Stream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        return IOUtil.copyStream2Stream(Platform.getMachineDataInfo().pageSizeInBytes(), inputStream, outputStream, n);
    }

    public static int copyStream2Stream(int n, InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[n];
        int n4 = 0;
        while ((n3 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n3);
            n4 += n3;
        }
        return n4;
    }

    public static byte[] copyStream2ByteArray(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n = 0;
        int n2 = inputStream.available();
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        do {
            if (n + n2 > byArray2.length) {
                byArray = new byte[n + n2];
                System.arraycopy(byArray2, 0, byArray, 0, n);
                byArray2 = byArray;
            }
            if ((n3 = inputStream.read(byArray2, n, n2)) < 0) continue;
            n += n3;
        } while ((n2 = inputStream.available()) > 0 && n3 >= 0);
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream) throws IOException {
        return IOUtil.copyStream2ByteBuffer(inputStream, -1);
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream, int n) throws IOException {
        int n2;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (n < (n2 = inputStream.available())) {
            n = n2;
        }
        MachineDataInfo machineDataInfo = Platform.getMachineDataInfo();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(machineDataInfo.pageAlignedSize(n));
        byte[] byArray = new byte[machineDataInfo.pageSizeInBytes()];
        int n3 = Math.min(machineDataInfo.pageSizeInBytes(), n2);
        int n4 = 0;
        do {
            if (n2 > byteBuffer.remaining()) {
                ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(machineDataInfo.pageAlignedSize(byteBuffer.position() + n2));
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
            }
            if ((n4 = inputStream.read(byArray, 0, n3)) > 0) {
                byteBuffer.put(byArray, 0, n4);
            }
            n2 = inputStream.available();
            n3 = Math.min(machineDataInfo.pageSizeInBytes(), n2);
        } while (n4 > 0);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static String slashify(String string, boolean bl, boolean bl2) throws URISyntaxException {
        String string2 = patternSingleBS.matcher(string).replaceAll("/");
        if (bl && !string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (bl2 && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return IOUtil.cleanPathString(string2);
    }

    public static String getFileSuffix(File file) {
        return IOUtil.getFileSuffix(file.getName());
    }

    public static String getFileSuffix(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return IOUtil.toLowerCase(string.substring(n + 1));
    }

    private static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static FileOutputStream getFileOutputStream(File file, boolean bl) throws IOException {
        Constructor<?> constructor = IOUtil.getFOSCtor();
        if (null == constructor) {
            throw new IOException("Cannot open file (" + file + ") for writing, FileOutputStream feature not available.");
        }
        if (file.exists() && !bl) {
            throw new IOException("File already exists (" + file + ") and overwrite=false");
        }
        try {
            return (FileOutputStream)constructor.newInstance(file);
        }
        catch (Exception exception) {
            throw new IOException("error opening " + file + " for write. ", exception);
        }
    }

    public static String getClassFileName(String string) {
        return string.replace('.', '/') + ".class";
    }

    public static URL getClassURL(String string, ClassLoader classLoader) throws IOException {
        URL uRL = classLoader.getResource(IOUtil.getClassFileName(string));
        if (null == uRL) {
            throw new IOException("Cannot not find: " + string);
        }
        return uRL;
    }

    public static String getBasename(String string) throws URISyntaxException {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String getDirname(String string) throws URISyntaxException {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(0, n + 1);
        }
        return string;
    }

    public static URLConnection getResource(Class<?> clazz, String string) {
        if (null == string) {
            return null;
        }
        ClassLoader classLoader = null != clazz ? clazz.getClassLoader() : IOUtil.class.getClassLoader();
        URLConnection uRLConnection = null;
        if (null != clazz) {
            String string2 = clazz.getName().replace('.', '/');
            int n = string2.lastIndexOf(47);
            if (n >= 0) {
                String string3 = string2.substring(0, n + 1);
                uRLConnection = IOUtil.getResource(string3 + string, classLoader);
                if (DEBUG) {
                    System.err.println("IOUtil: found <" + string + "> within class package <" + string3 + "> of given class <" + clazz.getName() + ">: " + (null != uRLConnection));
                }
            }
        } else if (DEBUG) {
            System.err.println("IOUtil: null context");
        }
        if (null == uRLConnection) {
            uRLConnection = IOUtil.getResource(string, classLoader);
            if (DEBUG) {
                System.err.println("IOUtil: found <" + string + "> by classloader: " + (null != uRLConnection));
            }
        }
        return uRLConnection;
    }

    public static URLConnection getResource(String string, ClassLoader classLoader) {
        if (null == string) {
            return null;
        }
        if (DEBUG) {
            System.err.println("IOUtil: locating <" + string + ">, has cl: " + (null != classLoader));
        }
        if (string.startsWith("asset:")) {
            try {
                return AssetURLContext.createURL(string, classLoader).openConnection();
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    System.err.println("IOUtil: Caught Exception:");
                    iOException.printStackTrace();
                }
                return null;
            }
        }
        try {
            return AssetURLContext.resolve(string, classLoader);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                System.err.println("IOUtil: Caught Exception:");
                iOException.printStackTrace();
            }
            return null;
        }
    }

    public static String getRelativeOf(File file, String string) throws URISyntaxException {
        if (null == string) {
            return null;
        }
        if (file != null) {
            File file2 = new File(file, string);
            return IOUtil.slashify(file2.getPath(), false, false);
        }
        return null;
    }

    public static String getParentOf(String string) throws URISyntaxException {
        int n;
        int n2 = n = null != string ? string.length() : 0;
        if (n == 0) {
            throw new IllegalArgumentException("path is empty <" + string + ">");
        }
        int n3 = string.lastIndexOf("/");
        if (n3 < 0) {
            throw new URISyntaxException(string, "path contains no '/'");
        }
        if (n3 == 0) {
            throw new URISyntaxException(string, "path has no parents");
        }
        if (n3 < n - 1) {
            return string.substring(0, n3 + 1);
        }
        int n4 = string.lastIndexOf("!") + 1;
        int n5 = string.lastIndexOf("/", n3 - 1);
        if (n5 >= n4) {
            return string.substring(0, n5 + 1);
        }
        throw new URISyntaxException(string, "parent of path contains no '/'");
    }

    public static String cleanPathString(String string) throws URISyntaxException {
        int n;
        while ((n = string.indexOf("../")) >= 0) {
            string = IOUtil.getParentOf(string.substring(0, n)) + string.substring(n + 3);
        }
        while ((n = string.indexOf("./")) >= 0) {
            string = string.substring(0, n) + string.substring(n + 2);
        }
        return string;
    }

    public static String getUriFilePathOrASCII(Uri uri) {
        if (uri.isFileScheme()) {
            return uri.toFile().getPath();
        }
        return uri.toASCIIString().get();
    }

    public static URLConnection openURL(URL uRL) {
        return IOUtil.openURL(uRL, ".");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URLConnection openURL(URL uRL, String string) {
        if (null != uRL) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                if (!DEBUG) return uRLConnection;
                System.err.println("IOUtil: urlExists(" + uRL + ") [" + string + "] - true");
                return uRLConnection;
            }
            catch (IOException iOException) {
                if (!DEBUG) return null;
                System.err.println("IOUtil: urlExists(" + uRL + ") [" + string + "] - false - " + iOException.getClass().getSimpleName() + ": " + iOException.getMessage());
                iOException.printStackTrace();
                return null;
            }
        } else {
            if (!DEBUG) return null;
            System.err.println("IOUtil: no url - urlExists(null) [" + string + "]");
        }
        return null;
    }

    private static String getExeTestFileSuffix() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                if (Platform.CPUFamily.X86 == PlatformPropsImpl.CPU_ARCH.family) {
                    return ".exe";
                }
                return ".bat";
            }
        }
        return ".sh";
    }

    private static String getExeTestShellCode() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                return "echo off" + PlatformPropsImpl.NEWLINE;
            }
        }
        return null;
    }

    private static String[] getExeTestCommandArgs(String string) {
        switch (PlatformPropsImpl.OS_TYPE) {
            default: 
        }
        return new String[]{string};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] getBytesFromRelFile(byte[] byArray, String string, int n) throws IOException {
        URLConnection uRLConnection = IOUtil.getResource(IOUtil.class, string);
        InputStream inputStream = uRLConnection.getInputStream();
        int n2 = 0;
        try {
            int n3;
            while (0 < (n3 = n - n2)) {
                int n4 = inputStream.read(byArray, n2, n3);
                if (n4 == -1) {
                    break;
                }
                n2 += n4;
            }
        }
        finally {
            inputStream.close();
        }
        if (n != n2) {
            throw new IOException("Got " + n2 + " bytes != expected " + n);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillExeTestFile(File file) throws IOException {
        if (Platform.OSType.WINDOWS == PlatformPropsImpl.OS_TYPE && Platform.CPUFamily.X86 == PlatformPropsImpl.CPU_ARCH.family) {
            byte[] byArray;
            Object object = exeTestBytesLock;
            synchronized (object) {
                byte[] byArray2;
                if (null == exeTestBytesRef || null == (byArray2 = (byte[])exeTestBytesRef.get())) {
                    byArray = IOUtil.getBytesFromRelFile(new byte[512], "bin/exe-windows-i586-268b.bin", 268);
                    exeTestBytesRef = new WeakReference<byte[]>(byArray);
                } else {
                    byArray = byArray2;
                }
            }
            object = new FileOutputStream(file);
            try {
                ((OutputStream)object).write(byArray, 0, 268);
            }
            finally {
                ((OutputStream)object).close();
            }
        }
        String string = IOUtil.getExeTestShellCode();
        if (IOUtil.isStringSet(string)) {
            FileWriter fileWriter = new FileWriter(file);
            try {
                fileWriter.write(string);
            }
            finally {
                fileWriter.close();
            }
        }
    }

    private static boolean getOSHasNoexecFS() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case OPENKODE: {
                return false;
            }
        }
        return true;
    }

    private static boolean getOSHasFreeDesktopXDG() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: 
            case OPENKODE: 
            case ANDROID: 
            case MACOS: {
                return false;
            }
        }
        return true;
    }

    public static boolean testFile(File file, boolean bl, boolean bl2) {
        if (!file.exists()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: does not exist");
            }
            return false;
        }
        if (bl && !file.isDirectory()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: is not a directory");
            }
            return false;
        }
        if (bl2 && !file.canWrite()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: is not writable");
            }
            return false;
        }
        return true;
    }

    public static boolean testDirExec(File file) throws SecurityException {
        int n;
        long l;
        File file2;
        long l2;
        block13: {
            if (!IOUtil.testFile(file, true, true)) {
                if (DEBUG) {
                    System.err.println("IOUtil.testDirExec: <" + file.getAbsolutePath() + ">: Not writeable dir");
                }
                return false;
            }
            if (!IOUtil.getOSHasNoexecFS()) {
                if (DEBUG) {
                    System.err.println("IOUtil.testDirExec: <" + file.getAbsolutePath() + ">: Always executable");
                }
                return true;
            }
            l2 = DEBUG ? System.currentTimeMillis() : 0L;
            try {
                file2 = File.createTempFile("jogamp_exe_tst", IOUtil.getExeTestFileSuffix(), file);
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    iOException.printStackTrace();
                }
                return false;
            }
            l = DEBUG ? System.currentTimeMillis() : 0L;
            n = -1;
            if (file2.setExecutable(true, true)) {
                try {
                    IOUtil.fillExeTestFile(file2);
                    Process process = Runtime.getRuntime().exec(IOUtil.getExeTestCommandArgs(file2.getCanonicalPath()));
                    process.waitFor();
                    n = process.exitValue();
                }
                catch (SecurityException securityException) {
                    throw securityException;
                }
                catch (Throwable throwable) {
                    n = -2;
                    if (!DEBUG) break block13;
                    System.err.println("IOUtil.testDirExec: <" + file2.getAbsolutePath() + ">: Caught " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
        }
        boolean bl = 0 == n;
        long l3 = DEBUG ? System.currentTimeMillis() : 0L;
        file2.delete();
        if (DEBUG) {
            System.err.println("IOUtil.testDirExec(): <" + file.getAbsolutePath() + ">: res " + n + " -> " + bl);
            System.err.println("IOUtil.testDirExec(): total " + (l3 - l2) + "ms, create " + (l - l2) + "ms, execute " + (l3 - l) + "ms");
        }
        return bl;
    }

    private static File testDirImpl(File file, boolean bl, boolean bl2, String string) throws SecurityException {
        File file2;
        if (bl && !file.exists()) {
            file.mkdirs();
        }
        if (bl2) {
            file2 = IOUtil.testDirExec(file) ? file : null;
        } else {
            File file3 = file2 = IOUtil.testFile(file, true, true) ? file : null;
        }
        if (DEBUG) {
            System.err.println("IOUtil.testDirImpl(" + string + "): <" + file.getAbsolutePath() + ">, create " + bl + ", exec " + bl2 + ": " + (null != file2));
        }
        return file2;
    }

    public static File testDir(File file, boolean bl, boolean bl2) throws SecurityException {
        return IOUtil.testDirImpl(file, bl, bl2, "testDir");
    }

    private static boolean isStringSet(String string) {
        return null != string && 0 < string.length();
    }

    private static File getSubTempDir(File file, String string, boolean bl, String string2) throws SecurityException {
        File file2 = null;
        if (null != IOUtil.testDirImpl(file, true, bl, string2)) {
            for (int i = 0; null == file2 && i <= 9999; ++i) {
                String string3 = String.format("_%04d", i);
                file2 = IOUtil.testDirImpl(new File(file, string + string3), true, bl, string2);
            }
        }
        return file2;
    }

    private static File getFile(String string) {
        if (IOUtil.isStringSet(string)) {
            return new File(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static File getTempDir(boolean bl) throws SecurityException, IOException {
        Object object;
        Object object2;
        if (!tempRootSet) {
            object2 = IOUtil.class;
            // MONITORENTER : com.jogamp.common.util.IOUtil.class
            if (!tempRootSet) {
                Object object3;
                String string;
                Object object4;
                Object object5;
                tempRootSet = true;
                object = AndroidUtils.getTempRoot();
                if (null != object) {
                    tempRootExec = tempRootNoexec = IOUtil.getSubTempDir((File)object, tmpSubDir, false, "Android.ctxTemp");
                    // MONITOREXIT : object2
                    return tempRootExec;
                }
                object = IOUtil.getFile(PropertyAccess.getProperty(java_io_tmpdir_propkey, false));
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX1 <" + object + ">, used " + (null != object));
                }
                if (!IOUtil.isStringSet((String)(object5 = System.getenv("TMPDIR")))) {
                    object5 = System.getenv("TEMP");
                }
                File file = null != (object4 = IOUtil.getFile((String)object5)) && !((File)object4).equals(object) ? object4 : null;
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX3 <" + object4 + ">, used " + (null != file));
                }
                object5 = IOUtil.getFile(PropertyAccess.getProperty(user_home_propkey, false));
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX4 <" + object5 + ">, used " + (null != object5));
                }
                if (IOUtil.getOSHasFreeDesktopXDG()) {
                    string = System.getenv(XDG_CACHE_HOME_envkey);
                    if (!IOUtil.isStringSet(string) && null != object5) {
                        string = ((File)object5).getAbsolutePath() + File.separator + ".cache";
                    }
                } else {
                    string = null;
                }
                object4 = null != (object3 = IOUtil.getFile(string)) && !((File)object3).equals(object) ? object3 : null;
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX2 <" + object3 + ">, used " + (null != object4));
                }
                if (null == tempRootExec && null != object) {
                    tempRootExec = Platform.OSType.MACOS == PlatformPropsImpl.OS_TYPE ? IOUtil.getSubTempDir((File)object, tmpSubDir, false, "tempX1") : IOUtil.getSubTempDir((File)object, tmpSubDir, true, "tempX1");
                }
                if (null == tempRootExec && null != object4) {
                    tempRootExec = IOUtil.getSubTempDir((File)object4, tmpSubDir, true, "tempX2");
                }
                if (null == tempRootExec && null != file) {
                    tempRootExec = IOUtil.getSubTempDir(file, tmpSubDir, true, "tempX3");
                }
                if (null == tempRootExec && null != object5) {
                    tempRootExec = IOUtil.getSubTempDir((File)object5, ".jogamp", true, "tempX4");
                }
                if (null != tempRootExec) {
                    tempRootNoexec = tempRootExec;
                } else {
                    if (null == tempRootNoexec && null != object) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object, tmpSubDir, false, "temp01");
                    }
                    if (null == tempRootNoexec && null != object4) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object4, tmpSubDir, false, "temp02");
                    }
                    if (null == tempRootNoexec && null != file) {
                        tempRootNoexec = IOUtil.getSubTempDir(file, tmpSubDir, false, "temp03");
                    }
                    if (null == tempRootNoexec && null != object5) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object5, ".jogamp", false, "temp04");
                    }
                }
                if (DEBUG) {
                    string = null != tempRootExec ? tempRootExec.getAbsolutePath() : null;
                    object3 = null != tempRootNoexec ? tempRootNoexec.getAbsolutePath() : null;
                    System.err.println("IOUtil.getTempRoot(): temp dirs: exec: " + string + ", noexec: " + (String)object3);
                }
            }
            // MONITOREXIT : object2
        }
        Object object6 = object2 = bl ? tempRootExec : tempRootNoexec;
        if (null != object2) {
            object = new FilePermission(((File)object2).getAbsolutePath(), "read,write,delete");
            SecurityUtil.checkPermission((Permission)object);
            return object2;
        }
        object = bl ? "executable " : "";
        throw new IOException("Could not determine a temporary " + (String)object + "directory");
    }

    public static File createTempFile(String string, String string2, boolean bl) throws IllegalArgumentException, IOException, SecurityException {
        return File.createTempFile(string, string2, IOUtil.getTempDir(bl));
    }

    public static void close(Closeable closeable, boolean bl) throws RuntimeException {
        block4: {
            if (null != closeable) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (bl) {
                        throw new RuntimeException(iOException);
                    }
                    if (!DEBUG) break block4;
                    System.err.println("Caught Exception: ");
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static IOException close(Closeable closeable, IOException[] iOExceptionArray, PrintStream printStream) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            if (null == iOExceptionArray[0]) {
                iOExceptionArray[0] = iOException;
            }
            if (null != printStream) {
                printStream.println("Caught " + iOException.getClass().getSimpleName() + ": " + iOException.getMessage());
                iOException.printStackTrace(printStream);
            }
            return iOException;
        }
        return null;
    }

    public static class StreamMonitor
    implements Runnable {
        private final InputStream[] istreams;
        private final PrintStream ostream;
        private final String prefix;

        public StreamMonitor(InputStream[] inputStreamArray, PrintStream printStream, String string) {
            this.istreams = inputStreamArray;
            this.ostream = printStream;
            this.prefix = string;
            new Thread((Runnable)this, "StreamMonitor-" + Thread.currentThread().getName()).start();
        }

        @Override
        public void run() {
            byte[] byArray = new byte[4096];
            try {
                int n;
                do {
                    n = 0;
                    for (int i = 0; i < this.istreams.length; ++i) {
                        int n2 = this.istreams[i].read(byArray);
                        if (n2 <= 0) continue;
                        if (null != this.ostream) {
                            if (null != this.prefix) {
                                this.ostream.write(this.prefix.getBytes());
                            }
                            this.ostream.write(byArray, 0, n2);
                        }
                        n += n2;
                    }
                    if (null == this.ostream) continue;
                    this.ostream.flush();
                } while (n >= 0);
            }
            catch (IOException iOException) {
                for (int i = 0; i < this.istreams.length; ++i) {
                    try {
                        this.istreams[i].close();
                        continue;
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static class ClassResources {
        public final Class<?> contextCL;
        public final String[] resourcePaths;

        public final int resourceCount() {
            return this.resourcePaths.length;
        }

        public ClassResources(Class<?> clazz, String[] stringArray) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (null != stringArray[i]) continue;
                throw new IllegalArgumentException("resourcePath[" + i + "] is null");
            }
            this.contextCL = clazz;
            this.resourcePaths = stringArray;
        }

        public URLConnection resolve(int n) throws ArrayIndexOutOfBoundsException {
            return IOUtil.getResource(this.contextCL, this.resourcePaths[n]);
        }
    }
}

