/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.jvm.JNILibLoaderBase;
import com.jogamp.common.os.DynamicLibraryBundleInfo;
import com.jogamp.common.os.DynamicLinker;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.util.RunnableExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class DynamicLibraryBundle
implements DynamicLookupHelper {
    private final DynamicLibraryBundleInfo info;
    protected final List<NativeLibrary> nativeLibraries;
    private final DynamicLinker dynLinkGlobal;
    private final List<List<String>> toolLibNames;
    private final List<String> glueLibNames;
    private final boolean[] toolLibLoaded;
    private int toolLibLoadedNumber;
    private final boolean[] glueLibLoaded;
    private int glueLibLoadedNumber;
    private long toolGetProcAddressHandle;
    private boolean toolGetProcAddressComplete;
    private HashSet<String> toolGetProcAddressFuncNameSet;
    private final List<String> toolGetProcAddressFuncNameList;

    public static RunnableExecutor getDefaultRunnableExecutor() {
        return RunnableExecutor.currentThreadExecutor;
    }

    public DynamicLibraryBundle(DynamicLibraryBundleInfo dynamicLibraryBundleInfo) {
        int n;
        if (null == dynamicLibraryBundleInfo) {
            throw new RuntimeException("Null DynamicLibraryBundleInfo");
        }
        this.info = dynamicLibraryBundleInfo;
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - DynamicLibraryBundle.init start with: " + dynamicLibraryBundleInfo.getClass().getName());
        }
        this.nativeLibraries = new ArrayList<NativeLibrary>();
        this.toolLibNames = dynamicLibraryBundleInfo.getToolLibNames();
        this.glueLibNames = dynamicLibraryBundleInfo.getGlueLibNames();
        this.toolLibLoaded = new boolean[this.toolLibNames.size()];
        if (DEBUG) {
            if (this.toolLibNames.size() == 0) {
                System.err.println("No Tool native library names given");
            }
            if (this.glueLibNames.size() == 0) {
                System.err.println("No Glue native library names given");
            }
        }
        for (n = this.toolLibNames.size() - 1; n >= 0; --n) {
            this.toolLibLoaded[n] = false;
        }
        this.glueLibLoaded = new boolean[this.glueLibNames.size()];
        for (n = this.glueLibNames.size() - 1; n >= 0; --n) {
            this.glueLibLoaded[n] = false;
        }
        final DynamicLinker[] dynamicLinkerArray = new DynamicLinker[]{null};
        dynamicLibraryBundleInfo.getLibLoaderExecutor().invoke(true, new Runnable(){

            @Override
            public void run() {
                dynamicLinkerArray[0] = DynamicLibraryBundle.this.loadLibraries();
            }
        });
        this.dynLinkGlobal = dynamicLinkerArray[0];
        this.toolGetProcAddressFuncNameList = dynamicLibraryBundleInfo.getToolGetProcAddressFuncNameList();
        if (null != this.toolGetProcAddressFuncNameList) {
            this.toolGetProcAddressFuncNameSet = new HashSet<String>(this.toolGetProcAddressFuncNameList);
            this.toolGetProcAddressHandle = this.getToolGetProcAddressHandle();
            this.toolGetProcAddressComplete = 0L != this.toolGetProcAddressHandle;
        } else {
            this.toolGetProcAddressFuncNameSet = new HashSet();
            this.toolGetProcAddressHandle = 0L;
            this.toolGetProcAddressComplete = true;
        }
        if (DEBUG) {
            System.err.println("DynamicLibraryBundle.init Summary: " + dynamicLibraryBundleInfo.getClass().getName());
            System.err.println("     toolGetProcAddressFuncNameList: " + this.toolGetProcAddressFuncNameList + ", complete: " + this.toolGetProcAddressComplete + ", 0x" + Long.toHexString(this.toolGetProcAddressHandle));
            System.err.println("     Tool Lib Names : " + this.toolLibNames);
            System.err.println("     Tool Lib Loaded: " + this.getToolLibLoadedNumber() + "/" + this.getToolLibNumber() + " " + Arrays.toString(this.toolLibLoaded) + ", complete " + this.isToolLibComplete());
            System.err.println("     Glue Lib Names : " + this.glueLibNames);
            System.err.println("     Glue Lib Loaded: " + this.getGlueLibLoadedNumber() + "/" + this.getGlueLibNumber() + " " + Arrays.toString(this.glueLibLoaded) + ", complete " + this.isGlueLibComplete());
            System.err.println("     All Complete: " + this.isLibComplete());
            System.err.println("     LibLoaderExecutor: " + dynamicLibraryBundleInfo.getLibLoaderExecutor().getClass().getName());
        }
    }

    public final void destroy() {
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - DynamicLibraryBundle.destroy() START: " + this.info.getClass().getName());
        }
        this.toolGetProcAddressFuncNameSet = null;
        this.toolGetProcAddressHandle = 0L;
        this.toolGetProcAddressComplete = false;
        for (int i = 0; i < this.nativeLibraries.size(); ++i) {
            this.nativeLibraries.get(i).close();
        }
        this.nativeLibraries.clear();
        this.toolLibNames.clear();
        this.glueLibNames.clear();
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - DynamicLibraryBundle.destroy() END: " + this.info.getClass().getName());
        }
    }

    public final boolean isLibComplete() {
        return this.isToolLibComplete() && this.isGlueLibComplete();
    }

    public final int getToolLibNumber() {
        return this.toolLibNames.size();
    }

    public final int getToolLibLoadedNumber() {
        return this.toolLibLoadedNumber;
    }

    public final boolean isToolLibComplete() {
        return this.toolGetProcAddressComplete && null != this.dynLinkGlobal && this.getToolLibNumber() == this.getToolLibLoadedNumber();
    }

    public final boolean isToolLibLoaded() {
        return 0 < this.toolLibLoadedNumber;
    }

    public final boolean isToolLibLoaded(int n) {
        if (0 <= n && n < this.toolLibLoaded.length) {
            return this.toolLibLoaded[n];
        }
        return false;
    }

    public final int getGlueLibNumber() {
        return this.glueLibNames.size();
    }

    public final int getGlueLibLoadedNumber() {
        return this.glueLibLoadedNumber;
    }

    public final boolean isGlueLibComplete() {
        return 0 == this.getGlueLibNumber() || this.isGlueLibLoaded(this.getGlueLibNumber() - 1);
    }

    public final boolean isGlueLibLoaded(int n) {
        if (0 <= n && n < this.glueLibLoaded.length) {
            return this.glueLibLoaded[n];
        }
        return false;
    }

    public final DynamicLibraryBundleInfo getBundleInfo() {
        return this.info;
    }

    protected final long getToolGetProcAddressHandle() throws SecurityException {
        if (!this.isToolLibLoaded()) {
            return 0L;
        }
        long l = 0L;
        for (int i = 0; i < this.toolGetProcAddressFuncNameList.size(); ++i) {
            String string = this.toolGetProcAddressFuncNameList.get(i);
            l = this.dynamicLookupFunctionOnLibs(string);
            if (!DEBUG) continue;
            System.err.println("getToolGetProcAddressHandle: " + string + " -> 0x" + Long.toHexString(l));
        }
        return l;
    }

    protected static final NativeLibrary loadFirstAvailable(List<String> list, ClassLoader classLoader, boolean bl) throws SecurityException {
        for (int i = 0; i < list.size(); ++i) {
            NativeLibrary nativeLibrary = NativeLibrary.open(list.get(i), classLoader, bl);
            if (nativeLibrary == null) continue;
            return nativeLibrary;
        }
        return null;
    }

    final DynamicLinker loadLibraries() throws SecurityException {
        List<String> list;
        int n;
        this.toolLibLoadedNumber = 0;
        ClassLoader classLoader = this.info.getClass().getClassLoader();
        NativeLibrary nativeLibrary = null;
        DynamicLinker dynamicLinker = null;
        for (n = 0; n < this.toolLibNames.size(); ++n) {
            list = this.toolLibNames.get(n);
            if (null == list || list.size() <= 0) continue;
            nativeLibrary = DynamicLibraryBundle.loadFirstAvailable(list, classLoader, this.info.shallLinkGlobal());
            if (null == nativeLibrary) {
                if (!DEBUG) continue;
                System.err.println("Unable to load any Tool library of: " + list);
                continue;
            }
            if (null == dynamicLinker) {
                dynamicLinker = nativeLibrary.getDynamicLinker();
            }
            this.nativeLibraries.add(nativeLibrary);
            this.toolLibLoaded[n] = true;
            ++this.toolLibLoadedNumber;
            if (!DEBUG) continue;
            System.err.println("Loaded Tool library: " + nativeLibrary);
        }
        if (this.toolLibNames.size() > 0 && !this.isToolLibLoaded()) {
            if (DEBUG) {
                System.err.println("No Tool libraries loaded");
            }
            return dynamicLinker;
        }
        this.glueLibLoadedNumber = 0;
        for (n = 0; n < this.glueLibNames.size(); ++n) {
            boolean bl;
            block9: {
                list = this.glueLibNames.get(n);
                try {
                    bl = GlueJNILibLoader.loadLibrary((String)((Object)list), true, classLoader);
                    if (DEBUG && !bl) {
                        System.err.println("Info: Could not load JNI/Glue library: " + (String)((Object)list));
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    bl = false;
                    if (!DEBUG) break block9;
                    System.err.println("Unable to load JNI/Glue library: " + (String)((Object)list));
                    unsatisfiedLinkError.printStackTrace();
                }
            }
            this.glueLibLoaded[n] = bl;
            if (!bl) continue;
            ++this.glueLibLoadedNumber;
        }
        return dynamicLinker;
    }

    private final long dynamicLookupFunctionOnLibs(String string) throws SecurityException {
        if (!this.isToolLibLoaded() || null == string) {
            if (DEBUG_LOOKUP && !this.isToolLibLoaded()) {
                System.err.println("Lookup-Native: <" + string + "> ** FAILED ** Tool native library not loaded");
            }
            return 0L;
        }
        long l = 0L;
        NativeLibrary nativeLibrary = null;
        if (this.info.shallLookupGlobal()) {
            l = this.dynLinkGlobal.lookupSymbolGlobal(string);
        }
        for (int i = 0; 0L == l && i < this.nativeLibraries.size(); ++i) {
            nativeLibrary = this.nativeLibraries.get(i);
            l = nativeLibrary.dynamicLookupFunction(string);
        }
        if (DEBUG_LOOKUP) {
            String string2;
            String string3 = string2 = null == nativeLibrary ? "GLOBAL" : nativeLibrary.toString();
            if (0L != l) {
                System.err.println("Lookup-Native: <" + string + "> 0x" + Long.toHexString(l) + " in lib " + string2);
            } else {
                System.err.println("Lookup-Native: <" + string + "> ** FAILED ** in libs " + this.nativeLibraries);
            }
        }
        return l;
    }

    private final long toolDynamicLookupFunction(String string) {
        if (0L != this.toolGetProcAddressHandle) {
            long l = this.info.toolGetProcAddress(this.toolGetProcAddressHandle, string);
            if (DEBUG_LOOKUP && 0L != l) {
                System.err.println("Lookup-Tool: <" + string + "> 0x" + Long.toHexString(l));
            }
            return l;
        }
        return 0L;
    }

    @Override
    public final void claimAllLinkPermission() throws SecurityException {
        for (int i = 0; i < this.nativeLibraries.size(); ++i) {
            this.nativeLibraries.get(i).claimAllLinkPermission();
        }
    }

    @Override
    public final void releaseAllLinkPermission() throws SecurityException {
        for (int i = 0; i < this.nativeLibraries.size(); ++i) {
            this.nativeLibraries.get(i).releaseAllLinkPermission();
        }
    }

    @Override
    public final long dynamicLookupFunction(String string) throws SecurityException {
        if (!this.isToolLibLoaded() || null == string) {
            if (DEBUG_LOOKUP && !this.isToolLibLoaded()) {
                System.err.println("Lookup: <" + string + "> ** FAILED ** Tool native library not loaded");
            }
            return 0L;
        }
        if (this.toolGetProcAddressFuncNameSet.contains(string)) {
            return this.toolGetProcAddressHandle;
        }
        long l = 0L;
        boolean bl = this.info.useToolGetProcAdressFirst(string);
        if (bl) {
            l = this.toolDynamicLookupFunction(string);
        }
        if (0L == l) {
            l = this.dynamicLookupFunctionOnLibs(string);
        }
        if (0L == l && !bl) {
            l = this.toolDynamicLookupFunction(string);
        }
        return l;
    }

    @Override
    public final boolean isFunctionAvailable(String string) throws SecurityException {
        return 0L != this.dynamicLookupFunction(string);
    }

    static final class GlueJNILibLoader
    extends JNILibLoaderBase {
        GlueJNILibLoader() {
        }

        protected static synchronized boolean loadLibrary(String string, boolean bl, ClassLoader classLoader) {
            return JNILibLoaderBase.loadLibrary(string, bl, classLoader);
        }
    }
}

