/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

public final class HashtableOfObjectToInt
implements Cloneable {
    public Object[] keyTable;
    public int[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfObjectToInt() {
        this(13);
    }

    public HashtableOfObjectToInt(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new Object[n2];
        this.valueTable = new int[n2];
    }

    public Object clone() throws CloneNotSupportedException {
        HashtableOfObjectToInt hashtableOfObjectToInt = (HashtableOfObjectToInt)super.clone();
        hashtableOfObjectToInt.elementSize = this.elementSize;
        hashtableOfObjectToInt.threshold = this.threshold;
        int n = this.keyTable.length;
        hashtableOfObjectToInt.keyTable = new Object[n];
        System.arraycopy(this.keyTable, 0, hashtableOfObjectToInt.keyTable, 0, n);
        n = this.valueTable.length;
        hashtableOfObjectToInt.valueTable = new int[n];
        System.arraycopy(this.valueTable, 0, hashtableOfObjectToInt.valueTable, 0, n);
        return hashtableOfObjectToInt;
    }

    public boolean containsKey(Object object) {
        Object object2;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.keyTable[n2]) != null) {
            if (object2.equals(object)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    public int get(Object object) {
        Object object2;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.keyTable[n2]) != null) {
            if (object2.equals(object)) {
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return -1;
    }

    public void keysToArray(Object[] objectArray) {
        int n = 0;
        int n2 = 0;
        int n3 = this.keyTable.length;
        while (n2 < n3) {
            if (this.keyTable[n2] != null) {
                objectArray[n++] = this.keyTable[n2];
            }
            ++n2;
        }
    }

    public int put(Object object, int n) {
        Object object2;
        int n2 = this.keyTable.length;
        int n3 = (object.hashCode() & Integer.MAX_VALUE) % n2;
        while ((object2 = this.keyTable[n3]) != null) {
            if (object2.equals(object)) {
                this.valueTable[n3] = n;
                return this.valueTable[n3];
            }
            if (++n3 != n2) continue;
            n3 = 0;
        }
        this.keyTable[n3] = object;
        this.valueTable[n3] = n;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return n;
    }

    public int removeKey(Object object) {
        Object object2;
        int n = this.keyTable.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.keyTable[n2]) != null) {
            if (object2.equals(object)) {
                int n3 = this.valueTable[n2];
                --this.elementSize;
                this.keyTable[n2] = null;
                this.rehash();
                return n3;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return -1;
    }

    private void rehash() {
        HashtableOfObjectToInt hashtableOfObjectToInt = new HashtableOfObjectToInt(this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            Object object = this.keyTable[n];
            if (object == null) continue;
            hashtableOfObjectToInt.put(object, this.valueTable[n]);
        }
        this.keyTable = hashtableOfObjectToInt.keyTable;
        this.valueTable = hashtableOfObjectToInt.valueTable;
        this.threshold = hashtableOfObjectToInt.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        int n = 0;
        int n2 = this.keyTable.length;
        while (n < n2) {
            Object object = this.keyTable[n];
            if (object != null) {
                string = String.valueOf(string) + object + " -> " + this.valueTable[n] + "\n";
            }
            ++n;
        }
        return string;
    }
}

