/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredAnnotation;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;

public class RecoveredField
extends RecoveredElement {
    public FieldDeclaration fieldDeclaration;
    boolean alreadyCompletedFieldInitialization;
    public RecoveredAnnotation[] annotations;
    public int annotationCount;
    public int modifiers;
    public int modifiersStart;
    public RecoveredType[] anonymousTypes;
    public int anonymousTypeCount;

    public RecoveredField(FieldDeclaration fieldDeclaration, RecoveredElement recoveredElement, int n) {
        this(fieldDeclaration, recoveredElement, n, null);
    }

    public RecoveredField(FieldDeclaration fieldDeclaration, RecoveredElement recoveredElement, int n, Parser parser) {
        super(recoveredElement, n, parser);
        this.fieldDeclaration = fieldDeclaration;
        this.alreadyCompletedFieldInitialization = fieldDeclaration.initialization != null;
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n) {
        this.resetPendingModifiers();
        if (this.parent == null) {
            return this;
        }
        if (this.fieldDeclaration.declarationSourceStart == fieldDeclaration.declarationSourceStart) {
            if (this.fieldDeclaration.initialization != null) {
                this.updateSourceEndIfNecessary(this.fieldDeclaration.initialization.sourceEnd);
            } else {
                this.updateSourceEndIfNecessary(this.fieldDeclaration.sourceEnd);
            }
        } else {
            this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(fieldDeclaration.declarationSourceStart - 1));
        }
        return this.parent.add(fieldDeclaration, n);
    }

    public RecoveredElement add(Statement statement, int n) {
        if (this.alreadyCompletedFieldInitialization || !(statement instanceof Expression)) {
            return super.add(statement, n);
        }
        if (statement.sourceEnd > 0) {
            this.alreadyCompletedFieldInitialization = true;
        }
        this.fieldDeclaration.initialization = (Expression)statement;
        this.fieldDeclaration.declarationSourceEnd = statement.sourceEnd;
        this.fieldDeclaration.declarationEnd = statement.sourceEnd;
        return this;
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n) {
        if (this.alreadyCompletedFieldInitialization || (typeDeclaration.bits & 0x200) == 0 || this.fieldDeclaration.declarationSourceEnd != 0 && typeDeclaration.sourceStart > this.fieldDeclaration.declarationSourceEnd) {
            return super.add(typeDeclaration, n);
        }
        if (this.anonymousTypes == null) {
            this.anonymousTypes = new RecoveredType[5];
            this.anonymousTypeCount = 0;
        } else if (this.anonymousTypeCount == this.anonymousTypes.length) {
            this.anonymousTypes = new RecoveredType[2 * this.anonymousTypeCount];
            System.arraycopy(this.anonymousTypes, 0, this.anonymousTypes, 0, this.anonymousTypeCount);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n);
        this.anonymousTypes[this.anonymousTypeCount++] = recoveredType;
        return recoveredType;
    }

    public void attach(RecoveredAnnotation[] recoveredAnnotationArray, int n, int n2, int n3) {
        if (n > 0) {
            Annotation[] annotationArray = this.fieldDeclaration.annotations;
            if (annotationArray != null) {
                this.annotations = new RecoveredAnnotation[n];
                this.annotationCount = 0;
                int n4 = 0;
                while (n4 < n) {
                    block7: {
                        int n5 = 0;
                        while (n5 < annotationArray.length) {
                            if (recoveredAnnotationArray[n4].annotation != annotationArray[n5]) {
                                ++n5;
                                continue;
                            }
                            break block7;
                        }
                        this.annotations[this.annotationCount++] = recoveredAnnotationArray[n4];
                    }
                    ++n4;
                }
            } else {
                this.annotations = recoveredAnnotationArray;
                this.annotationCount = n;
            }
        }
        if (n2 != 0) {
            this.modifiers = n2;
            this.modifiersStart = n3;
        }
    }

    public ASTNode parseTree() {
        return this.fieldDeclaration;
    }

    public int sourceEnd() {
        return this.fieldDeclaration.declarationSourceEnd;
    }

    public String toString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n));
        stringBuffer.append("Recovered field:\n");
        this.fieldDeclaration.print(n + 1, stringBuffer);
        if (this.annotations != null) {
            n2 = 0;
            while (n2 < this.annotationCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.annotations[n2].toString(n + 1));
                ++n2;
            }
        }
        if (this.anonymousTypes != null) {
            n2 = 0;
            while (n2 < this.anonymousTypeCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.anonymousTypes[n2].toString(n + 1));
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public FieldDeclaration updatedFieldDeclaration(int n, Set set) {
        int n2;
        Object object;
        int n3;
        if (this.modifiers != 0) {
            this.fieldDeclaration.modifiers |= this.modifiers;
            if (this.modifiersStart < this.fieldDeclaration.declarationSourceStart) {
                this.fieldDeclaration.declarationSourceStart = this.modifiersStart;
            }
        }
        if (this.annotationCount > 0) {
            n3 = this.fieldDeclaration.annotations == null ? 0 : this.fieldDeclaration.annotations.length;
            object = new Annotation[n3 + this.annotationCount];
            if (n3 > 0) {
                System.arraycopy(this.fieldDeclaration.annotations, 0, object, this.annotationCount, n3);
            }
            n2 = 0;
            while (n2 < this.annotationCount) {
                object[n2] = this.annotations[n2].updatedAnnotationReference();
                ++n2;
            }
            this.fieldDeclaration.annotations = object;
            n2 = this.annotations[0].annotation.sourceStart;
            if (n2 < this.fieldDeclaration.declarationSourceStart) {
                this.fieldDeclaration.declarationSourceStart = n2;
            }
        }
        if (this.anonymousTypes != null) {
            if (this.fieldDeclaration.initialization == null) {
                ArrayInitializer arrayInitializer = null;
                int n4 = 0;
                if (this.anonymousTypeCount > 1) {
                    arrayInitializer = new ArrayInitializer();
                    arrayInitializer.expressions = new Expression[this.anonymousTypeCount];
                }
                n2 = 0;
                while (n2 < this.anonymousTypeCount) {
                    TypeDeclaration typeDeclaration;
                    RecoveredType recoveredType = this.anonymousTypes[n2];
                    TypeDeclaration typeDeclaration2 = recoveredType.typeDeclaration;
                    if (typeDeclaration2.declarationSourceEnd == 0) {
                        typeDeclaration2.declarationSourceEnd = this.fieldDeclaration.declarationSourceEnd;
                        typeDeclaration2.bodyEnd = this.fieldDeclaration.declarationSourceEnd;
                    }
                    if (recoveredType.preserveContent && (typeDeclaration = recoveredType.updatedTypeDeclaration(n + 1, set)) != null) {
                        if (this.anonymousTypeCount > 1) {
                            if (n4 == 0) {
                                this.fieldDeclaration.initialization = arrayInitializer;
                            }
                            arrayInitializer.expressions[n4++] = typeDeclaration.allocation;
                        } else {
                            this.fieldDeclaration.initialization = typeDeclaration.allocation;
                        }
                        int n5 = typeDeclaration.declarationSourceEnd;
                        if (n5 > this.fieldDeclaration.declarationSourceEnd) {
                            this.fieldDeclaration.declarationSourceEnd = n5;
                            this.fieldDeclaration.declarationEnd = n5;
                        }
                    }
                    ++n2;
                }
                if (this.anonymousTypeCount > 0) {
                    this.fieldDeclaration.bits |= 2;
                }
            } else if (this.fieldDeclaration.getKind() == 3) {
                n3 = 0;
                while (n3 < this.anonymousTypeCount) {
                    object = this.anonymousTypes[n3];
                    TypeDeclaration typeDeclaration = ((RecoveredType)object).typeDeclaration;
                    if (typeDeclaration.declarationSourceEnd == 0) {
                        typeDeclaration.declarationSourceEnd = this.fieldDeclaration.declarationSourceEnd;
                        typeDeclaration.bodyEnd = this.fieldDeclaration.declarationSourceEnd;
                    }
                    ((RecoveredType)object).updatedTypeDeclaration(n, set);
                    ++n3;
                }
            }
        }
        return this.fieldDeclaration;
    }

    public RecoveredElement updateOnClosingBrace(int n, int n2) {
        if (this.bracketBalance > 0) {
            --this.bracketBalance;
            if (this.bracketBalance == 0) {
                if (this.fieldDeclaration.getKind() == 3) {
                    this.updateSourceEndIfNecessary(n2 - 1);
                    return this.parent;
                }
                if (this.fieldDeclaration.declarationSourceEnd > 0) {
                    this.alreadyCompletedFieldInitialization = true;
                }
            }
            return this;
        }
        if (this.bracketBalance == 0) {
            this.alreadyCompletedFieldInitialization = true;
            this.updateSourceEndIfNecessary(n2 - 1);
        }
        if (this.parent != null) {
            return this.parent.updateOnClosingBrace(n, n2);
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int n, int n2) {
        if (this.fieldDeclaration.declarationSourceEnd == 0) {
            if (this.fieldDeclaration.type instanceof ArrayTypeReference || this.fieldDeclaration.type instanceof ArrayQualifiedTypeReference) {
                if (!this.alreadyCompletedFieldInitialization) {
                    ++this.bracketBalance;
                    return null;
                }
            } else {
                ++this.bracketBalance;
                return null;
            }
        }
        if (this.fieldDeclaration.declarationSourceEnd == 0 && this.fieldDeclaration.getKind() == 3) {
            ++this.bracketBalance;
            return null;
        }
        this.updateSourceEndIfNecessary(n - 1, n2 - 1);
        return this.parent.updateOnOpeningBrace(n, n2);
    }

    public void updateParseTree() {
        this.updatedFieldDeclaration(0, new HashSet());
    }

    public void updateSourceEndIfNecessary(int n, int n2) {
        if (this.fieldDeclaration.declarationSourceEnd == 0) {
            this.fieldDeclaration.declarationSourceEnd = n2;
            this.fieldDeclaration.declarationEnd = n2;
        }
    }
}

