/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;

public class SignatureWrapper {
    public char[] signature;
    public int start;
    public int end;
    public int bracket;
    private boolean use15specifics;

    public SignatureWrapper(char[] cArray, boolean bl) {
        this.signature = cArray;
        this.start = 0;
        this.bracket = -1;
        this.end = -1;
        this.use15specifics = bl;
    }

    public SignatureWrapper(char[] cArray) {
        this(cArray, true);
    }

    public boolean atEnd() {
        return this.start < 0 || this.start >= this.signature.length;
    }

    public int computeEnd() {
        int n = this.start;
        while (this.signature[n] == '[') {
            ++n;
        }
        switch (this.signature[n]) {
            case 'L': 
            case 'T': {
                this.end = CharOperation.indexOf(';', this.signature, this.start);
                if (this.bracket <= this.start) {
                    this.bracket = CharOperation.indexOf('<', this.signature, this.start);
                }
                if (this.bracket > this.start && this.bracket < this.end) {
                    this.end = this.bracket;
                    break;
                }
                if (this.end != -1) break;
                this.end = this.signature.length + 1;
                break;
            }
            default: {
                this.end = this.start;
            }
        }
        if (this.use15specifics || this.end != this.bracket) {
            this.start = this.end + 1;
        } else {
            this.start = this.skipAngleContents(this.end) + 1;
            this.bracket = -1;
        }
        return this.end;
    }

    public int skipAngleContents(int n) {
        if (this.signature[n] != '<') {
            return n;
        }
        int n2 = 0;
        int n3 = this.signature.length;
        ++n;
        while (n < n3) {
            switch (this.signature[n]) {
                case '<': {
                    ++n2;
                    break;
                }
                case '>': {
                    if (--n2 >= 0) break;
                    return n + 1;
                }
            }
            ++n;
        }
        return n;
    }

    public char[] nextWord() {
        this.end = CharOperation.indexOf(';', this.signature, this.start);
        if (this.bracket <= this.start) {
            this.bracket = CharOperation.indexOf('<', this.signature, this.start);
        }
        int n = CharOperation.indexOf('.', this.signature, this.start);
        if (this.bracket > this.start && this.bracket < this.end) {
            this.end = this.bracket;
        }
        if (n > this.start && n < this.end) {
            this.end = n;
        }
        this.start = this.end;
        return CharOperation.subarray(this.signature, this.start, this.start);
    }

    public String toString() {
        return String.valueOf(new String(this.signature)) + " @ " + this.start;
    }
}

