/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionCastTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBindingVisitor;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedTypeBinding
extends ReferenceBinding
implements Substitution {
    private ReferenceBinding type;
    public TypeBinding[] arguments;
    public LookupEnvironment environment;
    public char[] genericTypeSignature;
    public ReferenceBinding superclass;
    public ReferenceBinding[] superInterfaces;
    public FieldBinding[] fields;
    public ReferenceBinding[] memberTypes;
    public MethodBinding[] methods;
    private ReferenceBinding enclosingType;

    public ParameterizedTypeBinding(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, LookupEnvironment lookupEnvironment) {
        this.environment = lookupEnvironment;
        this.enclosingType = referenceBinding2;
        this.initialize(referenceBinding, typeBindingArray);
        if (referenceBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)referenceBinding).addWrapper(this, lookupEnvironment);
        }
        if (typeBindingArray != null) {
            int n = 0;
            int n2 = typeBindingArray.length;
            while (n < n2) {
                if (typeBindingArray[n] instanceof UnresolvedReferenceBinding) {
                    ((UnresolvedReferenceBinding)typeBindingArray[n]).addWrapper(this, lookupEnvironment);
                }
                if (typeBindingArray[n].hasNullTypeAnnotations()) {
                    this.tagBits |= 0x100000L;
                }
                ++n;
            }
        }
        if (referenceBinding2 != null && referenceBinding2.hasNullTypeAnnotations()) {
            this.tagBits |= 0x100000L;
        }
        this.tagBits |= 0x1000000L;
    }

    @Override
    public ReferenceBinding actualType() {
        return this.type;
    }

    @Override
    public boolean isParameterizedType() {
        return true;
    }

    public void boundCheck(Scope scope, TypeReference[] typeReferenceArray) {
        if ((this.tagBits & 0x400000L) == 0L) {
            boolean bl = false;
            TypeVariableBinding[] typeVariableBindingArray = this.type.typeVariables();
            if (this.arguments != null && typeVariableBindingArray != null) {
                int n = 0;
                int n2 = typeVariableBindingArray.length;
                while (n < n2) {
                    if (typeVariableBindingArray[n].boundCheck(this, this.arguments[n], scope) != 0) {
                        bl = true;
                        if ((this.arguments[n].tagBits & 0x80L) == 0L) {
                            scope.problemReporter().typeMismatchError(this.arguments[n], typeVariableBindingArray[n], this.type, (ASTNode)typeReferenceArray[n]);
                        }
                    }
                    ++n;
                }
            }
            if (!bl) {
                this.tagBits |= 0x400000L;
            }
        }
    }

    @Override
    public boolean canBeInstantiated() {
        return (this.tagBits & 0x40000000L) == 0L && super.canBeInstantiated();
    }

    @Override
    public TypeBinding capture(Scope scope, int n) {
        TypeBinding typeBinding;
        if ((this.tagBits & 0x40000000L) == 0L) {
            return this;
        }
        TypeBinding[] typeBindingArray = this.arguments;
        int n2 = typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = new TypeBinding[n2];
        ReferenceBinding referenceBinding = scope.enclosingSourceType();
        if (referenceBinding != null) {
            referenceBinding = referenceBinding.outermostEnclosingType();
        }
        int n3 = 0;
        while (n3 < n2) {
            TypeBinding typeBinding2 = typeBindingArray[n3];
            if (typeBinding2.kind() == 516) {
                typeBinding = (WildcardBinding)typeBinding2;
                typeBindingArray2[n3] = ((WildcardBinding)typeBinding).boundKind == 2 && ((WildcardBinding)typeBinding).bound.id == 1 ? ((WildcardBinding)typeBinding).bound : new CaptureBinding((WildcardBinding)typeBinding, referenceBinding, n, scope.compilationUnitScope().nextCaptureID());
            } else {
                typeBindingArray2[n3] = typeBinding2;
            }
            ++n3;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = this.environment.createParameterizedType(this.type, typeBindingArray2, this.enclosingType(), this.typeAnnotations);
        int n4 = 0;
        while (n4 < n2) {
            typeBinding = typeBindingArray2[n4];
            if (typeBinding.isCapture()) {
                ((CaptureBinding)typeBinding).initializeBounds(scope, parameterizedTypeBinding);
            }
            ++n4;
        }
        return parameterizedTypeBinding;
    }

    @Override
    public TypeBinding uncapture(Scope scope) {
        if ((this.tagBits & 0x2000000000000000L) == 0L) {
            return this;
        }
        int n = this.arguments == null ? 0 : this.arguments.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        int n2 = 0;
        while (n2 < n) {
            typeBindingArray[n2] = this.arguments[n2].uncapture(scope);
            ++n2;
        }
        return scope.environment().createParameterizedType(this.type, typeBindingArray, (ReferenceBinding)(this.enclosingType != null ? this.enclosingType.uncapture(scope) : null), this.typeAnnotations);
    }

    @Override
    public List collectMissingTypes(List list) {
        if ((this.tagBits & 0x80L) != 0L) {
            if (this.enclosingType != null) {
                list = this.enclosingType.collectMissingTypes(list);
            }
            list = this.genericType().collectMissingTypes(list);
            if (this.arguments != null) {
                int n = 0;
                int n2 = this.arguments.length;
                while (n < n2) {
                    list = this.arguments[n].collectMissingTypes(list);
                    ++n;
                }
            }
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void collectSubstitutes(Scope var1_1, TypeBinding var2_2, InferenceContext var3_3, int var4_4) {
        if ((this.tagBits & 0x20000000L) == 0L) {
            var5_5 = var2_2.findSuperTypeOriginatingFrom(this.type);
            if (var5_5 != null && var5_5.isRawType()) {
                var3_3.isUnchecked = true;
            }
            return;
        }
        if (var2_2 == TypeBinding.NULL || var2_2.kind() == 65540) {
            return;
        }
        if (!(var2_2 instanceof ReferenceBinding)) {
            return;
        }
        switch (var4_4) {
            case 0: 
            case 1: {
                var5_6 = this;
                var6_7 = var2_2.findSuperTypeOriginatingFrom(this.type);
                if (var6_7 != null) break;
                return;
            }
            default: {
                var5_6 = this.findSuperTypeOriginatingFrom(var2_2);
                if (var5_6 == null) {
                    return;
                }
                var6_7 = var2_2;
            }
        }
        if ((var7_8 = var5_6.enclosingType()) != null) {
            var7_8.collectSubstitutes(var1_1, var6_7.enclosingType(), var3_3, var4_4);
        }
        if (this.arguments == null) {
            return;
        }
        switch (var5_6.kind()) {
            case 2052: {
                var8_9 = var5_6.typeVariables();
                break;
            }
            case 260: {
                var8_9 = ((ParameterizedTypeBinding)var5_6).arguments;
                break;
            }
            case 1028: {
                if (var3_3.depth > 0) {
                    var3_3.status = 1;
                }
                return;
            }
            default: {
                return;
            }
        }
        switch (var6_7.kind()) {
            case 2052: {
                var9_10 = var6_7.typeVariables();
                break;
            }
            case 260: {
                var9_10 = ((ParameterizedTypeBinding)var6_7).arguments;
                break;
            }
            case 1028: {
                if (var3_3.depth > 0) {
                    var3_3.status = 1;
                } else {
                    var3_3.isUnchecked = true;
                }
                return;
            }
            default: {
                return;
            }
        }
        ++var3_3.depth;
        var10_11 = 0;
        var11_12 = var8_9.length;
        while (var10_11 < var11_12) {
            block32: {
                block31: {
                    var12_13 = var8_9[var10_11];
                    var13_14 = var9_10[var10_11];
                    if (!var12_13.isWildcard()) break block31;
                    var12_13.collectSubstitutes(var1_1, var13_14, var3_3, var4_4);
                    break block32;
                }
                if (!var13_14.isWildcard()) ** GOTO lbl-1000
                var14_15 = (WildcardBinding)var13_14;
                if (var14_15.otherBounds == null) {
                    if (var4_4 == 2) {
                        switch (var14_15.boundKind) {
                            case 1: {
                                var12_13.collectSubstitutes(var1_1, var14_15.bound, var3_3, 2);
                                break;
                            }
                            case 2: {
                                var12_13.collectSubstitutes(var1_1, var14_15.bound, var3_3, 1);
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else lbl-1000:
                // 2 sources

                {
                    var12_13.collectSubstitutes(var1_1, var13_14, var3_3, 0);
                }
            }
            ++var10_11;
        }
        --var3_3.depth;
    }

    @Override
    public void computeId() {
        this.id = Integer.MAX_VALUE;
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        char[] cArray;
        Object object;
        ReferenceBinding referenceBinding;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType() && ((referenceBinding = this.enclosingType()).isParameterizedType() || referenceBinding.isRawType())) {
            object = referenceBinding.computeUniqueKey(false);
            stringBuffer.append((char[])object, 0, ((Object)object).length - 1);
            stringBuffer.append('.').append(this.sourceName());
        } else if (this.type.isLocalType()) {
            ReferenceBinding referenceBinding2;
            object = (LocalTypeBinding)this.type;
            referenceBinding = ((NestedTypeBinding)object).enclosingType();
            while ((referenceBinding2 = referenceBinding.enclosingType()) != null) {
                referenceBinding = referenceBinding2;
            }
            cArray = referenceBinding.computeUniqueKey(false);
            stringBuffer.append(cArray, 0, cArray.length - 1);
            stringBuffer.append('$');
            stringBuffer.append(((LocalTypeBinding)object).sourceStart);
        } else {
            object = this.type.computeUniqueKey(false);
            stringBuffer.append((char[])object, 0, ((Object)object).length - 1);
        }
        object = null;
        if (this.arguments != null) {
            stringBuffer.append('<');
            int n = 0;
            int n2 = this.arguments.length;
            while (n < n2) {
                TypeBinding typeBinding = this.arguments[n];
                stringBuffer.append(typeBinding.computeUniqueKey(false));
                if (typeBinding instanceof CaptureBinding) {
                    object = ((CaptureBinding)typeBinding).sourceType;
                }
                ++n;
            }
            stringBuffer.append('>');
        }
        stringBuffer.append(';');
        if (object != null && TypeBinding.notEquals((TypeBinding)object, this.type)) {
            stringBuffer.insert(0, "&");
            stringBuffer.insert(0, ((ReferenceBinding)object).computeUniqueKey(false));
        }
        int n = stringBuffer.length();
        cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public char[] constantPoolName() {
        return this.type.constantPoolName();
    }

    @Override
    public TypeBinding clone(TypeBinding typeBinding) {
        return new ParameterizedTypeBinding(this.type, this.arguments, (ReferenceBinding)typeBinding, this.environment);
    }

    public ParameterizedMethodBinding createParameterizedMethod(MethodBinding methodBinding) {
        return new ParameterizedMethodBinding(this, methodBinding);
    }

    @Override
    public String debugName() {
        if (this.hasTypeAnnotations()) {
            return this.annotatedDebugName();
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.type instanceof UnresolvedReferenceBinding) {
            stringBuffer.append(this.type);
        } else {
            stringBuffer.append(this.type.sourceName());
        }
        if (this.arguments != null && this.arguments.length > 0) {
            stringBuffer.append('<');
            int n = 0;
            int n2 = this.arguments.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[n].debugName());
                ++n;
            }
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }

    @Override
    public String annotatedDebugName() {
        StringBuffer stringBuffer = new StringBuffer(super.annotatedDebugName());
        if (this.arguments != null && this.arguments.length > 0) {
            stringBuffer.append('<');
            int n = 0;
            int n2 = this.arguments.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[n].annotatedDebugName());
                ++n;
            }
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }

    @Override
    public ReferenceBinding enclosingType() {
        return this.enclosingType;
    }

    @Override
    public LookupEnvironment environment() {
        return this.environment;
    }

    @Override
    public TypeBinding erasure() {
        return this.type.erasure();
    }

    @Override
    public int fieldCount() {
        return this.type.fieldCount();
    }

    @Override
    public FieldBinding[] fields() {
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.fields;
        }
        try {
            FieldBinding[] fieldBindingArray = this.type.fields();
            int n = fieldBindingArray.length;
            FieldBinding[] fieldBindingArray2 = new FieldBinding[n];
            int n2 = 0;
            while (n2 < n) {
                fieldBindingArray2[n2] = new ParameterizedFieldBinding(this, fieldBindingArray[n2]);
                ++n2;
            }
            this.fields = fieldBindingArray2;
        }
        finally {
            if (this.fields == null) {
                this.fields = Binding.NO_FIELDS;
            }
            this.tagBits |= 0x2000L;
        }
        return this.fields;
    }

    public ReferenceBinding genericType() {
        if (this.type instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)this.type).resolve(this.environment, false);
        }
        return this.type;
    }

    @Override
    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            if ((this.modifiers & 0x40000000) == 0) {
                this.genericTypeSignature = this.type.signature();
            } else {
                Object object;
                StringBuffer stringBuffer = new StringBuffer(10);
                if (this.isMemberType()) {
                    object = this.enclosingType();
                    char[] cArray = ((TypeBinding)object).genericTypeSignature();
                    stringBuffer.append(cArray, 0, cArray.length - 1);
                    if ((((ReferenceBinding)object).modifiers & 0x40000000) != 0) {
                        stringBuffer.append('.');
                    } else {
                        stringBuffer.append('$');
                    }
                    stringBuffer.append(this.sourceName());
                } else {
                    object = this.type.signature();
                    stringBuffer.append((char[])object, 0, ((Object)object).length - 1);
                }
                if (this.arguments != null) {
                    stringBuffer.append('<');
                    int n = 0;
                    int n2 = this.arguments.length;
                    while (n < n2) {
                        stringBuffer.append(this.arguments[n].genericTypeSignature());
                        ++n;
                    }
                    stringBuffer.append('>');
                }
                stringBuffer.append(';');
                int n = stringBuffer.length();
                this.genericTypeSignature = new char[n];
                stringBuffer.getChars(0, n, this.genericTypeSignature, 0);
            }
        }
        return this.genericTypeSignature;
    }

    @Override
    public long getAnnotationTagBits() {
        return this.type.getAnnotationTagBits();
    }

    @Override
    public int getEnclosingInstancesSlotSize() {
        return this.genericType().getEnclosingInstancesSlotSize();
    }

    @Override
    public MethodBinding getExactConstructor(TypeBinding[] typeBindingArray) {
        MethodBinding methodBinding;
        block10: {
            int n;
            block9: {
                n = typeBindingArray.length;
                methodBinding = null;
                if ((this.tagBits & 0x8000L) == 0L) break block9;
                long l = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods);
                if (l < 0L) break block10;
                int n2 = (int)l;
                int n3 = (int)(l >> 32);
                while (n2 <= n3) {
                    block8: {
                        MethodBinding methodBinding2 = this.methods[n2];
                        if (methodBinding2.parameters.length == n) {
                            TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
                            int n4 = 0;
                            while (n4 < n) {
                                if (!TypeBinding.notEquals(typeBindingArray2[n4], typeBindingArray[n4])) {
                                    ++n4;
                                    continue;
                                }
                                break block8;
                            }
                            if (methodBinding != null) {
                                return null;
                            }
                            methodBinding = methodBinding2;
                        }
                    }
                    ++n2;
                }
                break block10;
            }
            MethodBinding[] methodBindingArray = this.getMethods(TypeConstants.INIT);
            int n5 = methodBindingArray.length;
            block2: while (--n5 >= 0) {
                MethodBinding methodBinding3 = methodBindingArray[n5];
                TypeBinding[] typeBindingArray3 = methodBinding3.parameters;
                if (typeBindingArray3.length != n) continue;
                int n6 = 0;
                while (n6 < n) {
                    if (TypeBinding.notEquals(typeBindingArray3[n6], typeBindingArray[n6])) continue block2;
                    ++n6;
                }
                if (methodBinding != null) {
                    return null;
                }
                methodBinding = methodBinding3;
            }
        }
        return methodBinding;
    }

    @Override
    public MethodBinding getExactMethod(char[] cArray, TypeBinding[] typeBindingArray, CompilationUnitScope compilationUnitScope) {
        int n = typeBindingArray.length;
        boolean bl = true;
        MethodBinding methodBinding = null;
        if ((this.tagBits & 0x8000L) != 0L) {
            long l = ReferenceBinding.binarySearch(cArray, this.methods);
            if (l >= 0L) {
                int n2 = (int)l;
                int n3 = (int)(l >> 32);
                while (n2 <= n3) {
                    block20: {
                        MethodBinding methodBinding2 = this.methods[n2];
                        bl = false;
                        if (methodBinding2.parameters.length == n) {
                            TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
                            int n4 = 0;
                            while (n4 < n) {
                                if (!TypeBinding.notEquals(typeBindingArray2[n4], typeBindingArray[n4])) {
                                    ++n4;
                                    continue;
                                }
                                break block20;
                            }
                            if (methodBinding != null) {
                                return null;
                            }
                            methodBinding = methodBinding2;
                        }
                    }
                    ++n2;
                }
            }
        } else {
            MethodBinding[] methodBindingArray = this.getMethods(cArray);
            bl = methodBindingArray == Binding.NO_METHODS;
            int n5 = methodBindingArray.length;
            block2: while (--n5 >= 0) {
                MethodBinding methodBinding3 = methodBindingArray[n5];
                TypeBinding[] typeBindingArray3 = methodBinding3.parameters;
                if (typeBindingArray3.length != n) continue;
                int n6 = 0;
                while (n6 < n) {
                    if (TypeBinding.notEquals(typeBindingArray3[n6], typeBindingArray[n6])) continue block2;
                    ++n6;
                }
                if (methodBinding != null) {
                    return null;
                }
                methodBinding = methodBinding3;
            }
        }
        if (methodBinding != null) {
            if (methodBinding.hasSubstitutedParameters()) {
                return null;
            }
            return methodBinding;
        }
        if (bl && (this.arguments == null || this.arguments.length <= 1)) {
            if (this.isInterface()) {
                if (this.superInterfaces().length == 1) {
                    if (compilationUnitScope != null) {
                        compilationUnitScope.recordTypeReference(this.superInterfaces[0]);
                    }
                    return this.superInterfaces[0].getExactMethod(cArray, typeBindingArray, compilationUnitScope);
                }
            } else if (this.superclass() != null) {
                if (compilationUnitScope != null) {
                    compilationUnitScope.recordTypeReference(this.superclass);
                }
                return this.superclass.getExactMethod(cArray, typeBindingArray, compilationUnitScope);
            }
        }
        return null;
    }

    @Override
    public FieldBinding getField(char[] cArray, boolean bl) {
        this.fields();
        return ReferenceBinding.binarySearch(cArray, this.fields);
    }

    @Override
    public ReferenceBinding getMemberType(char[] cArray) {
        this.memberTypes();
        int n = cArray.length;
        int n2 = this.memberTypes.length;
        while (--n2 >= 0) {
            ReferenceBinding referenceBinding = this.memberTypes[n2];
            if (referenceBinding.sourceName.length != n || !CharOperation.equals(referenceBinding.sourceName, cArray)) continue;
            return referenceBinding;
        }
        return null;
    }

    @Override
    public MethodBinding[] getMethods(char[] cArray) {
        long l;
        if (this.methods != null && (l = ReferenceBinding.binarySearch(cArray, this.methods)) >= 0L) {
            int n = (int)l;
            int n2 = (int)(l >> 32) - n + 1;
            MethodBinding[] methodBindingArray = new MethodBinding[n2];
            System.arraycopy(this.methods, n, methodBindingArray, 0, n2);
            return methodBindingArray;
        }
        if ((this.tagBits & 0x8000L) != 0L) {
            return Binding.NO_METHODS;
        }
        MethodBinding[] methodBindingArray = null;
        try {
            MethodBinding[] methodBindingArray2 = this.type.getMethods(cArray);
            int n = methodBindingArray2.length;
            if (n == 0) {
                MethodBinding[] methodBindingArray3 = Binding.NO_METHODS;
                return methodBindingArray3;
            }
            methodBindingArray = new MethodBinding[n];
            CompilerOptions compilerOptions = this.environment.globalOptions;
            boolean bl = compilerOptions.isAnnotationBasedNullAnalysisEnabled && compilerOptions.sourceLevel >= 0x340000L;
            int n3 = 0;
            while (n3 < n) {
                methodBindingArray[n3] = this.createParameterizedMethod(methodBindingArray2[n3]);
                if (bl) {
                    methodBindingArray[n3] = NullAnnotationMatching.checkForContraditions(methodBindingArray[n3], null, null);
                }
                ++n3;
            }
            if (this.methods == null) {
                MethodBinding[] methodBindingArray4 = new MethodBinding[n];
                System.arraycopy(methodBindingArray, 0, methodBindingArray4, 0, n);
                this.methods = methodBindingArray4;
            } else {
                n3 = n + this.methods.length;
                MethodBinding[] methodBindingArray5 = new MethodBinding[n3];
                System.arraycopy(methodBindingArray, 0, methodBindingArray5, 0, n);
                System.arraycopy(this.methods, 0, methodBindingArray5, n, this.methods.length);
                if (n3 > 1) {
                    ReferenceBinding.sortMethods(methodBindingArray5, 0, n3);
                }
                this.methods = methodBindingArray5;
            }
            MethodBinding[] methodBindingArray6 = methodBindingArray;
            return methodBindingArray6;
        }
        finally {
            if (methodBindingArray == null) {
                methodBindingArray = Binding.NO_METHODS;
                this.methods = Binding.NO_METHODS;
            }
        }
    }

    @Override
    public int getOuterLocalVariablesSlotSize() {
        return this.genericType().getOuterLocalVariablesSlotSize();
    }

    @Override
    public boolean hasMemberTypes() {
        return this.type.hasMemberTypes();
    }

    @Override
    public boolean hasTypeBit(int n) {
        TypeBinding typeBinding = this.erasure();
        if (typeBinding instanceof ReferenceBinding) {
            return ((ReferenceBinding)typeBinding).hasTypeBit(n);
        }
        return false;
    }

    @Override
    public boolean implementsMethod(MethodBinding methodBinding) {
        return this.type.implementsMethod(methodBinding);
    }

    void initialize(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray) {
        this.type = referenceBinding;
        this.sourceName = referenceBinding.sourceName;
        this.compoundName = referenceBinding.compoundName;
        this.fPackage = referenceBinding.fPackage;
        this.fileName = referenceBinding.fileName;
        this.modifiers = referenceBinding.modifiers & 0xBFFFFFFF;
        if (typeBindingArray != null) {
            this.modifiers |= 0x40000000;
        } else if (this.enclosingType != null) {
            this.modifiers |= this.enclosingType.modifiers & 0x40000000;
            this.tagBits |= this.enclosingType.tagBits & 0x2000000020000080L;
        }
        if (typeBindingArray != null) {
            this.arguments = typeBindingArray;
            int n = 0;
            int n2 = typeBindingArray.length;
            while (n < n2) {
                TypeBinding typeBinding = typeBindingArray[n];
                switch (typeBinding.kind()) {
                    case 516: {
                        this.tagBits |= 0x40000000L;
                        if (((WildcardBinding)typeBinding).boundKind == 0) break;
                        this.tagBits |= 0x800000L;
                        break;
                    }
                    case 8196: {
                        this.tagBits |= 0x40800000L;
                        break;
                    }
                    default: {
                        this.tagBits |= 0x800000L;
                    }
                }
                this.tagBits |= typeBinding.tagBits & 0x2000000020000880L;
                ++n;
            }
        }
        this.tagBits |= referenceBinding.tagBits & 0x278000000000089CL;
        this.tagBits &= 0xFFFFFFFFFFFF5FFFL;
    }

    protected void initializeArguments() {
    }

    @Override
    void initializeForStaticImports() {
        this.type.initializeForStaticImports();
    }

    @Override
    public boolean isBoundParameterizedType() {
        return (this.tagBits & 0x800000L) != 0L;
    }

    @Override
    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (ParameterizedTypeBinding.equalsEquals(this, typeBinding)) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 260: {
                TypeBinding[] typeBindingArray;
                ReferenceBinding referenceBinding;
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
                if (TypeBinding.notEquals(this.type, parameterizedTypeBinding.type)) {
                    return false;
                }
                if (!this.isStatic() && (referenceBinding = this.enclosingType()) != null) {
                    typeBindingArray = parameterizedTypeBinding.enclosingType();
                    if (typeBindingArray == null) {
                        return false;
                    }
                    if ((typeBindingArray.tagBits & 0x40000000L) == 0L ? TypeBinding.notEquals(referenceBinding, (TypeBinding)typeBindingArray) : !referenceBinding.isEquivalentTo(parameterizedTypeBinding.enclosingType())) {
                        return false;
                    }
                }
                if (this.arguments == null) {
                    return parameterizedTypeBinding.arguments == null;
                }
                int n = this.arguments.length;
                typeBindingArray = parameterizedTypeBinding.arguments;
                if (typeBindingArray == null || typeBindingArray.length != n) {
                    return false;
                }
                int n2 = 0;
                while (n2 < n) {
                    if (!this.arguments[n2].isTypeArgumentContainedBy(typeBindingArray[n2])) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            case 1028: {
                return TypeBinding.equalsEquals(this.erasure(), typeBinding.erasure());
            }
        }
        return TypeBinding.equalsEquals(this.erasure(), typeBinding);
    }

    @Override
    public boolean isHierarchyConnected() {
        return this.superclass != null && this.superInterfaces != null;
    }

    @Override
    public boolean isProperType(boolean bl) {
        if (this.arguments != null) {
            int n = 0;
            while (n < this.arguments.length) {
                if (!this.arguments[n].isProperType(bl)) {
                    return false;
                }
                ++n;
            }
        }
        return super.isProperType(bl);
    }

    @Override
    TypeBinding substituteInferenceVariable(InferenceVariable inferenceVariable, TypeBinding typeBinding) {
        if (this.arguments != null) {
            TypeBinding[] typeBindingArray = null;
            int n = this.arguments.length;
            int n2 = 0;
            while (n2 < n) {
                TypeBinding typeBinding2 = this.arguments[n2];
                TypeBinding typeBinding3 = typeBinding2.substituteInferenceVariable(inferenceVariable, typeBinding);
                if (TypeBinding.notEquals(typeBinding3, typeBinding2)) {
                    if (typeBindingArray == null) {
                        typeBindingArray = new TypeBinding[n];
                        System.arraycopy(this.arguments, 0, typeBindingArray, 0, n);
                    }
                    typeBindingArray[n2] = typeBinding3;
                }
                ++n2;
            }
            if (typeBindingArray != null) {
                return this.environment.createParameterizedType(this.type, typeBindingArray, this.enclosingType);
            }
        }
        return this;
    }

    @Override
    public boolean isRawSubstitution() {
        return this.isRawType();
    }

    @Override
    public TypeBinding unannotated(boolean bl) {
        if (!this.hasTypeAnnotations()) {
            return this;
        }
        if (bl && !this.hasNullTypeAnnotations()) {
            return this;
        }
        if (bl) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.environment.getUnannotatedType(this.type);
            AnnotationBinding[] annotationBindingArray = this.environment.filterNullTypeAnnotations(this.typeAnnotations);
            return this.environment.createParameterizedType(referenceBinding, this.arguments, this.enclosingType, annotationBindingArray);
        }
        return this.environment.getUnannotatedType(this);
    }

    @Override
    public int kind() {
        return 260;
    }

    @Override
    public ReferenceBinding[] memberTypes() {
        if (this.memberTypes == null) {
            try {
                ReferenceBinding[] referenceBindingArray = this.type.memberTypes();
                int n = referenceBindingArray.length;
                ReferenceBinding[] referenceBindingArray2 = new ReferenceBinding[n];
                int n2 = 0;
                while (n2 < n) {
                    referenceBindingArray2[n2] = this.environment.createParameterizedType(referenceBindingArray[n2], null, this);
                    ++n2;
                }
                this.memberTypes = referenceBindingArray2;
            }
            finally {
                if (this.memberTypes == null) {
                    this.memberTypes = Binding.NO_MEMBER_TYPES;
                }
            }
        }
        return this.memberTypes;
    }

    @Override
    public boolean mentionsAny(TypeBinding[] typeBindingArray, int n) {
        if (super.mentionsAny(typeBindingArray, n)) {
            return true;
        }
        if (this.arguments != null) {
            int n2 = this.arguments.length;
            int n3 = 0;
            while (n3 < n2) {
                if (TypeBinding.notEquals(this.arguments[n3], this) && this.arguments[n3].mentionsAny(typeBindingArray, n)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    @Override
    void collectInferenceVariables(Set<InferenceVariable> set) {
        if (this.arguments != null) {
            int n = this.arguments.length;
            int n2 = 0;
            while (n2 < n) {
                if (TypeBinding.notEquals(this.arguments[n2], this)) {
                    this.arguments[n2].collectInferenceVariables(set);
                }
                ++n2;
            }
        }
    }

    @Override
    public MethodBinding[] methods() {
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.methods;
        }
        try {
            MethodBinding[] methodBindingArray = this.type.methods();
            int n = methodBindingArray.length;
            MethodBinding[] methodBindingArray2 = new MethodBinding[n];
            CompilerOptions compilerOptions = this.environment.globalOptions;
            boolean bl = compilerOptions.isAnnotationBasedNullAnalysisEnabled && compilerOptions.sourceLevel >= 0x340000L;
            int n2 = 0;
            while (n2 < n) {
                methodBindingArray2[n2] = this.createParameterizedMethod(methodBindingArray[n2]);
                if (bl) {
                    methodBindingArray2[n2] = NullAnnotationMatching.checkForContraditions(methodBindingArray2[n2], null, null);
                }
                ++n2;
            }
            this.methods = methodBindingArray2;
        }
        finally {
            if (this.methods == null) {
                this.methods = Binding.NO_METHODS;
            }
            this.tagBits |= 0x8000L;
        }
        return this.methods;
    }

    @Override
    public int problemId() {
        return this.type.problemId();
    }

    @Override
    public char[] qualifiedPackageName() {
        return this.type.qualifiedPackageName();
    }

    @Override
    public char[] qualifiedSourceName() {
        return this.type.qualifiedSourceName();
    }

    @Override
    public char[] readableName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.'));
        } else {
            stringBuffer.append(CharOperation.concatWith(this.type.compoundName, '.'));
        }
        if (this.arguments != null && this.arguments.length > 0) {
            stringBuffer.append('<');
            n = 0;
            int n2 = this.arguments.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[n].readableName());
                ++n;
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    ReferenceBinding resolve() {
        if ((this.tagBits & 0x1000000L) == 0L) {
            return this;
        }
        this.tagBits &= 0xFFFFFFFFFEFFFFFFL;
        ReferenceBinding referenceBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(this.type, this.environment, false);
        this.tagBits |= referenceBinding.tagBits & 0x800L;
        if (this.arguments != null) {
            int n = this.arguments.length;
            int n2 = 0;
            while (n2 < n) {
                TypeBinding typeBinding;
                this.arguments[n2] = typeBinding = BinaryTypeBinding.resolveType(this.arguments[n2], this.environment, true);
                this.tagBits |= referenceBinding.tagBits & 0x800L;
                ++n2;
            }
        }
        return this;
    }

    @Override
    public char[] shortReadableName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.'));
        } else {
            stringBuffer.append(this.type.sourceName);
        }
        if (this.arguments != null && this.arguments.length > 0) {
            stringBuffer.append('<');
            n = 0;
            int n2 = this.arguments.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[n].shortReadableName());
                ++n;
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public char[] nullAnnotatedReadableName(CompilerOptions compilerOptions, boolean bl) {
        if (bl) {
            return this.nullAnnotatedShortReadableName(compilerOptions);
        }
        return this.nullAnnotatedReadableName(compilerOptions);
    }

    @Override
    char[] nullAnnotatedReadableName(CompilerOptions compilerOptions) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(this.enclosingType().nullAnnotatedReadableName(compilerOptions, false));
            stringBuffer.append('.');
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            stringBuffer.append(this.sourceName);
        } else if (this.type.compoundName != null) {
            n2 = this.type.compoundName.length;
            n = 0;
            while (n < n2 - 1) {
                stringBuffer.append(this.type.compoundName[n]);
                stringBuffer.append('.');
                ++n;
            }
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            stringBuffer.append(this.type.compoundName[n]);
        } else {
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            if (this.type.sourceName != null) {
                stringBuffer.append(this.type.sourceName);
            } else {
                stringBuffer.append(this.type.readableName());
            }
        }
        if (this.arguments != null && this.arguments.length > 0) {
            stringBuffer.append('<');
            n = 0;
            n2 = this.arguments.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[n].nullAnnotatedReadableName(compilerOptions, false));
                ++n;
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    char[] nullAnnotatedShortReadableName(CompilerOptions compilerOptions) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(this.enclosingType().nullAnnotatedReadableName(compilerOptions, true));
            stringBuffer.append('.');
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            stringBuffer.append(this.sourceName);
        } else {
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            if (this.type.sourceName != null) {
                stringBuffer.append(this.type.sourceName);
            } else {
                stringBuffer.append(this.type.shortReadableName());
            }
        }
        if (this.arguments != null && this.arguments.length > 0) {
            stringBuffer.append('<');
            n = 0;
            int n2 = this.arguments.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[n].nullAnnotatedReadableName(compilerOptions, true));
                ++n;
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public char[] signature() {
        if (this.signature == null) {
            this.signature = this.type.signature();
        }
        return this.signature;
    }

    @Override
    public char[] sourceName() {
        return this.type.sourceName();
    }

    @Override
    public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
        ParameterizedTypeBinding parameterizedTypeBinding = this;
        while (true) {
            TypeBinding typeBinding;
            TypeVariableBinding[] typeVariableBindingArray;
            int n;
            if (typeVariableBinding.rank < (n = (typeVariableBindingArray = parameterizedTypeBinding.type.typeVariables()).length) && TypeBinding.equalsEquals(typeVariableBindingArray[typeVariableBinding.rank], typeVariableBinding)) {
                if (parameterizedTypeBinding.arguments == null) {
                    parameterizedTypeBinding.initializeArguments();
                }
                if (parameterizedTypeBinding.arguments != null) {
                    if (parameterizedTypeBinding.arguments.length == 0) {
                        return typeVariableBinding;
                    }
                    typeBinding = parameterizedTypeBinding.arguments[typeVariableBinding.rank];
                    return typeVariableBinding.combineTypeAnnotations(typeBinding);
                }
            }
            if (parameterizedTypeBinding.isStatic() || !((typeBinding = parameterizedTypeBinding.enclosingType()) instanceof ParameterizedTypeBinding)) break;
            parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
        }
        return typeVariableBinding;
    }

    @Override
    public ReferenceBinding superclass() {
        if (this.superclass == null) {
            ReferenceBinding referenceBinding = this.type.superclass();
            if (referenceBinding == null) {
                return null;
            }
            this.superclass = (ReferenceBinding)Scope.substitute((Substitution)this, referenceBinding);
            this.typeBits |= this.superclass.typeBits & 0x13;
            if ((this.typeBits & 3) != 0) {
                this.typeBits |= this.applyCloseableClassWhitelists();
            }
        }
        return this.superclass;
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        if (this.superInterfaces == null) {
            if (this.type.isHierarchyBeingConnected()) {
                return Binding.NO_SUPERINTERFACES;
            }
            this.superInterfaces = Scope.substitute((Substitution)this, this.type.superInterfaces());
            if (this.superInterfaces != null) {
                int n = this.superInterfaces.length;
                while (--n >= 0) {
                    this.typeBits |= this.superInterfaces[n].typeBits & 0x13;
                    if ((this.typeBits & 3) == 0) continue;
                    this.typeBits |= this.applyCloseableInterfaceWhitelists();
                }
            }
        }
        return this.superInterfaces;
    }

    @Override
    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        boolean bl = false;
        if (this.type == unresolvedReferenceBinding) {
            this.type = referenceBinding;
            bl = true;
            ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
            if (referenceBinding2 != null) {
                this.enclosingType = (ReferenceBinding)lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding2);
            }
        }
        if (this.arguments != null) {
            int n = 0;
            int n2 = this.arguments.length;
            while (n < n2) {
                if (this.arguments[n] == unresolvedReferenceBinding) {
                    this.arguments[n] = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
                    bl = true;
                }
                ++n;
            }
        }
        if (bl) {
            this.initialize(this.type, this.arguments);
        }
    }

    @Override
    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        return this.genericType().syntheticEnclosingInstanceTypes();
    }

    @Override
    public SyntheticArgumentBinding[] syntheticOuterLocalVariables() {
        return this.genericType().syntheticOuterLocalVariables();
    }

    public String toString() {
        if (this.hasTypeAnnotations()) {
            return this.annotatedDebugName();
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        if (this.type instanceof UnresolvedReferenceBinding) {
            stringBuffer.append(this.debugName());
        } else {
            int n;
            int n2;
            if (this.isDeprecated()) {
                stringBuffer.append("deprecated ");
            }
            if (this.isPublic()) {
                stringBuffer.append("public ");
            }
            if (this.isProtected()) {
                stringBuffer.append("protected ");
            }
            if (this.isPrivate()) {
                stringBuffer.append("private ");
            }
            if (this.isAbstract() && this.isClass()) {
                stringBuffer.append("abstract ");
            }
            if (this.isStatic() && this.isNestedType()) {
                stringBuffer.append("static ");
            }
            if (this.isFinal()) {
                stringBuffer.append("final ");
            }
            if (this.isEnum()) {
                stringBuffer.append("enum ");
            } else if (this.isAnnotationType()) {
                stringBuffer.append("@interface ");
            } else if (this.isClass()) {
                stringBuffer.append("class ");
            } else {
                stringBuffer.append("interface ");
            }
            stringBuffer.append(this.debugName());
            stringBuffer.append("\n\textends ");
            stringBuffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
            if (this.superInterfaces != null) {
                if (this.superInterfaces != Binding.NO_SUPERINTERFACES) {
                    stringBuffer.append("\n\timplements : ");
                    n2 = 0;
                    n = this.superInterfaces.length;
                    while (n2 < n) {
                        if (n2 > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(this.superInterfaces[n2] != null ? this.superInterfaces[n2].debugName() : "NULL TYPE");
                        ++n2;
                    }
                }
            } else {
                stringBuffer.append("NULL SUPERINTERFACES");
            }
            if (this.enclosingType() != null) {
                stringBuffer.append("\n\tenclosing type : ");
                stringBuffer.append(this.enclosingType().debugName());
            }
            if (this.fields != null) {
                if (this.fields != Binding.NO_FIELDS) {
                    stringBuffer.append("\n/*   fields   */");
                    n2 = 0;
                    n = this.fields.length;
                    while (n2 < n) {
                        stringBuffer.append('\n').append(this.fields[n2] != null ? this.fields[n2].toString() : "NULL FIELD");
                        ++n2;
                    }
                }
            } else {
                stringBuffer.append("NULL FIELDS");
            }
            if (this.methods != null) {
                if (this.methods != Binding.NO_METHODS) {
                    stringBuffer.append("\n/*   methods   */");
                    n2 = 0;
                    n = this.methods.length;
                    while (n2 < n) {
                        stringBuffer.append('\n').append(this.methods[n2] != null ? this.methods[n2].toString() : "NULL METHOD");
                        ++n2;
                    }
                }
            } else {
                stringBuffer.append("NULL METHODS");
            }
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public TypeVariableBinding[] typeVariables() {
        if (this.arguments == null) {
            return this.type.typeVariables();
        }
        return Binding.NO_TYPE_VARIABLES;
    }

    @Override
    public TypeBinding[] typeArguments() {
        return this.arguments;
    }

    @Override
    public FieldBinding[] unResolvedFields() {
        return this.fields;
    }

    @Override
    public MethodBinding getSingleAbstractMethod(Scope scope, boolean bl) {
        int n;
        int n2 = n = bl ? 0 : 1;
        if (this.singleAbstractMethod != null) {
            if (this.singleAbstractMethod[n] != null) {
                return this.singleAbstractMethod[n];
            }
        } else {
            this.singleAbstractMethod = new MethodBinding[2];
        }
        if (!this.isValidBinding()) {
            return null;
        }
        ReferenceBinding referenceBinding = this.genericType();
        MethodBinding methodBinding = referenceBinding.getSingleAbstractMethod(scope, bl);
        if (methodBinding == null || !methodBinding.isValidBinding()) {
            this.singleAbstractMethod[n] = methodBinding;
            return this.singleAbstractMethod[n];
        }
        ParameterizedTypeBinding parameterizedTypeBinding = null;
        TypeBinding[] typeBindingArray = this.arguments;
        if (bl) {
            typeBindingArray = this.getNonWildcardParameterization(scope);
            if (typeBindingArray == null) {
                this.singleAbstractMethod[n] = new ProblemMethodBinding(TypeConstants.ANONYMOUS_METHOD, null, 18);
                return this.singleAbstractMethod[n];
            }
        } else if (typeBindingArray == null) {
            typeBindingArray = NO_TYPES;
        }
        parameterizedTypeBinding = scope.environment().createParameterizedType(referenceBinding, typeBindingArray, referenceBinding.enclosingType());
        TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
        int n3 = 0;
        int n4 = typeVariableBindingArray.length;
        while (n3 < n4) {
            if (typeVariableBindingArray[n3].boundCheck(parameterizedTypeBinding, typeBindingArray[n3], scope) != 0) {
                this.singleAbstractMethod[n] = new ProblemMethodBinding(TypeConstants.ANONYMOUS_METHOD, null, 18);
                return this.singleAbstractMethod[n];
            }
            ++n3;
        }
        ReferenceBinding referenceBinding2 = (ReferenceBinding)parameterizedTypeBinding.findSuperTypeOriginatingFrom(methodBinding.declaringClass);
        MethodBinding[] methodBindingArray = referenceBinding2.getMethods(methodBinding.selector);
        int n5 = 0;
        int n6 = methodBindingArray.length;
        while (n5 < n6) {
            MethodBinding methodBinding2 = methodBindingArray[n5];
            if (methodBinding2.isAbstract() && !methodBinding2.redeclaresPublicObjectMethod(scope)) {
                this.singleAbstractMethod[n] = methodBinding2;
                break;
            }
            ++n5;
        }
        return this.singleAbstractMethod[n];
    }

    public TypeBinding[] getNonWildcardParameterization(Scope scope) {
        TypeBinding[] typeBindingArray = this.arguments;
        if (typeBindingArray == null) {
            return NO_TYPES;
        }
        TypeBinding[] typeBindingArray2 = this.genericType().typeVariables();
        TypeBinding[] typeBindingArray3 = new TypeBinding[typeBindingArray.length];
        int n = 0;
        int n2 = typeBindingArray.length;
        while (n < n2) {
            block20: {
                TypeBinding typeBinding;
                block19: {
                    typeBinding = typeBindingArray[n];
                    if (typeBinding.kind() != 516) break block19;
                    if (typeBindingArray2[n].mentionsAny(typeBindingArray2, n)) {
                        return null;
                    }
                    WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                    switch (wildcardBinding.boundKind) {
                        case 1: {
                            int n3;
                            TypeBinding[] typeBindingArray4 = wildcardBinding.otherBounds;
                            TypeBinding[] typeBindingArray5 = ((TypeVariableBinding)typeBindingArray2[n]).otherUpperBounds();
                            int n4 = 1 + (typeBindingArray4 != null ? typeBindingArray4.length : 0) + typeBindingArray5.length;
                            if (((TypeVariableBinding)typeBindingArray2[n]).firstBound != null) {
                                ++n4;
                            }
                            TypeBinding[] typeBindingArray6 = new TypeBinding[n4];
                            int n5 = 0;
                            typeBindingArray6[n5++] = wildcardBinding.bound;
                            if (typeBindingArray4 != null) {
                                n3 = 0;
                                while (n3 < typeBindingArray4.length) {
                                    typeBindingArray6[n5++] = typeBindingArray4[n3];
                                    ++n3;
                                }
                            }
                            if (((TypeVariableBinding)typeBindingArray2[n]).firstBound != null) {
                                typeBindingArray6[n5++] = ((TypeVariableBinding)typeBindingArray2[n]).firstBound;
                            }
                            n3 = 0;
                            while (n3 < typeBindingArray5.length) {
                                typeBindingArray6[n5++] = typeBindingArray5[n3];
                                ++n3;
                            }
                            Object[] objectArray = Scope.greaterLowerBound(typeBindingArray6, null, this.environment);
                            if (objectArray == null || objectArray.length == 0) {
                                return null;
                            }
                            if (objectArray.length == 1) {
                                typeBindingArray3[n] = objectArray[0];
                                break;
                            }
                            try {
                                ReferenceBinding[] referenceBindingArray = new ReferenceBinding[objectArray.length];
                                System.arraycopy(objectArray, 0, referenceBindingArray, 0, objectArray.length);
                                typeBindingArray3[n] = new IntersectionCastTypeBinding(referenceBindingArray, this.environment);
                                break;
                            }
                            catch (ArrayStoreException arrayStoreException) {
                                scope.problemReporter().genericInferenceError("Cannot compute glb of " + Arrays.toString(objectArray), null);
                                return null;
                            }
                        }
                        case 2: {
                            typeBindingArray3[n] = wildcardBinding.bound;
                            break;
                        }
                        case 0: {
                            typeBindingArray3[n] = ((TypeVariableBinding)typeBindingArray2[n]).firstBound;
                            if (typeBindingArray3[n] != null) break block20;
                            typeBindingArray3[n] = ((TypeVariableBinding)typeBindingArray2[n]).superclass;
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block20;
                }
                typeBindingArray3[n] = typeBinding;
            }
            ++n;
        }
        return typeBindingArray3;
    }

    static boolean typeParametersMentioned(TypeBinding typeBinding) {
        class MentionListener
        extends TypeBindingVisitor {
            private boolean typeParametersMentioned = false;

            MentionListener() {
            }

            public boolean visit(TypeVariableBinding typeVariableBinding) {
                this.typeParametersMentioned = true;
                return false;
            }

            public boolean typeParametersMentioned() {
                return this.typeParametersMentioned;
            }
        }
        MentionListener mentionListener = new MentionListener();
        TypeBindingVisitor.visit((TypeBindingVisitor)mentionListener, typeBinding);
        return mentionListener.typeParametersMentioned();
    }
}

