/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class LocalVariableBinding
extends VariableBinding {
    public int resolvedPosition;
    public static final int UNUSED = 0;
    public static final int USED = 1;
    public static final int FAKE_USED = 2;
    public int useFlag;
    public BlockScope declaringScope;
    public LocalDeclaration declaration;
    public int[] initializationPCs;
    public int initializationCount = 0;
    public FakedTrackingVariable closeTracker;

    public LocalVariableBinding(char[] cArray, TypeBinding typeBinding, int n, boolean bl) {
        super(cArray, typeBinding, n, bl ? Constant.NotAConstant : null);
        if (bl) {
            this.tagBits |= 0x400L;
        }
        this.tagBits |= 0x800L;
    }

    public LocalVariableBinding(LocalDeclaration localDeclaration, TypeBinding typeBinding, int n, boolean bl) {
        this(localDeclaration.name, typeBinding, n, bl);
        this.declaration = localDeclaration;
    }

    public LocalVariableBinding(LocalDeclaration localDeclaration, TypeBinding typeBinding, int n, MethodScope methodScope) {
        this(localDeclaration, typeBinding, n, true);
        this.declaringScope = methodScope;
    }

    public final int kind() {
        return 2;
    }

    public char[] computeUniqueKey(boolean bl) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        BlockScope blockScope = this.declaringScope;
        int n = 0;
        if (blockScope != null) {
            Binding binding;
            MethodScope methodScope = blockScope instanceof MethodScope ? (MethodScope)blockScope : blockScope.enclosingMethodScope();
            object = methodScope.referenceContext;
            if (object instanceof AbstractMethodDeclaration) {
                binding = ((AbstractMethodDeclaration)object).binding;
                if (binding != null) {
                    stringBuffer.append(((MethodBinding)binding).computeUniqueKey(false));
                }
            } else if (object instanceof TypeDeclaration) {
                binding = ((TypeDeclaration)object).binding;
                if (binding != null) {
                    stringBuffer.append(binding.computeUniqueKey(false));
                }
            } else if (object instanceof LambdaExpression && (binding = ((LambdaExpression)object).binding) != null) {
                stringBuffer.append(((MethodBinding)binding).computeUniqueKey(false));
            }
            this.getScopeKey(blockScope, stringBuffer);
            binding = blockScope.locals;
            int n2 = 0;
            while (n2 < blockScope.localIndex) {
                Binding binding2 = binding[n2];
                if (CharOperation.equals(this.name, ((LocalVariableBinding)binding2).name)) {
                    if (this == binding2) break;
                    ++n;
                }
                ++n2;
            }
        }
        stringBuffer.append('#');
        stringBuffer.append(this.name);
        if (n > 0) {
            stringBuffer.append('#');
            stringBuffer.append(n);
        }
        int n3 = stringBuffer.length();
        object = new char[n3];
        stringBuffer.getChars(0, n3, (char[])object, 0);
        return object;
    }

    public AnnotationBinding[] getAnnotations() {
        Annotation[] annotationArray;
        if (this.declaringScope == null) {
            if ((this.tagBits & 0x200000000L) != 0L) {
                if (this.declaration == null) {
                    return Binding.NO_ANNOTATIONS;
                }
                Annotation[] annotationArray2 = this.declaration.annotations;
                if (annotationArray2 != null) {
                    int n = annotationArray2.length;
                    AnnotationBinding[] annotationBindingArray = new AnnotationBinding[n];
                    int n2 = 0;
                    while (n2 < n) {
                        AnnotationBinding annotationBinding = annotationArray2[n2].getCompilerAnnotation();
                        if (annotationBinding == null) {
                            return Binding.NO_ANNOTATIONS;
                        }
                        annotationBindingArray[n2] = annotationBinding;
                        ++n2;
                    }
                    return annotationBindingArray;
                }
            }
            return Binding.NO_ANNOTATIONS;
        }
        SourceTypeBinding sourceTypeBinding = this.declaringScope.enclosingSourceType();
        if (sourceTypeBinding == null) {
            return Binding.NO_ANNOTATIONS;
        }
        if ((this.tagBits & 0x200000000L) == 0L && (this.tagBits & 0x400L) != 0L && this.declaration != null && (annotationArray = this.declaration.annotations) != null) {
            ASTNode.resolveAnnotations(this.declaringScope, annotationArray, this, true);
        }
        return sourceTypeBinding.retrieveAnnotations(this);
    }

    private void getScopeKey(BlockScope blockScope, StringBuffer stringBuffer) {
        int n = blockScope.scopeIndex();
        if (n != -1) {
            this.getScopeKey((BlockScope)blockScope.parent, stringBuffer);
            stringBuffer.append('#');
            stringBuffer.append(n);
        }
    }

    public boolean isSecret() {
        return this.declaration == null && (this.tagBits & 0x400L) == 0L;
    }

    public void recordInitializationEndPC(int n) {
        if (this.initializationPCs[(this.initializationCount - 1 << 1) + 1] == -1) {
            this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = n;
        }
    }

    public void recordInitializationStartPC(int n) {
        int n2;
        if (this.initializationPCs == null) {
            return;
        }
        if (this.initializationCount > 0) {
            n2 = this.initializationPCs[(this.initializationCount - 1 << 1) + 1];
            if (n2 == -1) {
                return;
            }
            if (n2 == n) {
                this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = -1;
                return;
            }
        }
        if ((n2 = this.initializationCount << 1) == this.initializationPCs.length) {
            this.initializationPCs = new int[this.initializationCount << 2];
            System.arraycopy(this.initializationPCs, 0, this.initializationPCs, 0, n2);
        }
        this.initializationPCs[n2] = n;
        this.initializationPCs[n2 + 1] = -1;
        ++this.initializationCount;
    }

    public void setAnnotations(AnnotationBinding[] annotationBindingArray, Scope scope) {
        if (scope == null) {
            return;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding != null) {
            sourceTypeBinding.storeAnnotations(this, annotationBindingArray);
        }
    }

    public void resetInitializations() {
        this.initializationCount = 0;
        this.initializationPCs = null;
    }

    public String toString() {
        String string = super.toString();
        switch (this.useFlag) {
            case 1: {
                string = String.valueOf(string) + "[pos: " + String.valueOf(this.resolvedPosition) + "]";
                break;
            }
            case 0: {
                string = String.valueOf(string) + "[pos: unused]";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "[pos: fake_used]";
            }
        }
        string = String.valueOf(string) + "[id:" + String.valueOf(this.id) + "]";
        if (this.initializationCount > 0) {
            string = String.valueOf(string) + "[pc: ";
            int n = 0;
            while (n < this.initializationCount) {
                if (n > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + String.valueOf(this.initializationPCs[n << 1]) + "-" + (this.initializationPCs[(n << 1) + 1] == -1 ? "?" : String.valueOf(this.initializationPCs[(n << 1) + 1]));
                ++n;
            }
            string = String.valueOf(string) + "]";
        }
        return string;
    }

    public boolean isParameter() {
        return (this.tagBits & 0x400L) != 0L;
    }

    public boolean isCatchParameter() {
        return false;
    }
}

