/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Set;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntersectionCastTypeBinding
extends ReferenceBinding {
    public ReferenceBinding[] intersectingTypes;
    private ReferenceBinding javaLangObject;
    int length;

    public IntersectionCastTypeBinding(ReferenceBinding[] referenceBindingArray, LookupEnvironment lookupEnvironment) {
        this.intersectingTypes = referenceBindingArray;
        this.length = referenceBindingArray.length;
        if (!referenceBindingArray[0].isClass()) {
            this.javaLangObject = lookupEnvironment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
            this.modifiers |= 0x200;
        }
    }

    @Override
    public MethodBinding getSingleAbstractMethod(Scope scope, boolean bl) {
        int n;
        int n2 = n = bl ? 0 : 1;
        if (this.singleAbstractMethod != null) {
            if (this.singleAbstractMethod[n] != null) {
                return this.singleAbstractMethod[n];
            }
        } else {
            this.singleAbstractMethod = new MethodBinding[2];
        }
        MethodBinding methodBinding = samProblemBinding;
        int n3 = 0;
        while (n3 < this.length) {
            MethodBinding methodBinding2 = this.intersectingTypes[n3].getSingleAbstractMethod(scope, bl);
            if (methodBinding2 != null && methodBinding2.isValidBinding()) {
                if (methodBinding.isValidBinding()) {
                    this.singleAbstractMethod[n] = new ProblemMethodBinding(TypeConstants.ANONYMOUS_METHOD, null, 19);
                    return this.singleAbstractMethod[n];
                }
                methodBinding = methodBinding2;
            }
            ++n3;
        }
        this.singleAbstractMethod[n] = methodBinding;
        return this.singleAbstractMethod[n];
    }

    @Override
    public boolean hasTypeBit(int n) {
        int n2 = 0;
        while (n2 < this.length) {
            if (this.intersectingTypes[n2].hasTypeBit(n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean canBeInstantiated() {
        return false;
    }

    @Override
    public boolean canBeSeenBy(PackageBinding packageBinding) {
        int n = 0;
        while (n < this.length) {
            if (!this.intersectingTypes[n].canBeSeenBy(packageBinding)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public boolean canBeSeenBy(Scope scope) {
        int n = 0;
        while (n < this.length) {
            if (!this.intersectingTypes[n].canBeSeenBy(scope)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public boolean canBeSeenBy(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        int n = 0;
        while (n < this.length) {
            if (!this.intersectingTypes[n].canBeSeenBy(referenceBinding, referenceBinding2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public char[] constantPoolName() {
        return this.intersectingTypes[0].constantPoolName();
    }

    @Override
    public PackageBinding getPackage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReferenceBinding[] getIntersectingTypes() {
        return this.intersectingTypes;
    }

    @Override
    public ReferenceBinding superclass() {
        return this.intersectingTypes[0].isClass() ? this.intersectingTypes[0] : this.javaLangObject;
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        if (this.intersectingTypes[0].isClass()) {
            ReferenceBinding[] referenceBindingArray = new ReferenceBinding[this.length - 1];
            System.arraycopy(this.intersectingTypes, 1, referenceBindingArray, 0, this.length - 1);
            return referenceBindingArray;
        }
        return this.intersectingTypes;
    }

    @Override
    public boolean isBoxedPrimitiveType() {
        return this.intersectingTypes[0].isBoxedPrimitiveType();
    }

    @Override
    public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (TypeBinding.equalsEquals(this, typeBinding)) {
            return true;
        }
        int n = typeBinding.kind();
        ReferenceBinding[] referenceBindingArray = null;
        if (n == 8196 && typeBinding.boundKind() == 1) {
            TypeBinding typeBinding2 = ((WildcardBinding)typeBinding).allBounds();
            if (typeBinding2 instanceof IntersectionCastTypeBinding) {
                referenceBindingArray = ((IntersectionCastTypeBinding)typeBinding2).intersectingTypes;
            }
        } else if (n == 32772) {
            referenceBindingArray = ((IntersectionCastTypeBinding)typeBinding).intersectingTypes;
        }
        if (referenceBindingArray != null) {
            int n2 = referenceBindingArray.length;
            TypeBinding[] typeBindingArray = new TypeBinding[n2];
            System.arraycopy(referenceBindingArray, 0, typeBindingArray, 0, n2);
            int n3 = 0;
            while (n3 < this.length) {
                ReferenceBinding referenceBinding = this.intersectingTypes[n3];
                int n4 = 0;
                while (n4 < typeBindingArray.length) {
                    if (typeBindingArray[n4] != null && ((TypeBinding)referenceBinding).isCompatibleWith(typeBindingArray[n4], scope)) {
                        typeBindingArray[n4] = null;
                        if (--n2 != 0) break;
                        return true;
                    }
                    ++n4;
                }
                ++n3;
            }
            return false;
        }
        int n5 = 0;
        while (n5 < this.length) {
            if (this.intersectingTypes[n5].isCompatibleWith(typeBinding, scope)) {
                return true;
            }
            ++n5;
        }
        return false;
    }

    @Override
    public boolean isSubtypeOf(TypeBinding typeBinding) {
        if (TypeBinding.equalsEquals(this, typeBinding)) {
            return true;
        }
        int n = 0;
        while (n < this.intersectingTypes.length) {
            if (this.intersectingTypes[n].isSubtypeOf(typeBinding)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public char[] qualifiedSourceName() {
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = 0;
        while (n < this.length) {
            stringBuffer.append(this.intersectingTypes[n].qualifiedSourceName());
            if (n != this.length - 1) {
                stringBuffer.append(" & ");
            }
            ++n;
        }
        return stringBuffer.toString().toCharArray();
    }

    @Override
    public char[] sourceName() {
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = 0;
        while (n < this.length) {
            stringBuffer.append(this.intersectingTypes[n].sourceName());
            if (n != this.length - 1) {
                stringBuffer.append(" & ");
            }
            ++n;
        }
        return stringBuffer.toString().toCharArray();
    }

    @Override
    public char[] readableName() {
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = 0;
        while (n < this.length) {
            stringBuffer.append(this.intersectingTypes[n].readableName());
            if (n != this.length - 1) {
                stringBuffer.append(" & ");
            }
            ++n;
        }
        return stringBuffer.toString().toCharArray();
    }

    @Override
    public char[] shortReadableName() {
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = 0;
        while (n < this.length) {
            stringBuffer.append(this.intersectingTypes[n].shortReadableName());
            if (n != this.length - 1) {
                stringBuffer.append(" & ");
            }
            ++n;
        }
        return stringBuffer.toString().toCharArray();
    }

    @Override
    public boolean isIntersectionCastType() {
        return true;
    }

    @Override
    public int kind() {
        return 32772;
    }

    @Override
    public String debugName() {
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = 0;
        while (n < this.length) {
            stringBuffer.append(this.intersectingTypes[n].debugName());
            if (n != this.length - 1) {
                stringBuffer.append(" & ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.debugName();
    }

    public TypeBinding getSAMType(Scope scope) {
        ReferenceBinding referenceBinding = null;
        int n = 0;
        int n2 = this.intersectingTypes.length;
        while (n < n2) {
            ReferenceBinding referenceBinding2 = this.intersectingTypes[n];
            MethodBinding methodBinding = ((TypeBinding)referenceBinding2).getSingleAbstractMethod(scope, true);
            if (!(methodBinding instanceof ProblemMethodBinding) || ((ProblemMethodBinding)methodBinding).problemId() != 17) {
                if (referenceBinding != null) {
                    return null;
                }
                referenceBinding = referenceBinding2;
            }
            ++n;
        }
        return referenceBinding;
    }

    @Override
    void collectInferenceVariables(Set<InferenceVariable> set) {
        int n = 0;
        while (n < this.intersectingTypes.length) {
            this.intersectingTypes[n].collectInferenceVariables(set);
            ++n;
        }
    }

    @Override
    public boolean mentionsAny(TypeBinding[] typeBindingArray, int n) {
        if (super.mentionsAny(typeBindingArray, n)) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.intersectingTypes.length) {
            if (this.intersectingTypes[n2].mentionsAny(typeBindingArray, -1)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

