/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class InferenceSubstitution
extends Scope.Substitutor
implements Substitution {
    private LookupEnvironment environment;
    private InferenceVariable[] variables;

    public InferenceSubstitution(LookupEnvironment lookupEnvironment, InferenceVariable[] inferenceVariableArray) {
        this.environment = lookupEnvironment;
        this.variables = inferenceVariableArray;
    }

    public TypeBinding substitute(Substitution substitution, TypeBinding typeBinding) {
        int n = 0;
        while (n < this.variables.length) {
            InferenceVariable inferenceVariable = this.variables[n];
            if (TypeBinding.equalsEquals(this.getP(n), typeBinding)) {
                inferenceVariable.nullHints |= typeBinding.tagBits & 0x180000000000000L;
                return inferenceVariable;
            }
            ++n;
        }
        return super.substitute(substitution, typeBinding);
    }

    protected TypeBinding getP(int n) {
        return this.variables[n].typeParameter;
    }

    public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
        ReferenceBinding referenceBinding = typeVariableBinding.superclass;
        ReferenceBinding[] referenceBindingArray = typeVariableBinding.superInterfaces;
        boolean bl = false;
        int n = 0;
        while (n < this.variables.length) {
            InferenceVariable inferenceVariable = this.variables[n];
            TypeBinding typeBinding = this.getP(n);
            if (TypeBinding.equalsEquals(typeBinding, typeVariableBinding)) {
                return inferenceVariable;
            }
            if (TypeBinding.equalsEquals(typeBinding, referenceBinding)) {
                referenceBinding = inferenceVariable;
                bl = true;
            } else if (referenceBindingArray != null) {
                int n2 = referenceBindingArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    if (TypeBinding.equalsEquals(typeBinding, referenceBindingArray[n3])) {
                        if (referenceBindingArray == typeVariableBinding.superInterfaces) {
                            ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                            referenceBindingArray = new ReferenceBinding[n2];
                            System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n2);
                        }
                        referenceBindingArray[n3] = inferenceVariable;
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
            ++n;
        }
        if (bl) {
            typeVariableBinding = new TypeVariableBinding(typeVariableBinding.sourceName, typeVariableBinding.declaringElement, typeVariableBinding.rank, this.environment);
            typeVariableBinding.superclass = referenceBinding;
            typeVariableBinding.superInterfaces = referenceBindingArray;
            TypeBinding typeBinding = typeVariableBinding.firstBound = referenceBinding != null ? referenceBinding : referenceBindingArray[0];
            if (typeVariableBinding.firstBound.hasNullTypeAnnotations()) {
                typeVariableBinding.tagBits |= 0x100000L;
            }
        }
        return typeVariableBinding;
    }

    public LookupEnvironment environment() {
        return this.environment;
    }

    public boolean isRawSubstitution() {
        return false;
    }
}

