/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ImplicitNullAnnotationVerifier {
    ImplicitNullAnnotationVerifier buddyImplicitNullAnnotationsVerifier;
    private boolean inheritNullAnnotations;
    protected LookupEnvironment environment;

    public ImplicitNullAnnotationVerifier(LookupEnvironment lookupEnvironment, boolean bl) {
        this.buddyImplicitNullAnnotationsVerifier = this;
        this.inheritNullAnnotations = bl;
        this.environment = lookupEnvironment;
    }

    ImplicitNullAnnotationVerifier(LookupEnvironment lookupEnvironment) {
        CompilerOptions compilerOptions = lookupEnvironment.globalOptions;
        this.buddyImplicitNullAnnotationsVerifier = new ImplicitNullAnnotationVerifier(lookupEnvironment, compilerOptions.inheritNullAnnotations);
        this.inheritNullAnnotations = compilerOptions.inheritNullAnnotations;
        this.environment = lookupEnvironment;
    }

    public void checkImplicitNullAnnotations(MethodBinding methodBinding, AbstractMethodDeclaration abstractMethodDeclaration, boolean bl, Scope scope) {
        try {
            ReferenceBinding referenceBinding = methodBinding.declaringClass;
            if (referenceBinding.id == 1) {
                return;
            }
            long l = scope.compilerOptions().sourceLevel;
            boolean bl2 = methodBinding.hasNonNullDefaultFor(24, l >= 0x340000L);
            boolean bl3 = !methodBinding.isConstructor() && !methodBinding.isStatic();
            if (!(bl2 || (bl &= bl3) || this.inheritNullAnnotations && bl3)) {
                return;
            }
            if (bl3) {
                ArrayList arrayList = new ArrayList();
                if (referenceBinding instanceof SourceTypeBinding && !referenceBinding.isHierarchyConnected() && !referenceBinding.isAnonymousType()) {
                    ((SourceTypeBinding)referenceBinding).scope.connectTypeHierarchy();
                }
                int n = methodBinding.parameters.length;
                this.findAllOverriddenMethods(methodBinding.original(), methodBinding.selector, n, referenceBinding, new HashSet(), arrayList);
                InheritedNonNullnessInfo[] inheritedNonNullnessInfoArray = new InheritedNonNullnessInfo[n + 1];
                int n2 = 0;
                while (n2 < n + 1) {
                    inheritedNonNullnessInfoArray[n2] = new InheritedNonNullnessInfo();
                    ++n2;
                }
                int n3 = n2 = arrayList.size();
                while (--n3 >= 0) {
                    MethodBinding methodBinding2 = (MethodBinding)arrayList.get(n3);
                    if ((methodBinding2.tagBits & 0x1000L) == 0L) {
                        this.checkImplicitNullAnnotations(methodBinding2, null, false, scope);
                    }
                    this.checkNullSpecInheritance(methodBinding, abstractMethodDeclaration, bl2, bl, methodBinding2, scope, inheritedNonNullnessInfoArray);
                    bl2 = false;
                }
                InheritedNonNullnessInfo inheritedNonNullnessInfo = inheritedNonNullnessInfoArray[0];
                if (!inheritedNonNullnessInfo.complained) {
                    long l2 = 0L;
                    if (inheritedNonNullnessInfo.inheritedNonNullness == Boolean.TRUE) {
                        l2 = 0x100000000000000L;
                    } else if (inheritedNonNullnessInfo.inheritedNonNullness == Boolean.FALSE) {
                        l2 = 0x80000000000000L;
                    }
                    if (l2 != 0L) {
                        if (l < 0x340000L) {
                            methodBinding.tagBits |= l2;
                        } else if (!methodBinding.returnType.isBaseType()) {
                            LookupEnvironment lookupEnvironment = scope.environment();
                            methodBinding.returnType = lookupEnvironment.createAnnotatedType(methodBinding.returnType, lookupEnvironment.nullAnnotationsFromTagBits(l2));
                        }
                    }
                }
                int n4 = 0;
                while (n4 < n) {
                    inheritedNonNullnessInfo = inheritedNonNullnessInfoArray[n4 + 1];
                    if (!inheritedNonNullnessInfo.complained && inheritedNonNullnessInfo.inheritedNonNullness != null) {
                        Argument argument;
                        Argument argument2 = argument = abstractMethodDeclaration == null ? null : abstractMethodDeclaration.arguments[n4];
                        if (l < 0x340000L) {
                            this.recordArgNonNullness(methodBinding, n, n4, argument, inheritedNonNullnessInfo.inheritedNonNullness);
                        } else {
                            this.recordArgNonNullness18(methodBinding, n4, argument, inheritedNonNullnessInfo.inheritedNonNullness, scope.environment());
                        }
                    }
                    ++n4;
                }
            }
            if (bl2) {
                if (scope.compilerOptions().sourceLevel < 0x340000L) {
                    methodBinding.fillInDefaultNonNullness(abstractMethodDeclaration);
                } else {
                    methodBinding.fillInDefaultNonNullness18(abstractMethodDeclaration, scope.environment());
                }
            }
        }
        finally {
            methodBinding.tagBits |= 0x1000L;
        }
    }

    private void findAllOverriddenMethods(MethodBinding methodBinding, char[] cArray, int n, ReferenceBinding referenceBinding, Set set, List list) {
        if (referenceBinding.id == 1) {
            return;
        }
        ReferenceBinding referenceBinding2 = referenceBinding.superclass();
        if (referenceBinding2 == null) {
            return;
        }
        this.collectOverriddenMethods(methodBinding, cArray, n, referenceBinding2, set, list);
        ReferenceBinding[] referenceBindingArray = referenceBinding.superInterfaces();
        int n2 = referenceBindingArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ReferenceBinding referenceBinding3 = referenceBindingArray[n3];
            if (set.add(referenceBinding3.original())) {
                this.collectOverriddenMethods(methodBinding, cArray, n, referenceBinding3, set, list);
            }
            ++n3;
        }
    }

    private void collectOverriddenMethods(MethodBinding methodBinding, char[] cArray, int n, ReferenceBinding referenceBinding, Set set, List list) {
        MethodBinding[] methodBindingArray = referenceBinding.getMethods(cArray, n);
        int n2 = methodBindingArray.length;
        int n3 = 0;
        while (n3 < n2) {
            MethodBinding methodBinding2 = methodBindingArray[n3];
            if (!methodBinding2.isStatic() && MethodVerifier.doesMethodOverride(methodBinding, methodBinding2, this.environment)) {
                list.add(methodBinding2);
                return;
            }
            ++n3;
        }
        this.findAllOverriddenMethods(methodBinding, cArray, n, referenceBinding, set, list);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void checkNullSpecInheritance(MethodBinding var1_1, AbstractMethodDeclaration var2_2, boolean var3_3, boolean var4_4, MethodBinding var5_5, Scope var6_6, InheritedNonNullnessInfo[] var7_7) {
        block36: {
            block37: {
                block38: {
                    if ((var5_5.tagBits & 4096L) == 0L) {
                        this.buddyImplicitNullAnnotationsVerifier.checkImplicitNullAnnotations(var5_5, null, false, var6_6);
                    }
                    var8_8 = this.environment.globalOptions.sourceLevel >= 0x340000L;
                    var9_9 = this.getReturnTypeNullnessTagBits(var5_5, var8_8);
                    var11_10 = this.getReturnTypeNullnessTagBits(var1_1, var8_8);
                    var13_11 = this.inheritNullAnnotations;
                    if (var1_1.returnType == null || var1_1.returnType.isBaseType()) break block36;
                    if (var11_10 != 0L) break block37;
                    if (!var13_11 || var9_9 == 0L) break block38;
                    if (var3_3 && var4_4 && var9_9 == 0x80000000000000L) {
                        var6_6.problemReporter().conflictingNullAnnotations(var1_1, ((MethodDeclaration)var2_2).returnType, var5_5);
                    }
                    if (var7_7 != null && var2_2 != null) {
                        this.recordDeferredInheritedNullness(var6_6, ((MethodDeclaration)var2_2).returnType, var5_5, var9_9 == 0x100000000000000L, var7_7[0]);
                    } else {
                        this.applyReturnNullBits(var1_1, var9_9);
                    }
                    break block36;
                }
                if (var3_3) {
                    var11_10 = 0x100000000000000L;
                    this.applyReturnNullBits(var1_1, var11_10);
                }
            }
            if (!var4_4) break block36;
            if ((var9_9 & 0x100000000000000L) == 0L || var11_10 == 0x100000000000000L) ** GOTO lbl29
            if (var2_2 != null) {
                var6_6.problemReporter().illegalReturnRedefinition(var2_2, var5_5, this.environment.getNonNullAnnotationName());
            } else {
                var6_6.problemReporter().cannotImplementIncompatibleNullness(var1_1, var5_5, var8_8);
                return;
lbl29:
                // 1 sources

                if (var8_8) {
                    var14_12 /* !! */  = null;
                    var15_13 = var5_5.original().typeVariables;
                    if (var15_13 != null && var1_1.returnType.id != 6) {
                        var16_14 = this.environment.createParameterizedGenericMethod(var1_1, (TypeBinding[])var15_13);
                        var14_12 /* !! */  = var16_14.returnType;
                    }
                    if (NullAnnotationMatching.analyse(var5_5.returnType, var1_1.returnType, (TypeBinding)var14_12 /* !! */ , 0, NullAnnotationMatching.CheckMode.OVERRIDE).isAnyMismatch()) {
                        var6_6.problemReporter().cannotImplementIncompatibleNullness(var1_1, var5_5, var8_8);
                        return;
                    }
                }
            }
        }
        var14_12 /* !! */  = null;
        if (var4_4 && (var15_13 = var1_1.original().typeVariables) != Binding.NO_TYPE_VARIABLES) {
            var16_14 = this.environment.createParameterizedGenericMethod(var5_5, (TypeBinding[])var15_13);
            var14_12 /* !! */  = var16_14.parameters;
        }
        var15_13 = var2_2 == null ? null : var2_2.arguments;
        var16_15 = 0;
        if (var15_13 != null) {
            var16_15 = var15_13.length;
        }
        if (var8_8) {
            var16_15 = var1_1.parameters.length;
        } else if (var5_5.parameterNonNullness != null) {
            var16_15 = var5_5.parameterNonNullness.length;
        } else if (var1_1.parameterNonNullness != null) {
            var16_15 = var1_1.parameterNonNullness.length;
        }
        var17_16 = 0;
        while (var17_16 < var16_15) {
            block39: {
                block42: {
                    block40: {
                        block41: {
                            if (var1_1.parameters[var17_16].isBaseType()) break block39;
                            var18_17 = var15_13 == null ? null : var15_13[var17_16];
                            var19_18 = this.getParameterNonNullness(var5_5, var17_16, var8_8);
                            var20_19 = this.getParameterNonNullness(var1_1, var17_16, var8_8);
                            if (var20_19 != null) break block40;
                            if (var19_18 == null || !var13_11) break block41;
                            if (var3_3 && var4_4 && var19_18 == Boolean.FALSE && var18_17 != null) {
                                var6_6.problemReporter().conflictingNullAnnotations(var1_1, (ASTNode)var18_17, var5_5);
                            }
                            if (var7_7 != null && var2_2 != null) {
                                this.recordDeferredInheritedNullness(var6_6, var2_2.arguments[var17_16].type, var5_5, var19_18, var7_7[var17_16 + 1]);
                            } else if (!var8_8) {
                                this.recordArgNonNullness(var1_1, var16_15, var17_16, (Argument)var18_17, var19_18);
                            } else {
                                this.recordArgNonNullness18(var1_1, var17_16, (Argument)var18_17, var19_18, this.environment);
                            }
                            break block39;
                        }
                        if (var3_3) {
                            var20_19 = Boolean.TRUE;
                            if (!var8_8) {
                                this.recordArgNonNullness(var1_1, var16_15, var17_16, (Argument)var18_17, Boolean.TRUE);
                            } else {
                                this.recordArgNonNullness18(var1_1, var17_16, (Argument)var18_17, Boolean.TRUE, this.environment);
                            }
                        }
                    }
                    if (!var4_4) break block39;
                    var21_20 = var19_18 == Boolean.TRUE ? this.environment.getNonNullAnnotationName() : this.environment.getNullableAnnotationName();
                    if (var19_18 == Boolean.TRUE || var20_19 != Boolean.TRUE) break block42;
                    if (var18_17 != null) {
                        var6_6.problemReporter().illegalRedefinitionToNonNullParameter((Argument)var18_17, var5_5.declaringClass, var19_18 == null ? null : this.environment.getNullableAnnotationName());
                    } else {
                        var6_6.problemReporter().cannotImplementIncompatibleNullness(var1_1, var5_5, false);
                    }
                    break block39;
                }
                if (var20_19 != null) ** GOTO lbl-1000
                if (var19_18 == Boolean.FALSE) {
                    if (var18_17 != null) {
                        var6_6.problemReporter().parameterLackingNullableAnnotation((Argument)var18_17, var5_5.declaringClass, var21_20);
                    } else {
                        var6_6.problemReporter().cannotImplementIncompatibleNullness(var1_1, var5_5, false);
                    }
                } else if (var19_18 == Boolean.TRUE) {
                    var6_6.problemReporter().parameterLackingNonnullAnnotation((Argument)var18_17, var5_5.declaringClass, var21_20);
                } else if (var8_8) {
                    v0 = var22_21 = var14_12 /* !! */  != null ? var14_12 /* !! */ [var17_16] : null;
                    if (NullAnnotationMatching.analyse(var1_1.parameters[var17_16], var5_5.parameters[var17_16], var22_21, 0, NullAnnotationMatching.CheckMode.OVERRIDE).isAnyMismatch()) {
                        var6_6.problemReporter().cannotImplementIncompatibleNullness(var1_1, var5_5, false);
                    }
                }
            }
            ++var17_16;
        }
    }

    void applyReturnNullBits(MethodBinding methodBinding, long l) {
        if (this.environment.globalOptions.sourceLevel < 0x340000L) {
            methodBinding.tagBits |= l;
        } else if (!methodBinding.returnType.isBaseType()) {
            methodBinding.returnType = this.environment.createAnnotatedType(methodBinding.returnType, this.environment.nullAnnotationsFromTagBits(l));
        }
    }

    private Boolean getParameterNonNullness(MethodBinding methodBinding, int n, boolean bl) {
        if (bl) {
            long l;
            TypeBinding typeBinding = methodBinding.parameters[n];
            if (typeBinding != null && (l = NullAnnotationMatching.validNullTagBits(typeBinding.tagBits)) != 0L) {
                return l == 0x100000000000000L;
            }
            return null;
        }
        return methodBinding.parameterNonNullness == null ? null : methodBinding.parameterNonNullness[n];
    }

    private long getReturnTypeNullnessTagBits(MethodBinding methodBinding, boolean bl) {
        if (bl) {
            if (methodBinding.returnType == null) {
                return 0L;
            }
            return NullAnnotationMatching.validNullTagBits(methodBinding.returnType.tagBits);
        }
        return methodBinding.tagBits & 0x180000000000000L;
    }

    protected void recordDeferredInheritedNullness(Scope scope, ASTNode aSTNode, MethodBinding methodBinding, Boolean bl, InheritedNonNullnessInfo inheritedNonNullnessInfo) {
        if (inheritedNonNullnessInfo.inheritedNonNullness != null && inheritedNonNullnessInfo.inheritedNonNullness != bl) {
            scope.problemReporter().conflictingInheritedNullAnnotations(aSTNode, inheritedNonNullnessInfo.inheritedNonNullness, inheritedNonNullnessInfo.annotationOrigin, bl, methodBinding);
            inheritedNonNullnessInfo.complained = true;
        } else {
            inheritedNonNullnessInfo.inheritedNonNullness = bl;
            inheritedNonNullnessInfo.annotationOrigin = methodBinding;
        }
    }

    void recordArgNonNullness(MethodBinding methodBinding, int n, int n2, Argument argument, Boolean bl) {
        if (methodBinding.parameterNonNullness == null) {
            methodBinding.parameterNonNullness = new Boolean[n];
        }
        methodBinding.parameterNonNullness[n2] = bl;
        if (argument != null) {
            argument.binding.tagBits = argument.binding.tagBits | (bl != false ? 0x100000000000000L : 0x80000000000000L);
        }
    }

    void recordArgNonNullness18(MethodBinding methodBinding, int n, Argument argument, Boolean bl, LookupEnvironment lookupEnvironment) {
        AnnotationBinding annotationBinding = bl != false ? lookupEnvironment.getNonNullAnnotation() : lookupEnvironment.getNullableAnnotation();
        methodBinding.parameters[n] = lookupEnvironment.createAnnotatedType(methodBinding.parameters[n], new AnnotationBinding[]{annotationBinding});
        if (argument != null) {
            argument.binding.type = methodBinding.parameters[n];
        }
    }

    static boolean areParametersEqual(MethodBinding methodBinding, MethodBinding methodBinding2) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
        if (typeBindingArray == typeBindingArray2) {
            return true;
        }
        int n = typeBindingArray.length;
        if (n != typeBindingArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!ImplicitNullAnnotationVerifier.areTypesEqual(typeBindingArray[n2], typeBindingArray2[n2])) {
                if (typeBindingArray[n2].leafComponentType().isRawType() && typeBindingArray[n2].dimensions() == typeBindingArray2[n2].dimensions() && typeBindingArray[n2].leafComponentType().isEquivalentTo(typeBindingArray2[n2].leafComponentType())) {
                    if (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES) {
                        return false;
                    }
                    int n3 = 0;
                    while (n3 < n2) {
                        if (typeBindingArray[n3].leafComponentType().isParameterizedTypeWithActualArguments()) {
                            return false;
                        }
                        ++n3;
                    }
                    break;
                }
                return false;
            }
            ++n2;
        }
        ++n2;
        while (n2 < n) {
            if (!ImplicitNullAnnotationVerifier.areTypesEqual(typeBindingArray[n2], typeBindingArray2[n2])) {
                if (!typeBindingArray[n2].leafComponentType().isRawType() || typeBindingArray[n2].dimensions() != typeBindingArray2[n2].dimensions() || !typeBindingArray[n2].leafComponentType().isEquivalentTo(typeBindingArray2[n2].leafComponentType())) {
                    return false;
                }
            } else if (typeBindingArray[n2].leafComponentType().isParameterizedTypeWithActualArguments()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean areTypesEqual(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (TypeBinding.equalsEquals(typeBinding, typeBinding2)) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 4: {
                switch (typeBinding2.kind()) {
                    case 260: 
                    case 1028: {
                        if (!TypeBinding.equalsEquals(typeBinding, typeBinding2.erasure())) break;
                        return true;
                    }
                }
                break;
            }
            case 260: 
            case 1028: {
                switch (typeBinding2.kind()) {
                    case 4: {
                        if (!TypeBinding.equalsEquals(typeBinding.erasure(), typeBinding2)) break;
                        return true;
                    }
                }
                break;
            }
        }
        if (typeBinding.isParameterizedType() && typeBinding2.isParameterizedType()) {
            return typeBinding.isEquivalentTo(typeBinding2) && typeBinding2.isEquivalentTo(typeBinding);
        }
        return false;
    }

    static class InheritedNonNullnessInfo {
        Boolean inheritedNonNullness;
        MethodBinding annotationOrigin;
        boolean complained;

        InheritedNonNullnessInfo() {
        }
    }
}

