/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BoundSet;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintFormula;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionCastTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBound;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstraintTypeFormula
extends ConstraintFormula {
    TypeBinding left;
    boolean isSoft;

    public static ConstraintTypeFormula create(TypeBinding typeBinding, TypeBinding typeBinding2, int n) {
        if (typeBinding == null || typeBinding2 == null) {
            return FALSE;
        }
        return new ConstraintTypeFormula(typeBinding, typeBinding2, n, false);
    }

    public static ConstraintTypeFormula create(TypeBinding typeBinding, TypeBinding typeBinding2, int n, boolean bl) {
        if (typeBinding == null || typeBinding2 == null) {
            return FALSE;
        }
        return new ConstraintTypeFormula(typeBinding, typeBinding2, n, bl);
    }

    private ConstraintTypeFormula(TypeBinding typeBinding, TypeBinding typeBinding2, int n, boolean bl) {
        this.left = typeBinding;
        this.right = typeBinding2;
        this.relation = n;
        this.isSoft = bl;
    }

    ConstraintTypeFormula() {
    }

    @Override
    public Object reduce(InferenceContext18 inferenceContext18) {
        switch (this.relation) {
            case 1: {
                if (this.left.isProperType(true) && this.right.isProperType(true)) {
                    if (this.isCompatibleWithInLooseInvocationContext(this.left, this.right, inferenceContext18)) {
                        return TRUE;
                    }
                    return FALSE;
                }
                if (this.left.isPrimitiveType()) {
                    TypeBinding typeBinding = inferenceContext18.environment.computeBoxingType(this.left);
                    return ConstraintTypeFormula.create(typeBinding, this.right, 1, this.isSoft);
                }
                if (this.right.isPrimitiveType()) {
                    TypeBinding typeBinding = inferenceContext18.environment.computeBoxingType(this.right);
                    return ConstraintTypeFormula.create(this.left, typeBinding, 4, this.isSoft);
                }
                switch (this.right.kind()) {
                    case 68: {
                        if (this.right.leafComponentType().kind() != 260) break;
                    }
                    case 260: {
                        TypeBinding typeBinding = this.left.findSuperTypeOriginatingFrom(this.right);
                        if (typeBinding == null || !typeBinding.leafComponentType().isRawType()) break;
                        inferenceContext18.recordUncheckedConversion(this);
                        return TRUE;
                    }
                }
                return ConstraintTypeFormula.create(this.left, this.right, 2, this.isSoft);
            }
            case 2: {
                return this.reduceSubType(inferenceContext18.scope, this.left, this.right);
            }
            case 3: {
                return this.reduceSubType(inferenceContext18.scope, this.right, this.left);
            }
            case 4: {
                return this.reduceTypeEquality(inferenceContext18.object);
            }
            case 5: {
                if (this.right.kind() != 516) {
                    if (this.left.kind() != 516) {
                        return ConstraintTypeFormula.create(this.left, this.right, 4, this.isSoft);
                    }
                    return FALSE;
                }
                WildcardBinding wildcardBinding = (WildcardBinding)this.right;
                if (wildcardBinding.boundKind == 0) {
                    return TRUE;
                }
                if (wildcardBinding.boundKind == 1) {
                    if (this.left.kind() != 516) {
                        return ConstraintTypeFormula.create(this.left, wildcardBinding.bound, 2, this.isSoft);
                    }
                    WildcardBinding wildcardBinding2 = (WildcardBinding)this.left;
                    switch (wildcardBinding2.boundKind) {
                        case 0: {
                            return ConstraintTypeFormula.create(inferenceContext18.object, wildcardBinding.bound, 2, this.isSoft);
                        }
                        case 1: {
                            return ConstraintTypeFormula.create(wildcardBinding2.bound, wildcardBinding.bound, 2, this.isSoft);
                        }
                        case 2: {
                            return ConstraintTypeFormula.create(inferenceContext18.object, wildcardBinding.bound, 4, this.isSoft);
                        }
                    }
                    throw new IllegalArgumentException("Unexpected boundKind " + wildcardBinding2.boundKind);
                }
                if (this.left.kind() != 516) {
                    return ConstraintTypeFormula.create(wildcardBinding.bound, this.left, 2, this.isSoft);
                }
                WildcardBinding wildcardBinding3 = (WildcardBinding)this.left;
                if (wildcardBinding3.boundKind == 2) {
                    return ConstraintTypeFormula.create(wildcardBinding.bound, wildcardBinding3.bound, 2, this.isSoft);
                }
                return FALSE;
            }
        }
        throw new IllegalStateException("Unexpected relation kind " + this.relation);
    }

    private Object reduceTypeEquality(TypeBinding typeBinding) {
        if (this.left.kind() == 516) {
            if (this.right.kind() == 516) {
                WildcardBinding wildcardBinding = (WildcardBinding)this.left;
                WildcardBinding wildcardBinding2 = (WildcardBinding)this.right;
                if (wildcardBinding.boundKind == 0 && wildcardBinding2.boundKind == 0) {
                    return TRUE;
                }
                if (wildcardBinding.boundKind == 0 && wildcardBinding2.boundKind == 1) {
                    return ConstraintTypeFormula.create(typeBinding, wildcardBinding2.bound, 4, this.isSoft);
                }
                if (wildcardBinding.boundKind == 1 && wildcardBinding2.boundKind == 0) {
                    return ConstraintTypeFormula.create(wildcardBinding.bound, typeBinding, 4, this.isSoft);
                }
                if (wildcardBinding.boundKind == 1 && wildcardBinding2.boundKind == 1 || wildcardBinding.boundKind == 2 && wildcardBinding2.boundKind == 2) {
                    return ConstraintTypeFormula.create(wildcardBinding.bound, wildcardBinding2.bound, 4, this.isSoft);
                }
            }
        } else if (this.right.kind() != 516) {
            if (this.left.isProperType(true) && this.right.isProperType(true)) {
                if (TypeBinding.equalsEquals(this.left, this.right)) {
                    return TRUE;
                }
                return FALSE;
            }
            if (this.left instanceof InferenceVariable) {
                return new TypeBound((InferenceVariable)this.left, this.right, 4, this.isSoft);
            }
            if (this.right instanceof InferenceVariable) {
                return new TypeBound((InferenceVariable)this.right, this.left, 4, this.isSoft);
            }
            if ((this.left.isClass() || this.left.isInterface()) && (this.right.isClass() || this.right.isInterface()) && TypeBinding.equalsEquals(this.left.erasure(), this.right.erasure())) {
                TypeBinding[] typeBindingArray = this.left.typeArguments();
                TypeBinding[] typeBindingArray2 = this.right.typeArguments();
                if (typeBindingArray == null || typeBindingArray2 == null) {
                    return typeBindingArray == typeBindingArray2 ? TRUE : FALSE;
                }
                if (typeBindingArray.length != typeBindingArray2.length) {
                    return FALSE;
                }
                int n = typeBindingArray.length;
                ConstraintFormula[] constraintFormulaArray = new ConstraintFormula[n];
                int n2 = 0;
                while (n2 < n) {
                    constraintFormulaArray[n2] = ConstraintTypeFormula.create(typeBindingArray[n2], typeBindingArray2[n2], 4, this.isSoft);
                    ++n2;
                }
                return constraintFormulaArray;
            }
            if (this.left.isArrayType() && this.right.isArrayType() && this.left.dimensions() == this.right.dimensions()) {
                return ConstraintTypeFormula.create(this.left.leafComponentType(), this.right.leafComponentType(), 4, this.isSoft);
            }
        }
        return FALSE;
    }

    private Object reduceSubType(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding.isProperType(true) && typeBinding2.isProperType(true)) {
            if (typeBinding.isCompatibleWith(typeBinding2, scope)) {
                return TRUE;
            }
            return FALSE;
        }
        if (typeBinding.id == 12) {
            return TRUE;
        }
        if (typeBinding2.id == 12) {
            return FALSE;
        }
        if (typeBinding instanceof InferenceVariable) {
            return new TypeBound((InferenceVariable)typeBinding, typeBinding2, 2, this.isSoft);
        }
        if (typeBinding2 instanceof InferenceVariable) {
            return new TypeBound((InferenceVariable)typeBinding2, typeBinding, 3, this.isSoft);
        }
        switch (typeBinding2.kind()) {
            case 4: 
            case 1028: 
            case 2052: {
                if (typeBinding.isSubtypeOf(typeBinding2)) {
                    return TRUE;
                }
                return FALSE;
            }
            case 260: {
                ArrayList<ConstraintFormula> arrayList = new ArrayList<ConstraintFormula>();
                while (typeBinding2 != null && typeBinding2.kind() == 260 && typeBinding != null) {
                    if (!this.addConstraintsFromTypeParameters(typeBinding, (ParameterizedTypeBinding)typeBinding2, arrayList)) {
                        return FALSE;
                    }
                    typeBinding2 = typeBinding2.enclosingType();
                    typeBinding = typeBinding.enclosingType();
                }
                switch (arrayList.size()) {
                    case 0: {
                        return TRUE;
                    }
                    case 1: {
                        return arrayList.get(0);
                    }
                }
                return arrayList.toArray(new ConstraintFormula[arrayList.size()]);
            }
            case 68: {
                TypeBinding typeBinding3;
                TypeBinding typeBinding4 = ((ArrayBinding)typeBinding2).elementsType();
                ArrayBinding arrayBinding = null;
                switch (typeBinding.kind()) {
                    case 8196: {
                        typeBinding3 = (WildcardBinding)typeBinding;
                        arrayBinding = this.findMostSpecificSuperArray(((WildcardBinding)typeBinding3).bound, ((WildcardBinding)typeBinding3).otherBounds, typeBinding3);
                        break;
                    }
                    case 68: {
                        arrayBinding = (ArrayBinding)typeBinding;
                        break;
                    }
                    case 4100: {
                        typeBinding3 = (TypeVariableBinding)typeBinding;
                        arrayBinding = this.findMostSpecificSuperArray(((TypeVariableBinding)typeBinding3).firstBound, ((TypeVariableBinding)typeBinding3).otherUpperBounds(), typeBinding3);
                        break;
                    }
                    default: {
                        return FALSE;
                    }
                }
                if (arrayBinding == null) {
                    return FALSE;
                }
                typeBinding3 = arrayBinding.elementsType();
                if (!typeBinding4.isPrimitiveType() && !typeBinding3.isPrimitiveType()) {
                    return ConstraintTypeFormula.create(typeBinding3, typeBinding4, 2, this.isSoft);
                }
                return TypeBinding.equalsEquals(typeBinding4, typeBinding3) ? TRUE : FALSE;
            }
            case 516: {
                Object object;
                if (typeBinding.kind() == 8196 && (object = typeBinding.getIntersectingTypes()) != null) {
                    int n = 0;
                    while (n < ((ReferenceBinding[])object).length) {
                        if (TypeBinding.equalsEquals(object[n], typeBinding2)) {
                            return true;
                        }
                        ++n;
                    }
                }
                object = (WildcardBinding)typeBinding2;
                if (object.boundKind == 2) {
                    return ConstraintTypeFormula.create(typeBinding, object.bound, 2, this.isSoft);
                }
                return FALSE;
            }
            case 4100: {
                Object object;
                if (typeBinding.kind() == 8196 && (object = typeBinding.getIntersectingTypes()) != null) {
                    int n = 0;
                    while (n < ((ReferenceBinding[])object).length) {
                        if (TypeBinding.equalsEquals(object[n], typeBinding2)) {
                            return true;
                        }
                        ++n;
                    }
                }
                if (typeBinding2 instanceof CaptureBinding) {
                    object = (CaptureBinding)typeBinding2;
                    if (object.lowerBound != null && (object.firstBound == null || object.firstBound.id == 1)) {
                        return ConstraintTypeFormula.create(typeBinding, object.lowerBound, 2, this.isSoft);
                    }
                }
                return FALSE;
            }
            case 8196: {
                typeBinding2 = ((WildcardBinding)typeBinding2).allBounds();
            }
            case 32772: {
                ReferenceBinding[] referenceBindingArray = ((IntersectionCastTypeBinding)typeBinding2).intersectingTypes;
                ConstraintFormula[] constraintFormulaArray = new ConstraintFormula[referenceBindingArray.length];
                int n = 0;
                while (n < referenceBindingArray.length) {
                    constraintFormulaArray[n] = ConstraintTypeFormula.create(typeBinding, referenceBindingArray[n], 2, this.isSoft);
                    ++n;
                }
                return constraintFormulaArray;
            }
        }
        throw new IllegalStateException("Unexpected RHS " + typeBinding2);
    }

    private ArrayBinding findMostSpecificSuperArray(TypeBinding typeBinding, TypeBinding[] typeBindingArray, TypeBinding typeBinding2) {
        int n = 0;
        ArrayBinding arrayBinding = null;
        if (typeBinding != null && typeBinding.isArrayType()) {
            arrayBinding = (ArrayBinding)typeBinding;
            ++n;
        }
        int n2 = 0;
        while (n2 < typeBindingArray.length) {
            if (typeBindingArray[n2].isArrayType()) {
                arrayBinding = (ArrayBinding)typeBindingArray[n2];
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return arrayBinding;
        }
        InferenceContext18.missingImplementation("Extracting array from intersection is not defined");
        return null;
    }

    boolean addConstraintsFromTypeParameters(TypeBinding typeBinding, ParameterizedTypeBinding parameterizedTypeBinding, List<ConstraintFormula> list) {
        TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
        if (typeBindingArray == null) {
            return true;
        }
        TypeBinding typeBinding2 = typeBinding.findSuperTypeOriginatingFrom(parameterizedTypeBinding);
        if (typeBinding2 == null) {
            return false;
        }
        if (TypeBinding.equalsEquals(parameterizedTypeBinding, typeBinding2)) {
            return true;
        }
        if (!(typeBinding2 instanceof ParameterizedTypeBinding)) {
            return this.isInsignificantParameterized(parameterizedTypeBinding);
        }
        TypeBinding[] typeBindingArray2 = ((ParameterizedTypeBinding)typeBinding2).arguments;
        if (typeBinding2.isRawType() || typeBindingArray2 == null || typeBindingArray2.length == 0) {
            return this.isSoft;
        }
        int n = 0;
        while (n < typeBindingArray.length) {
            list.add(ConstraintTypeFormula.create(typeBindingArray2[n], typeBindingArray[n], 5, this.isSoft));
            ++n;
        }
        return true;
    }

    private boolean isInsignificantParameterized(ParameterizedTypeBinding parameterizedTypeBinding) {
        TypeVariableBinding[] typeVariableBindingArray = parameterizedTypeBinding.original().typeVariables();
        TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
        if (typeVariableBindingArray == null || typeBindingArray == null) {
            return typeVariableBindingArray == typeBindingArray;
        }
        if (typeVariableBindingArray.length != typeBindingArray.length) {
            return false;
        }
        int n = 0;
        while (n < typeBindingArray.length) {
            if (TypeBinding.notEquals(typeVariableBindingArray[n], typeBindingArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public boolean applySubstitution(BoundSet boundSet, InferenceVariable[] inferenceVariableArray) {
        super.applySubstitution(boundSet, inferenceVariableArray);
        int n = 0;
        while (n < inferenceVariableArray.length) {
            InferenceVariable inferenceVariable = inferenceVariableArray[n];
            TypeBinding typeBinding = boundSet.getInstantiation(inferenceVariableArray[n], null);
            if (typeBinding == null) {
                return false;
            }
            this.left = this.left.substituteInferenceVariable(inferenceVariable, typeBinding);
            ++n;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Type Constraint:\n");
        stringBuffer.append('\t').append('\u27e8');
        this.appendTypeName(stringBuffer, this.left);
        stringBuffer.append(ConstraintTypeFormula.relationToString(this.relation));
        this.appendTypeName(stringBuffer, this.right);
        stringBuffer.append('\u27e9');
        return stringBuffer.toString();
    }
}

