/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.internal.compiler.lookup.BoundSet;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding18;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintTypeFormula;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InferenceFailureException;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.ReductionResult;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConstraintFormula
extends ReductionResult {
    static final List<InferenceVariable> EMPTY_VARIABLE_LIST = Collections.emptyList();
    static final ConstraintFormula[] NO_CONSTRAINTS = new ConstraintTypeFormula[0];
    static final char LEFT_ANGLE_BRACKET = '\u27e8';
    static final char RIGHT_ANGLE_BRACKET = '\u27e9';

    ConstraintFormula() {
    }

    public abstract Object reduce(InferenceContext18 var1) throws InferenceFailureException;

    protected boolean isCompatibleWithInLooseInvocationContext(TypeBinding typeBinding, TypeBinding typeBinding2, InferenceContext18 inferenceContext18) {
        TypeBinding typeBinding3;
        if (typeBinding.isCompatibleWith(typeBinding2, inferenceContext18.scope)) {
            return true;
        }
        if (typeBinding.isBaseType() == typeBinding2.isBaseType()) {
            return false;
        }
        if (typeBinding.isPrimitiveType()) {
            TypeBinding typeBinding4;
            if (!typeBinding2.isBaseType() && (typeBinding4 = inferenceContext18.environment.computeBoxingType(typeBinding)) != typeBinding) {
                return typeBinding4.isCompatibleWith(typeBinding2, inferenceContext18.scope);
            }
        } else if (typeBinding2.isPrimitiveType() && (typeBinding3 = inferenceContext18.environment.computeBoxingType(typeBinding2)) != typeBinding2) {
            return typeBinding.isCompatibleWith(typeBinding3, inferenceContext18.scope);
        }
        return false;
    }

    Collection<InferenceVariable> inputVariables(InferenceContext18 inferenceContext18) {
        return EMPTY_VARIABLE_LIST;
    }

    Collection<InferenceVariable> outputVariables(InferenceContext18 inferenceContext18) {
        HashSet<InferenceVariable> hashSet = new HashSet<InferenceVariable>();
        this.right.collectInferenceVariables(hashSet);
        if (!hashSet.isEmpty()) {
            hashSet.removeAll(this.inputVariables(inferenceContext18));
        }
        return hashSet;
    }

    public boolean applySubstitution(BoundSet boundSet, InferenceVariable[] inferenceVariableArray) {
        int n = 0;
        while (n < inferenceVariableArray.length) {
            InferenceVariable inferenceVariable = inferenceVariableArray[n];
            TypeBinding typeBinding = boundSet.getInstantiation(inferenceVariableArray[n], null);
            if (typeBinding == null) {
                return false;
            }
            this.right = this.right.substituteInferenceVariable(inferenceVariable, typeBinding);
            ++n;
        }
        return true;
    }

    protected void appendTypeName(StringBuffer stringBuffer, TypeBinding typeBinding) {
        if (typeBinding instanceof CaptureBinding18) {
            stringBuffer.append(typeBinding.toString());
        } else {
            stringBuffer.append(typeBinding.readableName());
        }
    }
}

