/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintTypeFormula;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintExceptionFormula
extends ConstraintFormula {
    FunctionalExpression left;

    public ConstraintExceptionFormula(FunctionalExpression functionalExpression, TypeBinding typeBinding) {
        this.left = functionalExpression;
        this.right = typeBinding;
        this.relation = 7;
    }

    @Override
    public Object reduce(InferenceContext18 inferenceContext18) {
        Object object;
        FunctionalExpression functionalExpression;
        int n;
        int n2;
        Scope scope = inferenceContext18.scope;
        if (!this.right.isFunctionalInterface(scope)) {
            return FALSE;
        }
        MethodBinding methodBinding = this.right.getSingleAbstractMethod(scope, true);
        if (methodBinding == null) {
            return FALSE;
        }
        if (this.left instanceof LambdaExpression) {
            if (((LambdaExpression)this.left).argumentsTypeElided()) {
                n2 = methodBinding.parameters.length;
                n = 0;
                while (n < n2) {
                    if (!methodBinding.parameters[n].isProperType(true)) {
                        return FALSE;
                    }
                    ++n;
                }
            }
            if (methodBinding.returnType != TypeBinding.VOID && !methodBinding.returnType.isProperType(true)) {
                return FALSE;
            }
        } else if (!((ReferenceExpression)this.left).isExactMethodReference()) {
            n2 = methodBinding.parameters.length;
            n = 0;
            while (n < n2) {
                if (!methodBinding.parameters[n].isProperType(true)) {
                    return FALSE;
                }
                ++n;
            }
            if (methodBinding.returnType != TypeBinding.VOID && !methodBinding.returnType.isProperType(true)) {
                return FALSE;
            }
        }
        ReferenceBinding[] referenceBindingArray = methodBinding.thrownExceptions;
        InferenceVariable[] inferenceVariableArray = new InferenceVariable[referenceBindingArray.length];
        int n3 = 0;
        int n4 = 0;
        while (n4 < referenceBindingArray.length) {
            if (!((TypeBinding)referenceBindingArray[n4]).isProperType(true)) {
                inferenceVariableArray[n3++] = (InferenceVariable)referenceBindingArray[n4];
            }
            ++n4;
        }
        if (n3 == 0) {
            return TRUE;
        }
        TypeBinding[] typeBindingArray = null;
        if (this.left instanceof LambdaExpression) {
            functionalExpression = ((LambdaExpression)this.left).getResolvedCopyForInferenceTargeting(this.right);
            if (functionalExpression == null) {
                return TRUE;
            }
            object = ((LambdaExpression)functionalExpression).getThrownExceptions();
            typeBindingArray = object.toArray(new TypeBinding[object.size()]);
        } else {
            functionalExpression = (ReferenceExpression)this.left;
            object = ((ReferenceExpression)functionalExpression).findCompileTimeMethodTargeting(this.right, scope);
            if (object != null) {
                typeBindingArray = ((MethodBinding)object).thrownExceptions;
            }
        }
        if (typeBindingArray == null) {
            return TRUE;
        }
        int n5 = typeBindingArray.length;
        object = new ArrayList<ConstraintTypeFormula>();
        int n6 = 0;
        while (n6 < n5) {
            block26: {
                if (!typeBindingArray[n6].isUncheckedException(false)) {
                    int n7 = 0;
                    while (n7 < referenceBindingArray.length) {
                        if (!((TypeBinding)referenceBindingArray[n7]).isProperType(true) || !typeBindingArray[n6].isCompatibleWith(referenceBindingArray[n7])) {
                            ++n7;
                            continue;
                        }
                        break block26;
                    }
                    n7 = 0;
                    while (n7 < n3) {
                        object.add(ConstraintTypeFormula.create(typeBindingArray[n6], inferenceVariableArray[n7], 2));
                        ++n7;
                    }
                }
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < n3) {
            inferenceContext18.currentBounds.inThrows.add(inferenceVariableArray[n6]);
            ++n6;
        }
        return object.toArray(new ConstraintFormula[object.size()]);
    }

    @Override
    Collection<InferenceVariable> inputVariables(InferenceContext18 inferenceContext18) {
        if (this.left instanceof LambdaExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(inferenceContext18.scope)) {
                LambdaExpression lambdaExpression = (LambdaExpression)this.left;
                MethodBinding methodBinding = this.right.getSingleAbstractMethod(inferenceContext18.scope, true);
                HashSet<InferenceVariable> hashSet = new HashSet<InferenceVariable>();
                if (lambdaExpression.argumentsTypeElided()) {
                    int n = methodBinding.parameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        methodBinding.parameters[n2].collectInferenceVariables(hashSet);
                        ++n2;
                    }
                }
                if (methodBinding.returnType != TypeBinding.VOID) {
                    methodBinding.returnType.collectInferenceVariables(hashSet);
                }
                return hashSet;
            }
        } else if (this.left instanceof ReferenceExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(inferenceContext18.scope)) {
                MethodBinding methodBinding = this.right.getSingleAbstractMethod(inferenceContext18.scope, true);
                HashSet<InferenceVariable> hashSet = new HashSet<InferenceVariable>();
                int n = methodBinding.parameters.length;
                int n3 = 0;
                while (n3 < n) {
                    methodBinding.parameters[n3].collectInferenceVariables(hashSet);
                    ++n3;
                }
                methodBinding.returnType.collectInferenceVariables(hashSet);
                return hashSet;
            }
        }
        return EMPTY_VARIABLE_LIST;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append('\u27e8');
        this.left.printExpression(4, stringBuffer);
        stringBuffer.append(" \u2286throws ");
        this.appendTypeName(stringBuffer, this.right);
        stringBuffer.append('\u27e9');
        return stringBuffer.toString();
    }
}

