/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public class ClassScope
extends Scope {
    public TypeDeclaration referenceContext;
    public TypeReference superTypeReference;
    ArrayList<Object> deferredBoundChecks;

    public ClassScope(Scope scope, TypeDeclaration typeDeclaration) {
        super(3, scope);
        this.referenceContext = typeDeclaration;
        this.deferredBoundChecks = null;
    }

    void buildAnonymousTypeBinding(SourceTypeBinding sourceTypeBinding, ReferenceBinding referenceBinding) {
        Object object;
        LocalTypeBinding localTypeBinding = this.buildLocalType(sourceTypeBinding, sourceTypeBinding.fPackage);
        localTypeBinding.modifiers |= 0x8000000;
        int n = referenceBinding.typeBits;
        if ((n & 4) != 0 && (object = this.referenceContext.methods) != null) {
            int n2 = 0;
            while (n2 < ((AbstractMethodDeclaration[])object).length) {
                if (CharOperation.equals(TypeConstants.CLOSE, object[n2].selector) && object[n2].arguments == null) {
                    n &= 0x13;
                    break;
                }
                ++n2;
            }
        }
        localTypeBinding.typeBits |= n;
        if (referenceBinding.isInterface()) {
            localTypeBinding.setSuperClass(this.getJavaLangObject());
            localTypeBinding.setSuperInterfaces(new ReferenceBinding[]{referenceBinding});
            object = this.referenceContext.allocation.type;
            if (object != null) {
                this.referenceContext.superInterfaces = new TypeReference[]{object};
                if ((referenceBinding.tagBits & 0x40000000L) != 0L) {
                    this.problemReporter().superTypeCannotUseWildcard(localTypeBinding, (TypeReference)object, referenceBinding);
                    localTypeBinding.tagBits |= 0x20000L;
                    localTypeBinding.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
                }
            }
        } else {
            localTypeBinding.setSuperClass(referenceBinding);
            localTypeBinding.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
            object = this.referenceContext.allocation.type;
            if (object != null) {
                this.referenceContext.superclass = object;
                if (referenceBinding.erasure().id == 41) {
                    this.problemReporter().cannotExtendEnum(localTypeBinding, (TypeReference)object, referenceBinding);
                    localTypeBinding.tagBits |= 0x20000L;
                    localTypeBinding.setSuperClass(this.getJavaLangObject());
                } else if (referenceBinding.isFinal()) {
                    this.problemReporter().anonymousClassCannotExtendFinalClass((TypeReference)object, referenceBinding);
                    localTypeBinding.tagBits |= 0x20000L;
                    localTypeBinding.setSuperClass(this.getJavaLangObject());
                } else if ((referenceBinding.tagBits & 0x40000000L) != 0L) {
                    this.problemReporter().superTypeCannotUseWildcard(localTypeBinding, (TypeReference)object, referenceBinding);
                    localTypeBinding.tagBits |= 0x20000L;
                    localTypeBinding.setSuperClass(this.getJavaLangObject());
                }
            }
        }
        this.connectMemberTypes();
        this.buildFieldsAndMethods();
        localTypeBinding.faultInTypesForFieldsAndMethods();
        localTypeBinding.verifyMethods(this.environment().methodVerifier());
    }

    void buildFields() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (sourceTypeBinding.areFieldsInitialized()) {
            return;
        }
        if (this.referenceContext.fields == null) {
            sourceTypeBinding.setFields(Binding.NO_FIELDS);
            return;
        }
        FieldDeclaration[] fieldDeclarationArray = this.referenceContext.fields;
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            switch (fieldDeclarationArray[n3].getKind()) {
                case 1: 
                case 3: {
                    ++n2;
                }
            }
            ++n3;
        }
        FieldBinding[] fieldBindingArray = new FieldBinding[n2];
        HashtableOfObject hashtableOfObject = new HashtableOfObject(n2);
        n2 = 0;
        int n4 = 0;
        while (n4 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n4];
            if (fieldDeclaration.getKind() != 2) {
                FieldBinding fieldBinding = new FieldBinding(fieldDeclaration, null, fieldDeclaration.modifiers | 0x2000000, sourceTypeBinding);
                fieldBinding.id = n2;
                this.checkAndSetModifiersForField(fieldBinding, fieldDeclaration);
                if (hashtableOfObject.containsKey(fieldDeclaration.name)) {
                    FieldBinding fieldBinding2 = (FieldBinding)hashtableOfObject.get(fieldDeclaration.name);
                    if (fieldBinding2 != null) {
                        int n5 = 0;
                        while (n5 < n4) {
                            FieldDeclaration fieldDeclaration2 = fieldDeclarationArray[n5];
                            if (fieldDeclaration2.binding == fieldBinding2) {
                                this.problemReporter().duplicateFieldInType(sourceTypeBinding, fieldDeclaration2);
                                break;
                            }
                            ++n5;
                        }
                    }
                    hashtableOfObject.put(fieldDeclaration.name, null);
                    this.problemReporter().duplicateFieldInType(sourceTypeBinding, fieldDeclaration);
                    fieldDeclaration.binding = null;
                } else {
                    hashtableOfObject.put(fieldDeclaration.name, fieldBinding);
                    fieldBindingArray[n2++] = fieldBinding;
                }
            }
            ++n4;
        }
        if (n2 != fieldBindingArray.length) {
            FieldBinding[] fieldBindingArray2 = fieldBindingArray;
            fieldBindingArray = new FieldBinding[n2];
            System.arraycopy(fieldBindingArray2, 0, fieldBindingArray, 0, n2);
        }
        sourceTypeBinding.tagBits &= 0xFFFFFFFFFFFFCFFFL;
        sourceTypeBinding.setFields(fieldBindingArray);
    }

    void buildFieldsAndMethods() {
        this.buildFields();
        this.buildMethods();
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (!sourceTypeBinding.isPrivate() && sourceTypeBinding.superclass instanceof SourceTypeBinding && sourceTypeBinding.superclass.isPrivate()) {
            ((SourceTypeBinding)sourceTypeBinding.superclass).tagIndirectlyAccessibleMembers();
        }
        if (sourceTypeBinding.isMemberType() && !sourceTypeBinding.isLocalType()) {
            ((MemberTypeBinding)sourceTypeBinding).checkSyntheticArgsAndFields();
        }
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.memberTypes;
        int n = 0;
        int n2 = referenceBindingArray.length;
        while (n < n2) {
            ((SourceTypeBinding)referenceBindingArray[n]).scope.buildFieldsAndMethods();
            ++n;
        }
    }

    private LocalTypeBinding buildLocalType(SourceTypeBinding sourceTypeBinding, PackageBinding packageBinding) {
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        LocalTypeBinding localTypeBinding = new LocalTypeBinding(this, sourceTypeBinding, this.innermostSwitchCase());
        this.referenceContext.binding = localTypeBinding;
        this.checkAndSetModifiers();
        this.buildTypeVariables();
        ReferenceBinding[] referenceBindingArray = Binding.NO_MEMBER_TYPES;
        if (this.referenceContext.memberTypes != null) {
            int n = this.referenceContext.memberTypes.length;
            referenceBindingArray = new ReferenceBinding[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                TypeDeclaration typeDeclaration = this.referenceContext.memberTypes[n3];
                block0 : switch (TypeDeclaration.kind(typeDeclaration.modifiers)) {
                    case 2: 
                    case 4: {
                        this.problemReporter().illegalLocalTypeDeclaration(typeDeclaration);
                        break;
                    }
                    default: {
                        ReferenceBinding referenceBinding = localTypeBinding;
                        do {
                            if (!CharOperation.equals(referenceBinding.sourceName, typeDeclaration.name)) continue;
                            this.problemReporter().typeCollidesWithEnclosingType(typeDeclaration);
                            break block0;
                        } while ((referenceBinding = ((TypeBinding)referenceBinding).enclosingType()) != null);
                        int n4 = 0;
                        while (n4 < n3) {
                            if (CharOperation.equals(this.referenceContext.memberTypes[n4].name, typeDeclaration.name)) {
                                this.problemReporter().duplicateNestedType(typeDeclaration);
                                break block0;
                            }
                            ++n4;
                        }
                        ClassScope classScope = new ClassScope(this, this.referenceContext.memberTypes[n3]);
                        LocalTypeBinding localTypeBinding2 = classScope.buildLocalType(localTypeBinding, packageBinding);
                        localTypeBinding2.setAsMemberType();
                        referenceBindingArray[n2++] = localTypeBinding2;
                    }
                }
                ++n3;
            }
            if (n2 != n) {
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2];
                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n2);
            }
        }
        localTypeBinding.setMemberTypes(referenceBindingArray);
        return localTypeBinding;
    }

    void buildLocalTypeBinding(SourceTypeBinding sourceTypeBinding) {
        LocalTypeBinding localTypeBinding = this.buildLocalType(sourceTypeBinding, sourceTypeBinding.fPackage);
        this.connectTypeHierarchy();
        if (this.compilerOptions().sourceLevel >= 0x310000L) {
            this.checkParameterizedTypeBounds();
            this.checkParameterizedSuperTypeCollisions();
        }
        this.buildFieldsAndMethods();
        localTypeBinding.faultInTypesForFieldsAndMethods();
        this.referenceContext.binding.verifyMethods(this.environment().methodVerifier());
    }

    private void buildMemberTypes(AccessRestriction accessRestriction) {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding[] referenceBindingArray = Binding.NO_MEMBER_TYPES;
        if (this.referenceContext.memberTypes != null) {
            int n = this.referenceContext.memberTypes.length;
            referenceBindingArray = new ReferenceBinding[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                TypeDeclaration typeDeclaration = this.referenceContext.memberTypes[n3];
                block0 : switch (TypeDeclaration.kind(typeDeclaration.modifiers)) {
                    case 2: 
                    case 4: {
                        if (sourceTypeBinding.isNestedType() && sourceTypeBinding.isClass() && !sourceTypeBinding.isStatic()) {
                            this.problemReporter().illegalLocalTypeDeclaration(typeDeclaration);
                            break;
                        }
                    }
                    default: {
                        ReferenceBinding referenceBinding = sourceTypeBinding;
                        do {
                            if (!CharOperation.equals(referenceBinding.sourceName, typeDeclaration.name)) continue;
                            this.problemReporter().typeCollidesWithEnclosingType(typeDeclaration);
                            break block0;
                        } while ((referenceBinding = referenceBinding.enclosingType()) != null);
                        int n4 = 0;
                        while (n4 < n3) {
                            if (CharOperation.equals(this.referenceContext.memberTypes[n4].name, typeDeclaration.name)) {
                                this.problemReporter().duplicateNestedType(typeDeclaration);
                                break block0;
                            }
                            ++n4;
                        }
                        ClassScope classScope = new ClassScope(this, typeDeclaration);
                        referenceBindingArray[n2++] = classScope.buildType(sourceTypeBinding, sourceTypeBinding.fPackage, accessRestriction);
                    }
                }
                ++n3;
            }
            if (n2 != n) {
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2];
                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n2);
            }
        }
        sourceTypeBinding.setMemberTypes(referenceBindingArray);
    }

    void buildMethods() {
        Object object;
        int n;
        boolean bl;
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (sourceTypeBinding.areMethodsInitialized()) {
            return;
        }
        boolean bl2 = bl = TypeDeclaration.kind(this.referenceContext.modifiers) == 3;
        if (this.referenceContext.methods == null && !bl) {
            this.referenceContext.binding.setMethods(Binding.NO_METHODS);
            return;
        }
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = this.referenceContext.methods;
        int n2 = abstractMethodDeclarationArray == null ? 0 : abstractMethodDeclarationArray.length;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            if (abstractMethodDeclarationArray[n4].isClinit()) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        n4 = bl ? 2 : 0;
        MethodBinding[] methodBindingArray = new MethodBinding[(n3 == -1 ? n2 : n2 - 1) + n4];
        if (bl) {
            methodBindingArray[0] = sourceTypeBinding.addSyntheticEnumMethod(TypeConstants.VALUES);
            methodBindingArray[1] = sourceTypeBinding.addSyntheticEnumMethod(TypeConstants.VALUEOF);
        }
        boolean bl3 = false;
        if (sourceTypeBinding.isAbstract()) {
            n = 0;
            while (n < n2) {
                MethodScope methodScope;
                if (n != n3 && (object = (methodScope = new MethodScope(this, abstractMethodDeclarationArray[n], false)).createMethod(abstractMethodDeclarationArray[n])) != null) {
                    methodBindingArray[n4++] = object;
                    bl3 = bl3 || ((MethodBinding)object).isNative();
                }
                ++n;
            }
        } else {
            n = 0;
            int n5 = 0;
            while (n5 < n2) {
                MethodBinding methodBinding;
                if (n5 != n3 && (methodBinding = ((MethodScope)(object = new MethodScope(this, abstractMethodDeclarationArray[n5], false))).createMethod(abstractMethodDeclarationArray[n5])) != null) {
                    methodBindingArray[n4++] = methodBinding;
                    n = n == 0 && !methodBinding.isAbstract() ? 0 : 1;
                    bl3 = bl3 || methodBinding.isNative();
                }
                ++n5;
            }
            if (n != 0) {
                this.problemReporter().abstractMethodInConcreteClass(sourceTypeBinding);
            }
        }
        if (n4 != methodBindingArray.length) {
            MethodBinding[] methodBindingArray2 = methodBindingArray;
            methodBindingArray = new MethodBinding[n4];
            System.arraycopy(methodBindingArray2, 0, methodBindingArray, 0, n4);
        }
        sourceTypeBinding.tagBits &= 0xFFFFFFFFFFFF3FFFL;
        sourceTypeBinding.setMethods(methodBindingArray);
        if (bl3) {
            n = 0;
            while (n < methodBindingArray.length) {
                methodBindingArray[n].modifiers |= 0x8000000;
                ++n;
            }
            FieldBinding[] fieldBindingArray = sourceTypeBinding.unResolvedFields();
            int n6 = 0;
            while (n6 < fieldBindingArray.length) {
                fieldBindingArray[n6].modifiers |= 0x8000000;
                ++n6;
            }
        }
    }

    SourceTypeBinding buildType(SourceTypeBinding sourceTypeBinding, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        Object object;
        Object object2;
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        if (sourceTypeBinding == null) {
            object2 = CharOperation.arrayConcat(packageBinding.compoundName, this.referenceContext.name);
            this.referenceContext.binding = new SourceTypeBinding((char[][])object2, packageBinding, this);
        } else {
            object2 = CharOperation.deepCopy(sourceTypeBinding.compoundName);
            object2[((char[][])object2).length - 1] = CharOperation.concat(object2[((char[][])object2).length - 1], this.referenceContext.name, '$');
            object = packageBinding.getType0(object2[((char[][])object2).length - 1]);
            if (object != null && !(object instanceof UnresolvedReferenceBinding)) {
                this.parent.problemReporter().duplicateNestedType(this.referenceContext);
            }
            this.referenceContext.binding = new MemberTypeBinding((char[][])object2, this, sourceTypeBinding);
        }
        object2 = this.referenceContext.binding;
        this.environment().setAccessRestriction((ReferenceBinding)object2, accessRestriction);
        object = this.referenceContext.typeParameters;
        object2.typeVariables = object == null || ((TypeParameter[])object).length == 0 ? Binding.NO_TYPE_VARIABLES : null;
        object2.fPackage.addType((ReferenceBinding)object2);
        this.checkAndSetModifiers();
        this.buildTypeVariables();
        this.buildMemberTypes(accessRestriction);
        return object2;
    }

    private void buildTypeVariables() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        TypeParameter[] typeParameterArray = this.referenceContext.typeParameters;
        if (typeParameterArray == null || typeParameterArray.length == 0) {
            sourceTypeBinding.setTypeVariables(Binding.NO_TYPE_VARIABLES);
            return;
        }
        sourceTypeBinding.setTypeVariables(Binding.NO_TYPE_VARIABLES);
        if (sourceTypeBinding.id == 1) {
            this.problemReporter().objectCannotBeGeneric(this.referenceContext);
            return;
        }
        sourceTypeBinding.setTypeVariables(this.createTypeVariables(typeParameterArray, sourceTypeBinding));
        sourceTypeBinding.modifiers |= 0x40000000;
    }

    void resolveTypeParameter(TypeParameter typeParameter) {
        typeParameter.resolve(this);
    }

    private void checkAndSetModifiers() {
        Binding binding;
        Object object;
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        int n = sourceTypeBinding.modifiers;
        if ((n & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForType(sourceTypeBinding);
        }
        ReferenceBinding referenceBinding = sourceTypeBinding.enclosingType();
        boolean bl = sourceTypeBinding.isMemberType();
        if (bl) {
            n |= referenceBinding.modifiers & 0x40000800;
            if (referenceBinding.isInterface()) {
                n |= 1;
            }
            if (sourceTypeBinding.isEnum()) {
                if (!referenceBinding.isStatic()) {
                    this.problemReporter().nonStaticContextForEnumMemberType(sourceTypeBinding);
                } else {
                    n |= 8;
                }
            } else if (sourceTypeBinding.isInterface()) {
                n |= 8;
            }
        } else if (sourceTypeBinding.isLocalType()) {
            if (sourceTypeBinding.isEnum()) {
                this.problemReporter().illegalLocalTypeDeclaration(this.referenceContext);
                sourceTypeBinding.modifiers = 0;
                return;
            }
            if (sourceTypeBinding.isAnonymousType()) {
                n |= 0x10;
                if (this.referenceContext.allocation.type == null) {
                    n |= 0x4000;
                }
            }
            Scope scope = this;
            block4: do {
                switch (scope.kind) {
                    case 2: {
                        object = (MethodScope)scope;
                        if (((MethodScope)object).isLambdaScope()) {
                            object = ((Scope)object).namedMethodScope();
                        }
                        if (((MethodScope)object).isInsideInitializer()) {
                            binding = ((TypeDeclaration)((MethodScope)object).referenceContext).binding;
                            if (((MethodScope)object).initializedField != null) {
                                if (!((MethodScope)object).initializedField.isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                                n |= 0x200000;
                                break;
                            }
                            if (((ReferenceBinding)binding).isStrictfp()) {
                                n |= 0x800;
                            }
                            if (!((ReferenceBinding)binding).isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                            n |= 0x200000;
                            break;
                        }
                        binding = ((AbstractMethodDeclaration)((MethodScope)object).referenceContext).binding;
                        if (binding == null) break;
                        if (((MethodBinding)binding).isStrictfp()) {
                            n |= 0x800;
                        }
                        if (!((MethodBinding)binding).isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                        n |= 0x200000;
                        break;
                    }
                    case 3: {
                        if (referenceBinding.isStrictfp()) {
                            n |= 0x800;
                        }
                        if (!referenceBinding.isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                        n |= 0x200000;
                    }
                }
            } while ((scope = scope.parent) != null);
        }
        int n2 = n & 0xFFFF;
        if ((n2 & 0x200) != 0) {
            if (bl) {
                if ((n2 & 0xFFFFD1F0) != 0) {
                    if ((n2 & 0x2000) != 0) {
                        this.problemReporter().illegalModifierForAnnotationMemberType(sourceTypeBinding);
                    } else {
                        this.problemReporter().illegalModifierForMemberInterface(sourceTypeBinding);
                    }
                }
            } else if ((n2 & 0xFFFFD1FE) != 0) {
                if ((n2 & 0x2000) != 0) {
                    this.problemReporter().illegalModifierForAnnotationType(sourceTypeBinding);
                } else {
                    this.problemReporter().illegalModifierForInterface(sourceTypeBinding);
                }
            }
            if (sourceTypeBinding.sourceName == TypeConstants.PACKAGE_INFO_NAME && this.compilerOptions().targetJDK > 0x310000L) {
                n |= 0x1000;
            }
            n |= 0x400;
        } else if ((n2 & 0x4000) != 0) {
            if (bl) {
                if ((n2 & 0xFFFFB7F0) != 0) {
                    this.problemReporter().illegalModifierForMemberEnum(sourceTypeBinding);
                    n &= 0xFFFFFBFF;
                    n2 &= 0xFFFFFBFF;
                }
            } else if (!sourceTypeBinding.isLocalType() && (n2 & 0xFFFFB7FE) != 0) {
                this.problemReporter().illegalModifierForEnum(sourceTypeBinding);
            }
            if (!sourceTypeBinding.isAnonymousType()) {
                int n3;
                block80: {
                    if ((this.referenceContext.bits & 0x800) != 0) {
                        n |= 0x400;
                    } else {
                        object = this.referenceContext;
                        binding = ((TypeDeclaration)object).fields;
                        int n4 = n3 = binding == null ? 0 : ((Binding)binding).length;
                        if (n3 != 0) {
                            AbstractMethodDeclaration[] abstractMethodDeclarationArray = ((TypeDeclaration)object).methods;
                            int n5 = abstractMethodDeclarationArray == null ? 0 : abstractMethodDeclarationArray.length;
                            boolean bl2 = ((TypeDeclaration)object).superInterfaces != null;
                            int n6 = 0;
                            while (n6 < n5 && !bl2) {
                                bl2 = abstractMethodDeclarationArray[n6].isAbstract();
                                ++n6;
                            }
                            if (bl2) {
                                n6 = 0;
                                int n7 = 0;
                                while (n7 < n3) {
                                    Binding binding2 = binding[n7];
                                    if (((FieldDeclaration)((Object)binding2)).getKind() == 3) {
                                        if (!(((FieldDeclaration)((Object)binding2)).initialization instanceof QualifiedAllocationExpression)) break block80;
                                        n6 = 1;
                                    }
                                    ++n7;
                                }
                                if (n6 != 0) {
                                    n |= 0x400;
                                }
                            }
                        }
                    }
                }
                object = this.referenceContext;
                binding = ((TypeDeclaration)object).fields;
                if (binding != null) {
                    n3 = 0;
                    int n8 = ((Binding)binding).length;
                    while (n3 < n8) {
                        Binding binding3 = binding[n3];
                        if (((FieldDeclaration)((Object)binding3)).getKind() != 3 || !(((FieldDeclaration)((Object)binding3)).initialization instanceof QualifiedAllocationExpression)) {
                            ++n3;
                            continue;
                        }
                        break;
                    }
                } else {
                    n |= 0x10;
                }
            }
        } else {
            if (bl) {
                if ((n2 & 0xFFFFF3E0) != 0) {
                    this.problemReporter().illegalModifierForMemberClass(sourceTypeBinding);
                }
            } else if (sourceTypeBinding.isLocalType()) {
                if ((n2 & 0xFFFFF3EF) != 0) {
                    this.problemReporter().illegalModifierForLocalClass(sourceTypeBinding);
                }
            } else if ((n2 & 0xFFFFF3EE) != 0) {
                this.problemReporter().illegalModifierForClass(sourceTypeBinding);
            }
            if ((n2 & 0x410) == 1040) {
                this.problemReporter().illegalModifierCombinationFinalAbstractForClass(sourceTypeBinding);
            }
        }
        if (bl) {
            if (referenceBinding.isInterface()) {
                if ((n2 & 6) != 0) {
                    this.problemReporter().illegalVisibilityModifierForInterfaceMemberType(sourceTypeBinding);
                    if ((n2 & 4) != 0) {
                        n &= 0xFFFFFFFB;
                    }
                    if ((n2 & 2) != 0) {
                        n &= 0xFFFFFFFD;
                    }
                }
            } else {
                int n9 = n2 & 7;
                if ((n9 & n9 - 1) > 1) {
                    this.problemReporter().illegalVisibilityModifierCombinationForMemberType(sourceTypeBinding);
                    if ((n9 & 1) != 0) {
                        if ((n9 & 4) != 0) {
                            n &= 0xFFFFFFFB;
                        }
                        if ((n9 & 2) != 0) {
                            n &= 0xFFFFFFFD;
                        }
                    } else if ((n9 & 4) != 0 && (n9 & 2) != 0) {
                        n &= 0xFFFFFFFD;
                    }
                }
            }
            if ((n2 & 8) == 0) {
                if (referenceBinding.isInterface()) {
                    n |= 8;
                }
            } else if (!referenceBinding.isStatic()) {
                this.problemReporter().illegalStaticModifierForMemberType(sourceTypeBinding);
            }
        }
        sourceTypeBinding.modifiers = n;
    }

    private void checkAndSetModifiersForField(FieldBinding fieldBinding, FieldDeclaration fieldDeclaration) {
        int n;
        int n2 = fieldBinding.modifiers;
        ReferenceBinding referenceBinding = fieldBinding.declaringClass;
        if ((n2 & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForField(referenceBinding, fieldDeclaration);
        }
        if (referenceBinding.isInterface()) {
            if (((n2 |= 0x19) & 0xFFFF) != 25) {
                if ((referenceBinding.modifiers & 0x2000) != 0) {
                    this.problemReporter().illegalModifierForAnnotationField(fieldDeclaration);
                } else {
                    this.problemReporter().illegalModifierForInterfaceField(fieldDeclaration);
                }
            }
            fieldBinding.modifiers = n2;
            return;
        }
        if (fieldDeclaration.getKind() == 3) {
            if ((n2 & 0xFFFF) != 0) {
                this.problemReporter().illegalModifierForEnumConstant(referenceBinding, fieldDeclaration);
            }
            fieldBinding.modifiers |= 0x8004019;
            return;
        }
        int n3 = n2 & 0xFFFF;
        if ((n3 & 0xFFFFFF20) != 0) {
            this.problemReporter().illegalModifierForField(referenceBinding, fieldDeclaration);
            n2 &= 0xFFFF00DF;
        }
        if (((n = n3 & 7) & n - 1) > 1) {
            this.problemReporter().illegalVisibilityModifierCombinationForField(referenceBinding, fieldDeclaration);
            if ((n & 1) != 0) {
                if ((n & 4) != 0) {
                    n2 &= 0xFFFFFFFB;
                }
                if ((n & 2) != 0) {
                    n2 &= 0xFFFFFFFD;
                }
            } else if ((n & 4) != 0 && (n & 2) != 0) {
                n2 &= 0xFFFFFFFD;
            }
        }
        if ((n3 & 0x50) == 80) {
            this.problemReporter().illegalModifierCombinationFinalVolatileForField(referenceBinding, fieldDeclaration);
        }
        if (fieldDeclaration.initialization == null && (n2 & 0x10) != 0) {
            n2 |= 0x4000000;
        }
        fieldBinding.modifiers = n2;
    }

    public void checkParameterizedSuperTypeCollisions() {
        ReferenceBinding referenceBinding;
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.superInterfaces;
        HashMap hashMap = new HashMap(2);
        ReferenceBinding referenceBinding2 = sourceTypeBinding.isInterface() ? null : sourceTypeBinding.superclass;
        int n = 0;
        int n2 = referenceBindingArray.length;
        while (n < n2) {
            ReferenceBinding referenceBinding3 = referenceBindingArray[n];
            if (!(referenceBinding3 == null || referenceBinding2 != null && this.hasErasedCandidatesCollisions(referenceBinding2, referenceBinding3, hashMap, sourceTypeBinding, this.referenceContext))) {
                int n3 = 0;
                while (n3 < n) {
                    referenceBinding = referenceBindingArray[n3];
                    if (referenceBinding != null && this.hasErasedCandidatesCollisions(referenceBinding3, referenceBinding, hashMap, sourceTypeBinding, this.referenceContext)) break;
                    ++n3;
                }
            }
            ++n;
        }
        TypeParameter[] typeParameterArray = this.referenceContext.typeParameters;
        n2 = 0;
        int n4 = typeParameterArray == null ? 0 : typeParameterArray.length;
        while (n2 < n4) {
            TypeReference[] typeReferenceArray;
            TypeParameter typeParameter = typeParameterArray[n2];
            referenceBinding = typeParameter.binding;
            if (referenceBinding != null && referenceBinding.isValidBinding() && (typeReferenceArray = typeParameter.bounds) != null) {
                boolean bl = TypeBinding.equalsEquals(((TypeVariableBinding)referenceBinding).firstBound, ((TypeVariableBinding)referenceBinding).superclass);
                int n5 = 0;
                int n6 = typeReferenceArray.length;
                block3: while (n5 < n6) {
                    TypeReference typeReference = typeReferenceArray[n5];
                    TypeBinding typeBinding = typeReference.resolvedType;
                    if (typeBinding != null && typeBinding.isValidBinding()) {
                        if (bl && this.hasErasedCandidatesCollisions(typeBinding, ((TypeVariableBinding)referenceBinding).superclass, hashMap, referenceBinding, typeReference)) break;
                        int n7 = ((TypeVariableBinding)referenceBinding).superInterfaces.length;
                        while (--n7 >= 0) {
                            if (this.hasErasedCandidatesCollisions(typeBinding, ((TypeVariableBinding)referenceBinding).superInterfaces[n7], hashMap, referenceBinding, typeReference)) break block3;
                        }
                    }
                    ++n5;
                }
            }
            ++n2;
        }
        ReferenceBinding[] referenceBindingArray2 = this.referenceContext.binding.memberTypes;
        if (referenceBindingArray2 != null && referenceBindingArray2 != Binding.NO_MEMBER_TYPES) {
            n4 = 0;
            int n8 = referenceBindingArray2.length;
            while (n4 < n8) {
                ((SourceTypeBinding)referenceBindingArray2[n4]).scope.checkParameterizedSuperTypeCollisions();
                ++n4;
            }
        }
    }

    private void checkForInheritedMemberTypes(SourceTypeBinding sourceTypeBinding) {
        int n;
        ReferenceBinding[] referenceBindingArray;
        int n2;
        ReferenceBinding referenceBinding = sourceTypeBinding;
        ReferenceBinding[] referenceBindingArray2 = null;
        int n3 = 0;
        do {
            if (referenceBinding.hasMemberTypes()) {
                return;
            }
            ReferenceBinding[] referenceBindingArray3 = referenceBinding.superInterfaces();
            if (referenceBindingArray3 == null || referenceBindingArray3 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray2 == null) {
                referenceBindingArray2 = referenceBindingArray3;
                n3 = referenceBindingArray2.length;
                continue;
            }
            n2 = referenceBindingArray3.length;
            if (n3 + n2 >= referenceBindingArray2.length) {
                ReferenceBinding[] referenceBindingArray4 = referenceBindingArray2;
                referenceBindingArray2 = new ReferenceBinding[n3 + n2 + 5];
                System.arraycopy(referenceBindingArray4, 0, referenceBindingArray2, 0, n3);
            }
            int n4 = 0;
            while (n4 < n2) {
                block19: {
                    referenceBindingArray = referenceBindingArray3[n4];
                    n = 0;
                    while (n < n3) {
                        if (!TypeBinding.equalsEquals((TypeBinding)referenceBindingArray, referenceBindingArray2[n])) {
                            ++n;
                            continue;
                        }
                        break block19;
                    }
                    referenceBindingArray2[n3++] = referenceBindingArray;
                }
                ++n4;
            }
        } while ((referenceBinding = referenceBinding.superclass()) != null && (referenceBinding.tagBits & 0x10000L) == 0L);
        if (referenceBindingArray2 != null) {
            boolean bl = false;
            n2 = 0;
            while (n2 < n3) {
                ReferenceBinding referenceBinding2 = referenceBindingArray2[n2];
                if ((referenceBinding2.tagBits & 0x10000L) == 0L) {
                    if (referenceBinding2.hasMemberTypes()) {
                        return;
                    }
                    bl = true;
                    referenceBindingArray = referenceBinding2.superInterfaces();
                    if (referenceBindingArray != null && referenceBindingArray != Binding.NO_SUPERINTERFACES) {
                        n = referenceBindingArray.length;
                        if (n3 + n >= referenceBindingArray2.length) {
                            ReferenceBinding[] referenceBindingArray5 = referenceBindingArray2;
                            referenceBindingArray2 = new ReferenceBinding[n3 + n + 5];
                            System.arraycopy(referenceBindingArray5, 0, referenceBindingArray2, 0, n3);
                        }
                        int n5 = 0;
                        while (n5 < n) {
                            block20: {
                                ReferenceBinding referenceBinding3 = referenceBindingArray[n5];
                                int n6 = 0;
                                while (n6 < n3) {
                                    if (!TypeBinding.equalsEquals(referenceBinding3, referenceBindingArray2[n6])) {
                                        ++n6;
                                        continue;
                                    }
                                    break block20;
                                }
                                referenceBindingArray2[n3++] = referenceBinding3;
                            }
                            ++n5;
                        }
                    }
                }
                ++n2;
            }
            if (bl) {
                n2 = 0;
                while (n2 < n3) {
                    referenceBindingArray2[n2].tagBits |= 0x10000L;
                    ++n2;
                }
            }
        }
        referenceBinding = sourceTypeBinding;
        do {
            referenceBinding.tagBits |= 0x10000L;
        } while ((referenceBinding = referenceBinding.superclass()) != null && (referenceBinding.tagBits & 0x10000L) == 0L);
    }

    public void checkParameterizedTypeBounds() {
        int n = 0;
        int n2 = this.deferredBoundChecks == null ? 0 : this.deferredBoundChecks.size();
        while (n < n2) {
            Object object = this.deferredBoundChecks.get(n);
            if (object instanceof TypeReference) {
                ((TypeReference)object).checkBounds(this);
            } else if (object instanceof Runnable) {
                ((Runnable)object).run();
            }
            ++n;
        }
        this.deferredBoundChecks = null;
        ReferenceBinding[] referenceBindingArray = this.referenceContext.binding.memberTypes;
        if (referenceBindingArray != null && referenceBindingArray != Binding.NO_MEMBER_TYPES) {
            n2 = 0;
            int n3 = referenceBindingArray.length;
            while (n2 < n3) {
                ((SourceTypeBinding)referenceBindingArray[n2]).scope.checkParameterizedTypeBounds();
                ++n2;
            }
        }
    }

    private void connectMemberTypes() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.memberTypes;
        if (referenceBindingArray != null && referenceBindingArray != Binding.NO_MEMBER_TYPES) {
            int n = 0;
            int n2 = referenceBindingArray.length;
            while (n < n2) {
                ((SourceTypeBinding)referenceBindingArray[n]).scope.connectTypeHierarchy();
                ++n;
            }
        }
    }

    private boolean connectSuperclass() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (sourceTypeBinding.id == 1) {
            sourceTypeBinding.setSuperClass(null);
            sourceTypeBinding.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
            if (!sourceTypeBinding.isClass()) {
                this.problemReporter().objectMustBeClass(sourceTypeBinding);
            }
            if (this.referenceContext.superclass != null || this.referenceContext.superInterfaces != null && this.referenceContext.superInterfaces.length > 0) {
                this.problemReporter().objectCannotHaveSuperTypes(sourceTypeBinding);
            }
            return true;
        }
        if (this.referenceContext.superclass == null) {
            if (sourceTypeBinding.isEnum() && this.compilerOptions().sourceLevel >= 0x310000L) {
                return this.connectEnumSuperclass();
            }
            sourceTypeBinding.setSuperClass(this.getJavaLangObject());
            return !this.detectHierarchyCycle(sourceTypeBinding, sourceTypeBinding.superclass, null);
        }
        TypeReference typeReference = this.referenceContext.superclass;
        ReferenceBinding referenceBinding = this.findSupertype(typeReference);
        if (referenceBinding != null) {
            if (!referenceBinding.isClass() && (referenceBinding.tagBits & 0x80L) == 0L) {
                this.problemReporter().superclassMustBeAClass(sourceTypeBinding, typeReference, referenceBinding);
            } else if (referenceBinding.isFinal()) {
                this.problemReporter().classExtendFinalClass(sourceTypeBinding, typeReference, referenceBinding);
            } else if ((referenceBinding.tagBits & 0x40000000L) != 0L) {
                this.problemReporter().superTypeCannotUseWildcard(sourceTypeBinding, typeReference, referenceBinding);
            } else if (referenceBinding.erasure().id == 41) {
                this.problemReporter().cannotExtendEnum(sourceTypeBinding, typeReference, referenceBinding);
            } else {
                if ((referenceBinding.tagBits & 0x20000L) != 0L || !typeReference.resolvedType.isValidBinding()) {
                    sourceTypeBinding.setSuperClass(referenceBinding);
                    sourceTypeBinding.tagBits |= 0x20000L;
                    return typeReference.resolvedType.isValidBinding();
                }
                sourceTypeBinding.setSuperClass(referenceBinding);
                sourceTypeBinding.typeBits |= referenceBinding.typeBits & 0x13;
                if ((sourceTypeBinding.typeBits & 3) != 0) {
                    sourceTypeBinding.typeBits |= sourceTypeBinding.applyCloseableClassWhitelists();
                }
                return true;
            }
        }
        sourceTypeBinding.tagBits |= 0x20000L;
        sourceTypeBinding.setSuperClass(this.getJavaLangObject());
        if ((sourceTypeBinding.superclass.tagBits & 0x100L) == 0L) {
            this.detectHierarchyCycle(sourceTypeBinding, sourceTypeBinding.superclass, null);
        }
        return false;
    }

    private boolean connectEnumSuperclass() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding referenceBinding = this.getJavaLangEnum();
        if ((referenceBinding.tagBits & 0x80L) != 0L) {
            sourceTypeBinding.tagBits |= 0x20000L;
            sourceTypeBinding.setSuperClass(referenceBinding);
            return false;
        }
        boolean bl = this.detectHierarchyCycle(sourceTypeBinding, referenceBinding, null);
        TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
        if (typeVariableBindingArray == Binding.NO_TYPE_VARIABLES) {
            this.problemReporter().nonGenericTypeCannotBeParameterized(0, null, referenceBinding, new TypeBinding[]{sourceTypeBinding});
            return false;
        }
        if (1 != typeVariableBindingArray.length) {
            this.problemReporter().incorrectArityForParameterizedType(null, referenceBinding, new TypeBinding[]{sourceTypeBinding});
            return false;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = this.environment().createParameterizedType(referenceBinding, new TypeBinding[]{this.environment().convertToRawType(sourceTypeBinding, false)}, null);
        sourceTypeBinding.tagBits |= parameterizedTypeBinding.tagBits & 0x20000L;
        sourceTypeBinding.setSuperClass(parameterizedTypeBinding);
        if (typeVariableBindingArray[0].boundCheck(parameterizedTypeBinding, sourceTypeBinding, this) != 0) {
            this.problemReporter().typeMismatchError((TypeBinding)referenceBinding, typeVariableBindingArray[0], sourceTypeBinding, null);
        }
        return !bl;
    }

    private boolean connectSuperInterfaces() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        sourceTypeBinding.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
        if (this.referenceContext.superInterfaces == null) {
            if (sourceTypeBinding.isAnnotationType() && this.compilerOptions().sourceLevel >= 0x310000L) {
                ReferenceBinding referenceBinding = this.getJavaLangAnnotationAnnotation();
                boolean bl = this.detectHierarchyCycle(sourceTypeBinding, referenceBinding, null);
                sourceTypeBinding.setSuperInterfaces(new ReferenceBinding[]{referenceBinding});
                return !bl;
            }
            return true;
        }
        if (sourceTypeBinding.id == 1) {
            return true;
        }
        boolean bl = true;
        int n = this.referenceContext.superInterfaces.length;
        ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            block17: {
                TypeReference typeReference = this.referenceContext.superInterfaces[n3];
                ReferenceBinding referenceBinding = this.findSupertype(typeReference);
                if (referenceBinding == null) {
                    sourceTypeBinding.tagBits |= 0x20000L;
                    bl = false;
                } else {
                    int n4 = 0;
                    while (n4 < n3) {
                        if (TypeBinding.equalsEquals(referenceBindingArray[n4], referenceBinding)) {
                            this.problemReporter().duplicateSuperinterface(sourceTypeBinding, typeReference, referenceBinding);
                            sourceTypeBinding.tagBits |= 0x20000L;
                            bl = false;
                            break block17;
                        }
                        ++n4;
                    }
                    if (!referenceBinding.isInterface() && (referenceBinding.tagBits & 0x80L) == 0L) {
                        this.problemReporter().superinterfaceMustBeAnInterface(sourceTypeBinding, typeReference, referenceBinding);
                        sourceTypeBinding.tagBits |= 0x20000L;
                        bl = false;
                    } else {
                        if (referenceBinding.isAnnotationType()) {
                            this.problemReporter().annotationTypeUsedAsSuperinterface(sourceTypeBinding, typeReference, referenceBinding);
                        }
                        if ((referenceBinding.tagBits & 0x40000000L) != 0L) {
                            this.problemReporter().superTypeCannotUseWildcard(sourceTypeBinding, typeReference, referenceBinding);
                            sourceTypeBinding.tagBits |= 0x20000L;
                            bl = false;
                        } else {
                            if ((referenceBinding.tagBits & 0x20000L) != 0L || !typeReference.resolvedType.isValidBinding()) {
                                sourceTypeBinding.tagBits |= 0x20000L;
                                bl &= typeReference.resolvedType.isValidBinding();
                            }
                            sourceTypeBinding.typeBits |= referenceBinding.typeBits & 0x13;
                            if ((sourceTypeBinding.typeBits & 3) != 0) {
                                sourceTypeBinding.typeBits |= sourceTypeBinding.applyCloseableInterfaceWhitelists();
                            }
                            referenceBindingArray[n2++] = referenceBinding;
                        }
                    }
                }
            }
            ++n3;
        }
        if (n2 > 0) {
            if (n2 != n) {
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2];
                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n2);
            }
            sourceTypeBinding.setSuperInterfaces(referenceBindingArray);
        }
        return bl;
    }

    void connectTypeHierarchy() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if ((sourceTypeBinding.tagBits & 0x100L) == 0L) {
            sourceTypeBinding.tagBits |= 0x100L;
            this.environment().typesBeingConnected.add(sourceTypeBinding);
            boolean bl = this.connectSuperclass();
            bl &= this.connectSuperInterfaces();
            this.environment().typesBeingConnected.remove(sourceTypeBinding);
            sourceTypeBinding.tagBits |= 0x200L;
            sourceTypeBinding.tagBits |= 0x40000L;
            if ((bl &= this.connectTypeVariables(this.referenceContext.typeParameters, false)) && sourceTypeBinding.isHierarchyInconsistent()) {
                this.problemReporter().hierarchyHasProblems(sourceTypeBinding);
            }
        }
        this.connectMemberTypes();
        LookupEnvironment lookupEnvironment = this.environment();
        try {
            try {
                lookupEnvironment.missingClassFileLocation = this.referenceContext;
                this.checkForInheritedMemberTypes(sourceTypeBinding);
            }
            catch (AbortCompilation abortCompilation) {
                abortCompilation.updateContext(this.referenceContext, this.referenceCompilationUnit().compilationResult);
                throw abortCompilation;
            }
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    public boolean deferCheck(Runnable runnable) {
        if (this.compilationUnitScope().connectingHierarchy) {
            if (this.deferredBoundChecks == null) {
                this.deferredBoundChecks = new ArrayList();
            }
            this.deferredBoundChecks.add(runnable);
            return true;
        }
        return false;
    }

    private void connectTypeHierarchyWithoutMembers() {
        if (this.parent instanceof CompilationUnitScope) {
            if (((CompilationUnitScope)this.parent).imports == null) {
                ((CompilationUnitScope)this.parent).checkAndSetImports();
            }
        } else if (this.parent instanceof ClassScope) {
            ((ClassScope)this.parent).connectTypeHierarchyWithoutMembers();
        }
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if ((sourceTypeBinding.tagBits & 0x100L) != 0L) {
            return;
        }
        sourceTypeBinding.tagBits |= 0x100L;
        this.environment().typesBeingConnected.add(sourceTypeBinding);
        boolean bl = this.connectSuperclass();
        bl &= this.connectSuperInterfaces();
        this.environment().typesBeingConnected.remove(sourceTypeBinding);
        sourceTypeBinding.tagBits |= 0x200L;
        sourceTypeBinding.tagBits |= 0x40000L;
        if ((bl &= this.connectTypeVariables(this.referenceContext.typeParameters, false)) && sourceTypeBinding.isHierarchyInconsistent()) {
            this.problemReporter().hierarchyHasProblems(sourceTypeBinding);
        }
    }

    public boolean detectHierarchyCycle(TypeBinding typeBinding, TypeReference typeReference) {
        if (!(typeBinding instanceof ReferenceBinding)) {
            return false;
        }
        if (typeReference == this.superTypeReference) {
            if (typeBinding.isTypeVariable()) {
                return false;
            }
            if (typeBinding.isParameterizedType()) {
                typeBinding = ((ParameterizedTypeBinding)typeBinding).genericType();
            }
            this.compilationUnitScope().recordSuperTypeReference(typeBinding);
            return this.detectHierarchyCycle(this.referenceContext.binding, (ReferenceBinding)typeBinding, typeReference);
        }
        if ((typeBinding.tagBits & 0x100L) == 0L && typeBinding instanceof SourceTypeBinding) {
            ((SourceTypeBinding)typeBinding).scope.connectTypeHierarchyWithoutMembers();
        }
        return false;
    }

    private boolean detectHierarchyCycle(SourceTypeBinding sourceTypeBinding, ReferenceBinding referenceBinding, TypeReference typeReference) {
        Object object;
        if (referenceBinding.isRawType()) {
            referenceBinding = ((RawTypeBinding)referenceBinding).genericType();
        }
        if (TypeBinding.equalsEquals(sourceTypeBinding, referenceBinding)) {
            this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
            sourceTypeBinding.tagBits |= 0x20000L;
            return true;
        }
        if (referenceBinding.isMemberType()) {
            object = referenceBinding.enclosingType();
            do {
                if (!((ReferenceBinding)object).isHierarchyBeingActivelyConnected() || !TypeBinding.equalsEquals((TypeBinding)object, sourceTypeBinding)) continue;
                this.problemReporter().hierarchyCircularity(sourceTypeBinding, (ReferenceBinding)object, typeReference);
                sourceTypeBinding.tagBits |= 0x20000L;
                ((ReferenceBinding)object).tagBits |= 0x20000L;
                return true;
            } while ((object = ((TypeBinding)object).enclosingType()) != null);
        }
        if (referenceBinding.isBinaryBinding()) {
            ReferenceBinding[] referenceBindingArray;
            boolean bl = false;
            ReferenceBinding referenceBinding2 = referenceBinding.superclass();
            if (referenceBinding2 != null) {
                if (TypeBinding.equalsEquals(sourceTypeBinding, referenceBinding2)) {
                    this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
                    sourceTypeBinding.tagBits |= 0x20000L;
                    referenceBinding.tagBits |= 0x20000L;
                    return true;
                }
                if (referenceBinding2.isParameterizedType()) {
                    referenceBinding2 = ((ParameterizedTypeBinding)referenceBinding2).genericType();
                }
                bl |= this.detectHierarchyCycle(sourceTypeBinding, referenceBinding2, typeReference);
                if ((referenceBinding2.tagBits & 0x20000L) != 0L) {
                    sourceTypeBinding.tagBits |= 0x20000L;
                    referenceBinding2.tagBits |= 0x20000L;
                }
            }
            if ((referenceBindingArray = referenceBinding.superInterfaces()) != null && referenceBindingArray != Binding.NO_SUPERINTERFACES) {
                int n = 0;
                int n2 = referenceBindingArray.length;
                while (n < n2) {
                    ReferenceBinding referenceBinding3 = referenceBindingArray[n];
                    if (TypeBinding.equalsEquals(sourceTypeBinding, referenceBinding3)) {
                        this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
                        sourceTypeBinding.tagBits |= 0x20000L;
                        referenceBinding.tagBits |= 0x20000L;
                        return true;
                    }
                    if (referenceBinding3.isParameterizedType()) {
                        referenceBinding3 = ((ParameterizedTypeBinding)referenceBinding3).genericType();
                    }
                    bl |= this.detectHierarchyCycle(sourceTypeBinding, referenceBinding3, typeReference);
                    if ((referenceBinding3.tagBits & 0x20000L) != 0L) {
                        sourceTypeBinding.tagBits |= 0x20000L;
                        referenceBinding.tagBits |= 0x20000L;
                    }
                    ++n;
                }
            }
            return bl;
        }
        if (referenceBinding.isHierarchyBeingActivelyConnected()) {
            object = ((SourceTypeBinding)referenceBinding).scope.superTypeReference;
            if (object != null && ((TypeReference)object).resolvedType != null && ((ReferenceBinding)((TypeReference)object).resolvedType).isHierarchyBeingActivelyConnected()) {
                this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
                sourceTypeBinding.tagBits |= 0x20000L;
                referenceBinding.tagBits |= 0x20000L;
                return true;
            }
            if (object != null && ((TypeReference)object).resolvedType == null) {
                char[] cArray = ((TypeReference)object).getLastToken();
                for (SourceTypeBinding sourceTypeBinding2 : this.environment().typesBeingConnected) {
                    if (!CharOperation.equals(cArray, sourceTypeBinding2.sourceName())) continue;
                    this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
                    sourceTypeBinding.tagBits |= 0x20000L;
                    referenceBinding.tagBits |= 0x20000L;
                    return true;
                }
            }
        }
        if ((referenceBinding.tagBits & 0x100L) == 0L) {
            ((SourceTypeBinding)referenceBinding).scope.connectTypeHierarchyWithoutMembers();
        }
        if ((referenceBinding.tagBits & 0x20000L) != 0L) {
            sourceTypeBinding.tagBits |= 0x20000L;
        }
        return false;
    }

    private ReferenceBinding findSupertype(TypeReference typeReference) {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        LookupEnvironment lookupEnvironment = compilationUnitScope.environment;
        try {
            ReferenceBinding referenceBinding;
            lookupEnvironment.missingClassFileLocation = typeReference;
            typeReference.aboutToResolve(this);
            compilationUnitScope.recordQualifiedReference(typeReference.getTypeName());
            this.superTypeReference = typeReference;
            ReferenceBinding referenceBinding2 = referenceBinding = (ReferenceBinding)typeReference.resolveSuperType(this);
            return referenceBinding2;
        }
        catch (AbortCompilation abortCompilation) {
            SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
            if (sourceTypeBinding.superInterfaces == null) {
                sourceTypeBinding.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
            }
            abortCompilation.updateContext(typeReference, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
            this.superTypeReference = null;
        }
    }

    public ProblemReporter problemReporter() {
        MethodScope methodScope = this.outerMostMethodScope();
        if (methodScope == null) {
            ProblemReporter problemReporter = this.referenceCompilationUnit().problemReporter;
            problemReporter.referenceContext = this.referenceContext;
            return problemReporter;
        }
        return methodScope.problemReporter();
    }

    public TypeDeclaration referenceType() {
        return this.referenceContext;
    }

    public boolean hasDefaultNullnessFor(int n) {
        int n2;
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (sourceTypeBinding != null && (n2 = sourceTypeBinding.getNullDefault()) != 0) {
            return (n2 & n) != 0;
        }
        return this.parent.hasDefaultNullnessFor(n);
    }

    public String toString() {
        if (this.referenceContext != null) {
            return "--- Class Scope ---\n\n" + this.referenceContext.binding.toString();
        }
        return "--- Class Scope ---\n\n Binding not initialized";
    }
}

