/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionCastTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class CaptureBinding18
extends CaptureBinding {
    TypeBinding[] upperBounds;
    private char[] originalName;
    int recursionLevel = 0;

    public CaptureBinding18(ReferenceBinding referenceBinding, char[] cArray, char[] cArray2, int n, int n2, LookupEnvironment lookupEnvironment) {
        super(referenceBinding, cArray, n, n2, lookupEnvironment);
        this.originalName = cArray2;
    }

    public boolean setUpperBounds(TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding) {
        this.upperBounds = typeBindingArray;
        if (typeBindingArray.length > 0) {
            this.firstBound = typeBindingArray[0];
        }
        int n = 0;
        if (!CaptureBinding18.isConsistentIntersection(typeBindingArray)) {
            return false;
        }
        int n2 = 0;
        while (n2 < typeBindingArray.length) {
            TypeBinding typeBinding = typeBindingArray[n2];
            if (typeBinding instanceof ReferenceBinding) {
                if (this.superclass == null && typeBinding.isClass()) {
                    this.superclass = (ReferenceBinding)typeBinding;
                } else if (typeBinding.isInterface()) {
                    ++n;
                }
            }
            ++n2;
        }
        this.superInterfaces = new ReferenceBinding[n];
        n2 = 0;
        int n3 = 0;
        while (n3 < typeBindingArray.length) {
            TypeBinding typeBinding = typeBindingArray[n3];
            if (typeBinding.isInterface()) {
                this.superInterfaces[n2++] = (ReferenceBinding)typeBinding;
            }
            ++n3;
        }
        if (this.superclass == null) {
            this.superclass = referenceBinding;
        }
        return true;
    }

    public void initializeBounds(Scope scope, ParameterizedTypeBinding parameterizedTypeBinding) {
    }

    public TypeBinding clone(TypeBinding typeBinding) {
        return new CaptureBinding18(this.sourceType, CharOperation.append(this.sourceName, '\''), this.originalName, this.position, this.captureID, this.environment);
    }

    public MethodBinding[] getMethods(char[] cArray) {
        if (this.upperBounds.length == 1 && this.upperBounds[0] instanceof ReferenceBinding) {
            return ((ReferenceBinding)this.upperBounds[0]).getMethods(cArray);
        }
        return super.getMethods(cArray);
    }

    public TypeBinding erasure() {
        if (this.upperBounds != null && this.upperBounds.length > 1) {
            ReferenceBinding[] referenceBindingArray = new ReferenceBinding[this.upperBounds.length];
            boolean bl = false;
            int n = 0;
            while (n < this.upperBounds.length) {
                referenceBindingArray[n] = (ReferenceBinding)this.upperBounds[n].erasure();
                if (n > 0 && TypeBinding.notEquals(referenceBindingArray[0], referenceBindingArray[n])) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                return referenceBindingArray[0];
            }
            return new IntersectionCastTypeBinding(referenceBindingArray, this.environment);
        }
        return super.erasure();
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (CaptureBinding18.equalsEquals(this, typeBinding)) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        if (this.upperBounds != null) {
            int n = 0;
            while (n < this.upperBounds.length) {
                TypeBinding typeBinding2 = this.upperBounds[n];
                if (typeBinding2 == null || !typeBinding2.isArrayType() || typeBinding2.isCompatibleWith(typeBinding)) {
                    switch (typeBinding.kind()) {
                        case 516: 
                        case 8196: {
                            if (((WildcardBinding)typeBinding).boundCheck(typeBinding2)) break;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (this.inRecursiveFunction) {
            return true;
        }
        this.inRecursiveFunction = true;
        try {
            if (this.upperBounds != null) {
                int n = 0;
                while (n < this.upperBounds.length) {
                    if (this.upperBounds[n].isCompatibleWith(typeBinding, scope)) {
                        return true;
                    }
                    ++n;
                }
            }
            boolean bl = super.isCompatibleWith(typeBinding, scope);
            return bl;
        }
        finally {
            this.inRecursiveFunction = false;
        }
    }

    public TypeBinding findSuperTypeOriginatingFrom(TypeBinding typeBinding) {
        if (this.upperBounds != null && this.upperBounds.length > 1) {
            int n = 0;
            while (n < this.upperBounds.length) {
                TypeBinding typeBinding2 = this.upperBounds[n].findSuperTypeOriginatingFrom(typeBinding);
                if (typeBinding2 != null) {
                    return typeBinding2;
                }
                ++n;
            }
        }
        return super.findSuperTypeOriginatingFrom(typeBinding);
    }

    TypeBinding substituteInferenceVariable(InferenceVariable inferenceVariable, TypeBinding typeBinding) {
        if (this.inRecursiveFunction) {
            return this;
        }
        this.inRecursiveFunction = true;
        try {
            int n;
            boolean bl = false;
            ReferenceBinding referenceBinding = this.superclass;
            if (referenceBinding != null) {
                referenceBinding = (ReferenceBinding)referenceBinding.substituteInferenceVariable(inferenceVariable, typeBinding);
                bl |= TypeBinding.notEquals(referenceBinding, this.superclass);
            }
            ReferenceBinding[] referenceBindingArray = null;
            if (this.superInterfaces != null) {
                int n2 = this.superInterfaces.length;
                if (bl) {
                    referenceBindingArray = new ReferenceBinding[n2];
                    System.arraycopy(this.superInterfaces, 0, referenceBindingArray, 0, n2);
                }
                n = 0;
                while (n < n2) {
                    ReferenceBinding referenceBinding2 = this.superInterfaces[n];
                    if (referenceBinding2 != null && TypeBinding.notEquals(referenceBinding2 = (ReferenceBinding)referenceBinding2.substituteInferenceVariable(inferenceVariable, typeBinding), this.superInterfaces[n])) {
                        if (referenceBindingArray == null) {
                            referenceBindingArray = new ReferenceBinding[n2];
                            System.arraycopy(this.superInterfaces, 0, referenceBindingArray, 0, n2);
                        }
                        referenceBindingArray[n] = referenceBinding2;
                        bl = true;
                    }
                    ++n;
                }
            }
            TypeBinding[] typeBindingArray = null;
            if (this.upperBounds != null) {
                n = this.upperBounds.length;
                if (bl) {
                    typeBindingArray = new TypeBinding[n];
                    System.arraycopy(this.upperBounds, 0, typeBindingArray, 0, n);
                }
                int n3 = 0;
                while (n3 < n) {
                    TypeBinding typeBinding2 = this.upperBounds[n3];
                    if (typeBinding2 != null && TypeBinding.notEquals(typeBinding2 = typeBinding2.substituteInferenceVariable(inferenceVariable, typeBinding), this.upperBounds[n3])) {
                        if (typeBindingArray == null) {
                            typeBindingArray = new TypeBinding[n];
                            System.arraycopy(this.upperBounds, 0, typeBindingArray, 0, n);
                        }
                        typeBindingArray[n3] = typeBinding2;
                        bl = true;
                    }
                    ++n3;
                }
            }
            if (bl) {
                final CaptureBinding18 captureBinding18 = (CaptureBinding18)this.clone(this.enclosingType());
                captureBinding18.tagBits = this.tagBits;
                Substitution substitution = new Substitution(){

                    public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
                        return typeVariableBinding == CaptureBinding18.this ? captureBinding18 : typeVariableBinding;
                    }

                    public boolean isRawSubstitution() {
                        return false;
                    }

                    public LookupEnvironment environment() {
                        return CaptureBinding18.this.environment;
                    }
                };
                captureBinding18.superclass = (ReferenceBinding)Scope.substitute(substitution, referenceBinding);
                captureBinding18.superInterfaces = Scope.substitute(substitution, referenceBindingArray);
                captureBinding18.upperBounds = Scope.substitute(substitution, typeBindingArray);
                CaptureBinding18 captureBinding182 = captureBinding18;
                return captureBinding182;
            }
            CaptureBinding18 captureBinding18 = this;
            return captureBinding18;
        }
        finally {
            this.inRecursiveFunction = false;
        }
    }

    public boolean isProperType(boolean bl) {
        if (!bl) {
            return false;
        }
        if (this.inRecursiveFunction) {
            return true;
        }
        this.inRecursiveFunction = true;
        try {
            if (this.lowerBound != null && !this.lowerBound.isProperType(bl)) {
                return false;
            }
            if (this.upperBounds != null) {
                int n = 0;
                while (n < this.upperBounds.length) {
                    if (!this.upperBounds[n].isProperType(bl)) {
                        return false;
                    }
                    ++n;
                }
            }
        }
        finally {
            this.inRecursiveFunction = false;
        }
        return true;
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            try {
                char[] cArray = this.recursionLevel++ > 0 || this.firstBound == null ? TypeConstants.WILDCARD_STAR : (this.upperBounds != null ? CharOperation.concat(TypeConstants.WILDCARD_PLUS, this.firstBound.genericTypeSignature()) : (this.lowerBound != null ? CharOperation.concat(TypeConstants.WILDCARD_MINUS, this.lowerBound.genericTypeSignature()) : TypeConstants.WILDCARD_STAR));
                this.genericTypeSignature = CharOperation.concat(TypeConstants.WILDCARD_CAPTURE, cArray);
            }
            finally {
                --this.recursionLevel;
            }
        }
        return this.genericTypeSignature;
    }

    public char[] readableName() {
        if (this.lowerBound == null && this.firstBound != null) {
            if (this.recursionLevel < 2) {
                try {
                    ++this.recursionLevel;
                    if (this.upperBounds != null && this.upperBounds.length > 1) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(this.upperBounds[0].readableName());
                        int n = 1;
                        while (n < this.upperBounds.length) {
                            stringBuffer.append('&').append(this.upperBounds[n].readableName());
                            ++n;
                        }
                        n = stringBuffer.length();
                        char[] cArray = new char[n];
                        stringBuffer.getChars(0, n, cArray, 0);
                        char[] cArray2 = cArray;
                        return cArray2;
                    }
                    char[] cArray = this.firstBound.readableName();
                    return cArray;
                }
                finally {
                    --this.recursionLevel;
                }
            }
            return this.originalName;
        }
        return super.readableName();
    }

    public char[] shortReadableName() {
        if (this.lowerBound == null && this.firstBound != null) {
            if (this.recursionLevel < 2) {
                try {
                    ++this.recursionLevel;
                    if (this.upperBounds != null && this.upperBounds.length > 1) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(this.upperBounds[0].shortReadableName());
                        int n = 1;
                        while (n < this.upperBounds.length) {
                            stringBuffer.append('&').append(this.upperBounds[n].shortReadableName());
                            ++n;
                        }
                        n = stringBuffer.length();
                        char[] cArray = new char[n];
                        stringBuffer.getChars(0, n, cArray, 0);
                        char[] cArray2 = cArray;
                        return cArray2;
                    }
                    char[] cArray = this.firstBound.shortReadableName();
                    return cArray;
                }
                finally {
                    --this.recursionLevel;
                }
            }
            return this.originalName;
        }
        return super.shortReadableName();
    }

    public TypeBinding uncapture(Scope scope) {
        return this;
    }

    public char[] computeUniqueKey(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TypeConstants.CAPTURE18);
        stringBuffer.append('{').append(this.position).append('#').append(this.captureID).append('}');
        stringBuffer.append(';');
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }
}

