/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class CaptureBinding
extends TypeVariableBinding {
    public TypeBinding lowerBound;
    public WildcardBinding wildcard;
    public int captureID;
    public ReferenceBinding sourceType;
    public int position;

    public CaptureBinding(WildcardBinding wildcardBinding, ReferenceBinding referenceBinding, int n, int n2) {
        super(TypeConstants.WILDCARD_CAPTURE_NAME_PREFIX, null, 0, wildcardBinding.environment);
        this.wildcard = wildcardBinding;
        this.modifiers = 0x40000001;
        this.fPackage = wildcardBinding.fPackage;
        this.sourceType = referenceBinding;
        this.position = n;
        this.captureID = n2;
        this.tagBits |= 0x2000000000000000L;
        if (wildcardBinding.hasTypeAnnotations()) {
            this.setTypeAnnotations(wildcardBinding.getTypeAnnotations(), wildcardBinding.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled);
            if (wildcardBinding.hasNullTypeAnnotations()) {
                this.tagBits |= 0x100000L;
            }
        }
    }

    protected CaptureBinding(ReferenceBinding referenceBinding, char[] cArray, int n, int n2, LookupEnvironment lookupEnvironment) {
        super(cArray, null, 0, lookupEnvironment);
        this.modifiers = 0x40000001;
        this.sourceType = referenceBinding;
        this.position = n;
        this.captureID = n2;
    }

    public CaptureBinding(CaptureBinding captureBinding) {
        super(captureBinding);
        this.wildcard = captureBinding.wildcard;
        this.sourceType = captureBinding.sourceType;
        this.position = captureBinding.position;
        this.captureID = captureBinding.captureID;
        this.lowerBound = captureBinding.lowerBound;
        this.tagBits |= captureBinding.tagBits & 0x2000000000000000L;
    }

    public TypeBinding clone(TypeBinding typeBinding) {
        return new CaptureBinding(this);
    }

    public char[] computeUniqueKey(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(this.sourceType.computeUniqueKey(false));
            stringBuffer.append('&');
        }
        stringBuffer.append(TypeConstants.WILDCARD_CAPTURE);
        stringBuffer.append(this.wildcard.computeUniqueKey(false));
        stringBuffer.append(this.position);
        stringBuffer.append(';');
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    public String debugName() {
        if (this.wildcard != null) {
            StringBuffer stringBuffer = new StringBuffer(10);
            AnnotationBinding[] annotationBindingArray = this.getTypeAnnotations();
            int n = 0;
            int n2 = annotationBindingArray == null ? 0 : annotationBindingArray.length;
            while (n < n2) {
                stringBuffer.append(annotationBindingArray[n]);
                stringBuffer.append(' ');
                ++n;
            }
            stringBuffer.append(TypeConstants.WILDCARD_CAPTURE_NAME_PREFIX).append(this.captureID).append(TypeConstants.WILDCARD_CAPTURE_NAME_SUFFIX).append(this.wildcard.debugName());
            return stringBuffer.toString();
        }
        return super.debugName();
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            this.genericTypeSignature = CharOperation.concat(TypeConstants.WILDCARD_CAPTURE, this.wildcard.genericTypeSignature());
        }
        return this.genericTypeSignature;
    }

    public void initializeBounds(Scope scope, ParameterizedTypeBinding parameterizedTypeBinding) {
        ReferenceBinding[] referenceBindingArray;
        ReferenceBinding[] referenceBindingArray2;
        TypeVariableBinding typeVariableBinding = this.wildcard.typeVariable();
        if (typeVariableBinding == null) {
            TypeBinding typeBinding = this.wildcard.bound;
            switch (this.wildcard.boundKind) {
                case 1: {
                    TypeBinding typeBinding2 = typeBinding.capture(scope, this.position);
                    if (typeBinding.isInterface()) {
                        this.setSuperClass(scope.getJavaLangObject());
                        this.setSuperInterfaces(new ReferenceBinding[]{(ReferenceBinding)typeBinding2});
                    } else {
                        if (typeBinding2.isArrayType() || TypeBinding.equalsEquals(typeBinding2, this)) {
                            this.setSuperClass(scope.getJavaLangObject());
                        } else {
                            this.setSuperClass((ReferenceBinding)typeBinding2);
                        }
                        this.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
                    }
                    this.setFirstBound(typeBinding2);
                    if ((typeBinding2.tagBits & 0x20000000L) != 0L) break;
                    this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                    break;
                }
                case 0: {
                    this.setSuperClass(scope.getJavaLangObject());
                    this.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
                    this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                    break;
                }
                case 2: {
                    this.setSuperClass(scope.getJavaLangObject());
                    this.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
                    this.lowerBound = this.wildcard.bound;
                    if ((typeBinding.tagBits & 0x20000000L) != 0L) break;
                    this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                }
            }
            return;
        }
        ReferenceBinding referenceBinding = typeVariableBinding.superclass;
        ReferenceBinding referenceBinding2 = (ReferenceBinding)Scope.substitute((Substitution)parameterizedTypeBinding, referenceBinding);
        if (TypeBinding.equalsEquals(referenceBinding2, this)) {
            referenceBinding2 = referenceBinding;
        }
        if ((referenceBindingArray2 = Scope.substitute((Substitution)parameterizedTypeBinding, referenceBindingArray = typeVariableBinding.superInterfaces())) != referenceBindingArray) {
            int n = 0;
            int n2 = referenceBindingArray2.length;
            while (n < n2) {
                if (TypeBinding.equalsEquals(referenceBindingArray2[n], this)) {
                    referenceBindingArray2[n] = referenceBindingArray[n];
                }
                ++n;
            }
        }
        TypeBinding typeBinding = this.wildcard.bound;
        switch (this.wildcard.boundKind) {
            case 1: {
                TypeBinding typeBinding3 = typeBinding.capture(scope, this.position);
                if (typeBinding.isInterface()) {
                    this.setSuperClass(referenceBinding2);
                    if (referenceBindingArray2 == Binding.NO_SUPERINTERFACES) {
                        this.setSuperInterfaces(new ReferenceBinding[]{(ReferenceBinding)typeBinding3});
                    } else {
                        int n = referenceBindingArray2.length;
                        ReferenceBinding[] referenceBindingArray3 = referenceBindingArray2;
                        referenceBindingArray2 = new ReferenceBinding[n + 1];
                        System.arraycopy(referenceBindingArray3, 0, referenceBindingArray2, 1, n);
                        referenceBindingArray2[0] = (ReferenceBinding)typeBinding3;
                        this.setSuperInterfaces(Scope.greaterLowerBound(referenceBindingArray2));
                    }
                } else {
                    if (typeBinding3.isArrayType() || TypeBinding.equalsEquals(typeBinding3, this)) {
                        this.setSuperClass(referenceBinding2);
                    } else {
                        this.setSuperClass((ReferenceBinding)typeBinding3);
                        if (this.superclass.isSuperclassOf(referenceBinding2)) {
                            this.setSuperClass(referenceBinding2);
                        }
                    }
                    this.setSuperInterfaces(referenceBindingArray2);
                }
                this.setFirstBound(typeBinding3);
                if ((typeBinding3.tagBits & 0x20000000L) != 0L) break;
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                break;
            }
            case 0: {
                this.setSuperClass(referenceBinding2);
                this.setSuperInterfaces(referenceBindingArray2);
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                break;
            }
            case 2: {
                this.setSuperClass(referenceBinding2);
                if (TypeBinding.equalsEquals(typeVariableBinding.firstBound, referenceBinding2) || TypeBinding.equalsEquals(typeBinding, referenceBinding2)) {
                    this.setFirstBound(referenceBinding2);
                }
                this.setSuperInterfaces(referenceBindingArray2);
                this.lowerBound = typeBinding;
                if ((typeBinding.tagBits & 0x20000000L) != 0L) break;
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
            }
        }
    }

    public boolean isCapture() {
        return true;
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (CaptureBinding.equalsEquals(this, typeBinding)) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        if (this.firstBound != null && this.firstBound.isArrayType() && this.firstBound.isCompatibleWith(typeBinding)) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
        }
        return false;
    }

    public char[] readableName() {
        if (this.wildcard != null) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(TypeConstants.WILDCARD_CAPTURE_NAME_PREFIX).append(this.captureID).append(TypeConstants.WILDCARD_CAPTURE_NAME_SUFFIX).append(this.wildcard.readableName());
            int n = stringBuffer.length();
            char[] cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
            return cArray;
        }
        return super.readableName();
    }

    public char[] shortReadableName() {
        if (this.wildcard != null) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(TypeConstants.WILDCARD_CAPTURE_NAME_PREFIX).append(this.captureID).append(TypeConstants.WILDCARD_CAPTURE_NAME_SUFFIX).append(this.wildcard.shortReadableName());
            int n = stringBuffer.length();
            char[] cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
            return cArray;
        }
        return super.shortReadableName();
    }

    public char[] nullAnnotatedReadableName(CompilerOptions compilerOptions, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(10);
        this.appendNullAnnotation(stringBuffer, compilerOptions);
        stringBuffer.append(this.sourceName());
        if (!this.inRecursiveFunction) {
            this.inRecursiveFunction = true;
            try {
                if (this.wildcard != null) {
                    stringBuffer.append("of ");
                    stringBuffer.append(this.wildcard.nullAnnotatedReadableName(compilerOptions, bl));
                } else if (this.lowerBound != null) {
                    stringBuffer.append(" super ");
                    stringBuffer.append(this.lowerBound.nullAnnotatedReadableName(compilerOptions, bl));
                } else if (this.firstBound != null) {
                    stringBuffer.append(" extends ");
                    stringBuffer.append(this.firstBound.nullAnnotatedReadableName(compilerOptions, bl));
                    TypeBinding[] typeBindingArray = this.otherUpperBounds();
                    if (typeBindingArray != NO_TYPES) {
                        stringBuffer.append(" & ...");
                    }
                }
            }
            finally {
                this.inRecursiveFunction = false;
            }
        }
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    public TypeBinding uncapture(Scope scope) {
        return this.wildcard;
    }

    public String toString() {
        if (this.wildcard != null) {
            StringBuffer stringBuffer = new StringBuffer(10);
            AnnotationBinding[] annotationBindingArray = this.getTypeAnnotations();
            int n = 0;
            int n2 = annotationBindingArray == null ? 0 : annotationBindingArray.length;
            while (n < n2) {
                stringBuffer.append(annotationBindingArray[n]);
                stringBuffer.append(' ');
                ++n;
            }
            stringBuffer.append(TypeConstants.WILDCARD_CAPTURE_NAME_PREFIX).append(this.captureID).append(TypeConstants.WILDCARD_CAPTURE_NAME_SUFFIX).append(this.wildcard);
            return stringBuffer.toString();
        }
        return super.toString();
    }
}

