/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.classfmt.NonNullDefaultAwareTypeAnnotationWalker;
import org.eclipse.jdt.internal.compiler.classfmt.TypeAnnotationWalker;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.env.ClassSignature;
import org.eclipse.jdt.internal.compiler.env.EnumConstantSignature;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;

public class BinaryTypeBinding
extends ReferenceBinding {
    private static final IBinaryMethod[] NO_BINARY_METHODS = new IBinaryMethod[0];
    protected ReferenceBinding superclass;
    protected ReferenceBinding enclosingType;
    protected ReferenceBinding[] superInterfaces;
    protected FieldBinding[] fields;
    protected MethodBinding[] methods;
    protected ReferenceBinding[] memberTypes;
    protected TypeVariableBinding[] typeVariables;
    private BinaryTypeBinding prototype;
    protected LookupEnvironment environment;
    protected SimpleLookupTable storedAnnotations = null;
    private ReferenceBinding containerAnnotationType;
    int defaultNullness = 0;

    static Object convertMemberValue(Object object, LookupEnvironment lookupEnvironment, char[][][] cArray, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof Constant) {
            return object;
        }
        if (object instanceof ClassSignature) {
            return lookupEnvironment.getTypeFromSignature(((ClassSignature)object).getTypeName(), 0, -1, false, null, cArray, TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER);
        }
        if (object instanceof IBinaryAnnotation) {
            return BinaryTypeBinding.createAnnotation((IBinaryAnnotation)object, lookupEnvironment, cArray);
        }
        if (object instanceof EnumConstantSignature) {
            EnumConstantSignature enumConstantSignature = (EnumConstantSignature)object;
            ReferenceBinding referenceBinding = (ReferenceBinding)lookupEnvironment.getTypeFromSignature(enumConstantSignature.getTypeName(), 0, -1, false, null, cArray, TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER);
            if (referenceBinding.isUnresolvedType() && !bl) {
                return new ElementValuePair.UnresolvedEnumConstant(referenceBinding, lookupEnvironment, enumConstantSignature.getEnumConstantName());
            }
            referenceBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding, lookupEnvironment, false);
            return referenceBinding.getField(enumConstantSignature.getEnumConstantName(), false);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            if (n == 0) {
                return objectArray;
            }
            Object[] objectArray2 = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                objectArray2[n2] = BinaryTypeBinding.convertMemberValue(objectArray[n2], lookupEnvironment, cArray, bl);
                ++n2;
            }
            return objectArray2;
        }
        throw new IllegalStateException();
    }

    public TypeBinding clone(TypeBinding typeBinding) {
        BinaryTypeBinding binaryTypeBinding = new BinaryTypeBinding(this);
        binaryTypeBinding.enclosingType = (ReferenceBinding)typeBinding;
        binaryTypeBinding.tagBits = binaryTypeBinding.enclosingType != null ? (binaryTypeBinding.tagBits |= 0x8000000L) : (binaryTypeBinding.tagBits &= 0xFFFFFFFFF7FFFFFFL);
        binaryTypeBinding.tagBits |= 0x10000000L;
        return binaryTypeBinding;
    }

    static AnnotationBinding createAnnotation(IBinaryAnnotation iBinaryAnnotation, LookupEnvironment lookupEnvironment, char[][][] cArray) {
        IBinaryElementValuePair[] iBinaryElementValuePairArray = iBinaryAnnotation.getElementValuePairs();
        int n = iBinaryElementValuePairArray == null ? 0 : iBinaryElementValuePairArray.length;
        ElementValuePair[] elementValuePairArray = n == 0 ? Binding.NO_ELEMENT_VALUE_PAIRS : new ElementValuePair[n];
        int n2 = 0;
        while (n2 < n) {
            elementValuePairArray[n2] = new ElementValuePair(iBinaryElementValuePairArray[n2].getName(), BinaryTypeBinding.convertMemberValue(iBinaryElementValuePairArray[n2].getValue(), lookupEnvironment, cArray, false), null);
            ++n2;
        }
        char[] cArray2 = iBinaryAnnotation.getTypeName();
        ReferenceBinding referenceBinding = lookupEnvironment.getTypeFromConstantPoolName(cArray2, 1, cArray2.length - 1, false, cArray);
        return lookupEnvironment.createUnresolvedAnnotation(referenceBinding, elementValuePairArray);
    }

    public static AnnotationBinding[] createAnnotations(IBinaryAnnotation[] iBinaryAnnotationArray, LookupEnvironment lookupEnvironment, char[][][] cArray) {
        int n = iBinaryAnnotationArray == null ? 0 : iBinaryAnnotationArray.length;
        AnnotationBinding[] annotationBindingArray = n == 0 ? Binding.NO_ANNOTATIONS : new AnnotationBinding[n];
        int n2 = 0;
        while (n2 < n) {
            annotationBindingArray[n2] = BinaryTypeBinding.createAnnotation(iBinaryAnnotationArray[n2], lookupEnvironment, cArray);
            ++n2;
        }
        return annotationBindingArray;
    }

    public static TypeBinding resolveType(TypeBinding typeBinding, LookupEnvironment lookupEnvironment, boolean bl) {
        switch (typeBinding.kind()) {
            case 260: {
                ((ParameterizedTypeBinding)typeBinding).resolve();
                break;
            }
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).resolve();
            }
            case 68: {
                BinaryTypeBinding.resolveType(((ArrayBinding)typeBinding).leafComponentType, lookupEnvironment, bl);
                break;
            }
            case 4100: {
                ((TypeVariableBinding)typeBinding).resolve();
                break;
            }
            case 2052: {
                if (!bl) break;
                return lookupEnvironment.convertUnresolvedBinaryToRawType(typeBinding);
            }
            default: {
                if (typeBinding instanceof UnresolvedReferenceBinding) {
                    return ((UnresolvedReferenceBinding)typeBinding).resolve(lookupEnvironment, bl);
                }
                if (!bl) break;
                return lookupEnvironment.convertUnresolvedBinaryToRawType(typeBinding);
            }
        }
        return typeBinding;
    }

    protected BinaryTypeBinding() {
        this.prototype = this;
    }

    public BinaryTypeBinding(BinaryTypeBinding binaryTypeBinding) {
        super(binaryTypeBinding);
        this.superclass = binaryTypeBinding.superclass;
        this.enclosingType = binaryTypeBinding.enclosingType;
        this.superInterfaces = binaryTypeBinding.superInterfaces;
        this.fields = binaryTypeBinding.fields;
        this.methods = binaryTypeBinding.methods;
        this.memberTypes = binaryTypeBinding.memberTypes;
        this.typeVariables = binaryTypeBinding.typeVariables;
        this.prototype = binaryTypeBinding.prototype;
        this.environment = binaryTypeBinding.environment;
        this.storedAnnotations = binaryTypeBinding.storedAnnotations;
    }

    public BinaryTypeBinding(PackageBinding packageBinding, IBinaryType iBinaryType, LookupEnvironment lookupEnvironment) {
        this(packageBinding, iBinaryType, lookupEnvironment, false);
    }

    public BinaryTypeBinding(PackageBinding packageBinding, IBinaryType iBinaryType, LookupEnvironment lookupEnvironment, boolean bl) {
        this.prototype = this;
        this.compoundName = CharOperation.splitOn('/', iBinaryType.getName());
        this.computeId();
        this.tagBits |= 0x40L;
        this.environment = lookupEnvironment;
        this.fPackage = packageBinding;
        this.fileName = iBinaryType.getFileName();
        char[] cArray = iBinaryType.getGenericSignature();
        this.typeVariables = cArray != null && cArray.length > 0 && cArray[0] == '<' ? null : Binding.NO_TYPE_VARIABLES;
        this.sourceName = iBinaryType.getSourceName();
        this.modifiers = iBinaryType.getModifiers();
        if ((iBinaryType.getTagBits() & 0x20000L) != 0L) {
            this.tagBits |= 0x20000L;
        }
        if (iBinaryType.isAnonymous()) {
            this.tagBits |= 0x834L;
        } else if (iBinaryType.isLocal()) {
            this.tagBits |= 0x814L;
        } else if (iBinaryType.isMember()) {
            this.tagBits |= 0x80CL;
        }
        char[] cArray2 = iBinaryType.getEnclosingTypeName();
        if (cArray2 != null) {
            this.enclosingType = lookupEnvironment.getTypeFromConstantPoolName(cArray2, 0, -1, true, null);
            this.tagBits |= 0x80CL;
            this.tagBits |= 0x8000000L;
            if (this.enclosingType().isStrictfp()) {
                this.modifiers |= 0x800;
            }
            if (this.enclosingType().isDeprecated()) {
                this.modifiers |= 0x200000;
            }
        }
        if (bl) {
            this.cachePartsFrom(iBinaryType, true);
        }
    }

    public FieldBinding[] availableFields() {
        if (!this.isPrototype()) {
            return this.prototype.availableFields();
        }
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.fields;
        }
        if ((this.tagBits & 0x1000L) == 0L) {
            int n = this.fields.length;
            if (n > 1) {
                ReferenceBinding.sortFields(this.fields, 0, n);
            }
            this.tagBits |= 0x1000L;
        }
        FieldBinding[] fieldBindingArray = new FieldBinding[this.fields.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.fields.length) {
            try {
                fieldBindingArray[n] = this.resolveTypeFor(this.fields[n2]);
                ++n;
            }
            catch (AbortCompilation abortCompilation) {}
            ++n2;
        }
        if (n < fieldBindingArray.length) {
            FieldBinding[] fieldBindingArray2 = fieldBindingArray;
            fieldBindingArray = new FieldBinding[n];
            System.arraycopy(fieldBindingArray2, 0, fieldBindingArray, 0, n);
        }
        return fieldBindingArray;
    }

    private TypeVariableBinding[] addMethodTypeVariables(TypeVariableBinding[] typeVariableBindingArray) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.typeVariables == null || this.typeVariables == Binding.NO_TYPE_VARIABLES) {
            return typeVariableBindingArray;
        }
        if (typeVariableBindingArray == null || typeVariableBindingArray == Binding.NO_TYPE_VARIABLES) {
            return this.typeVariables;
        }
        int n = this.typeVariables.length + typeVariableBindingArray.length;
        TypeVariableBinding[] typeVariableBindingArray2 = new TypeVariableBinding[n];
        System.arraycopy(this.typeVariables, 0, typeVariableBindingArray2, 0, this.typeVariables.length);
        int n2 = this.typeVariables.length;
        int n3 = 0;
        int n4 = typeVariableBindingArray.length;
        while (n3 < n4) {
            block7: {
                int n5 = this.typeVariables.length - 1;
                while (n5 >= 0) {
                    if (!CharOperation.equals(typeVariableBindingArray[n3].sourceName, this.typeVariables[n5].sourceName)) {
                        --n5;
                        continue;
                    }
                    break block7;
                }
                typeVariableBindingArray2[n2++] = typeVariableBindingArray[n3];
            }
            ++n3;
        }
        if (n2 != n) {
            TypeVariableBinding[] typeVariableBindingArray3 = typeVariableBindingArray2;
            typeVariableBindingArray2 = new TypeVariableBinding[n2];
            System.arraycopy(typeVariableBindingArray3, 0, typeVariableBindingArray2, 0, n2);
        }
        return typeVariableBindingArray2;
    }

    public MethodBinding[] availableMethods() {
        if (!this.isPrototype()) {
            return this.prototype.availableMethods();
        }
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.methods;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int n = this.methods.length;
            if (n > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n);
            }
            this.tagBits |= 0x4000L;
        }
        MethodBinding[] methodBindingArray = new MethodBinding[this.methods.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.methods.length) {
            try {
                methodBindingArray[n] = this.resolveTypesFor(this.methods[n2]);
                ++n;
            }
            catch (AbortCompilation abortCompilation) {}
            ++n2;
        }
        if (n < methodBindingArray.length) {
            MethodBinding[] methodBindingArray2 = methodBindingArray;
            methodBindingArray = new MethodBinding[n];
            System.arraycopy(methodBindingArray2, 0, methodBindingArray, 0, n);
        }
        return methodBindingArray;
    }

    void cachePartsFrom(IBinaryType iBinaryType, boolean bl) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        try {
            int n;
            int n2;
            Object object;
            Object object2;
            int n3;
            this.typeVariables = Binding.NO_TYPE_VARIABLES;
            this.superInterfaces = Binding.NO_SUPERINTERFACES;
            this.memberTypes = Binding.NO_MEMBER_TYPES;
            IBinaryNestedType[] iBinaryNestedTypeArray = iBinaryType.getMemberTypes();
            if (iBinaryNestedTypeArray != null && (n3 = iBinaryNestedTypeArray.length) > 0) {
                this.memberTypes = new ReferenceBinding[n3];
                int n4 = 0;
                while (n4 < n3) {
                    this.memberTypes[n4] = this.environment.getTypeFromConstantPoolName(iBinaryNestedTypeArray[n4].getName(), 0, -1, false, null);
                    ++n4;
                }
                this.tagBits |= 0x10000000L;
            }
            CompilerOptions compilerOptions = this.environment.globalOptions;
            long l = compilerOptions.originalSourceLevel;
            if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
                this.scanTypeForNullDefaultAnnotation(iBinaryType, this.fPackage, this);
            }
            TypeAnnotationWalker typeAnnotationWalker = this.getTypeAnnotationWalker(iBinaryType.getTypeAnnotations());
            char[] cArray = iBinaryType.getGenericSignature();
            this.tagBits |= iBinaryType.getTagBits();
            char[][][] cArray2 = iBinaryType.getMissingTypeNames();
            SignatureWrapper signatureWrapper = null;
            if (cArray != null) {
                signatureWrapper = new SignatureWrapper(cArray);
                if (signatureWrapper.signature[signatureWrapper.start] == '<') {
                    ++signatureWrapper.start;
                    this.typeVariables = this.createTypeVariables(signatureWrapper, true, cArray2, typeAnnotationWalker, true);
                    ++signatureWrapper.start;
                    this.tagBits |= 0x1000000L;
                    this.modifiers |= 0x40000000;
                }
            }
            TypeVariableBinding[] typeVariableBindingArray = Binding.NO_TYPE_VARIABLES;
            char[] cArray3 = iBinaryType.getEnclosingMethod();
            if (cArray3 != null && (object2 = this.findMethod(cArray3, cArray2)) != null) {
                typeVariableBindingArray = ((MethodBinding)object2).typeVariables;
                this.typeVariables = this.addMethodTypeVariables(typeVariableBindingArray);
            }
            if (cArray == null) {
                object2 = iBinaryType.getSuperclassName();
                if (object2 != null) {
                    this.superclass = this.environment.getTypeFromConstantPoolName((char[])object2, 0, -1, false, cArray2, typeAnnotationWalker.toSupertype((short)-1));
                    this.tagBits |= 0x2000000L;
                }
                this.superInterfaces = Binding.NO_SUPERINTERFACES;
                object = iBinaryType.getInterfaceNames();
                if (object != null && (n2 = ((char[][])object).length) > 0) {
                    this.superInterfaces = new ReferenceBinding[n2];
                    n = 0;
                    while (n < n2) {
                        this.superInterfaces[n] = this.environment.getTypeFromConstantPoolName(object[n], 0, -1, false, cArray2, typeAnnotationWalker.toSupertype((short)n));
                        n = (short)(n + 1);
                    }
                    this.tagBits |= 0x4000000L;
                }
            } else {
                this.superclass = (ReferenceBinding)this.environment.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, this, cArray2, typeAnnotationWalker.toSupertype((short)-1));
                this.tagBits |= 0x2000000L;
                this.superInterfaces = Binding.NO_SUPERINTERFACES;
                if (!signatureWrapper.atEnd()) {
                    object2 = new ArrayList(2);
                    short s = 0;
                    do {
                        short s2 = s;
                        s = (short)(s2 + 1);
                        ((ArrayList)object2).add(this.environment.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, this, cArray2, typeAnnotationWalker.toSupertype(s2)));
                    } while (!signatureWrapper.atEnd());
                    this.superInterfaces = new ReferenceBinding[((ArrayList)object2).size()];
                    ((ArrayList)object2).toArray(this.superInterfaces);
                    this.tagBits |= 0x4000000L;
                }
            }
            if (bl) {
                object2 = iBinaryType.getFields();
                this.createFields((IBinaryField[])object2, l, cArray2);
                object = this.createMethods(iBinaryType.getMethods(), l, cArray2);
                n2 = this.isViewedAsDeprecated() ? 1 : 0;
                if (n2 != 0) {
                    Binding binding;
                    n = 0;
                    int n5 = this.fields.length;
                    while (n < n5) {
                        binding = this.fields[n];
                        if (!((FieldBinding)binding).isDeprecated()) {
                            ((FieldBinding)binding).modifiers |= 0x200000;
                        }
                        ++n;
                    }
                    n = 0;
                    n5 = this.methods.length;
                    while (n < n5) {
                        binding = this.methods[n];
                        if (!((MethodBinding)binding).isDeprecated()) {
                            ((MethodBinding)binding).modifiers |= 0x200000;
                        }
                        ++n;
                    }
                }
                if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
                    if (object2 != null) {
                        n = 0;
                        while (n < ((IBinaryField[])object2).length) {
                            this.scanFieldForNullAnnotation((IBinaryField)object2[n], this.fields[n], this.isEnum());
                            ++n;
                        }
                    }
                    if (object != null) {
                        n = 0;
                        while (n < ((char[][])object).length) {
                            this.scanMethodForNullAnnotation((IBinaryMethod)object[n], this.methods[n]);
                            ++n;
                        }
                    }
                }
            }
            if (this.environment.globalOptions.storeAnnotations) {
                this.setAnnotations(BinaryTypeBinding.createAnnotations(iBinaryType.getAnnotations(), this.environment, cArray2));
            }
            if (this.isAnnotationType()) {
                this.scanTypeForContainerAnnotation(iBinaryType, cArray2);
            }
        }
        finally {
            if (this.fields == null) {
                this.fields = Binding.NO_FIELDS;
            }
            if (this.methods == null) {
                this.methods = Binding.NO_METHODS;
            }
        }
    }

    private TypeAnnotationWalker getTypeAnnotationWalker(IBinaryTypeAnnotation[] iBinaryTypeAnnotationArray) {
        int n;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (iBinaryTypeAnnotationArray == null || iBinaryTypeAnnotationArray.length == 0 || !this.environment.usesAnnotatedTypeSystem()) {
            int n2;
            if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled && (n2 = this.getNullDefault()) > 2) {
                return new NonNullDefaultAwareTypeAnnotationWalker(n2, this.environment);
            }
            return TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
        }
        if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled && (n = this.getNullDefault()) > 2) {
            return new NonNullDefaultAwareTypeAnnotationWalker(iBinaryTypeAnnotationArray, n, this.environment);
        }
        return new TypeAnnotationWalker(iBinaryTypeAnnotationArray);
    }

    private void createFields(IBinaryField[] iBinaryFieldArray, long l, char[][][] cArray) {
        int n;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        this.fields = Binding.NO_FIELDS;
        if (iBinaryFieldArray != null && (n = iBinaryFieldArray.length) > 0) {
            IBinaryField iBinaryField;
            this.fields = new FieldBinding[n];
            boolean bl = l >= 0x310000L;
            boolean bl2 = this.hasRestrictedAccess();
            int n2 = -1;
            int n3 = 0;
            while (n3 < n) {
                iBinaryField = iBinaryFieldArray[n3];
                char[] cArray2 = bl ? iBinaryField.getGenericSignature() : null;
                TypeAnnotationWalker typeAnnotationWalker = this.getTypeAnnotationWalker(iBinaryField.getTypeAnnotations()).toField();
                TypeBinding typeBinding = cArray2 == null ? this.environment.getTypeFromSignature(iBinaryField.getTypeName(), 0, -1, false, this, cArray, typeAnnotationWalker) : this.environment.getTypeFromTypeSignature(new SignatureWrapper(cArray2), Binding.NO_TYPE_VARIABLES, this, cArray, typeAnnotationWalker);
                FieldBinding fieldBinding = new FieldBinding(iBinaryField.getName(), typeBinding, iBinaryField.getModifiers() | 0x2000000, this, iBinaryField.getConstant());
                if (n2 < 0 && this.environment.globalOptions.storeAnnotations && iBinaryField.getAnnotations() != null) {
                    n2 = n3;
                }
                fieldBinding.id = n3;
                if (bl) {
                    fieldBinding.tagBits |= iBinaryField.getTagBits();
                }
                if (bl2) {
                    fieldBinding.modifiers |= 0x40000;
                }
                if (cArray2 != null) {
                    fieldBinding.modifiers |= 0x40000000;
                }
                this.fields[n3] = fieldBinding;
                ++n3;
            }
            if (n2 >= 0) {
                n3 = n2;
                while (n3 < n) {
                    iBinaryField = iBinaryFieldArray[n3];
                    this.fields[n3].setAnnotations(BinaryTypeBinding.createAnnotations(iBinaryField.getAnnotations(), this.environment, cArray));
                    ++n3;
                }
            }
        }
    }

    private MethodBinding createMethod(IBinaryMethod iBinaryMethod, long l, char[][][] cArray) {
        int n;
        Object object;
        int n2;
        Object object2;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        int n3 = iBinaryMethod.getModifiers() | 0x2000000;
        if (l < 0x310000L) {
            n3 &= 0xFFFFFF7F;
        }
        if (this.isInterface() && (n3 & 0x400) == 0 && (n3 & 8) == 0) {
            n3 |= 0x10000;
        }
        ReferenceBinding[] referenceBindingArray = Binding.NO_EXCEPTIONS;
        TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
        TypeVariableBinding[] typeVariableBindingArray = Binding.NO_TYPE_VARIABLES;
        AnnotationBinding[][] annotationBindingArray = null;
        TypeBinding typeBinding = null;
        Object object3 = iBinaryMethod.getArgumentNames();
        boolean bl = l >= 0x310000L;
        TypeAnnotationWalker typeAnnotationWalker = this.getTypeAnnotationWalker(iBinaryMethod.getTypeAnnotations());
        char[] cArray2 = iBinaryMethod.getGenericSignature();
        if (cArray2 == null) {
            char[][] cArray3;
            int n4;
            int n5;
            object2 = iBinaryMethod.getMethodDescriptor();
            int n6 = 0;
            n2 = 0;
            while ((object = object2[++n2]) != 41) {
                if (object == 91) continue;
                ++n6;
                if (object != 76) continue;
                while ((object = object2[++n2]) != 59) {
                }
            }
            n = 0;
            if (iBinaryMethod.isConstructor()) {
                if (this.isMemberType() && !this.isStatic()) {
                    ++n;
                }
                if (this.isEnum()) {
                    n += 2;
                }
            }
            if ((n5 = n6 - n) > 0) {
                typeBindingArray = new TypeBinding[n5];
                if (this.environment.globalOptions.storeAnnotations) {
                    annotationBindingArray = new AnnotationBinding[n5][];
                }
                n2 = 1;
                short s = 0;
                n4 = 0;
                int n7 = 0;
                while (n7 < n6) {
                    Object object4;
                    do {
                        object4 = object2[++n4];
                        object = object4;
                    } while (object4 == 91);
                    if (object == 76) {
                        Object object5;
                        do {
                            object5 = object2[++n4];
                            object = object5;
                        } while (object5 != 59);
                    }
                    if (n7 >= n) {
                        short s2 = s;
                        s = (short)(s2 + 1);
                        typeBindingArray[n7 - n] = this.environment.getTypeFromSignature((char[])object2, n2, n4, false, this, cArray, typeAnnotationWalker.toMethodParameter(s2));
                        if (annotationBindingArray != null) {
                            annotationBindingArray[n7 - n] = BinaryTypeBinding.createAnnotations(iBinaryMethod.getParameterAnnotations(n7 - n), this.environment, cArray);
                        }
                    }
                    n2 = n4 + 1;
                    ++n7;
                }
            }
            if ((cArray3 = iBinaryMethod.getExceptionTypeNames()) != null && (n5 = cArray3.length) > 0) {
                referenceBindingArray = new ReferenceBinding[n5];
                n4 = 0;
                while (n4 < n5) {
                    referenceBindingArray[n4] = this.environment.getTypeFromConstantPoolName(cArray3[n4], 0, -1, false, cArray, typeAnnotationWalker.toThrows(n4));
                    ++n4;
                }
            }
            if (!iBinaryMethod.isConstructor()) {
                typeBinding = this.environment.getTypeFromSignature((char[])object2, n2 + 1, -1, false, this, cArray, typeAnnotationWalker.toMethodReturn());
            }
            int n8 = n4 = object3 == null ? 0 : ((char[][])object3).length;
            if (n > 0 && n4 > 0) {
                if (n >= n4) {
                    object3 = Binding.NO_PARAMETER_NAMES;
                } else {
                    char[][] cArrayArray = new char[n4 - n][];
                    System.arraycopy(object3, n, cArrayArray, 0, n4 - n);
                    object3 = cArrayArray;
                }
            }
        } else {
            Object object6;
            n3 |= 0x40000000;
            object2 = new SignatureWrapper(cArray2, bl);
            if (((SignatureWrapper)object2).signature[((SignatureWrapper)object2).start] == '<') {
                ++((SignatureWrapper)object2).start;
                typeVariableBindingArray = this.createTypeVariables((SignatureWrapper)object2, false, cArray, typeAnnotationWalker, false);
                ++((SignatureWrapper)object2).start;
            }
            if (((SignatureWrapper)object2).signature[((SignatureWrapper)object2).start] == '(') {
                ++((SignatureWrapper)object2).start;
                if (((SignatureWrapper)object2).signature[((SignatureWrapper)object2).start] == ')') {
                    ++((SignatureWrapper)object2).start;
                } else {
                    object6 = new ArrayList(2);
                    object = 0;
                    while (((SignatureWrapper)object2).signature[((SignatureWrapper)object2).start] != ')') {
                        short s = object;
                        object = (short)(s + 1);
                        object6.add(this.environment.getTypeFromTypeSignature((SignatureWrapper)object2, typeVariableBindingArray, this, cArray, typeAnnotationWalker.toMethodParameter(s)));
                    }
                    ++((SignatureWrapper)object2).start;
                    n2 = object6.size();
                    typeBindingArray = new TypeBinding[n2];
                    object6.toArray(typeBindingArray);
                    if (this.environment.globalOptions.storeAnnotations) {
                        annotationBindingArray = new AnnotationBinding[n2][];
                        n = 0;
                        while (n < n2) {
                            annotationBindingArray[n] = BinaryTypeBinding.createAnnotations(iBinaryMethod.getParameterAnnotations(n), this.environment, cArray);
                            ++n;
                        }
                    }
                }
            }
            typeBinding = this.environment.getTypeFromTypeSignature((SignatureWrapper)object2, typeVariableBindingArray, this, cArray, typeAnnotationWalker.toMethodReturn());
            if (!((SignatureWrapper)object2).atEnd() && ((SignatureWrapper)object2).signature[((SignatureWrapper)object2).start] == '^') {
                object6 = new ArrayList(2);
                object = 0;
                do {
                    ++((SignatureWrapper)object2).start;
                    object6.add(this.environment.getTypeFromTypeSignature((SignatureWrapper)object2, typeVariableBindingArray, this, cArray, typeAnnotationWalker.toThrows((int)object++)));
                } while (!((SignatureWrapper)object2).atEnd() && ((SignatureWrapper)object2).signature[((SignatureWrapper)object2).start] == '^');
                referenceBindingArray = new ReferenceBinding[object6.size()];
                object6.toArray(referenceBindingArray);
            } else {
                object6 = iBinaryMethod.getExceptionTypeNames();
                if (object6 != null && (object = ((char[][])object6).length) > 0) {
                    referenceBindingArray = new ReferenceBinding[object];
                    n2 = 0;
                    while (n2 < object) {
                        referenceBindingArray[n2] = this.environment.getTypeFromConstantPoolName((char[])object6[n2], 0, -1, false, cArray, typeAnnotationWalker.toThrows(n2));
                        ++n2;
                    }
                }
            }
        }
        object2 = iBinaryMethod.isConstructor() ? new MethodBinding(n3, typeBindingArray, referenceBindingArray, this) : new MethodBinding(n3, iBinaryMethod.getSelector(), typeBinding, typeBindingArray, referenceBindingArray, this);
        IBinaryAnnotation[] iBinaryAnnotationArray = typeAnnotationWalker.toReceiver().getAnnotationsAtCursor();
        if (iBinaryAnnotationArray != null && iBinaryAnnotationArray.length > 0) {
            ((MethodBinding)object2).receiver = this.environment.createAnnotatedType((TypeBinding)this, BinaryTypeBinding.createAnnotations(iBinaryAnnotationArray, this.environment, cArray));
        }
        if (this.environment.globalOptions.storeAnnotations) {
            IBinaryAnnotation[] iBinaryAnnotationArray2 = iBinaryMethod.getAnnotations();
            if ((iBinaryAnnotationArray2 == null || iBinaryAnnotationArray2.length == 0) && iBinaryMethod.isConstructor()) {
                iBinaryAnnotationArray2 = typeAnnotationWalker.toMethodReturn().getAnnotationsAtCursor();
            }
            ((MethodBinding)object2).setAnnotations(BinaryTypeBinding.createAnnotations(iBinaryAnnotationArray2, this.environment, cArray), annotationBindingArray, this.isAnnotationType() ? BinaryTypeBinding.convertMemberValue(iBinaryMethod.getDefaultValue(), this.environment, cArray, true) : null, this.environment);
        }
        if (object3 != null) {
            ((MethodBinding)object2).parameterNames = object3;
        }
        if (bl) {
            ((MethodBinding)object2).tagBits |= iBinaryMethod.getTagBits();
        }
        ((MethodBinding)object2).typeVariables = typeVariableBindingArray;
        int n9 = 0;
        n2 = typeVariableBindingArray.length;
        while (n9 < n2) {
            typeVariableBindingArray[n9].declaringElement = object2;
            ++n9;
        }
        return object2;
    }

    private IBinaryMethod[] createMethods(IBinaryMethod[] iBinaryMethodArray, long l, char[][][] cArray) {
        Object object;
        int n;
        boolean bl;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int[] nArray = null;
        if (iBinaryMethodArray != null) {
            n2 = n3 = iBinaryMethodArray.length;
            bl = l < 0x310000L;
            n = n2;
            while (--n >= 0) {
                char[] cArray2;
                object = iBinaryMethodArray[n];
                if ((object.getModifiers() & 0x1000) != 0) {
                    if (bl && (object.getModifiers() & 0x40) != 0) continue;
                    if (nArray == null) {
                        nArray = new int[iBinaryMethodArray.length];
                    }
                    nArray[n] = -1;
                    --n2;
                    continue;
                }
                if (n4 != -1 || (cArray2 = object.getSelector()).length != 8 || cArray2[0] != '<') continue;
                n4 = n;
                --n2;
            }
        }
        if (n2 == 0) {
            this.methods = Binding.NO_METHODS;
            return NO_BINARY_METHODS;
        }
        bl = this.hasRestrictedAccess();
        this.methods = new MethodBinding[n2];
        if (n2 == n3) {
            n = 0;
            while (n < n3) {
                object = this.createMethod(iBinaryMethodArray[n], l, cArray);
                if (bl) {
                    ((MethodBinding)object).modifiers |= 0x40000;
                }
                this.methods[n] = object;
                ++n;
            }
            return iBinaryMethodArray;
        }
        IBinaryMethod[] iBinaryMethodArray2 = new IBinaryMethod[n2];
        int n5 = 0;
        int n6 = 0;
        while (n5 < n3) {
            if (n4 != n5 && (nArray == null || nArray[n5] != -1)) {
                MethodBinding methodBinding = this.createMethod(iBinaryMethodArray[n5], l, cArray);
                if (bl) {
                    methodBinding.modifiers |= 0x40000;
                }
                iBinaryMethodArray2[n6] = iBinaryMethodArray[n5];
                this.methods[n6++] = methodBinding;
            }
            ++n5;
        }
        return iBinaryMethodArray2;
    }

    private TypeVariableBinding[] createTypeVariables(SignatureWrapper signatureWrapper, boolean bl, char[][][] cArray, TypeAnnotationWalker typeAnnotationWalker, boolean bl2) {
        int n;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        char[] cArray2 = signatureWrapper.signature;
        int n2 = 0;
        int n3 = cArray2.length;
        int n4 = 0;
        ArrayList<TypeVariableBinding> arrayList = new ArrayList<TypeVariableBinding>(1);
        n2 = 0;
        boolean bl3 = true;
        int n5 = 1;
        block5: while (n5 < n3) {
            switch (cArray2[n5]) {
                case '<': {
                    ++n2;
                    break;
                }
                case '>': {
                    if (--n2 >= 0) break;
                    break block5;
                }
                case ';': {
                    if (n2 != 0 || n5 + 1 >= n3 || cArray2[n5 + 1] == ':') break;
                    bl3 = true;
                    break;
                }
                default: {
                    AnnotationBinding[] annotationBindingArray;
                    if (!bl3) break;
                    bl3 = false;
                    n = CharOperation.indexOf(':', cArray2, n5);
                    char[] cArray3 = CharOperation.subarray(cArray2, n5, n);
                    TypeVariableBinding typeVariableBinding = new TypeVariableBinding(cArray3, this, n4, this.environment);
                    if ((annotationBindingArray = BinaryTypeBinding.createAnnotations(typeAnnotationWalker.toTypeParameter(bl2, n4++).getAnnotationsAtCursor(), this.environment, cArray)) != null && annotationBindingArray != Binding.NO_ANNOTATIONS) {
                        typeVariableBinding.setTypeAnnotations(annotationBindingArray, this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled);
                    }
                    arrayList.add(typeVariableBinding);
                }
            }
            ++n5;
        }
        TypeVariableBinding[] typeVariableBindingArray = new TypeVariableBinding[n4];
        arrayList.toArray(typeVariableBindingArray);
        if (bl) {
            this.typeVariables = typeVariableBindingArray;
        }
        n = 0;
        while (n < n4) {
            this.initializeTypeVariable(typeVariableBindingArray[n], typeVariableBindingArray, signatureWrapper, cArray, typeAnnotationWalker.toTypeParameterBounds(bl2, n));
            ++n;
        }
        return typeVariableBindingArray;
    }

    public ReferenceBinding enclosingType() {
        if ((this.tagBits & 0x8000000L) == 0L) {
            return this.enclosingType;
        }
        this.enclosingType = (ReferenceBinding)BinaryTypeBinding.resolveType(this.enclosingType, this.environment, false);
        this.tagBits &= 0xFFFFFFFFF7FFFFFFL;
        return this.enclosingType;
    }

    public FieldBinding[] fields() {
        int n;
        if (!this.isPrototype()) {
            this.fields = this.prototype.fields();
            return this.fields;
        }
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.fields;
        }
        if ((this.tagBits & 0x1000L) == 0L) {
            n = this.fields.length;
            if (n > 1) {
                ReferenceBinding.sortFields(this.fields, 0, n);
            }
            this.tagBits |= 0x1000L;
        }
        n = this.fields.length;
        while (--n >= 0) {
            this.resolveTypeFor(this.fields[n]);
        }
        this.tagBits |= 0x2000L;
        return this.fields;
    }

    private MethodBinding findMethod(char[] cArray, char[][][] cArray2) {
        int n;
        char c;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        int n2 = -1;
        while (cArray[++n2] != '(') {
        }
        char[] cArray3 = new char[n2];
        System.arraycopy(cArray, 0, cArray3, 0, n2);
        TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
        int n3 = 0;
        int n4 = n2;
        while ((c = cArray[++n2]) != ')') {
            if (c == '[') continue;
            ++n3;
            if (c != 'L') continue;
            while ((c = cArray[++n2]) != ';') {
            }
        }
        if (n3 > 0) {
            typeBindingArray = new TypeBinding[n3];
            n2 = n4 + 1;
            n = n4;
            int n5 = 0;
            while (n5 < n3) {
                TypeBinding typeBinding;
                while ((c = cArray[++n]) == '[') {
                }
                if (c == 'L') {
                    while ((c = cArray[++n]) != ';') {
                    }
                }
                if ((typeBinding = this.environment.getTypeFromSignature(cArray, n2, n, false, this, cArray2, TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER)) instanceof UnresolvedReferenceBinding) {
                    typeBinding = BinaryTypeBinding.resolveType(typeBinding, this.environment, true);
                }
                typeBindingArray[n5] = typeBinding;
                n2 = n + 1;
                ++n5;
            }
        }
        n = typeBindingArray.length;
        MethodBinding[] methodBindingArray = this.enclosingType.getMethods(cArray3, n);
        int n6 = 0;
        int n7 = methodBindingArray.length;
        while (n6 < n7) {
            block14: {
                MethodBinding methodBinding = methodBindingArray[n6];
                TypeBinding[] typeBindingArray2 = methodBinding.parameters;
                int n8 = typeBindingArray2.length;
                if (n == n8) {
                    int n9 = 0;
                    while (n9 < n8) {
                        if (!TypeBinding.notEquals(typeBindingArray[n9], typeBindingArray2[n9]) || !TypeBinding.notEquals(typeBindingArray[n9].erasure(), typeBindingArray2[n9].erasure())) {
                            ++n9;
                            continue;
                        }
                        break block14;
                    }
                    return methodBinding;
                }
            }
            ++n6;
        }
        return null;
    }

    public char[] genericTypeSignature() {
        if (!this.isPrototype()) {
            return this.prototype.computeGenericTypeSignature(this.typeVariables);
        }
        return this.computeGenericTypeSignature(this.typeVariables);
    }

    public MethodBinding getExactConstructor(TypeBinding[] typeBindingArray) {
        int n;
        if (!this.isPrototype()) {
            return this.prototype.getExactConstructor(typeBindingArray);
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            n = this.methods.length;
            if (n > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n);
            }
            this.tagBits |= 0x4000L;
        }
        n = typeBindingArray.length;
        long l = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods);
        if (l >= 0L) {
            int n2 = (int)l;
            int n3 = (int)(l >> 32);
            while (n2 <= n3) {
                block8: {
                    MethodBinding methodBinding = this.methods[n2];
                    if (methodBinding.parameters.length == n) {
                        this.resolveTypesFor(methodBinding);
                        TypeBinding[] typeBindingArray2 = methodBinding.parameters;
                        int n4 = 0;
                        while (n4 < n) {
                            if (!TypeBinding.notEquals(typeBindingArray2[n4], typeBindingArray[n4])) {
                                ++n4;
                                continue;
                            }
                            break block8;
                        }
                        return methodBinding;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public MethodBinding getExactMethod(char[] cArray, TypeBinding[] typeBindingArray, CompilationUnitScope compilationUnitScope) {
        int n;
        if (!this.isPrototype()) {
            return this.prototype.getExactMethod(cArray, typeBindingArray, compilationUnitScope);
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            n = this.methods.length;
            if (n > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n);
            }
            this.tagBits |= 0x4000L;
        }
        n = typeBindingArray.length;
        boolean bl = true;
        long l = ReferenceBinding.binarySearch(cArray, this.methods);
        if (l >= 0L) {
            int n2 = (int)l;
            int n3 = (int)(l >> 32);
            while (n2 <= n3) {
                block15: {
                    MethodBinding methodBinding = this.methods[n2];
                    bl = false;
                    if (methodBinding.parameters.length == n) {
                        this.resolveTypesFor(methodBinding);
                        TypeBinding[] typeBindingArray2 = methodBinding.parameters;
                        int n4 = 0;
                        while (n4 < n) {
                            if (!TypeBinding.notEquals(typeBindingArray2[n4], typeBindingArray[n4])) {
                                ++n4;
                                continue;
                            }
                            break block15;
                        }
                        return methodBinding;
                    }
                }
                ++n2;
            }
        }
        if (bl) {
            if (this.isInterface()) {
                if (this.superInterfaces().length == 1) {
                    if (compilationUnitScope != null) {
                        compilationUnitScope.recordTypeReference(this.superInterfaces[0]);
                    }
                    return this.superInterfaces[0].getExactMethod(cArray, typeBindingArray, compilationUnitScope);
                }
            } else if (this.superclass() != null) {
                if (compilationUnitScope != null) {
                    compilationUnitScope.recordTypeReference(this.superclass);
                }
                return this.superclass.getExactMethod(cArray, typeBindingArray, compilationUnitScope);
            }
        }
        return null;
    }

    public FieldBinding getField(char[] cArray, boolean bl) {
        if (!this.isPrototype()) {
            return this.prototype.getField(cArray, bl);
        }
        if ((this.tagBits & 0x1000L) == 0L) {
            int n = this.fields.length;
            if (n > 1) {
                ReferenceBinding.sortFields(this.fields, 0, n);
            }
            this.tagBits |= 0x1000L;
        }
        FieldBinding fieldBinding = ReferenceBinding.binarySearch(cArray, this.fields);
        return bl && fieldBinding != null ? this.resolveTypeFor(fieldBinding) : fieldBinding;
    }

    public ReferenceBinding getMemberType(char[] cArray) {
        if (!this.isPrototype()) {
            ReferenceBinding referenceBinding = this.prototype.getMemberType(cArray);
            return referenceBinding == null ? null : this.environment.createMemberType(referenceBinding, this);
        }
        int n = this.memberTypes.length;
        while (--n >= 0) {
            ReferenceBinding referenceBinding = this.memberTypes[n];
            if (referenceBinding instanceof UnresolvedReferenceBinding) {
                char[] cArray2 = referenceBinding.sourceName;
                int n2 = this.compoundName[this.compoundName.length - 1].length + 1;
                if (cArray2.length != n2 + cArray.length || !CharOperation.fragmentEquals(cArray, cArray2, n2, true)) continue;
                this.memberTypes[n] = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding, this.environment, false);
                return this.memberTypes[n];
            }
            if (!CharOperation.equals(cArray, referenceBinding.sourceName)) continue;
            return referenceBinding;
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] cArray) {
        long l;
        if (!this.isPrototype()) {
            return this.prototype.getMethods(cArray);
        }
        if ((this.tagBits & 0x8000L) != 0L) {
            long l2 = ReferenceBinding.binarySearch(cArray, this.methods);
            if (l2 >= 0L) {
                int n = (int)l2;
                int n2 = (int)(l2 >> 32);
                int n3 = n2 - n + 1;
                if ((this.tagBits & 0x8000L) != 0L) {
                    MethodBinding[] methodBindingArray = new MethodBinding[n3];
                    System.arraycopy(this.methods, n, methodBindingArray, 0, n3);
                    return methodBindingArray;
                }
            }
            return Binding.NO_METHODS;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int n = this.methods.length;
            if (n > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n);
            }
            this.tagBits |= 0x4000L;
        }
        if ((l = ReferenceBinding.binarySearch(cArray, this.methods)) >= 0L) {
            int n = (int)l;
            int n4 = (int)(l >> 32);
            int n5 = n4 - n + 1;
            MethodBinding[] methodBindingArray = new MethodBinding[n5];
            int n6 = n;
            int n7 = 0;
            while (n6 <= n4) {
                methodBindingArray[n7] = this.resolveTypesFor(this.methods[n6]);
                ++n6;
                ++n7;
            }
            return methodBindingArray;
        }
        return Binding.NO_METHODS;
    }

    public MethodBinding[] getMethods(char[] cArray, int n) {
        long l;
        if (!this.isPrototype()) {
            return this.prototype.getMethods(cArray, n);
        }
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.getMethods(cArray);
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int n2 = this.methods.length;
            if (n2 > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n2);
            }
            this.tagBits |= 0x4000L;
        }
        if ((l = ReferenceBinding.binarySearch(cArray, this.methods)) >= 0L) {
            int n3;
            int n4 = (int)l;
            int n5 = (int)(l >> 32);
            int n6 = n5 - n4 + 1;
            int n7 = 0;
            int n8 = n4;
            while (n8 <= n5) {
                n3 = this.methods[n8].parameters.length;
                if (n3 <= n || this.methods[n8].isVarargs() && n3 == n + 1) {
                    ++n7;
                }
                ++n8;
            }
            if (n7 == 0) {
                MethodBinding[] methodBindingArray = new MethodBinding[n6];
                n3 = n4;
                int n9 = 0;
                while (n3 <= n5) {
                    methodBindingArray[n9++] = this.resolveTypesFor(this.methods[n3]);
                    ++n3;
                }
                return methodBindingArray;
            }
            MethodBinding[] methodBindingArray = new MethodBinding[n7];
            n3 = n4;
            int n10 = 0;
            while (n3 <= n5) {
                int n11 = this.methods[n3].parameters.length;
                if (n11 <= n || this.methods[n3].isVarargs() && n11 == n + 1) {
                    methodBindingArray[n10++] = this.resolveTypesFor(this.methods[n3]);
                }
                ++n3;
            }
            return methodBindingArray;
        }
        return Binding.NO_METHODS;
    }

    public boolean hasMemberTypes() {
        if (!this.isPrototype()) {
            return this.prototype.hasMemberTypes();
        }
        return this.memberTypes.length > 0;
    }

    public TypeVariableBinding getTypeVariable(char[] cArray) {
        if (!this.isPrototype()) {
            return this.prototype.getTypeVariable(cArray);
        }
        TypeVariableBinding typeVariableBinding = super.getTypeVariable(cArray);
        typeVariableBinding.resolve();
        return typeVariableBinding;
    }

    public boolean hasTypeBit(int n) {
        if (!this.isPrototype()) {
            return this.prototype.hasTypeBit(n);
        }
        boolean bl = this.environment.mayTolerateMissingType;
        this.environment.mayTolerateMissingType = true;
        try {
            this.superclass();
            this.superInterfaces();
        }
        finally {
            this.environment.mayTolerateMissingType = bl;
        }
        return (this.typeBits & n) != 0;
    }

    private void initializeTypeVariable(TypeVariableBinding typeVariableBinding, TypeVariableBinding[] typeVariableBindingArray, SignatureWrapper signatureWrapper, char[][][] cArray, TypeAnnotationWalker typeAnnotationWalker) {
        ReferenceBinding[] referenceBindingArray;
        ReferenceBinding referenceBinding;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        int n = CharOperation.indexOf(':', signatureWrapper.signature, signatureWrapper.start);
        signatureWrapper.start = n + 1;
        ReferenceBinding referenceBinding2 = null;
        short s = 0;
        if (signatureWrapper.signature[signatureWrapper.start] == ':') {
            referenceBinding = this.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
        } else {
            short s2 = s;
            s = (short)(s2 + 1);
            referenceBindingArray = this.environment.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, this, cArray, typeAnnotationWalker.toTypeBound(s2));
            referenceBinding = referenceBindingArray instanceof ReferenceBinding ? (ReferenceBinding)referenceBindingArray : this.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
            referenceBinding2 = referenceBinding;
        }
        typeVariableBinding.modifiers |= 0x2000000;
        typeVariableBinding.setSuperClass(referenceBinding);
        referenceBindingArray = null;
        if (signatureWrapper.signature[signatureWrapper.start] == ':') {
            ArrayList<TypeBinding> arrayList = new ArrayList<TypeBinding>(2);
            do {
                ++signatureWrapper.start;
                short s3 = s;
                s = (short)(s3 + 1);
                arrayList.add(this.environment.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, this, cArray, typeAnnotationWalker.toTypeBound(s3)));
            } while (signatureWrapper.signature[signatureWrapper.start] == ':');
            referenceBindingArray = new ReferenceBinding[arrayList.size()];
            arrayList.toArray(referenceBindingArray);
        }
        typeVariableBinding.setSuperInterfaces(referenceBindingArray == null ? Binding.NO_SUPERINTERFACES : referenceBindingArray);
        if (referenceBinding2 == null) {
            referenceBinding2 = typeVariableBinding.superInterfaces.length == 0 ? null : typeVariableBinding.superInterfaces[0];
        }
        typeVariableBinding.setFirstBound(referenceBinding2);
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (TypeBinding.equalsEquals(this, typeBinding)) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 260: 
            case 1028: {
                return TypeBinding.equalsEquals(typeBinding.erasure(), this);
            }
        }
        return false;
    }

    public boolean isGenericType() {
        if (!this.isPrototype()) {
            return this.prototype.isGenericType();
        }
        return this.typeVariables != Binding.NO_TYPE_VARIABLES;
    }

    public boolean isHierarchyConnected() {
        if (!this.isPrototype()) {
            return this.prototype.isHierarchyConnected();
        }
        return (this.tagBits & 0x6000000L) == 0L;
    }

    public boolean isRepeatableAnnotationType() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        return this.containerAnnotationType != null;
    }

    public int kind() {
        if (!this.isPrototype()) {
            return this.prototype.kind();
        }
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            return 2052;
        }
        return 4;
    }

    public ReferenceBinding[] memberTypes() {
        if (!this.isPrototype()) {
            int n;
            if ((this.tagBits & 0x10000000L) == 0L) {
                return this.memberTypes;
            }
            ReferenceBinding[] referenceBindingArray = this.prototype.memberTypes();
            int n2 = n = referenceBindingArray == null ? 0 : referenceBindingArray.length;
            if (n > 0) {
                this.memberTypes = new ReferenceBinding[n];
                int n3 = 0;
                while (n3 < n) {
                    this.memberTypes[n3] = this.environment.createMemberType(referenceBindingArray[n3], this);
                    ++n3;
                }
            }
            this.tagBits &= 0xFFFFFFFFEFFFFFFFL;
            return this.memberTypes;
        }
        if ((this.tagBits & 0x10000000L) == 0L) {
            return this.memberTypes;
        }
        int n = this.memberTypes.length;
        while (--n >= 0) {
            this.memberTypes[n] = (ReferenceBinding)BinaryTypeBinding.resolveType(this.memberTypes[n], this.environment, false);
        }
        this.tagBits &= 0xFFFFFFFFEFFFFFFFL;
        return this.memberTypes;
    }

    public MethodBinding[] methods() {
        int n;
        if (!this.isPrototype()) {
            this.methods = this.prototype.methods();
            return this.methods;
        }
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.methods;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            n = this.methods.length;
            if (n > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n);
            }
            this.tagBits |= 0x4000L;
        }
        n = this.methods.length;
        while (--n >= 0) {
            this.resolveTypesFor(this.methods[n]);
        }
        this.tagBits |= 0x8000L;
        return this.methods;
    }

    public TypeBinding prototype() {
        return this.prototype;
    }

    private boolean isPrototype() {
        return this == this.prototype;
    }

    public ReferenceBinding containerAnnotationType() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.containerAnnotationType instanceof UnresolvedReferenceBinding) {
            this.containerAnnotationType = (ReferenceBinding)BinaryTypeBinding.resolveType(this.containerAnnotationType, this.environment, false);
        }
        return this.containerAnnotationType;
    }

    private FieldBinding resolveTypeFor(FieldBinding fieldBinding) {
        TypeBinding typeBinding;
        if (!this.isPrototype()) {
            return this.prototype.resolveTypeFor(fieldBinding);
        }
        if ((fieldBinding.modifiers & 0x2000000) == 0) {
            return fieldBinding;
        }
        fieldBinding.type = typeBinding = BinaryTypeBinding.resolveType(fieldBinding.type, this.environment, true);
        if ((typeBinding.tagBits & 0x80L) != 0L) {
            fieldBinding.tagBits |= 0x80L;
        }
        fieldBinding.modifiers &= 0xFDFFFFFF;
        return fieldBinding;
    }

    MethodBinding resolveTypesFor(MethodBinding methodBinding) {
        TypeBinding typeBinding;
        if (!this.isPrototype()) {
            return this.prototype.resolveTypesFor(methodBinding);
        }
        if ((methodBinding.modifiers & 0x2000000) == 0) {
            return methodBinding;
        }
        if (!methodBinding.isConstructor()) {
            TypeBinding typeBinding2;
            methodBinding.returnType = typeBinding2 = BinaryTypeBinding.resolveType(methodBinding.returnType, this.environment, true);
            if ((typeBinding2.tagBits & 0x80L) != 0L) {
                methodBinding.tagBits |= 0x80L;
            }
        }
        int n = methodBinding.parameters.length;
        while (--n >= 0) {
            methodBinding.parameters[n] = typeBinding = BinaryTypeBinding.resolveType(methodBinding.parameters[n], this.environment, true);
            if ((typeBinding.tagBits & 0x80L) == 0L) continue;
            methodBinding.tagBits |= 0x80L;
        }
        n = methodBinding.thrownExceptions.length;
        while (--n >= 0) {
            typeBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(methodBinding.thrownExceptions[n], this.environment, true);
            methodBinding.thrownExceptions[n] = typeBinding;
            if ((((ReferenceBinding)typeBinding).tagBits & 0x80L) == 0L) continue;
            methodBinding.tagBits |= 0x80L;
        }
        n = methodBinding.typeVariables.length;
        while (--n >= 0) {
            methodBinding.typeVariables[n].resolve();
        }
        methodBinding.modifiers &= 0xFDFFFFFF;
        return methodBinding;
    }

    AnnotationBinding[] retrieveAnnotations(Binding binding) {
        if (!this.isPrototype()) {
            return this.prototype.retrieveAnnotations(binding);
        }
        return AnnotationBinding.addStandardAnnotations(super.retrieveAnnotations(binding), binding.getAnnotationTagBits(), this.environment);
    }

    public void setContainerAnnotationType(ReferenceBinding referenceBinding) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        this.containerAnnotationType = referenceBinding;
    }

    public void tagAsHavingDefectiveContainerType() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.containerAnnotationType != null && this.containerAnnotationType.isValidBinding()) {
            this.containerAnnotationType = new ProblemReferenceBinding(this.containerAnnotationType.compoundName, this.containerAnnotationType, 22);
        }
    }

    SimpleLookupTable storedAnnotations(boolean bl) {
        if (!this.isPrototype()) {
            return this.prototype.storedAnnotations(bl);
        }
        if (bl && this.storedAnnotations == null) {
            if (!this.environment.globalOptions.storeAnnotations) {
                return null;
            }
            this.storedAnnotations = new SimpleLookupTable(3);
        }
        return this.storedAnnotations;
    }

    private void scanFieldForNullAnnotation(IBinaryField iBinaryField, FieldBinding fieldBinding, boolean bl) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (bl && (iBinaryField.getModifiers() & 0x4000) != 0) {
            fieldBinding.tagBits |= 0x100000000000000L;
            return;
        }
        if (this.environment.globalOptions.sourceLevel >= 0x340000L) {
            TypeBinding typeBinding = fieldBinding.type;
            if (typeBinding != null && !typeBinding.isBaseType() && (typeBinding.tagBits & 0x180000000000000L) == 0L && this.hasNonNullDefaultFor(32, true)) {
                fieldBinding.type = this.environment.createAnnotatedType(typeBinding, new AnnotationBinding[]{this.environment.getNonNullAnnotation()});
            }
            return;
        }
        char[][] cArray = this.environment.getNullableAnnotationName();
        char[][] cArray2 = this.environment.getNonNullAnnotationName();
        if (cArray == null || cArray2 == null) {
            return;
        }
        if (fieldBinding.type == null || fieldBinding.type.isBaseType()) {
            return;
        }
        boolean bl2 = false;
        IBinaryAnnotation[] iBinaryAnnotationArray = iBinaryField.getAnnotations();
        if (iBinaryAnnotationArray != null) {
            int n = 0;
            while (n < iBinaryAnnotationArray.length) {
                char[] cArray3 = iBinaryAnnotationArray[n].getTypeName();
                if (cArray3[0] == 'L') {
                    char[][] cArray4 = CharOperation.splitOn('/', cArray3, 1, cArray3.length - 1);
                    if (CharOperation.equals(cArray4, cArray2)) {
                        fieldBinding.tagBits |= 0x100000000000000L;
                        bl2 = true;
                        break;
                    }
                    if (CharOperation.equals(cArray4, cArray)) {
                        fieldBinding.tagBits |= 0x80000000000000L;
                        bl2 = true;
                        break;
                    }
                }
                ++n;
            }
        }
        if (!bl2 && (this.tagBits & 0x200000000000000L) != 0L) {
            fieldBinding.tagBits |= 0x100000000000000L;
        }
    }

    private void scanMethodForNullAnnotation(IBinaryMethod iBinaryMethod, MethodBinding methodBinding) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (!this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
            return;
        }
        boolean bl = this.environment.globalOptions.sourceLevel >= 0x340000L;
        char[][] cArray = this.environment.getNullableAnnotationName();
        char[][] cArray2 = this.environment.getNonNullAnnotationName();
        char[][] cArray3 = this.environment.getNonNullByDefaultAnnotationName();
        if (cArray == null || cArray2 == null || cArray3 == null) {
            return;
        }
        IBinaryAnnotation[] iBinaryAnnotationArray = iBinaryMethod.getAnnotations();
        boolean bl2 = false;
        if (iBinaryAnnotationArray != null) {
            int n = 0;
            while (n < iBinaryAnnotationArray.length) {
                char[] cArray4 = iBinaryAnnotationArray[n].getTypeName();
                if (cArray4[0] == 'L') {
                    char[][] cArray5 = CharOperation.splitOn('/', cArray4, 1, cArray4.length - 1);
                    if (CharOperation.equals(cArray5, cArray3)) {
                        methodBinding.tagBits |= 0x200000000000000L;
                        if (bl) {
                            methodBinding.defaultNullness = this.getNonNullByDefaultValue(iBinaryAnnotationArray[n]);
                        }
                    }
                    if (!bl && !bl2) {
                        if (CharOperation.equals(cArray5, cArray2)) {
                            methodBinding.tagBits |= 0x100000000000000L;
                            bl2 = true;
                        } else if (CharOperation.equals(cArray5, cArray)) {
                            methodBinding.tagBits |= 0x80000000000000L;
                            bl2 = true;
                        }
                    }
                }
                ++n;
            }
        }
        if (bl) {
            return;
        }
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n = typeBindingArray.length;
        int n2 = iBinaryMethod.getAnnotatedParametersCount();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n) {
                int n4;
                IBinaryAnnotation[] iBinaryAnnotationArray2;
                if (n2 > 0 && (iBinaryAnnotationArray2 = iBinaryMethod.getParameterAnnotations(n3 + (n4 = n2 - n))) != null) {
                    int n5 = 0;
                    while (n5 < iBinaryAnnotationArray2.length) {
                        char[] cArray6 = iBinaryAnnotationArray2[n5].getTypeName();
                        if (cArray6[0] == 'L') {
                            char[][] cArray7 = CharOperation.splitOn('/', cArray6, 1, cArray6.length - 1);
                            if (CharOperation.equals(cArray7, cArray2)) {
                                if (methodBinding.parameterNonNullness == null) {
                                    methodBinding.parameterNonNullness = new Boolean[n];
                                }
                                methodBinding.parameterNonNullness[n3] = Boolean.TRUE;
                                break;
                            }
                            if (CharOperation.equals(cArray7, cArray)) {
                                if (methodBinding.parameterNonNullness == null) {
                                    methodBinding.parameterNonNullness = new Boolean[n];
                                }
                                methodBinding.parameterNonNullness[n3] = Boolean.FALSE;
                                break;
                            }
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
        }
    }

    private void scanTypeForNullDefaultAnnotation(IBinaryType iBinaryType, PackageBinding packageBinding, BinaryTypeBinding binaryTypeBinding) {
        ReferenceBinding referenceBinding;
        boolean bl;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        char[][] cArray = this.environment.getNonNullByDefaultAnnotationName();
        if (cArray == null) {
            return;
        }
        IBinaryAnnotation[] iBinaryAnnotationArray = iBinaryType.getAnnotations();
        boolean bl2 = CharOperation.equals(binaryTypeBinding.sourceName(), TypeConstants.PACKAGE_INFO_NAME);
        boolean bl3 = bl = this.environment.globalOptions.sourceLevel >= 0x340000L;
        if (iBinaryAnnotationArray != null) {
            long l = 0L;
            int n = 0;
            int n2 = iBinaryAnnotationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                char[][] cArray2;
                char[] cArray3 = iBinaryAnnotationArray[n3].getTypeName();
                if (cArray3[0] == 'L' && CharOperation.equals(cArray2 = CharOperation.splitOn('/', cArray3, 1, cArray3.length - 1), cArray)) {
                    IBinaryElementValuePair[] iBinaryElementValuePairArray = iBinaryAnnotationArray[n3].getElementValuePairs();
                    if (!bl) {
                        Object object;
                        if (iBinaryElementValuePairArray != null && iBinaryElementValuePairArray.length == 1 && (object = iBinaryElementValuePairArray[0].getValue()) instanceof BooleanConstant && !((BooleanConstant)object).booleanValue()) {
                            l = 0x400000000000000L;
                            n = 2;
                            break;
                        }
                    } else {
                        n = this.getNonNullByDefaultValue(iBinaryAnnotationArray[n3]);
                        if (n == 2) {
                            l = 0x400000000000000L;
                        } else if (n != 0) {
                            l = 0x200000000000000L;
                        }
                        this.defaultNullness = n;
                        break;
                    }
                    l = 0x200000000000000L;
                    n = 1;
                    break;
                }
                ++n3;
            }
            if (l != 0L) {
                binaryTypeBinding.tagBits |= l;
                if (bl2) {
                    packageBinding.defaultNullness = n;
                }
                return;
            }
        }
        if (bl2) {
            packageBinding.defaultNullness = 2;
            return;
        }
        ReferenceBinding referenceBinding2 = binaryTypeBinding.enclosingType;
        if (referenceBinding2 != null) {
            if (bl) {
                binaryTypeBinding.defaultNullness = referenceBinding2.getNullDefault();
                if (binaryTypeBinding.defaultNullness != 0) {
                    return;
                }
            } else {
                if ((referenceBinding2.tagBits & 0x200000000000000L) != 0L) {
                    binaryTypeBinding.tagBits |= 0x200000000000000L;
                    return;
                }
                if ((referenceBinding2.tagBits & 0x400000000000000L) != 0L) {
                    binaryTypeBinding.tagBits |= 0x400000000000000L;
                    return;
                }
            }
        }
        if (packageBinding.defaultNullness == 0 && !bl2 && (referenceBinding = packageBinding.getType(TypeConstants.PACKAGE_INFO_NAME)) == null) {
            packageBinding.defaultNullness = 2;
        }
        if (bl) {
            binaryTypeBinding.defaultNullness = packageBinding.defaultNullness;
        } else {
            switch (packageBinding.defaultNullness) {
                case 1: {
                    binaryTypeBinding.tagBits |= 0x200000000000000L;
                    break;
                }
                case 2: {
                    binaryTypeBinding.tagBits |= 0x400000000000000L;
                }
            }
        }
    }

    int getNonNullByDefaultValue(IBinaryAnnotation iBinaryAnnotation) {
        char[] cArray = iBinaryAnnotation.getTypeName();
        char[][] cArray2 = CharOperation.splitOn('/', cArray, 1, cArray.length - 1);
        IBinaryElementValuePair[] iBinaryElementValuePairArray = iBinaryAnnotation.getElementValuePairs();
        if (iBinaryElementValuePairArray == null || iBinaryElementValuePairArray.length == 0) {
            MethodBinding[] methodBindingArray;
            ReferenceBinding referenceBinding = this.environment.getType(cArray2);
            if (referenceBinding == null) {
                return 0;
            }
            if (referenceBinding.isUnresolvedType()) {
                referenceBinding = ((UnresolvedReferenceBinding)referenceBinding).resolve(this.environment, false);
            }
            if ((methodBindingArray = referenceBinding.methods()) != null && methodBindingArray.length == 1) {
                Object object = methodBindingArray[0].getDefaultValue();
                return Annotation.nullTagBitsFromAnnotationValue(object);
            }
        } else {
            if (iBinaryElementValuePairArray.length > 0) {
                int n = 0;
                int n2 = 0;
                while (n2 < iBinaryElementValuePairArray.length) {
                    n |= Annotation.nullTagBitsFromAnnotationValue(iBinaryElementValuePairArray[n2].getValue());
                    ++n2;
                }
                return n;
            }
            return 2;
        }
        return 0;
    }

    int getNullDefault() {
        return this.defaultNullness;
    }

    private void scanTypeForContainerAnnotation(IBinaryType iBinaryType, char[][][] cArray) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        IBinaryAnnotation[] iBinaryAnnotationArray = iBinaryType.getAnnotations();
        if (iBinaryAnnotationArray != null) {
            int n = iBinaryAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                char[] cArray2 = iBinaryAnnotationArray[n2].getTypeName();
                if (CharOperation.equals(cArray2, ConstantPool.JAVA_LANG_ANNOTATION_REPEATABLE)) {
                    Object object;
                    IBinaryElementValuePair[] iBinaryElementValuePairArray = iBinaryAnnotationArray[n2].getElementValuePairs();
                    if (iBinaryElementValuePairArray == null || iBinaryElementValuePairArray.length != 1 || !((object = iBinaryElementValuePairArray[0].getValue()) instanceof ClassSignature)) break;
                    this.containerAnnotationType = (ReferenceBinding)this.environment.getTypeFromSignature(((ClassSignature)object).getTypeName(), 0, -1, false, null, cArray, TypeAnnotationWalker.EMPTY_ANNOTATION_WALKER);
                    break;
                }
                ++n2;
            }
        }
    }

    public ReferenceBinding superclass() {
        if (!this.isPrototype()) {
            this.superclass = this.prototype.superclass();
            return this.superclass;
        }
        if ((this.tagBits & 0x2000000L) == 0L) {
            return this.superclass;
        }
        this.superclass = (ReferenceBinding)BinaryTypeBinding.resolveType(this.superclass, this.environment, true);
        this.tagBits &= 0xFFFFFFFFFDFFFFFFL;
        if (this.superclass.problemId() == 1) {
            this.tagBits |= 0x20000L;
        } else {
            boolean bl = this.environment.mayTolerateMissingType;
            this.environment.mayTolerateMissingType = true;
            try {
                this.superclass.superclass();
                this.superclass.superInterfaces();
            }
            finally {
                this.environment.mayTolerateMissingType = bl;
            }
        }
        this.typeBits |= this.superclass.typeBits & 0x13;
        if ((this.typeBits & 3) != 0) {
            this.typeBits |= this.applyCloseableClassWhitelists();
        }
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        if (!this.isPrototype()) {
            this.superInterfaces = this.prototype.superInterfaces();
            return this.superInterfaces;
        }
        if ((this.tagBits & 0x4000000L) == 0L) {
            return this.superInterfaces;
        }
        int n = this.superInterfaces.length;
        while (--n >= 0) {
            this.superInterfaces[n] = (ReferenceBinding)BinaryTypeBinding.resolveType(this.superInterfaces[n], this.environment, true);
            if (this.superInterfaces[n].problemId() == 1) {
                this.tagBits |= 0x20000L;
            } else {
                boolean bl = this.environment.mayTolerateMissingType;
                this.environment.mayTolerateMissingType = true;
                try {
                    this.superInterfaces[n].superclass();
                    this.superInterfaces[n].superInterfaces();
                }
                finally {
                    this.environment.mayTolerateMissingType = bl;
                }
            }
            this.typeBits |= this.superInterfaces[n].typeBits & 0x13;
            if ((this.typeBits & 3) == 0) continue;
            this.typeBits |= this.applyCloseableInterfaceWhitelists();
        }
        this.tagBits &= 0xFFFFFFFFFBFFFFFFL;
        return this.superInterfaces;
    }

    public TypeVariableBinding[] typeVariables() {
        if (!this.isPrototype()) {
            this.typeVariables = this.prototype.typeVariables();
            return this.typeVariables;
        }
        if ((this.tagBits & 0x1000000L) == 0L) {
            return this.typeVariables;
        }
        int n = this.typeVariables.length;
        while (--n >= 0) {
            this.typeVariables[n].resolve();
        }
        this.tagBits &= 0xFFFFFFFFFEFFFFFFL;
        return this.typeVariables;
    }

    public String toString() {
        int n;
        int n2;
        if (this.hasTypeAnnotations()) {
            return this.annotatedDebugName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDeprecated()) {
            stringBuffer.append("deprecated ");
        }
        if (this.isPublic()) {
            stringBuffer.append("public ");
        }
        if (this.isProtected()) {
            stringBuffer.append("protected ");
        }
        if (this.isPrivate()) {
            stringBuffer.append("private ");
        }
        if (this.isAbstract() && this.isClass()) {
            stringBuffer.append("abstract ");
        }
        if (this.isStatic() && this.isNestedType()) {
            stringBuffer.append("static ");
        }
        if (this.isFinal()) {
            stringBuffer.append("final ");
        }
        if (this.isEnum()) {
            stringBuffer.append("enum ");
        } else if (this.isAnnotationType()) {
            stringBuffer.append("@interface ");
        } else if (this.isClass()) {
            stringBuffer.append("class ");
        } else {
            stringBuffer.append("interface ");
        }
        stringBuffer.append(this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        if (this.typeVariables == null) {
            stringBuffer.append("<NULL TYPE VARIABLES>");
        } else if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            stringBuffer.append("<");
            n2 = 0;
            n = this.typeVariables.length;
            while (n2 < n) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                if (this.typeVariables[n2] == null) {
                    stringBuffer.append("NULL TYPE VARIABLE");
                } else {
                    char[] cArray = this.typeVariables[n2].toString().toCharArray();
                    stringBuffer.append(cArray, 1, cArray.length - 2);
                }
                ++n2;
            }
            stringBuffer.append(">");
        }
        stringBuffer.append("\n\textends ");
        stringBuffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.superInterfaces != null) {
            if (this.superInterfaces != Binding.NO_SUPERINTERFACES) {
                stringBuffer.append("\n\timplements : ");
                n2 = 0;
                n = this.superInterfaces.length;
                while (n2 < n) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.superInterfaces[n2] != null ? this.superInterfaces[n2].debugName() : "NULL TYPE");
                    ++n2;
                }
            }
        } else {
            stringBuffer.append("NULL SUPERINTERFACES");
        }
        if (this.enclosingType != null) {
            stringBuffer.append("\n\tenclosing type : ");
            stringBuffer.append(this.enclosingType.debugName());
        }
        if (this.fields != null) {
            if (this.fields != Binding.NO_FIELDS) {
                stringBuffer.append("\n/*   fields   */");
                n2 = 0;
                n = this.fields.length;
                while (n2 < n) {
                    stringBuffer.append(this.fields[n2] != null ? "\n" + this.fields[n2].toString() : "\nNULL FIELD");
                    ++n2;
                }
            }
        } else {
            stringBuffer.append("NULL FIELDS");
        }
        if (this.methods != null) {
            if (this.methods != Binding.NO_METHODS) {
                stringBuffer.append("\n/*   methods   */");
                n2 = 0;
                n = this.methods.length;
                while (n2 < n) {
                    stringBuffer.append(this.methods[n2] != null ? "\n" + this.methods[n2].toString() : "\nNULL METHOD");
                    ++n2;
                }
            }
        } else {
            stringBuffer.append("NULL METHODS");
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != Binding.NO_MEMBER_TYPES) {
                stringBuffer.append("\n/*   members   */");
                n2 = 0;
                n = this.memberTypes.length;
                while (n2 < n) {
                    stringBuffer.append(this.memberTypes[n2] != null ? "\n" + this.memberTypes[n2].toString() : "\nNULL TYPE");
                    ++n2;
                }
            }
        } else {
            stringBuffer.append("NULL MEMBER TYPES");
        }
        stringBuffer.append("\n\n\n");
        return stringBuffer.toString();
    }

    public TypeBinding unannotated(boolean bl) {
        if (bl) {
            if (!this.hasNullTypeAnnotations()) {
                return this;
            }
            AnnotationBinding[] annotationBindingArray = this.environment.filterNullTypeAnnotations(this.typeAnnotations);
            if (annotationBindingArray.length > 0) {
                return this.environment.createAnnotatedType((TypeBinding)this.prototype, annotationBindingArray);
            }
        }
        return this.prototype;
    }

    MethodBinding[] unResolvedMethods() {
        if (!this.isPrototype()) {
            return this.prototype.unResolvedMethods();
        }
        return this.methods;
    }

    public FieldBinding[] unResolvedFields() {
        if (!this.isPrototype()) {
            return this.prototype.unResolvedFields();
        }
        return this.fields;
    }
}

