/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayBinding
extends TypeBinding {
    public static final FieldBinding ArrayLength = new FieldBinding(TypeConstants.LENGTH, TypeBinding.INT, 17, null, Constant.NotAConstant);
    public TypeBinding leafComponentType;
    public int dimensions;
    LookupEnvironment environment;
    char[] constantPoolName;
    char[] genericTypeSignature;
    public long[] nullTagBitsPerDimension;

    public ArrayBinding(TypeBinding typeBinding, int n, LookupEnvironment lookupEnvironment) {
        this.tagBits |= 1L;
        this.leafComponentType = typeBinding;
        this.dimensions = n;
        this.environment = lookupEnvironment;
        if (typeBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)typeBinding).addWrapper(this, lookupEnvironment);
        } else {
            this.tagBits |= typeBinding.tagBits & 0x2000000060000880L;
        }
        long l = typeBinding.tagBits & 0x180000000000000L;
        if (l != 0L) {
            this.nullTagBitsPerDimension = new long[this.dimensions + 1];
            this.nullTagBitsPerDimension[this.dimensions] = l;
            this.tagBits |= 0x100000L;
        }
    }

    @Override
    public TypeBinding closestMatch() {
        if (this.isValidBinding()) {
            return this;
        }
        TypeBinding typeBinding = this.leafComponentType.closestMatch();
        if (typeBinding == null) {
            return null;
        }
        return this.environment.createArrayType(this.leafComponentType.closestMatch(), this.dimensions);
    }

    @Override
    public List collectMissingTypes(List list) {
        if ((this.tagBits & 0x80L) != 0L) {
            list = this.leafComponentType.collectMissingTypes(list);
        }
        return list;
    }

    @Override
    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, InferenceContext inferenceContext, int n) {
        if ((this.tagBits & 0x20000000L) == 0L) {
            return;
        }
        if (typeBinding == TypeBinding.NULL || typeBinding.kind() == 65540) {
            return;
        }
        switch (typeBinding.kind()) {
            case 68: {
                int n2 = typeBinding.dimensions();
                if (n2 == this.dimensions) {
                    this.leafComponentType.collectSubstitutes(scope, typeBinding.leafComponentType(), inferenceContext, n);
                    break;
                }
                if (n2 <= this.dimensions) break;
                ArrayBinding arrayBinding = this.environment.createArrayType(typeBinding.leafComponentType(), n2 - this.dimensions);
                this.leafComponentType.collectSubstitutes(scope, arrayBinding, inferenceContext, n);
                break;
            }
        }
    }

    @Override
    public boolean mentionsAny(TypeBinding[] typeBindingArray, int n) {
        return this.leafComponentType.mentionsAny(typeBindingArray, n);
    }

    @Override
    void collectInferenceVariables(Set<InferenceVariable> set) {
        this.leafComponentType.collectInferenceVariables(set);
    }

    @Override
    TypeBinding substituteInferenceVariable(InferenceVariable inferenceVariable, TypeBinding typeBinding) {
        TypeBinding typeBinding2 = this.leafComponentType.substituteInferenceVariable(inferenceVariable, typeBinding);
        if (TypeBinding.notEquals(typeBinding2, this.leafComponentType)) {
            return this.environment.createArrayType(typeBinding2, this.dimensions, this.typeAnnotations);
        }
        return this;
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        char[] cArray = new char[this.dimensions];
        int n = this.dimensions - 1;
        while (n >= 0) {
            cArray[n] = 91;
            --n;
        }
        return CharOperation.concat(cArray, this.leafComponentType.computeUniqueKey(bl));
    }

    @Override
    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        char[] cArray = new char[this.dimensions];
        int n = this.dimensions - 1;
        while (n >= 0) {
            cArray[n] = 91;
            --n;
        }
        this.constantPoolName = CharOperation.concat(cArray, this.leafComponentType.signature());
        return this.constantPoolName;
    }

    @Override
    public String debugName() {
        if (this.hasTypeAnnotations()) {
            return this.annotatedDebugName();
        }
        StringBuffer stringBuffer = new StringBuffer(this.dimensions * 2);
        int n = this.dimensions;
        while (--n >= 0) {
            stringBuffer.append("[]");
        }
        return String.valueOf(this.leafComponentType.debugName()) + stringBuffer.toString();
    }

    @Override
    public String annotatedDebugName() {
        StringBuffer stringBuffer = new StringBuffer(this.dimensions * 2);
        stringBuffer.append(this.leafComponentType.annotatedDebugName());
        stringBuffer.append(' ');
        AnnotationBinding[] annotationBindingArray = this.getTypeAnnotations();
        int n = 0;
        int n2 = -1;
        while (n < this.dimensions) {
            if (annotationBindingArray != null) {
                if (n != 0) {
                    stringBuffer.append(' ');
                }
                while (++n2 < annotationBindingArray.length && annotationBindingArray[n2] != null) {
                    stringBuffer.append(annotationBindingArray[n2]);
                    stringBuffer.append(' ');
                }
            }
            stringBuffer.append("[]");
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public int dimensions() {
        return this.dimensions;
    }

    public TypeBinding elementsType() {
        if (this.dimensions == 1) {
            return this.leafComponentType;
        }
        AnnotationBinding[] annotationBindingArray = this.getTypeAnnotations();
        AnnotationBinding[] annotationBindingArray2 = Binding.NO_ANNOTATIONS;
        int n = 0;
        int n2 = annotationBindingArray == null ? 0 : annotationBindingArray.length;
        while (n < n2) {
            if (annotationBindingArray[n] == null) {
                annotationBindingArray2 = new AnnotationBinding[n2 - n - 1];
                System.arraycopy(annotationBindingArray, n + 1, annotationBindingArray2, 0, n2 - n - 1);
                break;
            }
            ++n;
        }
        return this.environment.createArrayType(this.leafComponentType, this.dimensions - 1, annotationBindingArray2);
    }

    @Override
    public TypeBinding erasure() {
        TypeBinding typeBinding = this.leafComponentType.erasure();
        if (TypeBinding.notEquals(this.leafComponentType, typeBinding)) {
            return this.environment.createArrayType(typeBinding, this.dimensions);
        }
        return this;
    }

    public LookupEnvironment environment() {
        return this.environment;
    }

    @Override
    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            char[] cArray = new char[this.dimensions];
            int n = this.dimensions - 1;
            while (n >= 0) {
                cArray[n] = 91;
                --n;
            }
            this.genericTypeSignature = CharOperation.concat(cArray, this.leafComponentType.genericTypeSignature());
        }
        return this.genericTypeSignature;
    }

    @Override
    public PackageBinding getPackage() {
        return this.leafComponentType.getPackage();
    }

    public int hashCode() {
        return this.leafComponentType == null ? super.hashCode() : this.leafComponentType.hashCode();
    }

    @Override
    public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (ArrayBinding.equalsEquals(this, typeBinding)) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
                if (arrayBinding.leafComponentType.isBaseType()) {
                    return false;
                }
                if (this.dimensions == arrayBinding.dimensions) {
                    return this.leafComponentType.isCompatibleWith(arrayBinding.leafComponentType);
                }
                if (this.dimensions >= arrayBinding.dimensions) break;
                return false;
            }
            case 132: {
                return false;
            }
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 4100: {
                if (typeBinding.isCapture()) {
                    CaptureBinding captureBinding = (CaptureBinding)typeBinding;
                    TypeBinding typeBinding2 = captureBinding.lowerBound;
                    if (typeBinding2 != null) {
                        if (!typeBinding2.isArrayType()) {
                            return false;
                        }
                        return this.isCompatibleWith(typeBinding2, scope);
                    }
                }
                return false;
            }
        }
        switch (typeBinding.leafComponentType().id) {
            case 1: 
            case 36: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSubtypeOf(TypeBinding typeBinding) {
        if (ArrayBinding.equalsEquals(this, typeBinding)) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
                if (arrayBinding.leafComponentType.isBaseType()) {
                    return false;
                }
                if (this.dimensions == arrayBinding.dimensions) {
                    return this.leafComponentType.isSubtypeOf(arrayBinding.leafComponentType);
                }
                if (this.dimensions >= arrayBinding.dimensions) break;
                return false;
            }
            case 132: {
                return false;
            }
        }
        switch (typeBinding.leafComponentType().id) {
            case 1: 
            case 36: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isProperType(boolean bl) {
        return this.leafComponentType.isProperType(bl);
    }

    @Override
    public int kind() {
        return 68;
    }

    @Override
    public TypeBinding leafComponentType() {
        return this.leafComponentType;
    }

    @Override
    public char[] nullAnnotatedReadableName(CompilerOptions compilerOptions, boolean bl) {
        if (this.nullTagBitsPerDimension == null) {
            return bl ? this.shortReadableName() : this.readableName();
        }
        char[][] cArrayArray = new char[this.dimensions][];
        int n = 0;
        while (n < this.dimensions) {
            if ((this.nullTagBitsPerDimension[n] & 0x180000000000000L) != 0L) {
                char[][] cArray = (this.nullTagBitsPerDimension[n] & 0x100000000000000L) != 0L ? compilerOptions.nonNullAnnotationName : compilerOptions.nullableAnnotationName;
                char[] cArray2 = bl ? cArray[cArray.length - 1] : CharOperation.concatWith(cArray, '.');
                cArrayArray[n] = new char[cArray2.length + 3];
                cArrayArray[n][0] = 64;
                System.arraycopy(cArray2, 0, cArrayArray[n], 1, cArray2.length);
                cArrayArray[n][cArray2.length + 1] = 91;
                cArrayArray[n][cArray2.length + 2] = 93;
            } else {
                cArrayArray[n] = new char[]{'[', ']'};
            }
            ++n;
        }
        return CharOperation.concat(this.leafComponentType.nullAnnotatedReadableName(compilerOptions, bl), CharOperation.concatWith(cArrayArray, ' '), ' ');
    }

    @Override
    public int problemId() {
        return this.leafComponentType.problemId();
    }

    @Override
    public char[] qualifiedSourceName() {
        char[] cArray = new char[this.dimensions * 2];
        int n = this.dimensions * 2 - 1;
        while (n >= 0) {
            cArray[n] = 93;
            cArray[n - 1] = 91;
            n -= 2;
        }
        return CharOperation.concat(this.leafComponentType.qualifiedSourceName(), cArray);
    }

    @Override
    public char[] readableName() {
        char[] cArray = new char[this.dimensions * 2];
        int n = this.dimensions * 2 - 1;
        while (n >= 0) {
            cArray[n] = 93;
            cArray[n - 1] = 91;
            n -= 2;
        }
        return CharOperation.concat(this.leafComponentType.readableName(), cArray);
    }

    @Override
    public void setTypeAnnotations(AnnotationBinding[] annotationBindingArray, boolean bl) {
        this.tagBits |= 0x200000L;
        if (annotationBindingArray == null || annotationBindingArray.length == 0) {
            return;
        }
        this.typeAnnotations = annotationBindingArray;
        if (bl) {
            long l = 0L;
            if (this.nullTagBitsPerDimension == null) {
                this.nullTagBitsPerDimension = new long[this.dimensions + 1];
            }
            int n = 0;
            int n2 = 0;
            int n3 = annotationBindingArray.length;
            while (n2 < n3) {
                AnnotationBinding annotationBinding = annotationBindingArray[n2];
                if (annotationBinding != null) {
                    switch (annotationBinding.type.id) {
                        case 65: {
                            l |= 0x80000000000000L;
                            this.tagBits |= 0x100000L;
                            break;
                        }
                        case 66: {
                            l |= 0x100000000000000L;
                            this.tagBits |= 0x100000L;
                        }
                    }
                } else {
                    if (l != 0L) {
                        this.nullTagBitsPerDimension[n] = l;
                        l = 0L;
                    }
                    ++n;
                }
                ++n2;
            }
            this.tagBits |= this.nullTagBitsPerDimension[0];
        }
    }

    @Override
    public char[] shortReadableName() {
        char[] cArray = new char[this.dimensions * 2];
        int n = this.dimensions * 2 - 1;
        while (n >= 0) {
            cArray[n] = 93;
            cArray[n - 1] = 91;
            n -= 2;
        }
        return CharOperation.concat(this.leafComponentType.shortReadableName(), cArray);
    }

    @Override
    public char[] sourceName() {
        char[] cArray = new char[this.dimensions * 2];
        int n = this.dimensions * 2 - 1;
        while (n >= 0) {
            cArray[n] = 93;
            cArray[n - 1] = 91;
            n -= 2;
        }
        return CharOperation.concat(this.leafComponentType.sourceName(), cArray);
    }

    @Override
    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        if (this.leafComponentType == unresolvedReferenceBinding) {
            this.leafComponentType = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
            if (this.leafComponentType != referenceBinding) {
                this.id = lookupEnvironment.createArrayType((TypeBinding)this.leafComponentType, (int)this.dimensions, (AnnotationBinding[])this.typeAnnotations).id;
            }
            this.tagBits |= this.leafComponentType.tagBits & 0x2000000060000080L;
        }
    }

    public String toString() {
        return this.leafComponentType != null ? this.debugName() : "NULL TYPE ARRAY";
    }

    @Override
    public TypeBinding unannotated(boolean bl) {
        if (!this.hasTypeAnnotations()) {
            return this;
        }
        if (bl) {
            if (!this.hasNullTypeAnnotations()) {
                return this;
            }
            AnnotationBinding[] annotationBindingArray = this.environment.filterNullTypeAnnotations(this.typeAnnotations);
            if (annotationBindingArray.length > 0) {
                return this.environment.createArrayType(this.leafComponentType.unannotated(false), this.dimensions, annotationBindingArray);
            }
        }
        return this.environment.getUnannotatedType(this);
    }

    @Override
    public TypeBinding uncapture(Scope scope) {
        if ((this.tagBits & 0x2000000000000000L) == 0L) {
            return this;
        }
        TypeBinding typeBinding = this.leafComponentType.uncapture(scope);
        return scope.environment().createArrayType(typeBinding, this.dimensions, this.typeAnnotations);
    }
}

