/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeSystem;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.util.Util;

public class AnnotatableTypeSystem
extends TypeSystem {
    private LookupEnvironment environment;
    private boolean isAnnotationBasedNullAnalysisEnabled;

    public AnnotatableTypeSystem(LookupEnvironment lookupEnvironment) {
        super(lookupEnvironment);
        this.environment = lookupEnvironment;
        this.isAnnotationBasedNullAnalysisEnabled = lookupEnvironment.globalOptions.isAnnotationBasedNullAnalysisEnabled;
    }

    public TypeBinding[] getAnnotatedTypes(TypeBinding typeBinding) {
        TypeBinding[] typeBindingArray = this.getDerivedTypes(typeBinding);
        int n = typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = new TypeBinding[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            TypeBinding typeBinding2 = typeBindingArray[n3];
            if (typeBinding2 == null) break;
            if (typeBinding2.hasTypeAnnotations() && typeBinding2.id == typeBinding.id) {
                typeBindingArray2[n2++] = typeBinding2;
            }
            ++n3;
        }
        if (n2 != n) {
            TypeBinding[] typeBindingArray3 = typeBindingArray2;
            typeBindingArray2 = new TypeBinding[n2];
            System.arraycopy(typeBindingArray3, 0, typeBindingArray2, 0, n2);
        }
        return typeBindingArray2;
    }

    public ArrayBinding getArrayType(TypeBinding typeBinding, int n, AnnotationBinding[] annotationBindingArray) {
        ArrayBinding arrayBinding = null;
        TypeBinding[] typeBindingArray = this.getDerivedTypes(typeBinding);
        int n2 = 0;
        int n3 = typeBindingArray.length;
        while (n2 < n3) {
            TypeBinding typeBinding2 = typeBindingArray[n2];
            if (typeBinding2 == null) break;
            if (typeBinding2.isArrayType() && typeBinding2.dimensions() == n && typeBinding2.leafComponentType() == typeBinding) {
                if (Util.effectivelyEqual(typeBinding2.getTypeAnnotations(), annotationBindingArray)) {
                    return (ArrayBinding)typeBinding2;
                }
                if (!typeBinding2.hasTypeAnnotations()) {
                    arrayBinding = (ArrayBinding)typeBinding2;
                }
            }
            ++n2;
        }
        if (arrayBinding == null) {
            arrayBinding = super.getArrayType(typeBinding, n);
        }
        if (!this.haveTypeAnnotations(typeBinding, annotationBindingArray)) {
            return arrayBinding;
        }
        ArrayBinding arrayBinding2 = new ArrayBinding(typeBinding, n, this.environment);
        arrayBinding2.id = arrayBinding.id;
        arrayBinding2.setTypeAnnotations(annotationBindingArray, this.isAnnotationBasedNullAnalysisEnabled);
        return (ArrayBinding)this.cacheDerivedType(typeBinding, arrayBinding, arrayBinding2);
    }

    public ArrayBinding getArrayType(TypeBinding typeBinding, int n) {
        return this.getArrayType(typeBinding, n, Binding.NO_ANNOTATIONS);
    }

    public ReferenceBinding getMemberType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        if (!this.haveTypeAnnotations((TypeBinding)referenceBinding, referenceBinding2)) {
            return super.getMemberType(referenceBinding, referenceBinding2);
        }
        return (ReferenceBinding)this.getAnnotatedType(referenceBinding, referenceBinding2, referenceBinding.getTypeAnnotations());
    }

    public ParameterizedTypeBinding getParameterizedType(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, AnnotationBinding[] annotationBindingArray) {
        if (referenceBinding.hasTypeAnnotations()) {
            throw new IllegalStateException();
        }
        ParameterizedTypeBinding parameterizedTypeBinding = null;
        TypeBinding[] typeBindingArray2 = this.getDerivedTypes(referenceBinding);
        int n = 0;
        int n2 = typeBindingArray2.length;
        while (n < n2) {
            TypeBinding typeBinding = typeBindingArray2[n];
            if (typeBinding == null) break;
            if (typeBinding.isParameterizedType() && typeBinding.actualType() == referenceBinding && typeBinding.enclosingType() == referenceBinding2 && Util.effectivelyEqual(typeBinding.typeArguments(), typeBindingArray)) {
                if (Util.effectivelyEqual(annotationBindingArray, typeBinding.getTypeAnnotations())) {
                    return (ParameterizedTypeBinding)typeBinding;
                }
                if (!typeBinding.hasTypeAnnotations()) {
                    parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
                }
            }
            ++n;
        }
        if (parameterizedTypeBinding == null) {
            parameterizedTypeBinding = super.getParameterizedType(referenceBinding, typeBindingArray, referenceBinding2);
        }
        if (!this.haveTypeAnnotations(referenceBinding, referenceBinding2, typeBindingArray, annotationBindingArray)) {
            return parameterizedTypeBinding;
        }
        ParameterizedTypeBinding parameterizedTypeBinding2 = new ParameterizedTypeBinding(referenceBinding, typeBindingArray, referenceBinding2, this.environment);
        parameterizedTypeBinding2.id = parameterizedTypeBinding.id;
        parameterizedTypeBinding2.setTypeAnnotations(annotationBindingArray, this.isAnnotationBasedNullAnalysisEnabled);
        return (ParameterizedTypeBinding)this.cacheDerivedType(referenceBinding, parameterizedTypeBinding, parameterizedTypeBinding2);
    }

    public ParameterizedTypeBinding getParameterizedType(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2) {
        return this.getParameterizedType(referenceBinding, typeBindingArray, referenceBinding2, Binding.NO_ANNOTATIONS);
    }

    public RawTypeBinding getRawType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, AnnotationBinding[] annotationBindingArray) {
        if (referenceBinding.hasTypeAnnotations()) {
            throw new IllegalStateException();
        }
        RawTypeBinding rawTypeBinding = null;
        TypeBinding[] typeBindingArray = this.getDerivedTypes(referenceBinding);
        int n = 0;
        int n2 = typeBindingArray.length;
        while (n < n2) {
            TypeBinding typeBinding = typeBindingArray[n];
            if (typeBinding == null) break;
            if (typeBinding.isRawType() && typeBinding.actualType() == referenceBinding && typeBinding.enclosingType() == referenceBinding2) {
                if (Util.effectivelyEqual(typeBinding.getTypeAnnotations(), annotationBindingArray)) {
                    return (RawTypeBinding)typeBinding;
                }
                if (!typeBinding.hasTypeAnnotations()) {
                    rawTypeBinding = (RawTypeBinding)typeBinding;
                }
            }
            ++n;
        }
        if (rawTypeBinding == null) {
            rawTypeBinding = super.getRawType(referenceBinding, referenceBinding2);
        }
        if (!this.haveTypeAnnotations(referenceBinding, referenceBinding2, null, annotationBindingArray)) {
            return rawTypeBinding;
        }
        RawTypeBinding rawTypeBinding2 = new RawTypeBinding(referenceBinding, referenceBinding2, this.environment);
        rawTypeBinding2.id = rawTypeBinding.id;
        rawTypeBinding2.setTypeAnnotations(annotationBindingArray, this.isAnnotationBasedNullAnalysisEnabled);
        return (RawTypeBinding)this.cacheDerivedType(referenceBinding, rawTypeBinding, rawTypeBinding2);
    }

    public RawTypeBinding getRawType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        return this.getRawType(referenceBinding, referenceBinding2, Binding.NO_ANNOTATIONS);
    }

    public WildcardBinding getWildcard(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2, AnnotationBinding[] annotationBindingArray) {
        if (referenceBinding == null) {
            referenceBinding = ReferenceBinding.LUB_GENERIC;
        }
        if (referenceBinding.hasTypeAnnotations()) {
            throw new IllegalStateException();
        }
        WildcardBinding wildcardBinding = null;
        TypeBinding[] typeBindingArray2 = this.getDerivedTypes(referenceBinding);
        int n3 = 0;
        int n4 = typeBindingArray2.length;
        while (n3 < n4) {
            TypeBinding typeBinding2 = typeBindingArray2[n3];
            if (typeBinding2 == null) break;
            if (typeBinding2.isWildcard() && typeBinding2.actualType() == referenceBinding && typeBinding2.rank() == n && typeBinding2.boundKind() == n2 && typeBinding2.bound() == typeBinding && Util.effectivelyEqual(typeBinding2.additionalBounds(), typeBindingArray)) {
                if (Util.effectivelyEqual(typeBinding2.getTypeAnnotations(), annotationBindingArray)) {
                    return (WildcardBinding)typeBinding2;
                }
                if (!typeBinding2.hasTypeAnnotations()) {
                    wildcardBinding = (WildcardBinding)typeBinding2;
                }
            }
            ++n3;
        }
        if (wildcardBinding == null) {
            wildcardBinding = super.getWildcard(referenceBinding, n, typeBinding, typeBindingArray, n2);
        }
        if (!this.haveTypeAnnotations(referenceBinding, typeBinding, typeBindingArray, annotationBindingArray)) {
            return wildcardBinding;
        }
        WildcardBinding wildcardBinding2 = new WildcardBinding(referenceBinding, n, typeBinding, typeBindingArray, n2, this.environment);
        wildcardBinding2.id = wildcardBinding.id;
        wildcardBinding2.setTypeAnnotations(annotationBindingArray, this.isAnnotationBasedNullAnalysisEnabled);
        return (WildcardBinding)this.cacheDerivedType(referenceBinding, wildcardBinding, wildcardBinding2);
    }

    public WildcardBinding getWildcard(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2) {
        return this.getWildcard(referenceBinding, n, typeBinding, typeBindingArray, n2, Binding.NO_ANNOTATIONS);
    }

    public TypeBinding getAnnotatedType(TypeBinding typeBinding, AnnotationBinding[][] annotationBindingArray) {
        if (typeBinding == null || !typeBinding.isValidBinding() || annotationBindingArray == null || annotationBindingArray.length == 0) {
            return typeBinding;
        }
        TypeBinding typeBinding2 = null;
        switch (typeBinding.kind()) {
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
                typeBinding2 = this.getArrayType(arrayBinding.leafComponentType, arrayBinding.dimensions, AnnotatableTypeSystem.flattenedAnnotations(annotationBindingArray));
                break;
            }
            case 4: 
            case 132: 
            case 260: 
            case 516: 
            case 1028: 
            case 2052: 
            case 4100: 
            case 8196: 
            case 32772: {
                if (typeBinding.isUnresolvedType() && CharOperation.indexOf('$', typeBinding.sourceName()) > 0) {
                    typeBinding = BinaryTypeBinding.resolveType(typeBinding, this.environment, true);
                }
                int n = typeBinding.depth() + 1;
                TypeBinding[] typeBindingArray = new TypeBinding[n];
                typeBindingArray[--n] = typeBinding;
                TypeBinding typeBinding3 = typeBinding.enclosingType();
                while (typeBinding3 != null) {
                    typeBindingArray[--n] = typeBinding3;
                    typeBinding3 = typeBinding3.enclosingType();
                }
                n = annotationBindingArray.length;
                int n2 = typeBindingArray.length - n;
                int n3 = 0;
                while (n3 < n) {
                    if (annotationBindingArray[n3] != null && annotationBindingArray[n3].length > 0) break;
                    ++n3;
                    ++n2;
                }
                if (n3 == n) {
                    return typeBinding;
                }
                if (n2 < 0) {
                    return typeBinding;
                }
                typeBinding3 = n2 == 0 ? null : typeBindingArray[n2 - 1];
                while (n3 < n) {
                    TypeBinding typeBinding4 = typeBindingArray[n2];
                    AnnotationBinding[] annotationBindingArray2 = annotationBindingArray[n3] != null && annotationBindingArray[n3].length > 0 ? annotationBindingArray[n3] : typeBinding4.getTypeAnnotations();
                    typeBinding2 = this.getAnnotatedType(typeBinding4, typeBinding3, annotationBindingArray2);
                    typeBinding3 = typeBinding2;
                    ++n3;
                    ++n2;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return typeBinding2;
    }

    /*
     * Exception decompiling
     */
    private TypeBinding getAnnotatedType(TypeBinding var1_1, TypeBinding var2_2, AnnotationBinding[] var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[SWITCH], 5[CASE]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean haveTypeAnnotations(TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding[] typeBindingArray, AnnotationBinding[] annotationBindingArray) {
        if (typeBinding != null && typeBinding.hasTypeAnnotations()) {
            return true;
        }
        if (typeBinding2 != null && typeBinding2.hasTypeAnnotations()) {
            return true;
        }
        int n = 0;
        int n2 = annotationBindingArray == null ? 0 : annotationBindingArray.length;
        while (n < n2) {
            if (annotationBindingArray[n] != null) {
                return true;
            }
            ++n;
        }
        n = 0;
        n2 = typeBindingArray == null ? 0 : typeBindingArray.length;
        while (n < n2) {
            if (typeBindingArray[n].hasTypeAnnotations()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean haveTypeAnnotations(TypeBinding typeBinding, AnnotationBinding[] annotationBindingArray) {
        return this.haveTypeAnnotations(typeBinding, null, null, annotationBindingArray);
    }

    private boolean haveTypeAnnotations(TypeBinding typeBinding, TypeBinding typeBinding2) {
        return this.haveTypeAnnotations(typeBinding, typeBinding2, null, null);
    }

    static AnnotationBinding[] flattenedAnnotations(AnnotationBinding[][] annotationBindingArray) {
        int n;
        if (annotationBindingArray == null || annotationBindingArray.length == 0) {
            return Binding.NO_ANNOTATIONS;
        }
        int n2 = n = annotationBindingArray.length;
        int n3 = 0;
        while (n3 < n) {
            n2 += annotationBindingArray[n3] == null ? 0 : annotationBindingArray[n3].length;
            ++n3;
        }
        if (n2 == 0) {
            return Binding.NO_ANNOTATIONS;
        }
        AnnotationBinding[] annotationBindingArray2 = new AnnotationBinding[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6;
            int n7 = n6 = annotationBindingArray[n5] == null ? 0 : annotationBindingArray[n5].length;
            if (n6 > 0) {
                System.arraycopy(annotationBindingArray[n5], 0, annotationBindingArray2, n4, n6);
                n4 += n6;
            }
            annotationBindingArray2[n4++] = null;
            ++n5;
        }
        if (n4 != n2) {
            throw new IllegalStateException();
        }
        return annotationBindingArray2;
    }

    public boolean isAnnotatedTypeSystem() {
        return true;
    }
}

