/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;

public class TypeAnnotationWalker {
    public static final IBinaryAnnotation[] NO_ANNOTATIONS = new IBinaryAnnotation[0];
    public static final TypeAnnotationWalker EMPTY_ANNOTATION_WALKER = new TypeAnnotationWalker(new IBinaryTypeAnnotation[0], 0L){

        public TypeAnnotationWalker toField() {
            return this;
        }

        public TypeAnnotationWalker toTarget(int n) {
            return this;
        }

        public TypeAnnotationWalker toThrows(int n) {
            return this;
        }

        public TypeAnnotationWalker toTypeArgument(int n) {
            return this;
        }

        public TypeAnnotationWalker toMethodParameter(short s) {
            return this;
        }

        public TypeAnnotationWalker toSupertype(short s) {
            return this;
        }

        public TypeAnnotationWalker toTypeParameterBounds(boolean bl, int n) {
            return this;
        }

        public TypeAnnotationWalker toTypeBound(short s) {
            return this;
        }

        public TypeAnnotationWalker toTypeParameter(boolean bl, int n) {
            return this;
        }

        public TypeAnnotationWalker toNextDetail(int n) {
            return this;
        }

        public IBinaryAnnotation[] getAnnotationsAtCursor() {
            return NO_ANNOTATIONS;
        }
    };
    protected final IBinaryTypeAnnotation[] typeAnnotations;
    protected final long matches;
    protected final int pathPtr;

    public TypeAnnotationWalker(IBinaryTypeAnnotation[] iBinaryTypeAnnotationArray) {
        this(iBinaryTypeAnnotationArray, -1L >>> 64 - iBinaryTypeAnnotationArray.length);
    }

    TypeAnnotationWalker(IBinaryTypeAnnotation[] iBinaryTypeAnnotationArray, long l) {
        this(iBinaryTypeAnnotationArray, l, 0);
    }

    protected TypeAnnotationWalker(IBinaryTypeAnnotation[] iBinaryTypeAnnotationArray, long l, int n) {
        this.typeAnnotations = iBinaryTypeAnnotationArray;
        this.matches = l;
        this.pathPtr = n;
    }

    protected TypeAnnotationWalker restrict(long l, int n) {
        if (this.matches == l && this.pathPtr == n) {
            return this;
        }
        if (l == 0L || this.typeAnnotations == null || this.typeAnnotations.length == 0) {
            return EMPTY_ANNOTATION_WALKER;
        }
        return new TypeAnnotationWalker(this.typeAnnotations, l, n);
    }

    public TypeAnnotationWalker toField() {
        return this.toTarget(19);
    }

    public TypeAnnotationWalker toMethodReturn() {
        return this.toTarget(20);
    }

    public TypeAnnotationWalker toReceiver() {
        return this.toTarget(21);
    }

    protected TypeAnnotationWalker toTarget(int n) {
        long l = this.matches;
        if (l == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n2 = this.typeAnnotations.length;
        long l2 = 1L;
        int n3 = 0;
        while (n3 < n2) {
            if (this.typeAnnotations[n3].getTargetType() != n) {
                l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n3;
            l2 <<= 1;
        }
        return this.restrict(l, 0);
    }

    public TypeAnnotationWalker toTypeParameter(boolean bl, int n) {
        long l = this.matches;
        if (l == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n2 = bl ? 0 : 1;
        int n3 = this.typeAnnotations.length;
        long l2 = 1L;
        int n4 = 0;
        while (n4 < n3) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n4];
            if (iBinaryTypeAnnotation.getTargetType() != n2 || iBinaryTypeAnnotation.getTypeParameterIndex() != n) {
                l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n4;
            l2 <<= 1;
        }
        return this.restrict(l, 0);
    }

    public TypeAnnotationWalker toTypeParameterBounds(boolean bl, int n) {
        long l = this.matches;
        if (l == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n2 = this.typeAnnotations.length;
        int n3 = bl ? 17 : 18;
        long l2 = 1L;
        int n4 = 0;
        while (n4 < n2) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n4];
            if (iBinaryTypeAnnotation.getTargetType() != n3 || (short)iBinaryTypeAnnotation.getTypeParameterIndex() != n) {
                l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n4;
            l2 <<= 1;
        }
        return this.restrict(l, 0);
    }

    public TypeAnnotationWalker toTypeBound(short s) {
        long l = this.matches;
        if (l == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n = this.typeAnnotations.length;
        long l2 = 1L;
        int n2 = 0;
        while (n2 < n) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n2];
            if ((short)iBinaryTypeAnnotation.getBoundIndex() != s) {
                l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n2;
            l2 <<= 1;
        }
        return this.restrict(l, 0);
    }

    public TypeAnnotationWalker toSupertype(short s) {
        long l = this.matches;
        if (l == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n = this.typeAnnotations.length;
        long l2 = 1L;
        int n2 = 0;
        while (n2 < n) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n2];
            if (iBinaryTypeAnnotation.getTargetType() != 16 || (short)iBinaryTypeAnnotation.getSupertypeIndex() != s) {
                l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n2;
            l2 <<= 1;
        }
        return this.restrict(l, 0);
    }

    public TypeAnnotationWalker toMethodParameter(short s) {
        long l = this.matches;
        if (l == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n = this.typeAnnotations.length;
        long l2 = 1L;
        int n2 = 0;
        while (n2 < n) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n2];
            if (iBinaryTypeAnnotation.getTargetType() != 22 || (short)iBinaryTypeAnnotation.getMethodFormalParameterIndex() != s) {
                l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n2;
            l2 <<= 1;
        }
        return this.restrict(l, 0);
    }

    public TypeAnnotationWalker toThrows(int n) {
        long l = this.matches;
        if (l == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n2 = this.typeAnnotations.length;
        long l2 = 1L;
        int n3 = 0;
        while (n3 < n2) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n3];
            if (iBinaryTypeAnnotation.getTargetType() != 23 || iBinaryTypeAnnotation.getThrowsTypeIndex() != n) {
                l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n3;
            l2 <<= 1;
        }
        return this.restrict(l, 0);
    }

    public TypeAnnotationWalker toTypeArgument(int n) {
        long l = this.matches;
        if (l == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n2 = this.typeAnnotations.length;
        long l2 = 1L;
        int n3 = 0;
        while (n3 < n2) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n3];
            int[] nArray = iBinaryTypeAnnotation.getTypePath();
            if (this.pathPtr >= nArray.length || nArray[this.pathPtr] != 3 || nArray[this.pathPtr + 1] != n) {
                l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n3;
            l2 <<= 1;
        }
        return this.restrict(l, this.pathPtr + 2);
    }

    public TypeAnnotationWalker toWildcardBound() {
        long l = this.matches;
        if (l == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n = this.typeAnnotations.length;
        long l2 = 1L;
        int n2 = 0;
        while (n2 < n) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n2];
            int[] nArray = iBinaryTypeAnnotation.getTypePath();
            if (this.pathPtr >= nArray.length || nArray[this.pathPtr] != 2) {
                l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n2;
            l2 <<= 1;
        }
        return this.restrict(l, this.pathPtr + 2);
    }

    public TypeAnnotationWalker toNextArrayDimension() {
        return this.toNextDetail(0);
    }

    public TypeAnnotationWalker toNextNestedType() {
        return this.toNextDetail(1);
    }

    protected TypeAnnotationWalker toNextDetail(int n) {
        long l = this.matches;
        if (l == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n2 = this.typeAnnotations.length;
        long l2 = 1L;
        int n3 = 0;
        while (n3 < n2) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n3];
            int[] nArray = iBinaryTypeAnnotation.getTypePath();
            if (this.pathPtr >= nArray.length || nArray[this.pathPtr] != n) {
                l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n3;
            l2 <<= 1;
        }
        return this.restrict(l, this.pathPtr + 2);
    }

    public IBinaryAnnotation[] getAnnotationsAtCursor() {
        int n = this.typeAnnotations.length;
        IBinaryAnnotation[] iBinaryAnnotationArray = new IBinaryAnnotation[n];
        long l = 1L;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation;
            if ((this.matches & l) != 0L && (iBinaryTypeAnnotation = this.typeAnnotations[n3]).getTypePath().length <= this.pathPtr) {
                iBinaryAnnotationArray[n2++] = iBinaryTypeAnnotation.getAnnotation();
            }
            ++n3;
            l <<= 1;
        }
        if (n2 == 0) {
            return NO_ANNOTATIONS;
        }
        if (n2 < n) {
            IBinaryAnnotation[] iBinaryAnnotationArray2 = iBinaryAnnotationArray;
            iBinaryAnnotationArray = new IBinaryAnnotation[n2];
            System.arraycopy(iBinaryAnnotationArray2, 0, iBinaryAnnotationArray, 0, n2);
        }
        return iBinaryAnnotationArray;
    }
}

