/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.AbstractAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileFinder;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.CompilerStats;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.GenericXMLWriter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfInt;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Main
implements ProblemSeverities,
SuffixConstants {
    boolean enableJavadocOn;
    boolean warnJavadocOn;
    boolean warnAllJavadocOn;
    public Compiler batchCompiler;
    public ResourceBundle bundle;
    protected FileSystem.Classpath[] checkedClasspaths;
    public Locale compilerLocale;
    public CompilerOptions compilerOptions;
    public CompilationProgress progress;
    public String destinationPath;
    public String[] destinationPaths;
    private boolean didSpecifySource;
    private boolean didSpecifyTarget;
    public String[] encodings;
    public int exportedClassFilesCounter;
    public String[] filenames;
    public String[] classNames;
    public int globalErrorsCount;
    public int globalProblemsCount;
    public int globalTasksCount;
    public int globalWarningsCount;
    private File javaHomeCache;
    private boolean javaHomeChecked = false;
    public long lineCount0;
    public String log;
    public Logger logger;
    public int maxProblems;
    public Map options;
    public char[][] ignoreOptionalProblemsFromFolders;
    protected PrintWriter out;
    public boolean proceed = true;
    public boolean proceedOnError = false;
    public boolean produceRefInfo = false;
    public int currentRepetition;
    public int maxRepetition;
    public boolean showProgress = false;
    public long startTime;
    public ArrayList pendingErrors;
    public boolean systemExitWhenFinished = true;
    public static final int TIMING_DISABLED = 0;
    public static final int TIMING_ENABLED = 1;
    public static final int TIMING_DETAILED = 2;
    public int timing = 0;
    public CompilerStats[] compilerStats;
    public boolean verbose = false;
    private String[] expandedCommandLine;
    private PrintWriter err;
    protected ArrayList extraProblems;
    public static final String bundleName = "org.eclipse.jdt.internal.compiler.batch.messages";
    public static final int DEFAULT_SIZE_CLASSPATH = 4;
    public static final String NONE = "none";

    public static boolean compile(String string) {
        return new Main(new PrintWriter(System.out), new PrintWriter(System.err), false, null, null).compile(Main.tokenize(string));
    }

    public static boolean compile(String string, PrintWriter printWriter, PrintWriter printWriter2) {
        return new Main(printWriter, printWriter2, false, null, null).compile(Main.tokenize(string));
    }

    public static boolean compile(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2, CompilationProgress compilationProgress) {
        return new Main(printWriter, printWriter2, false, null, compilationProgress).compile(stringArray);
    }

    public static File[][] getLibrariesFiles(File[] fileArray) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return Util.isPotentialZipArchive(string);
            }
        };
        int n = fileArray.length;
        File[][] fileArray2 = new File[n][];
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists() && file.isDirectory()) {
                fileArray2[n2] = file.listFiles(filenameFilter);
            }
            ++n2;
        }
        return fileArray2;
    }

    public static void main(String[] stringArray) {
        new Main(new PrintWriter(System.out), new PrintWriter(System.err), true, null, null).compile(stringArray);
    }

    public static String[] tokenize(String string) {
        int n = 0;
        String[] stringArray = new String[10];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"", true);
        String string2 = Util.EMPTY_STRING;
        boolean bl = false;
        boolean bl2 = true;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals(" ")) {
                if (bl) {
                    int n2 = n - 1;
                    stringArray[n2] = String.valueOf(stringArray[n2]) + string2;
                    bl2 = false;
                    continue;
                }
                bl2 = true;
                continue;
            }
            if (string2.equals("\"")) {
                if (!bl && bl2) {
                    if (n == stringArray.length) {
                        String[] stringArray2 = stringArray;
                        stringArray = new String[n * 2];
                        System.arraycopy(stringArray2, 0, stringArray, 0, n);
                    }
                    stringArray[n++] = Util.EMPTY_STRING;
                }
                bl = !bl;
                bl2 = false;
                continue;
            }
            if (bl) {
                int n3 = n - 1;
                stringArray[n3] = String.valueOf(stringArray[n3]) + string2;
            } else if (string2.length() > 0 && !bl2) {
                int n4 = n - 1;
                stringArray[n4] = String.valueOf(stringArray[n4]) + string2;
            } else {
                String string3;
                if (n == stringArray.length) {
                    String[] stringArray3 = stringArray;
                    stringArray = new String[n * 2];
                    System.arraycopy(stringArray3, 0, stringArray, 0, n);
                }
                if ((string3 = string2.trim()).length() != 0) {
                    stringArray[n++] = string3;
                }
            }
            bl2 = false;
        }
        String[] stringArray4 = stringArray;
        stringArray = new String[n];
        System.arraycopy(stringArray4, 0, stringArray, 0, n);
        return stringArray;
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        this(printWriter, printWriter2, bl, null, null);
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map) {
        this(printWriter, printWriter2, bl, map, null);
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map, CompilationProgress compilationProgress) {
        this.initialize(printWriter, printWriter2, bl, map, compilationProgress);
        this.relocalize();
    }

    public void addExtraProblems(CategorizedProblem categorizedProblem) {
        if (this.extraProblems == null) {
            this.extraProblems = new ArrayList();
        }
        this.extraProblems.add(categorizedProblem);
    }

    protected void addNewEntry(ArrayList arrayList, String string, ArrayList arrayList2, String string2, String string3, boolean bl, boolean bl2) {
        Object object;
        int n = arrayList2.size();
        AccessRuleSet accessRuleSet = null;
        if (n != 0) {
            object = new AccessRule[arrayList2.size()];
            boolean bl3 = true;
            Iterator iterator = arrayList2.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                char c = string4.charAt(0);
                String string5 = string4.substring(1);
                if (string5.length() > 0) {
                    switch (c) {
                        case '+': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0);
                            break;
                        }
                        case '~': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000118);
                            break;
                        }
                        case '-': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000133);
                            break;
                        }
                        case '?': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000133, true);
                            break;
                        }
                        default: {
                            bl3 = false;
                            break;
                        }
                    }
                    continue;
                }
                bl3 = false;
            }
            if (bl3) {
                accessRuleSet = new AccessRuleSet((AccessRule[])object, 0, string);
            } else {
                if (string.length() != 0) {
                    this.addPendingErrors(this.bind("configure.incorrectClasspath", string));
                }
                return;
            }
        }
        if (NONE.equals(string3)) {
            string3 = NONE;
        }
        if (bl2 && string3 != null && Util.isPotentialZipArchive(string)) {
            throw new IllegalArgumentException(this.bind("configure.unexpectedDestinationPathEntryFile", string));
        }
        object = FileSystem.getClasspath(string, string2, bl, accessRuleSet, string3);
        if (object != null) {
            arrayList.add(object);
        } else if (string.length() != 0) {
            this.addPendingErrors(this.bind("configure.incorrectClasspath", string));
        }
    }

    void addPendingErrors(String string) {
        if (this.pendingErrors == null) {
            this.pendingErrors = new ArrayList();
        }
        this.pendingErrors.add(string);
    }

    public String bind(String string) {
        return this.bind(string, (String[])null);
    }

    public String bind(String string, String string2) {
        return this.bind(string, new String[]{string2});
    }

    public String bind(String string, String string2, String string3) {
        return this.bind(string, new String[]{string2, string3});
    }

    public String bind(String string, String[] stringArray) {
        if (string == null) {
            return "No message available";
        }
        String string2 = null;
        try {
            string2 = this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + string + " in: " + bundleName;
        }
        return MessageFormat.format(string2, stringArray);
    }

    private boolean checkVMVersion(long l) {
        int n;
        String string = System.getProperty("java.class.version");
        if (string == null) {
            return false;
        }
        int n2 = string.indexOf(46);
        if (n2 == -1) {
            return false;
        }
        try {
            n = Integer.parseInt(string.substring(0, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        switch (n) {
            case 45: {
                return 2949123L >= l;
            }
            case 46: {
                return 0x2E0000L >= l;
            }
            case 47: {
                return 0x2F0000L >= l;
            }
            case 48: {
                return 0x300000L >= l;
            }
            case 49: {
                return 0x310000L >= l;
            }
            case 50: {
                return 0x320000L >= l;
            }
            case 51: {
                return 0x330000L >= l;
            }
            case 52: {
                return 0x340000L >= l;
            }
        }
        return false;
    }

    public boolean compile(String[] stringArray) {
        try {
            try {
                this.configure(stringArray);
                if (this.progress != null) {
                    this.progress.begin(this.filenames == null ? 0 : this.filenames.length * this.maxRepetition);
                }
                if (this.proceed) {
                    if (this.showProgress) {
                        this.logger.compiling();
                    }
                    this.currentRepetition = 0;
                    while (this.currentRepetition < this.maxRepetition) {
                        this.globalProblemsCount = 0;
                        this.globalErrorsCount = 0;
                        this.globalWarningsCount = 0;
                        this.globalTasksCount = 0;
                        this.exportedClassFilesCounter = 0;
                        if (this.maxRepetition > 1) {
                            this.logger.flush();
                            this.logger.logRepetition(this.currentRepetition, this.maxRepetition);
                        }
                        this.performCompilation();
                        ++this.currentRepetition;
                    }
                    if (this.compilerStats != null) {
                        this.logger.logAverage();
                    }
                    if (this.showProgress) {
                        this.logger.printNewLine();
                    }
                }
                if (this.systemExitWhenFinished) {
                    this.logger.flush();
                    this.logger.close();
                    System.exit(this.globalErrorsCount > 0 ? -1 : 0);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.logException(illegalArgumentException);
                if (this.systemExitWhenFinished) {
                    this.logger.flush();
                    this.logger.close();
                    System.exit(-1);
                }
                this.logger.flush();
                this.logger.close();
                if (this.progress != null) {
                    this.progress.done();
                }
                return false;
            }
            catch (RuntimeException runtimeException) {
                this.logger.logException(runtimeException);
                if (this.systemExitWhenFinished) {
                    this.logger.flush();
                    this.logger.close();
                    System.exit(-1);
                }
                this.logger.flush();
                this.logger.close();
                if (this.progress != null) {
                    this.progress.done();
                }
                return false;
            }
        }
        finally {
            this.logger.flush();
            this.logger.close();
            if (this.progress != null) {
                this.progress.done();
            }
        }
        return this.globalErrorsCount == 0 && (this.progress == null || !this.progress.isCanceled());
    }

    /*
     * Unable to fully structure code
     */
    public void configure(String[] var1_1) {
        if (var1_1 == null || var1_1.length == 0) {
            this.printUsage();
            return;
        }
        var2_2 = new ArrayList<E>(4);
        var3_3 = null;
        var4_4 = new ArrayList<E>(4);
        var5_5 = new ArrayList<E>(4);
        var6_6 = null;
        var7_7 = null;
        var8_8 = -1;
        var9_9 = 0;
        var10_10 = 0;
        var11_11 = var1_1.length;
        var12_12 = 0;
        this.maxRepetition = 0;
        var13_13 = false;
        var14_14 = null;
        var15_15 = false;
        var16_16 = false;
        var17_17 = false;
        var18_18 = false;
        var19_19 = null;
        var20_20 = null;
        var21_21 = null;
        var22_22 = Util.EMPTY_STRING;
        var23_23 = null;
        var24_24 = false;
        var25_25 = 0;
        while (var25_25 < var11_11) {
            if (var1_1[var25_25].startsWith("@")) {
                var24_24 = true;
                break;
            }
            ++var25_25;
        }
        var25_26 = null;
        if (var24_24) {
            var25_26 = new String[var11_11];
            var8_8 = 0;
            var26_27 = 0;
            while (var26_27 < var11_11) {
                var27_43 = null;
                var28_55 = var1_1[var26_27].trim();
                if (var28_55.startsWith("@")) {
                    try {
                        var29_61 = new LineNumberReader(new StringReader(new String(Util.getFileCharContent(new File(var28_55.substring(1)), null))));
                        var30_68 = new StringBuffer();
                        while ((var31_73 = var29_61.readLine()) != null) {
                            if ((var31_73 = var31_73.trim()).startsWith("#")) continue;
                            var30_68.append(var31_73).append(" ");
                        }
                        var27_43 = Main.tokenize(var30_68.toString());
                    }
                    catch (IOException v0) {
                        throw new IllegalArgumentException(this.bind("configure.invalidexpansionargumentname", var28_55));
                    }
                }
                if (var27_43 != null) {
                    var29_62 = var25_26.length;
                    var30_69 = var27_43.length;
                    v1 = var25_26;
                    var25_26 = new String[var29_62 + var30_69 - 1];
                    System.arraycopy(v1, 0, var25_26, 0, var8_8);
                    System.arraycopy(var27_43, 0, var25_26, var8_8, var30_69);
                    var8_8 += var30_69;
                } else {
                    var25_26[var8_8++] = var28_55;
                }
                ++var26_27;
            }
            var8_8 = -1;
        } else {
            var25_26 = var1_1;
            var26_27 = 0;
            while (var26_27 < var11_11) {
                var25_26[var26_27] = var25_26[var26_27].trim();
                ++var26_27;
            }
        }
        var11_11 = var25_26.length;
        this.expandedCommandLine = var25_26;
        block55: while (++var8_8 < var11_11) {
            if (var19_19 != null) {
                throw new IllegalArgumentException(this.bind("configure.unexpectedCustomEncoding", var22_22, var19_19));
            }
            var22_22 = var25_26[var8_8];
            switch (var12_12) {
                case 0: {
                    if (var22_22.startsWith("-nowarn")) {
                        switch (var22_22.length()) {
                            case 7: {
                                this.disableAll(0);
                                break;
                            }
                            case 8: {
                                throw new IllegalArgumentException(this.bind("configure.invalidNowarnOption", var22_22));
                            }
                            default: {
                                var26_28 = var22_22.indexOf(91) + 1;
                                var27_45 = var22_22.lastIndexOf(93);
                                if (var26_28 <= 8 || var27_45 == -1 || var26_28 > var27_45 || var27_45 < var22_22.length() - 1) {
                                    throw new IllegalArgumentException(this.bind("configure.invalidNowarnOption", var22_22));
                                }
                                var28_56 = var22_22.substring(var26_28, var27_45);
                                if (var28_56.length() > 0) {
                                    var29_63 = Main.decodeIgnoreOptionalProblemsFromFolders(var28_56);
                                    if (this.ignoreOptionalProblemsFromFolders != null) {
                                        var30_70 = this.ignoreOptionalProblemsFromFolders.length + var29_63.length;
                                        var31_75 = new char[var30_70][];
                                        System.arraycopy(this.ignoreOptionalProblemsFromFolders, 0, var31_75, 0, this.ignoreOptionalProblemsFromFolders.length);
                                        System.arraycopy(var29_63, 0, var31_75, this.ignoreOptionalProblemsFromFolders.length, var29_63.length);
                                        this.ignoreOptionalProblemsFromFolders = var31_75;
                                        break;
                                    }
                                    this.ignoreOptionalProblemsFromFolders = var29_63;
                                    break;
                                }
                                throw new IllegalArgumentException(this.bind("configure.invalidNowarnOption", var22_22));
                            }
                        }
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.startsWith("[")) {
                        throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", var22_22));
                    }
                    if (var22_22.endsWith("]")) {
                        var26_29 = var22_22.indexOf(91) + 1;
                        if (var26_29 <= 1) {
                            throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", var22_22));
                        }
                        var27_46 = var22_22.length() - 1;
                        if (var26_29 >= 1) {
                            if (var26_29 < var27_46) {
                                var19_19 = var22_22.substring(var26_29, var27_46);
                                try {
                                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), var19_19);
                                }
                                catch (UnsupportedEncodingException v2) {
                                    throw new IllegalArgumentException(this.bind("configure.unsupportedEncoding", var19_19));
                                }
                            }
                            var22_22 = var22_22.substring(0, var26_29 - 1);
                        }
                    }
                    if (var22_22.endsWith(".java")) {
                        if (this.filenames == null) {
                            this.filenames = new String[var11_11 - var8_8];
                            this.encodings = new String[var11_11 - var8_8];
                            this.destinationPaths = new String[var11_11 - var8_8];
                        } else if (var9_9 == this.filenames.length) {
                            var26_30 = this.filenames.length;
                            this.filenames = new String[var26_30 + var11_11 - var8_8];
                            System.arraycopy(this.filenames, 0, this.filenames, 0, var26_30);
                            this.encodings = new String[var26_30 + var11_11 - var8_8];
                            System.arraycopy(this.encodings, 0, this.encodings, 0, var26_30);
                            this.destinationPaths = new String[var26_30 + var11_11 - var8_8];
                            System.arraycopy(this.destinationPaths, 0, this.destinationPaths, 0, var26_30);
                        }
                        this.filenames[var9_9] = var22_22;
                        this.encodings[var9_9++] = var19_19;
                        var19_19 = null;
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-log")) {
                        if (this.log != null) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateLog", var22_22));
                        }
                        var12_12 = 5;
                        break;
                    }
                    if (var22_22.equals("-repeat")) {
                        if (this.maxRepetition > 0) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateRepeat", var22_22));
                        }
                        var12_12 = 6;
                        break;
                    }
                    if (var22_22.equals("-maxProblems")) {
                        if (this.maxProblems > 0) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateMaxProblems", var22_22));
                        }
                        var12_12 = 11;
                        break;
                    }
                    if (var22_22.equals("-source")) {
                        var12_12 = 7;
                        break;
                    }
                    if (var22_22.equals("-encoding")) {
                        var12_12 = 8;
                        break;
                    }
                    if (var22_22.equals("-1.3")) {
                        if (var17_17) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", var22_22));
                        }
                        var17_17 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-1.4")) {
                        if (var17_17) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", var22_22));
                        }
                        var17_17 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-1.5") || var22_22.equals("-5") || var22_22.equals("-5.0")) {
                        if (var17_17) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", var22_22));
                        }
                        var17_17 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-1.6") || var22_22.equals("-6") || var22_22.equals("-6.0")) {
                        if (var17_17) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", var22_22));
                        }
                        var17_17 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-1.7") || var22_22.equals("-7") || var22_22.equals("-7.0")) {
                        if (var17_17) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", var22_22));
                        }
                        var17_17 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-1.8") || var22_22.equals("-8") || var22_22.equals("-8.0")) {
                        if (var17_17) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", var22_22));
                        }
                        var17_17 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.8");
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-d")) {
                        if (this.destinationPath != null) {
                            var26_31 = new StringBuffer();
                            var26_31.append(var22_22);
                            if (var8_8 + 1 < var11_11) {
                                var26_31.append(' ');
                                var26_31.append(var25_26[var8_8 + 1]);
                            }
                            throw new IllegalArgumentException(this.bind("configure.duplicateOutputPath", var26_31.toString()));
                        }
                        var12_12 = 3;
                        break;
                    }
                    if (var22_22.equals("-classpath") || var22_22.equals("-cp")) {
                        var12_12 = 1;
                        break;
                    }
                    if (var22_22.equals("-bootclasspath")) {
                        if (var2_2.size() > 0) {
                            var26_32 = new StringBuffer();
                            var26_32.append(var22_22);
                            if (var8_8 + 1 < var11_11) {
                                var26_32.append(' ');
                                var26_32.append(var25_26[var8_8 + 1]);
                            }
                            throw new IllegalArgumentException(this.bind("configure.duplicateBootClasspath", var26_32.toString()));
                        }
                        var12_12 = 9;
                        break;
                    }
                    if (var22_22.equals("-sourcepath")) {
                        if (var3_3 != null) {
                            var26_33 = new StringBuffer();
                            var26_33.append(var22_22);
                            if (var8_8 + 1 < var11_11) {
                                var26_33.append(' ');
                                var26_33.append(var25_26[var8_8 + 1]);
                            }
                            throw new IllegalArgumentException(this.bind("configure.duplicateSourcepath", var26_33.toString()));
                        }
                        var12_12 = 13;
                        break;
                    }
                    if (var22_22.equals("-extdirs")) {
                        if (var6_6 != null) {
                            var26_34 = new StringBuffer();
                            var26_34.append(var22_22);
                            if (var8_8 + 1 < var11_11) {
                                var26_34.append(' ');
                                var26_34.append(var25_26[var8_8 + 1]);
                            }
                            throw new IllegalArgumentException(this.bind("configure.duplicateExtDirs", var26_34.toString()));
                        }
                        var12_12 = 12;
                        break;
                    }
                    if (var22_22.equals("-endorseddirs")) {
                        if (var7_7 != null) {
                            var26_35 = new StringBuffer();
                            var26_35.append(var22_22);
                            if (var8_8 + 1 < var11_11) {
                                var26_35.append(' ');
                                var26_35.append(var25_26[var8_8 + 1]);
                            }
                            throw new IllegalArgumentException(this.bind("configure.duplicateEndorsedDirs", var26_35.toString()));
                        }
                        var12_12 = 15;
                        break;
                    }
                    if (var22_22.equals("-progress")) {
                        var12_12 = 0;
                        this.showProgress = true;
                        break;
                    }
                    if (!var22_22.startsWith("-proceedOnError")) ** GOTO lbl300
                    var12_12 = 0;
                    var26_36 = var22_22.length();
                    if (var26_36 <= 15) ** GOTO lbl296
                    if (var22_22.equals("-proceedOnError:Fatal")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "enabled");
                    } else {
                        throw new IllegalArgumentException(this.bind("configure.invalidWarningConfiguration", var22_22));
lbl296:
                        // 1 sources

                        this.options.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "disabled");
                    }
                    this.proceedOnError = true;
                    break;
lbl300:
                    // 1 sources

                    if (var22_22.equals("-time")) {
                        var12_12 = 0;
                        this.timing = 1;
                        break;
                    }
                    if (var22_22.equals("-time:detail")) {
                        var12_12 = 0;
                        this.timing = 3;
                        break;
                    }
                    if (var22_22.equals("-version") || var22_22.equals("-v")) {
                        this.logger.logVersion(true);
                        this.proceed = false;
                        return;
                    }
                    if (var22_22.equals("-showversion")) {
                        var15_15 = true;
                        var12_12 = 0;
                        break;
                    }
                    if ("-deprecation".equals(var22_22)) {
                        var16_16 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-help") || var22_22.equals("-?")) {
                        var13_13 = true;
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-help:warn") || var22_22.equals("-?:warn")) {
                        var13_13 = true;
                        var14_14 = "misc.usage.warn";
                        break;
                    }
                    if (var22_22.equals("-noExit")) {
                        this.systemExitWhenFinished = false;
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-verbose")) {
                        this.verbose = true;
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-referenceInfo")) {
                        this.produceRefInfo = true;
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-inlineJSR")) {
                        var12_12 = 0;
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
                        break;
                    }
                    if (var22_22.equals("-parameters")) {
                        var12_12 = 0;
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.methodParameters", "generate");
                        break;
                    }
                    if (var22_22.startsWith("-g")) {
                        var12_12 = 0;
                        var26_37 = var22_22;
                        var27_47 = var22_22.length();
                        if (var27_47 == 2) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                            break;
                        }
                        if (var27_47 > 3) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
                            if (var27_47 == 7 && var26_37.equals("-g:none")) continue block55;
                            var28_57 = new StringTokenizer(var26_37.substring(3, var26_37.length()), ",");
                            while (var28_57.hasMoreTokens()) {
                                var29_64 = var28_57.nextToken();
                                if (var29_64.equals("vars")) {
                                    this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                                    continue;
                                }
                                if (var29_64.equals("lines")) {
                                    this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                                    continue;
                                }
                                if (var29_64.equals("source")) {
                                    this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                                    continue;
                                }
                                throw new IllegalArgumentException(this.bind("configure.invalidDebugOption", var26_37));
                            }
                            continue block55;
                        }
                        throw new IllegalArgumentException(this.bind("configure.invalidDebugOption", var26_37));
                    }
                    if (var22_22.startsWith("-warn")) {
                        var12_12 = 0;
                        var26_38 = var22_22;
                        var27_48 = var22_22.length();
                        if (var27_48 == 10 && var26_38.equals("-warn:none")) {
                            this.disableAll(0);
                            break;
                        }
                        if (var27_48 <= 6) {
                            throw new IllegalArgumentException(this.bind("configure.invalidWarningConfiguration", var26_38));
                        }
                        switch (var26_38.charAt(6)) {
                            case '+': {
                                var28_58 = 7;
                                var29_65 = true;
                                break;
                            }
                            case '-': {
                                var28_58 = 7;
                                var29_65 = false;
                                break;
                            }
                            default: {
                                this.disableAll(0);
                                var28_58 = 6;
                                var29_65 = true;
                            }
                        }
                        var30_71 = new StringTokenizer(var26_38.substring(var28_58, var26_38.length()), ",");
                        var31_76 = 0;
                        if (var16_16) {
                            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                        }
                        while (var30_71.hasMoreTokens()) {
                            var32_78 = var30_71.nextToken();
                            ++var31_76;
                            switch (var32_78.charAt(0)) {
                                case '+': {
                                    var29_65 = true;
                                    var32_78 = var32_78.substring(1);
                                    break;
                                }
                                case '-': {
                                    var29_65 = false;
                                    var32_78 = var32_78.substring(1);
                                }
                            }
                            this.handleWarningToken(var32_78, var29_65);
                        }
                        if (var31_76 != 0) continue block55;
                        throw new IllegalArgumentException(this.bind("configure.invalidWarningOption", var22_22));
                    }
                    if (var22_22.startsWith("-err")) {
                        var12_12 = 0;
                        var26_39 = var22_22;
                        var27_49 = var22_22.length();
                        if (var27_49 <= 5) {
                            throw new IllegalArgumentException(this.bind("configure.invalidErrorConfiguration", var26_39));
                        }
                        switch (var26_39.charAt(5)) {
                            case '+': {
                                var28_59 = 6;
                                var29_66 = true;
                                break;
                            }
                            case '-': {
                                var28_59 = 6;
                                var29_66 = false;
                                break;
                            }
                            default: {
                                this.disableAll(1);
                                var28_59 = 5;
                                var29_66 = true;
                            }
                        }
                        var30_72 = new StringTokenizer(var26_39.substring(var28_59, var26_39.length()), ",");
                        var31_77 = 0;
                        while (var30_72.hasMoreTokens()) {
                            var32_78 = var30_72.nextToken();
                            ++var31_77;
                            switch (var32_78.charAt(0)) {
                                case '+': {
                                    var29_66 = true;
                                    var32_78 = var32_78.substring(1);
                                    break;
                                }
                                case '-': {
                                    var29_66 = false;
                                    var32_78 = var32_78.substring(1);
                                }
                            }
                            this.handleErrorToken(var32_78, var29_66);
                        }
                        if (var31_77 != 0) continue block55;
                        throw new IllegalArgumentException(this.bind("configure.invalidErrorOption", var22_22));
                    }
                    if (var22_22.equals("-target")) {
                        var12_12 = 4;
                        break;
                    }
                    if (var22_22.equals("-preserveAllLocals")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-enableJavadoc")) {
                        var12_12 = 0;
                        this.enableJavadocOn = true;
                        break;
                    }
                    if (var22_22.equals("-Xemacs")) {
                        var12_12 = 0;
                        this.logger.setEmacs();
                        break;
                    }
                    if (var22_22.startsWith("-A")) {
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-processorpath")) {
                        var12_12 = 17;
                        break;
                    }
                    if (var22_22.equals("-processor")) {
                        var12_12 = 18;
                        break;
                    }
                    if (var22_22.equals("-proc:only")) {
                        this.options.put("org.eclipse.jdt.core.compiler.generateClassFiles", "disabled");
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-proc:none")) {
                        var18_18 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.processAnnotations", "disabled");
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-s")) {
                        var12_12 = 19;
                        break;
                    }
                    if (var22_22.equals("-XprintProcessorInfo") || var22_22.equals("-XprintRounds")) {
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.startsWith("-X")) {
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.startsWith("-J")) {
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-O")) {
                        var12_12 = 0;
                        break;
                    }
                    if (var22_22.equals("-classNames")) {
                        var12_12 = 20;
                        break;
                    }
                    if (var22_22.equals("-properties")) {
                        var12_12 = 21;
                        break;
                    }
                    if (var22_22.equals("-missingNullDefault")) {
                        this.options.put("org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation", "warning");
                        break;
                    }
                    ** GOTO lbl726
                }
                case 4: {
                    if (this.didSpecifyTarget) {
                        throw new IllegalArgumentException(this.bind("configure.duplicateTarget", var22_22));
                    }
                    this.didSpecifyTarget = true;
                    if (var22_22.equals("1.1")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                    } else if (var22_22.equals("1.2")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                    } else if (var22_22.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
                    } else if (var22_22.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    } else if (var22_22.equals("1.5") || var22_22.equals("5") || var22_22.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    } else if (var22_22.equals("1.6") || var22_22.equals("6") || var22_22.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    } else if (var22_22.equals("1.7") || var22_22.equals("7") || var22_22.equals("7.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                    } else if (var22_22.equals("1.8") || var22_22.equals("8") || var22_22.equals("8.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
                    } else if (var22_22.equals("jsr14")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "jsr14");
                    } else if (var22_22.equals("cldc1.1")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "cldc1.1");
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
                    } else {
                        throw new IllegalArgumentException(this.bind("configure.targetJDK", var22_22));
                    }
                    var12_12 = 0;
                    break;
                }
                case 5: {
                    this.log = var22_22;
                    var12_12 = 0;
                    break;
                }
                case 6: {
                    try {
                        this.maxRepetition = Integer.parseInt(var22_22);
                        if (this.maxRepetition <= 0) {
                            throw new IllegalArgumentException(this.bind("configure.repetition", var22_22));
                        }
                    }
                    catch (NumberFormatException v3) {
                        throw new IllegalArgumentException(this.bind("configure.repetition", var22_22));
                    }
                    var12_12 = 0;
                    break;
                }
                case 11: {
                    try {
                        this.maxProblems = Integer.parseInt(var22_22);
                        if (this.maxProblems <= 0) {
                            throw new IllegalArgumentException(this.bind("configure.maxProblems", var22_22));
                        }
                        this.options.put("org.eclipse.jdt.core.compiler.maxProblemPerUnit", var22_22);
                    }
                    catch (NumberFormatException v4) {
                        throw new IllegalArgumentException(this.bind("configure.maxProblems", var22_22));
                    }
                    var12_12 = 0;
                    break;
                }
                case 7: {
                    if (this.didSpecifySource) {
                        throw new IllegalArgumentException(this.bind("configure.duplicateSource", var22_22));
                    }
                    this.didSpecifySource = true;
                    if (var22_22.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                    } else if (var22_22.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.4");
                    } else if (var22_22.equals("1.5") || var22_22.equals("5") || var22_22.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                    } else if (var22_22.equals("1.6") || var22_22.equals("6") || var22_22.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                    } else if (var22_22.equals("1.7") || var22_22.equals("7") || var22_22.equals("7.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.7");
                    } else if (var22_22.equals("1.8") || var22_22.equals("8") || var22_22.equals("8.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.8");
                    } else {
                        throw new IllegalArgumentException(this.bind("configure.source", var22_22));
                    }
                    var12_12 = 0;
                    break;
                }
                case 8: {
                    if (var23_23 != null) {
                        if (!var23_23.contains(var22_22)) {
                            if (var23_23.size() > 1) {
                                this.logger.logWarning(this.bind("configure.differentencodings", var22_22, Main.getAllEncodings(var23_23)));
                            } else {
                                this.logger.logWarning(this.bind("configure.differentencoding", var22_22, Main.getAllEncodings(var23_23)));
                            }
                        }
                    } else {
                        var23_23 = new HashSet<String>();
                    }
                    try {
                        new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), var22_22);
                    }
                    catch (UnsupportedEncodingException v5) {
                        throw new IllegalArgumentException(this.bind("configure.unsupportedEncoding", var22_22));
                    }
                    var23_23.add(var22_22);
                    this.options.put("org.eclipse.jdt.core.encoding", var22_22);
                    var12_12 = 0;
                    break;
                }
                case 3: {
                    this.setDestinationPath(var22_22.equals("none") != false ? "none" : var22_22);
                    var12_12 = 0;
                    break;
                }
                case 1: {
                    var12_12 = 0;
                    var8_8 += this.processPaths(var25_26, var8_8, var22_22, var5_5);
                    break;
                }
                case 9: {
                    var12_12 = 0;
                    var8_8 += this.processPaths(var25_26, var8_8, var22_22, var2_2);
                    break;
                }
                case 13: {
                    var12_12 = 0;
                    var26_40 = new String[1];
                    var8_8 += this.processPaths(var25_26, var8_8, var22_22, var26_40);
                    var3_3 = var26_40[0];
                    break;
                }
                case 12: {
                    if (var22_22.indexOf("[-d") != -1) {
                        throw new IllegalArgumentException(this.bind("configure.unexpectedDestinationPathEntry", "-extdir"));
                    }
                    var27_50 = new StringTokenizer(var22_22, File.pathSeparator, false);
                    var6_6 = new ArrayList<String>(4);
                    while (var27_50.hasMoreTokens()) {
                        var6_6.add(var27_50.nextToken());
                    }
                    var12_12 = 0;
                    break;
                }
                case 15: {
                    if (var22_22.indexOf("[-d") != -1) {
                        throw new IllegalArgumentException(this.bind("configure.unexpectedDestinationPathEntry", "-endorseddirs"));
                    }
                    var27_51 = new StringTokenizer(var22_22, File.pathSeparator, false);
                    var7_7 = new ArrayList<String>(4);
                    while (var27_51.hasMoreTokens()) {
                        var7_7.add(var27_51.nextToken());
                    }
                    var12_12 = 0;
                    break;
                }
                case 16: {
                    if (!var22_22.endsWith("]")) ** GOTO lbl700
                    var20_20 = var22_22.substring(0, var22_22.length() - 1);
                    ** GOTO lbl726
lbl700:
                    // 1 sources

                    throw new IllegalArgumentException(this.bind("configure.incorrectDestinationPathEntry", "[-d " + var22_22));
                }
                case 17: {
                    var12_12 = 0;
                    break;
                }
                case 18: {
                    var12_12 = 0;
                    break;
                }
                case 19: {
                    var12_12 = 0;
                    break;
                }
                case 20: {
                    var27_52 = new StringTokenizer(var22_22, ",");
                    if (this.classNames == null) {
                        this.classNames = new String[4];
                    }
                    while (var27_52.hasMoreTokens()) {
                        if (this.classNames.length == var10_10) {
                            this.classNames = new String[var10_10 * 2];
                            System.arraycopy(this.classNames, 0, this.classNames, 0, var10_10);
                        }
                        this.classNames[var10_10++] = var27_52.nextToken();
                    }
                    var12_12 = 0;
                    break;
                }
                case 21: {
                    this.initializeWarnings(var22_22);
                    var12_12 = 0;
                    break;
                }
lbl726:
                // 3 sources

                default: {
                    if (var20_20 == null) {
                        if (File.separatorChar != '/') {
                            var22_22 = var22_22.replace('/', File.separatorChar);
                        }
                        if (var22_22.endsWith("[-d")) {
                            var21_21 = var22_22.substring(0, var22_22.length() - 3);
                            var12_12 = 16;
                            break;
                        }
                        var21_21 = var22_22;
                    }
                    if (!(var26_41 = new File(var21_21)).isDirectory()) {
                        throw new IllegalArgumentException(this.bind("configure.unrecognizedOption", var21_21));
                    }
                    var27_53 = FileFinder.find(var26_41, ".JAVA");
                    if ("none".equals(var20_20)) {
                        var20_20 = "none";
                    }
                    if (this.filenames != null) {
                        var28_60 = var27_53.length;
                        this.filenames = new String[var28_60 + var9_9];
                        System.arraycopy(this.filenames, 0, this.filenames, 0, var9_9);
                        this.encodings = new String[var28_60 + var9_9];
                        System.arraycopy(this.encodings, 0, this.encodings, 0, var9_9);
                        this.destinationPaths = new String[var28_60 + var9_9];
                        System.arraycopy(this.destinationPaths, 0, this.destinationPaths, 0, var9_9);
                        System.arraycopy(var27_53, 0, this.filenames, var9_9, var28_60);
                        var29_67 = 0;
                        while (var29_67 < var28_60) {
                            this.encodings[var9_9 + var29_67] = var19_19;
                            this.destinationPaths[var9_9 + var29_67] = var20_20;
                            ++var29_67;
                        }
                        var9_9 += var28_60;
                        var19_19 = null;
                        var20_20 = null;
                        var21_21 = null;
                    } else {
                        this.filenames = var27_53;
                        var9_9 = this.filenames.length;
                        this.encodings = new String[var9_9];
                        this.destinationPaths = new String[var9_9];
                        var28_60 = 0;
                        while (var28_60 < var9_9) {
                            this.encodings[var28_60] = var19_19;
                            this.destinationPaths[var28_60] = var20_20;
                            ++var28_60;
                        }
                        var19_19 = null;
                        var20_20 = null;
                        var21_21 = null;
                    }
                    var12_12 = 0;
                }
            }
        }
        if (this.enableJavadocOn) {
            this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        } else if (this.warnJavadocOn || this.warnAllJavadocOn) {
            this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", "disabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference", "disabled");
        }
        if (this.warnJavadocOn) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
        }
        if (var13_13 || var9_9 == 0 && var10_10 == 0) {
            if (var14_14 == null) {
                this.printUsage();
            } else {
                this.printUsage(var14_14);
            }
            this.proceed = false;
            return;
        }
        if (this.log != null) {
            this.logger.setLog(this.log);
        } else {
            this.showProgress = false;
        }
        this.logger.logVersion(var15_15);
        this.validateOptions(var17_17);
        if (!var18_18 && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) >= 0x320000L) {
            this.options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        }
        this.logger.logCommandLineArguments(var25_26);
        this.logger.logOptions(this.options);
        if (this.maxRepetition == 0) {
            this.maxRepetition = 1;
        }
        if (this.maxRepetition >= 3 && (this.timing & 1) != 0) {
            this.compilerStats = new CompilerStats[this.maxRepetition];
        }
        if (var9_9 != 0) {
            this.filenames = new String[var9_9];
            System.arraycopy(this.filenames, 0, this.filenames, 0, var9_9);
        }
        if (var10_10 != 0) {
            this.classNames = new String[var10_10];
            System.arraycopy(this.classNames, 0, this.classNames, 0, var10_10);
        }
        this.setPaths(var2_2, var3_3, var4_4, var5_5, var6_6, var7_7, var19_19);
        if (var23_23 != null && var23_23.size() > 1) {
            this.logger.logWarning(this.bind("configure.multipleencodings", (String)this.options.get("org.eclipse.jdt.core.encoding"), Main.getAllEncodings(var23_23)));
        }
        if (this.pendingErrors != null) {
            for (String var27_54 : this.pendingErrors) {
                this.logger.logPendingError(var27_54);
            }
            this.pendingErrors = null;
        }
    }

    private static char[][] decodeIgnoreOptionalProblemsFromFolders(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        char[][] cArrayArray = new char[stringTokenizer.countTokens()][];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            File file = new File(string2);
            if (file.exists()) {
                try {
                    cArrayArray[n++] = file.getCanonicalPath().toCharArray();
                }
                catch (IOException iOException) {
                    cArrayArray[n++] = string2.toCharArray();
                }
                continue;
            }
            cArrayArray[n++] = string2.toCharArray();
        }
        return cArrayArray;
    }

    private static String getAllEncodings(Set set) {
        int n = set.size();
        Object[] objectArray = new String[n];
        set.toArray(objectArray);
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((String)objectArray[n2]);
            ++n2;
        }
        return String.valueOf(stringBuffer);
    }

    private void initializeWarnings(String string) {
        File file = new File(string);
        if (!file.exists()) {
            throw new IllegalArgumentException(this.bind("configure.missingwarningspropertiesfile", string));
        }
        BufferedInputStream bufferedInputStream = null;
        Properties properties = null;
        try {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                properties = new Properties();
                properties.load(bufferedInputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new IllegalArgumentException(this.bind("configure.ioexceptionwarningspropertiesfile", string));
            }
        }
        catch (Throwable throwable) {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {}
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string2 = (String)entry.getKey();
            if (!string2.startsWith("org.eclipse.jdt.core.compiler.")) continue;
            this.options.put(string2, entry.getValue());
        }
        if (!properties.containsKey("org.eclipse.jdt.core.compiler.debug.localVariable")) {
            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        }
        if (!properties.containsKey("org.eclipse.jdt.core.compiler.codegen.unusedLocal")) {
            this.options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        }
        if (!properties.containsKey("org.eclipse.jdt.core.compiler.doc.comment.support")) {
            this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        }
        if (!properties.containsKey("org.eclipse.jdt.core.compiler.problem.forbiddenReference")) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", "error");
        }
    }

    protected void enableAll(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "error";
                break;
            }
            case 0: {
                string = "warning";
            }
        }
        Object[] objectArray = this.options.entrySet().toArray();
        int n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3) {
            Map.Entry entry = (Map.Entry)objectArray[n2];
            if (entry.getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getValue()).equals("ignore")) {
                this.options.put(entry.getKey(), string);
            }
            ++n2;
        }
        this.options.put("org.eclipse.jdt.core.compiler.taskTags", Util.EMPTY_STRING);
    }

    protected void disableAll(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "error";
                break;
            }
            case 0: {
                string = "warning";
            }
        }
        Object[] objectArray = this.options.entrySet().toArray();
        int n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3) {
            Map.Entry entry = (Map.Entry)objectArray[n2];
            if (entry.getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getValue()).equals(string)) {
                this.options.put(entry.getKey(), "ignore");
            }
            ++n2;
        }
    }

    public String extractDestinationPathFromSourceFile(CompilationResult compilationResult) {
        String string;
        File file;
        char[] cArray;
        int n;
        ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
        if (iCompilationUnit != null && (n = CharOperation.lastIndexOf(File.separatorChar, cArray = iCompilationUnit.getFileName())) != -1 && (file = new File(string = new String(cArray, 0, n))).exists() && file.isDirectory()) {
            return string;
        }
        return System.getProperty("user.dir");
    }

    public ICompilerRequestor getBatchRequestor() {
        return new ICompilerRequestor(){
            int lineDelta = 0;

            public void acceptResult(CompilationResult compilationResult) {
                if (compilationResult.lineSeparatorPositions != null) {
                    int n = compilationResult.lineSeparatorPositions.length;
                    this.lineDelta += n;
                    if (Main.this.showProgress && this.lineDelta > 2000) {
                        Main.this.logger.logProgress();
                        this.lineDelta = 0;
                    }
                }
                Main.this.logger.startLoggingSource(compilationResult);
                if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
                    Main.this.logger.logProblems(compilationResult.getAllProblems(), compilationResult.compilationUnit.getContents(), Main.this);
                }
                Main.this.outputClassFiles(compilationResult);
                Main.this.logger.endLoggingSource();
            }
        };
    }

    public CompilationUnit[] getCompilationUnits() {
        int n = this.filenames.length;
        CompilationUnit[] compilationUnitArray = new CompilationUnit[n];
        HashtableOfObject hashtableOfObject = new HashtableOfObject(n);
        String string = (String)this.options.get("org.eclipse.jdt.core.encoding");
        if (Util.EMPTY_STRING.equals(string)) {
            string = null;
        }
        int n2 = 0;
        while (n2 < n) {
            String string2;
            char[] cArray = this.filenames[n2].toCharArray();
            if (hashtableOfObject.get(cArray) != null) {
                throw new IllegalArgumentException(this.bind("unit.more", this.filenames[n2]));
            }
            hashtableOfObject.put(cArray, cArray);
            File file = new File(this.filenames[n2]);
            if (!file.exists()) {
                throw new IllegalArgumentException(this.bind("unit.missing", this.filenames[n2]));
            }
            String string3 = this.encodings[n2];
            if (string3 == null) {
                string3 = string;
            }
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = this.filenames[n2];
            }
            compilationUnitArray[n2] = new CompilationUnit(null, string2, string3, this.destinationPaths[n2], Main.shouldIgnoreOptionalProblems(this.ignoreOptionalProblemsFromFolders, string2.toCharArray()));
            ++n2;
        }
        return compilationUnitArray;
    }

    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return Main.this.proceedOnError;
            }

            public boolean stopOnFirstError() {
                return false;
            }

            public boolean ignoreAllErrors() {
                return false;
            }
        };
    }

    public File getJavaHome() {
        if (!this.javaHomeChecked) {
            this.javaHomeChecked = true;
            this.javaHomeCache = Util.getJavaHome();
        }
        return this.javaHomeCache;
    }

    public FileSystem getLibraryAccess() {
        return new FileSystem(this.checkedClasspaths, this.filenames);
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(this.compilerLocale);
    }

    protected ArrayList handleBootclasspath(ArrayList arrayList, String string) {
        int n;
        if (arrayList != null && (n = arrayList.size()) != 0) {
            String[] stringArray = new String[n];
            arrayList.toArray(stringArray);
            arrayList.clear();
            int n2 = 0;
            while (n2 < n) {
                this.processPathEntries(4, arrayList, stringArray[n2], string, false, true);
                ++n2;
            }
        } else {
            arrayList = new ArrayList(4);
            try {
                Util.collectRunningVMBootclasspath(arrayList);
            }
            catch (IllegalStateException illegalStateException) {
                this.logger.logWrongJDK();
                this.proceed = false;
                return null;
            }
        }
        return arrayList;
    }

    protected ArrayList handleClasspath(ArrayList arrayList, String string) {
        FileSystem.Classpath classpath;
        Object object;
        Object object2;
        int n;
        if (arrayList != null && (n = arrayList.size()) != 0) {
            object2 = new String[n];
            arrayList.toArray((T[])object2);
            arrayList.clear();
            int n2 = 0;
            while (n2 < n) {
                this.processPathEntries(4, arrayList, (String)object2[n2], string, false, true);
                ++n2;
            }
        } else {
            arrayList = new ArrayList<FileSystem.Classpath>(4);
            object2 = System.getProperty("java.class.path");
            if (object2 == null || ((String)object2).length() == 0) {
                this.addPendingErrors(this.bind("configure.noClasspath"));
                FileSystem.Classpath classpath2 = FileSystem.getClasspath(System.getProperty("user.dir"), string, null);
                if (classpath2 != null) {
                    arrayList.add(classpath2);
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    classpath = FileSystem.getClasspath((String)object, string, null);
                    if (classpath != null) {
                        arrayList.add(classpath);
                        continue;
                    }
                    if (((String)object).length() == 0) continue;
                    this.addPendingErrors(this.bind("configure.incorrectClasspath", (String)object));
                }
            }
        }
        object2 = new ArrayList();
        HashMap<String, FileSystem.Classpath> hashMap = new HashMap<String, FileSystem.Classpath>();
        object = new FileSystem.ClasspathSectionProblemReporter(){

            public void invalidClasspathSection(String string) {
                Main.this.addPendingErrors(Main.this.bind("configure.invalidClasspathSection", string));
            }

            public void multipleClasspathSections(String string) {
                Main.this.addPendingErrors(Main.this.bind("configure.multipleClasspathSections", string));
            }
        };
        while (!arrayList.isEmpty()) {
            classpath = (FileSystem.Classpath)arrayList.remove(0);
            String string2 = classpath.getPath();
            if (hashMap.get(string2) != null) continue;
            hashMap.put(string2, classpath);
            ((ArrayList)object2).add(classpath);
            List list = classpath.fetchLinkedJars((FileSystem.ClasspathSectionProblemReporter)object);
            if (list == null) continue;
            arrayList.addAll(0, list);
        }
        return object2;
    }

    protected ArrayList handleEndorseddirs(ArrayList arrayList) {
        Object object;
        File file = this.getJavaHome();
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(4);
            object = System.getProperty("java.endorsed.dirs");
            if (object == null) {
                if (file != null) {
                    arrayList.add(String.valueOf(file.getAbsolutePath()) + "/lib/endorsed");
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
        }
        if (arrayList.size() != 0) {
            object = new File[arrayList.size()];
            int n = 0;
            while (n < ((File[])object).length) {
                object[n] = new File((String)arrayList.get(n));
                ++n;
            }
            arrayList.clear();
            File[][] fileArray = Main.getLibrariesFiles(object);
            if (fileArray != null) {
                int n2 = 0;
                int n3 = fileArray.length;
                while (n2 < n3) {
                    File[] fileArray2 = fileArray[n2];
                    if (fileArray2 != null) {
                        int n4 = 0;
                        int n5 = fileArray2.length;
                        while (n4 < n5) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray2[n4].getAbsolutePath(), null, null);
                            if (classpath != null) {
                                arrayList.add(classpath);
                            }
                            ++n4;
                        }
                    } else if (object[n2].isFile()) {
                        this.addPendingErrors(this.bind("configure.incorrectEndorsedDirsEntry", object[n2].getAbsolutePath()));
                    }
                    ++n2;
                }
            }
        }
        return arrayList;
    }

    protected ArrayList handleExtdirs(ArrayList arrayList) {
        Object object;
        File file = this.getJavaHome();
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(4);
            object = System.getProperty("java.ext.dirs");
            if (object == null) {
                arrayList.add(String.valueOf(file.getAbsolutePath()) + "/lib/ext");
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
        }
        if (arrayList.size() != 0) {
            object = new File[arrayList.size()];
            int n = 0;
            while (n < ((File[])object).length) {
                object[n] = new File((String)arrayList.get(n));
                ++n;
            }
            arrayList.clear();
            File[][] fileArray = Main.getLibrariesFiles(object);
            if (fileArray != null) {
                int n2 = 0;
                int n3 = fileArray.length;
                while (n2 < n3) {
                    File[] fileArray2 = fileArray[n2];
                    if (fileArray2 != null) {
                        int n4 = 0;
                        int n5 = fileArray2.length;
                        while (n4 < n5) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray2[n4].getAbsolutePath(), null, null);
                            if (classpath != null) {
                                arrayList.add(classpath);
                            }
                            ++n4;
                        }
                    } else if (object[n2].isFile()) {
                        this.addPendingErrors(this.bind("configure.incorrectExtDirsEntry", object[n2].getAbsolutePath()));
                    }
                    ++n2;
                }
            }
        }
        return arrayList;
    }

    protected void handleWarningToken(String string, boolean bl) {
        this.handleErrorOrWarningToken(string, bl, 0);
    }

    protected void handleErrorToken(String string, boolean bl) {
        this.handleErrorOrWarningToken(string, bl, 1);
    }

    private void setSeverity(String string, int n, boolean bl) {
        if (bl) {
            switch (n) {
                case 1: {
                    this.options.put(string, "error");
                    break;
                }
                case 0: {
                    this.options.put(string, "warning");
                    break;
                }
                default: {
                    this.options.put(string, "ignore");
                    break;
                }
            }
        } else {
            switch (n) {
                case 1: {
                    String string2 = (String)this.options.get(string);
                    if (!"error".equals(string2)) break;
                    this.options.put(string, "ignore");
                    break;
                }
                case 0: {
                    String string3 = (String)this.options.get(string);
                    if (!"warning".equals(string3)) break;
                    this.options.put(string, "ignore");
                    break;
                }
                default: {
                    this.options.put(string, "ignore");
                }
            }
        }
    }

    private void handleErrorOrWarningToken(String string, boolean bl, int n) {
        if (string.length() == 0) {
            return;
        }
        switch (string.charAt(0)) {
            case 'a': {
                if (string.equals("allDeprecation")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.deprecation", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", bl ? "enabled" : "disabled");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("allJavadoc")) {
                    this.warnAllJavadocOn = this.warnJavadocOn = bl;
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", n, bl);
                    return;
                }
                if (string.equals("assertIdentifier")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.assertIdentifier", n, bl);
                    return;
                }
                if (string.equals("allDeadCode")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.deadCode", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deadCodeInTrivialIfStatement", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("allOver-ann")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("all-static-method")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", n, bl);
                    return;
                }
                if (!string.equals("all")) break;
                if (bl) {
                    this.enableAll(n);
                } else {
                    this.disableAll(n);
                }
                return;
            }
            case 'b': {
                if (!string.equals("boxing")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.autoboxing", n, bl);
                return;
            }
            case 'c': {
                if (string.equals("constructorName")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", n, bl);
                    return;
                }
                if (string.equals("conditionAssign")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", n, bl);
                    return;
                }
                if (string.equals("compareIdentical")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.comparingIdentical", n, bl);
                    return;
                }
                if (!string.equals("charConcat")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", n, bl);
                return;
            }
            case 'd': {
                if (string.equals("deprecation")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.deprecation", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "disabled");
                    return;
                }
                if (string.equals("dep-ann")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation", n, bl);
                    return;
                }
                if (string.equals("discouraged")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.discouragedReference", n, bl);
                    return;
                }
                if (!string.equals("deadCode")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.deadCode", n, bl);
                this.options.put("org.eclipse.jdt.core.compiler.problem.deadCodeInTrivialIfStatement", "disabled");
                return;
            }
            case 'e': {
                if (string.equals("enumSwitch")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", n, bl);
                    return;
                }
                if (string.equals("enumSwitchPedantic")) {
                    if (bl) {
                        switch (n) {
                            case 1: {
                                this.setSeverity("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", n, bl);
                                break;
                            }
                            case 0: {
                                if (!"ignore".equals(this.options.get("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch"))) break;
                                this.setSeverity("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", n, bl);
                            }
                        }
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingEnumCaseDespiteDefault", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("emptyBlock")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", n, bl);
                    return;
                }
                if (!string.equals("enumIdentifier")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.enumIdentifier", n, bl);
                return;
            }
            case 'f': {
                if (string.equals("fieldHiding")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.fieldHiding", n, bl);
                    return;
                }
                if (string.equals("finalBound")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.finalParameterBound", n, bl);
                    return;
                }
                if (string.equals("finally")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", n, bl);
                    return;
                }
                if (string.equals("forbidden")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.forbiddenReference", n, bl);
                    return;
                }
                if (!string.equals("fallthrough")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.fallthroughCase", n, bl);
                return;
            }
            case 'h': {
                if (string.equals("hiding")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.localVariableHiding", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.fieldHiding", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", n, bl);
                    return;
                }
                if (!string.equals("hashCode")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingHashCodeMethod", n, bl);
                return;
            }
            case 'i': {
                if (string.equals("indirectStatic")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", n, bl);
                    return;
                }
                if (string.equals("inheritNullAnnot")) {
                    this.options.put("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("intfNonInherited") || string.equals("interfaceNonInherited")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", n, bl);
                    return;
                }
                if (string.equals("intfAnnotation")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.annotationSuperInterface", n, bl);
                    return;
                }
                if (string.equals("intfRedundant")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", n, bl);
                    return;
                }
                if (string.equals("includeAssertNull")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.includeNullInfoFromAsserts", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("invalidJavadoc")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", bl ? "enabled" : "disabled");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", bl ? "enabled" : "disabled");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", bl ? "enabled" : "disabled");
                    if (bl) {
                        this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
                    }
                    return;
                }
                if (string.equals("invalidJavadocTag")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("invalidJavadocTagDep")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("invalidJavadocTagNotVisible")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", bl ? "enabled" : "disabled");
                    return;
                }
                if (!string.startsWith("invalidJavadocTagVisibility")) break;
                int n2 = string.indexOf(40);
                int n3 = string.indexOf(41);
                String string2 = null;
                if (bl && n2 >= 0 && n3 >= 0 && n2 < n3) {
                    string2 = string.substring(n2 + 1, n3).trim();
                }
                if (string2 != null && string2.equals("public") || string2.equals("private") || string2.equals("protected") || string2.equals("default")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", string2);
                    return;
                }
                throw new IllegalArgumentException(this.bind("configure.invalidJavadocTagVisibility", string));
            }
            case 'j': {
                if (!string.equals("javadoc")) break;
                this.warnJavadocOn = bl;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", n, bl);
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", n, bl);
                return;
            }
            case 'l': {
                if (!string.equals("localHiding")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.localVariableHiding", n, bl);
                return;
            }
            case 'm': {
                if (string.equals("maskedCatchBlock") || string.equals("maskedCatchBlocks")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", n, bl);
                    return;
                }
                if (string.equals("missingJavadocTags")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding", bl ? "enabled" : "disabled");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters", bl ? "enabled" : "disabled");
                    if (bl) {
                        this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
                    }
                    return;
                }
                if (string.equals("missingJavadocTagsOverriding")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("missingJavadocTagsMethod")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.startsWith("missingJavadocTagsVisibility")) {
                    int n4 = string.indexOf(40);
                    int n5 = string.indexOf(41);
                    String string3 = null;
                    if (bl && n4 >= 0 && n5 >= 0 && n4 < n5) {
                        string3 = string.substring(n4 + 1, n5).trim();
                    }
                    if (string3 != null && string3.equals("public") || string3.equals("private") || string3.equals("protected") || string3.equals("default")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", string3);
                        return;
                    }
                    throw new IllegalArgumentException(this.bind("configure.missingJavadocTagsVisibility", string));
                }
                if (string.equals("missingJavadocComments")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding", bl ? "enabled" : "disabled");
                    if (bl) {
                        this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility", "private");
                    }
                    return;
                }
                if (string.equals("missingJavadocCommentsOverriding")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding", bl ? "enabled" : "disabled");
                    return;
                }
                if (!string.startsWith("missingJavadocCommentsVisibility")) break;
                int n6 = string.indexOf(40);
                int n7 = string.indexOf(41);
                String string4 = null;
                if (bl && n6 >= 0 && n7 >= 0 && n6 < n7) {
                    string4 = string.substring(n6 + 1, n7).trim();
                }
                if (string4 != null && string4.equals("public") || string4.equals("private") || string4.equals("protected") || string4.equals("default")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility", string4);
                    return;
                }
                throw new IllegalArgumentException(this.bind("configure.missingJavadocCommentsVisibility", string));
            }
            case 'n': {
                if (string.equals("nls")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", n, bl);
                    return;
                }
                if (string.equals("noEffectAssign")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", n, bl);
                    return;
                }
                if (string.equals("noImplicitStringConversion")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", n, bl);
                    return;
                }
                if (string.equals("null")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullReference", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.potentialNullReference", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", n, bl);
                    return;
                }
                if (string.equals("nullDereference")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullReference", n, bl);
                    if (!bl) {
                        this.setSeverity("org.eclipse.jdt.core.compiler.problem.potentialNullReference", 256, bl);
                        this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", 256, bl);
                    }
                    return;
                }
                if (string.equals("nullAnnotConflict")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullAnnotationInferenceConflict", n, bl);
                    return;
                }
                if (string.equals("nullAnnotRedundant")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation", n, bl);
                    return;
                }
                if (string.startsWith("nullAnnot")) {
                    String string5 = Util.EMPTY_STRING;
                    int n8 = string.indexOf(40);
                    int n9 = string.indexOf(41);
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    if (bl && n8 >= 0 && n9 >= 0 && n8 < n9) {
                        string5 = string.substring(n8 + 1, n9).trim();
                        int n10 = string5.indexOf(124);
                        if (n10 == -1) {
                            throw new IllegalArgumentException(this.bind("configure.invalidNullAnnot", string));
                        }
                        string7 = string5.substring(0, n10).trim();
                        if (string7.length() == 0) {
                            throw new IllegalArgumentException(this.bind("configure.invalidNullAnnot", string));
                        }
                        int n11 = string5.indexOf(124, n10 + 1);
                        if (n11 == -1) {
                            throw new IllegalArgumentException(this.bind("configure.invalidNullAnnot", string));
                        }
                        string6 = string5.substring(n10 + 1, n11).trim();
                        if (string6.length() == 0) {
                            throw new IllegalArgumentException(this.bind("configure.invalidNullAnnot", string));
                        }
                        string8 = string5.substring(n11 + 1).trim();
                        if (string8.length() == 0) {
                            throw new IllegalArgumentException(this.bind("configure.invalidNullAnnot", string));
                        }
                        this.options.put("org.eclipse.jdt.core.compiler.annotation.nullable", string7);
                        this.options.put("org.eclipse.jdt.core.compiler.annotation.nonnull", string6);
                        this.options.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", string8);
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", bl ? "enabled" : "disabled");
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullAnnotationInferenceConflict", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation", n, bl);
                    return;
                }
                if (string.equals("nullUncheckedConversion")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", n, bl);
                    return;
                }
                if (!string.equals("nonnullNotRepeated")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.nonnullParameterAnnotationDropped", n, bl);
                return;
            }
            case 'o': {
                if (string.equals("over-sync")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod", n, bl);
                    return;
                }
                if (!string.equals("over-ann")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", n, bl);
                this.options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "disabled");
                return;
            }
            case 'p': {
                if (string.equals("pkgDefaultMethod") || string.equals("packageDefaultMethod")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", n, bl);
                    return;
                }
                if (!string.equals("paramAssign")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.parameterAssignment", n, bl);
                return;
            }
            case 'r': {
                if (string.equals("raw")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.rawTypeReference", n, bl);
                    return;
                }
                if (string.equals("redundantSuperinterface")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", n, bl);
                    return;
                }
                if (!string.equals("resource")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", n, bl);
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", n, bl);
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", n, bl);
                return;
            }
            case 's': {
                if (string.equals("specialParamHiding")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("syntheticAccess") || string.equals("synthetic-access")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", n, bl);
                    return;
                }
                if (string.equals("staticReceiver")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", n, bl);
                    return;
                }
                if (string.equals("syncOverride")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod", n, bl);
                    return;
                }
                if (string.equals("semicolon")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.emptyStatement", n, bl);
                    return;
                }
                if (string.equals("serial")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", n, bl);
                    return;
                }
                if (string.equals("suppress")) {
                    switch (n) {
                        case 0: {
                            this.options.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", bl ? "enabled" : "disabled");
                            this.options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "disabled");
                            break;
                        }
                        case 1: {
                            this.options.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", bl ? "enabled" : "disabled");
                            this.options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", bl ? "enabled" : "disabled");
                        }
                    }
                    return;
                }
                if (string.equals("static-access")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", n, bl);
                    return;
                }
                if (string.equals("super")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", n, bl);
                    return;
                }
                if (string.equals("static-method")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", n, bl);
                    return;
                }
                if (!string.equals("switchDefault")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", n, bl);
                return;
            }
            case 't': {
                if (string.startsWith("tasks")) {
                    String string9 = Util.EMPTY_STRING;
                    int n12 = string.indexOf(40);
                    int n13 = string.indexOf(41);
                    if (n12 >= 0 && n13 >= 0 && n12 < n13) {
                        string9 = string.substring(n12 + 1, n13).trim();
                        string9 = string9.replace('|', ',');
                    }
                    if (string9.length() == 0) {
                        throw new IllegalArgumentException(this.bind("configure.invalidTaskTag", string));
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.taskTags", bl ? string9 : Util.EMPTY_STRING);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.tasks", n, bl);
                    return;
                }
                if (!string.equals("typeHiding")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", n, bl);
                return;
            }
            case 'u': {
                if (string.equals("unusedLocal") || string.equals("unusedLocals")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedLocal", n, bl);
                    return;
                }
                if (string.equals("unusedArgument") || string.equals("unusedArguments")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedParameter", n, bl);
                    return;
                }
                if (string.equals("unusedImport") || string.equals("unusedImports")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedImport", n, bl);
                    return;
                }
                if (string.equals("unusedAllocation")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", n, bl);
                    return;
                }
                if (string.equals("unusedPrivate")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", n, bl);
                    return;
                }
                if (string.equals("unusedLabel")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedLabel", n, bl);
                    return;
                }
                if (string.equals("uselessTypeCheck")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", n, bl);
                    return;
                }
                if (string.equals("unchecked") || string.equals("unsafe")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", n, bl);
                    return;
                }
                if (string.equals("unnecessaryElse")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unnecessaryElse", n, bl);
                    return;
                }
                if (string.equals("unusedThrown")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", n, bl);
                    return;
                }
                if (string.equals("unusedThrownWhenOverriding")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("unusedThrownIncludeDocComment")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("unusedThrownExemptExceptionThrowable")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("unqualifiedField") || string.equals("unqualified-field-access")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", n, bl);
                    return;
                }
                if (string.equals("unused")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedLocal", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedParameter", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedImport", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedLabel", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedTypeParameter", n, bl);
                    return;
                }
                if (string.equals("unusedParam")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedParameter", n, bl);
                    return;
                }
                if (string.equals("unusedTypeParameter")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedTypeParameter", n, bl);
                    return;
                }
                if (string.equals("unusedParamIncludeDoc")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("unusedParamOverriding")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("unusedParamImplementing")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("unusedTypeArgs")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", n, bl);
                    return;
                }
                if (!string.equals("unavoidableGenericProblems")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", bl ? "enabled" : "disabled");
                return;
            }
            case 'v': {
                if (!string.equals("varargsCast")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast", n, bl);
                return;
            }
            case 'w': {
                if (!string.equals("warningToken")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken", n, bl);
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", n, bl);
                return;
            }
        }
        String string10 = null;
        switch (n) {
            case 0: {
                string10 = this.bind("configure.invalidWarning", string);
                break;
            }
            case 1: {
                string10 = this.bind("configure.invalidError", string);
            }
        }
        this.addPendingErrors(string10);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        this.initialize(printWriter, printWriter2, bl, null, null);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map) {
        this.initialize(printWriter, printWriter2, bl, map, null);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map, CompilationProgress compilationProgress) {
        this.logger = new Logger(this, printWriter, printWriter2);
        this.proceed = true;
        this.out = printWriter;
        this.err = printWriter2;
        this.systemExitWhenFinished = bl;
        this.options = new CompilerOptions().getMap();
        this.ignoreOptionalProblemsFromFolders = null;
        this.progress = compilationProgress;
        if (map != null) {
            this.didSpecifySource = map.get("org.eclipse.jdt.core.compiler.source") != null;
            this.didSpecifyTarget = map.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform") != null;
            for (Map.Entry entry : map.entrySet()) {
                this.options.put(entry.getKey(), entry.getValue());
            }
        } else {
            this.didSpecifySource = false;
            this.didSpecifyTarget = false;
        }
        this.classNames = null;
    }

    protected void initializeAnnotationProcessorManager() {
        try {
            Class<?> clazz = Class.forName("org.eclipse.jdt.internal.compiler.apt.dispatch.BatchAnnotationProcessorManager");
            AbstractAnnotationProcessorManager abstractAnnotationProcessorManager = (AbstractAnnotationProcessorManager)clazz.newInstance();
            abstractAnnotationProcessorManager.configure(this, this.expandedCommandLine);
            abstractAnnotationProcessorManager.setErr(this.err);
            abstractAnnotationProcessorManager.setOut(this.out);
            this.batchCompiler.annotationProcessorManager = abstractAnnotationProcessorManager;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
            throw new AbortCompilation();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AbortCompilation();
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            this.logger.logIncorrectVMVersionForAnnotationProcessing();
        }
    }

    private static boolean isParentOf(char[] cArray, char[] cArray2) {
        if (cArray.length >= cArray2.length) {
            return false;
        }
        if (cArray2[cArray.length] != '\\' && cArray2[cArray.length] != '/') {
            return false;
        }
        int n = cArray.length - 1;
        while (n >= 0) {
            if (cArray[n] != cArray2[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public void outputClassFiles(CompilationResult compilationResult) {
        if (compilationResult != null && (!compilationResult.hasErrors() || this.proceedOnError)) {
            ClassFile[] classFileArray = compilationResult.getClassFiles();
            String string = null;
            boolean bl = false;
            CompilationUnit compilationUnit = (CompilationUnit)compilationResult.compilationUnit;
            if (compilationUnit.destinationPath == null) {
                if (this.destinationPath == null) {
                    string = this.extractDestinationPathFromSourceFile(compilationResult);
                } else if (this.destinationPath != NONE) {
                    string = this.destinationPath;
                    bl = true;
                }
            } else if (compilationUnit.destinationPath != NONE) {
                string = compilationUnit.destinationPath;
                bl = true;
            }
            if (string != null) {
                int n = 0;
                int n2 = classFileArray.length;
                while (n < n2) {
                    ClassFile classFile = classFileArray[n];
                    char[] cArray = classFile.fileName();
                    int n3 = cArray.length;
                    char[] cArray2 = new char[n3 + 6];
                    System.arraycopy(cArray, 0, cArray2, 0, n3);
                    System.arraycopy(SuffixConstants.SUFFIX_class, 0, cArray2, n3, 6);
                    CharOperation.replace(cArray2, '/', File.separatorChar);
                    String string2 = new String(cArray2);
                    try {
                        if (this.compilerOptions.verbose) {
                            this.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), string2}));
                        }
                        Util.writeToDisk(bl, string, string2, classFile);
                        this.logger.logClassFile(bl, string, string2);
                        ++this.exportedClassFilesCounter;
                    }
                    catch (IOException iOException) {
                        this.logger.logNoClassFileCreated(string, string2, iOException);
                    }
                    ++n;
                }
                this.batchCompiler.lookupEnvironment.releaseClassFiles(classFileArray);
            }
        }
    }

    public void performCompilation() {
        this.startTime = System.currentTimeMillis();
        FileSystem fileSystem = this.getLibraryAccess();
        this.compilerOptions = new CompilerOptions(this.options);
        this.compilerOptions.performMethodsFullRecovery = false;
        this.compilerOptions.performStatementsRecovery = false;
        this.batchCompiler = new Compiler(fileSystem, this.getHandlingPolicy(), this.compilerOptions, this.getBatchRequestor(), this.getProblemFactory(), this.out, this.progress);
        this.batchCompiler.remainingIterations = this.maxRepetition - this.currentRepetition;
        String string = System.getProperty("jdt.compiler.useSingleThread");
        boolean bl = this.batchCompiler.useSingleThread = string != null && string.equals("true");
        if (this.compilerOptions.complianceLevel >= 0x320000L && this.compilerOptions.processAnnotations) {
            if (this.checkVMVersion(0x320000L)) {
                this.initializeAnnotationProcessorManager();
                if (this.classNames != null) {
                    this.batchCompiler.setBinaryTypes(this.processClassNames(this.batchCompiler.lookupEnvironment));
                }
            } else {
                this.logger.logIncorrectVMVersionForAnnotationProcessing();
            }
        }
        this.compilerOptions.verbose = this.verbose;
        this.compilerOptions.produceReferenceInfo = this.produceRefInfo;
        try {
            this.logger.startLoggingSources();
            this.batchCompiler.compile(this.getCompilationUnits());
        }
        finally {
            this.logger.endLoggingSources();
        }
        if (this.extraProblems != null) {
            this.loggingExtraProblems();
            this.extraProblems = null;
        }
        if (this.compilerStats != null) {
            this.compilerStats[this.currentRepetition] = this.batchCompiler.stats;
        }
        this.logger.printStats();
        fileSystem.cleanup();
    }

    protected void loggingExtraProblems() {
        this.logger.loggingExtraProblems(this);
    }

    public void printUsage() {
        this.printUsage("misc.usage");
    }

    private void printUsage(String string) {
        this.logger.logUsage(this.bind(string, new String[]{System.getProperty("path.separator"), this.bind("compiler.name"), this.bind("compiler.version"), this.bind("compiler.copyright")}));
        this.logger.flush();
    }

    private ReferenceBinding[] processClassNames(LookupEnvironment lookupEnvironment) {
        int n = this.classNames.length;
        ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n];
        int n2 = 0;
        while (n2 < n) {
            Object object;
            String string = this.classNames[n2];
            Object object2 = null;
            if (string.indexOf(46) != -1) {
                object = string.toCharArray();
                object2 = CharOperation.splitOn('.', (char[])object);
            } else {
                object2 = new char[][]{string.toCharArray()};
            }
            object = lookupEnvironment.getType((char[][])object2);
            if (object != null && ((Binding)object).isValidBinding()) {
                if (((ReferenceBinding)object).isBinaryBinding()) {
                    referenceBindingArray[n2] = object;
                }
            } else {
                throw new IllegalArgumentException(this.bind("configure.invalidClassName", string));
            }
            ++n2;
        }
        return referenceBindingArray;
    }

    public void processPathEntries(int n, ArrayList arrayList, String string, String string2, boolean bl, boolean bl2) {
        String string3 = null;
        String string4 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(File.pathSeparator) + "[]", true);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList3.add(stringTokenizer.nextToken());
        }
        int n2 = 0;
        String string5 = null;
        int n3 = 0;
        int n4 = arrayList3.size();
        int n5 = -1;
        while (n3 < n4 && n2 != 99) {
            if ((string5 = (String)arrayList3.get(n3++)).equals(File.pathSeparator)) {
                switch (n2) {
                    case 0: 
                    case 3: 
                    case 10: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 8: {
                        n2 = 3;
                        this.addNewEntry(arrayList, string3, arrayList2, string2, string4, bl, bl2);
                        arrayList2.clear();
                        break;
                    }
                    case 6: {
                        n2 = 4;
                        break;
                    }
                    case 7: {
                        throw new IllegalArgumentException(this.bind("configure.incorrectDestinationPathEntry", string));
                    }
                    case 11: {
                        n3 = n5 + 1;
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else if (string5.equals("[")) {
                switch (n2) {
                    case 0: {
                        string3 = "";
                    }
                    case 1: {
                        n5 = n3 - 1;
                    }
                    case 11: {
                        n2 = 10;
                        break;
                    }
                    case 2: {
                        n2 = 9;
                        break;
                    }
                    case 8: {
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else if (string5.equals("]")) {
                switch (n2) {
                    case 6: {
                        n2 = 2;
                        break;
                    }
                    case 7: {
                        n2 = 8;
                        break;
                    }
                    case 10: {
                        n2 = 11;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else {
                switch (n2) {
                    case 0: 
                    case 3: {
                        n2 = 1;
                        string3 = string5;
                        break;
                    }
                    case 5: {
                        if (string5.startsWith("-d ")) {
                            if (string4 != null) {
                                throw new IllegalArgumentException(this.bind("configure.duplicateDestinationPathEntry", string));
                            }
                            string4 = string5.substring(3).trim();
                            n2 = 7;
                            break;
                        }
                    }
                    case 4: {
                        if (string4 != null) {
                            throw new IllegalArgumentException(this.bind("configure.accessRuleAfterDestinationPath", string));
                        }
                        n2 = 6;
                        arrayList2.add(string5);
                        break;
                    }
                    case 9: {
                        if (!string5.startsWith("-d ")) {
                            n2 = 99;
                            break;
                        }
                        string4 = string5.substring(3).trim();
                        n2 = 7;
                        break;
                    }
                    case 11: {
                        int n6 = n5;
                        while (n6 < n3) {
                            string3 = String.valueOf(string3) + (String)arrayList3.get(n6);
                            ++n6;
                        }
                        n2 = 1;
                        break;
                    }
                    case 10: {
                        break;
                    }
                    default: {
                        n2 = 99;
                    }
                }
            }
            if (n2 != 11 || n3 != n4) continue;
            n3 = n5 + 1;
            n2 = 5;
        }
        switch (n2) {
            case 3: {
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                this.addNewEntry(arrayList, string3, arrayList2, string2, string4, bl, bl2);
                break;
            }
            default: {
                if (string.length() == 0) break;
                this.addPendingErrors(this.bind("configure.incorrectClasspath", string));
            }
        }
    }

    private int processPaths(String[] stringArray, int n, String string, ArrayList arrayList) {
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        while (n4 < n5) {
            switch (string.charAt(n4)) {
                case '[': {
                    ++n3;
                    break;
                }
                case ']': {
                    --n3;
                }
            }
            ++n4;
        }
        if (n3 != 0) {
            if (n3 > 1) {
                throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            while (true) {
                if (n2 >= stringArray.length) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                }
                String string2 = stringArray[++n2];
                int n6 = 0;
                int n7 = string2.length();
                while (n6 < n7) {
                    switch (string2.charAt(n6)) {
                        case '[': {
                            if (n3 > 1) {
                                throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string2));
                            }
                            ++n3;
                            break;
                        }
                        case ']': {
                            --n3;
                        }
                    }
                    ++n6;
                }
                if (n3 == 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                    arrayList.add(stringBuffer.toString());
                    return n2 - n;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string2));
                }
                stringBuffer.append(' ');
                stringBuffer.append(string2);
            }
        }
        arrayList.add(string);
        return n2 - n;
    }

    private int processPaths(String[] stringArray, int n, String string, String[] stringArray2) {
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        while (n4 < n5) {
            switch (string.charAt(n4)) {
                case '[': {
                    ++n3;
                    break;
                }
                case ']': {
                    --n3;
                }
            }
            ++n4;
        }
        if (n3 != 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (true) {
                if (++n2 >= stringArray.length) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                }
                String string2 = stringArray[n2];
                int n6 = 0;
                int n7 = string2.length();
                while (n6 < n7) {
                    switch (string2.charAt(n6)) {
                        case '[': {
                            if (n3 > 1) {
                                throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                            }
                            ++n3;
                            break;
                        }
                        case ']': {
                            --n3;
                        }
                    }
                    ++n6;
                }
                if (n3 == 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                    stringArray2[0] = stringBuffer.toString();
                    return n2 - n;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                }
                stringBuffer.append(' ');
                stringBuffer.append(string2);
            }
        }
        stringArray2[0] = string;
        return n2 - n;
    }

    public void relocalize() {
        this.relocalize(Locale.getDefault());
    }

    private void relocalize(Locale locale) {
        this.compilerLocale = locale;
        try {
            this.bundle = ResourceBundleFactory.getBundle(locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + locale);
            throw missingResourceException;
        }
    }

    public void setDestinationPath(String string) {
        this.destinationPath = string;
    }

    public void setLocale(Locale locale) {
        this.relocalize(locale);
    }

    protected void setPaths(ArrayList arrayList, String string, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, ArrayList arrayList5, String string2) {
        arrayList = this.handleBootclasspath(arrayList, string2);
        arrayList3 = this.handleClasspath(arrayList3, string2);
        if (string != null) {
            this.processPathEntries(4, arrayList2, string, string2, true, false);
        }
        arrayList4 = this.handleExtdirs(arrayList4);
        arrayList5 = this.handleEndorseddirs(arrayList5);
        arrayList.addAll(0, arrayList5);
        arrayList.addAll(arrayList4);
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        arrayList3 = arrayList;
        arrayList3 = FileSystem.ClasspathNormalizer.normalize(arrayList3);
        this.checkedClasspaths = new FileSystem.Classpath[arrayList3.size()];
        arrayList3.toArray(this.checkedClasspaths);
        this.logger.logClasspath(this.checkedClasspaths);
    }

    private static boolean shouldIgnoreOptionalProblems(char[][] cArray, char[] cArray2) {
        if (cArray == null || cArray2 == null) {
            return false;
        }
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            char[] cArray3 = cArray[n];
            if (Main.isParentOf(cArray3, cArray2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void validateOptions(boolean bl) {
        Object v;
        Object v2;
        if (bl) {
            v2 = this.options.get("org.eclipse.jdt.core.compiler.compliance");
            if ("1.3".equals(v2)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                }
            } else if ("1.4".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                        }
                    } else if ("1.4".equals(v) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                    }
                }
            } else if ("1.5".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(v) || "1.4".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if ("1.5".equals(v) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    }
                }
            } else if ("1.6".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(v) || "1.4".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if (("1.5".equals(v) || "1.6".equals(v)) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    }
                }
            } else if ("1.7".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(v) || "1.4".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if ("1.5".equals(v) || "1.6".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                        }
                    } else if ("1.7".equals(v) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.7");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                    }
                }
            } else if ("1.8".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(v) || "1.4".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if ("1.5".equals(v) || "1.6".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                        }
                    } else if ("1.7".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                        }
                    } else if ("1.8".equals(v) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.8");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
                    }
                }
            }
        } else if (this.didSpecifySource) {
            v2 = this.options.get("org.eclipse.jdt.core.compiler.source");
            if ("1.4".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                }
            } else if ("1.5".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            } else if ("1.6".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                }
            } else if ("1.7".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                }
            } else if ("1.8".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.8");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
                }
            }
        }
        v2 = this.options.get("org.eclipse.jdt.core.compiler.source");
        v = this.options.get("org.eclipse.jdt.core.compiler.compliance");
        if (v2.equals("1.8") && CompilerOptions.versionToJdkLevel(v) < 0x340000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.8"));
        }
        if (v2.equals("1.7") && CompilerOptions.versionToJdkLevel(v) < 0x330000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.7"));
        }
        if (v2.equals("1.6") && CompilerOptions.versionToJdkLevel(v) < 0x320000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.6"));
        }
        if (v2.equals("1.5") && CompilerOptions.versionToJdkLevel(v) < 0x310000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.5"));
        }
        if (v2.equals("1.4") && CompilerOptions.versionToJdkLevel(v) < 0x300000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.4"));
        }
        if (this.didSpecifyTarget) {
            Object v3 = this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            if ("jsr14".equals(v3)) {
                if (CompilerOptions.versionToJdkLevel(v2) < 0x310000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForGenericSource", (String)v3, (String)v2));
                }
            } else if ("cldc1.1".equals(v3)) {
                if (this.didSpecifySource && CompilerOptions.versionToJdkLevel(v2) >= 0x300000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleSourceForCldcTarget", (String)v3, (String)v2));
                }
                if (CompilerOptions.versionToJdkLevel(v) >= 0x310000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForCldcTarget", (String)v3, (String)v2));
                }
            } else {
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x340000L && CompilerOptions.versionToJdkLevel(v3) < 0x340000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.8"));
                }
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x330000L && CompilerOptions.versionToJdkLevel(v3) < 0x330000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.7"));
                }
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x320000L && CompilerOptions.versionToJdkLevel(v3) < 0x320000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.6"));
                }
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x310000L && CompilerOptions.versionToJdkLevel(v3) < 0x310000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.5"));
                }
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x300000L && CompilerOptions.versionToJdkLevel(v3) < 0x300000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.4"));
                }
                if (CompilerOptions.versionToJdkLevel(v) < CompilerOptions.versionToJdkLevel(v3)) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForTarget", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), (String)v3));
                }
            }
        }
    }

    public static class Logger {
        private PrintWriter err;
        private PrintWriter log;
        private Main main;
        private PrintWriter out;
        private HashMap parameters;
        int tagBits;
        private static final String CLASS = "class";
        private static final String CLASS_FILE = "classfile";
        private static final String CLASSPATH = "classpath";
        private static final String CLASSPATH_FILE = "FILE";
        private static final String CLASSPATH_FOLDER = "FOLDER";
        private static final String CLASSPATH_ID = "id";
        private static final String CLASSPATH_JAR = "JAR";
        private static final String CLASSPATHS = "classpaths";
        private static final String COMMAND_LINE_ARGUMENT = "argument";
        private static final String COMMAND_LINE_ARGUMENTS = "command_line";
        private static final String COMPILER = "compiler";
        private static final String COMPILER_COPYRIGHT = "copyright";
        private static final String COMPILER_NAME = "name";
        private static final String COMPILER_VERSION = "version";
        public static final int EMACS = 2;
        private static final String ERROR = "ERROR";
        private static final String ERROR_TAG = "error";
        private static final String WARNING_TAG = "warning";
        private static final String EXCEPTION = "exception";
        private static final String EXTRA_PROBLEM_TAG = "extra_problem";
        private static final String EXTRA_PROBLEMS = "extra_problems";
        private static final HashtableOfInt FIELD_TABLE = new HashtableOfInt();
        private static final String KEY = "key";
        private static final String MESSAGE = "message";
        private static final String NUMBER_OF_CLASSFILES = "number_of_classfiles";
        private static final String NUMBER_OF_ERRORS = "errors";
        private static final String NUMBER_OF_LINES = "number_of_lines";
        private static final String NUMBER_OF_PROBLEMS = "problems";
        private static final String NUMBER_OF_TASKS = "tasks";
        private static final String NUMBER_OF_WARNINGS = "warnings";
        private static final String OPTION = "option";
        private static final String OPTIONS = "options";
        private static final String OUTPUT = "output";
        private static final String PACKAGE = "package";
        private static final String PATH = "path";
        private static final String PROBLEM_ARGUMENT = "argument";
        private static final String PROBLEM_ARGUMENT_VALUE = "value";
        private static final String PROBLEM_ARGUMENTS = "arguments";
        private static final String PROBLEM_CATEGORY_ID = "categoryID";
        private static final String ID = "id";
        private static final String PROBLEM_ID = "problemID";
        private static final String PROBLEM_LINE = "line";
        private static final String PROBLEM_OPTION_KEY = "optionKey";
        private static final String PROBLEM_MESSAGE = "message";
        private static final String PROBLEM_SEVERITY = "severity";
        private static final String PROBLEM_SOURCE_END = "charEnd";
        private static final String PROBLEM_SOURCE_START = "charStart";
        private static final String PROBLEM_SUMMARY = "problem_summary";
        private static final String PROBLEM_TAG = "problem";
        private static final String PROBLEMS = "problems";
        private static final String SOURCE = "source";
        private static final String SOURCE_CONTEXT = "source_context";
        private static final String SOURCE_END = "sourceEnd";
        private static final String SOURCE_START = "sourceStart";
        private static final String SOURCES = "sources";
        private static final String STATS = "stats";
        private static final String TASK = "task";
        private static final String TASKS = "tasks";
        private static final String TIME = "time";
        private static final String VALUE = "value";
        private static final String WARNING = "WARNING";
        public static final int XML = 1;
        private static final String XML_DTD_DECLARATION = "<!DOCTYPE compiler PUBLIC \"-//Eclipse.org//DTD Eclipse JDT 3.2.004 Compiler//EN\" \"http://www.eclipse.org/jdt/core/compiler_32_004.dtd\">";

        static {
            try {
                Class<IProblem> clazz = IProblem.class;
                Field[] fieldArray = clazz.getFields();
                int n = 0;
                int n2 = fieldArray.length;
                while (n < n2) {
                    Field field = fieldArray[n];
                    if (field.getType().equals(Integer.TYPE)) {
                        Integer n3 = (Integer)field.get(null);
                        int n4 = n3 & 0xFFFFFF;
                        if (n4 == 0) {
                            n4 = Integer.MAX_VALUE;
                        }
                        FIELD_TABLE.put(n4, field.getName());
                    }
                    ++n;
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }

        public Logger(Main main, PrintWriter printWriter, PrintWriter printWriter2) {
            this.out = printWriter;
            this.err = printWriter2;
            this.parameters = new HashMap();
            this.main = main;
        }

        public String buildFileName(String string, String string2) {
            char c = File.separatorChar;
            String string3 = File.separator;
            string = string.replace('/', c);
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!string.endsWith(string3)) {
                stringBuffer.append(string3);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            String string4 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(string4).append(string3);
                string4 = stringTokenizer.nextToken();
            }
            return stringBuffer.append(string4).toString();
        }

        public void close() {
            if (this.log != null) {
                if ((this.tagBits & 1) != 0) {
                    this.endTag(COMPILER);
                    this.flush();
                }
                this.log.close();
            }
        }

        public void compiling() {
            this.printlnOut(this.main.bind("progress.compiling"));
        }

        private void endLoggingExtraProblems() {
            this.endTag(EXTRA_PROBLEMS);
        }

        private void endLoggingProblems() {
            this.endTag("problems");
        }

        public void endLoggingSource() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCE);
            }
        }

        public void endLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCES);
            }
        }

        public void endLoggingTasks() {
            if ((this.tagBits & 1) != 0) {
                this.endTag("tasks");
            }
        }

        private void endTag(String string) {
            if (this.log != null) {
                ((GenericXMLWriter)this.log).endTag(string, true, true);
            }
        }

        private String errorReportSource(CategorizedProblem categorizedProblem, char[] cArray, int n) {
            char c;
            int n2;
            int n3 = categorizedProblem.getSourceStart();
            int n4 = categorizedProblem.getSourceEnd();
            if (cArray == null && categorizedProblem.getOriginatingFileName() != null) {
                try {
                    cArray = Util.getFileCharContent(new File(new String(categorizedProblem.getOriginatingFileName())), null);
                }
                catch (IOException iOException) {}
            }
            if (n3 > n4 || n3 < 0 && n4 < 0 || cArray == null || (n2 = cArray.length) == 0) {
                return Messages.problem_noSourceInformation;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if ((n & 2) == 0) {
                stringBuffer.append(' ').append(Messages.bind(Messages.problem_atLine, String.valueOf(categorizedProblem.getSourceLineNumber())));
                stringBuffer.append(Util.LINE_SEPARATOR);
            }
            stringBuffer.append('\t');
            int n5 = n3 >= n2 ? n2 - 1 : n3;
            while (n5 > 0) {
                c = cArray[n5 - 1];
                if (c == '\n' || c == '\r') break;
                --n5;
            }
            int n6 = n4 >= n2 ? n2 - 1 : n4;
            while (n6 + 1 < n2) {
                c = cArray[n6 + 1];
                if (c == '\r' || c == '\n') break;
                ++n6;
            }
            while ((c = cArray[n5]) == ' ' || c == '\t') {
                ++n5;
            }
            stringBuffer.append(cArray, n5, n6 - n5 + 1);
            stringBuffer.append(Util.LINE_SEPARATOR).append("\t");
            int n7 = n5;
            while (n7 < n3) {
                stringBuffer.append(cArray[n7] == '\t' ? (char)'\t' : ' ');
                ++n7;
            }
            n7 = n3;
            while (n7 <= (n4 >= n2 ? n2 - 1 : n4)) {
                stringBuffer.append('^');
                ++n7;
            }
            return stringBuffer.toString();
        }

        private void extractContext(CategorizedProblem categorizedProblem, char[] cArray) {
            char c;
            int n;
            int n2 = categorizedProblem.getSourceStart();
            int n3 = categorizedProblem.getSourceEnd();
            if (cArray == null && categorizedProblem.getOriginatingFileName() != null) {
                try {
                    cArray = Util.getFileCharContent(new File(new String(categorizedProblem.getOriginatingFileName())), null);
                }
                catch (IOException iOException) {}
            }
            if (n2 > n3 || n2 < 0 && n3 < 0 || cArray == null || (n = cArray.length) <= 0 || n3 > n) {
                this.parameters.put("value", Messages.problem_noSourceInformation);
                this.parameters.put(SOURCE_START, "-1");
                this.parameters.put(SOURCE_END, "-1");
                this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
                return;
            }
            int n4 = n2 >= n ? n - 1 : n2;
            while (n4 > 0) {
                c = cArray[n4 - 1];
                if (c == '\n' || c == '\r') break;
                --n4;
            }
            int n5 = n3 >= n ? n - 1 : n3;
            while (n5 + 1 < n) {
                c = cArray[n5 + 1];
                if (c == '\r' || c == '\n') break;
                ++n5;
            }
            while ((c = cArray[n4]) == ' ' || c == '\t') {
                ++n4;
            }
            while ((c = cArray[n5]) == ' ' || c == '\t') {
                --n5;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray, n4, n5 - n4 + 1);
            this.parameters.put("value", String.valueOf(stringBuffer));
            this.parameters.put(SOURCE_START, Integer.toString(n2 - n4));
            this.parameters.put(SOURCE_END, Integer.toString(n3 - n4));
            this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
        }

        public void flush() {
            this.out.flush();
            this.err.flush();
            if (this.log != null) {
                this.log.flush();
            }
        }

        private String getFieldName(int n) {
            int n2 = n & 0xFFFFFF;
            if (n2 == 0) {
                n2 = Integer.MAX_VALUE;
            }
            return (String)FIELD_TABLE.get(n2);
        }

        private String getProblemOptionKey(int n) {
            int n2 = ProblemReporter.getIrritant(n);
            return CompilerOptions.optionKeyFromIrritant(n2);
        }

        public void logAverage() {
            Arrays.sort(this.main.compilerStats);
            long l = this.main.compilerStats[0].lineCount;
            int n = this.main.maxRepetition;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            int n2 = 1;
            int n3 = n - 1;
            while (n2 < n3) {
                CompilerStats compilerStats = this.main.compilerStats[n2];
                l2 += compilerStats.elapsedTime();
                l3 += compilerStats.parseTime;
                l4 += compilerStats.resolveTime;
                l5 += compilerStats.analyzeTime;
                l6 += compilerStats.generateTime;
                ++n2;
            }
            long l7 = l2 / (long)(n - 2);
            long l8 = l3 / (long)(n - 2);
            long l9 = l4 / (long)(n - 2);
            long l10 = l5 / (long)(n - 2);
            long l11 = l6 / (long)(n - 2);
            this.printlnOut(this.main.bind("compile.averageTime", new String[]{String.valueOf(l), String.valueOf(l7), String.valueOf((double)((int)((double)l * 10000.0 / (double)l7)) / 10.0)}));
            if ((this.main.timing & 2) != 0) {
                this.printlnOut(this.main.bind("compile.detailedTime", new String[]{String.valueOf(l8), String.valueOf((double)((int)((double)l8 * 1000.0 / (double)l7)) / 10.0), String.valueOf(l9), String.valueOf((double)((int)((double)l9 * 1000.0 / (double)l7)) / 10.0), String.valueOf(l10), String.valueOf((double)((int)((double)l10 * 1000.0 / (double)l7)) / 10.0), String.valueOf(l11), String.valueOf((double)((int)((double)l11 * 1000.0 / (double)l7)) / 10.0)}));
            }
        }

        public void logClassFile(boolean bl, String string, String string2) {
            if ((this.tagBits & 1) != 0) {
                String string3 = null;
                if (bl) {
                    string3 = this.buildFileName(string, string2);
                } else {
                    char c = File.separatorChar;
                    String string4 = File.separator;
                    string = string.replace('/', c);
                    int n = string2.lastIndexOf(c);
                    if (n == -1) {
                        string3 = string.endsWith(string4) ? String.valueOf(string) + string2 : String.valueOf(string) + string4 + string2;
                    } else {
                        int n2 = string2.length();
                        string3 = string.endsWith(string4) ? String.valueOf(string) + string2.substring(n + 1, n2) : String.valueOf(string) + string4 + string2.substring(n + 1, n2);
                    }
                }
                File file = new File(string3);
                try {
                    this.parameters.put(PATH, file.getCanonicalPath());
                    this.printTag(CLASS_FILE, this.parameters, true, true);
                }
                catch (IOException iOException) {
                    this.logNoClassFileCreated(string, string2, iOException);
                }
            }
        }

        public void logClasspath(FileSystem.Classpath[] classpathArray) {
            int n;
            if (classpathArray == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (n = classpathArray.length) != 0) {
                this.printTag(CLASSPATHS, null, true, false);
                int n2 = 0;
                while (n2 < n) {
                    String string = classpathArray[n2].getPath();
                    this.parameters.put(PATH, string);
                    File file = new File(string);
                    String string2 = null;
                    if (file.isFile()) {
                        string2 = Util.isPotentialZipArchive(string) ? CLASSPATH_JAR : CLASSPATH_FILE;
                    } else if (file.isDirectory()) {
                        string2 = CLASSPATH_FOLDER;
                    }
                    if (string2 != null) {
                        this.parameters.put("id", string2);
                        this.printTag(CLASSPATH, this.parameters, true, true);
                    }
                    ++n2;
                }
                this.endTag(CLASSPATHS);
            }
        }

        public void logCommandLineArguments(String[] stringArray) {
            int n;
            if (stringArray == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (n = stringArray.length) != 0) {
                this.printTag(COMMAND_LINE_ARGUMENTS, null, true, false);
                int n2 = 0;
                while (n2 < n) {
                    this.parameters.put("value", stringArray[n2]);
                    this.printTag("argument", this.parameters, true, true);
                    ++n2;
                }
                this.endTag(COMMAND_LINE_ARGUMENTS);
            }
        }

        public void logException(Exception exception) {
            Object object;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            String string = stringWriter.toString();
            if ((this.tagBits & 1) != 0) {
                object = new LineNumberReader(new StringReader(string));
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = exception.getMessage();
                if (string2 != null) {
                    stringBuffer.append(string2).append(Util.LINE_SEPARATOR);
                }
                try {
                    String string3;
                    while ((string3 = ((LineNumberReader)object).readLine()) != null && n < 4) {
                        stringBuffer.append(string3).append(Util.LINE_SEPARATOR);
                        ++n;
                    }
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {}
                string2 = stringBuffer.toString();
                this.parameters.put("message", string2);
                this.parameters.put(CLASS, exception.getClass());
                this.printTag(EXCEPTION, this.parameters, true, true);
            }
            if ((object = exception.getMessage()) == null) {
                this.printlnErr(string);
            } else {
                this.printlnErr((String)object);
            }
        }

        private void logExtraProblem(CategorizedProblem categorizedProblem, int n, int n2) {
            char[] cArray = categorizedProblem.getOriginatingFileName();
            if (cArray == null) {
                if (categorizedProblem.isError()) {
                    this.printErr(this.main.bind("requestor.extraerror", Integer.toString(n2)));
                } else {
                    this.printErr(this.main.bind("requestor.extrawarning", Integer.toString(n2)));
                }
                this.printErr(" ");
                this.printlnErr(categorizedProblem.getMessage());
            } else {
                String string = new String(cArray);
                if ((this.tagBits & 2) != 0) {
                    String string2 = String.valueOf(string) + ":" + categorizedProblem.getSourceLineNumber() + ": " + (categorizedProblem.isError() ? this.main.bind("output.emacs.error") : this.main.bind("output.emacs.warning")) + ": " + categorizedProblem.getMessage();
                    this.printlnErr(string2);
                    String string3 = this.errorReportSource(categorizedProblem, null, this.tagBits);
                    this.printlnErr(string3);
                } else {
                    if (n == 0) {
                        this.printlnErr("----------");
                    }
                    this.printErr(categorizedProblem.isError() ? this.main.bind("requestor.error", Integer.toString(n2), new String(string)) : this.main.bind("requestor.warning", Integer.toString(n2), new String(string)));
                    String string4 = this.errorReportSource(categorizedProblem, null, 0);
                    this.printlnErr(string4);
                    this.printlnErr(categorizedProblem.getMessage());
                    this.printlnErr("----------");
                }
            }
        }

        public void loggingExtraProblems(Main main) {
            ArrayList arrayList = main.extraProblems;
            int n = arrayList.size();
            int n2 = 0;
            if (n != 0) {
                CategorizedProblem categorizedProblem;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                while (n5 < n) {
                    categorizedProblem = (CategorizedProblem)arrayList.get(n5);
                    if (categorizedProblem != null) {
                        ++main.globalProblemsCount;
                        this.logExtraProblem(categorizedProblem, n2, main.globalProblemsCount);
                        ++n2;
                        if (categorizedProblem.isError()) {
                            ++n3;
                            ++main.globalErrorsCount;
                        } else if (categorizedProblem.isWarning()) {
                            ++main.globalWarningsCount;
                            ++n4;
                        }
                    }
                    ++n5;
                }
                if ((this.tagBits & 1) != 0 && n3 + n4 != 0) {
                    this.startLoggingExtraProblems(n);
                    n5 = 0;
                    while (n5 < n) {
                        categorizedProblem = (CategorizedProblem)arrayList.get(n5);
                        if (categorizedProblem != null && categorizedProblem.getID() != 536871362) {
                            this.logXmlExtraProblem(categorizedProblem, n2, main.globalProblemsCount);
                        }
                        ++n5;
                    }
                    this.endLoggingExtraProblems();
                }
            }
        }

        public void logIncorrectVMVersionForAnnotationProcessing() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.incorrectVMVersionforAPT"));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.incorrectVMVersionforAPT"));
        }

        public void logNoClassFileCreated(String string, String string2, IOException iOException) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("output.noClassFileCreated", new String[]{string, string2, iOException.getMessage()}));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("output.noClassFileCreated", new String[]{string, string2, iOException.getMessage()}));
        }

        public void logNumberOfClassFilesGenerated(int n) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("value", new Integer(n));
                this.printTag(NUMBER_OF_CLASSFILES, this.parameters, true, true);
            }
            if (n == 1) {
                this.printlnOut(this.main.bind("compile.oneClassFileGenerated"));
            } else {
                this.printlnOut(this.main.bind("compile.severalClassFilesGenerated", String.valueOf(n)));
            }
        }

        public void logOptions(Map map) {
            if ((this.tagBits & 1) != 0) {
                this.printTag(OPTIONS, null, true, false);
                Set set = map.entrySet();
                Object[] objectArray = set.toArray();
                Arrays.sort(objectArray, new Comparator(){

                    public int compare(Object object, Object object2) {
                        Map.Entry entry = (Map.Entry)object;
                        Map.Entry entry2 = (Map.Entry)object2;
                        return ((String)entry.getKey()).compareTo((String)entry2.getKey());
                    }
                });
                int n = 0;
                int n2 = objectArray.length;
                while (n < n2) {
                    Map.Entry entry = (Map.Entry)objectArray[n];
                    String string = (String)entry.getKey();
                    this.parameters.put(KEY, string);
                    this.parameters.put("value", entry.getValue());
                    this.printTag(OPTION, this.parameters, true, true);
                    ++n;
                }
                this.endTag(OPTIONS);
            }
        }

        public void logPendingError(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", string);
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(string);
        }

        public void logWarning(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", string);
                this.printTag(WARNING_TAG, this.parameters, true, true);
            }
            this.printlnOut(string);
        }

        private void logProblem(CategorizedProblem categorizedProblem, int n, int n2, char[] cArray) {
            if ((this.tagBits & 2) != 0) {
                String string = String.valueOf(new String(categorizedProblem.getOriginatingFileName())) + ":" + categorizedProblem.getSourceLineNumber() + ": " + (categorizedProblem.isError() ? this.main.bind("output.emacs.error") : this.main.bind("output.emacs.warning")) + ": " + categorizedProblem.getMessage();
                this.printlnErr(string);
                String string2 = this.errorReportSource(categorizedProblem, cArray, this.tagBits);
                if (string2.length() != 0) {
                    this.printlnErr(string2);
                }
            } else {
                if (n == 0) {
                    this.printlnErr("----------");
                }
                this.printErr(categorizedProblem.isError() ? this.main.bind("requestor.error", Integer.toString(n2), new String(categorizedProblem.getOriginatingFileName())) : this.main.bind("requestor.warning", Integer.toString(n2), new String(categorizedProblem.getOriginatingFileName())));
                try {
                    String string = this.errorReportSource(categorizedProblem, cArray, 0);
                    this.printlnErr(string);
                    this.printlnErr(categorizedProblem.getMessage());
                }
                catch (Exception exception) {
                    this.printlnErr(this.main.bind("requestor.notRetrieveErrorMessage", categorizedProblem.toString()));
                }
                this.printlnErr("----------");
            }
        }

        public int logProblems(CategorizedProblem[] categorizedProblemArray, char[] cArray, Main main) {
            int n = categorizedProblemArray.length;
            int n2 = 0;
            int n3 = 0;
            if (n != 0) {
                CategorizedProblem categorizedProblem;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                while (n7 < n) {
                    categorizedProblem = categorizedProblemArray[n7];
                    if (categorizedProblem != null) {
                        ++main.globalProblemsCount;
                        this.logProblem(categorizedProblem, n3, main.globalProblemsCount, cArray);
                        ++n3;
                        if (categorizedProblem.isError()) {
                            ++n2;
                            ++n4;
                            ++main.globalErrorsCount;
                        } else if (categorizedProblem.getID() == 536871362) {
                            ++main.globalTasksCount;
                            ++n6;
                        } else {
                            ++main.globalWarningsCount;
                            ++n5;
                        }
                    }
                    ++n7;
                }
                if ((this.tagBits & 1) != 0) {
                    if (n4 + n5 != 0) {
                        this.startLoggingProblems(n4, n5);
                        n7 = 0;
                        while (n7 < n) {
                            categorizedProblem = categorizedProblemArray[n7];
                            if (categorizedProblem != null && categorizedProblem.getID() != 536871362) {
                                this.logXmlProblem(categorizedProblem, cArray);
                            }
                            ++n7;
                        }
                        this.endLoggingProblems();
                    }
                    if (n6 != 0) {
                        this.startLoggingTasks(n6);
                        n7 = 0;
                        while (n7 < n) {
                            categorizedProblem = categorizedProblemArray[n7];
                            if (categorizedProblem != null && categorizedProblem.getID() == 536871362) {
                                this.logXmlTask(categorizedProblem, cArray);
                            }
                            ++n7;
                        }
                        this.endLoggingTasks();
                    }
                }
            }
            return n2;
        }

        public void logProblemsSummary(int n, int n2, int n3, int n4) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("problems", new Integer(n));
                this.parameters.put(NUMBER_OF_ERRORS, new Integer(n2));
                this.parameters.put(NUMBER_OF_WARNINGS, new Integer(n3));
                this.parameters.put("tasks", new Integer(n4));
                this.printTag(PROBLEM_SUMMARY, this.parameters, true, true);
            }
            if (n == 1) {
                String string = null;
                string = n2 == 1 ? this.main.bind("compile.oneError") : this.main.bind("compile.oneWarning");
                this.printErr(this.main.bind("compile.oneProblem", string));
            } else {
                int n5;
                String string = null;
                String string2 = null;
                if (n2 > 0) {
                    string = n2 == 1 ? this.main.bind("compile.oneError") : this.main.bind("compile.severalErrors", String.valueOf(n2));
                }
                if ((n5 = n3 + n4) > 0) {
                    string2 = n5 == 1 ? this.main.bind("compile.oneWarning") : this.main.bind("compile.severalWarnings", String.valueOf(n5));
                }
                if (string == null || string2 == null) {
                    if (string == null) {
                        this.printErr(this.main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n), string2));
                    } else {
                        this.printErr(this.main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n), string));
                    }
                } else {
                    this.printErr(this.main.bind("compile.severalProblemsErrorsAndWarnings", new String[]{String.valueOf(n), string, string2}));
                }
            }
            if ((this.tagBits & 1) == 0) {
                this.printlnErr();
            }
        }

        public void logProgress() {
            this.printOut('.');
        }

        public void logRepetition(int n, int n2) {
            this.printlnOut(this.main.bind("compile.repetition", String.valueOf(n + 1), String.valueOf(n2)));
        }

        public void logTiming(CompilerStats compilerStats) {
            long l = compilerStats.elapsedTime();
            long l2 = compilerStats.lineCount;
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("value", new Long(l));
                this.printTag(TIME, this.parameters, true, true);
                this.parameters.put("value", new Long(l2));
                this.printTag(NUMBER_OF_LINES, this.parameters, true, true);
            }
            if (l2 != 0L) {
                this.printlnOut(this.main.bind("compile.instantTime", new String[]{String.valueOf(l2), String.valueOf(l), String.valueOf((double)((int)((double)l2 * 10000.0 / (double)l)) / 10.0)}));
            } else {
                this.printlnOut(this.main.bind("compile.totalTime", new String[]{String.valueOf(l)}));
            }
            if ((this.main.timing & 2) != 0) {
                this.printlnOut(this.main.bind("compile.detailedTime", new String[]{String.valueOf(compilerStats.parseTime), String.valueOf((double)((int)((double)compilerStats.parseTime * 1000.0 / (double)l)) / 10.0), String.valueOf(compilerStats.resolveTime), String.valueOf((double)((int)((double)compilerStats.resolveTime * 1000.0 / (double)l)) / 10.0), String.valueOf(compilerStats.analyzeTime), String.valueOf((double)((int)((double)compilerStats.analyzeTime * 1000.0 / (double)l)) / 10.0), String.valueOf(compilerStats.generateTime), String.valueOf((double)((int)((double)compilerStats.generateTime * 1000.0 / (double)l)) / 10.0)}));
            }
        }

        public void logUsage(String string) {
            this.printlnOut(string);
        }

        public void logVersion(boolean bl) {
            if (this.log != null && (this.tagBits & 1) == 0) {
                String string = this.main.bind("misc.version", new String[]{this.main.bind("compiler.name"), this.main.bind("compiler.version"), this.main.bind("compiler.copyright")});
                this.log.println("# " + string);
                if (bl) {
                    this.out.println(string);
                    this.out.flush();
                }
            } else if (bl) {
                String string = this.main.bind("misc.version", new String[]{this.main.bind("compiler.name"), this.main.bind("compiler.version"), this.main.bind("compiler.copyright")});
                this.out.println(string);
                this.out.flush();
            }
        }

        public void logWrongJDK() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.requiresJDK1.2orAbove"));
                this.printTag(ERROR, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.requiresJDK1.2orAbove"));
        }

        private void logXmlExtraProblem(CategorizedProblem categorizedProblem, int n, int n2) {
            int n3 = categorizedProblem.getSourceStart();
            int n4 = categorizedProblem.getSourceEnd();
            boolean bl = categorizedProblem.isError();
            this.parameters.put(PROBLEM_SEVERITY, bl ? ERROR : WARNING);
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(n3));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(n4));
            this.printTag(EXTRA_PROBLEM_TAG, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, null);
            this.endTag(EXTRA_PROBLEM_TAG);
        }

        private void logXmlProblem(CategorizedProblem categorizedProblem, char[] cArray) {
            int n = categorizedProblem.getSourceStart();
            int n2 = categorizedProblem.getSourceEnd();
            int n3 = categorizedProblem.getID();
            this.parameters.put("id", this.getFieldName(n3));
            this.parameters.put(PROBLEM_ID, new Integer(n3));
            boolean bl = categorizedProblem.isError();
            int n4 = bl ? 1 : 0;
            this.parameters.put(PROBLEM_SEVERITY, bl ? ERROR : WARNING);
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(n));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(n2));
            String string = this.getProblemOptionKey(n3);
            if (string != null) {
                this.parameters.put(PROBLEM_OPTION_KEY, string);
            }
            int n5 = ProblemReporter.getProblemCategory(n4, n3);
            this.parameters.put(PROBLEM_CATEGORY_ID, new Integer(n5));
            this.printTag(PROBLEM_TAG, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, cArray);
            String[] stringArray = categorizedProblem.getArguments();
            int n6 = stringArray.length;
            if (n6 != 0) {
                this.printTag(PROBLEM_ARGUMENTS, null, true, false);
                int n7 = 0;
                while (n7 < n6) {
                    this.parameters.put("value", stringArray[n7]);
                    this.printTag("argument", this.parameters, true, true);
                    ++n7;
                }
                this.endTag(PROBLEM_ARGUMENTS);
            }
            this.endTag(PROBLEM_TAG);
        }

        private void logXmlTask(CategorizedProblem categorizedProblem, char[] cArray) {
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(categorizedProblem.getSourceStart()));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(categorizedProblem.getSourceEnd()));
            String string = this.getProblemOptionKey(categorizedProblem.getID());
            if (string != null) {
                this.parameters.put(PROBLEM_OPTION_KEY, string);
            }
            this.printTag(TASK, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, cArray);
            this.endTag(TASK);
        }

        private void printErr(String string) {
            this.err.print(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.print(string);
            }
        }

        private void printlnErr() {
            this.err.println();
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println();
            }
        }

        private void printlnErr(String string) {
            this.err.println(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(string);
            }
        }

        private void printlnOut(String string) {
            this.out.println(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(string);
            }
        }

        public void printNewLine() {
            this.out.println();
        }

        private void printOut(char c) {
            this.out.print(c);
        }

        public void printStats() {
            boolean bl;
            boolean bl2 = bl = (this.main.timing & 1) != 0;
            if ((this.tagBits & 1) != 0) {
                this.printTag(STATS, null, true, false);
            }
            if (bl) {
                CompilerStats compilerStats = this.main.batchCompiler.stats;
                compilerStats.startTime = this.main.startTime;
                compilerStats.endTime = System.currentTimeMillis();
                this.logTiming(compilerStats);
            }
            if (this.main.globalProblemsCount > 0) {
                this.logProblemsSummary(this.main.globalProblemsCount, this.main.globalErrorsCount, this.main.globalWarningsCount, this.main.globalTasksCount);
            }
            if (this.main.exportedClassFilesCounter != 0 && (this.main.showProgress || bl || this.main.verbose)) {
                this.logNumberOfClassFilesGenerated(this.main.exportedClassFilesCounter);
            }
            if ((this.tagBits & 1) != 0) {
                this.endTag(STATS);
            }
        }

        private void printTag(String string, HashMap hashMap, boolean bl, boolean bl2) {
            if (this.log != null) {
                ((GenericXMLWriter)this.log).printTag(string, this.parameters, true, bl, bl2);
            }
            this.parameters.clear();
        }

        public void setEmacs() {
            this.tagBits |= 2;
        }

        public void setLog(String string) {
            Date date = new Date();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1, Locale.getDefault());
            try {
                int n = string.lastIndexOf(46);
                if (n != -1) {
                    if (string.substring(n).toLowerCase().equals(".xml")) {
                        this.log = new GenericXMLWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, false), "UTF-8"), Util.LINE_SEPARATOR, true);
                        this.tagBits |= 1;
                        this.log.println("<!-- " + dateFormat.format(date) + " -->");
                        this.log.println(XML_DTD_DECLARATION);
                        this.parameters.put(COMPILER_NAME, this.main.bind("compiler.name"));
                        this.parameters.put(COMPILER_VERSION, this.main.bind("compiler.version"));
                        this.parameters.put(COMPILER_COPYRIGHT, this.main.bind("compiler.copyright"));
                        this.printTag(COMPILER, this.parameters, true, false);
                    } else {
                        this.log = new PrintWriter(new FileOutputStream(string, false));
                        this.log.println("# " + dateFormat.format(date));
                    }
                } else {
                    this.log = new PrintWriter(new FileOutputStream(string, false));
                    this.log.println("# " + dateFormat.format(date));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException(this.main.bind("configure.cannotOpenLog", string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException(this.main.bind("configure.cannotOpenLogInvalidEncoding", string));
            }
        }

        private void startLoggingExtraProblems(int n) {
            this.parameters.put("problems", new Integer(n));
            this.printTag(EXTRA_PROBLEMS, this.parameters, true, false);
        }

        private void startLoggingProblems(int n, int n2) {
            this.parameters.put("problems", new Integer(n + n2));
            this.parameters.put(NUMBER_OF_ERRORS, new Integer(n));
            this.parameters.put(NUMBER_OF_WARNINGS, new Integer(n2));
            this.printTag("problems", this.parameters, true, false);
        }

        public void startLoggingSource(CompilationResult compilationResult) {
            if ((this.tagBits & 1) != 0) {
                ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
                if (iCompilationUnit != null) {
                    char[][] cArray;
                    char[] cArray2 = iCompilationUnit.getFileName();
                    File file = new File(new String(cArray2));
                    if (cArray2 != null) {
                        this.parameters.put(PATH, file.getAbsolutePath());
                    }
                    if ((cArray = compilationResult.packageName) != null) {
                        this.parameters.put(PACKAGE, new String(CharOperation.concatWith(cArray, File.separatorChar)));
                    }
                    CompilationUnit compilationUnit = (CompilationUnit)iCompilationUnit;
                    String string = compilationUnit.destinationPath;
                    if (string == null) {
                        string = this.main.destinationPath;
                    }
                    if (string != null && string != Main.NONE) {
                        if (File.separatorChar == '/') {
                            this.parameters.put(OUTPUT, string);
                        } else {
                            this.parameters.put(OUTPUT, string.replace('/', File.separatorChar));
                        }
                    }
                }
                this.printTag(SOURCE, this.parameters, true, false);
            }
        }

        public void startLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.printTag(SOURCES, null, true, false);
            }
        }

        public void startLoggingTasks(int n) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("tasks", new Integer(n));
                this.printTag("tasks", this.parameters, true, false);
            }
        }
    }

    public static class ResourceBundleFactory {
        private static HashMap Cache = new HashMap();

        public static synchronized ResourceBundle getBundle(Locale locale) {
            ResourceBundle resourceBundle = (ResourceBundle)Cache.get(locale);
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(Main.bundleName, locale);
                Cache.put(locale, resourceBundle);
            }
            return resourceBundle;
        }
    }
}

