/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.ManifestAnalyzer;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClasspathJar
extends ClasspathLocation {
    protected File file;
    protected ZipFile zipFile;
    protected boolean closeZipFileAtEnd;
    protected Hashtable packageCache;

    public ClasspathJar(File file, boolean bl, AccessRuleSet accessRuleSet, String string) {
        super(accessRuleSet, string);
        this.file = file;
        this.closeZipFileAtEnd = bl;
    }

    /*
     * Loose catch block
     */
    public List fetchLinkedJars(FileSystem.ClasspathSectionProblemReporter classpathSectionProblemReporter) {
        ArrayList<ClasspathJar> arrayList;
        InputStream inputStream;
        block18: {
            inputStream = null;
            this.initialize();
            ArrayList<ClasspathJar> arrayList2 = new ArrayList<ClasspathJar>();
            ZipEntry zipEntry = this.zipFile.getEntry("META-INF/MANIFEST.MF");
            if (zipEntry != null) {
                inputStream = this.zipFile.getInputStream(zipEntry);
                ManifestAnalyzer manifestAnalyzer = new ManifestAnalyzer();
                boolean bl = manifestAnalyzer.analyzeManifestContents(inputStream);
                List list = manifestAnalyzer.getCalledFileNames();
                if (classpathSectionProblemReporter != null) {
                    if (!bl || manifestAnalyzer.getClasspathSectionsCount() == 1 && list == null) {
                        classpathSectionProblemReporter.invalidClasspathSection(this.getPath());
                    } else if (manifestAnalyzer.getClasspathSectionsCount() > 1) {
                        classpathSectionProblemReporter.multipleClasspathSections(this.getPath());
                    }
                }
                if (list != null) {
                    Iterator iterator = list.iterator();
                    String string = this.getPath();
                    int n = string.lastIndexOf(File.separatorChar);
                    string = string.substring(0, n + 1);
                    while (iterator.hasNext()) {
                        arrayList2.add(new ClasspathJar(new File(String.valueOf(string) + (String)iterator.next()), this.closeZipFileAtEnd, this.accessRuleSet, this.destinationPath));
                    }
                }
            }
            arrayList = arrayList2;
            if (inputStream == null) break block18;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return arrayList;
        catch (IOException iOException) {
            block19: {
                try {
                    if (inputStream == null) break block19;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException3) {}
            }
            return null;
        }
    }

    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2) {
        return this.findClass(cArray, string, string2, false);
    }

    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, boolean bl) {
        if (!this.isPackage(string)) {
            return null;
        }
        try {
            ClassFileReader classFileReader = ClassFileReader.read(this.zipFile, string2);
            if (classFileReader != null) {
                return new NameEnvironmentAnswer(classFileReader, this.fetchAccessRestriction(string2));
            }
        }
        catch (ClassFormatException classFormatException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    public char[][][] findTypeNames(String string) {
        Object object;
        if (!this.isPackage(string)) {
            return null;
        }
        ArrayList<char[][]> arrayList = new ArrayList<char[][]>();
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        block0: while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement().getName();
            int n = ((String)object).lastIndexOf(47);
            while (n > 0) {
                String string2 = ((String)object).substring(0, n);
                if (!string.equals(string2)) continue block0;
                int n2 = ((String)object).lastIndexOf(46);
                if (n2 == -1) continue;
                String string3 = ((String)object).substring(n + 1, n2);
                char[] cArray = string2.toCharArray();
                arrayList.add(CharOperation.arrayConcat(CharOperation.splitOn('/', cArray), string3.toCharArray()));
            }
        }
        int n = arrayList.size();
        if (n != 0) {
            object = new char[n][][];
            arrayList.toArray((T[])object);
            return null;
        }
        return null;
    }

    public void initialize() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.file);
        }
    }

    public boolean isPackage(String string) {
        if (this.packageCache != null) {
            return this.packageCache.containsKey(string);
        }
        this.packageCache = new Hashtable(41);
        this.packageCache.put(Util.EMPTY_STRING, Util.EMPTY_STRING);
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        block0: while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().getName();
            int n = string2.lastIndexOf(47);
            while (n > 0) {
                String string3 = string2.substring(0, n);
                if (this.packageCache.containsKey(string3)) continue block0;
                this.packageCache.put(string3, string3);
                n = string3.lastIndexOf(47);
            }
        }
        return this.packageCache.containsKey(string);
    }

    public void reset() {
        if (this.zipFile != null && this.closeZipFileAtEnd) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {}
            this.zipFile = null;
        }
        this.packageCache = null;
    }

    public String toString() {
        return "Classpath for jar file " + this.file.getPath();
    }

    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            String string = this.getPath();
            char[] cArray = string.toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(cArray, '\\', '/');
            }
            this.normalizedPath = CharOperation.subarray(cArray, 0, CharOperation.lastIndexOf('.', cArray));
        }
        return this.normalizedPath;
    }

    public String getPath() {
        if (this.path == null) {
            try {
                this.path = this.file.getCanonicalPath();
            }
            catch (IOException iOException) {
                this.path = this.file.getAbsolutePath();
            }
        }
        return this.path;
    }

    public int getMode() {
        return 2;
    }
}

