/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class Wildcard
extends SingleTypeReference {
    public static final int UNBOUND = 0;
    public static final int EXTENDS = 1;
    public static final int SUPER = 2;
    public TypeReference bound;
    public int kind;

    public Wildcard(int n) {
        super(WILDCARD_NAME, 0L);
        this.kind = n;
    }

    public char[][] getParameterizedTypeName() {
        switch (this.kind) {
            case 0: {
                return new char[][]{WILDCARD_NAME};
            }
            case 1: {
                return new char[][]{CharOperation.concat(WILDCARD_NAME, WILDCARD_EXTENDS, CharOperation.concatWith(this.bound.getParameterizedTypeName(), '.'))};
            }
        }
        return new char[][]{CharOperation.concat(WILDCARD_NAME, WILDCARD_SUPER, CharOperation.concatWith(this.bound.getParameterizedTypeName(), '.'))};
    }

    public char[][] getTypeName() {
        switch (this.kind) {
            case 0: {
                return new char[][]{WILDCARD_NAME};
            }
            case 1: {
                return new char[][]{CharOperation.concat(WILDCARD_NAME, WILDCARD_EXTENDS, CharOperation.concatWith(this.bound.getTypeName(), '.'))};
            }
        }
        return new char[][]{CharOperation.concat(WILDCARD_NAME, WILDCARD_SUPER, CharOperation.concatWith(this.bound.getTypeName(), '.'))};
    }

    private TypeBinding internalResolveType(Scope scope, ReferenceBinding referenceBinding, int n) {
        TypeBinding typeBinding = null;
        if (this.bound != null) {
            typeBinding = scope.kind == 3 ? this.bound.resolveType((ClassScope)scope, 256) : this.bound.resolveType((BlockScope)scope, true, 256);
            this.bits |= this.bound.bits & 0x100000;
            if (typeBinding == null) {
                return null;
            }
        }
        this.resolvedType = scope.environment().createWildcard(referenceBinding, n, typeBinding, null, this.kind);
        this.resolveAnnotations(scope, 0);
        if (typeBinding != null && typeBinding.hasNullTypeAnnotations() && this.resolvedType.hasNullTypeAnnotations() && ((typeBinding.tagBits | this.resolvedType.tagBits) & 0x180000000000000L) == 0x180000000000000L) {
            Annotation annotation = this.bound.findAnnotation(typeBinding.tagBits & 0x180000000000000L);
            if (annotation == null) {
                TypeBinding typeBinding2;
                ((WildcardBinding)this.resolvedType).bound = typeBinding2 = typeBinding.unannotated(true);
                this.bound.resolvedType = typeBinding2;
            } else {
                scope.problemReporter().contradictoryNullAnnotationsOnBounds(annotation, this.resolvedType.tagBits);
            }
        }
        return this.resolvedType;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        if (this.annotations != null && this.annotations[0] != null) {
            Wildcard.printAnnotations(this.annotations[0], stringBuffer);
            stringBuffer.append(' ');
        }
        switch (this.kind) {
            case 0: {
                stringBuffer.append(WILDCARD_NAME);
                break;
            }
            case 1: {
                stringBuffer.append(WILDCARD_NAME).append(WILDCARD_EXTENDS);
                this.bound.printExpression(0, stringBuffer);
                break;
            }
            default: {
                stringBuffer.append(WILDCARD_NAME).append(WILDCARD_SUPER);
                this.bound.printExpression(0, stringBuffer);
            }
        }
        return stringBuffer;
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl, int n) {
        if (this.bound != null) {
            this.bound.resolveType(blockScope, bl, 256);
            this.bits |= this.bound.bits & 0x100000;
        }
        return null;
    }

    public TypeBinding resolveType(ClassScope classScope, int n) {
        if (this.bound != null) {
            this.bound.resolveType(classScope, 256);
            this.bits |= this.bound.bits & 0x100000;
        }
        return null;
    }

    public TypeBinding resolveTypeArgument(BlockScope blockScope, ReferenceBinding referenceBinding, int n) {
        return this.internalResolveType(blockScope, referenceBinding, n);
    }

    public TypeBinding resolveTypeArgument(ClassScope classScope, ReferenceBinding referenceBinding, int n) {
        return this.internalResolveType(classScope, referenceBinding, n);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.annotations != null) {
                Annotation[] annotationArray = this.annotations[0];
                int n = 0;
                int n2 = annotationArray == null ? 0 : annotationArray.length;
                while (n < n2) {
                    annotationArray[n].traverse(aSTVisitor, blockScope);
                    ++n;
                }
            }
            if (this.bound != null) {
                this.bound.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            if (this.annotations != null) {
                Annotation[] annotationArray = this.annotations[0];
                int n = 0;
                int n2 = annotationArray == null ? 0 : annotationArray.length;
                while (n < n2) {
                    annotationArray[n].traverse(aSTVisitor, classScope);
                    ++n;
                }
            }
            if (this.bound != null) {
                this.bound.traverse(aSTVisitor, classScope);
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }

    public boolean isWildcard() {
        return true;
    }
}

