/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class UnionTypeReference
extends TypeReference {
    public TypeReference[] typeReferences;

    public UnionTypeReference(TypeReference[] typeReferenceArray) {
        this.bits |= 0x20000000;
        this.typeReferences = typeReferenceArray;
        this.sourceStart = typeReferenceArray[0].sourceStart;
        int n = typeReferenceArray.length;
        this.sourceEnd = typeReferenceArray[n - 1].sourceEnd;
    }

    public char[] getLastToken() {
        return null;
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl, int n) {
        int n2 = this.typeReferences.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n2];
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n2) {
            TypeBinding typeBinding = this.typeReferences[n3].resolveType(blockScope, bl, n);
            if (typeBinding == null) {
                return null;
            }
            switch (typeBinding.kind()) {
                case 260: {
                    if (!typeBinding.isBoundParameterizedType()) break;
                    bl2 = true;
                    blockScope.problemReporter().invalidParameterizedExceptionType(typeBinding, this.typeReferences[n3]);
                    break;
                }
                case 4100: {
                    blockScope.problemReporter().invalidTypeVariableAsException(typeBinding, this.typeReferences[n3]);
                    bl2 = true;
                }
            }
            if (typeBinding.findSuperTypeOriginatingFrom(21, true) == null && typeBinding.isValidBinding()) {
                blockScope.problemReporter().cannotThrowType(this.typeReferences[n3], typeBinding);
                bl2 = true;
            }
            typeBindingArray[n3] = typeBinding;
            int n4 = 0;
            while (n4 < n3) {
                if (typeBindingArray[n4].isCompatibleWith(typeBinding)) {
                    blockScope.problemReporter().wrongSequenceOfExceptionTypes(this.typeReferences[n4], typeBindingArray[n4], typeBinding);
                    bl2 = true;
                } else if (typeBinding.isCompatibleWith(typeBindingArray[n4])) {
                    blockScope.problemReporter().wrongSequenceOfExceptionTypes(this.typeReferences[n3], typeBinding, typeBindingArray[n4]);
                    bl2 = true;
                }
                ++n4;
            }
            ++n3;
        }
        if (bl2) {
            return null;
        }
        this.resolvedType = blockScope.lowerUpperBound(typeBindingArray);
        return this.resolvedType;
    }

    public char[][] getTypeName() {
        return this.typeReferences[0].getTypeName();
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n = this.typeReferences == null ? 0 : this.typeReferences.length;
            int n2 = 0;
            while (n2 < n) {
                this.typeReferences[n2].traverse(aSTVisitor, blockScope);
                ++n2;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n = this.typeReferences == null ? 0 : this.typeReferences.length;
            int n2 = 0;
            while (n2 < n) {
                this.typeReferences[n2].traverse(aSTVisitor, classScope);
                ++n2;
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2 = this.typeReferences == null ? 0 : this.typeReferences.length;
        UnionTypeReference.printIndent(n, stringBuffer);
        int n3 = 0;
        while (n3 < n2) {
            this.typeReferences[n3].printExpression(0, stringBuffer);
            if (n3 != n2 - 1) {
                stringBuffer.append(" | ");
            }
            ++n3;
        }
        return stringBuffer;
    }

    public boolean isUnionType() {
        return true;
    }

    public TypeReference augmentTypeWithAdditionalDimensions(int n, Annotation[][] annotationArray, boolean bl) {
        return this;
    }
}

