/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.List;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class TypeParameter
extends AbstractVariableDeclaration {
    public TypeVariableBinding binding;
    public TypeReference[] bounds;

    public int getKind() {
        return 6;
    }

    public void checkBounds(Scope scope) {
        if (this.type != null) {
            this.type.checkBounds(scope);
        }
        if (this.bounds != null) {
            int n = 0;
            int n2 = this.bounds.length;
            while (n < n2) {
                this.bounds[n].checkBounds(scope);
                ++n;
            }
        }
    }

    public void getAllAnnotationContexts(int n, int n2, List list) {
        int n3;
        int n4;
        TypeReference.AnnotationCollector annotationCollector = new TypeReference.AnnotationCollector(this, n, n2, list);
        if (this.annotations != null) {
            n4 = this.annotations.length;
            n3 = 0;
            while (n3 < n4) {
                this.annotations[n3].traverse((ASTVisitor)annotationCollector, (BlockScope)null);
                ++n3;
            }
        }
        switch (annotationCollector.targetType) {
            case 0: {
                annotationCollector.targetType = 17;
                break;
            }
            case 1: {
                annotationCollector.targetType = 18;
            }
        }
        n4 = 0;
        if (this.type != null) {
            if (this.type.resolvedType.isInterface()) {
                n4 = 1;
            }
            if ((this.type.bits & 0x100000) != 0) {
                annotationCollector.info2 = n4;
                this.type.traverse((ASTVisitor)annotationCollector, (BlockScope)null);
            }
        }
        if (this.bounds != null) {
            n3 = this.bounds.length;
            int n5 = 0;
            while (n5 < n3) {
                TypeReference typeReference = this.bounds[n5];
                if ((typeReference.bits & 0x100000) != 0) {
                    annotationCollector.info2 = ++n4;
                    typeReference.traverse((ASTVisitor)annotationCollector, (BlockScope)null);
                }
                ++n5;
            }
        }
    }

    private void internalResolve(Scope scope, boolean bl) {
        Binding binding;
        if (this.binding != null && (binding = scope.parent.getBinding(this.name, 4, this, false)) != null && this.binding != binding && binding.isValidBinding() && (binding.kind() != 4100 || !bl)) {
            scope.problemReporter().typeHiding(this, binding);
        }
        if (this.annotations != null) {
            this.resolveAnnotations(scope);
        }
    }

    public void resolve(BlockScope blockScope) {
        this.internalResolve(blockScope, blockScope.methodScope().isStatic);
    }

    public void resolve(ClassScope classScope) {
        this.internalResolve(classScope, classScope.enclosingSourceType().isStatic());
    }

    public void resolveAnnotations(Scope scope) {
        AnnotationBinding[] annotationBindingArray;
        BlockScope blockScope = Scope.typeAnnotationsResolutionScope(scope);
        if (blockScope != null && (annotationBindingArray = TypeParameter.resolveAnnotations(blockScope, this.annotations, this.binding, false)) != null && annotationBindingArray.length > 0) {
            this.binding.setTypeAnnotations(annotationBindingArray, scope.environment().globalOptions.isAnnotationBasedNullAnalysisEnabled);
            scope.referenceCompilationUnit().compilationResult.hasAnnotations = true;
            if (this.binding != null && this.binding.isValidBinding()) {
                this.binding.evaluateNullAnnotations(scope, this);
            }
        }
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        if (this.annotations != null) {
            TypeParameter.printAnnotations(this.annotations, stringBuffer);
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.name);
        if (this.type != null) {
            stringBuffer.append(" extends ");
            this.type.print(0, stringBuffer);
        }
        if (this.bounds != null) {
            int n2 = 0;
            while (n2 < this.bounds.length) {
                stringBuffer.append(" & ");
                this.bounds[n2].print(0, stringBuffer);
                ++n2;
            }
        }
        return stringBuffer;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.annotations != null) {
                n2 = this.annotations.length;
                n = 0;
                while (n < n2) {
                    this.annotations[n].traverse(aSTVisitor, blockScope);
                    ++n;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.bounds != null) {
                n2 = this.bounds.length;
                n = 0;
                while (n < n2) {
                    this.bounds[n].traverse(aSTVisitor, blockScope);
                    ++n;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            int n2;
            if (this.annotations != null) {
                n2 = this.annotations.length;
                n = 0;
                while (n < n2) {
                    this.annotations[n].traverse(aSTVisitor, classScope);
                    ++n;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, classScope);
            }
            if (this.bounds != null) {
                n2 = this.bounds.length;
                n = 0;
                while (n < n2) {
                    this.bounds[n].traverse(aSTVisitor, classScope);
                    ++n;
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

