/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.VoidTypeBinding;

public class ReturnStatement
extends Statement {
    public Expression expression;
    public SubRoutineStatement[] subroutines;
    public LocalVariableBinding saveValueVariable;
    public int initStateIndex = -1;
    private boolean implicitReturn;

    public ReturnStatement(Expression expression, int n, int n2) {
        this(expression, n, n2, false);
    }

    public ReturnStatement(Expression expression, int n, int n2, boolean bl) {
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.expression = expression;
        this.implicitReturn = bl;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        TypeConstants typeConstants;
        if (this.expression instanceof FunctionalExpression && (this.expression.resolvedType == null || !this.expression.resolvedType.isValidBinding())) {
            flowContext.recordAbruptExit();
            return FlowInfo.DEAD_END;
        }
        MethodScope methodScope = blockScope.methodScope();
        if (this.expression != null) {
            flowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo);
            this.expression.checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
            if (flowInfo.reachMode() == 0 && blockScope.compilerOptions().isAnnotationBasedNullAnalysisEnabled) {
                this.checkAgainstNullAnnotation(blockScope, flowContext, flowInfo);
            }
            if (blockScope.compilerOptions().analyseResourceLeaks && (typeConstants = FakedTrackingVariable.getCloseTrackingVariable(this.expression, flowInfo, flowContext)) != null) {
                if (methodScope != ((FakedTrackingVariable)typeConstants).methodScope) {
                    ((FakedTrackingVariable)typeConstants).markClosedInNestedMethod();
                }
                flowInfo = FakedTrackingVariable.markPassedToOutside(blockScope, this.expression, flowInfo, flowContext, true);
            }
        }
        this.initStateIndex = methodScope.recordInitializationStates(flowInfo);
        typeConstants = flowContext;
        int n = 0;
        boolean bl = false;
        boolean bl2 = this.needValueStore();
        boolean bl3 = true;
        do {
            SubRoutineStatement subRoutineStatement;
            if ((subRoutineStatement = ((FlowContext)typeConstants).subroutine()) != null) {
                if (this.subroutines == null) {
                    this.subroutines = new SubRoutineStatement[5];
                }
                if (n == this.subroutines.length) {
                    this.subroutines = new SubRoutineStatement[n * 2];
                    System.arraycopy(this.subroutines, 0, this.subroutines, 0, n);
                }
                this.subroutines[n++] = subRoutineStatement;
                if (subRoutineStatement.isSubRoutineEscaping()) {
                    bl = false;
                    this.bits |= 0x20000000;
                    break;
                }
                if (subRoutineStatement instanceof TryStatement && ((TryStatement)subRoutineStatement).resources.length > 0) {
                    bl3 = false;
                }
            }
            ((FlowContext)typeConstants).recordReturnFrom(flowInfo.unconditionalInits());
            if (typeConstants instanceof InsideSubRoutineFlowContext) {
                ASTNode aSTNode = ((FlowContext)typeConstants).associatedNode;
                if (aSTNode instanceof SynchronizedStatement) {
                    this.bits |= 0x40000000;
                    continue;
                }
                if (!(aSTNode instanceof TryStatement)) continue;
                TryStatement tryStatement = (TryStatement)aSTNode;
                flowInfo.addInitializationsFrom(tryStatement.subRoutineInits);
                if (!bl2) continue;
                if (this.saveValueVariable == null) {
                    this.prepareSaveValueLocation(tryStatement);
                }
                bl = true;
                this.initStateIndex = methodScope.recordInitializationStates(flowInfo);
                continue;
            }
            if (!(typeConstants instanceof InitializationFlowContext)) continue;
            blockScope.problemReporter().cannotReturnInInitializer(this);
            return FlowInfo.DEAD_END;
        } while ((typeConstants = ((FlowContext)typeConstants).getLocalParent()) != null);
        if (this.subroutines != null && n != this.subroutines.length) {
            this.subroutines = new SubRoutineStatement[n];
            System.arraycopy(this.subroutines, 0, this.subroutines, 0, n);
        }
        if (bl) {
            if (this.saveValueVariable != null) {
                this.saveValueVariable.useFlag = 1;
            }
        } else {
            this.saveValueVariable = null;
            if ((this.bits & 0x40000000) == 0 && this.expression != null && TypeBinding.equalsEquals(this.expression.resolvedType, TypeBinding.BOOLEAN) && bl3) {
                this.expression.bits |= 0x10;
            }
        }
        blockScope.checkUnclosedCloseables(flowInfo, flowContext, this, blockScope);
        flowContext.recordAbruptExit();
        return FlowInfo.DEAD_END;
    }

    void checkAgainstNullAnnotation(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        long l;
        int n = this.expression.nullStatus(flowInfo, flowContext);
        MethodBinding methodBinding = null;
        boolean bl = blockScope.compilerOptions().sourceLevel >= 0x340000L;
        try {
            methodBinding = blockScope.methodScope().referenceMethodBinding();
            l = bl ? methodBinding.returnType.tagBits : methodBinding.tagBits;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        if (bl) {
            this.checkAgainstNullTypeAnnotation(blockScope, methodBinding.returnType, this.expression, flowContext, flowInfo);
        } else if (n != 4 && (l & 0x100000000000000L) != 0L) {
            flowContext.recordNullityMismatch(blockScope, this.expression, this.expression.resolvedType, methodBinding.returnType, n);
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        boolean bl = false;
        if (this.needValueStore()) {
            bl = true;
            this.expression.generateCode(blockScope, codeStream, this.needValue());
            this.generateStoreSaveValueIfNecessary(codeStream);
        }
        if (this.subroutines != null) {
            VoidTypeBinding voidTypeBinding = this.expression == null ? TypeBinding.VOID : this.expression.reusableJSRTarget();
            int n2 = 0;
            int n3 = this.subroutines.length;
            while (n2 < n3) {
                SubRoutineStatement subRoutineStatement = this.subroutines[n2];
                boolean bl2 = subRoutineStatement.generateSubRoutineInvocation(blockScope, codeStream, voidTypeBinding, this.initStateIndex, this.saveValueVariable);
                if (bl2) {
                    codeStream.recordPositionsFrom(n, this.sourceStart);
                    SubRoutineStatement.reenterAllExceptionHandlers(this.subroutines, n2, codeStream);
                    return;
                }
                ++n2;
            }
        }
        if (this.saveValueVariable != null) {
            codeStream.load(this.saveValueVariable);
        }
        if (this.expression != null && !bl) {
            this.expression.generateCode(blockScope, codeStream, true);
            this.generateStoreSaveValueIfNecessary(codeStream);
        }
        this.generateReturnBytecode(codeStream);
        if (this.saveValueVariable != null) {
            codeStream.removeVariable(this.saveValueVariable);
        }
        if (this.initStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.initStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.initStateIndex);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
        SubRoutineStatement.reenterAllExceptionHandlers(this.subroutines, -1, codeStream);
    }

    public void generateReturnBytecode(CodeStream codeStream) {
        codeStream.generateReturnBytecode(this.expression);
    }

    public void generateStoreSaveValueIfNecessary(CodeStream codeStream) {
        if (this.saveValueVariable != null) {
            codeStream.store(this.saveValueVariable, false);
            codeStream.addVariable(this.saveValueVariable);
        }
    }

    private boolean needValueStore() {
        return this.expression != null && (this.expression.constant == Constant.NotAConstant || (this.expression.implicitConversion & 0x200) != 0) && !(this.expression instanceof NullLiteral);
    }

    public boolean needValue() {
        return this.saveValueVariable != null || (this.bits & 0x40000000) != 0 || (this.bits & 0x20000000) == 0;
    }

    public void prepareSaveValueLocation(TryStatement tryStatement) {
        this.saveValueVariable = tryStatement.secretReturnValue;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        ReturnStatement.printIndent(n, stringBuffer).append("return ");
        if (this.expression != null) {
            this.expression.printExpression(0, stringBuffer);
        }
        return stringBuffer.append(';');
    }

    public void resolve(BlockScope blockScope) {
        TypeBinding typeBinding;
        MethodBinding methodBinding;
        LambdaExpression lambdaExpression;
        MethodScope methodScope = blockScope.methodScope();
        LambdaExpression lambdaExpression2 = lambdaExpression = methodScope.referenceContext instanceof LambdaExpression ? (LambdaExpression)methodScope.referenceContext : null;
        Object object = lambdaExpression != null ? lambdaExpression.expectedResultType() : (methodScope.referenceContext instanceof AbstractMethodDeclaration ? ((methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) == null ? null : methodBinding.returnType) : (typeBinding = TypeBinding.VOID));
        if (this.expression != null) {
            this.expression.setExpressionContext(ExpressionContext.ASSIGNMENT_CONTEXT);
            this.expression.setExpectedType(typeBinding);
        }
        if (typeBinding == TypeBinding.VOID) {
            if (this.expression == null) {
                if (lambdaExpression != null) {
                    lambdaExpression.returnsExpression(null, TypeBinding.VOID);
                }
                return;
            }
            TypeBinding typeBinding2 = this.expression.resolveType(blockScope);
            if (lambdaExpression != null) {
                lambdaExpression.returnsExpression(this.expression, typeBinding2);
            }
            if (this.implicitReturn && (typeBinding2 == TypeBinding.VOID || this.expression.statementExpression())) {
                return;
            }
            if (typeBinding2 != null) {
                blockScope.problemReporter().attemptToReturnNonVoidExpression(this, typeBinding2);
            }
            return;
        }
        if (this.expression == null) {
            if (lambdaExpression != null) {
                lambdaExpression.returnsExpression(null, typeBinding);
            }
            if (typeBinding != null) {
                blockScope.problemReporter().shouldReturn(typeBinding, this);
            }
            return;
        }
        TypeBinding typeBinding3 = this.expression.resolveType(blockScope);
        if (lambdaExpression != null) {
            lambdaExpression.returnsExpression(this.expression, typeBinding3);
        }
        if (typeBinding3 == null) {
            return;
        }
        if (typeBinding3 == TypeBinding.VOID) {
            blockScope.problemReporter().attemptToReturnVoidValue(this);
            return;
        }
        if (typeBinding == null) {
            return;
        }
        if (TypeBinding.notEquals(typeBinding, typeBinding3)) {
            blockScope.compilationUnitScope().recordTypeConversion(typeBinding, typeBinding3);
        }
        if (this.expression.isConstantValueOfTypeAssignableToType(typeBinding3, typeBinding) || typeBinding3.isCompatibleWith(typeBinding)) {
            this.expression.computeConversion(blockScope, typeBinding, typeBinding3);
            if (typeBinding3.needsUncheckedConversion(typeBinding)) {
                blockScope.problemReporter().unsafeTypeConversion(this.expression, typeBinding3, typeBinding);
            }
            if (this.expression instanceof CastExpression && (this.expression.bits & 0x4020) == 0) {
                CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.expression);
            }
            return;
        }
        if (this.isBoxingCompatible(typeBinding3, typeBinding, this.expression, blockScope)) {
            this.expression.computeConversion(blockScope, typeBinding, typeBinding3);
            if (this.expression instanceof CastExpression && (this.expression.bits & 0x4020) == 0) {
                CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.expression);
            }
            return;
        }
        if ((typeBinding.tagBits & 0x80L) == 0L) {
            blockScope.problemReporter().typeMismatchError(typeBinding3, typeBinding, this.expression, (ASTNode)this);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.expression != null) {
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

