/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class Reference
extends Expression {
    public abstract FlowInfo analyseAssignment(BlockScope var1, FlowContext var2, FlowInfo var3, Assignment var4, boolean var5);

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public boolean checkNPE(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (flowContext.isNullcheckedFieldAccess(this)) {
            return true;
        }
        return super.checkNPE(blockScope, flowContext, flowInfo);
    }

    protected boolean checkNullableFieldDereference(Scope scope, FieldBinding fieldBinding, long l) {
        if ((fieldBinding.type.tagBits & 0x80000000000000L) != 0L) {
            scope.problemReporter().dereferencingNullableExpression(l, scope.environment());
            return true;
        }
        if ((fieldBinding.tagBits & 0x80000000000000L) != 0L) {
            scope.problemReporter().nullableFieldDereference(fieldBinding, l);
            return true;
        }
        return false;
    }

    public FieldBinding fieldBinding() {
        return null;
    }

    public void fieldStore(Scope scope, CodeStream codeStream, FieldBinding fieldBinding, MethodBinding methodBinding, TypeBinding typeBinding, boolean bl, boolean bl2) {
        int n = codeStream.position;
        if (fieldBinding.isStatic()) {
            if (bl2) {
                switch (fieldBinding.type.id) {
                    case 7: 
                    case 8: {
                        codeStream.dup2();
                        break;
                    }
                    default: {
                        codeStream.dup();
                    }
                }
            }
            if (methodBinding == null) {
                TypeBinding typeBinding2 = CodeStream.getConstantPoolDeclaringClass(scope, fieldBinding, typeBinding, bl);
                codeStream.fieldAccess((byte)-77, fieldBinding, typeBinding2);
            } else {
                codeStream.invoke((byte)-72, methodBinding, null);
            }
        } else {
            if (bl2) {
                switch (fieldBinding.type.id) {
                    case 7: 
                    case 8: {
                        codeStream.dup2_x1();
                        break;
                    }
                    default: {
                        codeStream.dup_x1();
                    }
                }
            }
            if (methodBinding == null) {
                TypeBinding typeBinding3 = CodeStream.getConstantPoolDeclaringClass(scope, fieldBinding, typeBinding, bl);
                codeStream.fieldAccess((byte)-75, fieldBinding, typeBinding3);
            } else {
                codeStream.invoke((byte)-72, methodBinding, null);
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public abstract void generateAssignment(BlockScope var1, CodeStream var2, Assignment var3, boolean var4);

    public abstract void generateCompoundAssignment(BlockScope var1, CodeStream var2, Expression var3, int var4, int var5, boolean var6);

    public abstract void generatePostIncrement(BlockScope var1, CodeStream var2, CompoundAssignment var3, boolean var4);

    public boolean isEquivalent(Reference reference) {
        return false;
    }

    public FieldBinding lastFieldBinding() {
        return null;
    }

    public int nullStatus(FlowInfo flowInfo, FlowContext flowContext) {
        FieldBinding fieldBinding = this.lastFieldBinding();
        if (fieldBinding != null) {
            if (fieldBinding.isNonNull() || flowContext.isNullcheckedFieldAccess(this)) {
                return 4;
            }
            if (fieldBinding.isNullable()) {
                return 16;
            }
        }
        if (this.resolvedType != null) {
            return FlowInfo.tagBitsToNullStatus(this.resolvedType.tagBits);
        }
        return 1;
    }

    void reportOnlyUselesslyReadPrivateField(BlockScope blockScope, FieldBinding fieldBinding, boolean bl) {
        if (bl) {
            fieldBinding.compoundUseFlag = 0;
            fieldBinding.modifiers |= 0x8000000;
        } else if (fieldBinding.isUsedOnlyInCompound()) {
            --fieldBinding.compoundUseFlag;
            if (fieldBinding.compoundUseFlag == 0 && fieldBinding.isOrEnclosedByPrivateType() && (this.implicitConversion & 0x400) == 0) {
                blockScope.problemReporter().unusedPrivateField(fieldBinding.sourceField());
                fieldBinding.modifiers |= 0x8000000;
            }
        }
    }

    static void reportOnlyUselesslyReadLocal(BlockScope blockScope, LocalVariableBinding localVariableBinding, boolean bl) {
        if (localVariableBinding.declaration == null) {
            return;
        }
        if ((localVariableBinding.declaration.bits & 0x40000000) == 0) {
            return;
        }
        if (localVariableBinding.useFlag >= 1) {
            return;
        }
        if (bl) {
            localVariableBinding.useFlag = 1;
            return;
        }
        ++localVariableBinding.useFlag;
        if (localVariableBinding.useFlag != 0) {
            return;
        }
        if (localVariableBinding.declaration instanceof Argument) {
            MethodScope methodScope = blockScope.methodScope();
            if (methodScope != null && !methodScope.isLambdaScope()) {
                boolean bl2;
                MethodBinding methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext()).binding;
                boolean bl3 = bl2 = !methodBinding.isMain();
                if (methodBinding.isImplementing()) {
                    bl2 &= blockScope.compilerOptions().reportUnusedParameterWhenImplementingAbstract;
                } else if (methodBinding.isOverriding()) {
                    bl2 &= blockScope.compilerOptions().reportUnusedParameterWhenOverridingConcrete;
                }
                if (bl2) {
                    blockScope.problemReporter().unusedArgument(localVariableBinding.declaration);
                }
            }
        } else {
            blockScope.problemReporter().unusedLocalVariable(localVariableBinding.declaration);
        }
        localVariableBinding.useFlag = 1;
    }
}

