/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class QualifiedSuperReference
extends QualifiedThisReference {
    public QualifiedSuperReference(TypeReference typeReference, int n, int n2) {
        super(typeReference, n, n2);
    }

    public boolean isSuper() {
        return true;
    }

    public boolean isThis() {
        return false;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        return this.qualification.print(0, stringBuffer).append(".super");
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        if ((this.bits & 0x1FE00000) != 0) {
            blockScope.problemReporter().invalidParenthesizedExpression(this);
            return null;
        }
        super.resolveType(blockScope);
        if (this.resolvedType != null && !this.resolvedType.isValidBinding()) {
            blockScope.problemReporter().illegalSuperAccess(this.qualification.resolvedType, this.resolvedType, this);
            return null;
        }
        if (this.currentCompatibleType == null) {
            return null;
        }
        if (this.currentCompatibleType.id == 1) {
            blockScope.problemReporter().cannotUseSuperInJavaLangObject(this);
            return null;
        }
        this.resolvedType = this.currentCompatibleType.isInterface() ? this.currentCompatibleType : this.currentCompatibleType.superclass();
        return this.resolvedType;
    }

    int findCompatibleEnclosing(ReferenceBinding referenceBinding, TypeBinding typeBinding) {
        if (typeBinding.isInterface()) {
            ReferenceBinding[] referenceBindingArray = referenceBinding.superInterfaces();
            int n = referenceBindingArray.length;
            boolean bl = true;
            char[][] cArray = null;
            ReferenceBinding referenceBinding2 = null;
            int n2 = 0;
            while (n2 < n) {
                if (TypeBinding.equalsEquals(referenceBindingArray[n2].erasure(), typeBinding)) {
                    this.currentCompatibleType = referenceBinding2 = referenceBindingArray[n2];
                } else if (referenceBindingArray[n2].erasure().isCompatibleWith(typeBinding)) {
                    bl = false;
                    cArray = referenceBindingArray[n2].compoundName;
                    if (referenceBinding2 == null) {
                        referenceBinding2 = referenceBindingArray[n2];
                    }
                }
                ++n2;
            }
            if (!bl) {
                this.currentCompatibleType = null;
                this.resolvedType = new ProblemReferenceBinding(cArray, referenceBinding2, 21);
            }
            return 0;
        }
        return super.findCompatibleEnclosing(referenceBinding, typeBinding);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.qualification.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            this.qualification.traverse(aSTVisitor, classScope);
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

