/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedQualifiedTypeReference
extends ArrayQualifiedTypeReference {
    public TypeReference[][] typeArguments;

    public ParameterizedQualifiedTypeReference(char[][] cArray, TypeReference[][] typeReferenceArray, int n, long[] lArray) {
        super(cArray, n, lArray);
        this.typeArguments = typeReferenceArray;
        int n2 = 0;
        int n3 = typeReferenceArray.length;
        block0: while (n2 < n3) {
            TypeReference[] typeReferenceArray2 = typeReferenceArray[n2];
            if (typeReferenceArray2 != null) {
                int n4 = 0;
                int n5 = typeReferenceArray2.length;
                while (n4 < n5) {
                    if ((typeReferenceArray2[n4].bits & 0x100000) != 0) {
                        this.bits |= 0x100000;
                        break block0;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public ParameterizedQualifiedTypeReference(char[][] cArray, TypeReference[][] typeReferenceArray, int n, Annotation[][] annotationArray, long[] lArray) {
        this(cArray, typeReferenceArray, n, lArray);
        this.setAnnotationsOnDimensions(annotationArray);
        if (annotationArray != null) {
            this.bits |= 0x100000;
        }
    }

    public void checkBounds(Scope scope) {
        if (this.resolvedType == null) {
            return;
        }
        this.checkBounds((ReferenceBinding)this.resolvedType.leafComponentType(), scope, this.typeArguments.length - 1);
    }

    public void checkBounds(ReferenceBinding referenceBinding, Scope scope, int n) {
        ParameterizedTypeBinding parameterizedTypeBinding;
        ReferenceBinding referenceBinding2;
        TypeVariableBinding[] typeVariableBindingArray;
        if (n > 0 && referenceBinding.enclosingType() != null) {
            this.checkBounds(referenceBinding.enclosingType(), scope, n - 1);
        }
        if (referenceBinding.isParameterizedTypeWithActualArguments() && (typeVariableBindingArray = (referenceBinding2 = (parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding).genericType()).typeVariables()) != null) {
            parameterizedTypeBinding.boundCheck(scope, this.typeArguments[n]);
        }
        this.checkNullConstraints(scope, this.typeArguments[n]);
    }

    public TypeReference augmentTypeWithAdditionalDimensions(int n, Annotation[][] annotationArray, boolean bl) {
        int n2 = this.dimensions() + n;
        Annotation[][] annotationArray2 = this.getMergedAnnotationsOnDimensions(n, annotationArray);
        ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference = new ParameterizedQualifiedTypeReference(this.tokens, this.typeArguments, n2, annotationArray2, this.sourcePositions);
        parameterizedQualifiedTypeReference.annotations = this.annotations;
        parameterizedQualifiedTypeReference.bits |= this.bits & 0x100000;
        if (!bl) {
            parameterizedQualifiedTypeReference.extendedDimensions = n;
        }
        return parameterizedQualifiedTypeReference;
    }

    public boolean isParameterizedTypeReference() {
        return true;
    }

    public char[][] getParameterizedTypeName() {
        int n;
        Object[] objectArray;
        int n2 = this.tokens.length;
        char[][] cArrayArray = new char[n2][];
        int n3 = 0;
        while (n3 < n2) {
            objectArray = this.typeArguments[n3];
            if (objectArray == null) {
                cArrayArray[n3] = this.tokens[n3];
            } else {
                StringBuffer stringBuffer = new StringBuffer(5);
                stringBuffer.append(this.tokens[n3]);
                stringBuffer.append('<');
                n = 0;
                int n4 = objectArray.length;
                while (n < n4) {
                    if (n > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(CharOperation.concatWith(objectArray[n].getParameterizedTypeName(), '.'));
                    ++n;
                }
                stringBuffer.append('>');
                n = stringBuffer.length();
                cArrayArray[n3] = new char[n];
                stringBuffer.getChars(0, n, cArrayArray[n3], 0);
            }
            ++n3;
        }
        n3 = this.dimensions;
        if (n3 > 0) {
            objectArray = new char[n3 * 2];
            int n5 = 0;
            while (n5 < n3) {
                n = n5 * 2;
                objectArray[n] = (TypeReference)91;
                objectArray[n + 1] = (TypeReference)93;
                ++n5;
            }
            cArrayArray[n2 - 1] = CharOperation.concat(cArrayArray[n2 - 1], (char[])objectArray);
        }
        return cArrayArray;
    }

    public TypeReference[][] getTypeArguments() {
        return this.typeArguments;
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    private TypeBinding internalResolveType(Scope scope, boolean bl, int n) {
        this.constant = Constant.NotAConstant;
        if ((this.bits & 0x40000) != 0 && this.resolvedType != null) {
            if (this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            switch (this.resolvedType.problemId()) {
                case 1: 
                case 2: 
                case 5: {
                    TypeBinding typeBinding = this.resolvedType.closestMatch();
                    return typeBinding;
                }
            }
            return null;
        }
        this.bits |= 0x40000;
        TypeBinding typeBinding = this.internalResolveLeafType(scope, bl);
        this.createArrayType(scope);
        this.resolveAnnotations(scope, n);
        if (this.typeArguments != null && bl) {
            this.checkNullConstraints(scope, this.typeArguments[this.typeArguments.length - 1]);
        }
        return typeBinding == null ? typeBinding : this.resolvedType;
    }

    private TypeBinding internalResolveLeafType(Scope scope, boolean bl) {
        boolean bl2 = scope.kind == 3;
        Binding binding = scope.getPackage(this.tokens);
        if (binding != null && !binding.isValidBinding()) {
            this.resolvedType = (ReferenceBinding)binding;
            this.reportInvalidType(scope);
            int n = 0;
            int n2 = this.tokens.length;
            while (n < n2) {
                TypeReference[] typeReferenceArray = this.typeArguments[n];
                if (typeReferenceArray != null) {
                    int n3 = typeReferenceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TypeReference typeReference = typeReferenceArray[n4];
                        if (bl2) {
                            typeReference.resolveType((ClassScope)scope);
                        } else {
                            typeReference.resolveType((BlockScope)scope, bl);
                        }
                        ++n4;
                    }
                }
                ++n;
            }
            return null;
        }
        PackageBinding packageBinding = binding == null ? null : (PackageBinding)binding;
        this.rejectAnnotationsOnPackageQualifiers(scope, packageBinding);
        boolean bl3 = true;
        Object object = null;
        int n = packageBinding == null ? 0 : packageBinding.compoundName.length;
        int n5 = this.tokens.length;
        while (n < n5) {
            Object object2;
            int n6;
            Object object3;
            this.findNextTypeBinding(n, scope, packageBinding);
            if (!this.resolvedType.isValidBinding()) {
                this.reportInvalidType(scope);
                int n7 = n;
                while (n7 < n5) {
                    object3 = this.typeArguments[n7];
                    if (object3 != null) {
                        int n8 = ((TypeReference[])object3).length;
                        n6 = 0;
                        while (n6 < n8) {
                            Object object4 = object3[n6];
                            if (bl2) {
                                ((TypeReference)object4).resolveType((ClassScope)scope);
                            } else {
                                ((TypeReference)object4).resolveType((BlockScope)scope);
                            }
                            ++n6;
                        }
                    }
                    ++n7;
                }
                return null;
            }
            ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
            if (object == null) {
                object = referenceBinding.enclosingType();
                if (object != null) {
                    object = referenceBinding.isStatic() ? (ReferenceBinding)scope.environment().convertToRawType((TypeBinding)object, false) : scope.environment().convertToParameterizedType((ReferenceBinding)object);
                }
            } else {
                if (this.annotations != null) {
                    ParameterizedQualifiedTypeReference.rejectAnnotationsOnStaticMemberQualififer(scope, referenceBinding, this.annotations[n - 1]);
                }
                if (bl3 && referenceBinding.isStatic() && (((TypeBinding)object).isParameterizedTypeWithActualArguments() || ((TypeBinding)object).isGenericType())) {
                    scope.problemReporter().staticMemberOfParameterizedType(this, scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), null, (ReferenceBinding)object), n);
                    bl3 = false;
                }
                if ((object3 = referenceBinding.enclosingType()) != null && TypeBinding.notEquals(((TypeBinding)object3).erasure(), ((TypeBinding)object).erasure())) {
                    object = object3;
                }
            }
            if ((object3 = this.typeArguments[n]) != null) {
                TypeVariableBinding[] typeVariableBindingArray;
                Object object5;
                object2 = null;
                if (bl2) {
                    object2 = ((ClassScope)scope).superTypeReference;
                    ((ClassScope)scope).superTypeReference = null;
                }
                boolean bl4 = (n6 = ((Object)object3).length) == 0 && n == n5 - 1 && (this.bits & 0x80000) != 0;
                TypeBinding[] typeBindingArray = new TypeBinding[n6];
                boolean bl5 = false;
                ReferenceBinding referenceBinding2 = (ReferenceBinding)referenceBinding.original();
                int n9 = 0;
                while (n9 < n6) {
                    TypeBinding typeBinding;
                    object5 = object3[n9];
                    TypeBinding typeBinding2 = typeBinding = bl2 ? ((TypeReference)object5).resolveTypeArgument((ClassScope)scope, referenceBinding2, n9) : ((TypeReference)object5).resolveTypeArgument((BlockScope)scope, referenceBinding2, n9);
                    if (typeBinding == null) {
                        bl5 = true;
                    } else {
                        typeBindingArray[n9] = typeBinding;
                    }
                    ++n9;
                }
                if (bl5) {
                    return null;
                }
                if (bl2) {
                    ((ClassScope)scope).superTypeReference = object2;
                    if (((ClassScope)scope).detectHierarchyCycle(referenceBinding2, this)) {
                        return null;
                    }
                }
                if ((typeVariableBindingArray = referenceBinding2.typeVariables()) == Binding.NO_TYPE_VARIABLES) {
                    if (scope.compilerOptions().originalSourceLevel >= 0x310000L) {
                        scope.problemReporter().nonGenericTypeCannotBeParameterized(n, this, referenceBinding, typeBindingArray);
                        return null;
                    }
                    this.resolvedType = object != null && ((TypeBinding)object).isParameterizedType() ? scope.environment().createParameterizedType(referenceBinding2, null, (ReferenceBinding)object) : referenceBinding;
                    return this.resolvedType;
                }
                if (n6 != typeVariableBindingArray.length && !bl4) {
                    scope.problemReporter().incorrectArityForParameterizedType(this, referenceBinding, typeBindingArray, n);
                    return null;
                }
                if (bl3 && !referenceBinding.isStatic() && (object5 = referenceBinding.enclosingType()) != null && ((TypeBinding)object5).isRawType()) {
                    scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType(referenceBinding2, (ReferenceBinding)object5), typeBindingArray);
                    bl3 = false;
                }
                object5 = scope.environment().createParameterizedType(referenceBinding2, typeBindingArray, (ReferenceBinding)object);
                if (!bl4) {
                    if (bl) {
                        ((ParameterizedTypeBinding)object5).boundCheck(scope, (TypeReference[])object3);
                    } else {
                        scope.deferBoundCheck(this);
                    }
                }
                object = object5;
            } else {
                object2 = (ReferenceBinding)referenceBinding.original();
                if (bl2 && ((ClassScope)scope).detectHierarchyCycle((TypeBinding)object2, this)) {
                    return null;
                }
                if (((TypeBinding)object2).isGenericType()) {
                    if (bl3 && object != null && ((TypeBinding)object).isParameterizedType()) {
                        scope.problemReporter().parameterizedMemberTypeMissingArguments(this, scope.environment().createParameterizedType((ReferenceBinding)object2, null, (ReferenceBinding)object), n);
                        bl3 = false;
                    }
                    object = scope.environment().createRawType((ReferenceBinding)object2, (ReferenceBinding)object);
                } else {
                    Object object6 = object = object != null && ((TypeBinding)object).isParameterizedType() ? scope.environment().createParameterizedType((ReferenceBinding)object2, null, (ReferenceBinding)object) : referenceBinding;
                }
            }
            if (this.isTypeUseDeprecated((TypeBinding)object, scope)) {
                this.reportDeprecatedType((TypeBinding)object, scope, n);
            }
            this.resolvedType = object;
            this.recordResolution(scope.environment(), this.resolvedType);
            ++n;
        }
        return this.resolvedType;
    }

    private void createArrayType(Scope scope) {
        if (this.dimensions > 0) {
            if (this.dimensions > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = scope.createArrayType(this.resolvedType, this.dimensions);
        }
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        int n3;
        TypeReference[] typeReferenceArray;
        int n4 = this.tokens.length;
        int n5 = 0;
        while (n5 < n4 - 1) {
            if (this.annotations != null && this.annotations[n5] != null) {
                ParameterizedQualifiedTypeReference.printAnnotations(this.annotations[n5], stringBuffer);
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.tokens[n5]);
            typeReferenceArray = this.typeArguments[n5];
            if (typeReferenceArray != null) {
                stringBuffer.append('<');
                n3 = typeReferenceArray.length;
                if (n3 > 0) {
                    n2 = n3 - 1;
                    int n6 = 0;
                    while (n6 < n2) {
                        typeReferenceArray[n6].print(0, stringBuffer);
                        stringBuffer.append(", ");
                        ++n6;
                    }
                    typeReferenceArray[n2].print(0, stringBuffer);
                }
                stringBuffer.append('>');
            }
            stringBuffer.append('.');
            ++n5;
        }
        if (this.annotations != null && this.annotations[n4 - 1] != null) {
            stringBuffer.append(" ");
            ParameterizedQualifiedTypeReference.printAnnotations(this.annotations[n4 - 1], stringBuffer);
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.tokens[n4 - 1]);
        TypeReference[] typeReferenceArray2 = this.typeArguments[n4 - 1];
        if (typeReferenceArray2 != null) {
            stringBuffer.append('<');
            int n7 = typeReferenceArray2.length;
            if (n7 > 0) {
                n3 = n7 - 1;
                n2 = 0;
                while (n2 < n3) {
                    typeReferenceArray2[n2].print(0, stringBuffer);
                    stringBuffer.append(", ");
                    ++n2;
                }
                typeReferenceArray2[n3].print(0, stringBuffer);
            }
            stringBuffer.append('>');
        }
        typeReferenceArray = this.getAnnotationsOnDimensions();
        if ((this.bits & 0x4000) != 0) {
            n3 = 0;
            while (n3 < this.dimensions - 1) {
                if (typeReferenceArray != null && typeReferenceArray[n3] != null) {
                    stringBuffer.append(" ");
                    ParameterizedQualifiedTypeReference.printAnnotations((Annotation[])typeReferenceArray[n3], stringBuffer);
                    stringBuffer.append(" ");
                }
                stringBuffer.append("[]");
                ++n3;
            }
            if (typeReferenceArray != null && typeReferenceArray[this.dimensions - 1] != null) {
                stringBuffer.append(" ");
                ParameterizedQualifiedTypeReference.printAnnotations((Annotation[])typeReferenceArray[this.dimensions - 1], stringBuffer);
                stringBuffer.append(" ");
            }
            stringBuffer.append("...");
        } else {
            n3 = 0;
            while (n3 < this.dimensions) {
                if (typeReferenceArray != null && typeReferenceArray[n3] != null) {
                    stringBuffer.append(" ");
                    ParameterizedQualifiedTypeReference.printAnnotations((Annotation[])typeReferenceArray[n3], stringBuffer);
                    stringBuffer.append(" ");
                }
                stringBuffer.append("[]");
                ++n3;
            }
        }
        return stringBuffer;
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl, int n) {
        return this.internalResolveType(blockScope, bl, n);
    }

    public TypeBinding resolveType(ClassScope classScope, int n) {
        return this.internalResolveType(classScope, false, n);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            Annotation[][] annotationArray;
            int n2;
            int n3;
            if (this.annotations != null) {
                int n4 = this.annotations.length;
                n3 = 0;
                while (n3 < n4) {
                    n2 = this.annotations[n3] == null ? 0 : this.annotations[n3].length;
                    int n5 = 0;
                    while (n5 < n2) {
                        this.annotations[n3][n5].traverse(aSTVisitor, blockScope);
                        ++n5;
                    }
                    ++n3;
                }
            }
            if ((annotationArray = this.getAnnotationsOnDimensions(true)) != null) {
                n3 = 0;
                n2 = annotationArray.length;
                while (n3 < n2) {
                    Annotation[] annotationArray2 = annotationArray[n3];
                    n = 0;
                    int n6 = annotationArray2 == null ? 0 : annotationArray2.length;
                    while (n < n6) {
                        Annotation annotation = annotationArray2[n];
                        annotation.traverse(aSTVisitor, blockScope);
                        ++n;
                    }
                    ++n3;
                }
            }
            n3 = 0;
            n2 = this.typeArguments.length;
            while (n3 < n2) {
                if (this.typeArguments[n3] != null) {
                    int n7 = 0;
                    n = this.typeArguments[n3].length;
                    while (n7 < n) {
                        this.typeArguments[n3][n7].traverse(aSTVisitor, blockScope);
                        ++n7;
                    }
                }
                ++n3;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            Annotation[][] annotationArray;
            int n2;
            int n3;
            if (this.annotations != null) {
                int n4 = this.annotations.length;
                n3 = 0;
                while (n3 < n4) {
                    n2 = this.annotations[n3] == null ? 0 : this.annotations[n3].length;
                    int n5 = 0;
                    while (n5 < n2) {
                        this.annotations[n3][n5].traverse(aSTVisitor, classScope);
                        ++n5;
                    }
                    ++n3;
                }
            }
            if ((annotationArray = this.getAnnotationsOnDimensions(true)) != null) {
                n3 = 0;
                n2 = annotationArray.length;
                while (n3 < n2) {
                    Annotation[] annotationArray2 = annotationArray[n3];
                    n = 0;
                    int n6 = annotationArray2 == null ? 0 : annotationArray2.length;
                    while (n < n6) {
                        Annotation annotation = annotationArray2[n];
                        annotation.traverse(aSTVisitor, classScope);
                        ++n;
                    }
                    ++n3;
                }
            }
            n3 = 0;
            n2 = this.typeArguments.length;
            while (n3 < n2) {
                if (this.typeArguments[n3] != null) {
                    int n7 = 0;
                    n = this.typeArguments[n3].length;
                    while (n7 < n) {
                        this.typeArguments[n3][n7].traverse(aSTVisitor, classScope);
                        ++n7;
                    }
                }
                ++n3;
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

