/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JavadocAllocationExpression
extends AllocationExpression {
    public int tagSourceStart;
    public int tagSourceEnd;
    public int tagValue;
    public int memberStart;
    public char[][] qualification;

    public JavadocAllocationExpression(int n, int n2) {
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.bits |= 0x8000;
    }

    public JavadocAllocationExpression(long l) {
        this((int)(l >>> 32), (int)l);
    }

    TypeBinding internalResolveType(Scope scope) {
        int n;
        Object object;
        this.constant = Constant.NotAConstant;
        this.resolvedType = this.type == null ? scope.enclosingSourceType() : (scope.kind == 3 ? this.type.resolveType((ClassScope)scope) : this.type.resolveType((BlockScope)scope, true));
        TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
        boolean bl = false;
        if (this.arguments != null) {
            boolean bl2 = false;
            int n2 = this.arguments.length;
            typeBindingArray = new TypeBinding[n2];
            int n3 = 0;
            while (n3 < n2) {
                object = this.arguments[n3];
                typeBindingArray[n3] = scope.kind == 3 ? ((Expression)object).resolveType((ClassScope)scope) : ((Expression)object).resolveType((BlockScope)scope);
                if (typeBindingArray[n3] == null) {
                    bl2 = true;
                } else if (!bl) {
                    bl = typeBindingArray[n3].isTypeVariable();
                }
                ++n3;
            }
            if (bl2) {
                return null;
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        this.resolvedType = scope.environment().convertToRawType(this.type.resolvedType, true);
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding != null && sourceTypeBinding.isCompatibleWith(this.resolvedType)) {
            this.bits |= 0x4000;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
        this.binding = scope.getConstructor(referenceBinding, typeBindingArray, this);
        if (!this.binding.isValidBinding()) {
            ReferenceBinding referenceBinding2 = referenceBinding;
            object = this.binding;
            while (!((Binding)object).isValidBinding() && (referenceBinding2.isMemberType() || referenceBinding2.isLocalType())) {
                referenceBinding2 = referenceBinding2.enclosingType();
                object = scope.getConstructor(referenceBinding2, typeBindingArray, this);
            }
            if (((Binding)object).isValidBinding()) {
                this.binding = object;
            }
        }
        if (!this.binding.isValidBinding()) {
            MethodBinding methodBinding = scope.getMethod(this.resolvedType, this.resolvedType.sourceName(), typeBindingArray, this);
            if (methodBinding.isValidBinding()) {
                this.binding = methodBinding;
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = referenceBinding;
                }
                scope.problemReporter().javadocInvalidConstructor(this, this.binding, scope.getDeclarationModifiers());
            }
            return this.resolvedType;
        }
        if (this.binding.isVarargs()) {
            int n4 = typeBindingArray.length;
            if (this.binding.parameters.length != n4 || !typeBindingArray[n4 - 1].isArrayType()) {
                object = new ProblemMethodBinding(this.binding, this.binding.selector, typeBindingArray, 1);
                scope.problemReporter().javadocInvalidConstructor(this, (MethodBinding)object, scope.getDeclarationModifiers());
            }
        } else if (bl) {
            ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(this.binding, this.binding.selector, typeBindingArray, 1);
            scope.problemReporter().javadocInvalidConstructor(this, problemMethodBinding, scope.getDeclarationModifiers());
        } else if (this.binding instanceof ParameterizedMethodBinding) {
            ParameterizedMethodBinding parameterizedMethodBinding = (ParameterizedMethodBinding)this.binding;
            if (parameterizedMethodBinding.hasSubstitutedParameters()) {
                int n5 = typeBindingArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    if (TypeBinding.notEquals(parameterizedMethodBinding.parameters[n6], typeBindingArray[n6]) && TypeBinding.notEquals(parameterizedMethodBinding.parameters[n6].erasure(), typeBindingArray[n6].erasure())) {
                        ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(this.binding, this.binding.selector, typeBindingArray, 1);
                        scope.problemReporter().javadocInvalidConstructor(this, problemMethodBinding, scope.getDeclarationModifiers());
                        break;
                    }
                    ++n6;
                }
            }
        } else if (this.resolvedType.isMemberType() && (n = this.qualification.length) > 1) {
            object = referenceBinding;
            if (this.type instanceof JavadocQualifiedTypeReference && ((JavadocQualifiedTypeReference)this.type).tokens.length != n) {
                scope.problemReporter().javadocInvalidMemberTypeQualification(this.memberStart + 1, this.sourceEnd, scope.getDeclarationModifiers());
            } else {
                int n7 = n;
                while (n7 > 0 && CharOperation.equals(this.qualification[--n7], ((ReferenceBinding)object).sourceName) && (object = ((TypeBinding)object).enclosingType()) != null) {
                }
                if (n7 > 0 || object != null) {
                    scope.problemReporter().javadocInvalidMemberTypeQualification(this.memberStart + 1, this.sourceEnd, scope.getDeclarationModifiers());
                }
            }
        }
        if (this.isMethodUseDeprecated(this.binding, scope, true)) {
            scope.problemReporter().javadocDeprecatedMethod(this.binding, this, scope.getDeclarationModifiers());
        }
        return referenceBinding;
    }

    public boolean isSuperAccess() {
        return (this.bits & 0x4000) != 0;
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        return this.internalResolveType(blockScope);
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.typeArguments != null) {
                n2 = 0;
                n = this.typeArguments.length;
                while (n2 < n) {
                    this.typeArguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.arguments != null) {
                n2 = 0;
                n = this.arguments.length;
                while (n2 < n) {
                    this.arguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            int n2;
            if (this.typeArguments != null) {
                n2 = 0;
                n = this.typeArguments.length;
                while (n2 < n) {
                    this.typeArguments[n2].traverse(aSTVisitor, classScope);
                    ++n2;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, classScope);
            }
            if (this.arguments != null) {
                n2 = 0;
                n = this.arguments.length;
                while (n2 < n) {
                    this.arguments[n2].traverse(aSTVisitor, classScope);
                    ++n2;
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

