/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class Initializer
extends FieldDeclaration {
    public Block block;
    public int lastVisibleFieldID;
    public int bodyStart;
    public int bodyEnd;

    public Initializer(Block block, int n) {
        this.block = block;
        this.modifiers = n;
        if (block != null) {
            this.declarationSourceStart = this.sourceStart = block.sourceStart;
        }
    }

    public FlowInfo analyseCode(MethodScope methodScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.block != null) {
            return this.block.analyseCode(methodScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        if (this.block != null) {
            this.block.generateCode(blockScope, codeStream);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public int getKind() {
        return 2;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public void parseStatements(Parser parser, TypeDeclaration typeDeclaration, CompilationUnitDeclaration compilationUnitDeclaration) {
        parser.parse(this, typeDeclaration, compilationUnitDeclaration);
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        if (this.modifiers != 0) {
            Initializer.printIndent(n, stringBuffer);
            Initializer.printModifiers(this.modifiers, stringBuffer);
            if (this.annotations != null) {
                Initializer.printAnnotations(this.annotations, stringBuffer);
                stringBuffer.append(' ');
            }
            stringBuffer.append("{\n");
            if (this.block != null) {
                this.block.printBody(n, stringBuffer);
            }
            Initializer.printIndent(n, stringBuffer).append('}');
            return stringBuffer;
        }
        if (this.block != null) {
            this.block.printStatement(n, stringBuffer);
        } else {
            Initializer.printIndent(n, stringBuffer).append("{}");
        }
        return stringBuffer;
    }

    public void resolve(MethodScope methodScope) {
        FieldBinding fieldBinding = methodScope.initializedField;
        int n = methodScope.lastVisibleFieldID;
        try {
            SourceTypeBinding sourceTypeBinding;
            methodScope.initializedField = null;
            methodScope.lastVisibleFieldID = this.lastVisibleFieldID;
            if (this.isStatic() && (sourceTypeBinding = methodScope.enclosingSourceType()).isNestedType() && !sourceTypeBinding.isStatic()) {
                methodScope.problemReporter().innerTypesCannotDeclareStaticInitializers(sourceTypeBinding, this);
            }
            if (this.block != null) {
                this.block.resolve(methodScope);
            }
        }
        finally {
            methodScope.initializedField = fieldBinding;
            methodScope.lastVisibleFieldID = n;
        }
    }

    public void traverse(ASTVisitor aSTVisitor, MethodScope methodScope) {
        if (aSTVisitor.visit(this, methodScope) && this.block != null) {
            this.block.traverse(aSTVisitor, methodScope);
        }
        aSTVisitor.endVisit(this, methodScope);
    }
}

