/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayTypeReference
extends SingleTypeReference {
    public int dimensions;
    private Annotation[][] annotationsOnDimensions;
    public int originalSourceEnd;
    public int extendedDimensions;

    public ArrayTypeReference(char[] cArray, int n, long l) {
        super(cArray, l);
        this.originalSourceEnd = this.sourceEnd;
        this.dimensions = n;
        this.annotationsOnDimensions = null;
    }

    public ArrayTypeReference(char[] cArray, int n, Annotation[][] annotationArray, long l) {
        this(cArray, n, l);
        if (annotationArray != null) {
            this.bits |= 0x100000;
        }
        this.annotationsOnDimensions = annotationArray;
    }

    public int dimensions() {
        return this.dimensions;
    }

    public int extraDimensions() {
        return this.extendedDimensions;
    }

    public Annotation[][] getAnnotationsOnDimensions(boolean bl) {
        if (bl || this.annotationsOnDimensions == null || this.annotationsOnDimensions.length == 0 || this.extendedDimensions == 0 || this.extendedDimensions == this.dimensions) {
            return this.annotationsOnDimensions;
        }
        Annotation[][] annotationArray = new Annotation[this.dimensions][];
        int n = this.dimensions - this.extendedDimensions;
        System.arraycopy(this.annotationsOnDimensions, n, annotationArray, 0, this.extendedDimensions);
        System.arraycopy(this.annotationsOnDimensions, 0, annotationArray, this.extendedDimensions, n);
        return annotationArray;
    }

    public void setAnnotationsOnDimensions(Annotation[][] annotationArray) {
        this.annotationsOnDimensions = annotationArray;
    }

    public char[][] getParameterizedTypeName() {
        int n = this.dimensions;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 * 2;
            cArray[n3] = 91;
            cArray[n3 + 1] = 93;
            ++n2;
        }
        return new char[][]{CharOperation.concat(this.token, cArray)};
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        if (this.dimensions > 255) {
            scope.problemReporter().tooManyDimensions(this);
        }
        TypeBinding typeBinding = scope.getType(this.token);
        return scope.createArrayType(typeBinding, this.dimensions);
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        super.printExpression(n, stringBuffer);
        if ((this.bits & 0x4000) != 0) {
            int n2 = 0;
            while (n2 < this.dimensions - 1) {
                if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[n2] != null) {
                    stringBuffer.append(' ');
                    ArrayTypeReference.printAnnotations(this.annotationsOnDimensions[n2], stringBuffer);
                    stringBuffer.append(' ');
                }
                stringBuffer.append("[]");
                ++n2;
            }
            if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[this.dimensions - 1] != null) {
                stringBuffer.append(' ');
                ArrayTypeReference.printAnnotations(this.annotationsOnDimensions[this.dimensions - 1], stringBuffer);
                stringBuffer.append(' ');
            }
            stringBuffer.append("...");
        } else {
            int n3 = 0;
            while (n3 < this.dimensions) {
                if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[n3] != null) {
                    stringBuffer.append(" ");
                    ArrayTypeReference.printAnnotations(this.annotationsOnDimensions[n3], stringBuffer);
                    stringBuffer.append(" ");
                }
                stringBuffer.append("[]");
                ++n3;
            }
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            if (this.annotations != null) {
                Annotation[] annotationArray = this.annotations[0];
                n = 0;
                int n2 = annotationArray == null ? 0 : annotationArray.length;
                while (n < n2) {
                    annotationArray[n].traverse(aSTVisitor, blockScope);
                    ++n;
                }
            }
            if (this.annotationsOnDimensions != null) {
                int n3 = 0;
                n = this.annotationsOnDimensions.length;
                while (n3 < n) {
                    Annotation[] annotationArray = this.annotationsOnDimensions[n3];
                    if (annotationArray != null) {
                        int n4 = 0;
                        int n5 = annotationArray.length;
                        while (n4 < n5) {
                            Annotation annotation = annotationArray[n4];
                            annotation.traverse(aSTVisitor, blockScope);
                            ++n4;
                        }
                    }
                    ++n3;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            if (this.annotations != null) {
                Annotation[] annotationArray = this.annotations[0];
                n = 0;
                int n2 = annotationArray == null ? 0 : annotationArray.length;
                while (n < n2) {
                    annotationArray[n].traverse(aSTVisitor, classScope);
                    ++n;
                }
            }
            if (this.annotationsOnDimensions != null) {
                int n3 = 0;
                n = this.annotationsOnDimensions.length;
                while (n3 < n) {
                    Annotation[] annotationArray = this.annotationsOnDimensions[n3];
                    if (annotationArray != null) {
                        int n4 = 0;
                        int n5 = annotationArray.length;
                        while (n4 < n5) {
                            Annotation annotation = annotationArray[n4];
                            annotation.traverse(aSTVisitor, classScope);
                            ++n4;
                        }
                    }
                    ++n3;
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }

    protected TypeBinding internalResolveType(Scope scope, int n) {
        TypeBinding typeBinding = super.internalResolveType(scope, n);
        return typeBinding;
    }
}

