/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CatchParameterBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class Argument
extends LocalDeclaration {
    private static final char[] SET = "set".toCharArray();

    public Argument(char[] cArray, long l, TypeReference typeReference, int n) {
        super(cArray, (int)(l >>> 32), (int)l);
        this.declarationSourceEnd = (int)l;
        this.modifiers = n;
        this.type = typeReference;
        if (typeReference != null) {
            this.bits |= typeReference.bits & 0x100000;
        }
        this.bits |= 0x40000004;
    }

    public Argument(char[] cArray, long l, TypeReference typeReference, int n, boolean bl) {
        super(cArray, (int)(l >>> 32), (int)l);
        this.declarationSourceEnd = (int)l;
        this.modifiers = n;
        this.type = typeReference;
        if (typeReference != null) {
            this.bits |= typeReference.bits & 0x100000;
        }
        this.bits |= 0x40000006;
    }

    public TypeBinding createBinding(MethodScope methodScope, TypeBinding typeBinding) {
        MethodBinding methodBinding;
        AbstractMethodDeclaration abstractMethodDeclaration;
        if (this.binding == null) {
            this.binding = new LocalVariableBinding((LocalDeclaration)this, typeBinding, this.modifiers, methodScope);
        } else if (!this.binding.type.isValidBinding() && (abstractMethodDeclaration = methodScope.referenceMethod()) != null && (methodBinding = abstractMethodDeclaration.binding) != null) {
            methodBinding.tagBits |= 0x200L;
        }
        if ((this.binding.tagBits & 0x200000000L) == 0L) {
            Argument.resolveAnnotations(methodScope, this.annotations, this.binding, true);
            if (methodScope.compilerOptions().sourceLevel >= 0x340000L) {
                Annotation.isTypeUseCompatible(this.type, methodScope, this.annotations);
                methodScope.validateNullAnnotation(this.binding.tagBits, this.type, this.annotations);
            }
        }
        this.binding.declaration = this;
        return this.binding.type;
    }

    public TypeBinding bind(MethodScope methodScope, TypeBinding typeBinding, boolean bl) {
        TypeBinding typeBinding2 = this.createBinding(methodScope, typeBinding);
        Binding binding = methodScope.getBinding(this.name, 3, (InvocationSite)this, false);
        if (binding != null && binding.isValidBinding()) {
            boolean bl2 = binding instanceof LocalVariableBinding;
            if (bl2 && (this.bits & 0x200000) != 0 && methodScope.isLambdaSubscope()) {
                methodScope.problemReporter().lambdaRedeclaresArgument(this);
            } else if (bl2 && this.hiddenVariableDepth == 0) {
                methodScope.problemReporter().redefineArgument(this);
            } else {
                boolean bl3 = false;
                if (binding instanceof FieldBinding) {
                    if (methodScope.isInsideConstructor()) {
                        bl3 = true;
                    } else {
                        AbstractMethodDeclaration abstractMethodDeclaration = methodScope.referenceMethod();
                        if (abstractMethodDeclaration != null && CharOperation.prefixEquals(SET, abstractMethodDeclaration.selector)) {
                            bl3 = true;
                        }
                    }
                }
                methodScope.problemReporter().localVariableHiding(this, binding, bl3);
            }
        }
        methodScope.addLocalVariable(this.binding);
        this.binding.useFlag = bl ? 1 : 0;
        return typeBinding2;
    }

    public int getKind() {
        return (this.bits & 4) != 0 ? 5 : 4;
    }

    public boolean isArgument() {
        return true;
    }

    public boolean isVarArgs() {
        return this.type != null && (this.type.bits & 0x4000) != 0;
    }

    public boolean hasElidedType() {
        return (this.bits & 2) != 0;
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        Argument.printIndent(n, stringBuffer);
        Argument.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            Argument.printAnnotations(this.annotations, stringBuffer);
            stringBuffer.append(' ');
        }
        if (this.type == null) {
            stringBuffer.append("<no type> ");
        } else {
            this.type.print(0, stringBuffer).append(' ');
        }
        return stringBuffer.append(this.name);
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer).append(';');
    }

    public TypeBinding resolveForCatch(BlockScope blockScope) {
        boolean bl;
        TypeBinding typeBinding = this.type.resolveType(blockScope, true);
        if (typeBinding == null) {
            bl = true;
        } else {
            bl = false;
            switch (typeBinding.kind()) {
                case 260: {
                    if (!typeBinding.isBoundParameterizedType()) break;
                    bl = true;
                    blockScope.problemReporter().invalidParameterizedExceptionType(typeBinding, this);
                    break;
                }
                case 4100: {
                    blockScope.problemReporter().invalidTypeVariableAsException(typeBinding, this);
                    bl = true;
                }
            }
            if (typeBinding.findSuperTypeOriginatingFrom(21, true) == null && typeBinding.isValidBinding()) {
                blockScope.problemReporter().cannotThrowType(this.type, typeBinding);
                bl = true;
            }
        }
        Binding binding = blockScope.getBinding(this.name, 3, (InvocationSite)this, false);
        if (binding != null && binding.isValidBinding()) {
            if (binding instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                blockScope.problemReporter().redefineArgument(this);
            } else {
                blockScope.problemReporter().localVariableHiding(this, binding, false);
            }
        }
        if ((this.type.bits & 0x20000000) != 0) {
            this.binding = new CatchParameterBinding((LocalDeclaration)this, typeBinding, this.modifiers | 0x10, false);
            this.binding.tagBits |= 0x1000L;
        } else {
            this.binding = new CatchParameterBinding((LocalDeclaration)this, typeBinding, this.modifiers, false);
        }
        Argument.resolveAnnotations(blockScope, this.annotations, this.binding, true);
        Annotation.isTypeUseCompatible(this.type, blockScope, this.annotations);
        if (this.type.resolvedType != null && this.type.resolvedType.hasNullTypeAnnotations()) {
            blockScope.problemReporter().nullAnnotationUnsupportedLocation(this.type);
        }
        blockScope.addLocalVariable(this.binding);
        this.binding.setConstant(Constant.NotAConstant);
        if (bl) {
            return null;
        }
        return typeBinding;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    this.annotations[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    this.annotations[n2].traverse(aSTVisitor, classScope);
                    ++n2;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, classScope);
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

