/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.InnerInferenceHelper;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ImplicitNullAnnotationVerifier;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticFactoryMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;

public class AllocationExpression
extends Expression
implements Invocation {
    public TypeReference type;
    public Expression[] arguments;
    public MethodBinding binding;
    MethodBinding syntheticAccessor;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public FieldDeclaration enumConstant;
    protected TypeBinding typeExpected;
    public boolean inferredReturnType;
    public FakedTrackingVariable closeTracker;
    private ExpressionContext expressionContext = ExpressionContext.VANILLA_CONTEXT;
    private SimpleLookupTable inferenceContexts;
    protected InnerInferenceHelper innerInferenceHelper;
    ResolutionState suspendedResolutionState;

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.checkCapturedLocalInitializationIfNecessary((ReferenceBinding)this.binding.declaringClass.erasure(), blockScope, flowInfo);
        if (this.arguments != null) {
            boolean bl = blockScope.compilerOptions().analyseResourceLeaks;
            boolean bl2 = bl && this.resolvedType instanceof ReferenceBinding && ((ReferenceBinding)this.resolvedType).hasTypeBit(4);
            int n = 0;
            int n2 = this.arguments.length;
            while (n < n2) {
                flowInfo = this.arguments[n].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                if (bl && !bl2) {
                    flowInfo = FakedTrackingVariable.markPassedToOutside(blockScope, this.arguments[n], flowInfo, flowContext, false);
                }
                this.arguments[n].checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
                ++n;
            }
            this.analyseArguments(blockScope, flowContext, flowInfo, this.binding, this.arguments);
        }
        TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
                typeBindingArray = blockScope.environment().convertToRawTypes(this.binding.thrownExceptions, true, true);
            }
            flowContext.checkExceptionHandlers(typeBindingArray, (ASTNode)this, (FlowInfo)flowInfo.unconditionalCopy(), blockScope);
        }
        if (blockScope.compilerOptions().analyseResourceLeaks && FakedTrackingVariable.isAnyCloseable(this.resolvedType)) {
            FakedTrackingVariable.analyseCloseableAllocation(blockScope, flowInfo, this);
        }
        if (this.binding.declaringClass.isMemberType() && !this.binding.declaringClass.isStatic()) {
            blockScope.tagAsAccessingEnclosingInstanceStateOf(this.binding.declaringClass.enclosingType(), false);
        }
        this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        flowContext.recordAbruptExit();
        return flowInfo;
    }

    public void checkCapturedLocalInitializationIfNecessary(ReferenceBinding referenceBinding, BlockScope blockScope, FlowInfo flowInfo) {
        NestedTypeBinding nestedTypeBinding;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray;
        if ((referenceBinding.tagBits & 0x834L) == 2068L && !blockScope.isDefinedInType(referenceBinding) && (syntheticArgumentBindingArray = (nestedTypeBinding = (NestedTypeBinding)referenceBinding).syntheticOuterLocalVariables()) != null) {
            int n = 0;
            int n2 = syntheticArgumentBindingArray.length;
            while (n < n2) {
                SyntheticArgumentBinding syntheticArgumentBinding = syntheticArgumentBindingArray[n];
                LocalVariableBinding localVariableBinding = syntheticArgumentBinding.actualOuterLocalVariable;
                if (localVariableBinding != null && localVariableBinding.declaration != null && !flowInfo.isDefinitelyAssigned(localVariableBinding)) {
                    blockScope.problemReporter().uninitializedLocalVariable(localVariableBinding, this);
                }
                ++n;
            }
        }
    }

    public Expression enclosingInstance() {
        return null;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        boolean bl2;
        if (!bl) {
            blockScope.problemReporter().unusedObjectAllocation(this);
        }
        int n = codeStream.position;
        MethodBinding methodBinding = this.binding.original();
        ReferenceBinding referenceBinding = methodBinding.declaringClass;
        codeStream.new_(this.type, referenceBinding);
        boolean bl3 = bl2 = (this.implicitConversion & 0x400) != 0;
        if (bl || bl2) {
            codeStream.dup();
        }
        if (this.type != null) {
            codeStream.recordPositionsFrom(n, this.type.sourceStart);
        } else {
            codeStream.ldc(String.valueOf(this.enumConstant.name));
            codeStream.generateInlinedValue(this.enumConstant.binding.id);
        }
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticEnclosingInstanceValues(blockScope, referenceBinding, this.enclosingInstance(), this);
        }
        this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticOuterArgumentValues(blockScope, referenceBinding, this);
        }
        if (this.syntheticAccessor == null) {
            codeStream.invoke((byte)-73, methodBinding, null, this.typeArguments);
        } else {
            int n2 = 0;
            int n3 = this.syntheticAccessor.parameters.length - methodBinding.parameters.length;
            while (n2 < n3) {
                codeStream.aconst_null();
                ++n2;
            }
            codeStream.invoke((byte)-73, this.syntheticAccessor, null, this.typeArguments);
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else if (bl2) {
            codeStream.generateImplicitConversion(this.implicitConversion);
            switch (this.postConversionType((Scope)blockScope).id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isSuperAccess() {
        return false;
    }

    public boolean isTypeAccess() {
        return true;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding.declaringClass.erasure();
        if (referenceBinding.isNestedType() && (blockScope.enclosingSourceType().isLocalType() || blockScope.isLambdaScope())) {
            if (referenceBinding.isLocalType()) {
                ((LocalTypeBinding)referenceBinding).addInnerEmulationDependent(blockScope, false);
            } else {
                blockScope.propagateInnerEmulation(referenceBinding, false);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        MethodBinding methodBinding = this.binding.original();
        if (methodBinding.isPrivate()) {
            ReferenceBinding referenceBinding = methodBinding.declaringClass;
            if (TypeBinding.notEquals(blockScope.enclosingSourceType(), referenceBinding)) {
                if ((referenceBinding.tagBits & 0x10L) != 0L && blockScope.compilerOptions().complianceLevel >= 0x300000L) {
                    methodBinding.tagBits |= 0x200L;
                } else {
                    this.syntheticAccessor = ((SourceTypeBinding)referenceBinding).addSyntheticMethod(methodBinding, this.isSuperAccess());
                    blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
                }
            }
        }
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        if (this.type != null) {
            stringBuffer.append("new ");
        }
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n2 = this.typeArguments.length - 1;
            int n3 = 0;
            while (n3 < n2) {
                this.typeArguments[n3].print(0, stringBuffer);
                stringBuffer.append(", ");
                ++n3;
            }
            this.typeArguments[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        if (this.type != null) {
            this.type.printExpression(0, stringBuffer);
        }
        stringBuffer.append('(');
        if (this.arguments != null) {
            n2 = 0;
            while (n2 < this.arguments.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].printExpression(0, stringBuffer);
                ++n2;
            }
        }
        return stringBuffer.append(')');
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        int n;
        Object object;
        boolean bl = this.type != null && (this.type.bits & 0x80000) != 0;
        CompilerOptions compilerOptions = blockScope.compilerOptions();
        boolean bl2 = false;
        long l = compilerOptions.sourceLevel;
        if (this.constant != Constant.NotAConstant) {
            this.constant = Constant.NotAConstant;
            if (this.type == null) {
                this.resolvedType = blockScope.enclosingReceiverType();
            } else {
                this.resolvedType = this.type.resolveType(blockScope, true);
                if (bl && this.typeExpected == null && this.expressionContext == ExpressionContext.INVOCATION_CONTEXT && l >= 0x340000L && this.resolvedType != null && this.resolvedType.isValidBinding()) {
                    bl2 = true;
                }
            }
        } else {
            this.resolvedType = this.type.resolvedType;
        }
        if (this.type != null) {
            this.checkIllegalNullAnnotation(blockScope, this.resolvedType);
            if (this.type instanceof ParameterizedQualifiedTypeReference) {
                ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
                if (referenceBinding == null) {
                    return referenceBinding;
                }
                block0: while ((referenceBinding.modifiers & 8) == 0 && !referenceBinding.isRawType()) {
                    if ((referenceBinding = referenceBinding.enclosingType()) != null) continue;
                    object = (ParameterizedQualifiedTypeReference)this.type;
                    n = object.typeArguments.length - 2;
                    while (n >= 0) {
                        if (object.typeArguments[n] != null) {
                            blockScope.problemReporter().illegalQualifiedParameterizedTypeAllocation(this.type, this.resolvedType);
                            break block0;
                        }
                        --n;
                    }
                    break block0;
                }
            }
        }
        if (this.typeArguments != null) {
            int n2 = this.typeArguments.length;
            boolean bl3 = l < 0x310000L;
            this.genericTypeArguments = new TypeBinding[n2];
            n = 0;
            while (n < n2) {
                TypeReference typeReference = this.typeArguments[n];
                this.genericTypeArguments[n] = typeReference.resolveType(blockScope, true);
                if (this.genericTypeArguments[n] == null) {
                    bl3 = true;
                }
                if (bl3 && typeReference instanceof Wildcard) {
                    blockScope.problemReporter().illegalUsageOfWildcard(typeReference);
                }
                ++n;
            }
            if (bl) {
                blockScope.problemReporter().diamondNotWithExplicitTypeArguments(this.typeArguments);
                return null;
            }
            if (bl3) {
                if (this.arguments != null) {
                    n = 0;
                    int n3 = this.arguments.length;
                    while (n < n3) {
                        this.arguments[n].resolveType(blockScope);
                        ++n;
                    }
                }
                return null;
            }
        }
        boolean bl4 = false;
        object = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            n = 0;
            int n4 = this.arguments.length;
            object = new TypeBinding[n4];
            int n5 = 0;
            while (n5 < n4) {
                Expression expression = this.arguments[n5];
                if (expression instanceof CastExpression) {
                    expression.bits |= 0x20;
                    bl4 = true;
                }
                expression.setExpressionContext(ExpressionContext.INVOCATION_CONTEXT);
                if (this.arguments[n5].resolvedType != null) {
                    blockScope.problemReporter().genericInferenceError("Argument was unexpectedly found resolved", this);
                }
                if ((object[n5] = expression.resolveType(blockScope)) == null) {
                    n = 1;
                }
                if (l >= 0x340000L && expression.isPolyExpression() && this.innerInferenceHelper == null) {
                    this.innerInferenceHelper = new InnerInferenceHelper();
                }
                ++n5;
            }
            if (n != 0) {
                if (bl) {
                    return null;
                }
                if (this.resolvedType instanceof ReferenceBinding) {
                    MethodBinding methodBinding;
                    TypeBinding[] typeBindingArray = new TypeBinding[n4];
                    int n6 = n4;
                    while (--n6 >= 0) {
                        TypeBinding typeBinding = typeBindingArray[n6] = object[n6] == null ? TypeBinding.NULL : object[n6];
                    }
                    this.binding = blockScope.findMethod((ReferenceBinding)this.resolvedType, TypeConstants.INIT, typeBindingArray, this, false);
                    if (this.binding != null && !this.binding.isValidBinding() && (methodBinding = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                        if (methodBinding.original().typeVariables != Binding.NO_TYPE_VARIABLES) {
                            methodBinding = blockScope.environment().createParameterizedGenericMethod(methodBinding.original(), (RawTypeBinding)null);
                        }
                        this.binding = methodBinding;
                        MethodBinding methodBinding2 = methodBinding.original();
                        if (methodBinding2.isOrEnclosedByPrivateType() && !blockScope.isDefinedInMethod(methodBinding2)) {
                            methodBinding2.modifiers |= 0x8000000;
                        }
                    }
                }
                return this.resolvedType;
            }
        }
        if (this.resolvedType == null || !this.resolvedType.isValidBinding()) {
            return null;
        }
        if (this.type != null && !this.resolvedType.canBeInstantiated()) {
            blockScope.problemReporter().cannotInstantiate(this.type, this.resolvedType);
            return this.resolvedType;
        }
        ResolutionState resolutionState = new ResolutionState(blockScope, bl, bl2, bl4, (TypeBinding[])object);
        if (bl2) {
            this.suspendedResolutionState = resolutionState;
            return new PolyTypeBinding(this);
        }
        if (!this.resolvePart2(resolutionState)) {
            return null;
        }
        return this.resolvePart3(resolutionState);
    }

    boolean resolvePart2(ResolutionState resolutionState) {
        ReferenceBinding referenceBinding;
        if (resolutionState.isDiamond) {
            referenceBinding = ((ParameterizedTypeBinding)this.resolvedType).genericType();
            TypeBinding[] typeBindingArray = this.inferElidedTypes((ParameterizedTypeBinding)this.resolvedType, this.resolvedType.enclosingType(), resolutionState.argumentTypes, resolutionState.scope);
            if (typeBindingArray == null) {
                if (!resolutionState.diamondNeedsDeferring) {
                    resolutionState.scope.problemReporter().cannotInferElidedTypes(this);
                    resolutionState.hasReportedError = true;
                    this.resolvedType = null;
                } else {
                    resolutionState.cannotInferDiamond = true;
                }
                return false;
            }
            this.resolvedType = this.type.resolvedType = resolutionState.scope.environment().createParameterizedType(referenceBinding, typeBindingArray, ((ParameterizedTypeBinding)this.resolvedType).enclosingType());
            resolutionState.cannotInferDiamond = false;
        }
        referenceBinding = (ReferenceBinding)this.resolvedType;
        this.binding = this.findConstructorBinding(resolutionState.scope, this, referenceBinding, resolutionState.argumentTypes);
        return true;
    }

    TypeBinding resolvePart3(ResolutionState resolutionState) {
        if (this.suspendedResolutionState != null && this.suspendedResolutionState.hasReportedError) {
            return this.resolvedType;
        }
        this.suspendedResolutionState = null;
        if (resolutionState.cannotInferDiamond) {
            resolutionState.scope.problemReporter().cannotInferElidedTypes(this);
            this.resolvedType = null;
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
        if (!this.binding.isValidBinding()) {
            if (this.binding.declaringClass == null) {
                this.binding.declaringClass = referenceBinding;
            }
            if (this.type != null && !this.type.resolvedType.isValidBinding()) {
                return null;
            }
            resolutionState.scope.problemReporter().invalidConstructor(this, this.binding);
            return this.resolvedType;
        }
        if ((this.binding.tagBits & 0x80L) != 0L) {
            resolutionState.scope.problemReporter().missingTypeInConstructor(this, this.binding);
        }
        if (this.isMethodUseDeprecated(this.binding, resolutionState.scope, true)) {
            resolutionState.scope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (AllocationExpression.checkInvocationArguments(resolutionState.scope, null, referenceBinding, this.binding, this.arguments, resolutionState.argumentTypes, resolutionState.argsContainCast, this)) {
            this.bits |= 0x10000;
        }
        if (this.typeArguments != null && this.binding.original().typeVariables == Binding.NO_TYPE_VARIABLES) {
            resolutionState.scope.problemReporter().unnecessaryTypeArgumentsForMethodInvocation(this.binding, this.genericTypeArguments, this.typeArguments);
        }
        if (!resolutionState.isDiamond && this.resolvedType.isParameterizedTypeWithActualArguments()) {
            this.checkTypeArgumentRedundancy((ParameterizedTypeBinding)this.resolvedType, this.resolvedType.enclosingType(), resolutionState.argumentTypes, resolutionState.scope);
        }
        CompilerOptions compilerOptions = resolutionState.scope.compilerOptions();
        if (compilerOptions.isAnnotationBasedNullAnalysisEnabled && (this.binding.tagBits & 0x1000L) == 0L) {
            new ImplicitNullAnnotationVerifier(resolutionState.scope.environment(), compilerOptions.inheritNullAnnotations).checkImplicitNullAnnotations(this.binding, null, false, resolutionState.scope);
        }
        this.recordExceptionsForEnclosingLambda(resolutionState.scope, this.binding.thrownExceptions);
        return referenceBinding;
    }

    void checkIllegalNullAnnotation(BlockScope blockScope, TypeBinding typeBinding) {
        Annotation annotation;
        long l;
        if (typeBinding != null && (l = typeBinding.tagBits & 0x180000000000000L) != 0L && (annotation = this.type.findAnnotation(l)) != null) {
            blockScope.problemReporter().nullAnnotationUnsupportedLocation(annotation);
        }
    }

    public TypeBinding[] inferElidedTypes(ParameterizedTypeBinding parameterizedTypeBinding, ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, BlockScope blockScope) {
        MethodBinding methodBinding = blockScope.getStaticFactory(parameterizedTypeBinding, referenceBinding, typeBindingArray, this);
        if (methodBinding instanceof ParameterizedGenericMethodBinding && methodBinding.isValidBinding()) {
            ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = (ParameterizedGenericMethodBinding)methodBinding;
            this.inferredReturnType = parameterizedGenericMethodBinding.inferredReturnType;
            InferenceContext18 inferenceContext18 = this.getInferenceContext(parameterizedGenericMethodBinding);
            if (inferenceContext18 != null && inferenceContext18.stepCompleted == 3) {
                int n = 0;
                while (n < typeBindingArray.length) {
                    if (typeBindingArray[n] instanceof PolyTypeBinding) {
                        typeBindingArray[n] = this.arguments[n].resolvedType;
                    }
                    ++n;
                }
            }
            return ((ParameterizedTypeBinding)methodBinding.returnType).arguments;
        }
        return null;
    }

    public void checkTypeArgumentRedundancy(ParameterizedTypeBinding parameterizedTypeBinding, ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, BlockScope blockScope) {
        int n;
        TypeBinding[] typeBindingArray2;
        if (blockScope.problemReporter().computeSeverity(16778100) == 256 || blockScope.compilerOptions().sourceLevel < 0x330000L) {
            return;
        }
        if (parameterizedTypeBinding.arguments == null) {
            return;
        }
        if (this.genericTypeArguments != null) {
            return;
        }
        if (this.type == null) {
            return;
        }
        if (typeBindingArray == Binding.NO_PARAMETERS && this.typeExpected instanceof ParameterizedTypeBinding) {
            typeBindingArray2 = (TypeBinding[])this.typeExpected;
            if (typeBindingArray2.arguments != null && parameterizedTypeBinding.arguments.length == typeBindingArray2.arguments.length) {
                n = 0;
                while (n < parameterizedTypeBinding.arguments.length) {
                    if (TypeBinding.notEquals(parameterizedTypeBinding.arguments[n], typeBindingArray2.arguments[n])) break;
                    ++n;
                }
                if (n == parameterizedTypeBinding.arguments.length) {
                    blockScope.problemReporter().redundantSpecificationOfTypeArguments(this.type, parameterizedTypeBinding.arguments);
                    return;
                }
            }
        }
        n = this.type.bits;
        try {
            this.type.bits |= 0x80000;
            typeBindingArray2 = this.inferElidedTypes(parameterizedTypeBinding, referenceBinding, typeBindingArray, blockScope);
        }
        finally {
            this.type.bits = n;
        }
        if (typeBindingArray2 == null) {
            return;
        }
        int n2 = 0;
        while (n2 < typeBindingArray2.length) {
            if (TypeBinding.notEquals(typeBindingArray2[n2], parameterizedTypeBinding.arguments[n2])) {
                return;
            }
            ++n2;
        }
        blockScope.problemReporter().redundantSpecificationOfTypeArguments(this.type, parameterizedTypeBinding.arguments);
    }

    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    public void setDepth(int n) {
    }

    public void setFieldIndex(int n) {
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.typeArguments != null) {
                n2 = 0;
                n = this.typeArguments.length;
                while (n2 < n) {
                    this.typeArguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.arguments != null) {
                n2 = 0;
                n = this.arguments.length;
                while (n2 < n) {
                    this.arguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void setExpectedType(TypeBinding typeBinding) {
        this.typeExpected = typeBinding;
    }

    public void setExpressionContext(ExpressionContext expressionContext) {
        this.expressionContext = expressionContext;
    }

    public boolean isPolyExpression() {
        return this.isPolyExpression(this.binding);
    }

    public boolean isPolyExpression(MethodBinding methodBinding) {
        return (this.expressionContext == ExpressionContext.ASSIGNMENT_CONTEXT || this.expressionContext == ExpressionContext.INVOCATION_CONTEXT) && this.type != null && (this.type.bits & 0x80000) != 0;
    }

    public TypeBinding invocationTargetType() {
        return this.typeExpected;
    }

    public boolean statementExpression() {
        return true;
    }

    public MethodBinding binding(TypeBinding typeBinding, boolean bl, Scope scope) {
        if (this.suspendedResolutionState != null && typeBinding != null) {
            this.setExpectedType(typeBinding);
            if (!this.resolvePart2(this.suspendedResolutionState)) {
                if (bl && !this.suspendedResolutionState.hasReportedError) {
                    if (this.suspendedResolutionState.cannotInferDiamond) {
                        scope.problemReporter().cannotInferElidedTypes(this);
                    } else {
                        scope.problemReporter().genericInferenceError("constructor is unexpectedly unresolved", this);
                    }
                    this.suspendedResolutionState.hasReportedError = true;
                }
                return null;
            }
        }
        if (bl && this.binding != null && !this.binding.isValidBinding()) {
            if (this.binding.declaringClass == null) {
                this.binding.declaringClass = (ReferenceBinding)this.resolvedType;
            }
            if (this.suspendedResolutionState != null) {
                scope.problemReporter().invalidConstructor(this, this.binding);
                this.suspendedResolutionState.hasReportedError = true;
            }
        }
        return this.binding;
    }

    public TypeBinding checkAgainstFinalTargetType(TypeBinding typeBinding, Scope scope) {
        InferenceContext18 inferenceContext18;
        boolean bl;
        this.typeExpected = typeBinding;
        boolean bl2 = bl = this.binding == null || this.resolvedType != null && typeBinding != null && !this.resolvedType.isCompatibleWith(typeBinding);
        if (bl && this.suspendedResolutionState != null && !this.suspendedResolutionState.hasReportedError) {
            this.resolvePart2(this.suspendedResolutionState);
        }
        if (this.binding instanceof ParameterizedGenericMethodBinding && (inferenceContext18 = this.getInferenceContext((ParameterizedMethodBinding)this.binding)) != null && inferenceContext18.stepCompleted < 2) {
            this.typeExpected = typeBinding;
            MethodBinding methodBinding = inferenceContext18.inferInvocationType(this, (ParameterizedGenericMethodBinding)this.binding);
            if (this.updateBindings(methodBinding, typeBinding)) {
                ASTNode.resolvePolyExpressionArguments(this, methodBinding, scope);
            }
        }
        if (this.suspendedResolutionState != null) {
            return this.resolvePart3(this.suspendedResolutionState);
        }
        return this.resolvedType;
    }

    public Expression[] arguments() {
        return this.arguments;
    }

    public boolean updateBindings(MethodBinding methodBinding, TypeBinding typeBinding) {
        InferenceContext18 inferenceContext18;
        boolean bl;
        boolean bl2 = bl = this.binding != methodBinding;
        if (this.inferenceContexts != null && this.binding.original() == methodBinding.original() && (inferenceContext18 = (InferenceContext18)this.inferenceContexts.get(this.binding)) != null && methodBinding instanceof ParameterizedGenericMethodBinding) {
            this.inferenceContexts.put(methodBinding, inferenceContext18);
            bl |= inferenceContext18.registerSolution(typeBinding, methodBinding);
        }
        this.binding = methodBinding;
        this.resolvedType = methodBinding.declaringClass;
        return bl;
    }

    public void registerInferenceContext(ParameterizedGenericMethodBinding parameterizedGenericMethodBinding, InferenceContext18 inferenceContext18) {
        if (this.inferenceContexts == null) {
            this.inferenceContexts = new SimpleLookupTable();
        }
        this.inferenceContexts.put(parameterizedGenericMethodBinding, inferenceContext18);
        MethodBinding methodBinding = parameterizedGenericMethodBinding.original();
        if (methodBinding instanceof SyntheticFactoryMethodBinding) {
            SyntheticFactoryMethodBinding syntheticFactoryMethodBinding = (SyntheticFactoryMethodBinding)methodBinding;
            ParameterizedMethodBinding parameterizedMethodBinding = syntheticFactoryMethodBinding.applyTypeArgumentsOnConstructor(parameterizedGenericMethodBinding.typeArguments);
            this.inferenceContexts.put(parameterizedMethodBinding, inferenceContext18);
        }
    }

    public boolean usesInference() {
        return this.binding instanceof ParameterizedGenericMethodBinding && this.getInferenceContext((ParameterizedGenericMethodBinding)this.binding) != null;
    }

    public InferenceContext18 getInferenceContext(ParameterizedMethodBinding parameterizedMethodBinding) {
        if (this.inferenceContexts == null) {
            return null;
        }
        return (InferenceContext18)this.inferenceContexts.get(parameterizedMethodBinding);
    }

    public boolean innersNeedUpdate() {
        return this.innerInferenceHelper != null;
    }

    public void innerUpdateDone() {
        this.innerInferenceHelper = null;
    }

    public InnerInferenceHelper innerInferenceHelper() {
        return this.innerInferenceHelper;
    }

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public InferenceContext18 freshInferenceContext(Scope scope) {
        return new InferenceContext18(scope, this.arguments, this);
    }

    class ResolutionState {
        BlockScope scope;
        boolean isDiamond;
        boolean diamondNeedsDeferring;
        boolean argsContainCast;
        boolean cannotInferDiamond;
        TypeBinding[] argumentTypes;
        boolean hasReportedError;

        ResolutionState(BlockScope blockScope, boolean bl, boolean bl2, boolean bl3, TypeBinding[] typeBindingArray) {
            this.scope = blockScope;
            this.isDiamond = bl;
            this.diamondNeedsDeferring = bl2;
            this.argsContainCast = bl3;
            this.argumentTypes = typeBindingArray;
        }
    }
}

