/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.AnnotationContext;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.codegen.StackMapFrame;
import org.eclipse.jdt.internal.compiler.codegen.StackMapFrameCodeStream;
import org.eclipse.jdt.internal.compiler.codegen.TypeAnnotationCodeStream;
import org.eclipse.jdt.internal.compiler.codegen.VerificationTypeInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.problem.ShouldNotImplement;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClassFile
implements TypeConstants,
TypeIds {
    private byte[] bytes;
    public CodeStream codeStream;
    public ConstantPool constantPool;
    public int constantPoolOffset;
    public byte[] contents;
    public int contentsOffset;
    protected boolean creatingProblemType;
    public ClassFile enclosingClassFile;
    public byte[] header;
    public int headerOffset;
    public Set innerClassesBindings;
    public List bootstrapMethods = null;
    public int methodCount;
    public int methodCountOffset;
    boolean isShared = false;
    public int produceAttributes;
    public SourceTypeBinding referenceBinding;
    public boolean isNestedType;
    public long targetJDK;
    public List missingTypes = null;
    public Set visitedTypes;
    public static final int INITIAL_CONTENTS_SIZE = 400;
    public static final int INITIAL_HEADER_SIZE = 1500;
    public static final int INNER_CLASSES_SIZE = 5;

    public static void createProblemType(TypeDeclaration typeDeclaration, CompilationResult compilationResult) {
        ASTNode aSTNode;
        int n;
        int n2;
        CategorizedProblem[] categorizedProblemArray;
        int n3;
        int n4;
        ReferenceBinding[] referenceBindingArray;
        SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
        ClassFile classFile = ClassFile.getNewInstance(sourceTypeBinding);
        classFile.initialize(sourceTypeBinding, null, true);
        if (sourceTypeBinding.hasMemberTypes()) {
            referenceBindingArray = sourceTypeBinding.memberTypes;
            n4 = 0;
            n3 = referenceBindingArray.length;
            while (n4 < n3) {
                classFile.recordInnerClasses(referenceBindingArray[n4]);
                ++n4;
            }
        }
        if (sourceTypeBinding.isNestedType()) {
            classFile.recordInnerClasses(sourceTypeBinding);
        }
        referenceBindingArray = sourceTypeBinding.typeVariables();
        n4 = 0;
        n3 = referenceBindingArray.length;
        while (n4 < n3) {
            categorizedProblemArray = referenceBindingArray[n4];
            if ((categorizedProblemArray.tagBits & 0x800L) != 0L) {
                Util.recordNestedType(classFile, (TypeBinding)categorizedProblemArray);
            }
            ++n4;
        }
        FieldBinding[] fieldBindingArray = sourceTypeBinding.fields();
        if (fieldBindingArray != null && fieldBindingArray != Binding.NO_FIELDS) {
            classFile.addFieldInfos();
        } else {
            classFile.contents[classFile.contentsOffset++] = 0;
            classFile.contents[classFile.contentsOffset++] = 0;
        }
        classFile.setForMethodInfos();
        categorizedProblemArray = compilationResult.getErrors();
        if (categorizedProblemArray == null) {
            categorizedProblemArray = new CategorizedProblem[]{};
        }
        n3 = categorizedProblemArray.length;
        CategorizedProblem[] categorizedProblemArray2 = new CategorizedProblem[n3];
        System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray2, 0, n3);
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = typeDeclaration.methods;
        boolean bl = false;
        if (abstractMethodDeclarationArray != null) {
            if (sourceTypeBinding.isInterface()) {
                if (sourceTypeBinding.scope.compilerOptions().sourceLevel < 0x340000L) {
                    bl = true;
                }
                classFile.addProblemClinit(categorizedProblemArray2);
            }
            n2 = 0;
            n = abstractMethodDeclarationArray.length;
            while (n2 < n) {
                aSTNode = abstractMethodDeclarationArray[n2];
                MethodBinding methodBinding = aSTNode.binding;
                if (methodBinding != null) {
                    if (bl) {
                        methodBinding.modifiers = 1025;
                    }
                    if (methodBinding.isConstructor()) {
                        if (!sourceTypeBinding.isInterface()) {
                            classFile.addProblemConstructor((AbstractMethodDeclaration)aSTNode, methodBinding, categorizedProblemArray2);
                        }
                    } else if (methodBinding.isAbstract()) {
                        classFile.addAbstractMethod((AbstractMethodDeclaration)aSTNode, methodBinding);
                    } else {
                        classFile.addProblemMethod((AbstractMethodDeclaration)aSTNode, methodBinding, categorizedProblemArray2);
                    }
                }
                ++n2;
            }
            classFile.addDefaultAbstractMethods();
        }
        if (typeDeclaration.memberTypes != null) {
            n2 = 0;
            n = typeDeclaration.memberTypes.length;
            while (n2 < n) {
                aSTNode = typeDeclaration.memberTypes[n2];
                if (((TypeDeclaration)aSTNode).binding != null) {
                    ClassFile.createProblemType((TypeDeclaration)aSTNode, compilationResult);
                }
                ++n2;
            }
        }
        classFile.addAttributes();
        compilationResult.record(sourceTypeBinding.constantPoolName(), classFile);
    }

    public static ClassFile getNewInstance(SourceTypeBinding sourceTypeBinding) {
        LookupEnvironment lookupEnvironment = sourceTypeBinding.scope.environment();
        return lookupEnvironment.classFilePool.acquire(sourceTypeBinding);
    }

    protected ClassFile() {
    }

    public ClassFile(SourceTypeBinding sourceTypeBinding) {
        this.constantPool = new ConstantPool(this);
        CompilerOptions compilerOptions = sourceTypeBinding.scope.compilerOptions();
        this.targetJDK = compilerOptions.targetJDK;
        this.produceAttributes = compilerOptions.produceDebugAttributes;
        this.referenceBinding = sourceTypeBinding;
        this.isNestedType = sourceTypeBinding.isNestedType();
        if (this.targetJDK >= 0x320000L) {
            this.produceAttributes |= 8;
            if (this.targetJDK >= 0x340000L) {
                this.produceAttributes |= 0x20;
                this.codeStream = new TypeAnnotationCodeStream(this);
                if (compilerOptions.produceMethodParameters) {
                    this.produceAttributes |= 0x40;
                }
            } else {
                this.codeStream = new StackMapFrameCodeStream(this);
            }
        } else if (this.targetJDK == 2949124L) {
            this.targetJDK = 2949123L;
            this.produceAttributes |= 0x10;
            this.codeStream = new StackMapFrameCodeStream(this);
        } else {
            this.codeStream = new CodeStream(this);
        }
        this.initByteArrays();
    }

    public void addAbstractMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(methodBinding);
        this.completeMethodInfo(methodBinding, n, n2);
    }

    public void addAttributes() {
        Object[] objectArray;
        TypeDeclaration typeDeclaration;
        int n;
        Object object;
        this.contents[this.methodCountOffset++] = (byte)(this.methodCount >> 8);
        this.contents[this.methodCountOffset] = (byte)this.methodCount;
        int n2 = 0;
        int n3 = this.contentsOffset;
        this.contentsOffset += 2;
        if ((this.produceAttributes & 1) != 0) {
            object = new String(this.referenceBinding.scope.referenceCompilationUnit().getFileName());
            n = ((String)(object = ((String)object).replace('\\', '/'))).lastIndexOf(47);
            if (n != -1) {
                object = ((String)object).substring(n + 1, ((String)object).length());
            }
            n2 += this.generateSourceAttribute((String)object);
        }
        if (this.referenceBinding.isDeprecated()) {
            n2 += this.generateDeprecatedAttribute();
        }
        if ((object = this.referenceBinding.genericSignature()) != null) {
            n2 += this.generateSignatureAttribute((char[])object);
        }
        if (this.targetJDK >= 0x310000L && this.referenceBinding.isNestedType() && !this.referenceBinding.isMemberType()) {
            n2 += this.generateEnclosingMethodAttribute();
        }
        if (this.targetJDK >= 0x300000L && (typeDeclaration = this.referenceBinding.scope.referenceContext) != null && (objectArray = typeDeclaration.annotations) != null) {
            long l = typeDeclaration.isPackageInfo() ? 0x80000000000L : (this.referenceBinding.isAnnotationType() ? 0x41000000000L : 0x20001000000000L);
            n2 += this.generateRuntimeAnnotations((Annotation[])objectArray, l);
        }
        if (this.referenceBinding.isHierarchyInconsistent()) {
            ReferenceBinding referenceBinding = this.referenceBinding.superclass;
            if (referenceBinding != null) {
                this.missingTypes = referenceBinding.collectMissingTypes(this.missingTypes);
            }
            objectArray = this.referenceBinding.superInterfaces();
            int n4 = 0;
            int n5 = objectArray.length;
            while (n4 < n5) {
                this.missingTypes = ((TypeBinding)objectArray[n4]).collectMissingTypes(this.missingTypes);
                ++n4;
            }
            n2 += this.generateHierarchyInconsistentAttribute();
        }
        if (this.bootstrapMethods != null && !this.bootstrapMethods.isEmpty()) {
            n2 += this.generateBootstrapMethods(this.bootstrapMethods);
        }
        int n6 = n = this.innerClassesBindings == null ? 0 : this.innerClassesBindings.size();
        if (n != 0) {
            objectArray = new ReferenceBinding[n];
            this.innerClassesBindings.toArray(objectArray);
            Arrays.sort(objectArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    TypeBinding typeBinding = (TypeBinding)object;
                    TypeBinding typeBinding2 = (TypeBinding)object2;
                    return CharOperation.compareTo(typeBinding.constantPoolName(), typeBinding2.constantPoolName());
                }
            });
            n2 += this.generateInnerClassAttribute(n, (ReferenceBinding[])objectArray);
        }
        if (this.missingTypes != null) {
            this.generateMissingTypesAttribute();
            ++n2;
        }
        n2 += this.generateTypeAnnotationAttributeForTypeDeclaration();
        if (n3 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n3++] = (byte)(n2 >> 8);
        this.contents[n3] = (byte)n2;
        this.header = this.constantPool.poolContent;
        this.headerOffset = this.constantPool.currentOffset;
        int n7 = this.constantPool.currentIndex;
        this.header[this.constantPoolOffset++] = (byte)(n7 >> 8);
        this.header[this.constantPoolOffset] = (byte)n7;
    }

    public void addDefaultAbstractMethods() {
        MethodBinding[] methodBindingArray = this.referenceBinding.getDefaultAbstractMethods();
        int n = 0;
        int n2 = methodBindingArray.length;
        while (n < n2) {
            MethodBinding methodBinding = methodBindingArray[n];
            this.generateMethodInfoHeader(methodBinding);
            int n3 = this.contentsOffset;
            int n4 = this.generateMethodInfoAttributes(methodBinding);
            this.completeMethodInfo(methodBinding, n3, n4);
            ++n;
        }
    }

    private int addFieldAttributes(FieldBinding fieldBinding, int n) {
        FieldDeclaration fieldDeclaration;
        char[] cArray;
        int n2 = 0;
        Constant constant = fieldBinding.constant();
        if (constant != Constant.NotAConstant) {
            n2 += this.generateConstantValueAttribute(constant, fieldBinding, n);
        }
        if (this.targetJDK < 0x310000L && fieldBinding.isSynthetic()) {
            n2 += this.generateSyntheticAttribute();
        }
        if (fieldBinding.isDeprecated()) {
            n2 += this.generateDeprecatedAttribute();
        }
        if ((cArray = fieldBinding.genericSignature()) != null) {
            n2 += this.generateSignatureAttribute(cArray);
        }
        if (this.targetJDK >= 0x300000L && (fieldDeclaration = fieldBinding.sourceField()) != null) {
            Annotation[] annotationArray = fieldDeclaration.annotations;
            if (annotationArray != null) {
                n2 += this.generateRuntimeAnnotations(annotationArray, 0x2000000000L);
            }
            if ((this.produceAttributes & 0x20) != 0) {
                int n3;
                ArrayList<AnnotationContext> arrayList = new ArrayList<AnnotationContext>();
                if (annotationArray != null && (fieldDeclaration.bits & 0x100000) != 0) {
                    fieldDeclaration.getAllAnnotationContexts(19, arrayList);
                }
                int n4 = 0;
                int n5 = 0;
                TypeReference typeReference = fieldDeclaration.type;
                if (typeReference != null && (typeReference.bits & 0x100000) != 0) {
                    typeReference.getAllAnnotationContexts(19, arrayList);
                }
                if ((n3 = arrayList.size()) != 0) {
                    AnnotationContext[] annotationContextArray = new AnnotationContext[n3];
                    arrayList.toArray(annotationContextArray);
                    int n6 = 0;
                    int n7 = annotationContextArray.length;
                    while (n6 < n7) {
                        AnnotationContext annotationContext = annotationContextArray[n6];
                        if ((annotationContext.visibility & 2) != 0) {
                            ++n4;
                            arrayList.add(annotationContext);
                        } else {
                            ++n5;
                            arrayList.add(annotationContext);
                        }
                        ++n6;
                    }
                    n2 += this.generateRuntimeTypeAnnotations(annotationContextArray, n5, n4);
                }
            }
        }
        if ((fieldBinding.tagBits & 0x80L) != 0L) {
            this.missingTypes = fieldBinding.type.collectMissingTypes(this.missingTypes);
        }
        return n2;
    }

    private void addFieldInfo(FieldBinding fieldBinding) {
        if (this.contentsOffset + 8 >= this.contents.length) {
            this.resizeContents(8);
        }
        int n = fieldBinding.getAccessFlags();
        if (this.targetJDK < 0x310000L) {
            n &= 0xFFFFEFFF;
        }
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(fieldBinding.name);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        int n3 = this.constantPool.literalIndex(fieldBinding.type);
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        int n4 = this.contentsOffset;
        int n5 = 0;
        this.contentsOffset += 2;
        n5 += this.addFieldAttributes(fieldBinding, n4);
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n4++] = (byte)(n5 >> 8);
        this.contents[n4] = (byte)n5;
    }

    public void addFieldInfos() {
        SourceTypeBinding sourceTypeBinding = this.referenceBinding;
        FieldBinding[] fieldBindingArray = sourceTypeBinding.syntheticFields();
        int n = sourceTypeBinding.fieldCount() + (fieldBindingArray == null ? 0 : fieldBindingArray.length);
        if (n > 65535) {
            this.referenceBinding.scope.problemReporter().tooManyFields(this.referenceBinding.scope.referenceType());
        }
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        FieldDeclaration[] fieldDeclarationArray = sourceTypeBinding.scope.referenceContext.fields;
        int n2 = 0;
        int n3 = fieldDeclarationArray == null ? 0 : fieldDeclarationArray.length;
        while (n2 < n3) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            if (fieldDeclaration.binding != null) {
                this.addFieldInfo(fieldDeclaration.binding);
            }
            ++n2;
        }
        if (fieldBindingArray != null) {
            n2 = 0;
            n3 = fieldBindingArray.length;
            while (n2 < n3) {
                this.addFieldInfo(fieldBindingArray[n2]);
                ++n2;
            }
        }
    }

    private void addMissingAbstractProblemMethod(MethodDeclaration methodDeclaration, MethodBinding methodBinding, CategorizedProblem categorizedProblem, CompilationResult compilationResult) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(methodBinding);
        ++n2;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        StringBuffer stringBuffer = new StringBuffer(25);
        stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
        stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
        String string = stringBuffer.toString();
        this.codeStream.init(this);
        this.codeStream.preserveUnusedLocals = true;
        this.codeStream.initializeMaxLocals(methodBinding);
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        this.completeCodeAttributeForMissingAbstractProblemMethod(methodBinding, n3, compilationResult.getLineSeparatorPositions(), categorizedProblem.getSourceLineNumber());
        this.completeMethodInfo(methodBinding, n, n2);
    }

    public void addProblemClinit(CategorizedProblem[] categorizedProblemArray) {
        this.generateMethodInfoHeaderForClinit();
        this.contentsOffset -= 2;
        int n = this.contentsOffset;
        this.contentsOffset += 2;
        int n2 = 0;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.resetForProblemClinit(this);
        String string = "";
        int n4 = 0;
        if (categorizedProblemArray != null) {
            int n5 = categorizedProblemArray.length;
            StringBuffer stringBuffer = new StringBuffer(25);
            int n6 = 0;
            int n7 = 0;
            while (n7 < n5) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[n7];
                if (categorizedProblem != null && categorizedProblem.isError()) {
                    stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
                    ++n6;
                    if (n4 == 0) {
                        n4 = categorizedProblem.getSourceLineNumber();
                    }
                    categorizedProblemArray[n7] = null;
                }
                ++n7;
            }
            if (n6 > 1) {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            string = stringBuffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        ++n2;
        this.completeCodeAttributeForClinit(n3, n4);
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addProblemConstructor(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray) {
        if (methodBinding.declaringClass.isInterface()) {
            abstractMethodDeclaration.abort(8, null);
        }
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(methodBinding);
        ++n2;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(abstractMethodDeclaration, this);
        String string = "";
        int n4 = 0;
        if (categorizedProblemArray != null) {
            int n5 = categorizedProblemArray.length;
            StringBuffer stringBuffer = new StringBuffer(25);
            int n6 = 0;
            int n7 = 0;
            while (n7 < n5) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[n7];
                if (categorizedProblem != null && categorizedProblem.isError()) {
                    stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
                    ++n6;
                    if (n4 == 0) {
                        n4 = categorizedProblem.getSourceLineNumber();
                    }
                }
                ++n7;
            }
            if (n6 > 1) {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            string = stringBuffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        this.completeCodeAttributeForProblemMethod(abstractMethodDeclaration, methodBinding, n3, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions(), n4);
        this.completeMethodInfo(methodBinding, n, n2);
    }

    public void addProblemConstructor(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray, int n) {
        this.contentsOffset = n;
        --this.methodCount;
        this.addProblemConstructor(abstractMethodDeclaration, methodBinding, categorizedProblemArray);
    }

    public void addProblemMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray) {
        if (methodBinding.isAbstract() && methodBinding.declaringClass.isInterface()) {
            abstractMethodDeclaration.abort(8, null);
        }
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(methodBinding);
        ++n2;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(abstractMethodDeclaration, this);
        String string = "";
        int n4 = 0;
        if (categorizedProblemArray != null) {
            int n5 = categorizedProblemArray.length;
            StringBuffer stringBuffer = new StringBuffer(25);
            int n6 = 0;
            int n7 = 0;
            while (n7 < n5) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[n7];
                if (categorizedProblem != null && categorizedProblem.isError() && categorizedProblem.getSourceStart() >= abstractMethodDeclaration.declarationSourceStart && categorizedProblem.getSourceEnd() <= abstractMethodDeclaration.declarationSourceEnd) {
                    stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
                    ++n6;
                    if (n4 == 0) {
                        n4 = categorizedProblem.getSourceLineNumber();
                    }
                    categorizedProblemArray[n7] = null;
                }
                ++n7;
            }
            if (n6 > 1) {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            string = stringBuffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        this.completeCodeAttributeForProblemMethod(abstractMethodDeclaration, methodBinding, n3, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions(), n4);
        this.completeMethodInfo(methodBinding, n, n2);
    }

    public void addProblemMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray, int n) {
        this.contentsOffset = n;
        --this.methodCount;
        this.addProblemMethod(abstractMethodDeclaration, methodBinding, categorizedProblemArray);
    }

    public void addSpecialMethods() {
        int n;
        int n2;
        SyntheticMethodBinding[] syntheticMethodBindingArray;
        this.generateMissingAbstractMethods(this.referenceBinding.scope.referenceType().missingAbstractMethods, this.referenceBinding.scope.referenceCompilationUnit().compilationResult);
        MethodBinding[] methodBindingArray = this.referenceBinding.getDefaultAbstractMethods();
        int n3 = 0;
        int n4 = methodBindingArray.length;
        while (n3 < n4) {
            syntheticMethodBindingArray = methodBindingArray[n3];
            this.generateMethodInfoHeader((MethodBinding)syntheticMethodBindingArray);
            n2 = this.contentsOffset;
            n = this.generateMethodInfoAttributes((MethodBinding)syntheticMethodBindingArray);
            this.completeMethodInfo((MethodBinding)syntheticMethodBindingArray, n2, n);
            ++n3;
        }
        n3 = 0;
        n4 = 1;
        while (n4 != 0) {
            n4 = 0;
            syntheticMethodBindingArray = this.referenceBinding.syntheticMethods();
            int n5 = n2 = syntheticMethodBindingArray == null ? 0 : syntheticMethodBindingArray.length;
            if (n3 == n2) continue;
            n = n3;
            int n6 = n2;
            while (n < n6) {
                SyntheticMethodBinding syntheticMethodBinding = syntheticMethodBindingArray[n];
                switch (syntheticMethodBinding.purpose) {
                    case 1: 
                    case 3: {
                        this.addSyntheticFieldReadAccessMethod(syntheticMethodBinding);
                        break;
                    }
                    case 2: 
                    case 4: {
                        this.addSyntheticFieldWriteAccessMethod(syntheticMethodBinding);
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 8: {
                        this.addSyntheticMethodAccessMethod(syntheticMethodBinding);
                        break;
                    }
                    case 6: {
                        this.addSyntheticConstructorAccessMethod(syntheticMethodBinding);
                        break;
                    }
                    case 9: {
                        this.addSyntheticEnumValuesMethod(syntheticMethodBinding);
                        break;
                    }
                    case 10: {
                        this.addSyntheticEnumValueOfMethod(syntheticMethodBinding);
                        break;
                    }
                    case 11: {
                        this.addSyntheticSwitchTable(syntheticMethodBinding);
                        break;
                    }
                    case 12: {
                        this.addSyntheticEnumInitializationMethod(syntheticMethodBinding);
                        break;
                    }
                    case 13: {
                        syntheticMethodBinding.lambda.generateCode(this.referenceBinding.scope, this);
                        n4 = 1;
                        break;
                    }
                    case 14: {
                        this.addSyntheticArrayConstructor(syntheticMethodBinding);
                        break;
                    }
                    case 15: {
                        this.addSyntheticArrayClone(syntheticMethodBinding);
                        break;
                    }
                    case 16: {
                        this.addSyntheticFactoryMethod(syntheticMethodBinding);
                        break;
                    }
                    case 17: {
                        this.addSyntheticDeserializeLambda(syntheticMethodBinding, this.referenceBinding.syntheticMethods());
                    }
                }
                ++n;
            }
            n3 = n2;
        }
    }

    public void addSyntheticArrayConstructor(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForArrayConstructor(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticArrayClone(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForArrayClone(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticFactoryMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFactoryMethod(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticConstructorAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForConstructorAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticEnumValueOfMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        ++n2;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumValueOf(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        if ((this.produceAttributes & 0x40) != 0) {
            n2 += this.generateMethodParameters(syntheticMethodBinding);
        }
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticEnumValuesMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumValues(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticEnumInitializationMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumInitializationMethod(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticFieldReadAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldReadAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticFieldWriteAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldWriteAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticMethodAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForMethodAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticSwitchTable(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForSwitchTable(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(true, syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void completeCodeAttribute(int n) {
        this.contents = this.codeStream.bCodeStream;
        int n2 = this.codeStream.classFileOffset;
        int n3 = this.codeStream.position;
        if (n3 > 65535) {
            if (this.codeStream.methodDeclaration != null) {
                this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration);
            } else {
                this.codeStream.lambdaExpression.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.lambdaExpression);
            }
        }
        if (n2 + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n4 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n4 >> 8);
        this.contents[n + 7] = (byte)n4;
        int n5 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n5 >> 8);
        this.contents[n + 9] = (byte)n5;
        this.contents[n + 10] = (byte)(n3 >> 24);
        this.contents[n + 11] = (byte)(n3 >> 16);
        this.contents[n + 12] = (byte)(n3 >> 8);
        this.contents[n + 13] = (byte)n3;
        boolean bl = (this.produceAttributes & 8) != 0;
        ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.codeStream.exceptionLabelsCounter;
        while (n7 < n8) {
            n6 += this.codeStream.exceptionLabels[n7].getCount() / 2;
            ++n7;
        }
        n7 = n6 * 8 + 2;
        if (n7 + n2 >= this.contents.length) {
            this.resizeContents(n7);
        }
        this.contents[n2++] = (byte)(n6 >> 8);
        this.contents[n2++] = (byte)n6;
        n8 = 0;
        int n9 = this.codeStream.exceptionLabelsCounter;
        while (n8 < n9) {
            ExceptionLabel exceptionLabel = exceptionLabelArray[n8];
            if (exceptionLabel != null) {
                int n10 = 0;
                int n11 = exceptionLabel.getCount();
                if ((n11 & 1) != 0) {
                    if (this.codeStream.methodDeclaration != null) {
                        this.codeStream.methodDeclaration.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(this.codeStream.methodDeclaration.selector)), this.codeStream.methodDeclaration);
                    } else {
                        this.codeStream.lambdaExpression.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(this.codeStream.lambdaExpression.binding.selector)), this.codeStream.lambdaExpression);
                    }
                }
                while (n10 < n11) {
                    int n12 = exceptionLabel.ranges[n10++];
                    this.contents[n2++] = (byte)(n12 >> 8);
                    this.contents[n2++] = (byte)n12;
                    int n13 = exceptionLabel.ranges[n10++];
                    this.contents[n2++] = (byte)(n13 >> 8);
                    this.contents[n2++] = (byte)n13;
                    int n14 = exceptionLabel.position;
                    if (bl) {
                        StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
                        stackMapFrameCodeStream.addFramePosition(n14);
                    }
                    this.contents[n2++] = (byte)(n14 >> 8);
                    this.contents[n2++] = (byte)n14;
                    if (exceptionLabel.exceptionType == null) {
                        this.contents[n2++] = 0;
                        this.contents[n2++] = 0;
                        continue;
                    }
                    int n15 = exceptionLabel.exceptionType == TypeBinding.NULL ? this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName) : this.constantPool.literalIndexForType(exceptionLabel.exceptionType);
                    this.contents[n2++] = (byte)(n15 >> 8);
                    this.contents[n2++] = (byte)n15;
                }
            }
            ++n8;
        }
        n8 = n2;
        n9 = 0;
        if ((n2 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contentsOffset = n2;
        if ((this.produceAttributes & 2) != 0) {
            n9 += this.generateLineNumberAttribute();
        }
        if ((this.produceAttributes & 4) != 0) {
            boolean bl2 = this.codeStream.methodDeclaration != null ? this.codeStream.methodDeclaration.isStatic() : this.codeStream.lambdaExpression.binding.isStatic();
            n9 += this.generateLocalVariableTableAttribute(n3, bl2, false);
        }
        if (bl) {
            n9 += this.generateStackMapTableAttribute(this.codeStream.methodDeclaration != null ? this.codeStream.methodDeclaration.binding : this.codeStream.lambdaExpression.binding, n3, n, n5, false);
        }
        if ((this.produceAttributes & 0x10) != 0) {
            n9 += this.generateStackMapAttribute(this.codeStream.methodDeclaration != null ? this.codeStream.methodDeclaration.binding : this.codeStream.lambdaExpression.binding, n3, n, n5, false);
        }
        if ((this.produceAttributes & 0x20) != 0) {
            n9 += this.generateTypeAnnotationsOnCodeAttribute();
        }
        this.contents[n8++] = (byte)(n9 >> 8);
        this.contents[n8] = (byte)n9;
        int n16 = this.contentsOffset - (n + 6);
        this.contents[n + 2] = (byte)(n16 >> 24);
        this.contents[n + 3] = (byte)(n16 >> 16);
        this.contents[n + 4] = (byte)(n16 >> 8);
        this.contents[n + 5] = (byte)n16;
    }

    public int generateTypeAnnotationsOnCodeAttribute() {
        int n;
        Object object;
        int n2 = 0;
        List list = ((TypeAnnotationCodeStream)this.codeStream).allTypeAnnotationContexts;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.codeStream.allLocalsCounter;
        while (n5 < n6) {
            LocalVariableBinding localVariableBinding = this.codeStream.locals[n5];
            if (!(localVariableBinding.isCatchParameter() || (object = localVariableBinding.declaration) == null || ((LocalDeclaration)object).isArgument() && (((LocalDeclaration)object).bits & 0x20000000) == 0 || localVariableBinding.initializationCount == 0 || (((LocalDeclaration)object).bits & 0x100000) == 0)) {
                n = (localVariableBinding.tagBits & 0x2000L) == 0L ? 64 : 65;
                ((LocalDeclaration)object).getAllAnnotationContexts(n, localVariableBinding, list);
            }
            ++n5;
        }
        ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
        n6 = 0;
        int n7 = this.codeStream.exceptionLabelsCounter;
        while (n6 < n7) {
            object = exceptionLabelArray[n6];
            if (((ExceptionLabel)object).exceptionTypeReference != null && (((ExceptionLabel)object).exceptionTypeReference.bits & 0x100000) != 0) {
                ((ExceptionLabel)object).exceptionTypeReference.getAllAnnotationContexts(66, n6, list, ((ExceptionLabel)object).se7Annotations);
            }
            ++n6;
        }
        n6 = list.size();
        if (n6 != 0) {
            AnnotationContext[] annotationContextArray = new AnnotationContext[n6];
            list.toArray(annotationContextArray);
            int n8 = 0;
            n = annotationContextArray.length;
            while (n8 < n) {
                AnnotationContext annotationContext = annotationContextArray[n8];
                if ((annotationContext.visibility & 2) != 0) {
                    ++n3;
                } else {
                    ++n4;
                }
                ++n8;
            }
            n2 += this.generateRuntimeTypeAnnotations(annotationContextArray, n4, n3);
        }
        return n2;
    }

    public void completeCodeAttributeForClinit(int n) {
        this.contents = this.codeStream.bCodeStream;
        int n2 = this.codeStream.classFileOffset;
        int n3 = this.codeStream.position;
        if (n3 > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (n2 + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n4 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n4 >> 8);
        this.contents[n + 7] = (byte)n4;
        int n5 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n5 >> 8);
        this.contents[n + 9] = (byte)n5;
        this.contents[n + 10] = (byte)(n3 >> 24);
        this.contents[n + 11] = (byte)(n3 >> 16);
        this.contents[n + 12] = (byte)(n3 >> 8);
        this.contents[n + 13] = (byte)n3;
        boolean bl = (this.produceAttributes & 8) != 0;
        ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.codeStream.exceptionLabelsCounter;
        while (n7 < n8) {
            n6 += this.codeStream.exceptionLabels[n7].getCount() / 2;
            ++n7;
        }
        n7 = n6 * 8 + 2;
        if (n7 + n2 >= this.contents.length) {
            this.resizeContents(n7);
        }
        this.contents[n2++] = (byte)(n6 >> 8);
        this.contents[n2++] = (byte)n6;
        n8 = 0;
        int n9 = this.codeStream.exceptionLabelsCounter;
        while (n8 < n9) {
            ExceptionLabel exceptionLabel = exceptionLabelArray[n8];
            if (exceptionLabel != null) {
                int n10 = 0;
                int n11 = exceptionLabel.getCount();
                if ((n11 & 1) != 0) {
                    this.codeStream.methodDeclaration.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(this.codeStream.methodDeclaration.selector)), this.codeStream.methodDeclaration);
                }
                while (n10 < n11) {
                    int n12 = exceptionLabel.ranges[n10++];
                    this.contents[n2++] = (byte)(n12 >> 8);
                    this.contents[n2++] = (byte)n12;
                    int n13 = exceptionLabel.ranges[n10++];
                    this.contents[n2++] = (byte)(n13 >> 8);
                    this.contents[n2++] = (byte)n13;
                    int n14 = exceptionLabel.position;
                    this.contents[n2++] = (byte)(n14 >> 8);
                    this.contents[n2++] = (byte)n14;
                    if (bl) {
                        StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
                        stackMapFrameCodeStream.addFramePosition(n14);
                    }
                    if (exceptionLabel.exceptionType == null) {
                        this.contents[n2++] = 0;
                        this.contents[n2++] = 0;
                        continue;
                    }
                    int n15 = exceptionLabel.exceptionType == TypeBinding.NULL ? this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName) : this.constantPool.literalIndexForType(exceptionLabel.exceptionType);
                    this.contents[n2++] = (byte)(n15 >> 8);
                    this.contents[n2++] = (byte)n15;
                }
            }
            ++n8;
        }
        n8 = n2;
        n9 = 0;
        if ((n2 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contentsOffset = n2;
        if ((this.produceAttributes & 2) != 0) {
            n9 += this.generateLineNumberAttribute();
        }
        if ((this.produceAttributes & 4) != 0) {
            n9 += this.generateLocalVariableTableAttribute(n3, true, false);
        }
        if ((this.produceAttributes & 8) != 0) {
            n9 += this.generateStackMapTableAttribute(null, n3, n, n5, true);
        }
        if ((this.produceAttributes & 0x10) != 0) {
            n9 += this.generateStackMapAttribute(null, n3, n, n5, true);
        }
        if ((this.produceAttributes & 0x20) != 0) {
            n9 += this.generateTypeAnnotationsOnCodeAttribute();
        }
        if (n8 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n8++] = (byte)(n9 >> 8);
        this.contents[n8] = (byte)n9;
        int n16 = this.contentsOffset - (n + 6);
        this.contents[n + 2] = (byte)(n16 >> 24);
        this.contents[n + 3] = (byte)(n16 >> 16);
        this.contents[n + 4] = (byte)(n16 >> 8);
        this.contents[n + 5] = (byte)n16;
    }

    public void completeCodeAttributeForClinit(int n, int n2) {
        int n3;
        this.contents = this.codeStream.bCodeStream;
        int n4 = this.codeStream.classFileOffset;
        int n5 = this.codeStream.position;
        if (n5 > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (n4 + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n6 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n6 >> 8);
        this.contents[n + 7] = (byte)n6;
        int n7 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n7 >> 8);
        this.contents[n + 9] = (byte)n7;
        this.contents[n + 10] = (byte)(n5 >> 24);
        this.contents[n + 11] = (byte)(n5 >> 16);
        this.contents[n + 12] = (byte)(n5 >> 8);
        this.contents[n + 13] = (byte)n5;
        this.contents[n4++] = 0;
        this.contents[n4++] = 0;
        int n8 = n4;
        int n9 = 0;
        if ((n4 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contentsOffset = n4;
        if ((this.produceAttributes & 2) != 0) {
            n9 += this.generateLineNumberAttribute(n2);
        }
        n4 = this.contentsOffset;
        if ((this.produceAttributes & 4) != 0) {
            n3 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (n4 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[n4++] = (byte)(n3 >> 8);
            this.contents[n4++] = (byte)n3;
            this.contents[n4++] = 0;
            this.contents[n4++] = 0;
            this.contents[n4++] = 0;
            this.contents[n4++] = 2;
            this.contents[n4++] = 0;
            this.contents[n4++] = 0;
            ++n9;
        }
        this.contentsOffset = n4;
        if ((this.produceAttributes & 8) != 0) {
            n9 += this.generateStackMapTableAttribute(null, n5, n, n7, true);
        }
        if ((this.produceAttributes & 0x10) != 0) {
            n9 += this.generateStackMapAttribute(null, n5, n, n7, true);
        }
        if ((this.produceAttributes & 0x20) != 0) {
            n9 += this.generateTypeAnnotationsOnCodeAttribute();
        }
        if (n8 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n8++] = (byte)(n9 >> 8);
        this.contents[n8] = (byte)n9;
        n3 = this.contentsOffset - (n + 6);
        this.contents[n + 2] = (byte)(n3 >> 24);
        this.contents[n + 3] = (byte)(n3 >> 16);
        this.contents[n + 4] = (byte)(n3 >> 8);
        this.contents[n + 5] = (byte)n3;
    }

    public void completeCodeAttributeForMissingAbstractProblemMethod(MethodBinding methodBinding, int n, int[] nArray, int n2) {
        this.contents = this.codeStream.bCodeStream;
        int n3 = this.codeStream.classFileOffset;
        int n4 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n4 >> 8);
        this.contents[n + 7] = (byte)n4;
        int n5 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n5 >> 8);
        this.contents[n + 9] = (byte)n5;
        int n6 = this.codeStream.position;
        this.contents[n + 10] = (byte)(n6 >> 24);
        this.contents[n + 11] = (byte)(n6 >> 16);
        this.contents[n + 12] = (byte)(n6 >> 8);
        this.contents[n + 13] = (byte)n6;
        if (n3 + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[n3++] = 0;
        this.contents[n3++] = 0;
        int n7 = n3;
        int n8 = 0;
        if ((n3 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contentsOffset = n3;
        if ((this.produceAttributes & 2) != 0) {
            if (n2 == 0) {
                n2 = Util.getLineNumber(methodBinding.sourceStart(), nArray, 0, nArray.length - 1);
            }
            n8 += this.generateLineNumberAttribute(n2);
        }
        if ((this.produceAttributes & 8) != 0) {
            n8 += this.generateStackMapTableAttribute(methodBinding, n6, n, n5, false);
        }
        if ((this.produceAttributes & 0x10) != 0) {
            n8 += this.generateStackMapAttribute(methodBinding, n6, n, n5, false);
        }
        if (n7 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n7++] = (byte)(n8 >> 8);
        this.contents[n7] = (byte)n8;
        int n9 = this.contentsOffset - (n + 6);
        this.contents[n + 2] = (byte)(n9 >> 24);
        this.contents[n + 3] = (byte)(n9 >> 16);
        this.contents[n + 4] = (byte)(n9 >> 8);
        this.contents[n + 5] = (byte)n9;
    }

    public void completeCodeAttributeForProblemMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, int n, int[] nArray, int n2) {
        int n3;
        this.contents = this.codeStream.bCodeStream;
        int n4 = this.codeStream.classFileOffset;
        int n5 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n5 >> 8);
        this.contents[n + 7] = (byte)n5;
        int n6 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n6 >> 8);
        this.contents[n + 9] = (byte)n6;
        int n7 = this.codeStream.position;
        this.contents[n + 10] = (byte)(n7 >> 24);
        this.contents[n + 11] = (byte)(n7 >> 16);
        this.contents[n + 12] = (byte)(n7 >> 8);
        this.contents[n + 13] = (byte)n7;
        if (n4 + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[n4++] = 0;
        this.contents[n4++] = 0;
        int n8 = n4;
        int n9 = 0;
        if ((n4 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contentsOffset = n4;
        if ((this.produceAttributes & 2) != 0) {
            if (n2 == 0) {
                n2 = Util.getLineNumber(methodBinding.sourceStart(), nArray, 0, nArray.length - 1);
            }
            n9 += this.generateLineNumberAttribute(n2);
        }
        if ((this.produceAttributes & 4) != 0) {
            n3 = this.codeStream.methodDeclaration.isStatic();
            n9 += this.generateLocalVariableTableAttribute(n7, n3 != 0, false);
        }
        if ((this.produceAttributes & 8) != 0) {
            n9 += this.generateStackMapTableAttribute(methodBinding, n7, n, n6, false);
        }
        if ((this.produceAttributes & 0x10) != 0) {
            n9 += this.generateStackMapAttribute(methodBinding, n7, n, n6, false);
        }
        if (n8 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n8++] = (byte)(n9 >> 8);
        this.contents[n8] = (byte)n9;
        n3 = this.contentsOffset - (n + 6);
        this.contents[n + 2] = (byte)(n3 >> 24);
        this.contents[n + 3] = (byte)(n3 >> 16);
        this.contents[n + 4] = (byte)(n3 >> 8);
        this.contents[n + 5] = (byte)n3;
    }

    public void completeCodeAttributeForSyntheticMethod(boolean bl, SyntheticMethodBinding syntheticMethodBinding, int n, int[] nArray) {
        int n2;
        int n3;
        boolean bl2;
        this.contents = this.codeStream.bCodeStream;
        int n4 = this.codeStream.classFileOffset;
        int n5 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n5 >> 8);
        this.contents[n + 7] = (byte)n5;
        int n6 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n6 >> 8);
        this.contents[n + 9] = (byte)n6;
        int n7 = this.codeStream.position;
        this.contents[n + 10] = (byte)(n7 >> 24);
        this.contents[n + 11] = (byte)(n7 >> 16);
        this.contents[n + 12] = (byte)(n7 >> 8);
        this.contents[n + 13] = (byte)n7;
        if (n4 + 40 >= this.contents.length) {
            this.resizeContents(40);
        }
        boolean bl3 = bl2 = (this.produceAttributes & 8) != 0;
        if (bl) {
            ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
            n3 = 0;
            n2 = 0;
            int n8 = this.codeStream.exceptionLabelsCounter;
            while (n2 < n8) {
                n3 += this.codeStream.exceptionLabels[n2].getCount() / 2;
                ++n2;
            }
            n2 = n3 * 8 + 2;
            if (n2 + n4 >= this.contents.length) {
                this.resizeContents(n2);
            }
            this.contents[n4++] = (byte)(n3 >> 8);
            this.contents[n4++] = (byte)n3;
            n8 = 0;
            int n9 = this.codeStream.exceptionLabelsCounter;
            while (n8 < n9) {
                ExceptionLabel exceptionLabel = exceptionLabelArray[n8];
                if (exceptionLabel != null) {
                    int n10 = 0;
                    int n11 = exceptionLabel.getCount();
                    if ((n11 & 1) != 0) {
                        this.referenceBinding.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(syntheticMethodBinding.selector), this.referenceBinding.scope.problemReporter().referenceContext));
                    }
                    while (n10 < n11) {
                        int n12;
                        int n13 = exceptionLabel.ranges[n10++];
                        this.contents[n4++] = (byte)(n13 >> 8);
                        this.contents[n4++] = (byte)n13;
                        int n14 = exceptionLabel.ranges[n10++];
                        this.contents[n4++] = (byte)(n14 >> 8);
                        this.contents[n4++] = (byte)n14;
                        int n15 = exceptionLabel.position;
                        if (bl2) {
                            StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
                            stackMapFrameCodeStream.addFramePosition(n15);
                        }
                        this.contents[n4++] = (byte)(n15 >> 8);
                        this.contents[n4++] = (byte)n15;
                        if (exceptionLabel.exceptionType == null) {
                            this.contents[n4++] = 0;
                            this.contents[n4++] = 0;
                            continue;
                        }
                        switch (exceptionLabel.exceptionType.id) {
                            case 12: {
                                n12 = this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName);
                                break;
                            }
                            case 7: {
                                n12 = this.constantPool.literalIndexForType(ConstantPool.JavaLangNoSuchFieldErrorConstantPoolName);
                                break;
                            }
                            default: {
                                n12 = this.constantPool.literalIndexForType(exceptionLabel.exceptionType);
                            }
                        }
                        this.contents[n4++] = (byte)(n12 >> 8);
                        this.contents[n4++] = (byte)n12;
                    }
                }
                ++n8;
            }
        } else {
            this.contents[n4++] = 0;
            this.contents[n4++] = 0;
        }
        int n16 = n4;
        n3 = 0;
        if ((n4 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contentsOffset = n4;
        if ((this.produceAttributes & 2) != 0) {
            n2 = Util.getLineNumber(syntheticMethodBinding.sourceStart, nArray, 0, nArray.length - 1);
            n3 += this.generateLineNumberAttribute(n2);
        }
        if ((this.produceAttributes & 4) != 0) {
            n2 = syntheticMethodBinding.isStatic() ? 1 : 0;
            n3 += this.generateLocalVariableTableAttribute(n7, n2 != 0, true);
        }
        if (bl2) {
            n3 += this.generateStackMapTableAttribute(syntheticMethodBinding, n7, n, n6, false);
        }
        if ((this.produceAttributes & 0x10) != 0) {
            n3 += this.generateStackMapAttribute(syntheticMethodBinding, n7, n, n6, false);
        }
        if (n16 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n16++] = (byte)(n3 >> 8);
        this.contents[n16] = (byte)n3;
        n2 = this.contentsOffset - (n + 6);
        this.contents[n + 2] = (byte)(n2 >> 24);
        this.contents[n + 3] = (byte)(n2 >> 16);
        this.contents[n + 4] = (byte)(n2 >> 8);
        this.contents[n + 5] = (byte)n2;
    }

    public void completeCodeAttributeForSyntheticMethod(SyntheticMethodBinding syntheticMethodBinding, int n, int[] nArray) {
        this.completeCodeAttributeForSyntheticMethod(false, syntheticMethodBinding, n, nArray);
    }

    private void completeArgumentAnnotationInfo(Argument[] argumentArray, List list) {
        int n = 0;
        int n2 = argumentArray.length;
        while (n < n2) {
            Argument argument = argumentArray[n];
            if ((argument.bits & 0x100000) != 0) {
                argument.getAllAnnotationContexts(22, n, list);
            }
            ++n;
        }
    }

    public void completeMethodInfo(MethodBinding methodBinding, int n, int n2) {
        if ((this.produceAttributes & 0x20) != 0) {
            int n3;
            AnnotationContext annotationContext;
            int n4;
            AnnotationContext[] annotationContextArray;
            Statement[] statementArray;
            ArrayList arrayList = new ArrayList();
            int n5 = 0;
            int n6 = 0;
            AbstractMethodDeclaration abstractMethodDeclaration = methodBinding.sourceMethod();
            if (abstractMethodDeclaration != null) {
                Object object;
                if ((abstractMethodDeclaration.bits & 0x100000) != 0) {
                    statementArray = abstractMethodDeclaration.arguments;
                    if (statementArray != null) {
                        this.completeArgumentAnnotationInfo((Argument[])statementArray, arrayList);
                    }
                    if ((annotationContextArray = abstractMethodDeclaration.receiver) != null && (annotationContextArray.type.bits & 0x100000) != 0) {
                        annotationContextArray.type.getAllAnnotationContexts(21, arrayList);
                    }
                }
                if ((statementArray = abstractMethodDeclaration.annotations) != null && !abstractMethodDeclaration.isClinit() && (abstractMethodDeclaration.isConstructor() || methodBinding.returnType.id != 6)) {
                    abstractMethodDeclaration.getAllAnnotationContexts(20, arrayList);
                }
                if (!abstractMethodDeclaration.isConstructor() && !abstractMethodDeclaration.isClinit() && methodBinding.returnType.id != 6) {
                    annotationContextArray = (MethodDeclaration)abstractMethodDeclaration;
                    object = annotationContextArray.returnType;
                    if ((((TypeReference)object).bits & 0x100000) != 0) {
                        ((TypeReference)object).getAllAnnotationContexts(20, arrayList);
                    }
                }
                if ((annotationContextArray = abstractMethodDeclaration.thrownExceptions) != null) {
                    int n7 = 0;
                    n4 = annotationContextArray.length;
                    while (n7 < n4) {
                        annotationContext = annotationContextArray[n7];
                        ((TypeReference)((Object)annotationContext)).getAllAnnotationContexts(23, n7, arrayList);
                        ++n7;
                    }
                }
                if ((object = abstractMethodDeclaration.typeParameters()) != null) {
                    n4 = 0;
                    int n8 = ((TypeParameter[])object).length;
                    while (n4 < n8) {
                        TypeParameter typeParameter = object[n4];
                        if ((typeParameter.bits & 0x100000) != 0) {
                            typeParameter.getAllAnnotationContexts(1, n4, arrayList);
                        }
                        ++n4;
                    }
                }
            } else if (methodBinding.sourceLambda() != null) {
                statementArray = methodBinding.sourceLambda();
                if ((statementArray.bits & 0x100000) != 0 && statementArray.arguments != null) {
                    this.completeArgumentAnnotationInfo(statementArray.arguments, arrayList);
                }
            }
            if ((n3 = arrayList.size()) != 0) {
                annotationContextArray = new AnnotationContext[n3];
                arrayList.toArray(annotationContextArray);
                int n9 = 0;
                n4 = annotationContextArray.length;
                while (n9 < n4) {
                    annotationContext = annotationContextArray[n9];
                    if ((annotationContext.visibility & 2) != 0) {
                        ++n5;
                    } else {
                        ++n6;
                    }
                    ++n9;
                }
                n2 += this.generateRuntimeTypeAnnotations(annotationContextArray, n6, n5);
            }
        }
        if ((this.produceAttributes & 0x40) != 0) {
            n2 += this.generateMethodParameters(methodBinding);
        }
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    private void dumpLocations(int[] nArray) {
        if (nArray == null) {
            if (this.contentsOffset + 1 >= this.contents.length) {
                this.resizeContents(1);
            }
            this.contents[this.contentsOffset++] = 0;
        } else {
            int n = nArray.length;
            if (this.contentsOffset + n >= this.contents.length) {
                this.resizeContents(n + 1);
            }
            this.contents[this.contentsOffset++] = (byte)(nArray.length / 2);
            int n2 = 0;
            while (n2 < n) {
                this.contents[this.contentsOffset++] = (byte)nArray[n2];
                ++n2;
            }
        }
    }

    private void dumpTargetTypeContents(int n, AnnotationContext annotationContext) {
        switch (n) {
            case 0: 
            case 1: {
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                break;
            }
            case 17: {
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                this.contents[this.contentsOffset++] = (byte)annotationContext.info2;
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.contents[this.contentsOffset++] = (byte)(annotationContext.info >> 8);
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                break;
            }
            case 71: {
                this.contents[this.contentsOffset++] = (byte)(annotationContext.info >> 8);
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                this.contents[this.contentsOffset++] = (byte)annotationContext.info2;
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                this.contents[this.contentsOffset++] = (byte)(annotationContext.info >> 8);
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                this.contents[this.contentsOffset++] = (byte)annotationContext.info2;
                break;
            }
            case 16: 
            case 23: {
                this.contents[this.contentsOffset++] = (byte)(annotationContext.info >> 8);
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                break;
            }
            case 64: 
            case 65: {
                int n2 = this.contentsOffset;
                LocalVariableBinding localVariableBinding = annotationContext.variableBinding;
                int n3 = 0;
                int n4 = localVariableBinding.initializationCount;
                if (this.contentsOffset + (n3 += 6 * n4) >= this.contents.length) {
                    this.resizeContents(n3);
                }
                this.contentsOffset += 2;
                int n5 = 0;
                int n6 = 0;
                while (n6 < n4) {
                    int n7 = localVariableBinding.initializationPCs[n6 << 1];
                    int n8 = localVariableBinding.initializationPCs[(n6 << 1) + 1];
                    if (n7 != n8) {
                        ++n5;
                        this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
                        this.contents[this.contentsOffset++] = (byte)n7;
                        int n9 = n8 - n7;
                        this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                        this.contents[this.contentsOffset++] = (byte)n9;
                        int n10 = localVariableBinding.resolvedPosition;
                        this.contents[this.contentsOffset++] = (byte)(n10 >> 8);
                        this.contents[this.contentsOffset++] = (byte)n10;
                    }
                    ++n6;
                }
                this.contents[n2++] = (byte)(n5 >> 8);
                this.contents[n2] = (byte)n5;
                break;
            }
            case 18: {
                this.contents[this.contentsOffset++] = (byte)annotationContext.info;
                this.contents[this.contentsOffset++] = (byte)annotationContext.info2;
            }
        }
    }

    public char[] fileName() {
        return this.constantPool.UTF8Cache.returnKeyFor(2);
    }

    private void generateAnnotation(Annotation annotation, int n) {
        TypeBinding typeBinding;
        int n2 = n;
        if (this.contentsOffset + 4 >= this.contents.length) {
            this.resizeContents(4);
        }
        if ((typeBinding = annotation.resolvedType) == null) {
            this.contentsOffset = n2;
            return;
        }
        if (typeBinding.isMemberType()) {
            this.recordInnerClasses(typeBinding);
        }
        int n3 = this.constantPool.literalIndex(typeBinding.signature());
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            MemberValuePair[] memberValuePairArray = normalAnnotation.memberValuePairs;
            int n4 = this.contentsOffset;
            if (memberValuePairArray != null) {
                int n5 = memberValuePairArray.length;
                this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
                this.contents[this.contentsOffset++] = (byte)n5;
                int n6 = 0;
                while (n6 < n5) {
                    block23: {
                        MemberValuePair memberValuePair = memberValuePairArray[n6];
                        if (this.contentsOffset + 2 >= this.contents.length) {
                            this.resizeContents(2);
                        }
                        int n7 = this.constantPool.literalIndex(memberValuePair.name);
                        this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
                        this.contents[this.contentsOffset++] = (byte)n7;
                        MethodBinding methodBinding = memberValuePair.binding;
                        if (methodBinding == null) {
                            this.contentsOffset = n2;
                        } else {
                            try {
                                this.generateElementValue(memberValuePair.value, methodBinding.returnType, n4);
                                if (this.contentsOffset != n4) break block23;
                                this.contents[this.contentsOffset++] = 0;
                                this.contents[this.contentsOffset++] = 0;
                                break;
                            }
                            catch (ClassCastException classCastException) {
                                this.contentsOffset = n2;
                            }
                            catch (ShouldNotImplement shouldNotImplement) {
                                this.contentsOffset = n2;
                            }
                        }
                    }
                    ++n6;
                }
            } else {
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
            }
        } else if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 1;
            if (this.contentsOffset + 2 >= this.contents.length) {
                this.resizeContents(2);
            }
            int n8 = this.constantPool.literalIndex(VALUE);
            this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
            this.contents[this.contentsOffset++] = (byte)n8;
            MethodBinding methodBinding = singleMemberAnnotation.memberValuePairs()[0].binding;
            if (methodBinding == null) {
                this.contentsOffset = n2;
            } else {
                int n9 = this.contentsOffset;
                try {
                    this.generateElementValue(singleMemberAnnotation.memberValue, methodBinding.returnType, n9);
                    if (this.contentsOffset == n9) {
                        this.contents[this.contentsOffset++] = 0;
                        this.contents[this.contentsOffset++] = 0;
                    }
                }
                catch (ClassCastException classCastException) {
                    this.contentsOffset = n2;
                }
                catch (ShouldNotImplement shouldNotImplement) {
                    this.contentsOffset = n2;
                }
            }
        } else {
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
        }
    }

    private int generateAnnotationDefaultAttribute(AnnotationMethodDeclaration annotationMethodDeclaration, int n) {
        int n2 = 0;
        int n3 = this.constantPool.literalIndex(AttributeNamesConstants.AnnotationDefaultName);
        if (this.contentsOffset + 6 >= this.contents.length) {
            this.resizeContents(6);
        }
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        int n4 = this.contentsOffset;
        this.contentsOffset += 4;
        this.generateElementValue(annotationMethodDeclaration.defaultValue, annotationMethodDeclaration.binding.returnType, n);
        if (this.contentsOffset != n) {
            int n5 = this.contentsOffset - n4 - 4;
            this.contents[n4++] = (byte)(n5 >> 24);
            this.contents[n4++] = (byte)(n5 >> 16);
            this.contents[n4++] = (byte)(n5 >> 8);
            this.contents[n4++] = (byte)n5;
            ++n2;
        }
        return n2;
    }

    public void generateCodeAttributeHeader() {
        if (this.contentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n = this.constantPool.literalIndex(AttributeNamesConstants.CodeName);
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        this.contentsOffset += 12;
    }

    private int generateConstantValueAttribute(Constant constant, FieldBinding fieldBinding, int n) {
        int n2 = this.contentsOffset;
        int n3 = 1;
        if (n2 + 8 >= this.contents.length) {
            this.resizeContents(8);
        }
        int n4 = this.constantPool.literalIndex(AttributeNamesConstants.ConstantValueName);
        this.contents[n2++] = (byte)(n4 >> 8);
        this.contents[n2++] = (byte)n4;
        this.contents[n2++] = 0;
        this.contents[n2++] = 0;
        this.contents[n2++] = 0;
        this.contents[n2++] = 2;
        switch (constant.typeID()) {
            case 5: {
                int n5 = this.constantPool.literalIndex(constant.booleanValue() ? 1 : 0);
                this.contents[n2++] = (byte)(n5 >> 8);
                this.contents[n2++] = (byte)n5;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                int n6 = this.constantPool.literalIndex(constant.intValue());
                this.contents[n2++] = (byte)(n6 >> 8);
                this.contents[n2++] = (byte)n6;
                break;
            }
            case 9: {
                int n7 = this.constantPool.literalIndex(constant.floatValue());
                this.contents[n2++] = (byte)(n7 >> 8);
                this.contents[n2++] = (byte)n7;
                break;
            }
            case 8: {
                int n8 = this.constantPool.literalIndex(constant.doubleValue());
                this.contents[n2++] = (byte)(n8 >> 8);
                this.contents[n2++] = (byte)n8;
                break;
            }
            case 7: {
                int n9 = this.constantPool.literalIndex(constant.longValue());
                this.contents[n2++] = (byte)(n9 >> 8);
                this.contents[n2++] = (byte)n9;
                break;
            }
            case 11: {
                int n10 = this.constantPool.literalIndex(((StringConstant)constant).stringValue());
                if (n10 == -1) {
                    if (!this.creatingProblemType) {
                        TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
                        FieldDeclaration[] fieldDeclarationArray = typeDeclaration.fields;
                        int n11 = fieldDeclarationArray == null ? 0 : fieldDeclarationArray.length;
                        int n12 = 0;
                        while (n12 < n11) {
                            if (fieldDeclarationArray[n12].binding == fieldBinding) {
                                typeDeclaration.scope.problemReporter().stringConstantIsExceedingUtf8Limit(fieldDeclarationArray[n12]);
                            }
                            ++n12;
                        }
                        break;
                    }
                    this.contentsOffset = n;
                    n3 = 0;
                    break;
                }
                this.contents[n2++] = (byte)(n10 >> 8);
                this.contents[n2++] = (byte)n10;
            }
        }
        this.contentsOffset = n2;
        return n3;
    }

    private int generateDeprecatedAttribute() {
        int n = this.contentsOffset;
        if (n + 6 >= this.contents.length) {
            this.resizeContents(6);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contentsOffset = n;
        return 1;
    }

    private void generateElementValue(Expression expression, TypeBinding typeBinding, int n) {
        Constant constant = expression.constant;
        TypeBinding typeBinding2 = expression.resolvedType;
        if (typeBinding2 == null) {
            this.contentsOffset = n;
        } else {
            if (typeBinding2.isMemberType()) {
                this.recordInnerClasses(typeBinding2);
            }
            if (typeBinding.isMemberType()) {
                this.recordInnerClasses(typeBinding);
            }
            if (typeBinding.isArrayType() && !typeBinding2.isArrayType()) {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 91;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 1;
            }
            if (constant != null && constant != Constant.NotAConstant) {
                this.generateElementValue(n, expression, constant, typeBinding.leafComponentType());
            } else {
                this.generateElementValueForNonConstantExpression(expression, n, typeBinding2);
            }
        }
    }

    private void generateElementValue(int n, Expression expression, Constant constant, TypeBinding typeBinding) {
        if (this.contentsOffset + 3 >= this.contents.length) {
            this.resizeContents(3);
        }
        switch (typeBinding.id) {
            case 5: {
                this.contents[this.contentsOffset++] = 90;
                int n2 = this.constantPool.literalIndex(constant.booleanValue() ? 1 : 0);
                this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
                this.contents[this.contentsOffset++] = (byte)n2;
                break;
            }
            case 3: {
                this.contents[this.contentsOffset++] = 66;
                int n3 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                this.contents[this.contentsOffset++] = (byte)n3;
                break;
            }
            case 2: {
                this.contents[this.contentsOffset++] = 67;
                int n4 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
                this.contents[this.contentsOffset++] = (byte)n4;
                break;
            }
            case 10: {
                this.contents[this.contentsOffset++] = 73;
                int n5 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
                this.contents[this.contentsOffset++] = (byte)n5;
                break;
            }
            case 4: {
                this.contents[this.contentsOffset++] = 83;
                int n6 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
                this.contents[this.contentsOffset++] = (byte)n6;
                break;
            }
            case 9: {
                this.contents[this.contentsOffset++] = 70;
                int n7 = this.constantPool.literalIndex(constant.floatValue());
                this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
                this.contents[this.contentsOffset++] = (byte)n7;
                break;
            }
            case 8: {
                this.contents[this.contentsOffset++] = 68;
                int n8 = this.constantPool.literalIndex(constant.doubleValue());
                this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
                this.contents[this.contentsOffset++] = (byte)n8;
                break;
            }
            case 7: {
                this.contents[this.contentsOffset++] = 74;
                int n9 = this.constantPool.literalIndex(constant.longValue());
                this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                this.contents[this.contentsOffset++] = (byte)n9;
                break;
            }
            case 11: {
                this.contents[this.contentsOffset++] = 115;
                int n10 = this.constantPool.literalIndex(((StringConstant)constant).stringValue().toCharArray());
                if (n10 == -1) {
                    if (!this.creatingProblemType) {
                        TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
                        typeDeclaration.scope.problemReporter().stringConstantIsExceedingUtf8Limit(expression);
                        break;
                    }
                    this.contentsOffset = n;
                    break;
                }
                this.contents[this.contentsOffset++] = (byte)(n10 >> 8);
                this.contents[this.contentsOffset++] = (byte)n10;
            }
        }
    }

    private void generateElementValueForNonConstantExpression(Expression expression, int n, TypeBinding typeBinding) {
        if (typeBinding != null) {
            if (typeBinding.isEnum()) {
                NameReference nameReference;
                if (this.contentsOffset + 5 >= this.contents.length) {
                    this.resizeContents(5);
                }
                this.contents[this.contentsOffset++] = 101;
                FieldBinding fieldBinding = null;
                if (expression instanceof QualifiedNameReference) {
                    nameReference = (QualifiedNameReference)expression;
                    fieldBinding = (FieldBinding)nameReference.binding;
                } else if (expression instanceof SingleNameReference) {
                    nameReference = (SingleNameReference)expression;
                    fieldBinding = (FieldBinding)((SingleNameReference)nameReference).binding;
                } else {
                    this.contentsOffset = n;
                }
                if (fieldBinding != null) {
                    int n2 = this.constantPool.literalIndex(fieldBinding.type.signature());
                    int n3 = this.constantPool.literalIndex(fieldBinding.name);
                    this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n2;
                    this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n3;
                }
            } else if (typeBinding.isAnnotationType()) {
                if (this.contentsOffset + 1 >= this.contents.length) {
                    this.resizeContents(1);
                }
                this.contents[this.contentsOffset++] = 64;
                this.generateAnnotation((Annotation)expression, n);
            } else if (typeBinding.isArrayType()) {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 91;
                if (expression instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                    int n4 = arrayInitializer.expressions != null ? arrayInitializer.expressions.length : 0;
                    this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n4;
                    int n5 = 0;
                    while (n5 < n4) {
                        this.generateElementValue(arrayInitializer.expressions[n5], typeBinding.leafComponentType(), n);
                        ++n5;
                    }
                } else {
                    this.contentsOffset = n;
                }
            } else {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 99;
                if (expression instanceof ClassLiteralAccess) {
                    ClassLiteralAccess classLiteralAccess = (ClassLiteralAccess)expression;
                    int n6 = this.constantPool.literalIndex(classLiteralAccess.targetType.signature());
                    this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n6;
                } else {
                    this.contentsOffset = n;
                }
            }
        } else {
            this.contentsOffset = n;
        }
    }

    private int generateEnclosingMethodAttribute() {
        MethodBinding methodBinding;
        int n = this.contentsOffset;
        if (n + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.EnclosingMethodName);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 4;
        int n3 = this.constantPool.literalIndexForType(this.referenceBinding.enclosingType().constantPoolName());
        this.contents[n++] = (byte)(n3 >> 8);
        this.contents[n++] = (byte)n3;
        byte by = 0;
        byte by2 = 0;
        if (this.referenceBinding instanceof LocalTypeBinding && (methodBinding = ((LocalTypeBinding)this.referenceBinding).enclosingMethod) != null) {
            int n4 = this.constantPool.literalIndexForNameAndType(methodBinding.selector, methodBinding.signature(this));
            by = (byte)(n4 >> 8);
            by2 = (byte)n4;
        }
        this.contents[n++] = by;
        this.contents[n++] = by2;
        this.contentsOffset = n;
        return 1;
    }

    private int generateExceptionsAttribute(ReferenceBinding[] referenceBindingArray) {
        int n = this.contentsOffset;
        int n2 = referenceBindingArray.length;
        int n3 = 8 + n2 * 2;
        if (n3 + this.contentsOffset >= this.contents.length) {
            this.resizeContents(n3);
        }
        int n4 = this.constantPool.literalIndex(AttributeNamesConstants.ExceptionsName);
        this.contents[n++] = (byte)(n4 >> 8);
        this.contents[n++] = (byte)n4;
        int n5 = n2 * 2 + 2;
        this.contents[n++] = (byte)(n5 >> 24);
        this.contents[n++] = (byte)(n5 >> 16);
        this.contents[n++] = (byte)(n5 >> 8);
        this.contents[n++] = (byte)n5;
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = this.constantPool.literalIndexForType(referenceBindingArray[n6]);
            this.contents[n++] = (byte)(n7 >> 8);
            this.contents[n++] = (byte)n7;
            ++n6;
        }
        this.contentsOffset = n;
        return 1;
    }

    private int generateHierarchyInconsistentAttribute() {
        int n = this.contentsOffset;
        if (n + 6 >= this.contents.length) {
            this.resizeContents(6);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.InconsistentHierarchy);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contentsOffset = n;
        return 1;
    }

    private int generateInnerClassAttribute(int n, ReferenceBinding[] referenceBindingArray) {
        int n2 = 8 * n + 8;
        int n3 = this.contentsOffset;
        if (n2 + n3 >= this.contents.length) {
            this.resizeContents(n2);
        }
        int n4 = this.constantPool.literalIndex(AttributeNamesConstants.InnerClassName);
        this.contents[n3++] = (byte)(n4 >> 8);
        this.contents[n3++] = (byte)n4;
        int n5 = (n << 3) + 2;
        this.contents[n3++] = (byte)(n5 >> 24);
        this.contents[n3++] = (byte)(n5 >> 16);
        this.contents[n3++] = (byte)(n5 >> 8);
        this.contents[n3++] = (byte)n5;
        this.contents[n3++] = (byte)(n >> 8);
        this.contents[n3++] = (byte)n;
        int n6 = 0;
        while (n6 < n) {
            int n7;
            ReferenceBinding referenceBinding = referenceBindingArray[n6];
            int n8 = referenceBinding.getAccessFlags();
            int n9 = this.constantPool.literalIndexForType(referenceBinding.constantPoolName());
            this.contents[n3++] = (byte)(n9 >> 8);
            this.contents[n3++] = (byte)n9;
            if (referenceBinding.isMemberType()) {
                n7 = this.constantPool.literalIndexForType(referenceBinding.enclosingType().constantPoolName());
                this.contents[n3++] = (byte)(n7 >> 8);
                this.contents[n3++] = (byte)n7;
            } else {
                this.contents[n3++] = 0;
                this.contents[n3++] = 0;
            }
            if (!referenceBinding.isAnonymousType()) {
                n7 = this.constantPool.literalIndex(referenceBinding.sourceName());
                this.contents[n3++] = (byte)(n7 >> 8);
                this.contents[n3++] = (byte)n7;
            } else {
                this.contents[n3++] = 0;
                this.contents[n3++] = 0;
            }
            if (referenceBinding.isAnonymousType()) {
                n8 &= 0xFFFFFFEF;
            } else if (referenceBinding.isMemberType() && referenceBinding.isInterface()) {
                n8 |= 8;
            }
            this.contents[n3++] = (byte)(n8 >> 8);
            this.contents[n3++] = (byte)n8;
            ++n6;
        }
        this.contentsOffset = n3;
        return 1;
    }

    private int generateBootstrapMethods(List list) {
        ReferenceBinding referenceBinding = this.referenceBinding.scope.getJavaLangInvokeMethodHandlesLookup();
        if (referenceBinding == null) {
            return 0;
        }
        this.recordInnerClasses(referenceBinding);
        ReferenceBinding referenceBinding2 = this.referenceBinding.scope.getJavaLangInvokeLambdaMetafactory();
        int n = 0;
        int n2 = 0;
        int n3 = list.size();
        int n4 = this.contentsOffset;
        int n5 = 10 * n3 + 8;
        if (n5 + n4 >= this.contents.length) {
            this.resizeContents(n5);
        }
        int n6 = this.constantPool.literalIndex(AttributeNamesConstants.BootstrapMethodsName);
        this.contents[n4++] = (byte)(n6 >> 8);
        this.contents[n4++] = (byte)n6;
        int n7 = n4;
        n4 += 4;
        this.contents[n4++] = (byte)(n3 >> 8);
        this.contents[n4++] = (byte)n3;
        int n8 = 0;
        while (n8 < n3) {
            int n9;
            int n10;
            FunctionalExpression functionalExpression = (FunctionalExpression)list.get(n8);
            MethodBinding[] methodBindingArray = functionalExpression.getRequiredBridges();
            TypeBinding[] typeBindingArray = null;
            if (functionalExpression instanceof LambdaExpression && ((typeBindingArray = ((LambdaExpression)functionalExpression).getMarkerInterfaces()) != null || ((LambdaExpression)functionalExpression).isSerializable) || methodBindingArray != null) {
                int n11;
                int n12;
                int n13;
                LambdaExpression lambdaExpression = (LambdaExpression)functionalExpression;
                n10 = 2;
                if (typeBindingArray != null) {
                    n10 += 2 + 2 * typeBindingArray.length;
                }
                if (methodBindingArray != null) {
                    n10 += 2 + 2 * methodBindingArray.length;
                }
                if (n10 + n4 >= this.contents.length) {
                    this.resizeContents(n10);
                }
                if (n2 == 0) {
                    n2 = this.constantPool.literalIndexForMethodHandle(6, referenceBinding2, ConstantPool.ALTMETAFACTORY, ConstantPool.JAVA_LANG_INVOKE_LAMBDAMETAFACTORY_ALTMETAFACTORY_SIGNATURE, false);
                }
                this.contents[n4++] = (byte)(n2 >> 8);
                this.contents[n4++] = (byte)n2;
                this.contents[n4++] = 0;
                this.contents[n4++] = (byte)(4 + (typeBindingArray == null ? 0 : 1 + typeBindingArray.length) + (methodBindingArray == null ? 0 : 1 + methodBindingArray.length));
                int n14 = this.constantPool.literalIndexForMethodType(functionalExpression.descriptor.original().signature());
                this.contents[n4++] = (byte)(n14 >> 8);
                this.contents[n4++] = (byte)n14;
                n9 = this.constantPool.literalIndexForMethodHandle(functionalExpression.binding.original());
                this.contents[n4++] = (byte)(n9 >> 8);
                this.contents[n4++] = (byte)n9;
                char[] cArray = functionalExpression.descriptor.signature();
                int n15 = this.constantPool.literalIndexForMethodType(cArray);
                this.contents[n4++] = (byte)(n15 >> 8);
                this.contents[n4++] = (byte)n15;
                int n16 = 0;
                if (lambdaExpression.isSerializable) {
                    n16 |= 1;
                }
                if (typeBindingArray != null) {
                    n16 |= 2;
                }
                if (methodBindingArray != null) {
                    n16 |= 4;
                }
                int n17 = this.constantPool.literalIndex(n16);
                this.contents[n4++] = (byte)(n17 >> 8);
                this.contents[n4++] = (byte)n17;
                if (typeBindingArray != null) {
                    n13 = this.constantPool.literalIndex(typeBindingArray.length);
                    this.contents[n4++] = (byte)(n13 >> 8);
                    this.contents[n4++] = (byte)n13;
                    n12 = 0;
                    n11 = typeBindingArray.length;
                    while (n12 < n11) {
                        int n18 = this.constantPool.literalIndexForType(typeBindingArray[n12]);
                        this.contents[n4++] = (byte)(n18 >> 8);
                        this.contents[n4++] = (byte)n18;
                        ++n12;
                    }
                }
                if (methodBindingArray != null) {
                    n13 = this.constantPool.literalIndex(methodBindingArray.length);
                    this.contents[n4++] = (byte)(n13 >> 8);
                    this.contents[n4++] = (byte)n13;
                    n12 = 0;
                    n11 = methodBindingArray.length;
                    while (n12 < n11) {
                        char[] cArray2 = methodBindingArray[n12].signature();
                        int n19 = this.constantPool.literalIndexForMethodType(cArray2);
                        this.contents[n4++] = (byte)(n19 >> 8);
                        this.contents[n4++] = (byte)n19;
                        ++n12;
                    }
                }
            } else {
                if (n == 0) {
                    n = this.constantPool.literalIndexForMethodHandle(6, referenceBinding2, ConstantPool.METAFACTORY, ConstantPool.JAVA_LANG_INVOKE_LAMBDAMETAFACTORY_METAFACTORY_SIGNATURE, false);
                }
                this.contents[n4++] = (byte)(n >> 8);
                this.contents[n4++] = (byte)n;
                this.contents[n4++] = 0;
                this.contents[n4++] = 3;
                int n20 = this.constantPool.literalIndexForMethodType(functionalExpression.descriptor.original().signature());
                this.contents[n4++] = (byte)(n20 >> 8);
                this.contents[n4++] = (byte)n20;
                n10 = this.constantPool.literalIndexForMethodHandle(functionalExpression.binding.original());
                this.contents[n4++] = (byte)(n10 >> 8);
                this.contents[n4++] = (byte)n10;
                char[] cArray = functionalExpression.descriptor.signature();
                n9 = this.constantPool.literalIndexForMethodType(cArray);
                this.contents[n4++] = (byte)(n9 >> 8);
                this.contents[n4++] = (byte)n9;
            }
            ++n8;
        }
        n8 = n4 - n7 - 4;
        this.contents[n7++] = (byte)(n8 >> 24);
        this.contents[n7++] = (byte)(n8 >> 16);
        this.contents[n7++] = (byte)(n8 >> 8);
        this.contents[n7++] = (byte)n8;
        this.contentsOffset = n4;
        return 1;
    }

    private int generateLineNumberAttribute() {
        int n = this.contentsOffset;
        int n2 = 0;
        int[] nArray = this.codeStream.pcToSourceMap;
        if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
            int n3 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            if (n + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[n++] = (byte)(n3 >> 8);
            this.contents[n++] = (byte)n3;
            int n4 = n;
            n += 6;
            int n5 = 0;
            int n6 = this.codeStream.pcToSourceMapSize;
            int n7 = 0;
            while (n7 < n6) {
                if (n + 4 >= this.contents.length) {
                    this.resizeContents(4);
                }
                int n8 = nArray[n7++];
                this.contents[n++] = (byte)(n8 >> 8);
                this.contents[n++] = (byte)n8;
                int n9 = nArray[n7++];
                this.contents[n++] = (byte)(n9 >> 8);
                this.contents[n++] = (byte)n9;
                ++n5;
            }
            n7 = n5 * 4 + 2;
            this.contents[n4++] = (byte)(n7 >> 24);
            this.contents[n4++] = (byte)(n7 >> 16);
            this.contents[n4++] = (byte)(n7 >> 8);
            this.contents[n4++] = (byte)n7;
            this.contents[n4++] = (byte)(n5 >> 8);
            this.contents[n4++] = (byte)n5;
            n2 = 1;
        }
        this.contentsOffset = n;
        return n2;
    }

    private int generateLineNumberAttribute(int n) {
        int n2 = this.contentsOffset;
        if (n2 + 12 >= this.contents.length) {
            this.resizeContents(12);
        }
        int n3 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
        this.contents[n2++] = (byte)(n3 >> 8);
        this.contents[n2++] = (byte)n3;
        this.contents[n2++] = 0;
        this.contents[n2++] = 0;
        this.contents[n2++] = 0;
        this.contents[n2++] = 6;
        this.contents[n2++] = 0;
        this.contents[n2++] = 1;
        this.contents[n2++] = 0;
        this.contents[n2++] = 0;
        this.contents[n2++] = (byte)(n >> 8);
        this.contents[n2++] = (byte)n;
        this.contentsOffset = n2;
        return 1;
    }

    private int generateLocalVariableTableAttribute(int n, boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Binding binding;
        int n7;
        int n8;
        int n9 = 0;
        int n10 = this.contentsOffset;
        int n11 = 0;
        int n12 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
        int n13 = 8 + 10 * (bl ? 0 : 1);
        int n14 = 0;
        while (n14 < this.codeStream.allLocalsCounter) {
            LocalVariableBinding localVariableBinding = this.codeStream.locals[n14];
            n13 += 10 * localVariableBinding.initializationCount;
            ++n14;
        }
        if (n10 + n13 >= this.contents.length) {
            this.resizeContents(n13);
        }
        this.contents[n10++] = (byte)(n12 >> 8);
        this.contents[n10++] = (byte)n12;
        n14 = n10;
        n10 += 6;
        SourceTypeBinding sourceTypeBinding = null;
        if (!bl && !bl2) {
            ++n11;
            this.contents[n10++] = 0;
            this.contents[n10++] = 0;
            this.contents[n10++] = (byte)(n >> 8);
            this.contents[n10++] = (byte)n;
            int n15 = this.constantPool.literalIndex(ConstantPool.This);
            this.contents[n10++] = (byte)(n15 >> 8);
            this.contents[n10++] = (byte)n15;
            sourceTypeBinding = (SourceTypeBinding)(this.codeStream.methodDeclaration != null ? this.codeStream.methodDeclaration.binding.declaringClass : this.codeStream.lambdaExpression.binding.declaringClass);
            n8 = this.constantPool.literalIndex(sourceTypeBinding.signature());
            this.contents[n10++] = (byte)(n8 >> 8);
            this.contents[n10++] = (byte)n8;
            this.contents[n10++] = 0;
            this.contents[n10++] = 0;
        }
        int n16 = 0;
        LocalVariableBinding[] localVariableBindingArray = null;
        int n17 = 0;
        int n18 = 0;
        int n19 = this.codeStream.allLocalsCounter;
        while (n18 < n19) {
            LocalVariableBinding localVariableBinding = this.codeStream.locals[n18];
            n7 = localVariableBinding.initializationCount;
            if (n7 != 0 && localVariableBinding.declaration != null) {
                binding = localVariableBinding.type;
                int n20 = n6 = !binding.isParameterizedType() && !binding.isTypeVariable() ? 0 : 1;
                if (n6 != 0) {
                    if (localVariableBindingArray == null) {
                        localVariableBindingArray = new LocalVariableBinding[n19];
                    }
                    localVariableBindingArray[n16++] = localVariableBinding;
                }
                n5 = 0;
                while (n5 < n7) {
                    n4 = localVariableBinding.initializationPCs[n5 << 1];
                    n3 = localVariableBinding.initializationPCs[(n5 << 1) + 1];
                    if (n4 != n3) {
                        if (n3 == -1) {
                            localVariableBinding.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(localVariableBinding.name)), (ASTNode)((Object)localVariableBinding.declaringScope.methodScope().referenceContext));
                        }
                        if (n6 != 0) {
                            ++n17;
                        }
                        ++n11;
                        this.contents[n10++] = (byte)(n4 >> 8);
                        this.contents[n10++] = (byte)n4;
                        n2 = n3 - n4;
                        this.contents[n10++] = (byte)(n2 >> 8);
                        this.contents[n10++] = (byte)n2;
                        int n21 = this.constantPool.literalIndex(localVariableBinding.name);
                        this.contents[n10++] = (byte)(n21 >> 8);
                        this.contents[n10++] = (byte)n21;
                        n8 = this.constantPool.literalIndex(binding.signature());
                        this.contents[n10++] = (byte)(n8 >> 8);
                        this.contents[n10++] = (byte)n8;
                        int n22 = localVariableBinding.resolvedPosition;
                        this.contents[n10++] = (byte)(n22 >> 8);
                        this.contents[n10++] = (byte)n22;
                    }
                    ++n5;
                }
            }
            ++n18;
        }
        n18 = n11 * 10 + 2;
        this.contents[n14++] = (byte)(n18 >> 24);
        this.contents[n14++] = (byte)(n18 >> 16);
        this.contents[n14++] = (byte)(n18 >> 8);
        this.contents[n14++] = (byte)n18;
        this.contents[n14++] = (byte)(n11 >> 8);
        this.contents[n14] = (byte)n11;
        ++n9;
        int n23 = n19 = !bl && sourceTypeBinding != null && sourceTypeBinding.typeVariables != Binding.NO_TYPE_VARIABLES ? 1 : 0;
        if (n16 != 0 || n19 != 0) {
            n13 = 8 + (n17 += n19 != 0 ? 1 : 0) * 10;
            if (n10 + n13 >= this.contents.length) {
                this.resizeContents(n13);
            }
            int n24 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
            this.contents[n10++] = (byte)(n24 >> 8);
            this.contents[n10++] = (byte)n24;
            n18 = n17 * 10 + 2;
            this.contents[n10++] = (byte)(n18 >> 24);
            this.contents[n10++] = (byte)(n18 >> 16);
            this.contents[n10++] = (byte)(n18 >> 8);
            this.contents[n10++] = (byte)n18;
            this.contents[n10++] = (byte)(n17 >> 8);
            this.contents[n10++] = (byte)n17;
            if (n19 != 0) {
                this.contents[n10++] = 0;
                this.contents[n10++] = 0;
                this.contents[n10++] = (byte)(n >> 8);
                this.contents[n10++] = (byte)n;
                int n25 = this.constantPool.literalIndex(ConstantPool.This);
                this.contents[n10++] = (byte)(n25 >> 8);
                this.contents[n10++] = (byte)n25;
                n8 = this.constantPool.literalIndex(sourceTypeBinding.genericTypeSignature());
                this.contents[n10++] = (byte)(n8 >> 8);
                this.contents[n10++] = (byte)n8;
                this.contents[n10++] = 0;
                this.contents[n10++] = 0;
            }
            n7 = 0;
            while (n7 < n16) {
                binding = localVariableBindingArray[n7];
                n6 = 0;
                while (n6 < ((LocalVariableBinding)binding).initializationCount) {
                    n5 = ((LocalVariableBinding)binding).initializationPCs[n6 << 1];
                    n4 = ((LocalVariableBinding)binding).initializationPCs[(n6 << 1) + 1];
                    if (n5 != n4) {
                        this.contents[n10++] = (byte)(n5 >> 8);
                        this.contents[n10++] = (byte)n5;
                        n3 = n4 - n5;
                        this.contents[n10++] = (byte)(n3 >> 8);
                        this.contents[n10++] = (byte)n3;
                        int n26 = this.constantPool.literalIndex(((LocalVariableBinding)binding).name);
                        this.contents[n10++] = (byte)(n26 >> 8);
                        this.contents[n10++] = (byte)n26;
                        n8 = this.constantPool.literalIndex(((LocalVariableBinding)binding).type.genericTypeSignature());
                        this.contents[n10++] = (byte)(n8 >> 8);
                        this.contents[n10++] = (byte)n8;
                        n2 = ((LocalVariableBinding)binding).resolvedPosition;
                        this.contents[n10++] = (byte)(n2 >> 8);
                        this.contents[n10++] = (byte)n2;
                    }
                    ++n6;
                }
                ++n7;
            }
            ++n9;
        }
        this.contentsOffset = n10;
        return n9;
    }

    public int generateMethodInfoAttributes(MethodBinding methodBinding) {
        char[] cArray;
        this.contentsOffset += 2;
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        int n = 0;
        ReferenceBinding[] referenceBindingArray = methodBinding.thrownExceptions;
        if (methodBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
            n += this.generateExceptionsAttribute(referenceBindingArray);
        }
        if (methodBinding.isDeprecated()) {
            n += this.generateDeprecatedAttribute();
        }
        if (this.targetJDK < 0x310000L) {
            if (methodBinding.isSynthetic()) {
                n += this.generateSyntheticAttribute();
            }
            if (methodBinding.isVarargs()) {
                n += this.generateVarargsAttribute();
            }
        }
        if ((cArray = methodBinding.genericSignature()) != null) {
            n += this.generateSignatureAttribute(cArray);
        }
        if (this.targetJDK >= 0x300000L) {
            Object object;
            AbstractMethodDeclaration abstractMethodDeclaration = methodBinding.sourceMethod();
            if (methodBinding instanceof SyntheticMethodBinding) {
                object = (Annotation[])methodBinding;
                if (object.purpose == 7 && CharOperation.equals(object.selector, object.targetMethod.selector)) {
                    abstractMethodDeclaration = ((SyntheticMethodBinding)methodBinding).targetMethod.sourceMethod();
                }
            }
            if (abstractMethodDeclaration != null) {
                Argument[] argumentArray;
                object = abstractMethodDeclaration.annotations;
                if (object != null) {
                    n += this.generateRuntimeAnnotations((Annotation[])object, methodBinding.isConstructor() ? 0x10000000000L : 0x4000000000L);
                }
                if ((methodBinding.tagBits & 0x400L) != 0L && (argumentArray = abstractMethodDeclaration.arguments) != null) {
                    n += this.generateRuntimeAnnotationsForParameters(argumentArray);
                }
            } else {
                Argument[] argumentArray;
                object = methodBinding.sourceLambda();
                if (object != null && (methodBinding.tagBits & 0x400L) != 0L && (argumentArray = object.arguments()) != null) {
                    int n2 = methodBinding.parameters.length;
                    int n3 = argumentArray.length;
                    if (n2 > n3) {
                        int n4 = n2 - n3;
                        Argument[] argumentArray2 = argumentArray;
                        argumentArray = new Argument[n2];
                        System.arraycopy(argumentArray2, 0, argumentArray, n4, n3);
                        int n5 = 0;
                        while (n5 < n4) {
                            argumentArray[n5] = new Argument(CharOperation.NO_CHAR, 0L, null, 0);
                            ++n5;
                        }
                    }
                    n += this.generateRuntimeAnnotationsForParameters(argumentArray);
                }
            }
        }
        if ((methodBinding.tagBits & 0x80L) != 0L) {
            this.missingTypes = methodBinding.collectMissingTypes(this.missingTypes);
        }
        return n;
    }

    public int generateMethodInfoAttributes(MethodBinding methodBinding, AnnotationMethodDeclaration annotationMethodDeclaration) {
        int n = this.generateMethodInfoAttributes(methodBinding);
        int n2 = this.contentsOffset;
        if ((annotationMethodDeclaration.modifiers & 0x20000) != 0) {
            n += this.generateAnnotationDefaultAttribute(annotationMethodDeclaration, n2);
        }
        return n;
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers);
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding, int n) {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        if (this.targetJDK < 0x310000L) {
            n &= 0xFFFFEF7F;
        }
        if ((methodBinding.tagBits & 0x200L) != 0L) {
            n &= 0xFFFFFFFD;
        }
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(methodBinding.selector);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        int n3 = this.constantPool.literalIndex(methodBinding.signature(this));
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
    }

    public void addSyntheticDeserializeLambda(SyntheticMethodBinding syntheticMethodBinding, SyntheticMethodBinding[] syntheticMethodBindingArray) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttributes(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        ++n2;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForDeserializeLambda(syntheticMethodBinding, syntheticMethodBindingArray);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        if ((this.produceAttributes & 0x40) != 0) {
            n2 += this.generateMethodParameters(syntheticMethodBinding);
        }
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void generateMethodInfoHeaderForClinit() {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 8;
        int n = this.constantPool.literalIndex(ConstantPool.Clinit);
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(ConstantPool.ClinitSignature);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 1;
    }

    public void generateMissingAbstractMethods(MethodDeclaration[] methodDeclarationArray, CompilationResult compilationResult) {
        if (methodDeclarationArray != null) {
            TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
            int n = typeDeclaration.sourceStart();
            int n2 = typeDeclaration.sourceEnd();
            int n3 = 0;
            int n4 = methodDeclarationArray.length;
            while (n3 < n4) {
                MethodDeclaration methodDeclaration = methodDeclarationArray[n3];
                MethodBinding methodBinding = methodDeclaration.binding;
                String string = new String(methodBinding.readableName());
                CategorizedProblem[] categorizedProblemArray = compilationResult.problems;
                int n5 = compilationResult.problemCount;
                int n6 = 0;
                while (n6 < n5) {
                    CategorizedProblem categorizedProblem = categorizedProblemArray[n6];
                    if (categorizedProblem != null && categorizedProblem.getID() == 67109264 && categorizedProblem.getMessage().indexOf(string) != -1 && categorizedProblem.getSourceStart() >= n && categorizedProblem.getSourceEnd() <= n2) {
                        this.addMissingAbstractProblemMethod(methodDeclaration, methodBinding, categorizedProblem, compilationResult);
                    }
                    ++n6;
                }
                ++n3;
            }
        }
    }

    private void generateMissingTypesAttribute() {
        int n;
        int n2 = this.missingTypes.size();
        int[] nArray = new int[n2];
        int n3 = 0;
        if (n2 > 1) {
            Collections.sort(this.missingTypes, new Comparator(){

                public int compare(Object object, Object object2) {
                    TypeBinding typeBinding = (TypeBinding)object;
                    TypeBinding typeBinding2 = (TypeBinding)object2;
                    return CharOperation.compareTo(typeBinding.constantPoolName(), typeBinding2.constantPoolName());
                }
            });
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            n = this.constantPool.literalIndexForType((TypeBinding)this.missingTypes.get(n5));
            if (n4 != n) {
                n4 = n;
                nArray[n3++] = n;
            }
            ++n5;
        }
        n5 = n3 * 2 + 2;
        if (this.contentsOffset + n5 + 6 >= this.contents.length) {
            this.resizeContents(n5 + 6);
        }
        n = this.constantPool.literalIndex(AttributeNamesConstants.MissingTypesName);
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        this.contents[this.contentsOffset++] = (byte)(n5 >> 24);
        this.contents[this.contentsOffset++] = (byte)(n5 >> 16);
        this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
        this.contents[this.contentsOffset++] = (byte)n5;
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        int n6 = 0;
        while (n6 < n3) {
            int n7 = nArray[n6];
            this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
            this.contents[this.contentsOffset++] = (byte)n7;
            ++n6;
        }
    }

    private int generateRuntimeAnnotations(Annotation[] annotationArray, long l) {
        int n;
        long l2;
        Annotation annotation;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        int n8 = annotationArray.length;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n8) {
            Annotation annotation2 = annotationArray[n11].getPersistibleAnnotation();
            if (annotation2 != null) {
                long l3;
                long l4 = l3 = annotation2.resolvedType != null ? annotation2.resolvedType.getAnnotationTagBits() & 0x600FF800000000L : 0L;
                if (l3 == 0L || (l3 & l) != 0L) {
                    if (annotation2.isRuntimeInvisible() || annotation2.isRuntimeTypeInvisible()) {
                        ++n10;
                    } else if (annotation2.isRuntimeVisible() || annotation2.isRuntimeTypeVisible()) {
                        ++n9;
                    }
                }
            }
            ++n11;
        }
        n11 = this.contentsOffset;
        int n12 = this.constantPool.currentOffset;
        int n13 = this.constantPool.currentIndex;
        if (n10 != 0) {
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            n6 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
            this.contents[this.contentsOffset++] = (byte)n6;
            n5 = this.contentsOffset;
            this.contentsOffset += 4;
            n4 = this.contentsOffset;
            this.contentsOffset += 2;
            n3 = 0;
            n2 = 0;
            while (n2 < n8) {
                if (n10 == 0) break;
                annotation = annotationArray[n2].getPersistibleAnnotation();
                if (annotation != null) {
                    long l5 = l2 = annotation.resolvedType != null ? annotation.resolvedType.getAnnotationTagBits() & 0x600FF800000000L : 0L;
                    if ((l2 == 0L || (l2 & l) != 0L) && (annotation.isRuntimeInvisible() || annotation.isRuntimeTypeInvisible())) {
                        n = this.contentsOffset;
                        this.generateAnnotation(annotation, n);
                        --n10;
                        if (this.contentsOffset != n) {
                            ++n3;
                        }
                    }
                }
                ++n2;
            }
            if (n3 != 0) {
                this.contents[n4++] = (byte)(n3 >> 8);
                this.contents[n4++] = (byte)n3;
                n2 = this.contentsOffset - n5 - 4;
                this.contents[n5++] = (byte)(n2 >> 24);
                this.contents[n5++] = (byte)(n2 >> 16);
                this.contents[n5++] = (byte)(n2 >> 8);
                this.contents[n5++] = (byte)n2;
                ++n7;
            } else {
                this.contentsOffset = n11;
                this.constantPool.resetForAttributeName(AttributeNamesConstants.RuntimeInvisibleAnnotationsName, n13, n12);
            }
        }
        n11 = this.contentsOffset;
        n12 = this.constantPool.currentOffset;
        n13 = this.constantPool.currentIndex;
        if (n9 != 0) {
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            n6 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
            this.contents[this.contentsOffset++] = (byte)n6;
            n5 = this.contentsOffset;
            this.contentsOffset += 4;
            n4 = this.contentsOffset;
            this.contentsOffset += 2;
            n3 = 0;
            n2 = 0;
            while (n2 < n8) {
                if (n9 == 0) break;
                annotation = annotationArray[n2].getPersistibleAnnotation();
                if (annotation != null) {
                    long l6 = l2 = annotation.resolvedType != null ? annotation.resolvedType.getAnnotationTagBits() & 0x600FF800000000L : 0L;
                    if ((l2 == 0L || (l2 & l) != 0L) && (annotation.isRuntimeVisible() || annotation.isRuntimeTypeVisible())) {
                        --n9;
                        n = this.contentsOffset;
                        this.generateAnnotation(annotation, n);
                        if (this.contentsOffset != n) {
                            ++n3;
                        }
                    }
                }
                ++n2;
            }
            if (n3 != 0) {
                this.contents[n4++] = (byte)(n3 >> 8);
                this.contents[n4++] = (byte)n3;
                n2 = this.contentsOffset - n5 - 4;
                this.contents[n5++] = (byte)(n2 >> 24);
                this.contents[n5++] = (byte)(n2 >> 16);
                this.contents[n5++] = (byte)(n2 >> 8);
                this.contents[n5++] = (byte)n2;
                ++n7;
            } else {
                this.contentsOffset = n11;
                this.constantPool.resetForAttributeName(AttributeNamesConstants.RuntimeVisibleAnnotationsName, n13, n12);
            }
        }
        return n7;
    }

    private int generateRuntimeAnnotationsForParameters(Argument[] argumentArray) {
        int n;
        long l;
        Annotation annotation;
        int n2;
        int n3;
        Annotation[] annotationArray;
        Argument argument;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = argumentArray.length;
        int n9 = 0;
        int n10 = 0;
        int[][] nArray = new int[n8][2];
        int n11 = 0;
        while (n11 < n8) {
            Argument argument2 = argumentArray[n11];
            Annotation[] annotationArray2 = argument2.annotations;
            if (annotationArray2 != null) {
                n7 = 0;
                n6 = annotationArray2.length;
                while (n7 < n6) {
                    Annotation annotation2 = annotationArray2[n7].getPersistibleAnnotation();
                    if (annotation2 != null) {
                        long l2;
                        long l3 = l2 = annotation2.resolvedType != null ? annotation2.resolvedType.getAnnotationTagBits() & 0x600FF800000000L : 0L;
                        if (l2 == 0L || (l2 & 0x8000000000L) != 0L) {
                            if (annotation2.isRuntimeInvisible()) {
                                int[] nArray2 = nArray[n11];
                                nArray2[1] = nArray2[1] + 1;
                                ++n9;
                            } else if (annotation2.isRuntimeVisible()) {
                                int[] nArray3 = nArray[n11];
                                nArray3[0] = nArray3[0] + 1;
                                ++n10;
                            }
                        }
                    }
                    ++n7;
                }
            }
            ++n11;
        }
        n11 = 0;
        int n12 = this.contentsOffset;
        if (n9 != 0) {
            int n13 = 0;
            if (this.contentsOffset + 7 >= this.contents.length) {
                this.resizeContents(7);
            }
            n7 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleParameterAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
            this.contents[this.contentsOffset++] = (byte)n7;
            n6 = this.contentsOffset;
            this.contentsOffset += 4;
            this.contents[this.contentsOffset++] = (byte)n8;
            int n14 = 0;
            while (n14 < n8) {
                if (this.contentsOffset + 2 >= this.contents.length) {
                    this.resizeContents(2);
                }
                if (n9 == 0) {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                } else {
                    int n15 = nArray[n14][1];
                    n5 = this.contentsOffset;
                    this.contentsOffset += 2;
                    n4 = 0;
                    if (n15 != 0) {
                        argument = argumentArray[n14];
                        annotationArray = argument.annotations;
                        n3 = 0;
                        n2 = annotationArray.length;
                        while (n3 < n2) {
                            annotation = annotationArray[n3].getPersistibleAnnotation();
                            if (annotation != null) {
                                long l4 = l = annotation.resolvedType != null ? annotation.resolvedType.getAnnotationTagBits() & 0x600FF800000000L : 0L;
                                if ((l == 0L || (l & 0x8000000000L) != 0L) && annotation.isRuntimeInvisible()) {
                                    n = this.contentsOffset;
                                    this.generateAnnotation(annotation, n);
                                    if (this.contentsOffset != n) {
                                        ++n4;
                                        ++n13;
                                    }
                                    --n9;
                                }
                            }
                            ++n3;
                        }
                    }
                    this.contents[n5++] = (byte)(n4 >> 8);
                    this.contents[n5] = (byte)n4;
                }
                ++n14;
            }
            if (n13 != 0) {
                n14 = this.contentsOffset - n6 - 4;
                this.contents[n6++] = (byte)(n14 >> 24);
                this.contents[n6++] = (byte)(n14 >> 16);
                this.contents[n6++] = (byte)(n14 >> 8);
                this.contents[n6++] = (byte)n14;
                ++n11;
            } else {
                this.contentsOffset = n12;
            }
        }
        if (n10 != 0) {
            int n16 = 0;
            if (this.contentsOffset + 7 >= this.contents.length) {
                this.resizeContents(7);
            }
            n7 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleParameterAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
            this.contents[this.contentsOffset++] = (byte)n7;
            n6 = this.contentsOffset;
            this.contentsOffset += 4;
            this.contents[this.contentsOffset++] = (byte)n8;
            int n17 = 0;
            while (n17 < n8) {
                if (this.contentsOffset + 2 >= this.contents.length) {
                    this.resizeContents(2);
                }
                if (n10 == 0) {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                } else {
                    int n18 = nArray[n17][0];
                    n5 = this.contentsOffset;
                    this.contentsOffset += 2;
                    n4 = 0;
                    if (n18 != 0) {
                        argument = argumentArray[n17];
                        annotationArray = argument.annotations;
                        n3 = 0;
                        n2 = annotationArray.length;
                        while (n3 < n2) {
                            annotation = annotationArray[n3].getPersistibleAnnotation();
                            if (annotation != null) {
                                long l5 = l = annotation.resolvedType != null ? annotation.resolvedType.getAnnotationTagBits() & 0x600FF800000000L : 0L;
                                if ((l == 0L || (l & 0x8000000000L) != 0L) && annotation.isRuntimeVisible()) {
                                    n = this.contentsOffset;
                                    this.generateAnnotation(annotation, n);
                                    if (this.contentsOffset != n) {
                                        ++n4;
                                        ++n16;
                                    }
                                    --n10;
                                }
                            }
                            ++n3;
                        }
                    }
                    this.contents[n5++] = (byte)(n4 >> 8);
                    this.contents[n5] = (byte)n4;
                }
                ++n17;
            }
            if (n16 != 0) {
                n17 = this.contentsOffset - n6 - 4;
                this.contents[n6++] = (byte)(n17 >> 24);
                this.contents[n6++] = (byte)(n17 >> 16);
                this.contents[n6++] = (byte)(n17 >> 8);
                this.contents[n6++] = (byte)n17;
                ++n11;
            } else {
                this.contentsOffset = n12;
            }
        }
        return n11;
    }

    private int generateRuntimeTypeAnnotations(AnnotationContext[] annotationContextArray, int n, int n2) {
        int n3;
        AnnotationContext annotationContext;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = 0;
        int n10 = annotationContextArray.length;
        int n11 = n;
        int n12 = n2;
        int n13 = this.contentsOffset;
        int n14 = this.constantPool.currentOffset;
        int n15 = this.constantPool.currentIndex;
        if (n12 != 0) {
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            n8 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleTypeAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
            this.contents[this.contentsOffset++] = (byte)n8;
            n7 = this.contentsOffset;
            this.contentsOffset += 4;
            n6 = this.contentsOffset;
            this.contentsOffset += 2;
            n5 = 0;
            n4 = 0;
            while (n4 < n10) {
                if (n12 == 0) break;
                annotationContext = annotationContextArray[n4];
                if ((annotationContext.visibility & 2) != 0) {
                    n3 = this.contentsOffset;
                    this.generateTypeAnnotation(annotationContext, n3);
                    --n12;
                    if (this.contentsOffset != n3) {
                        ++n5;
                    }
                }
                ++n4;
            }
            if (n5 != 0) {
                this.contents[n6++] = (byte)(n5 >> 8);
                this.contents[n6++] = (byte)n5;
                n4 = this.contentsOffset - n7 - 4;
                this.contents[n7++] = (byte)(n4 >> 24);
                this.contents[n7++] = (byte)(n4 >> 16);
                this.contents[n7++] = (byte)(n4 >> 8);
                this.contents[n7++] = (byte)n4;
                ++n9;
            } else {
                this.contentsOffset = n13;
                this.constantPool.resetForAttributeName(AttributeNamesConstants.RuntimeInvisibleTypeAnnotationsName, n15, n14);
            }
        }
        n13 = this.contentsOffset;
        n14 = this.constantPool.currentOffset;
        n15 = this.constantPool.currentIndex;
        if (n11 != 0) {
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            n8 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleTypeAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
            this.contents[this.contentsOffset++] = (byte)n8;
            n7 = this.contentsOffset;
            this.contentsOffset += 4;
            n6 = this.contentsOffset;
            this.contentsOffset += 2;
            n5 = 0;
            n4 = 0;
            while (n4 < n10) {
                if (n11 == 0) break;
                annotationContext = annotationContextArray[n4];
                if ((annotationContext.visibility & 1) != 0) {
                    --n11;
                    n3 = this.contentsOffset;
                    this.generateTypeAnnotation(annotationContext, n3);
                    if (this.contentsOffset != n3) {
                        ++n5;
                    }
                }
                ++n4;
            }
            if (n5 != 0) {
                this.contents[n6++] = (byte)(n5 >> 8);
                this.contents[n6++] = (byte)n5;
                n4 = this.contentsOffset - n7 - 4;
                this.contents[n7++] = (byte)(n4 >> 24);
                this.contents[n7++] = (byte)(n4 >> 16);
                this.contents[n7++] = (byte)(n4 >> 8);
                this.contents[n7++] = (byte)n4;
                ++n9;
            } else {
                this.contentsOffset = n13;
                this.constantPool.resetForAttributeName(AttributeNamesConstants.RuntimeVisibleTypeAnnotationsName, n15, n14);
            }
        }
        return n9;
    }

    private int generateMethodParameters(MethodBinding methodBinding) {
        int n;
        int n2;
        int n3;
        boolean bl;
        int n4 = this.contentsOffset;
        int n5 = 0;
        AbstractMethodDeclaration abstractMethodDeclaration = methodBinding.sourceMethod();
        boolean bl2 = methodBinding.isConstructor();
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        ReferenceBinding referenceBinding = methodBinding.declaringClass;
        if (referenceBinding.isEnum()) {
            if (bl2) {
                n5 = this.writeArgumentName(ConstantPool.EnumName, 4096, n5);
                n5 = this.writeArgumentName(ConstantPool.EnumOrdinal, 4096, n5);
            } else if (CharOperation.equals(ConstantPool.ValueOf, methodBinding.selector)) {
                n5 = this.writeArgumentName(ConstantPool.Name, 32768, n5);
                typeBindingArray = Binding.NO_PARAMETERS;
            }
        }
        boolean bl3 = bl = bl2 && referenceBinding.isNestedType();
        if (bl) {
            n3 = referenceBinding.isAnonymousType() && referenceBinding.superclass().isLocalType() ? 1 : 0;
            n2 = referenceBinding.isAnonymousType() && referenceBinding.superclass().isNestedType() ? 1 : 0;
            n = (!referenceBinding.isPrivate() || referenceBinding.isAnonymousType()) && n3 == 0 ? 1 : 0;
            ReferenceBinding[] referenceBindingArray = referenceBinding.syntheticEnclosingInstanceTypes();
            if (referenceBindingArray != null) {
                int n6 = 0;
                int n7 = referenceBindingArray.length;
                while (n6 < n7) {
                    boolean bl4 = n2 != 0 ? referenceBinding.superclass().enclosingType().equals(referenceBindingArray[n6]) : true;
                    int n8 = bl4 && n != 0 ? 32768 : 4096;
                    char[] cArray = CharOperation.concat(TypeConstants.SYNTHETIC_ENCLOSING_INSTANCE_PREFIX, String.valueOf(n6).toCharArray());
                    n5 = this.writeArgumentName(cArray, n8 | 0x10, n5);
                    ++n6;
                }
            }
            if (methodBinding instanceof SyntheticMethodBinding) {
                typeBindingArray = ((SyntheticMethodBinding)methodBinding).targetMethod.parameters;
                abstractMethodDeclaration = ((SyntheticMethodBinding)methodBinding).targetMethod.sourceMethod();
            }
        }
        if (typeBindingArray != Binding.NO_PARAMETERS) {
            Argument[] argumentArray = null;
            if (abstractMethodDeclaration != null && abstractMethodDeclaration.arguments != null) {
                argumentArray = abstractMethodDeclaration.arguments;
            } else if (methodBinding.sourceLambda() != null) {
                argumentArray = methodBinding.sourceLambda().arguments;
            }
            n2 = 0;
            n = typeBindingArray.length;
            int n9 = argumentArray != null ? argumentArray.length : 0;
            while (n2 < n) {
                if (n9 > n2 && argumentArray[n2] != null) {
                    Argument argument = argumentArray[n2];
                    n5 = this.writeArgumentName(argument.name, argument.binding.modifiers, n5);
                } else {
                    n5 = this.writeArgumentName(null, 4096, n5);
                }
                ++n2;
            }
        }
        if (bl) {
            SyntheticArgumentBinding[] syntheticArgumentBindingArray = referenceBinding.syntheticOuterLocalVariables();
            n2 = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
            n = 0;
            while (n < n2) {
                n5 = this.writeArgumentName(syntheticArgumentBindingArray[n].name, syntheticArgumentBindingArray[n].modifiers | 0x1000, n5);
                ++n;
            }
            n = typeBindingArray.length;
            int n10 = methodBinding.parameters.length;
            while (n < n10) {
                TypeBinding typeBinding = methodBinding.parameters[n];
                n5 = this.writeArgumentName(typeBinding.constantPoolName(), 4096, n5);
                ++n;
            }
        }
        if (n5 > 0) {
            n3 = 1 + 4 * n5;
            if (this.contentsOffset + 6 + n3 >= this.contents.length) {
                this.resizeContents(6 + n3);
            }
            n2 = this.constantPool.literalIndex(AttributeNamesConstants.MethodParametersName);
            this.contents[n4++] = (byte)(n2 >> 8);
            this.contents[n4++] = (byte)n2;
            this.contents[n4++] = (byte)(n3 >> 24);
            this.contents[n4++] = (byte)(n3 >> 16);
            this.contents[n4++] = (byte)(n3 >> 8);
            this.contents[n4++] = (byte)n3;
            this.contents[n4++] = (byte)n5;
            return 1;
        }
        return 0;
    }

    private int writeArgumentName(char[] cArray, int n, int n2) {
        int n3 = 4;
        if (n2 == 0) {
            n3 += 7;
            this.contentsOffset += 7;
        }
        if (this.contentsOffset + n3 > this.contents.length) {
            this.resizeContents(n3);
        }
        int n4 = cArray == null ? 0 : this.constantPool.literalIndex(cArray);
        this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
        this.contents[this.contentsOffset++] = (byte)n4;
        int n5 = n & 0x9010;
        this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
        this.contents[this.contentsOffset++] = (byte)n5;
        return n2 + 1;
    }

    private int generateSignatureAttribute(char[] cArray) {
        int n = this.contentsOffset;
        if (n + 8 >= this.contents.length) {
            this.resizeContents(8);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 2;
        int n3 = this.constantPool.literalIndex(cArray);
        this.contents[n++] = (byte)(n3 >> 8);
        this.contents[n++] = (byte)n3;
        this.contentsOffset = n;
        return 1;
    }

    private int generateSourceAttribute(String string) {
        int n = this.contentsOffset;
        if (n + 8 >= this.contents.length) {
            this.resizeContents(8);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.SourceName);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 2;
        int n3 = this.constantPool.literalIndex(string.toCharArray());
        this.contents[n++] = (byte)(n3 >> 8);
        this.contents[n++] = (byte)n3;
        this.contentsOffset = n;
        return 1;
    }

    private int generateStackMapAttribute(MethodBinding methodBinding, int n, int n2, int n3, boolean bl) {
        HashMap hashMap;
        List list;
        int n4;
        int n5 = 0;
        int n6 = this.contentsOffset;
        StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
        stackMapFrameCodeStream.removeFramePosition(n);
        if (stackMapFrameCodeStream.hasFramePositions() && (n4 = (list = this.traverse(bl ? null : methodBinding, n3, this.contents, n2 + 14, n, hashMap = new HashMap(), bl)).size()) > 1) {
            int n7 = n6;
            if (n6 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int n8 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapName);
            this.contents[n6++] = (byte)(n8 >> 8);
            this.contents[n6++] = (byte)n8;
            int n9 = n6;
            if ((n6 += 4) + 4 >= this.contents.length) {
                this.resizeContents(4);
            }
            int n10 = n6;
            if ((n6 += 2) + 2 >= this.contents.length) {
                this.resizeContents(2);
            }
            StackMapFrame stackMapFrame = (StackMapFrame)list.get(0);
            int n11 = 1;
            while (n11 < n4) {
                int n12;
                stackMapFrame = (StackMapFrame)list.get(n11);
                int n13 = stackMapFrame.pc;
                if (n6 + 5 >= this.contents.length) {
                    this.resizeContents(5);
                }
                this.contents[n6++] = (byte)(n13 >> 8);
                this.contents[n6++] = (byte)n13;
                int n14 = n6;
                n6 += 2;
                int n15 = 0;
                int n16 = stackMapFrame.getNumberOfLocals();
                int n17 = 0;
                int n18 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                int n19 = 0;
                while (n19 < n18 && n15 < n16) {
                    VerificationTypeInfo verificationTypeInfo;
                    if (n6 + 3 >= this.contents.length) {
                        this.resizeContents(3);
                    }
                    if ((verificationTypeInfo = stackMapFrame.locals[n19]) == null) {
                        this.contents[n6++] = 0;
                    } else {
                        block0 : switch (verificationTypeInfo.id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n6++] = 1;
                                break;
                            }
                            case 9: {
                                this.contents[n6++] = 2;
                                break;
                            }
                            case 7: {
                                this.contents[n6++] = 4;
                                ++n19;
                                break;
                            }
                            case 8: {
                                this.contents[n6++] = 3;
                                ++n19;
                                break;
                            }
                            case 12: {
                                this.contents[n6++] = 5;
                                break;
                            }
                            default: {
                                this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                switch (verificationTypeInfo.tag) {
                                    case 8: {
                                        int n20 = verificationTypeInfo.offset;
                                        this.contents[n6++] = (byte)(n20 >> 8);
                                        this.contents[n6++] = (byte)n20;
                                        break block0;
                                    }
                                    case 7: {
                                        n12 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                        this.contents[n6++] = (byte)(n12 >> 8);
                                        this.contents[n6++] = (byte)n12;
                                    }
                                }
                            }
                        }
                        ++n15;
                    }
                    ++n17;
                    ++n19;
                }
                if (n6 + 4 >= this.contents.length) {
                    this.resizeContents(4);
                }
                this.contents[n14++] = (byte)(n17 >> 8);
                this.contents[n14] = (byte)n17;
                n19 = stackMapFrame.numberOfStackItems;
                this.contents[n6++] = (byte)(n19 >> 8);
                this.contents[n6++] = (byte)n19;
                int n21 = 0;
                while (n21 < n19) {
                    VerificationTypeInfo verificationTypeInfo;
                    if (n6 + 3 >= this.contents.length) {
                        this.resizeContents(3);
                    }
                    if ((verificationTypeInfo = stackMapFrame.stackItems[n21]) == null) {
                        this.contents[n6++] = 0;
                    } else {
                        block11 : switch (verificationTypeInfo.id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n6++] = 1;
                                break;
                            }
                            case 9: {
                                this.contents[n6++] = 2;
                                break;
                            }
                            case 7: {
                                this.contents[n6++] = 4;
                                break;
                            }
                            case 8: {
                                this.contents[n6++] = 3;
                                break;
                            }
                            case 12: {
                                this.contents[n6++] = 5;
                                break;
                            }
                            default: {
                                this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                switch (verificationTypeInfo.tag) {
                                    case 8: {
                                        n12 = verificationTypeInfo.offset;
                                        this.contents[n6++] = (byte)(n12 >> 8);
                                        this.contents[n6++] = (byte)n12;
                                        break block11;
                                    }
                                    case 7: {
                                        int n22 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                        this.contents[n6++] = (byte)(n22 >> 8);
                                        this.contents[n6++] = (byte)n22;
                                    }
                                }
                            }
                        }
                    }
                    ++n21;
                }
                ++n11;
            }
            if (--n4 != 0) {
                this.contents[n10++] = (byte)(n4 >> 8);
                this.contents[n10] = (byte)n4;
                n11 = n6 - n9 - 4;
                this.contents[n9++] = (byte)(n11 >> 24);
                this.contents[n9++] = (byte)(n11 >> 16);
                this.contents[n9++] = (byte)(n11 >> 8);
                this.contents[n9] = (byte)n11;
                ++n5;
            } else {
                n6 = n7;
            }
        }
        this.contentsOffset = n6;
        return n5;
    }

    private int generateStackMapTableAttribute(MethodBinding methodBinding, int n, int n2, int n3, boolean bl) {
        HashMap hashMap;
        List list;
        int n4;
        int n5 = 0;
        int n6 = this.contentsOffset;
        StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
        stackMapFrameCodeStream.removeFramePosition(n);
        if (stackMapFrameCodeStream.hasFramePositions() && (n4 = (list = this.traverse(bl ? null : methodBinding, n3, this.contents, n2 + 14, n, hashMap = new HashMap(), bl)).size()) > 1) {
            int n7 = n6;
            if (n6 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int n8 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[n6++] = (byte)(n8 >> 8);
            this.contents[n6++] = (byte)n8;
            int n9 = n6;
            if ((n6 += 4) + 4 >= this.contents.length) {
                this.resizeContents(4);
            }
            int n10 = n6;
            if ((n6 += 2) + 2 >= this.contents.length) {
                this.resizeContents(2);
            }
            StackMapFrame stackMapFrame = (StackMapFrame)list.get(0);
            StackMapFrame stackMapFrame2 = null;
            int n11 = 1;
            while (n11 < n4) {
                stackMapFrame2 = stackMapFrame;
                stackMapFrame = (StackMapFrame)list.get(n11);
                int n12 = stackMapFrame.getOffsetDelta(stackMapFrame2);
                block0 : switch (stackMapFrame.getFrameType(stackMapFrame2)) {
                    case 2: {
                        int n13;
                        int n14;
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n15 = stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n6++] = (byte)(251 + n15);
                        this.contents[n6++] = (byte)(n12 >> 8);
                        this.contents[n6++] = (byte)n12;
                        int n16 = stackMapFrame.getIndexOfDifferentLocals(n15);
                        int n17 = stackMapFrame.getNumberOfLocals();
                        int n18 = n16;
                        while (n18 < stackMapFrame.locals.length && n15 > 0) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n18]) == null) {
                                this.contents[n6++] = 0;
                            } else {
                                block8 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n6++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n6++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n6++] = 4;
                                        ++n18;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n6++] = 3;
                                        ++n18;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n6++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n14 = verificationTypeInfo.offset;
                                                this.contents[n6++] = (byte)(n14 >> 8);
                                                this.contents[n6++] = (byte)n14;
                                                break block8;
                                            }
                                            case 7: {
                                                n13 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n6++] = (byte)(n13 >> 8);
                                                this.contents[n6++] = (byte)n13;
                                            }
                                        }
                                    }
                                }
                                --n15;
                            }
                            ++n18;
                        }
                        break;
                    }
                    case 0: {
                        if (n6 + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[n6++] = (byte)n12;
                        break;
                    }
                    case 3: {
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[n6++] = -5;
                        this.contents[n6++] = (byte)(n12 >> 8);
                        this.contents[n6++] = (byte)n12;
                        break;
                    }
                    case 1: {
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n15 = -stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n6++] = (byte)(251 - n15);
                        this.contents[n6++] = (byte)(n12 >> 8);
                        this.contents[n6++] = (byte)n12;
                        break;
                    }
                    case 5: {
                        int n13;
                        int n14;
                        if (n6 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n6++] = (byte)(n12 + 64);
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n6++] = 0;
                            break;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n6++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[n6++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[n6++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[n6++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[n6++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        byte by = (byte)verificationTypeInfo.tag;
                        this.contents[n6++] = by;
                        switch (by) {
                            case 8: {
                                n14 = verificationTypeInfo.offset;
                                this.contents[n6++] = (byte)(n14 >> 8);
                                this.contents[n6++] = (byte)n14;
                                break;
                            }
                            case 7: {
                                n13 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n6++] = (byte)(n13 >> 8);
                                this.contents[n6++] = (byte)n13;
                            }
                        }
                        break;
                    }
                    case 6: {
                        int n13;
                        int n14;
                        if (n6 + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[n6++] = -9;
                        this.contents[n6++] = (byte)(n12 >> 8);
                        this.contents[n6++] = (byte)n12;
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n6++] = 0;
                            break;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n6++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[n6++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[n6++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[n6++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[n6++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        byte by = (byte)verificationTypeInfo.tag;
                        this.contents[n6++] = by;
                        switch (by) {
                            case 8: {
                                n14 = verificationTypeInfo.offset;
                                this.contents[n6++] = (byte)(n14 >> 8);
                                this.contents[n6++] = (byte)n14;
                                break;
                            }
                            case 7: {
                                n13 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n6++] = (byte)(n13 >> 8);
                                this.contents[n6++] = (byte)n13;
                            }
                        }
                        break;
                    }
                    default: {
                        int n19;
                        if (n6 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n6++] = -1;
                        this.contents[n6++] = (byte)(n12 >> 8);
                        this.contents[n6++] = (byte)n12;
                        int n20 = n6;
                        n6 += 2;
                        int n21 = 0;
                        int n17 = stackMapFrame.getNumberOfLocals();
                        int n14 = 0;
                        int n13 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        int n22 = 0;
                        while (n22 < n13 && n21 < n17) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n22]) == null) {
                                this.contents[n6++] = 0;
                            } else {
                                block41 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n6++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n6++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n6++] = 4;
                                        ++n22;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n6++] = 3;
                                        ++n22;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n6++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n23 = verificationTypeInfo.offset;
                                                this.contents[n6++] = (byte)(n23 >> 8);
                                                this.contents[n6++] = (byte)n23;
                                                break block41;
                                            }
                                            case 7: {
                                                n19 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n6++] = (byte)(n19 >> 8);
                                                this.contents[n6++] = (byte)n19;
                                            }
                                        }
                                    }
                                }
                                ++n21;
                            }
                            ++n14;
                            ++n22;
                        }
                        if (n6 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n20++] = (byte)(n14 >> 8);
                        this.contents[n20] = (byte)n14;
                        n22 = stackMapFrame.numberOfStackItems;
                        this.contents[n6++] = (byte)(n22 >> 8);
                        this.contents[n6++] = (byte)n22;
                        int n24 = 0;
                        while (n24 < n22) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[n24]) == null) {
                                this.contents[n6++] = 0;
                            } else {
                                block52 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n6++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n6++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n6++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n6++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n6++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n19 = verificationTypeInfo.offset;
                                                this.contents[n6++] = (byte)(n19 >> 8);
                                                this.contents[n6++] = (byte)n19;
                                                break block52;
                                            }
                                            case 7: {
                                                int n25 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n6++] = (byte)(n25 >> 8);
                                                this.contents[n6++] = (byte)n25;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n24;
                        }
                        break block0;
                    }
                }
                ++n11;
            }
            if (--n4 != 0) {
                this.contents[n10++] = (byte)(n4 >> 8);
                this.contents[n10] = (byte)n4;
                n11 = n6 - n9 - 4;
                this.contents[n9++] = (byte)(n11 >> 24);
                this.contents[n9++] = (byte)(n11 >> 16);
                this.contents[n9++] = (byte)(n11 >> 8);
                this.contents[n9] = (byte)n11;
                ++n5;
            } else {
                n6 = n7;
            }
        }
        this.contentsOffset = n6;
        return n5;
    }

    private int generateSyntheticAttribute() {
        int n = this.contentsOffset;
        if (n + 6 >= this.contents.length) {
            this.resizeContents(6);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contentsOffset = n;
        return 1;
    }

    private void generateTypeAnnotation(AnnotationContext annotationContext, int n) {
        Annotation annotation = annotationContext.annotation.getPersistibleAnnotation();
        if (annotation == null || annotation.resolvedType == null) {
            return;
        }
        int n2 = annotationContext.targetType;
        int[] nArray = Annotation.getLocations(annotationContext.typeReference, annotationContext.annotation);
        if (this.contentsOffset + 5 >= this.contents.length) {
            this.resizeContents(5);
        }
        this.contents[this.contentsOffset++] = (byte)n2;
        this.dumpTargetTypeContents(n2, annotationContext);
        this.dumpLocations(nArray);
        this.generateAnnotation(annotation, n);
    }

    private int generateTypeAnnotationAttributeForTypeDeclaration() {
        int n;
        TypeParameter[] typeParameterArray;
        TypeReference[] typeReferenceArray;
        TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
        if ((typeDeclaration.bits & 0x100000) == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        TypeReference typeReference = typeDeclaration.superclass;
        ArrayList<AnnotationContext> arrayList = new ArrayList<AnnotationContext>();
        if (typeReference != null && (typeReference.bits & 0x100000) != 0) {
            typeReference.getAllAnnotationContexts(16, -1, arrayList);
        }
        if ((typeReferenceArray = typeDeclaration.superInterfaces) != null) {
            int n5 = 0;
            while (n5 < typeReferenceArray.length) {
                TypeReference typeReference2 = typeReferenceArray[n5];
                if ((typeReference2.bits & 0x100000) != 0) {
                    typeReference2.getAllAnnotationContexts(16, n5, arrayList);
                }
                ++n5;
            }
        }
        if ((typeParameterArray = typeDeclaration.typeParameters) != null) {
            int n6 = 0;
            int n7 = typeParameterArray.length;
            while (n6 < n7) {
                TypeParameter typeParameter = typeParameterArray[n6];
                if ((typeParameter.bits & 0x100000) != 0) {
                    typeParameter.getAllAnnotationContexts(0, n6, arrayList);
                }
                ++n6;
            }
        }
        if ((n = arrayList.size()) != 0) {
            AnnotationContext[] annotationContextArray = new AnnotationContext[n];
            arrayList.toArray(annotationContextArray);
            int n8 = 0;
            int n9 = annotationContextArray.length;
            while (n8 < n9) {
                AnnotationContext annotationContext = annotationContextArray[n8];
                if ((annotationContext.visibility & 2) != 0) {
                    ++n4;
                    arrayList.add(annotationContext);
                } else {
                    ++n3;
                    arrayList.add(annotationContext);
                }
                ++n8;
            }
            n2 += this.generateRuntimeTypeAnnotations(annotationContextArray, n3, n4);
        }
        return n2;
    }

    private int generateVarargsAttribute() {
        int n = this.contentsOffset;
        if (n + 6 >= this.contents.length) {
            this.resizeContents(6);
        }
        int n2 = this.constantPool.literalIndex(AttributeNamesConstants.VarargsName);
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n++] = (byte)n2;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contents[n++] = 0;
        this.contentsOffset = n;
        return 1;
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = new byte[this.headerOffset + this.contentsOffset];
            System.arraycopy(this.header, 0, this.bytes, 0, this.headerOffset);
            System.arraycopy(this.contents, 0, this.bytes, this.headerOffset, this.contentsOffset);
        }
        return this.bytes;
    }

    public char[][] getCompoundName() {
        return CharOperation.splitOn('/', this.fileName());
    }

    private int getParametersCount(char[] cArray) {
        char c;
        int n = CharOperation.indexOf('(', cArray);
        if ((c = cArray[++n]) == ')') {
            return 0;
        }
        int n2 = 0;
        block5: while (true) {
            if ((c = cArray[n]) == ')') {
                return n2;
            }
            switch (c) {
                case '[': {
                    int n3 = this.scanType(cArray, n + 1);
                    ++n2;
                    n = n3 + 1;
                    continue block5;
                }
                case 'L': {
                    int n3 = CharOperation.indexOf(';', cArray, n + 1);
                    ++n2;
                    n = n3 + 1;
                    continue block5;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    ++n2;
                    ++n;
                    continue block5;
                }
            }
            break;
        }
        throw new IllegalArgumentException("Invalid starting type character : " + c);
    }

    private char[] getReturnType(char[] cArray) {
        int n = CharOperation.lastIndexOf(')', cArray);
        return CharOperation.subarray(cArray, n + 1, cArray.length);
    }

    private final int i4At(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        return ((byArray[n3++] & 0xFF) << 24) + ((byArray[n3++] & 0xFF) << 16) + ((byArray[n3++] & 0xFF) << 8) + (byArray[n3] & 0xFF);
    }

    protected void initByteArrays() {
        int n = this.referenceBinding.methods().length + this.referenceBinding.fields().length;
        this.header = new byte[1500];
        this.contents = new byte[n < 15 ? 400 : 1500];
    }

    public void initialize(SourceTypeBinding sourceTypeBinding, ClassFile classFile, boolean bl) {
        int n;
        this.header[this.headerOffset++] = -54;
        this.header[this.headerOffset++] = -2;
        this.header[this.headerOffset++] = -70;
        this.header[this.headerOffset++] = -66;
        long l = this.targetJDK;
        this.header[this.headerOffset++] = (byte)(l >> 8);
        this.header[this.headerOffset++] = (byte)(l >> 0);
        this.header[this.headerOffset++] = (byte)(l >> 24);
        this.header[this.headerOffset++] = (byte)(l >> 16);
        this.constantPoolOffset = this.headerOffset;
        this.headerOffset += 2;
        this.constantPool.initialize(this);
        int n2 = sourceTypeBinding.getAccessFlags();
        if (sourceTypeBinding.isPrivate()) {
            n2 &= 0xFFFFFFFE;
        }
        if (sourceTypeBinding.isProtected()) {
            n2 |= 1;
        }
        n2 &= 0xFFFFF6D1;
        if (!sourceTypeBinding.isInterface()) {
            n2 |= 0x20;
        }
        if (sourceTypeBinding.isAnonymousType()) {
            n2 &= 0xFFFFFFEF;
        }
        if ((n2 & (n = 1040)) == n) {
            n2 &= ~n;
        }
        this.enclosingClassFile = classFile;
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        int n3 = this.constantPool.literalIndexForType(sourceTypeBinding);
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        int n4 = sourceTypeBinding.isInterface() ? this.constantPool.literalIndexForType(ConstantPool.JavaLangObjectConstantPoolName) : (sourceTypeBinding.superclass != null ? ((sourceTypeBinding.superclass.tagBits & 0x80L) != 0L ? this.constantPool.literalIndexForType(ConstantPool.JavaLangObjectConstantPoolName) : this.constantPool.literalIndexForType(sourceTypeBinding.superclass)) : 0);
        this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
        this.contents[this.contentsOffset++] = (byte)n4;
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.superInterfaces();
        int n5 = referenceBindingArray.length;
        int n6 = this.contentsOffset;
        this.contentsOffset += 2;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            ReferenceBinding referenceBinding = referenceBindingArray[n8];
            if ((referenceBinding.tagBits & 0x80L) == 0L) {
                ++n7;
                int n9 = this.constantPool.literalIndexForType(referenceBinding);
                this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                this.contents[this.contentsOffset++] = (byte)n9;
            }
            ++n8;
        }
        this.contents[n6++] = (byte)(n7 >> 8);
        this.contents[n6] = (byte)n7;
        this.creatingProblemType = bl;
        this.codeStream.maxFieldCount = sourceTypeBinding.scope.outerMostClassScope().referenceType().maxFieldCount;
    }

    private void initializeDefaultLocals(StackMapFrame stackMapFrame, MethodBinding methodBinding, int n, int n2) {
        block22: {
            Object object;
            int n3;
            block23: {
                block24: {
                    SyntheticArgumentBinding[] syntheticArgumentBindingArray;
                    int n4;
                    if (n == 0) break block22;
                    n3 = 0;
                    boolean bl = methodBinding.isConstructor();
                    if (bl || !methodBinding.isStatic()) {
                        object = new LocalVariableBinding(ConstantPool.This, (TypeBinding)methodBinding.declaringClass, 0, false);
                        ((LocalVariableBinding)object).resolvedPosition = 0;
                        this.codeStream.record((LocalVariableBinding)object);
                        ((LocalVariableBinding)object).recordInitializationStartPC(0);
                        ((LocalVariableBinding)object).recordInitializationEndPC(n2);
                        stackMapFrame.putLocal(n3, new VerificationTypeInfo(bl ? 6 : 7, methodBinding.declaringClass));
                        ++n3;
                    }
                    if (!bl) break block23;
                    if (methodBinding.declaringClass.isEnum()) {
                        object = new LocalVariableBinding(" name".toCharArray(), (TypeBinding)this.referenceBinding.scope.getJavaLangString(), 0, false);
                        ((LocalVariableBinding)object).resolvedPosition = n3;
                        this.codeStream.record((LocalVariableBinding)object);
                        ((LocalVariableBinding)object).recordInitializationStartPC(0);
                        ((LocalVariableBinding)object).recordInitializationEndPC(n2);
                        stackMapFrame.putLocal(n3, new VerificationTypeInfo(11, ConstantPool.JavaLangStringConstantPoolName));
                        object = new LocalVariableBinding(" ordinal".toCharArray(), (TypeBinding)TypeBinding.INT, 0, false);
                        ((LocalVariableBinding)object).resolvedPosition = ++n3;
                        this.codeStream.record((LocalVariableBinding)object);
                        ((LocalVariableBinding)object).recordInitializationStartPC(0);
                        ((LocalVariableBinding)object).recordInitializationEndPC(n2);
                        stackMapFrame.putLocal(n3, new VerificationTypeInfo(TypeBinding.INT));
                        ++n3;
                    }
                    if (!methodBinding.declaringClass.isNestedType()) break block24;
                    object = methodBinding.declaringClass.syntheticEnclosingInstanceTypes();
                    if (object != null) {
                        int n5 = 0;
                        n4 = ((Object)object).length;
                        while (n5 < n4) {
                            LocalVariableBinding localVariableBinding = new LocalVariableBinding((" enclosingType" + n5).toCharArray(), (TypeBinding)object[n5], 0, false);
                            localVariableBinding.resolvedPosition = n3;
                            this.codeStream.record(localVariableBinding);
                            localVariableBinding.recordInitializationStartPC(0);
                            localVariableBinding.recordInitializationEndPC(n2);
                            stackMapFrame.putLocal(n3, new VerificationTypeInfo((TypeBinding)object[n5]));
                            ++n3;
                            ++n5;
                        }
                    }
                    TypeBinding[] typeBindingArray = methodBinding.parameters;
                    if (methodBinding.parameters != null) {
                        n4 = 0;
                        int n6 = typeBindingArray.length;
                        while (n4 < n6) {
                            TypeBinding typeBinding = typeBindingArray[n4];
                            stackMapFrame.putLocal(n3, new VerificationTypeInfo(typeBinding));
                            switch (typeBinding.id) {
                                case 7: 
                                case 8: {
                                    n3 += 2;
                                    break;
                                }
                                default: {
                                    ++n3;
                                }
                            }
                            ++n4;
                        }
                    }
                    if ((syntheticArgumentBindingArray = methodBinding.declaringClass.syntheticOuterLocalVariables()) == null) break block22;
                    int n7 = 0;
                    int n8 = syntheticArgumentBindingArray.length;
                    while (n7 < n8) {
                        TypeBinding typeBinding = syntheticArgumentBindingArray[n7].type;
                        LocalVariableBinding localVariableBinding = new LocalVariableBinding((" synthetic" + n7).toCharArray(), typeBinding, 0, false);
                        localVariableBinding.resolvedPosition = n3;
                        this.codeStream.record(localVariableBinding);
                        localVariableBinding.recordInitializationStartPC(0);
                        localVariableBinding.recordInitializationEndPC(n2);
                        stackMapFrame.putLocal(n3, new VerificationTypeInfo(typeBinding));
                        switch (typeBinding.id) {
                            case 7: 
                            case 8: {
                                n3 += 2;
                                break;
                            }
                            default: {
                                ++n3;
                            }
                        }
                        ++n7;
                    }
                    break block22;
                }
                object = methodBinding.parameters;
                if (methodBinding.parameters == null) break block22;
                int n9 = 0;
                int n10 = ((Object)object).length;
                while (n9 < n10) {
                    Object object2 = object[n9];
                    stackMapFrame.putLocal(n3, new VerificationTypeInfo((TypeBinding)object2));
                    switch (((TypeBinding)object2).id) {
                        case 7: 
                        case 8: {
                            n3 += 2;
                            break;
                        }
                        default: {
                            ++n3;
                        }
                    }
                    ++n9;
                }
                break block22;
            }
            object = methodBinding.parameters;
            if (methodBinding.parameters != null) {
                int n11 = 0;
                int n12 = ((TypeBinding[])object).length;
                while (n11 < n12) {
                    Object object3 = object[n11];
                    LocalVariableBinding localVariableBinding = new LocalVariableBinding((" synthetic" + n11).toCharArray(), (TypeBinding)object3, 0, true);
                    localVariableBinding.resolvedPosition = n11;
                    this.codeStream.record(localVariableBinding);
                    localVariableBinding.recordInitializationStartPC(0);
                    localVariableBinding.recordInitializationEndPC(n2);
                    stackMapFrame.putLocal(n3, new VerificationTypeInfo((TypeBinding)object3));
                    switch (((TypeBinding)object3).id) {
                        case 7: 
                        case 8: {
                            n3 += 2;
                            break;
                        }
                        default: {
                            ++n3;
                        }
                    }
                    ++n11;
                }
            }
        }
    }

    private void initializeLocals(boolean bl, int n, StackMapFrame stackMapFrame) {
        VerificationTypeInfo[] verificationTypeInfoArray = stackMapFrame.locals;
        int n2 = verificationTypeInfoArray.length;
        int n3 = 0;
        if (!bl) {
            n3 = 1;
        }
        while (n3 < n2) {
            verificationTypeInfoArray[n3] = null;
            ++n3;
        }
        n3 = 0;
        int n4 = this.codeStream.allLocalsCounter;
        while (n3 < n4) {
            LocalVariableBinding localVariableBinding = this.codeStream.locals[n3];
            if (localVariableBinding != null) {
                int n5 = localVariableBinding.resolvedPosition;
                TypeBinding typeBinding = localVariableBinding.type;
                int n6 = 0;
                while (n6 < localVariableBinding.initializationCount) {
                    int n7 = localVariableBinding.initializationPCs[n6 << 1];
                    int n8 = localVariableBinding.initializationPCs[(n6 << 1) + 1];
                    if (n >= n7 && n < n8) {
                        if (stackMapFrame.locals[n5] != null) break;
                        stackMapFrame.locals[n5] = new VerificationTypeInfo(typeBinding);
                        break;
                    }
                    ++n6;
                }
            }
            ++n3;
        }
    }

    public ClassFile outerMostEnclosingClassFile() {
        ClassFile classFile = this;
        while (classFile.enclosingClassFile != null) {
            classFile = classFile.enclosingClassFile;
        }
        return classFile;
    }

    public void recordInnerClasses(TypeBinding typeBinding) {
        if (this.innerClassesBindings == null) {
            this.innerClassesBindings = new HashSet(5);
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        this.innerClassesBindings.add(referenceBinding.erasure().unannotated(false));
        ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
        while (referenceBinding2 != null && referenceBinding2.isNestedType()) {
            this.innerClassesBindings.add(referenceBinding2.erasure().unannotated(false));
            referenceBinding2 = referenceBinding2.enclosingType();
        }
    }

    public int recordBootstrapMethod(FunctionalExpression functionalExpression) {
        if (this.bootstrapMethods == null) {
            this.bootstrapMethods = new ArrayList();
        }
        this.bootstrapMethods.add(functionalExpression);
        functionalExpression.bootstrapMethodNumber = this.bootstrapMethods.size() - 1;
        return this.bootstrapMethods.size() - 1;
    }

    public void reset(SourceTypeBinding sourceTypeBinding) {
        CompilerOptions compilerOptions = sourceTypeBinding.scope.compilerOptions();
        this.referenceBinding = sourceTypeBinding;
        this.isNestedType = sourceTypeBinding.isNestedType();
        this.targetJDK = compilerOptions.targetJDK;
        this.produceAttributes = compilerOptions.produceDebugAttributes;
        if (this.targetJDK >= 0x320000L) {
            this.produceAttributes |= 8;
            if (this.targetJDK >= 0x340000L) {
                this.produceAttributes |= 0x20;
                if (compilerOptions.produceMethodParameters) {
                    this.produceAttributes |= 0x40;
                }
            }
        } else if (this.targetJDK == 2949124L) {
            this.targetJDK = 2949123L;
            this.produceAttributes |= 0x10;
        }
        this.bytes = null;
        this.constantPool.reset();
        this.codeStream.reset(this);
        this.constantPoolOffset = 0;
        this.contentsOffset = 0;
        this.creatingProblemType = false;
        this.enclosingClassFile = null;
        this.headerOffset = 0;
        this.methodCount = 0;
        this.methodCountOffset = 0;
        if (this.innerClassesBindings != null) {
            this.innerClassesBindings.clear();
        }
        if (this.bootstrapMethods != null) {
            this.bootstrapMethods.clear();
        }
        this.missingTypes = null;
        this.visitedTypes = null;
    }

    private final void resizeContents(int n) {
        int n2 = this.contents.length;
        int n3 = n2;
        if (n3 < n) {
            n3 = n;
        }
        this.contents = new byte[n2 + n3];
        System.arraycopy(this.contents, 0, this.contents, 0, n2);
    }

    private VerificationTypeInfo retrieveLocal(int n, int n2) {
        int n3 = 0;
        int n4 = this.codeStream.allLocalsCounter;
        while (n3 < n4) {
            LocalVariableBinding localVariableBinding = this.codeStream.locals[n3];
            if (localVariableBinding != null && n2 == localVariableBinding.resolvedPosition) {
                int n5 = 0;
                while (n5 < localVariableBinding.initializationCount) {
                    int n6 = localVariableBinding.initializationPCs[n5 << 1];
                    int n7 = localVariableBinding.initializationPCs[(n5 << 1) + 1];
                    if (n >= n6 && n < n7) {
                        return new VerificationTypeInfo(localVariableBinding.type);
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        return null;
    }

    private int scanType(char[] cArray, int n) {
        switch (cArray[n]) {
            case '[': {
                return this.scanType(cArray, n + 1);
            }
            case 'L': {
                return CharOperation.indexOf(';', cArray, n + 1);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n;
            }
        }
        throw new IllegalArgumentException();
    }

    public void setForMethodInfos() {
        this.methodCountOffset = this.contentsOffset;
        this.contentsOffset += 2;
    }

    private List filterFakeFrames(Set set, Map map, int n) {
        set.remove(new Integer(n));
        ArrayList<StackMapFrame> arrayList = new ArrayList<StackMapFrame>();
        for (Integer n2 : set) {
            StackMapFrame stackMapFrame = (StackMapFrame)map.get(n2);
            if (stackMapFrame == null) continue;
            arrayList.add(stackMapFrame);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                StackMapFrame stackMapFrame = (StackMapFrame)object;
                StackMapFrame stackMapFrame2 = (StackMapFrame)object2;
                return stackMapFrame.pc - stackMapFrame2.pc;
            }
        });
        return arrayList;
    }

    public List traverse(MethodBinding methodBinding, int n, byte[] byArray, int n2, int n3, Map map, boolean bl) {
        Object object;
        HashSet hashSet = new HashSet();
        StackMapFrameCodeStream stackMapFrameCodeStream = (StackMapFrameCodeStream)this.codeStream;
        int[] nArray = stackMapFrameCodeStream.getFramePositions();
        int n4 = n2;
        int[] nArray2 = this.constantPool.offsets;
        byte[] byArray2 = this.constantPool.poolContent;
        int n5 = 0;
        int n6 = nArray.length;
        int n7 = nArray[0];
        int n8 = 0;
        StackMapFrameCodeStream.StackDepthMarker[] stackDepthMarkerArray = stackMapFrameCodeStream.getStackDepthMarkers();
        int n9 = stackDepthMarkerArray == null ? 0 : stackDepthMarkerArray.length;
        boolean bl2 = n9 != 0;
        StackMapFrameCodeStream.StackDepthMarker stackDepthMarker = null;
        if (bl2) {
            stackDepthMarker = stackDepthMarkerArray[0];
        }
        int n10 = 0;
        StackMapFrameCodeStream.StackMarker[] stackMarkerArray = stackMapFrameCodeStream.getStackMarkers();
        int n11 = stackMarkerArray == null ? 0 : stackMarkerArray.length;
        boolean bl3 = n11 != 0;
        StackMapFrameCodeStream.StackMarker stackMarker = null;
        if (bl3) {
            stackMarker = stackMarkerArray[0];
        }
        int n12 = 0;
        StackMapFrameCodeStream.ExceptionMarker[] exceptionMarkerArray = stackMapFrameCodeStream.getExceptionMarkers();
        int n13 = exceptionMarkerArray == null ? 0 : exceptionMarkerArray.length;
        boolean bl4 = n13 != 0;
        StackMapFrameCodeStream.ExceptionMarker exceptionMarker = null;
        if (bl4) {
            exceptionMarker = exceptionMarkerArray[0];
        }
        StackMapFrame stackMapFrame = new StackMapFrame(n);
        if (!bl) {
            this.initializeDefaultLocals(stackMapFrame, methodBinding, n, n3);
        }
        stackMapFrame.pc = -1;
        this.add(map, stackMapFrame.duplicate());
        this.addRealJumpTarget(hashSet, -1);
        int n14 = 0;
        int n15 = this.codeStream.exceptionLabelsCounter;
        while (n14 < n15) {
            object = this.codeStream.exceptionLabels[n14];
            if (object != null) {
                this.addRealJumpTarget(hashSet, object.position);
            }
            ++n14;
        }
        do {
            n14 = n4 - n2;
            if (bl3 && stackMarker.pc == n14) {
                VerificationTypeInfo[] verificationTypeInfoArray = stackMapFrame.stackItems;
                object = new VerificationTypeInfo[stackMapFrame.numberOfStackItems];
                System.arraycopy(verificationTypeInfoArray, 0, object, 0, stackMapFrame.numberOfStackItems);
                stackMarker.setInfos((VerificationTypeInfo[])object);
            } else if (bl3 && stackMarker.destinationPC == n14) {
                VerificationTypeInfo[] verificationTypeInfoArray = stackMarker.infos;
                stackMapFrame.stackItems = verificationTypeInfoArray;
                stackMapFrame.numberOfStackItems = verificationTypeInfoArray.length;
                if (++n10 < n11) {
                    stackMarker = stackMarkerArray[n10];
                } else {
                    bl3 = false;
                }
            }
            if (bl2 && stackDepthMarker.pc == n14) {
                TypeBinding typeBinding = stackDepthMarker.typeBinding;
                if (typeBinding != null) {
                    if (stackDepthMarker.delta > 0) {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(typeBinding));
                    } else {
                        stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(typeBinding);
                    }
                } else {
                    --stackMapFrame.numberOfStackItems;
                }
                if (++n8 < n9) {
                    stackDepthMarker = stackDepthMarkerArray[n8];
                } else {
                    bl2 = false;
                }
            }
            if (bl4 && exceptionMarker.pc == n14) {
                stackMapFrame.numberOfStackItems = 0;
                stackMapFrame.addStackItem(new VerificationTypeInfo(0, 7, exceptionMarker.constantPoolName));
                if (++n12 < n13) {
                    exceptionMarker = exceptionMarkerArray[n12];
                } else {
                    bl4 = false;
                }
            }
            if (n7 < n14) {
                while ((n7 = ++n5 < n6 ? nArray[n5] : Integer.MAX_VALUE) < n14) {
                }
            }
            if (n7 == n14) {
                StackMapFrame stackMapFrame2 = stackMapFrame.duplicate();
                stackMapFrame2.pc = n14;
                this.initializeLocals(bl ? true : methodBinding.isStatic(), n14, stackMapFrame2);
                this.add(map, stackMapFrame2);
                n7 = ++n5 < n6 ? nArray[n5] : Integer.MAX_VALUE;
            }
            n15 = (byte)this.u1At(byArray, 0, n4);
            switch (n15) {
                case 0: {
                    ++n4;
                    break;
                }
                case 1: {
                    stackMapFrame.addStackItem(TypeBinding.NULL);
                    ++n4;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    stackMapFrame.addStackItem(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case 9: 
                case 10: {
                    stackMapFrame.addStackItem(TypeBinding.LONG);
                    ++n4;
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    stackMapFrame.addStackItem(TypeBinding.FLOAT);
                    ++n4;
                    break;
                }
                case 14: 
                case 15: {
                    stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                    ++n4;
                    break;
                }
                case 16: {
                    stackMapFrame.addStackItem(TypeBinding.BYTE);
                    n4 += 2;
                    break;
                }
                case 17: {
                    stackMapFrame.addStackItem(TypeBinding.SHORT);
                    n4 += 3;
                    break;
                }
                case 18: {
                    int n16 = this.u1At(byArray, 1, n4);
                    switch (this.u1At(byArray2, 0, nArray2[n16])) {
                        case 8: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(11, ConstantPool.JavaLangStringConstantPoolName));
                            break;
                        }
                        case 3: {
                            stackMapFrame.addStackItem(TypeBinding.INT);
                            break;
                        }
                        case 4: {
                            stackMapFrame.addStackItem(TypeBinding.FLOAT);
                            break;
                        }
                        case 7: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(16, ConstantPool.JavaLangClassConstantPoolName));
                        }
                    }
                    n4 += 2;
                    break;
                }
                case 19: {
                    int n16 = this.u2At(byArray, 1, n4);
                    switch (this.u1At(byArray2, 0, nArray2[n16])) {
                        case 8: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(11, ConstantPool.JavaLangStringConstantPoolName));
                            break;
                        }
                        case 3: {
                            stackMapFrame.addStackItem(TypeBinding.INT);
                            break;
                        }
                        case 4: {
                            stackMapFrame.addStackItem(TypeBinding.FLOAT);
                            break;
                        }
                        case 7: {
                            stackMapFrame.addStackItem(new VerificationTypeInfo(16, ConstantPool.JavaLangClassConstantPoolName));
                        }
                    }
                    n4 += 3;
                    break;
                }
                case 20: {
                    int n16 = this.u2At(byArray, 1, n4);
                    switch (this.u1At(byArray2, 0, nArray2[n16])) {
                        case 6: {
                            stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                            break;
                        }
                        case 5: {
                            stackMapFrame.addStackItem(TypeBinding.LONG);
                        }
                    }
                    n4 += 3;
                    break;
                }
                case 21: {
                    stackMapFrame.addStackItem(TypeBinding.INT);
                    n4 += 2;
                    break;
                }
                case 22: {
                    stackMapFrame.addStackItem(TypeBinding.LONG);
                    n4 += 2;
                    break;
                }
                case 23: {
                    stackMapFrame.addStackItem(TypeBinding.FLOAT);
                    n4 += 2;
                    break;
                }
                case 24: {
                    stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                    n4 += 2;
                    break;
                }
                case 25: {
                    int n16 = this.u1At(byArray, 1, n4);
                    object = this.retrieveLocal(n14, n16);
                    stackMapFrame.addStackItem((VerificationTypeInfo)object);
                    n4 += 2;
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    stackMapFrame.addStackItem(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    stackMapFrame.addStackItem(TypeBinding.LONG);
                    ++n4;
                    break;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    stackMapFrame.addStackItem(TypeBinding.FLOAT);
                    ++n4;
                    break;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                    ++n4;
                    break;
                }
                case 42: {
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.locals[0];
                    if (verificationTypeInfo == null || verificationTypeInfo.tag != 6) {
                        verificationTypeInfo = this.retrieveLocal(n14, 0);
                    }
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    ++n4;
                    break;
                }
                case 43: {
                    VerificationTypeInfo verificationTypeInfo = this.retrieveLocal(n14, 1);
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    ++n4;
                    break;
                }
                case 44: {
                    VerificationTypeInfo verificationTypeInfo = this.retrieveLocal(n14, 2);
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    ++n4;
                    break;
                }
                case 45: {
                    VerificationTypeInfo verificationTypeInfo = this.retrieveLocal(n14, 3);
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    ++n4;
                    break;
                }
                case 46: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case 47: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.LONG);
                    ++n4;
                    break;
                }
                case 48: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.FLOAT);
                    ++n4;
                    break;
                }
                case 49: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                    ++n4;
                    break;
                }
                case 50: {
                    --stackMapFrame.numberOfStackItems;
                    stackMapFrame.replaceWithElementType();
                    ++n4;
                    break;
                }
                case 51: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.BYTE);
                    ++n4;
                    break;
                }
                case 52: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.CHAR);
                    ++n4;
                    break;
                }
                case 53: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.SHORT);
                    ++n4;
                    break;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    --stackMapFrame.numberOfStackItems;
                    n4 += 2;
                    break;
                }
                case 58: {
                    int n16 = this.u1At(byArray, 1, n4);
                    --stackMapFrame.numberOfStackItems;
                    n4 += 2;
                    break;
                }
                case 75: {
                    stackMapFrame.locals[0] = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    ++n4;
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 76: 
                case 77: 
                case 78: {
                    --stackMapFrame.numberOfStackItems;
                    ++n4;
                    break;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    stackMapFrame.numberOfStackItems -= 3;
                    ++n4;
                    break;
                }
                case 87: {
                    --stackMapFrame.numberOfStackItems;
                    ++n4;
                    break;
                }
                case 88: {
                    int n17 = stackMapFrame.numberOfStackItems--;
                    switch (stackMapFrame.stackItems[n17 - 1].id()) {
                        case 7: 
                        case 8: {
                            break;
                        }
                        default: {
                            stackMapFrame.numberOfStackItems -= 2;
                        }
                    }
                    ++n4;
                    break;
                }
                case 89: {
                    stackMapFrame.addStackItem(stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1]);
                    ++n4;
                    break;
                }
                case 90: {
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    VerificationTypeInfo verificationTypeInfo2 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    stackMapFrame.addStackItem(verificationTypeInfo2);
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    ++n4;
                    break;
                }
                case 91: {
                    int n17;
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    VerificationTypeInfo verificationTypeInfo2 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    switch (verificationTypeInfo2.id()) {
                        case 7: 
                        case 8: {
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            break;
                        }
                        default: {
                            n17 = stackMapFrame.numberOfStackItems--;
                            VerificationTypeInfo verificationTypeInfo3 = stackMapFrame.stackItems[n17 - 1];
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo3);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                        }
                    }
                    ++n4;
                    break;
                }
                case 92: {
                    VerificationTypeInfo verificationTypeInfo2;
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    switch (verificationTypeInfo.id()) {
                        case 7: 
                        case 8: {
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            break;
                        }
                        default: {
                            verificationTypeInfo2 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                            --stackMapFrame.numberOfStackItems;
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                        }
                    }
                    ++n4;
                    break;
                }
                case 93: {
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    VerificationTypeInfo verificationTypeInfo2 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    switch (verificationTypeInfo.id()) {
                        case 7: 
                        case 8: {
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            break;
                        }
                        default: {
                            VerificationTypeInfo verificationTypeInfo4 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                            --stackMapFrame.numberOfStackItems;
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo4);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                        }
                    }
                    ++n4;
                    break;
                }
                case 94: {
                    int n17 = stackMapFrame.numberOfStackItems--;
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[n17 - 1];
                    VerificationTypeInfo verificationTypeInfo2 = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                    --stackMapFrame.numberOfStackItems;
                    block123 : switch (verificationTypeInfo.id()) {
                        case 7: 
                        case 8: {
                            switch (verificationTypeInfo2.id()) {
                                case 7: 
                                case 8: {
                                    stackMapFrame.addStackItem(verificationTypeInfo);
                                    stackMapFrame.addStackItem(verificationTypeInfo2);
                                    stackMapFrame.addStackItem(verificationTypeInfo);
                                    break block123;
                                }
                            }
                            n17 = stackMapFrame.numberOfStackItems--;
                            VerificationTypeInfo verificationTypeInfo5 = stackMapFrame.stackItems[n17 - 1];
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo5);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            break;
                        }
                        default: {
                            n17 = stackMapFrame.numberOfStackItems--;
                            VerificationTypeInfo verificationTypeInfo6 = stackMapFrame.stackItems[n17 - 1];
                            switch (verificationTypeInfo6.id()) {
                                case 7: 
                                case 8: {
                                    stackMapFrame.addStackItem(verificationTypeInfo2);
                                    stackMapFrame.addStackItem(verificationTypeInfo);
                                    stackMapFrame.addStackItem(verificationTypeInfo6);
                                    stackMapFrame.addStackItem(verificationTypeInfo2);
                                    stackMapFrame.addStackItem(verificationTypeInfo);
                                    break block123;
                                }
                            }
                            n17 = stackMapFrame.numberOfStackItems--;
                            VerificationTypeInfo verificationTypeInfo7 = stackMapFrame.stackItems[n17 - 1];
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                            stackMapFrame.addStackItem(verificationTypeInfo7);
                            stackMapFrame.addStackItem(verificationTypeInfo6);
                            stackMapFrame.addStackItem(verificationTypeInfo2);
                            stackMapFrame.addStackItem(verificationTypeInfo);
                        }
                    }
                    ++n4;
                    break;
                }
                case 95: {
                    VerificationTypeInfo verificationTypeInfo2;
                    int n17 = stackMapFrame.numberOfStackItems;
                    VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[n17 - 1];
                    stackMapFrame.stackItems[n17 - 1] = verificationTypeInfo2 = stackMapFrame.stackItems[n17 - 2];
                    stackMapFrame.stackItems[n17 - 2] = verificationTypeInfo;
                    ++n4;
                    break;
                }
                case -128: 
                case -127: 
                case -126: 
                case -125: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    --stackMapFrame.numberOfStackItems;
                    ++n4;
                    break;
                }
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    ++n4;
                    break;
                }
                case -124: {
                    n4 += 3;
                    break;
                }
                case -123: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.LONG);
                    ++n4;
                    break;
                }
                case -122: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.FLOAT);
                    ++n4;
                    break;
                }
                case -121: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.DOUBLE);
                    ++n4;
                    break;
                }
                case -120: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case -119: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.FLOAT);
                    ++n4;
                    break;
                }
                case -118: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.DOUBLE);
                    ++n4;
                    break;
                }
                case -117: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case -116: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.LONG);
                    ++n4;
                    break;
                }
                case -115: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.DOUBLE);
                    ++n4;
                    break;
                }
                case -114: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case -113: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.LONG);
                    ++n4;
                    break;
                }
                case -112: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.FLOAT);
                    ++n4;
                    break;
                }
                case -111: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.BYTE);
                    ++n4;
                    break;
                }
                case -110: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.CHAR);
                    ++n4;
                    break;
                }
                case -109: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.SHORT);
                    ++n4;
                    break;
                }
                case -108: 
                case -107: 
                case -106: 
                case -105: 
                case -104: {
                    stackMapFrame.numberOfStackItems -= 2;
                    stackMapFrame.addStackItem(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: {
                    --stackMapFrame.numberOfStackItems;
                    this.addRealJumpTarget(hashSet, n14 + this.i2At(byArray, 1, n4));
                    n4 += 3;
                    break;
                }
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: 
                case -91: 
                case -90: {
                    stackMapFrame.numberOfStackItems -= 2;
                    this.addRealJumpTarget(hashSet, n14 + this.i2At(byArray, 1, n4));
                    n4 += 3;
                    break;
                }
                case -89: {
                    this.addRealJumpTarget(hashSet, n14 + this.i2At(byArray, 1, n4));
                    this.addRealJumpTarget(hashSet, (n4 += 3) - n2);
                    break;
                }
                case -86: {
                    ++n4;
                    while ((n4 - n2 & 3) != 0) {
                        ++n4;
                    }
                    this.addRealJumpTarget(hashSet, n14 + this.i4At(byArray, 0, n4));
                    int n18 = this.i4At(byArray, 0, n4 += 4);
                    int n19 = this.i4At(byArray, 0, n4 += 4);
                    n4 += 4;
                    int n20 = n19 - n18 + 1;
                    int n21 = 0;
                    while (n21 < n20) {
                        this.addRealJumpTarget(hashSet, n14 + this.i4At(byArray, 0, n4));
                        n4 += 4;
                        ++n21;
                    }
                    --stackMapFrame.numberOfStackItems;
                    break;
                }
                case -85: {
                    ++n4;
                    while ((n4 - n2 & 3) != 0) {
                        ++n4;
                    }
                    this.addRealJumpTarget(hashSet, n14 + this.i4At(byArray, 0, n4));
                    int n21 = (int)this.u4At(byArray, 0, n4 += 4);
                    n4 += 4;
                    int n22 = 0;
                    while (n22 < n21) {
                        this.addRealJumpTarget(hashSet, n14 + this.i4At(byArray, 0, n4 += 4));
                        n4 += 4;
                        ++n22;
                    }
                    --stackMapFrame.numberOfStackItems;
                    break;
                }
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: {
                    --stackMapFrame.numberOfStackItems;
                    this.addRealJumpTarget(hashSet, ++n4 - n2);
                    break;
                }
                case -79: {
                    this.addRealJumpTarget(hashSet, ++n4 - n2);
                    break;
                }
                case -78: {
                    int n16 = this.u2At(byArray, 1, n4);
                    int n22 = this.u2At(byArray2, 3, nArray2[n16]);
                    int n23 = this.u2At(byArray2, 3, nArray2[n22]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n23] + 3, this.u2At(byArray2, 1, nArray2[n23]));
                    if (cArray.length == 1) {
                        switch (cArray[0]) {
                            case 'Z': {
                                stackMapFrame.addStackItem(TypeBinding.BOOLEAN);
                                break;
                            }
                            case 'B': {
                                stackMapFrame.addStackItem(TypeBinding.BYTE);
                                break;
                            }
                            case 'C': {
                                stackMapFrame.addStackItem(TypeBinding.CHAR);
                                break;
                            }
                            case 'D': {
                                stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                                break;
                            }
                            case 'F': {
                                stackMapFrame.addStackItem(TypeBinding.FLOAT);
                                break;
                            }
                            case 'I': {
                                stackMapFrame.addStackItem(TypeBinding.INT);
                                break;
                            }
                            case 'J': {
                                stackMapFrame.addStackItem(TypeBinding.LONG);
                                break;
                            }
                            case 'S': {
                                stackMapFrame.addStackItem(TypeBinding.SHORT);
                            }
                        }
                    } else if (cArray[0] == '[') {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, cArray));
                    } else {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, CharOperation.subarray(cArray, 1, cArray.length - 1)));
                    }
                    n4 += 3;
                    break;
                }
                case -77: {
                    --stackMapFrame.numberOfStackItems;
                    n4 += 3;
                    break;
                }
                case -76: {
                    int n16 = this.u2At(byArray, 1, n4);
                    int n22 = this.u2At(byArray2, 3, nArray2[n16]);
                    int n23 = this.u2At(byArray2, 3, nArray2[n22]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n23] + 3, this.u2At(byArray2, 1, nArray2[n23]));
                    --stackMapFrame.numberOfStackItems;
                    if (cArray.length == 1) {
                        switch (cArray[0]) {
                            case 'Z': {
                                stackMapFrame.addStackItem(TypeBinding.BOOLEAN);
                                break;
                            }
                            case 'B': {
                                stackMapFrame.addStackItem(TypeBinding.BYTE);
                                break;
                            }
                            case 'C': {
                                stackMapFrame.addStackItem(TypeBinding.CHAR);
                                break;
                            }
                            case 'D': {
                                stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                                break;
                            }
                            case 'F': {
                                stackMapFrame.addStackItem(TypeBinding.FLOAT);
                                break;
                            }
                            case 'I': {
                                stackMapFrame.addStackItem(TypeBinding.INT);
                                break;
                            }
                            case 'J': {
                                stackMapFrame.addStackItem(TypeBinding.LONG);
                                break;
                            }
                            case 'S': {
                                stackMapFrame.addStackItem(TypeBinding.SHORT);
                            }
                        }
                    } else if (cArray[0] == '[') {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, cArray));
                    } else {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, CharOperation.subarray(cArray, 1, cArray.length - 1)));
                    }
                    n4 += 3;
                    break;
                }
                case -75: {
                    stackMapFrame.numberOfStackItems -= 2;
                    n4 += 3;
                    break;
                }
                case -74: {
                    int n16 = this.u2At(byArray, 1, n4);
                    int n22 = this.u2At(byArray2, 3, nArray2[n16]);
                    int n23 = this.u2At(byArray2, 3, nArray2[n22]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n23] + 3, this.u2At(byArray2, 1, nArray2[n23]));
                    n23 = this.u2At(byArray2, 1, nArray2[n22]);
                    char[] cArray2 = this.utf8At(byArray2, nArray2[n23] + 3, this.u2At(byArray2, 1, nArray2[n23]));
                    stackMapFrame.numberOfStackItems -= this.getParametersCount(cArray) + 1;
                    char[] cArray3 = this.getReturnType(cArray);
                    if (cArray3.length == 1) {
                        switch (cArray3[0]) {
                            case 'Z': {
                                stackMapFrame.addStackItem(TypeBinding.BOOLEAN);
                                break;
                            }
                            case 'B': {
                                stackMapFrame.addStackItem(TypeBinding.BYTE);
                                break;
                            }
                            case 'C': {
                                stackMapFrame.addStackItem(TypeBinding.CHAR);
                                break;
                            }
                            case 'D': {
                                stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                                break;
                            }
                            case 'F': {
                                stackMapFrame.addStackItem(TypeBinding.FLOAT);
                                break;
                            }
                            case 'I': {
                                stackMapFrame.addStackItem(TypeBinding.INT);
                                break;
                            }
                            case 'J': {
                                stackMapFrame.addStackItem(TypeBinding.LONG);
                                break;
                            }
                            case 'S': {
                                stackMapFrame.addStackItem(TypeBinding.SHORT);
                            }
                        }
                    } else if (cArray3[0] == '[') {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, cArray3));
                    } else {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, CharOperation.subarray(cArray3, 1, cArray3.length - 1)));
                    }
                    n4 += 3;
                    break;
                }
                case -70: {
                    int n16 = this.u2At(byArray, 1, n4);
                    int n22 = this.u2At(byArray2, 3, nArray2[n16]);
                    int n23 = this.u2At(byArray2, 3, nArray2[n22]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n23] + 3, this.u2At(byArray2, 1, nArray2[n23]));
                    stackMapFrame.numberOfStackItems -= this.getParametersCount(cArray);
                    char[] cArray3 = this.getReturnType(cArray);
                    if (cArray3.length == 1) {
                        switch (cArray3[0]) {
                            case 'Z': {
                                stackMapFrame.addStackItem(TypeBinding.BOOLEAN);
                                break;
                            }
                            case 'B': {
                                stackMapFrame.addStackItem(TypeBinding.BYTE);
                                break;
                            }
                            case 'C': {
                                stackMapFrame.addStackItem(TypeBinding.CHAR);
                                break;
                            }
                            case 'D': {
                                stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                                break;
                            }
                            case 'F': {
                                stackMapFrame.addStackItem(TypeBinding.FLOAT);
                                break;
                            }
                            case 'I': {
                                stackMapFrame.addStackItem(TypeBinding.INT);
                                break;
                            }
                            case 'J': {
                                stackMapFrame.addStackItem(TypeBinding.LONG);
                                break;
                            }
                            case 'S': {
                                stackMapFrame.addStackItem(TypeBinding.SHORT);
                            }
                        }
                    } else if (cArray3[0] == '[') {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, cArray3));
                    } else {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, CharOperation.subarray(cArray3, 1, cArray3.length - 1)));
                    }
                    n4 += 5;
                    break;
                }
                case -73: {
                    int n16 = this.u2At(byArray, 1, n4);
                    int n22 = this.u2At(byArray2, 3, nArray2[n16]);
                    int n23 = this.u2At(byArray2, 3, nArray2[n22]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n23] + 3, this.u2At(byArray2, 1, nArray2[n23]));
                    n23 = this.u2At(byArray2, 1, nArray2[n22]);
                    char[] cArray2 = this.utf8At(byArray2, nArray2[n23] + 3, this.u2At(byArray2, 1, nArray2[n23]));
                    stackMapFrame.numberOfStackItems -= this.getParametersCount(cArray);
                    if (CharOperation.equals(ConstantPool.Init, cArray2)) {
                        stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1].tag = 7;
                    }
                    --stackMapFrame.numberOfStackItems;
                    char[] cArray3 = this.getReturnType(cArray);
                    if (cArray3.length == 1) {
                        switch (cArray3[0]) {
                            case 'Z': {
                                stackMapFrame.addStackItem(TypeBinding.BOOLEAN);
                                break;
                            }
                            case 'B': {
                                stackMapFrame.addStackItem(TypeBinding.BYTE);
                                break;
                            }
                            case 'C': {
                                stackMapFrame.addStackItem(TypeBinding.CHAR);
                                break;
                            }
                            case 'D': {
                                stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                                break;
                            }
                            case 'F': {
                                stackMapFrame.addStackItem(TypeBinding.FLOAT);
                                break;
                            }
                            case 'I': {
                                stackMapFrame.addStackItem(TypeBinding.INT);
                                break;
                            }
                            case 'J': {
                                stackMapFrame.addStackItem(TypeBinding.LONG);
                                break;
                            }
                            case 'S': {
                                stackMapFrame.addStackItem(TypeBinding.SHORT);
                            }
                        }
                    } else if (cArray3[0] == '[') {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, cArray3));
                    } else {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, CharOperation.subarray(cArray3, 1, cArray3.length - 1)));
                    }
                    n4 += 3;
                    break;
                }
                case -72: {
                    int n16 = this.u2At(byArray, 1, n4);
                    int n22 = this.u2At(byArray2, 3, nArray2[n16]);
                    int n23 = this.u2At(byArray2, 3, nArray2[n22]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n23] + 3, this.u2At(byArray2, 1, nArray2[n23]));
                    n23 = this.u2At(byArray2, 1, nArray2[n22]);
                    char[] cArray2 = this.utf8At(byArray2, nArray2[n23] + 3, this.u2At(byArray2, 1, nArray2[n23]));
                    stackMapFrame.numberOfStackItems -= this.getParametersCount(cArray);
                    char[] cArray3 = this.getReturnType(cArray);
                    if (cArray3.length == 1) {
                        switch (cArray3[0]) {
                            case 'Z': {
                                stackMapFrame.addStackItem(TypeBinding.BOOLEAN);
                                break;
                            }
                            case 'B': {
                                stackMapFrame.addStackItem(TypeBinding.BYTE);
                                break;
                            }
                            case 'C': {
                                stackMapFrame.addStackItem(TypeBinding.CHAR);
                                break;
                            }
                            case 'D': {
                                stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                                break;
                            }
                            case 'F': {
                                stackMapFrame.addStackItem(TypeBinding.FLOAT);
                                break;
                            }
                            case 'I': {
                                stackMapFrame.addStackItem(TypeBinding.INT);
                                break;
                            }
                            case 'J': {
                                stackMapFrame.addStackItem(TypeBinding.LONG);
                                break;
                            }
                            case 'S': {
                                stackMapFrame.addStackItem(TypeBinding.SHORT);
                            }
                        }
                    } else if (cArray3[0] == '[') {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, cArray3));
                    } else {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, CharOperation.subarray(cArray3, 1, cArray3.length - 1)));
                    }
                    n4 += 3;
                    break;
                }
                case -71: {
                    int n16 = this.u2At(byArray, 1, n4);
                    int n22 = this.u2At(byArray2, 3, nArray2[n16]);
                    int n23 = this.u2At(byArray2, 3, nArray2[n22]);
                    char[] cArray = this.utf8At(byArray2, nArray2[n23] + 3, this.u2At(byArray2, 1, nArray2[n23]));
                    n23 = this.u2At(byArray2, 1, nArray2[n22]);
                    char[] cArray2 = this.utf8At(byArray2, nArray2[n23] + 3, this.u2At(byArray2, 1, nArray2[n23]));
                    stackMapFrame.numberOfStackItems -= this.getParametersCount(cArray) + 1;
                    char[] cArray3 = this.getReturnType(cArray);
                    if (cArray3.length == 1) {
                        switch (cArray3[0]) {
                            case 'Z': {
                                stackMapFrame.addStackItem(TypeBinding.BOOLEAN);
                                break;
                            }
                            case 'B': {
                                stackMapFrame.addStackItem(TypeBinding.BYTE);
                                break;
                            }
                            case 'C': {
                                stackMapFrame.addStackItem(TypeBinding.CHAR);
                                break;
                            }
                            case 'D': {
                                stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                                break;
                            }
                            case 'F': {
                                stackMapFrame.addStackItem(TypeBinding.FLOAT);
                                break;
                            }
                            case 'I': {
                                stackMapFrame.addStackItem(TypeBinding.INT);
                                break;
                            }
                            case 'J': {
                                stackMapFrame.addStackItem(TypeBinding.LONG);
                                break;
                            }
                            case 'S': {
                                stackMapFrame.addStackItem(TypeBinding.SHORT);
                            }
                        }
                    } else if (cArray3[0] == '[') {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, cArray3));
                    } else {
                        stackMapFrame.addStackItem(new VerificationTypeInfo(0, CharOperation.subarray(cArray3, 1, cArray3.length - 1)));
                    }
                    n4 += 5;
                    break;
                }
                case -69: {
                    int n16 = this.u2At(byArray, 1, n4);
                    int n23 = this.u2At(byArray2, 1, nArray2[n16]);
                    char[] cArray4 = this.utf8At(byArray2, nArray2[n23] + 3, this.u2At(byArray2, 1, nArray2[n23]));
                    VerificationTypeInfo verificationTypeInfo = new VerificationTypeInfo(0, 8, cArray4);
                    verificationTypeInfo.offset = n14;
                    stackMapFrame.addStackItem(verificationTypeInfo);
                    n4 += 3;
                    break;
                }
                case -68: {
                    char[] cArray = null;
                    switch (this.u1At(byArray, 1, n4)) {
                        case 10: {
                            cArray = new char[]{'[', 'I'};
                            break;
                        }
                        case 8: {
                            cArray = new char[]{'[', 'B'};
                            break;
                        }
                        case 4: {
                            cArray = new char[]{'[', 'Z'};
                            break;
                        }
                        case 9: {
                            cArray = new char[]{'[', 'S'};
                            break;
                        }
                        case 5: {
                            cArray = new char[]{'[', 'C'};
                            break;
                        }
                        case 11: {
                            cArray = new char[]{'[', 'J'};
                            break;
                        }
                        case 6: {
                            cArray = new char[]{'[', 'F'};
                            break;
                        }
                        case 7: {
                            cArray = new char[]{'[', 'D'};
                        }
                    }
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(1, cArray);
                    n4 += 2;
                    break;
                }
                case -67: {
                    char[] cArray;
                    int n16 = this.u2At(byArray, 1, n4);
                    int n23 = this.u2At(byArray2, 1, nArray2[n16]);
                    char[] cArray4 = this.utf8At(byArray2, nArray2[n23] + 3, this.u2At(byArray2, 1, nArray2[n23]));
                    int n24 = cArray4.length;
                    if (cArray4[0] != '[') {
                        cArray = new char[n24 + 3];
                        System.arraycopy(cArray4, 0, cArray, 2, n24);
                        cArray[0] = 91;
                        cArray[1] = 76;
                        cArray[n24 + 2] = 59;
                    } else {
                        cArray = new char[n24 + 1];
                        System.arraycopy(cArray4, 0, cArray, 1, n24);
                        cArray[0] = 91;
                    }
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(0, cArray);
                    n4 += 3;
                    break;
                }
                case -66: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.INT);
                    ++n4;
                    break;
                }
                case -65: {
                    --stackMapFrame.numberOfStackItems;
                    this.addRealJumpTarget(hashSet, ++n4 - n2);
                    break;
                }
                case -64: {
                    int n16 = this.u2At(byArray, 1, n4);
                    int n23 = this.u2At(byArray2, 1, nArray2[n16]);
                    char[] cArray4 = this.utf8At(byArray2, nArray2[n23] + 3, this.u2At(byArray2, 1, nArray2[n23]));
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(0, cArray4);
                    n4 += 3;
                    break;
                }
                case -63: {
                    stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1] = new VerificationTypeInfo(TypeBinding.INT);
                    n4 += 3;
                    break;
                }
                case -62: 
                case -61: {
                    --stackMapFrame.numberOfStackItems;
                    ++n4;
                    break;
                }
                case -60: {
                    n15 = (byte)this.u1At(byArray, 1, n4);
                    if (n15 == -124) {
                        n4 += 6;
                        break;
                    }
                    int n16 = this.u2At(byArray, 2, n4);
                    switch (n15) {
                        case 21: {
                            stackMapFrame.addStackItem(TypeBinding.INT);
                            break;
                        }
                        case 23: {
                            stackMapFrame.addStackItem(TypeBinding.FLOAT);
                            break;
                        }
                        case 25: {
                            object = stackMapFrame.locals[n16];
                            if (object == null) {
                                object = this.retrieveLocal(n14, n16);
                            }
                            stackMapFrame.addStackItem((VerificationTypeInfo)object);
                            break;
                        }
                        case 22: {
                            stackMapFrame.addStackItem(TypeBinding.LONG);
                            break;
                        }
                        case 24: {
                            stackMapFrame.addStackItem(TypeBinding.DOUBLE);
                            break;
                        }
                        case 54: {
                            --stackMapFrame.numberOfStackItems;
                            break;
                        }
                        case 56: {
                            --stackMapFrame.numberOfStackItems;
                            break;
                        }
                        case 58: {
                            stackMapFrame.locals[n16] = stackMapFrame.stackItems[stackMapFrame.numberOfStackItems - 1];
                            --stackMapFrame.numberOfStackItems;
                            break;
                        }
                        case 55: {
                            --stackMapFrame.numberOfStackItems;
                            break;
                        }
                        case 57: {
                            --stackMapFrame.numberOfStackItems;
                        }
                    }
                    n4 += 4;
                    break;
                }
                case -59: {
                    int n16 = this.u2At(byArray, 1, n4);
                    int n23 = this.u2At(byArray2, 1, nArray2[n16]);
                    char[] cArray4 = this.utf8At(byArray2, nArray2[n23] + 3, this.u2At(byArray2, 1, nArray2[n23]));
                    int n25 = this.u1At(byArray, 3, n4);
                    stackMapFrame.numberOfStackItems -= n25;
                    int n24 = cArray4.length;
                    char[] cArray = new char[n24 + n25];
                    int n26 = 0;
                    while (n26 < n25) {
                        cArray[n26] = 91;
                        ++n26;
                    }
                    System.arraycopy(cArray4, 0, cArray, n25, n24);
                    stackMapFrame.addStackItem(new VerificationTypeInfo(0, cArray));
                    n4 += 4;
                    break;
                }
                case -58: 
                case -57: {
                    --stackMapFrame.numberOfStackItems;
                    this.addRealJumpTarget(hashSet, n14 + this.i2At(byArray, 1, n4));
                    n4 += 3;
                    break;
                }
                case -56: {
                    this.addRealJumpTarget(hashSet, n14 + this.i4At(byArray, 1, n4));
                    this.addRealJumpTarget(hashSet, (n4 += 5) - n2);
                    break;
                }
                default: {
                    if (this.codeStream.methodDeclaration != null) {
                        this.codeStream.methodDeclaration.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidOpcode, new Object[]{new Byte((byte)n15), new Integer(n4), new String(methodBinding.shortReadableName())}), this.codeStream.methodDeclaration);
                        break;
                    }
                    this.codeStream.lambdaExpression.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidOpcode, new Object[]{new Byte((byte)n15), new Integer(n4), new String(methodBinding.shortReadableName())}), this.codeStream.lambdaExpression);
                }
            }
        } while (n4 < n3 + n2);
        return this.filterFakeFrames(hashSet, map, n3);
    }

    private void addRealJumpTarget(Set set, int n) {
        set.add(new Integer(n));
    }

    private void add(Map map, StackMapFrame stackMapFrame) {
        map.put(new Integer(stackMapFrame.pc), stackMapFrame);
    }

    private final int u1At(byte[] byArray, int n, int n2) {
        return byArray[n + n2] & 0xFF;
    }

    private final int u2At(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        return ((byArray[n3++] & 0xFF) << 8) + (byArray[n3] & 0xFF);
    }

    private final long u4At(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        return (((long)byArray[n3++] & 0xFFL) << 24) + (long)((byArray[n3++] & 0xFF) << 16) + (long)((byArray[n3++] & 0xFF) << 8) + (long)(byArray[n3] & 0xFF);
    }

    private final int i2At(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        return (byArray[n3++] << 8) + (byArray[n3] & 0xFF);
    }

    public char[] utf8At(byte[] byArray, int n, int n2) {
        int n3 = n2;
        char[] cArray = new char[n2];
        int n4 = 0;
        int n5 = n;
        while (n3 != 0) {
            int n6 = byArray[n5++] & 0xFF;
            --n3;
            if ((0x80 & n6) != 0) {
                if ((n6 & 0x20) != 0) {
                    n3 -= 2;
                    n6 = (n6 & 0xF) << 12 | (byArray[n5++] & 0x3F) << 6 | byArray[n5++] & 0x3F;
                } else {
                    --n3;
                    n6 = (n6 & 0x1F) << 6 | byArray[n5++] & 0x3F;
                }
            }
            cArray[n4++] = (char)n6;
        }
        if (n4 != n2) {
            char[] cArray2 = cArray;
            cArray = new char[n4];
            System.arraycopy(cArray2, 0, cArray, 0, n4);
        }
        return cArray;
    }
}

