/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.validation;

import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.types.NCName;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.BindingFault;
import org.apache.woden.wsdl20.BindingFaultReference;
import org.apache.woden.wsdl20.BindingMessageReference;
import org.apache.woden.wsdl20.BindingOperation;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.Interface;
import org.apache.woden.wsdl20.InterfaceFault;
import org.apache.woden.wsdl20.InterfaceFaultReference;
import org.apache.woden.wsdl20.InterfaceMessageReference;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.Service;
import org.apache.woden.wsdl20.WSDLComponent;

public class WSDLComponentValidator {
    public void validate(Description desc, ErrorReporter errorReporter) throws WSDLException {
        this.validateInterfaces(desc.getInterfaces(), errorReporter);
        this.validateBindings(desc.getBindings(), desc, errorReporter);
        this.validateServices(desc.getServices(), desc, errorReporter);
    }

    protected void validateInterfaces(Interface[] interfaces, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionInterface1010(interfaces, errorReporter);
        int numInterfaces = interfaces.length;
        for (int i = 0; i < numInterfaces; ++i) {
            Interface interfac = interfaces[i];
            this.testAssertionInterface1009(interfac, errorReporter);
            this.validateInterfaceOperations(interfac, interfac.getInterfaceOperations(), errorReporter);
        }
    }

    protected void validateInterfaceOperations(Interface interfac, InterfaceOperation[] interfaceOperations, ErrorReporter errorReporter) throws WSDLException {
        int numInterfaceOperations = interfaceOperations.length;
        for (int j = 0; j < numInterfaceOperations; ++j) {
            InterfaceOperation interfaceOperation = interfaceOperations[j];
            this.testAssertionMEP1022(interfaceOperation.getMessageExchangePattern(), errorReporter);
            this.validateInterfaceMessageReferences(interfaceOperation.getInterfaceMessageReferences(), errorReporter);
            this.validateInterfaceFaultReferences(interfaceOperation.getInterfaceFaultReferences(), errorReporter);
        }
    }

    protected void validateInterfaceMessageReferences(InterfaceMessageReference[] messageReferences, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionInterfaceMessageReference1029(messageReferences, errorReporter);
        int numMessageReferences = messageReferences.length;
        for (int k = 0; k < numMessageReferences; ++k) {
            InterfaceMessageReference messageReference = messageReferences[k];
            this.testAssertionInterfaceMessageReference1028(messageReference, errorReporter);
        }
    }

    protected void validateInterfaceFaultReferences(InterfaceFaultReference[] faultReferences, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionInterfaceFaultReference1039(faultReferences, errorReporter);
    }

    protected void validateBindings(Binding[] bindings, Description desc, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionBinding1049(bindings, errorReporter);
        int numBindings = bindings.length;
        for (int i = 0; i < numBindings; ++i) {
            Binding binding = bindings[i];
            this.testAssertionBinding1044(binding, errorReporter);
            this.testAssertionBinding1045(binding, errorReporter);
            this.testAssertionBinding1048(binding, errorReporter);
            this.validateBindingOperations(binding.getBindingOperations(), desc, errorReporter);
            this.validateBindingFaults(binding.getBindingFaults(), desc, errorReporter);
        }
    }

    protected void validateBindingOperations(BindingOperation[] bindingOperations, Description desc, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionBindingOperation1051(bindingOperations, errorReporter);
        int numBindingOperations = bindingOperations.length;
        for (int i = 0; i < numBindingOperations; ++i) {
            BindingOperation bindingOperation = bindingOperations[i];
            this.validateBindingMessageReferences(bindingOperation.getBindingMessageReferences(), desc, errorReporter);
            this.validateBindingFaultReferences(bindingOperation.getBindingFaultReferences(), desc, errorReporter);
        }
    }

    protected void validateBindingMessageReferences(BindingMessageReference[] bindingMessageReferences, Description desc, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionBindingMessageReference1052(bindingMessageReferences, errorReporter);
        int numBindingMessageReferences = bindingMessageReferences.length;
        for (int i = 0; i < numBindingMessageReferences; ++i) {
            BindingMessageReference bindingMessageReference = bindingMessageReferences[i];
        }
    }

    protected void validateBindingFaultReferences(BindingFaultReference[] bindingFaultReferences, Description desc, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionBindingFaultReference1055(bindingFaultReferences, errorReporter);
        int numBindingFaultReferences = bindingFaultReferences.length;
        for (int i = 0; i < numBindingFaultReferences; ++i) {
            BindingFaultReference bindingFaultReference = bindingFaultReferences[i];
            this.testAssertionBindingFaultReference1059(bindingFaultReference, errorReporter);
        }
    }

    protected void validateBindingFaults(BindingFault[] bindingFaults, Description desc, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionBindingFault1050(bindingFaults, errorReporter);
        int numBindingFaults = bindingFaults.length;
        for (int i = 0; i < numBindingFaults; ++i) {
            BindingFault bindingFault = bindingFaults[i];
        }
    }

    protected void validateServices(Service[] services, Description desc, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionService1060(services, errorReporter);
        int numServices = services.length;
        for (int i = 0; i < numServices; ++i) {
            Service service = services[i];
            this.validateEndpoints(service.getEndpoints(), desc, errorReporter);
        }
    }

    protected void validateEndpoints(Endpoint[] endpoints, Description desc, ErrorReporter errorReporter) throws WSDLException {
        int numEndpoints = endpoints.length;
        for (int i = 0; i < numEndpoints; ++i) {
            Endpoint endpoint = endpoints[i];
            this.testAssertionEndpoint1061(endpoint, errorReporter);
            this.testAssertionEndpoint1062(endpoint, errorReporter);
        }
    }

    protected boolean testAssertionInterface1009(Interface interfac, ErrorReporter errorReporter) throws WSDLException {
        Interface[] extendedInterfaces = interfac.getExtendedInterfaces();
        Interface extendedInterface = this.containsInterface(interfac, extendedInterfaces);
        if (extendedInterface != null) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Interface-1009", new Object[]{extendedInterface.getName()}, (short)2);
            return false;
        }
        return true;
    }

    private Interface containsInterface(Interface interfac, Interface[] extendedInterfaces) {
        int numExtInterfaces = extendedInterfaces.length;
        for (int i = 0; i < numExtInterfaces; ++i) {
            if (interfac.isEquivalentTo((WSDLComponent)extendedInterfaces[i])) {
                return extendedInterfaces[i];
            }
            if (this.containsInterface(interfac, extendedInterfaces[i].getExtendedInterfaces()) == null) continue;
            return extendedInterfaces[i];
        }
        return null;
    }

    protected boolean testAssertionInterface1010(Interface[] interfaces, ErrorReporter errorReporter) throws WSDLException {
        boolean duplicateFound = false;
        ArrayList<QName> names = new ArrayList<QName>();
        int numInterfaces = interfaces.length;
        for (int i = 0; i < numInterfaces; ++i) {
            QName name = interfaces[i].getName();
            if (name == null) continue;
            if (names.contains(name)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Interface-1010", new Object[]{name}, (short)2);
                duplicateFound = true;
                continue;
            }
            names.add(name);
        }
        return !duplicateFound;
    }

    protected boolean testAssertionMEP1022(URI pattern, ErrorReporter errorReporter) throws WSDLException {
        if (!pattern.isAbsolute()) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "MEP-1022", new Object[]{pattern}, (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionInterfaceMessageReference1028(InterfaceMessageReference messageReference, ErrorReporter errorReporter) throws WSDLException {
        String messContentModel = messageReference.getMessageContentModel();
        if ((messContentModel.equals("#any") || messContentModel.equals("#none")) && messageReference.getElementDeclaration() != null) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "InterfaceMessageReference-1028", new Object[0], (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionInterfaceMessageReference1029(InterfaceMessageReference[] messageReferences, ErrorReporter errorReporter) throws WSDLException {
        ArrayList<NCName> messageLabels = new ArrayList<NCName>();
        int numMessageReferences = messageReferences.length;
        for (int i = 0; i < numMessageReferences; ++i) {
            NCName messageLabel = messageReferences[i].getMessageLabel();
            if (messageLabel == null) continue;
            if (messageLabels.contains(messageLabel)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "InterfaceMessageReference-1029", new Object[]{messageLabel}, (short)2);
                return false;
            }
            messageLabels.add(messageLabel);
        }
        return true;
    }

    protected boolean testAssertionInterfaceFaultReference1039(InterfaceFaultReference[] faultReferences, ErrorReporter errorReporter) throws WSDLException {
        Hashtable<InterfaceFault, ArrayList<NCName>> identifiers = new Hashtable<InterfaceFault, ArrayList<NCName>>();
        int numFaultReferences = faultReferences.length;
        for (int i = 0; i < numFaultReferences; ++i) {
            InterfaceFault fault = faultReferences[i].getInterfaceFault();
            NCName messageLabel = faultReferences[i].getMessageLabel();
            if (fault == null || messageLabel == null) continue;
            ArrayList<NCName> messageLabels = (ArrayList<NCName>)identifiers.get(fault);
            if (messageLabels != null && messageLabels.contains(messageLabel)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "InterfaceFaultReference-1039", new Object[]{fault, messageLabel}, (short)2);
                return false;
            }
            if (messageLabels == null) {
                messageLabels = new ArrayList<NCName>();
            }
            messageLabels.add(messageLabel);
            identifiers.put(fault, messageLabels);
        }
        return true;
    }

    protected boolean testAssertionBinding1044(Binding binding, ErrorReporter errorReporter) throws WSDLException {
        BindingOperation[] bindingOperations = binding.getBindingOperations();
        BindingFault[] bindingFaults = binding.getBindingFaults();
        Interface bindingInterface = binding.getInterface();
        if ((bindingOperations != null && bindingOperations.length > 0 || bindingFaults != null && bindingFaults.length > 0) && bindingInterface == null) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Binding-1044", new Object[0], (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionBinding1045(Binding binding, ErrorReporter errorReporter) throws WSDLException {
        Interface[] extendedInterfaces;
        boolean allInterfaceOperationsHaveBinding = true;
        QName bindingQN = binding.getName();
        String bindingName = bindingQN != null ? bindingQN.getLocalPart() : null;
        Interface interfac = binding.getInterface();
        if (interfac == null) {
            return true;
        }
        BindingOperation[] bindingOperations = binding.getBindingOperations();
        int numBindingOperations = bindingOperations.length;
        ArrayList<InterfaceOperation> usedInterfaceOperationList = new ArrayList<InterfaceOperation>();
        for (int i = 0; i < numBindingOperations; ++i) {
            InterfaceOperation io = bindingOperations[i].getInterfaceOperation();
            if (io == null) continue;
            usedInterfaceOperationList.add(io);
        }
        if (!this.checkAllInterfaceOperationsHaveBinding(bindingName, interfac, usedInterfaceOperationList, errorReporter)) {
            allInterfaceOperationsHaveBinding = false;
        }
        if ((extendedInterfaces = interfac.getExtendedInterfaces()) != null) {
            int numExtendedInterfaces = extendedInterfaces.length;
            for (int i = 0; i < numExtendedInterfaces; ++i) {
                if (this.checkAllInterfaceOperationsHaveBinding(bindingName, extendedInterfaces[i], usedInterfaceOperationList, errorReporter)) continue;
                allInterfaceOperationsHaveBinding = false;
            }
        }
        return allInterfaceOperationsHaveBinding;
    }

    private boolean checkAllInterfaceOperationsHaveBinding(String bindingName, Interface interfac, List usedInterfaceOperations, ErrorReporter errorReporter) throws WSDLException {
        boolean allInterfaceOperationsHaveBinding = true;
        InterfaceOperation[] interfaceOperations = interfac.getInterfaceOperations();
        if (interfaceOperations == null) {
            return true;
        }
        int numInterfaceOperations = interfaceOperations.length;
        for (int i = 0; i < numInterfaceOperations; ++i) {
            if (usedInterfaceOperations.contains(interfaceOperations[i])) continue;
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Binding-1045", new Object[]{bindingName, interfaceOperations[i].getName()}, (short)2);
            allInterfaceOperationsHaveBinding = false;
        }
        return allInterfaceOperationsHaveBinding;
    }

    protected boolean testAssertionBinding1048(Binding binding, ErrorReporter errorReporter) throws WSDLException {
        URI type = binding.getType();
        if (type != null && !type.isAbsolute()) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Binding-1048", new Object[]{type}, (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionBinding1049(Binding[] bindings, ErrorReporter errorReporter) throws WSDLException {
        boolean duplicateFound = false;
        ArrayList<QName> names = new ArrayList<QName>();
        int numBindings = bindings.length;
        for (int i = 0; i < numBindings; ++i) {
            QName name = bindings[i].getName();
            if (name == null) continue;
            if (names.contains(name)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Binding-1049", new Object[]{name}, (short)2);
                duplicateFound = true;
                continue;
            }
            names.add(name);
        }
        return !duplicateFound;
    }

    protected boolean testAssertionBindingFault1050(BindingFault[] bindingFaults, ErrorReporter errorReporter) throws WSDLException {
        boolean duplicateFound = false;
        ArrayList<InterfaceFault> usedInterfaceFaults = new ArrayList<InterfaceFault>();
        int numBindingFaults = bindingFaults.length;
        for (int i = 0; i < numBindingFaults; ++i) {
            InterfaceFault interfaceFault = bindingFaults[i].getInterfaceFault();
            if (interfaceFault == null) continue;
            if (usedInterfaceFaults.contains(interfaceFault)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "BindingFault-1050", new Object[0], (short)2);
                duplicateFound = true;
                continue;
            }
            usedInterfaceFaults.add(interfaceFault);
        }
        return !duplicateFound;
    }

    protected boolean testAssertionBindingOperation1051(BindingOperation[] bindingOperations, ErrorReporter errorReporter) throws WSDLException {
        boolean duplicateFound = false;
        ArrayList<InterfaceOperation> specifiedInterfaceOperations = new ArrayList<InterfaceOperation>();
        int numBindingOperations = bindingOperations.length;
        for (int i = 0; i < numBindingOperations; ++i) {
            InterfaceOperation interfaceOperation = bindingOperations[i].getInterfaceOperation();
            if (interfaceOperation == null) continue;
            if (specifiedInterfaceOperations.contains(interfaceOperation)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "BindingOperation-1051", new Object[]{interfaceOperation.getName()}, (short)2);
                duplicateFound = true;
                continue;
            }
            specifiedInterfaceOperations.add(interfaceOperation);
        }
        return !duplicateFound;
    }

    protected boolean testAssertionBindingMessageReference1052(BindingMessageReference[] bindingMessageReferences, ErrorReporter errorReporter) throws WSDLException {
        boolean duplicateFound = false;
        ArrayList<InterfaceMessageReference> specifiedInterfaceMessageReferences = new ArrayList<InterfaceMessageReference>();
        int numBindingMessageReferences = bindingMessageReferences.length;
        for (int i = 0; i < numBindingMessageReferences; ++i) {
            InterfaceMessageReference interfaceMessageReference = bindingMessageReferences[i].getInterfaceMessageReference();
            if (interfaceMessageReference == null) continue;
            if (specifiedInterfaceMessageReferences.contains(interfaceMessageReference)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "BindingMessageReference-1052", new Object[]{interfaceMessageReference.getMessageLabel()}, (short)2);
                duplicateFound = true;
                continue;
            }
            specifiedInterfaceMessageReferences.add(interfaceMessageReference);
        }
        return !duplicateFound;
    }

    protected boolean testAssertionBindingFaultReference1055(BindingFaultReference[] bindingFaultReferences, ErrorReporter errorReporter) throws WSDLException {
        boolean duplicateFound = false;
        ArrayList<InterfaceFaultReference> specifiedInterfaceFaultReferences = new ArrayList<InterfaceFaultReference>();
        int numBindingFaultReferences = bindingFaultReferences.length;
        for (int i = 0; i < numBindingFaultReferences; ++i) {
            InterfaceFaultReference interfaceFaultReference = bindingFaultReferences[i].getInterfaceFaultReference();
            if (interfaceFaultReference == null) continue;
            if (specifiedInterfaceFaultReferences.contains(interfaceFaultReference)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "BindingFaultReference-1055", new Object[]{interfaceFaultReference.getMessageLabel()}, (short)2);
                duplicateFound = true;
                continue;
            }
            specifiedInterfaceFaultReferences.add(interfaceFaultReference);
        }
        return !duplicateFound;
    }

    protected boolean testAssertionBindingFaultReference1059(BindingFaultReference bindingFaultReference, ErrorReporter errorReporter) throws WSDLException {
        InterfaceFaultReference interfaceFaultReference = bindingFaultReference.getInterfaceFaultReference();
        if (interfaceFaultReference == null) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "BindingFaultReference-1059", new Object[0], (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionService1060(Service[] services, ErrorReporter errorReporter) throws WSDLException {
        ArrayList<QName> names = new ArrayList<QName>();
        int numServices = services.length;
        for (int i = 0; i < numServices; ++i) {
            QName name = services[i].getName();
            if (name == null) continue;
            if (names.contains(name)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Service-1060", new Object[]{name}, (short)2);
                return false;
            }
            names.add(name);
        }
        return true;
    }

    protected boolean testAssertionEndpoint1061(Endpoint endpoint, ErrorReporter errorReporter) throws WSDLException {
        URI address = endpoint.getAddress();
        if (address != null && !address.isAbsolute()) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Endpoint-1061", new Object[]{address}, (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionEndpoint1062(Endpoint endpoint, ErrorReporter errorReporter) throws WSDLException {
        Service service;
        Interface serviceInterface;
        Binding binding = endpoint.getBinding();
        if (binding == null) {
            return true;
        }
        Interface bindingInterface = binding.getInterface();
        WSDLComponent parent = endpoint.getParent();
        if (parent != null && (serviceInterface = (service = (Service)parent).getInterface()) != null && bindingInterface != null && !serviceInterface.isEquivalentTo((WSDLComponent)bindingInterface)) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Endpoint-1062", new Object[]{binding, bindingInterface, serviceInterface}, (short)2);
            return false;
        }
        return true;
    }
}

