/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.antrun;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.antrun.AntPropertyHelper;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.types.Path;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractAntMojo
extends AbstractMojo {
    private List artifacts;

    protected void executeTasks(Target antTasks, MavenProject mavenProject) throws MojoExecutionException {
        try {
            ExpressionEvaluator exprEvaluator = (ExpressionEvaluator)antTasks.getProject().getReference("maven.expressionEvaluator");
            Project antProject = antTasks.getProject();
            PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)antProject);
            propertyHelper.setNext((PropertyHelper)new AntPropertyHelper(exprEvaluator, this.getLog()));
            DefaultLogger antLogger = new DefaultLogger();
            antLogger.setOutputPrintStream(System.out);
            antLogger.setErrorPrintStream(System.err);
            antLogger.setMessageOutputLevel(2);
            antProject.addBuildListener((BuildListener)antLogger);
            antProject.setBaseDir(mavenProject.getBasedir());
            Path p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getArtifacts().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.dependency.classpath", (Object)p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getCompileClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.compile.classpath", (Object)p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getRuntimeClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.runtime.classpath", (Object)p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getTestClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.test.classpath", (Object)p);
            ArrayList<String> list = new ArrayList<String>(this.artifacts.size());
            Iterator i = this.artifacts.iterator();
            while (i.hasNext()) {
                Artifact a = (Artifact)i.next();
                File file = a.getFile();
                if (file == null) {
                    throw new DependencyResolutionRequiredException(a);
                }
                list.add(file.getPath());
            }
            p = new Path(antProject);
            p.setPath(StringUtils.join(list.iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.plugin.classpath", (Object)p);
            this.getLog().info((CharSequence)"Executing tasks");
            antTasks.execute();
            this.getLog().info((CharSequence)"Executed tasks");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing ant tasks", e);
        }
    }
}

