/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.1
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif



#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1,
  SWIG_JavaIOException,
  SWIG_JavaRuntimeException,
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError,
  SWIG_JavaIllegalStateException,
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { SWIG_JavaIllegalStateException, "java/lang/IllegalStateException" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1
#define  SWIG_IOError        	   -2
#define  SWIG_RuntimeError   	   -3
#define  SWIG_IndexError     	   -4
#define  SWIG_TypeError      	   -5
#define  SWIG_DivisionByZero 	   -6
#define  SWIG_OverflowError  	   -7
#define  SWIG_SyntaxError    	   -8
#define  SWIG_ValueError     	   -9
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12
#define  SWIG_NullReferenceError   -13




  #include <SWIG_CGAL/Java/exception.h>


SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <typeinfo>
#include <stdexcept>


#include <string>


#if !defined(SWIGPYTHON) && !defined(SWIGJAVA)
  #define SWIG_CGAL_NON_SUPPORTED_TARGET_LANGUAGE 1
#else
  #define SWIG_CGAL_NON_SUPPORTED_TARGET_LANGUAGE 0
#endif  


  #include <SWIG_CGAL/Common/Iterator.h>
  #include  <SWIG_CGAL/Polyhedron_3/all_includes.h>
  #include  <SWIG_CGAL/Polygon_mesh_processing/all_includes.h>

typedef Polyhedron_3_wrapper< Polyhedron_3_,SWIG_Polyhedron_3::CGAL_Vertex_handle<Polyhedron_3_>,SWIG_Polyhedron_3::CGAL_Halfedge_handle<Polyhedron_3_>,SWIG_Polyhedron_3::CGAL_Facet_handle<Polyhedron_3_> >  Polyhedron_3_SWIG_wrapper; 
typedef SWIG_Polyhedron_3::CGAL_Halfedge_handle<Polyhedron_3_>  Polyhedron_3_Halfedge_handle_SWIG_wrapper; 
typedef SWIG_Polyhedron_3::CGAL_Facet_handle<Polyhedron_3_>  Polyhedron_3_Facet_handle_SWIG_wrapper; 
typedef SWIG_Polyhedron_3::CGAL_Vertex_handle<Polyhedron_3_>  Polyhedron_3_Vertex_handle_SWIG_wrapper; 
 typedef Polygon_mesh_slicer_wrapper<Polyhedron_3_SWIG_wrapper>  Polygon_mesh_slicer_SWIG_wrapper; 
 typedef Side_of_triangle_mesh_wrapper<Polyhedron_3_SWIG_wrapper>  Side_of_triangle_mesh_SWIG_wrapper; 
 typedef SWIG_CGAL::Triple<int,int,int>  Integer_triple_SWIG_wrapper; 

#include <typeinfo>
#include <stdexcept>


#include <utility>

 typedef std::pair<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper>  Facet_pair_SWIG_wrapper; 
 typedef std::pair<Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper>  Halfedge_pair_SWIG_wrapper; 

#include <vector>
#include <stdexcept>


/* Check for overflow converting to Java int (always signed 32-bit) from (unsigned variable-bit) size_t */
SWIGINTERN jint SWIG_JavaIntFromSize_t(size_t size) {
  static const jint JINT_MAX = 0x7FFFFFFF;
  return (size > (size_t)JINT_MAX) ? -1 : (jint)size;
}


SWIGINTERN jint SWIG_VectorSize(size_t size) {
  jint sz = SWIG_JavaIntFromSize_t(size);
  if (sz == -1)
    throw std::out_of_range("vector size is too large to fit into a Java int");
  return sz;
}

SWIGINTERN std::vector< Point_3 > *new_std_vector_Sl_Point_3_Sg___SWIG_2(jint count,Point_3 const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< Point_3 >(static_cast<std::vector< Point_3 >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_Point_3_Sg__doSize(std::vector< Point_3 > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_Point_3_Sg__doAdd__SWIG_0(std::vector< Point_3 > *self,std::vector< Point_3 >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_Point_3_Sg__doAdd__SWIG_1(std::vector< Point_3 > *self,jint index,std::vector< Point_3 >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< Point_3 >::value_type std_vector_Sl_Point_3_Sg__doRemove(std::vector< Point_3 > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          Point_3 const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< Point_3 >::value_type const &std_vector_Sl_Point_3_Sg__doGet(std::vector< Point_3 > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< Point_3 >::value_type std_vector_Sl_Point_3_Sg__doSet(std::vector< Point_3 > *self,jint index,std::vector< Point_3 >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          Point_3 const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_Point_3_Sg__doRemoveRange(std::vector< Point_3 > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< int > *new_std_vector_Sl_int_Sg___SWIG_2(jint count,int const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< int >(static_cast<std::vector< int >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_int_Sg__doSize(std::vector< int > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_int_Sg__doAdd__SWIG_0(std::vector< int > *self,std::vector< int >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_int_Sg__doAdd__SWIG_1(std::vector< int > *self,jint index,std::vector< int >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< int >::value_type std_vector_Sl_int_Sg__doRemove(std::vector< int > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          int const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< int >::value_type const &std_vector_Sl_int_Sg__doGet(std::vector< int > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< int >::value_type std_vector_Sl_int_Sg__doSet(std::vector< int > *self,jint index,std::vector< int >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          int const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_int_Sg__doRemoveRange(std::vector< int > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< int > > *new_std_vector_Sl_std_vector_Sl_int_Sg__Sg___SWIG_2(jint count,std::vector< int > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::vector< int > >(static_cast<std::vector< std::vector< int > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_vector_Sl_int_Sg__Sg__doSize(std::vector< std::vector< int > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_int_Sg__Sg__doAdd__SWIG_0(std::vector< std::vector< int > > *self,std::vector< std::vector< int > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_int_Sg__Sg__doAdd__SWIG_1(std::vector< std::vector< int > > *self,jint index,std::vector< std::vector< int > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< int > >::value_type std_vector_Sl_std_vector_Sl_int_Sg__Sg__doRemove(std::vector< std::vector< int > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::vector< int > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< int > >::value_type const &std_vector_Sl_std_vector_Sl_int_Sg__Sg__doGet(std::vector< std::vector< int > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::vector< int > >::value_type std_vector_Sl_std_vector_Sl_int_Sg__Sg__doSet(std::vector< std::vector< int > > *self,jint index,std::vector< std::vector< int > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::vector< int > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_int_Sg__Sg__doRemoveRange(std::vector< std::vector< int > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< Point_3 > > *new_std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg___SWIG_2(jint count,std::vector< Point_3 > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::vector< Point_3 > >(static_cast<std::vector< std::vector< Point_3 > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg__doSize(std::vector< std::vector< Point_3 > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg__doAdd__SWIG_0(std::vector< std::vector< Point_3 > > *self,std::vector< std::vector< Point_3 > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg__doAdd__SWIG_1(std::vector< std::vector< Point_3 > > *self,jint index,std::vector< std::vector< Point_3 > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< Point_3 > >::value_type std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg__doRemove(std::vector< std::vector< Point_3 > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::vector< Point_3 > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< Point_3 > >::value_type const &std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg__doGet(std::vector< std::vector< Point_3 > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::vector< Point_3 > >::value_type std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg__doSet(std::vector< std::vector< Point_3 > > *self,jint index,std::vector< std::vector< Point_3 > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::vector< Point_3 > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg__doRemoveRange(std::vector< std::vector< Point_3 > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }

  #include <CGAL/polygon_mesh_processing.h>
  #include <SWIG_CGAL/Common/Wrapper_iterator_helper.h>
  #include <SWIG_CGAL/Common/triple.h>
  #include <SWIG_CGAL/Polygon_mesh_processing/utils.h>
  #include <iostream>


  #ifndef SWIG
  #include <boost/shared_ptr.hpp>
  namespace PMP=CGAL::Polygon_mesh_processing;
  namespace params=CGAL::Polygon_mesh_processing::parameters;

  #if CGAL_VERSION_NR < 1040800000
  namespace CGAL{
    template <typename T>
    Iterator_range<T>
    make_range(const std::pair<T,T>& p)
    {
      return Iterator_range<T>(p.first,p.second);
    }
  }
  #endif // CGAL 4.7

  struct Is_constrained_map{
    typedef boost::graph_traits<Polyhedron_3_SWIG_wrapper::cpp_base>::edge_descriptor key_type;
    std::set<key_type>* m_set;
    typedef boost::readable_property_map_tag category;
    typedef bool value_type;
    typedef bool reference;

    Is_constrained_map() : m_set(NULL) {}
    Is_constrained_map(std::set<key_type>& set_) : m_set(&set_) {}

    friend bool get(const Is_constrained_map& map, const key_type& k)
    {
      CGAL_assertion(map.m_set != NULL);
      return map.m_set->count(k);
    }

    friend void put(const Is_constrained_map& map, const key_type& k, value_type b)
    {
      CGAL_assertion(map.m_set != NULL);
      if (b)
        map.m_set->insert(k);
      else
        map.m_set->erase(k);
    }
  };

  #endif // SWIG
  // input iterators
  typedef Wrapper_iterator_helper<Polyhedron_3_Vertex_handle_SWIG_wrapper>::input Vertex_range;
  typedef Wrapper_iterator_helper<Polyhedron_3_Facet_handle_SWIG_wrapper>::input Facet_range;
  typedef Wrapper_iterator_helper<Polyhedron_3_Halfedge_handle_SWIG_wrapper>::input Halfedge_range;
  typedef Wrapper_iterator_helper<Halfedge_pair_SWIG_wrapper>::input Halfedge_pair_range;
  typedef Wrapper_iterator_helper<Point_3>::input Point_3_range;
  // output iterators
  typedef Wrapper_iterator_helper<Polyhedron_3_Vertex_handle_SWIG_wrapper>::output Vertex_output_iterator;
  typedef Wrapper_iterator_helper<Polyhedron_3_Halfedge_handle_SWIG_wrapper>::output Halfedge_output_iterator;
  typedef Wrapper_iterator_helper<Polyhedron_3_Facet_handle_SWIG_wrapper>::output Facet_output_iterator;
  typedef Wrapper_iterator_helper<Integer_triple_SWIG_wrapper>::output Integer_triple_output_iterator;
  typedef Wrapper_iterator_helper<Facet_pair_SWIG_wrapper>::output Facet_pair_output_iterator;
  typedef Wrapper_iterator_helper<Vector_3>::output Vector_3_output_iterator;
  typedef Wrapper_iterator_helper<int>::output Integer_output_iterator;

// Meshing Functions
//   CGAL::Polygon_mesh_processing::fair()
  void fair(Polyhedron_3_SWIG_wrapper& P,
            Vertex_range vertex_range)
  {
    PMP::fair(P.get_data(), vertex_range);
  }

  void fair(Polyhedron_3_SWIG_wrapper& P,
            Vertex_range vertex_range,
            int fairing_continuity)
  {
    PMP::fair(P.get_data(), vertex_range,
              params::fairing_continuity(fairing_continuity));
  }
//   CGAL::Polygon_mesh_processing::refine()
  void refine( Polyhedron_3_SWIG_wrapper& P,
               Facet_range facet_range,
               Facet_output_iterator facet_output,
               Vertex_output_iterator vertex_output)
  {
    PMP::refine(P.get_data(), facet_range, facet_output, vertex_output);
  }
  void refine( Polyhedron_3_SWIG_wrapper& P,
               Facet_range facet_range,
               Facet_output_iterator facet_output,
               Vertex_output_iterator vertex_output,
               double density_control_factor)
  {
    PMP::refine(P.get_data(), facet_range, facet_output, vertex_output,
                params::fairing_continuity(density_control_factor));
  }

#if CGAL_VERSION_NR >= 1040800000
// CGAL::Polygon_mesh_processing::triangulate_face()
  void triangulate_face(Polyhedron_3_Facet_handle_SWIG_wrapper& face,
		                    Polyhedron_3_SWIG_wrapper& P)
  {
    PMP::triangulate_face(face.get_data(), P.get_data());
  }
#endif //CGAL 4.8 or later

//   CGAL::Polygon_mesh_processing::triangulate_faces()
  void triangulate_faces(Polyhedron_3_SWIG_wrapper& P)
  {
    PMP::triangulate_faces(P.get_data());
  }

#if CGAL_VERSION_NR >= 1040800000
  void triangulate_faces (Facet_range facet_range,
                          Polyhedron_3_SWIG_wrapper& P)
  {
    PMP::triangulate_faces(facet_range, P.get_data());
  }

//   CGAL::Polygon_mesh_processing::isotropic_remeshing() (4.8)
  void isotropic_remeshing(Facet_range facet_range,
                           double target_edge_length,
                           Polyhedron_3_SWIG_wrapper& P,
                           int number_of_iterations,
                           Halfedge_range constraints,
                           bool protect_constraints=false)
  {
    typedef Polyhedron_3_SWIG_wrapper::cpp_base Polyhedron;
    typedef boost::graph_traits<Polyhedron>::edge_descriptor edge_descriptor;
    std::set<edge_descriptor> constrained_edges;
    BOOST_FOREACH(Polyhedron::Halfedge_handle h, constraints)
      constrained_edges.insert(edge(h,P.get_data()));
    CGAL::set_halfedgeds_items_id(P.get_data());
    // isotropic_remeshing requires a ForwardIterator
    std::vector<Polyhedron_3_SWIG_wrapper::cpp_base::Face_handle> faces(facet_range.first, facet_range.second);
    PMP::isotropic_remeshing(faces, target_edge_length, P.get_data(),
                             params::number_of_iterations(number_of_iterations).
                             edge_is_constrained_map(
                              Is_constrained_map(constrained_edges)).
                              protect_constraints(protect_constraints)
                              );
  }
  void isotropic_remeshing(Facet_range facet_range,
                           double target_edge_length,
                           Polyhedron_3_SWIG_wrapper& P,
                           int number_of_iterations)
  {
    CGAL::set_halfedgeds_items_id(P.get_data());
    // isotropic_remeshing requires a ForwardIterator
    std::vector<Polyhedron_3_SWIG_wrapper::cpp_base::Face_handle> faces(facet_range.first, facet_range.second);
    PMP::isotropic_remeshing(faces, target_edge_length, P.get_data(),
                             params::number_of_iterations(number_of_iterations));
  }
  void isotropic_remeshing(Facet_range facet_range,
                           double target_edge_length,
                           Polyhedron_3_SWIG_wrapper& P)
  {
    CGAL::set_halfedgeds_items_id(P.get_data());
    // isotropic_remeshing requires a ForwardIterator
    std::vector<Polyhedron_3_SWIG_wrapper::cpp_base::Face_handle> faces(facet_range.first, facet_range.second);
    PMP::isotropic_remeshing(make_range(facet_range), target_edge_length, P.get_data());
  }
//   CGAL::Polygon_mesh_processing::split_long_edges() (4.8)
  void split_long_edges(Halfedge_range halfedge_range,
                        const double& max_length,
                        Polyhedron_3_SWIG_wrapper& P)
  {
    typedef Polyhedron_3_SWIG_wrapper::cpp_base Polyhedron;
    typedef boost::graph_traits<Polyhedron>::edge_descriptor edge_descriptor;
    std::vector<edge_descriptor> edges;
    BOOST_FOREACH(Polyhedron::Halfedge_handle h, halfedge_range)
      edges.push_back(edge(h,P.get_data()));
    PMP::split_long_edges(edges, max_length, P.get_data());
  }
//
#endif // CGAL 4.8 or later
// Hole Filling Functions
//   CGAL::Polygon_mesh_processing::triangulate_hole()
  void triangulate_hole(Polyhedron_3_SWIG_wrapper& P,
                        Polyhedron_3_Halfedge_handle_SWIG_wrapper& h,
                        Facet_output_iterator output)
  {
    CGAL::Polygon_mesh_processing::triangulate_hole(P.get_data(), h.get_data(),
                                                    output);
  }
//   CGAL::Polygon_mesh_processing::triangulate_and_refine_hole()
  void triangulate_and_refine_hole( Polyhedron_3_SWIG_wrapper& P,
                                    Polyhedron_3_Halfedge_handle_SWIG_wrapper& h,
                                    Facet_output_iterator facet_output,
                                    Vertex_output_iterator vertex_output)
  {
    PMP::triangulate_and_refine_hole(P.get_data(), h.get_data(), facet_output,
                                     vertex_output);
  }
  void triangulate_and_refine_hole( Polyhedron_3_SWIG_wrapper& P,
                                    Polyhedron_3_Halfedge_handle_SWIG_wrapper& h,
                                    Facet_output_iterator facet_output,
                                    Vertex_output_iterator vertex_output,
                                    double density_control_factor)
  {
    PMP::triangulate_and_refine_hole(P.get_data(), h.get_data(), facet_output,
                                     vertex_output,
                                     params::density_control_factor(density_control_factor));
  }
//   CGAL::Polygon_mesh_processing::triangulate_refine_and_fair_hole()
  void triangulate_refine_and_fair_hole( Polyhedron_3_SWIG_wrapper& P,
                                         Polyhedron_3_Halfedge_handle_SWIG_wrapper& h,
                                         Facet_output_iterator facet_output,
                                         Vertex_output_iterator vertex_output)
  {
    PMP::triangulate_refine_and_fair_hole(P.get_data(), h.get_data(),
                                          facet_output, vertex_output);
  }
  void triangulate_refine_and_fair_hole( Polyhedron_3_SWIG_wrapper& P,
                                         Polyhedron_3_Halfedge_handle_SWIG_wrapper& h,
                                         Facet_output_iterator facet_output,
                                         Vertex_output_iterator vertex_output,
                                         double density_control_factor)
  {
    PMP::triangulate_refine_and_fair_hole(P.get_data(), h.get_data(), facet_output,
                                          vertex_output,
                                          params::density_control_factor(density_control_factor));
  }
  void triangulate_refine_and_fair_hole( Polyhedron_3_SWIG_wrapper& P,
                                         Polyhedron_3_Halfedge_handle_SWIG_wrapper& h,
                                         Facet_output_iterator facet_output,
                                         Vertex_output_iterator vertex_output,
                                         double density_control_factor,
                                         int fairing_continuity)
  {
    PMP::triangulate_refine_and_fair_hole(P.get_data(), h.get_data(),
                                          facet_output, vertex_output,
                                          params::density_control_factor(density_control_factor).
                                          fairing_continuity(fairing_continuity));
  }
//   CGAL::Polygon_mesh_processing::triangulate_hole_polyline()
  void triangulate_hole_polyline 	(Point_3_range points,
  		                             Point_3_range third_points,
                                   Integer_triple_output_iterator out)
  {
    PMP::triangulate_hole_polyline( CGAL::make_range(points),
                                    CGAL::make_range(third_points),
                                    out);
  }
  #if CGAL_VERSION_NR >= 1040800000
  // not activated in 4.7 due to a bug in CGAL
  void triangulate_hole_polyline 	(Point_3_range points,
                                   Integer_triple_output_iterator out)
  {
    PMP::triangulate_hole_polyline( CGAL::make_range(points),
                                    out);
  }
  #endif // CGAL 4.8 or later

//
// Predicate Functions
//   CGAL::Polygon_mesh_processing::does_self_intersect()
  bool does_self_intersect(Polyhedron_3_SWIG_wrapper& P)
  {
    return PMP::does_self_intersect(P.get_data());
  }
//   CGAL::Polygon_mesh_processing::self_intersections()
  void self_intersections(Polyhedron_3_SWIG_wrapper& P,
                          Facet_pair_output_iterator out)
  {
    PMP::self_intersections(P.get_data(), out);
  }
//
// Orientation Functions
//   CGAL::Polygon_mesh_processing::is_outward_oriented()
  bool is_outward_oriented(Polyhedron_3_SWIG_wrapper& P)
  {
    return PMP::is_outward_oriented(P.get_data());
  }
//   CGAL::Polygon_mesh_processing::reverse_face_orientations()
  void reverse_face_orientations(Polyhedron_3_SWIG_wrapper& P)
  {
    PMP::reverse_face_orientations(P.get_data());
  }
  void reverse_face_orientations(Facet_range face_range,
                                 Polyhedron_3_SWIG_wrapper& P)
  {
    PMP::reverse_face_orientations(CGAL::make_range(face_range), P.get_data());
  }
//   CGAL::Polygon_mesh_processing::orient_polygon_soup()
  bool orient_polygon_soup(std::vector<Point_3>& points,
                           std::vector< std::vector<int> >& polygons)
  {
    std::size_t nb_pts = points.size();
    std::vector< Point_3::cpp_base > cgal_points;
    cgal_points.reserve(nb_pts);
    BOOST_FOREACH(const Point_3& pt, points)
      cgal_points.push_back( pt.get_data() );
    bool res = PMP::orient_polygon_soup(cgal_points, polygons);
    if (cgal_points.size()>nb_pts)
      for (std::size_t i=nb_pts;i<cgal_points.size();++i)
        points.push_back( Point_3(cgal_points[i]) );
    return res;
  }
//
// Combinatorial Repairing Functions
//   CGAL::Polygon_mesh_processing::stitch_borders()
  void stitch_borders(Polyhedron_3_SWIG_wrapper& P)
  {
    PMP::stitch_borders(P.get_data());
  }
  void stitch_borders(Polyhedron_3_SWIG_wrapper& P,
                      Halfedge_pair_range hedges)
  {
    PMP::stitch_borders(P.get_data(), CGAL::make_range(hedges));
  }
//   CGAL::Polygon_mesh_processing::polygon_soup_to_polygon_mesh()
  void polygon_soup_to_polygon_mesh(const std::vector<Point_3>& points,
                                    const std::vector< std::vector<int> >& polygons,
                                    Polyhedron_3_SWIG_wrapper& P)
  {
    std::size_t nb_pts = points.size();
    std::vector< Point_3::cpp_base > cgal_points;
    cgal_points.reserve(nb_pts);
    BOOST_FOREACH(const Point_3& pt, points)
      cgal_points.push_back( pt.get_data() );
    PMP::polygon_soup_to_polygon_mesh(cgal_points, polygons, P.get_data());
  }

#if CGAL_VERSION_NR >= 1040800000
//   CGAL::Polygon_mesh_processing::remove_isolated_vertices() (4.8)
void remove_isolated_vertices(Polyhedron_3_SWIG_wrapper& P)
{
  PMP::remove_isolated_vertices(P.get_data());
}
#endif // CGAL 4.8 or later
//
// Normal Computation Functions
//   CGAL::Polygon_mesh_processing::compute_face_normal()
  Vector_3 compute_face_normal(Polyhedron_3_Facet_handle_SWIG_wrapper& face,
                               Polyhedron_3_SWIG_wrapper& P)
  {
    return PMP::compute_face_normal(face.get_data(), P.get_data());
  }
  void compute_face_normal(Polyhedron_3_Facet_handle_SWIG_wrapper& face,
                           Polyhedron_3_SWIG_wrapper& P,
                           Vector_3& output_normal)
  {
    output_normal=Vector_3(
        PMP::compute_face_normal(face.get_data(), P.get_data()) );
  }
//   CGAL::Polygon_mesh_processing::compute_face_normals()
  void compute_face_normals(Polyhedron_3_SWIG_wrapper& P,
                            Vector_3_output_iterator out)
  {
    CGAL::set_halfedgeds_items_id(P.get_data());
    std::vector< EPIC_Kernel::Vector_3 > normals(P.get_data().size_of_vertices());
    typedef Polyhedron_3_SWIG_wrapper::cpp_base::Facet_handle Facet_handle;
    X_from_id_pmap<Facet_handle, EPIC_Kernel::Vector_3> ppmap(normals);
    PMP::compute_face_normals(P.get_data(), ppmap);
    BOOST_FOREACH(const EPIC_Kernel::Vector_3& v, normals)
      *out++=v;
  }
//   CGAL::Polygon_mesh_processing::compute_vertex_normal()
  Vector_3 compute_vertex_normal(Polyhedron_3_Vertex_handle_SWIG_wrapper& vertex,
                                 Polyhedron_3_SWIG_wrapper& P)
  {
    return PMP::compute_vertex_normal(vertex.get_data(), P.get_data());
  }
  void compute_vertex_normal(Polyhedron_3_Vertex_handle_SWIG_wrapper& vertex,
                             Polyhedron_3_SWIG_wrapper& P,
                             Vector_3& output_normal)
  {
    output_normal=Vector_3(
        PMP::compute_vertex_normal(vertex.get_data(), P.get_data()) );
  }
//   CGAL::Polygon_mesh_processing::compute_vertex_normals()
  void compute_vertex_normals(Polyhedron_3_SWIG_wrapper& P,
                              Vector_3_output_iterator out)
  {
    CGAL::set_halfedgeds_items_id(P.get_data());
    std::vector< EPIC_Kernel::Vector_3 > normals(P.get_data().size_of_vertices());
    typedef Polyhedron_3_SWIG_wrapper::cpp_base::Vertex_handle Vertex_handle;
    X_from_id_pmap<Vertex_handle, EPIC_Kernel::Vector_3> ppmap(normals);
    PMP::compute_vertex_normals(P.get_data(), ppmap);
    BOOST_FOREACH(const EPIC_Kernel::Vector_3& v, normals)
      *out++=v;
  }
//   CGAL::Polygon_mesh_processing::compute_normals()
//
// Connected Components
//   CGAL::Polygon_mesh_processing::connected_component()
  void connected_component(Polyhedron_3_Facet_handle_SWIG_wrapper& seed_face,
                           Polyhedron_3_SWIG_wrapper& P,
                           Facet_output_iterator out)
  {
    PMP::connected_component(seed_face.get_data(), P.get_data(), out);
  }
//   CGAL::Polygon_mesh_processing::connected_components()
  boost::shared_ptr<std::vector<int> >
  connected_components(Polyhedron_3_SWIG_wrapper& P)
  {
    CGAL::set_halfedgeds_items_id(P.get_data());
    boost::shared_ptr<std::vector<int> > cc_ids( new std::vector<int>(P.size_of_facets()) );
    typedef Polyhedron_3_SWIG_wrapper::cpp_base::Facet_handle Facet_handle;
    Int_from_id_pmap<Facet_handle> pmap(*cc_ids);
    PMP::connected_components(P.get_data(), pmap);
    return cc_ids;
  }
#if CGAL_VERSION_NR >= 1040800000
  //   CGAL::Polygon_mesh_processing::keep_large_connected_components() (4.8)
  int keep_large_connected_components(Polyhedron_3_SWIG_wrapper& P,
                                      int threshold_components_to_keep)
  {
    return PMP::keep_large_connected_components(P.get_data(),
                                                threshold_components_to_keep);
  }
#endif // CGAL 4.8 or later
//   CGAL::Polygon_mesh_processing::keep_largest_connected_components()
  int keep_largest_connected_components(Polyhedron_3_SWIG_wrapper& P,
                                        int nb_components_to_keep)
  {
    return PMP::keep_largest_connected_components(P.get_data(),
                                                  nb_components_to_keep);
  }
//   CGAL::Polygon_mesh_processing::keep_connected_components()
  void keep_connected_components(Polyhedron_3_SWIG_wrapper& P,
                                 Facet_range components_to_keep)
  {
    PMP::keep_connected_components(P.get_data(),
                                   CGAL::make_range(components_to_keep));
  }
  void keep_connected_components(Polyhedron_3_SWIG_wrapper& P,
                                 boost::shared_ptr<std::vector<int> > components_to_keep,
                                 boost::shared_ptr<std::vector<int> > fcm)
  {
    CGAL::set_halfedgeds_items_id(P.get_data());
    typedef Polyhedron_3_SWIG_wrapper::cpp_base::Facet_handle Facet_handle;
    Int_from_id_pmap<Facet_handle> pmap(*fcm);
    PMP::keep_connected_components(P.get_data(),
                                   *components_to_keep,
                                   pmap);
  }

//   CGAL::Polygon_mesh_processing::remove_connected_components()
  #if CGAL_VERSION_NR >= 1040800000
  // desactivated in 4.7 due to a bug in CGAL
  void remove_connected_components( Polyhedron_3_SWIG_wrapper& P,
                                    Facet_range components_to_remove)
  {
    PMP::remove_connected_components(P.get_data(),
                                     CGAL::make_range(components_to_remove));
  }
  #endif // CGAL 4.8 or later
  void remove_connected_components(Polyhedron_3_SWIG_wrapper& P,
                                 boost::shared_ptr<std::vector<int> > components_to_remove,
                                 boost::shared_ptr<std::vector<int> > fcm)
  {
    CGAL::set_halfedgeds_items_id(P.get_data());
    typedef Polyhedron_3_SWIG_wrapper::cpp_base::Facet_handle Facet_handle;
    Int_from_id_pmap<Facet_handle> pmap(*fcm);
    PMP::remove_connected_components(P.get_data(),
                                     *components_to_remove,
                                     pmap);
  }
//
#if CGAL_VERSION_NR >= 1040800000
// Geometric Measure functions
//   CGAL::Polygon_mesh_processing::face_area()
  double face_area(Polyhedron_3_Facet_handle_SWIG_wrapper& face,
                   Polyhedron_3_SWIG_wrapper& P)
  {
    return PMP::face_area(face.get_data(), P.get_data());
  }
//   CGAL::Polygon_mesh_processing::area() (4.8)
  double area(Facet_range facet_range,
              Polyhedron_3_SWIG_wrapper& P)
  {
    return PMP::area(facet_range, P.get_data());
  }
  double area(Polyhedron_3_SWIG_wrapper& P)
  {
    return PMP::area(P.get_data());
  }
//   CGAL::Polygon_mesh_processing::volume() (4.8)
  double volume(Polyhedron_3_SWIG_wrapper& P)
  {
    return PMP::volume(P.get_data());
  }
//   CGAL::Polygon_mesh_processing::edge_length() (4.8)
  double edge_length(Polyhedron_3_Halfedge_handle_SWIG_wrapper& hedge,
                     Polyhedron_3_SWIG_wrapper& P)
  {
    return PMP::edge_length(hedge.get_data(), P.get_data());
  }
//   CGAL::Polygon_mesh_processing::face_border_length() (4.8)
  double face_border_length(Polyhedron_3_Halfedge_handle_SWIG_wrapper& hedge,
                            Polyhedron_3_SWIG_wrapper& P)
  {
    return PMP::face_border_length(hedge.get_data(), P.get_data());
  }
//
// Miscellaneous
#if CGAL_VERSION_NR < 1041001000
//   CGAL::Polygon_mesh_processing::bbox_3() (4.8)
  Bbox_3 bbox_3(Polyhedron_3_SWIG_wrapper& P)
  {
    return Bbox_3( PMP::bbox_3(P.get_data()));
  }
#else
  Bbox_3 bbox(Polyhedron_3_SWIG_wrapper& P)
  {
    return Bbox_3( PMP::bbox(P.get_data()));
  }
#endif
//   CGAL::Polygon_mesh_processing::border_halfedges() (4.8)
  void border_halfedges(Facet_range facet_range,
                        Polyhedron_3_SWIG_wrapper& P,
                        Halfedge_output_iterator out)
  {
    CGAL::set_halfedgeds_items_id(P.get_data());
    PMP::border_halfedges(make_range(facet_range), P.get_data(), out);
  }
#endif // CGAL 4.8 or later



#include <boost/shared_ptr.hpp>
void polygon_soup_to_polygon_mesh(boost::shared_ptr< std::vector<EPIC_Kernel::Point_3> > points,
                                  boost::shared_ptr< std::vector< std::vector<int> > > polygons,
                                  Polyhedron_3_SWIG_wrapper& P)
{
  CGAL::Polygon_mesh_processing::polygon_soup_to_polygon_mesh(*points, *polygons, P.get_data());
}


#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Polygon_1mesh_1slicer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Polyhedron_3_wrapper< Polyhedron_3_,SWIG_Polyhedron_3::CGAL_Vertex_handle< Polyhedron_3_ >,SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ >,SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > > *arg1 = 0 ;
  Polygon_mesh_slicer_wrapper< Polyhedron_3_SWIG_wrapper > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_wrapper< Polyhedron_3_,SWIG_Polyhedron_3::CGAL_Vertex_handle< Polyhedron_3_ >,SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ >,SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_wrapper< Polyhedron_3_,SWIG_Polyhedron_3::CGAL_Vertex_handle< Polyhedron_3_ >,SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ >,SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > > & reference is null");
    return 0;
  } 
  {
    try{
      result = (Polygon_mesh_slicer_wrapper< Polyhedron_3_SWIG_wrapper > *)new Polygon_mesh_slicer_wrapper< Polyhedron_3_SWIG_wrapper >(*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Polygon_mesh_slicer_wrapper< Polyhedron_3_SWIG_wrapper > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polygon_1mesh_1slicer_1slice(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  Polygon_mesh_slicer_wrapper< Polyhedron_3_SWIG_wrapper > *arg1 = (Polygon_mesh_slicer_wrapper< Polyhedron_3_SWIG_wrapper > *) 0 ;
  Plane_3 *arg2 = 0 ;
  std::vector< std::vector< Point_3 > > *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Polygon_mesh_slicer_wrapper< Polyhedron_3_SWIG_wrapper > **)&jarg1; 
  arg2 = *(Plane_3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Plane_3 const & reference is null");
    return ;
  } 
  arg3 = *(std::vector< std::vector< Point_3 > > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< Point_3 > > & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->slice((Plane_3 const &)*arg2,*arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_delete_1Polygon_1mesh_1slicer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Polygon_mesh_slicer_wrapper< Polyhedron_3_SWIG_wrapper > *arg1 = (Polygon_mesh_slicer_wrapper< Polyhedron_3_SWIG_wrapper > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Polygon_mesh_slicer_wrapper< Polyhedron_3_SWIG_wrapper > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Side_1of_1triangle_1mesh(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Polyhedron_3_wrapper< Polyhedron_3_,SWIG_Polyhedron_3::CGAL_Vertex_handle< Polyhedron_3_ >,SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ >,SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > > *arg1 = 0 ;
  Side_of_triangle_mesh_wrapper< Polyhedron_3_SWIG_wrapper > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_wrapper< Polyhedron_3_,SWIG_Polyhedron_3::CGAL_Vertex_handle< Polyhedron_3_ >,SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ >,SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_wrapper< Polyhedron_3_,SWIG_Polyhedron_3::CGAL_Vertex_handle< Polyhedron_3_ >,SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ >,SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > > & reference is null");
    return 0;
  } 
  {
    try{
      result = (Side_of_triangle_mesh_wrapper< Polyhedron_3_SWIG_wrapper > *)new Side_of_triangle_mesh_wrapper< Polyhedron_3_SWIG_wrapper >(*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Side_of_triangle_mesh_wrapper< Polyhedron_3_SWIG_wrapper > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Side_1of_1triangle_1mesh_1bounded_1side(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  Side_of_triangle_mesh_wrapper< Polyhedron_3_SWIG_wrapper > *arg1 = (Side_of_triangle_mesh_wrapper< Polyhedron_3_SWIG_wrapper > *) 0 ;
  Point_3 *arg2 = 0 ;
  Bounded_side result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Side_of_triangle_mesh_wrapper< Polyhedron_3_SWIG_wrapper > **)&jarg1; 
  arg2 = *(Point_3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Point_3 & reference is null");
    return 0;
  } 
  {
    try{
      result = (Bounded_side)(arg1)->bounded_side(*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_delete_1Side_1of_1triangle_1mesh(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Side_of_triangle_mesh_wrapper< Polyhedron_3_SWIG_wrapper > *arg1 = (Side_of_triangle_mesh_wrapper< Polyhedron_3_SWIG_wrapper > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Side_of_triangle_mesh_wrapper< Polyhedron_3_SWIG_wrapper > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Integer_1triple_1first_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SWIG_CGAL::Triple< int,int,int > *arg1 = (SWIG_CGAL::Triple< int,int,int > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL::Triple< int,int,int > **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->first = arg2;
}


SWIGEXPORT jint JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Integer_1triple_1first_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SWIG_CGAL::Triple< int,int,int > *arg1 = (SWIG_CGAL::Triple< int,int,int > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL::Triple< int,int,int > **)&jarg1; 
  result = (int) ((arg1)->first);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Integer_1triple_1second_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SWIG_CGAL::Triple< int,int,int > *arg1 = (SWIG_CGAL::Triple< int,int,int > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL::Triple< int,int,int > **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->second = arg2;
}


SWIGEXPORT jint JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Integer_1triple_1second_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SWIG_CGAL::Triple< int,int,int > *arg1 = (SWIG_CGAL::Triple< int,int,int > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL::Triple< int,int,int > **)&jarg1; 
  result = (int) ((arg1)->second);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Integer_1triple_1third_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  SWIG_CGAL::Triple< int,int,int > *arg1 = (SWIG_CGAL::Triple< int,int,int > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL::Triple< int,int,int > **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->third = arg2;
}


SWIGEXPORT jint JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Integer_1triple_1third_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SWIG_CGAL::Triple< int,int,int > *arg1 = (SWIG_CGAL::Triple< int,int,int > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL::Triple< int,int,int > **)&jarg1; 
  result = (int) ((arg1)->third);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Integer_1triple_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SWIG_CGAL::Triple< int,int,int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (SWIG_CGAL::Triple< int,int,int > *)new SWIG_CGAL::Triple< int,int,int >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_CGAL::Triple< int,int,int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Integer_1triple_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  int *arg1 = 0 ;
  int *arg2 = 0 ;
  int *arg3 = 0 ;
  int temp1 ;
  int temp2 ;
  int temp3 ;
  SWIG_CGAL::Triple< int,int,int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  temp1 = (int)jarg1; 
  arg1 = &temp1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  temp3 = (int)jarg3; 
  arg3 = &temp3; 
  {
    try{
      result = (SWIG_CGAL::Triple< int,int,int > *)new SWIG_CGAL::Triple< int,int,int >((int const &)*arg1,(int const &)*arg2,(int const &)*arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_CGAL::Triple< int,int,int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Integer_1triple_1clone_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SWIG_CGAL::Triple< int,int,int > *arg1 = (SWIG_CGAL::Triple< int,int,int > *) 0 ;
  SWIG_CGAL::Triple< int,int,int >::Self result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL::Triple< int,int,int > **)&jarg1; 
  {
    try{
      result = ((SWIG_CGAL::Triple< int,int,int > const *)arg1)->deepcopy();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_CGAL::Triple< int,int,int >::Self **)&jresult = new SWIG_CGAL::Triple< int,int,int >::Self((const SWIG_CGAL::Triple< int,int,int >::Self &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Integer_1triple_1clone_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SWIG_CGAL::Triple< int,int,int > *arg1 = (SWIG_CGAL::Triple< int,int,int > *) 0 ;
  SWIG_CGAL::Triple< int,int,int >::Self *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL::Triple< int,int,int > **)&jarg1; 
  arg2 = *(SWIG_CGAL::Triple< int,int,int >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL::Triple< int,int,int >::Self const & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->deepcopy((SWIG_CGAL::Triple< int,int,int >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_delete_1Integer_1triple(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SWIG_CGAL::Triple< int,int,int > *arg1 = (SWIG_CGAL::Triple< int,int,int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SWIG_CGAL::Triple< int,int,int > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Facet_1pair_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *)new std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Facet_1pair_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > arg1 ;
  SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > arg2 ;
  SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > *argp1 ;
  SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > *argp2 ;
  std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  argp1 = *(SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ >");
    return 0;
  }
  arg1 = *argp1; 
  argp2 = *(SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ >");
    return 0;
  }
  arg2 = *argp2; 
  {
    try{
      result = (std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *)new std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper >(arg1,arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Facet_1pair_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *arg1 = 0 ;
  std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > const & reference is null");
    return 0;
  } 
  {
    try{
      result = (std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *)new std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper >((std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > const &)*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Facet_1pair_1first_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *arg1 = (std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *) 0 ;
  SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > *arg2 = (SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > **)&jarg1; 
  arg2 = *(SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > **)&jarg2; 
  if (arg1) (arg1)->first = *arg2;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Facet_1pair_1first_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *arg1 = (std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *) 0 ;
  SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > **)&jarg1; 
  result = (SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > *)& ((arg1)->first);
  *(SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Facet_1pair_1second_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *arg1 = (std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *) 0 ;
  SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > *arg2 = (SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > **)&jarg1; 
  arg2 = *(SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > **)&jarg2; 
  if (arg1) (arg1)->second = *arg2;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Facet_1pair_1second_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *arg1 = (std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *) 0 ;
  SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > **)&jarg1; 
  result = (SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > *)& ((arg1)->second);
  *(SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_delete_1Facet_1pair(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *arg1 = (std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::pair< Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Halfedge_1pair_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *)new std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Halfedge_1pair_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > arg1 ;
  SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > arg2 ;
  SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > *argp1 ;
  SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > *argp2 ;
  std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  argp1 = *(SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ >");
    return 0;
  }
  arg1 = *argp1; 
  argp2 = *(SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ >");
    return 0;
  }
  arg2 = *argp2; 
  {
    try{
      result = (std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *)new std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper >(arg1,arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Halfedge_1pair_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *arg1 = 0 ;
  std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > const & reference is null");
    return 0;
  } 
  {
    try{
      result = (std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *)new std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper >((std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > const &)*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Halfedge_1pair_1first_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *arg1 = (std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *) 0 ;
  SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > *arg2 = (SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > **)&jarg1; 
  arg2 = *(SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > **)&jarg2; 
  if (arg1) (arg1)->first = *arg2;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Halfedge_1pair_1first_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *arg1 = (std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *) 0 ;
  SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > **)&jarg1; 
  result = (SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > *)& ((arg1)->first);
  *(SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Halfedge_1pair_1second_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *arg1 = (std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *) 0 ;
  SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > *arg2 = (SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > **)&jarg1; 
  arg2 = *(SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > **)&jarg2; 
  if (arg1) (arg1)->second = *arg2;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Halfedge_1pair_1second_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *arg1 = (std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *) 0 ;
  SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > **)&jarg1; 
  result = (SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > *)& ((arg1)->second);
  *(SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_delete_1Halfedge_1pair(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *arg1 = (std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::pair< Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Point_13_1Vector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< Point_3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (std::vector< Point_3 > *)new std::vector< Point_3 >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< Point_3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Point_13_1Vector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Point_3 > *arg1 = 0 ;
  std::vector< Point_3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Point_3 > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Point_3 > const & reference is null");
    return 0;
  } 
  {
    try{
      result = (std::vector< Point_3 > *)new std::vector< Point_3 >((std::vector< Point_3 > const &)*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< Point_3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Point_13_1Vector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< Point_3 > *arg1 = (std::vector< Point_3 > *) 0 ;
  std::vector< Point_3 >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Point_3 > **)&jarg1; 
  {
    try{
      result = ((std::vector< Point_3 > const *)arg1)->capacity();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Point_13_1Vector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< Point_3 > *arg1 = (std::vector< Point_3 > *) 0 ;
  std::vector< Point_3 >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Point_3 > **)&jarg1; 
  arg2 = (std::vector< Point_3 >::size_type)jarg2; 
  {
    try{
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Point_13_1Vector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< Point_3 > *arg1 = (std::vector< Point_3 > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Point_3 > **)&jarg1; 
  {
    try{
      result = (bool)((std::vector< Point_3 > const *)arg1)->empty();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Point_13_1Vector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< Point_3 > *arg1 = (std::vector< Point_3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Point_3 > **)&jarg1; 
  {
    try{
      (arg1)->clear();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Point_13_1Vector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  Point_3 *arg2 = 0 ;
  std::vector< Point_3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(Point_3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Point_3 const & reference is null");
    return 0;
  } 
  {
    try{
      try {
        result = (std::vector< Point_3 > *)new_std_vector_Sl_Point_3_Sg___SWIG_2(arg1,(Point_3 const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< Point_3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Point_13_1Vector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< Point_3 > *arg1 = (std::vector< Point_3 > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Point_3 > **)&jarg1; 
  {
    try{
      try {
        result = std_vector_Sl_Point_3_Sg__doSize((std::vector< Point_3 > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Point_13_1Vector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< Point_3 > *arg1 = (std::vector< Point_3 > *) 0 ;
  std::vector< Point_3 >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< Point_3 > **)&jarg1; 
  arg2 = *(std::vector< Point_3 >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Point_3 >::value_type const & reference is null");
    return ;
  } 
  {
    try{
      std_vector_Sl_Point_3_Sg__doAdd__SWIG_0(arg1,(Point_3 const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Point_13_1Vector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< Point_3 > *arg1 = (std::vector< Point_3 > *) 0 ;
  jint arg2 ;
  std::vector< Point_3 >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< Point_3 > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< Point_3 >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Point_3 >::value_type const & reference is null");
    return ;
  } 
  {
    try{
      try {
        std_vector_Sl_Point_3_Sg__doAdd__SWIG_1(arg1,arg2,(Point_3 const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Point_13_1Vector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< Point_3 > *arg1 = (std::vector< Point_3 > *) 0 ;
  jint arg2 ;
  std::vector< Point_3 >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Point_3 > **)&jarg1; 
  arg2 = jarg2; 
  {
    try{
      try {
        result = std_vector_Sl_Point_3_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< Point_3 >::value_type **)&jresult = new std::vector< Point_3 >::value_type((const std::vector< Point_3 >::value_type &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Point_13_1Vector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< Point_3 > *arg1 = (std::vector< Point_3 > *) 0 ;
  jint arg2 ;
  std::vector< Point_3 >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Point_3 > **)&jarg1; 
  arg2 = jarg2; 
  {
    try{
      try {
        result = (std::vector< Point_3 >::value_type *) &std_vector_Sl_Point_3_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< Point_3 >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Point_13_1Vector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< Point_3 > *arg1 = (std::vector< Point_3 > *) 0 ;
  jint arg2 ;
  std::vector< Point_3 >::value_type *arg3 = 0 ;
  std::vector< Point_3 >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< Point_3 > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< Point_3 >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Point_3 >::value_type const & reference is null");
    return 0;
  } 
  {
    try{
      try {
        result = std_vector_Sl_Point_3_Sg__doSet(arg1,arg2,(Point_3 const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< Point_3 >::value_type **)&jresult = new std::vector< Point_3 >::value_type((const std::vector< Point_3 >::value_type &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Point_13_1Vector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< Point_3 > *arg1 = (std::vector< Point_3 > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< Point_3 > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try{
      try {
        std_vector_Sl_Point_3_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_delete_1Point_13_1Vector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< Point_3 > *arg1 = (std::vector< Point_3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< Point_3 > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Int_1Vector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (std::vector< int > *)new std::vector< int >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Int_1Vector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< int > *arg1 = 0 ;
  std::vector< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int > const & reference is null");
    return 0;
  } 
  {
    try{
      result = (std::vector< int > *)new std::vector< int >((std::vector< int > const &)*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Int_1Vector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  {
    try{
      result = ((std::vector< int > const *)arg1)->capacity();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Int_1Vector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  arg2 = (std::vector< int >::size_type)jarg2; 
  {
    try{
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Int_1Vector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  {
    try{
      result = (bool)((std::vector< int > const *)arg1)->empty();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Int_1Vector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  {
    try{
      (arg1)->clear();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Int_1Vector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  int *arg2 = 0 ;
  int temp2 ;
  std::vector< int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  {
    try{
      try {
        result = (std::vector< int > *)new_std_vector_Sl_int_Sg___SWIG_2(arg1,(int const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Int_1Vector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  {
    try{
      try {
        result = std_vector_Sl_int_Sg__doSize((std::vector< int > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Int_1Vector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  std::vector< int >::value_type *arg2 = 0 ;
  std::vector< int >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  temp2 = (std::vector< int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try{
      std_vector_Sl_int_Sg__doAdd__SWIG_0(arg1,(int const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Int_1Vector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  jint arg2 ;
  std::vector< int >::value_type *arg3 = 0 ;
  std::vector< int >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try{
      try {
        std_vector_Sl_int_Sg__doAdd__SWIG_1(arg1,arg2,(int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jint JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Int_1Vector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  jint arg2 ;
  std::vector< int >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  arg2 = jarg2; 
  {
    try{
      try {
        result = (std::vector< int >::value_type)std_vector_Sl_int_Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Int_1Vector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  jint arg2 ;
  std::vector< int >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  arg2 = jarg2; 
  {
    try{
      try {
        result = (std::vector< int >::value_type *) &std_vector_Sl_int_Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)*result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Int_1Vector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  jint arg2 ;
  std::vector< int >::value_type *arg3 = 0 ;
  std::vector< int >::value_type temp3 ;
  std::vector< int >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try{
      try {
        result = (std::vector< int >::value_type)std_vector_Sl_int_Sg__doSet(arg1,arg2,(int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Int_1Vector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try{
      try {
        std_vector_Sl_int_Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_delete_1Int_1Vector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< int > *arg1 = (std::vector< int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< int > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Polygon_1Vector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::vector< int > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (std::vector< std::vector< int > > *)new std::vector< std::vector< int > >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< std::vector< int > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Polygon_1Vector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< int > > *arg1 = 0 ;
  std::vector< std::vector< int > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< int > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< int > > const & reference is null");
    return 0;
  } 
  {
    try{
      result = (std::vector< std::vector< int > > *)new std::vector< std::vector< int > >((std::vector< std::vector< int > > const &)*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< std::vector< int > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polygon_1Vector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< int > > *arg1 = (std::vector< std::vector< int > > *) 0 ;
  std::vector< std::vector< int > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< int > > **)&jarg1; 
  {
    try{
      result = ((std::vector< std::vector< int > > const *)arg1)->capacity();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polygon_1Vector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::vector< int > > *arg1 = (std::vector< std::vector< int > > *) 0 ;
  std::vector< std::vector< int > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< int > > **)&jarg1; 
  arg2 = (std::vector< std::vector< int > >::size_type)jarg2; 
  {
    try{
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polygon_1Vector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::vector< int > > *arg1 = (std::vector< std::vector< int > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< int > > **)&jarg1; 
  {
    try{
      result = (bool)((std::vector< std::vector< int > > const *)arg1)->empty();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polygon_1Vector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::vector< int > > *arg1 = (std::vector< std::vector< int > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< int > > **)&jarg1; 
  {
    try{
      (arg1)->clear();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Polygon_1Vector_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::vector< int > *arg2 = 0 ;
  std::vector< std::vector< int > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(std::vector< int > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int > const & reference is null");
    return 0;
  } 
  {
    try{
      try {
        result = (std::vector< std::vector< int > > *)new_std_vector_Sl_std_vector_Sl_int_Sg__Sg___SWIG_2(arg1,(std::vector< int > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< std::vector< int > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polygon_1Vector_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::vector< int > > *arg1 = (std::vector< std::vector< int > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< int > > **)&jarg1; 
  {
    try{
      try {
        result = std_vector_Sl_std_vector_Sl_int_Sg__Sg__doSize((std::vector< std::vector< int > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polygon_1Vector_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::vector< int > > *arg1 = (std::vector< std::vector< int > > *) 0 ;
  std::vector< std::vector< int > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::vector< int > > **)&jarg1; 
  arg2 = *(std::vector< std::vector< int > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< int > >::value_type const & reference is null");
    return ;
  } 
  {
    try{
      std_vector_Sl_std_vector_Sl_int_Sg__Sg__doAdd__SWIG_0(arg1,(std::vector< int > const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polygon_1Vector_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::vector< int > > *arg1 = (std::vector< std::vector< int > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< int > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::vector< int > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::vector< int > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< int > >::value_type const & reference is null");
    return ;
  } 
  {
    try{
      try {
        std_vector_Sl_std_vector_Sl_int_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::vector< int > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polygon_1Vector_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::vector< int > > *arg1 = (std::vector< std::vector< int > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< int > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< int > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try{
      try {
        result = std_vector_Sl_std_vector_Sl_int_Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< std::vector< int > >::value_type **)&jresult = new std::vector< std::vector< int > >::value_type((const std::vector< std::vector< int > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polygon_1Vector_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::vector< int > > *arg1 = (std::vector< std::vector< int > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< int > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< int > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try{
      try {
        result = (std::vector< std::vector< int > >::value_type *) &std_vector_Sl_std_vector_Sl_int_Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< std::vector< int > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polygon_1Vector_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::vector< int > > *arg1 = (std::vector< std::vector< int > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< int > >::value_type *arg3 = 0 ;
  std::vector< std::vector< int > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::vector< int > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::vector< int > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< int > >::value_type const & reference is null");
    return 0;
  } 
  {
    try{
      try {
        result = std_vector_Sl_std_vector_Sl_int_Sg__Sg__doSet(arg1,arg2,(std::vector< int > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< std::vector< int > >::value_type **)&jresult = new std::vector< std::vector< int > >::value_type((const std::vector< std::vector< int > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polygon_1Vector_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::vector< int > > *arg1 = (std::vector< std::vector< int > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< int > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try{
      try {
        std_vector_Sl_std_vector_Sl_int_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_delete_1Polygon_1Vector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::vector< int > > *arg1 = (std::vector< std::vector< int > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::vector< int > > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Polylines_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::vector< Point_3 > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (std::vector< std::vector< Point_3 > > *)new std::vector< std::vector< Point_3 > >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< std::vector< Point_3 > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Polylines_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< Point_3 > > *arg1 = 0 ;
  std::vector< std::vector< Point_3 > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Point_3 > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< Point_3 > > const & reference is null");
    return 0;
  } 
  {
    try{
      result = (std::vector< std::vector< Point_3 > > *)new std::vector< std::vector< Point_3 > >((std::vector< std::vector< Point_3 > > const &)*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< std::vector< Point_3 > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polylines_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< Point_3 > > *arg1 = (std::vector< std::vector< Point_3 > > *) 0 ;
  std::vector< std::vector< Point_3 > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Point_3 > > **)&jarg1; 
  {
    try{
      result = ((std::vector< std::vector< Point_3 > > const *)arg1)->capacity();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polylines_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::vector< Point_3 > > *arg1 = (std::vector< std::vector< Point_3 > > *) 0 ;
  std::vector< std::vector< Point_3 > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Point_3 > > **)&jarg1; 
  arg2 = (std::vector< std::vector< Point_3 > >::size_type)jarg2; 
  {
    try{
      try {
        (arg1)->reserve(arg2);
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polylines_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::vector< Point_3 > > *arg1 = (std::vector< std::vector< Point_3 > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Point_3 > > **)&jarg1; 
  {
    try{
      result = (bool)((std::vector< std::vector< Point_3 > > const *)arg1)->empty();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polylines_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::vector< Point_3 > > *arg1 = (std::vector< std::vector< Point_3 > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Point_3 > > **)&jarg1; 
  {
    try{
      (arg1)->clear();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_new_1Polylines_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::vector< Point_3 > *arg2 = 0 ;
  std::vector< std::vector< Point_3 > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(std::vector< Point_3 > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Point_3 > const & reference is null");
    return 0;
  } 
  {
    try{
      try {
        result = (std::vector< std::vector< Point_3 > > *)new_std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg___SWIG_2(arg1,(std::vector< Point_3 > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< std::vector< Point_3 > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polylines_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::vector< Point_3 > > *arg1 = (std::vector< std::vector< Point_3 > > *) 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Point_3 > > **)&jarg1; 
  {
    try{
      try {
        result = std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg__doSize((std::vector< std::vector< Point_3 > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polylines_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::vector< Point_3 > > *arg1 = (std::vector< std::vector< Point_3 > > *) 0 ;
  std::vector< std::vector< Point_3 > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::vector< Point_3 > > **)&jarg1; 
  arg2 = *(std::vector< std::vector< Point_3 > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< Point_3 > >::value_type const & reference is null");
    return ;
  } 
  {
    try{
      std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg__doAdd__SWIG_0(arg1,(std::vector< Point_3 > const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polylines_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::vector< Point_3 > > *arg1 = (std::vector< std::vector< Point_3 > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< Point_3 > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::vector< Point_3 > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::vector< Point_3 > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< Point_3 > >::value_type const & reference is null");
    return ;
  } 
  {
    try{
      try {
        std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg__doAdd__SWIG_1(arg1,arg2,(std::vector< Point_3 > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polylines_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::vector< Point_3 > > *arg1 = (std::vector< std::vector< Point_3 > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< Point_3 > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Point_3 > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try{
      try {
        result = std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg__doRemove(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< std::vector< Point_3 > >::value_type **)&jresult = new std::vector< std::vector< Point_3 > >::value_type((const std::vector< std::vector< Point_3 > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polylines_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::vector< Point_3 > > *arg1 = (std::vector< std::vector< Point_3 > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< Point_3 > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Point_3 > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try{
      try {
        result = (std::vector< std::vector< Point_3 > >::value_type *) &std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg__doGet(arg1,arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< std::vector< Point_3 > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polylines_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::vector< Point_3 > > *arg1 = (std::vector< std::vector< Point_3 > > *) 0 ;
  jint arg2 ;
  std::vector< std::vector< Point_3 > >::value_type *arg3 = 0 ;
  std::vector< std::vector< Point_3 > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::vector< Point_3 > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::vector< Point_3 > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< Point_3 > >::value_type const & reference is null");
    return 0;
  } 
  {
    try{
      try {
        result = std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg__doSet(arg1,arg2,(std::vector< Point_3 > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(std::vector< std::vector< Point_3 > >::value_type **)&jresult = new std::vector< std::vector< Point_3 > >::value_type((const std::vector< std::vector< Point_3 > >::value_type &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_Polylines_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::vector< Point_3 > > *arg1 = (std::vector< std::vector< Point_3 > > *) 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< Point_3 > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try{
      try {
        std_vector_Sl_std_vector_Sl_Point_3_Sg__Sg__doRemoveRange(arg1,arg2,arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_delete_1Polylines(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::vector< Point_3 > > *arg1 = (std::vector< std::vector< Point_3 > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::vector< Point_3 > > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_fair_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Vertex_handle< Polyhedron_3_ > >::input > arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    Input_iterator_wrapper<Polyhedron_3_Vertex_handle_SWIG_wrapper,Polyhedron_3_Vertex_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Vertex_handle_SWIG_wrapper,Polyhedron_3_Vertex_handle_SWIG_wrapper::cpp_base> it_begin(jarg2,"(LCGAL/Polyhedron_3/Polyhedron_3_Vertex_handle;)J");
    arg2=std::make_pair(it_begin,it_end);
  }
  {
    try{
      fair(*arg1,arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_fair_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Vertex_handle< Polyhedron_3_ > >::input > arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    Input_iterator_wrapper<Polyhedron_3_Vertex_handle_SWIG_wrapper,Polyhedron_3_Vertex_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Vertex_handle_SWIG_wrapper,Polyhedron_3_Vertex_handle_SWIG_wrapper::cpp_base> it_begin(jarg2,"(LCGAL/Polyhedron_3/Polyhedron_3_Vertex_handle;)J");
    arg2=std::make_pair(it_begin,it_end);
  }
  arg3 = (int)jarg3; 
  {
    try{
      fair(*arg1,arg2,arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_refine_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::input > arg2 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::output > arg3 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Vertex_handle< Polyhedron_3_ > >::output > arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_begin(jarg2,"(LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;)J");
    arg2=std::make_pair(it_begin,it_end);
  }
  {
    arg3=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base>(jarg3,"LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;") );
  }
  {
    arg4=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Vertex_handle_SWIG_wrapper,Polyhedron_3_Vertex_handle_SWIG_wrapper::cpp_base>(jarg4,"LCGAL/Polyhedron_3/Polyhedron_3_Vertex_handle;") );
  }
  {
    try{
      refine(*arg1,arg2,arg3,arg4);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_refine_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jdouble jarg5) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::input > arg2 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::output > arg3 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Vertex_handle< Polyhedron_3_ > >::output > arg4 ;
  double arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_begin(jarg2,"(LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;)J");
    arg2=std::make_pair(it_begin,it_end);
  }
  {
    arg3=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base>(jarg3,"LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;") );
  }
  {
    arg4=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Vertex_handle_SWIG_wrapper,Polyhedron_3_Vertex_handle_SWIG_wrapper::cpp_base>(jarg4,"LCGAL/Polyhedron_3/Polyhedron_3_Vertex_handle;") );
  }
  arg5 = (double)jarg5; 
  {
    try{
      refine(*arg1,arg2,arg3,arg4,arg5);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_triangulate_1face(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Polyhedron_3_Facet_handle_SWIG_wrapper *arg1 = 0 ;
  Polyhedron_3_SWIG_wrapper *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Polyhedron_3_Facet_handle_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_Facet_handle_SWIG_wrapper & reference is null");
    return ;
  } 
  arg2 = *(Polyhedron_3_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    try{
      triangulate_face(*arg1,*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_triangulate_1faces_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    try{
      triangulate_faces(*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_triangulate_1faces_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jlong jarg2, jobject jarg2_) {
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::input > arg1 ;
  Polyhedron_3_SWIG_wrapper *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  {
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_begin(jarg1,"(LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;)J");
    arg1=std::make_pair(it_begin,it_end);
  }
  arg2 = *(Polyhedron_3_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    try{
      triangulate_faces(arg1,*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_isotropic_1remeshing_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jdouble jarg2, jlong jarg3, jobject jarg3_, jint jarg4, jobject jarg5, jboolean jarg6) {
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::input > arg1 ;
  double arg2 ;
  Polyhedron_3_SWIG_wrapper *arg3 = 0 ;
  int arg4 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > >::input > arg5 ;
  bool arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  {
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_begin(jarg1,"(LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;)J");
    arg1=std::make_pair(it_begin,it_end);
  }
  arg2 = (double)jarg2; 
  arg3 = *(Polyhedron_3_SWIG_wrapper **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  arg4 = (int)jarg4; 
  {
    Input_iterator_wrapper<Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper::cpp_base> it_begin(jarg5,"(LCGAL/Polyhedron_3/Polyhedron_3_Halfedge_handle;)J");
    arg5=std::make_pair(it_begin,it_end);
  }
  arg6 = jarg6 ? true : false; 
  {
    try{
      isotropic_remeshing(arg1,arg2,*arg3,arg4,arg5,arg6);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_isotropic_1remeshing_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jdouble jarg2, jlong jarg3, jobject jarg3_, jint jarg4, jobject jarg5) {
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::input > arg1 ;
  double arg2 ;
  Polyhedron_3_SWIG_wrapper *arg3 = 0 ;
  int arg4 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > >::input > arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  {
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_begin(jarg1,"(LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;)J");
    arg1=std::make_pair(it_begin,it_end);
  }
  arg2 = (double)jarg2; 
  arg3 = *(Polyhedron_3_SWIG_wrapper **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  arg4 = (int)jarg4; 
  {
    Input_iterator_wrapper<Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper::cpp_base> it_begin(jarg5,"(LCGAL/Polyhedron_3/Polyhedron_3_Halfedge_handle;)J");
    arg5=std::make_pair(it_begin,it_end);
  }
  {
    try{
      isotropic_remeshing(arg1,arg2,*arg3,arg4,arg5);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_isotropic_1remeshing_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jobject jarg1, jdouble jarg2, jlong jarg3, jobject jarg3_, jint jarg4) {
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::input > arg1 ;
  double arg2 ;
  Polyhedron_3_SWIG_wrapper *arg3 = 0 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  {
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_begin(jarg1,"(LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;)J");
    arg1=std::make_pair(it_begin,it_end);
  }
  arg2 = (double)jarg2; 
  arg3 = *(Polyhedron_3_SWIG_wrapper **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  arg4 = (int)jarg4; 
  {
    try{
      isotropic_remeshing(arg1,arg2,*arg3,arg4);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_isotropic_1remeshing_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jobject jarg1, jdouble jarg2, jlong jarg3, jobject jarg3_) {
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::input > arg1 ;
  double arg2 ;
  Polyhedron_3_SWIG_wrapper *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  {
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_begin(jarg1,"(LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;)J");
    arg1=std::make_pair(it_begin,it_end);
  }
  arg2 = (double)jarg2; 
  arg3 = *(Polyhedron_3_SWIG_wrapper **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    try{
      isotropic_remeshing(arg1,arg2,*arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_split_1long_1edges(JNIEnv *jenv, jclass jcls, jobject jarg1, jdouble jarg2, jlong jarg3, jobject jarg3_) {
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > >::input > arg1 ;
  double *arg2 = 0 ;
  Polyhedron_3_SWIG_wrapper *arg3 = 0 ;
  double temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  {
    Input_iterator_wrapper<Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper::cpp_base> it_begin(jarg1,"(LCGAL/Polyhedron_3/Polyhedron_3_Halfedge_handle;)J");
    arg1=std::make_pair(it_begin,it_end);
  }
  temp2 = (double)jarg2; 
  arg2 = &temp2; 
  arg3 = *(Polyhedron_3_SWIG_wrapper **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    try{
      split_long_edges(arg1,(double const &)*arg2,*arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_triangulate_1hole(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  Polyhedron_3_Halfedge_handle_SWIG_wrapper *arg2 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::output > arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  arg2 = *(Polyhedron_3_Halfedge_handle_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_Halfedge_handle_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    arg3=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base>(jarg3,"LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;") );
  }
  {
    try{
      triangulate_hole(*arg1,*arg2,arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_triangulate_1and_1refine_1hole_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  Polyhedron_3_Halfedge_handle_SWIG_wrapper *arg2 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::output > arg3 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Vertex_handle< Polyhedron_3_ > >::output > arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  arg2 = *(Polyhedron_3_Halfedge_handle_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_Halfedge_handle_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    arg3=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base>(jarg3,"LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;") );
  }
  {
    arg4=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Vertex_handle_SWIG_wrapper,Polyhedron_3_Vertex_handle_SWIG_wrapper::cpp_base>(jarg4,"LCGAL/Polyhedron_3/Polyhedron_3_Vertex_handle;") );
  }
  {
    try{
      triangulate_and_refine_hole(*arg1,*arg2,arg3,arg4);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_triangulate_1and_1refine_1hole_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jdouble jarg5) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  Polyhedron_3_Halfedge_handle_SWIG_wrapper *arg2 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::output > arg3 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Vertex_handle< Polyhedron_3_ > >::output > arg4 ;
  double arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  arg2 = *(Polyhedron_3_Halfedge_handle_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_Halfedge_handle_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    arg3=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base>(jarg3,"LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;") );
  }
  {
    arg4=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Vertex_handle_SWIG_wrapper,Polyhedron_3_Vertex_handle_SWIG_wrapper::cpp_base>(jarg4,"LCGAL/Polyhedron_3/Polyhedron_3_Vertex_handle;") );
  }
  arg5 = (double)jarg5; 
  {
    try{
      triangulate_and_refine_hole(*arg1,*arg2,arg3,arg4,arg5);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_triangulate_1refine_1and_1fair_1hole_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  Polyhedron_3_Halfedge_handle_SWIG_wrapper *arg2 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::output > arg3 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Vertex_handle< Polyhedron_3_ > >::output > arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  arg2 = *(Polyhedron_3_Halfedge_handle_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_Halfedge_handle_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    arg3=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base>(jarg3,"LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;") );
  }
  {
    arg4=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Vertex_handle_SWIG_wrapper,Polyhedron_3_Vertex_handle_SWIG_wrapper::cpp_base>(jarg4,"LCGAL/Polyhedron_3/Polyhedron_3_Vertex_handle;") );
  }
  {
    try{
      triangulate_refine_and_fair_hole(*arg1,*arg2,arg3,arg4);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_triangulate_1refine_1and_1fair_1hole_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jdouble jarg5) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  Polyhedron_3_Halfedge_handle_SWIG_wrapper *arg2 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::output > arg3 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Vertex_handle< Polyhedron_3_ > >::output > arg4 ;
  double arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  arg2 = *(Polyhedron_3_Halfedge_handle_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_Halfedge_handle_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    arg3=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base>(jarg3,"LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;") );
  }
  {
    arg4=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Vertex_handle_SWIG_wrapper,Polyhedron_3_Vertex_handle_SWIG_wrapper::cpp_base>(jarg4,"LCGAL/Polyhedron_3/Polyhedron_3_Vertex_handle;") );
  }
  arg5 = (double)jarg5; 
  {
    try{
      triangulate_refine_and_fair_hole(*arg1,*arg2,arg3,arg4,arg5);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_triangulate_1refine_1and_1fair_1hole_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jdouble jarg5, jint jarg6) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  Polyhedron_3_Halfedge_handle_SWIG_wrapper *arg2 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::output > arg3 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Vertex_handle< Polyhedron_3_ > >::output > arg4 ;
  double arg5 ;
  int arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  arg2 = *(Polyhedron_3_Halfedge_handle_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_Halfedge_handle_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    arg3=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base>(jarg3,"LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;") );
  }
  {
    arg4=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Vertex_handle_SWIG_wrapper,Polyhedron_3_Vertex_handle_SWIG_wrapper::cpp_base>(jarg4,"LCGAL/Polyhedron_3/Polyhedron_3_Vertex_handle;") );
  }
  arg5 = (double)jarg5; 
  arg6 = (int)jarg6; 
  {
    try{
      triangulate_refine_and_fair_hole(*arg1,*arg2,arg3,arg4,arg5,arg6);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_triangulate_1hole_1polyline_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2, jobject jarg3) {
  SwigValueWrapper< Wrapper_iterator_helper< Point_3 >::input > arg1 ;
  SwigValueWrapper< Wrapper_iterator_helper< Point_3 >::input > arg2 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_CGAL::Triple< int,int,int > >::output > arg3 ;
  
  (void)jenv;
  (void)jcls;
  {
    Input_iterator_wrapper<Point_3,internal::Converter<Point_3>::result_type> it_end;
    Input_iterator_wrapper<Point_3,internal::Converter<Point_3>::result_type> it_begin(jarg1,"(LCGAL/Kernel/""Point_3"";)J");
    arg1=std::make_pair(it_begin,it_end);
  }
  {
    Input_iterator_wrapper<Point_3,internal::Converter<Point_3>::result_type> it_end;
    Input_iterator_wrapper<Point_3,internal::Converter<Point_3>::result_type> it_begin(jarg2,"(LCGAL/Kernel/""Point_3"";)J");
    arg2=std::make_pair(it_begin,it_end);
  }
  {
    arg3=boost::make_function_output_iterator( Container_writer<Integer_triple_SWIG_wrapper,internal::Converter<Integer_triple_SWIG_wrapper>::result_type>(jarg3,"LCGAL/Polygon_mesh_processing/Integer_triple;") );
  }
  {
    try{
      triangulate_hole_polyline(arg1,arg2,arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_triangulate_1hole_1polyline_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  SwigValueWrapper< Wrapper_iterator_helper< Point_3 >::input > arg1 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_CGAL::Triple< int,int,int > >::output > arg2 ;
  
  (void)jenv;
  (void)jcls;
  {
    Input_iterator_wrapper<Point_3,internal::Converter<Point_3>::result_type> it_end;
    Input_iterator_wrapper<Point_3,internal::Converter<Point_3>::result_type> it_begin(jarg1,"(LCGAL/Kernel/""Point_3"";)J");
    arg1=std::make_pair(it_begin,it_end);
  }
  {
    arg2=boost::make_function_output_iterator( Container_writer<Integer_triple_SWIG_wrapper,internal::Converter<Integer_triple_SWIG_wrapper>::result_type>(jarg2,"LCGAL/Polygon_mesh_processing/Integer_triple;") );
  }
  {
    try{
      triangulate_hole_polyline(arg1,arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_does_1self_1intersect(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return 0;
  } 
  {
    try{
      result = (bool)does_self_intersect(*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_self_1intersections(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< std::pair< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ >,SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > > >::output > arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    arg2=boost::make_function_output_iterator( Container_writer<Facet_pair_SWIG_wrapper,internal::Converter<Facet_pair_SWIG_wrapper>::result_type>(jarg2,"LCGAL/Polygon_mesh_processing/Facet_pair;") );
  }
  {
    try{
      self_intersections(*arg1,arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_is_1outward_1oriented(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return 0;
  } 
  {
    try{
      result = (bool)is_outward_oriented(*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_reverse_1face_1orientations_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    try{
      reverse_face_orientations(*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_reverse_1face_1orientations_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jlong jarg2, jobject jarg2_) {
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::input > arg1 ;
  Polyhedron_3_SWIG_wrapper *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  {
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_begin(jarg1,"(LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;)J");
    arg1=std::make_pair(it_begin,it_end);
  }
  arg2 = *(Polyhedron_3_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    try{
      reverse_face_orientations(arg1,*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_orient_1polygon_1soup(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  std::vector< Point_3 > *arg1 = 0 ;
  std::vector< std::vector< int > > *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< Point_3 > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Point_3 > & reference is null");
    return 0;
  } 
  arg2 = *(std::vector< std::vector< int > > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< int > > & reference is null");
    return 0;
  } 
  {
    try{
      result = (bool)orient_polygon_soup(*arg1,*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_stitch_1borders_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    try{
      stitch_borders(*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_stitch_1borders_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< std::pair< SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ >,SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > > >::input > arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    Input_iterator_wrapper<Halfedge_pair_SWIG_wrapper,internal::Converter<Halfedge_pair_SWIG_wrapper>::result_type> it_end;
    Input_iterator_wrapper<Halfedge_pair_SWIG_wrapper,internal::Converter<Halfedge_pair_SWIG_wrapper>::result_type> it_begin(jarg2,"(LCGAL/Polygon_mesh_processing/Halfedge_pair;)J");
    arg2=std::make_pair(it_begin,it_end);
  }
  {
    try{
      stitch_borders(*arg1,arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_polygon_1soup_1to_1polygon_1mesh_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  std::vector< Point_3 > *arg1 = 0 ;
  std::vector< std::vector< int > > *arg2 = 0 ;
  Polyhedron_3_SWIG_wrapper *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(std::vector< Point_3 > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< Point_3 > const & reference is null");
    return ;
  } 
  arg2 = *(std::vector< std::vector< int > > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< int > > const & reference is null");
    return ;
  } 
  arg3 = *(Polyhedron_3_SWIG_wrapper **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    try{
      polygon_soup_to_polygon_mesh((std::vector< Point_3 > const &)*arg1,(std::vector< std::vector< int > > const &)*arg2,*arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_remove_1isolated_1vertices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    try{
      remove_isolated_vertices(*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_compute_1face_1normal_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Polyhedron_3_Facet_handle_SWIG_wrapper *arg1 = 0 ;
  Polyhedron_3_SWIG_wrapper *arg2 = 0 ;
  Vector_3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Polyhedron_3_Facet_handle_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_Facet_handle_SWIG_wrapper & reference is null");
    return 0;
  } 
  arg2 = *(Polyhedron_3_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return 0;
  } 
  {
    try{
      result = compute_face_normal(*arg1,*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Vector_3 **)&jresult = new Vector_3((const Vector_3 &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_compute_1face_1normal_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  Polyhedron_3_Facet_handle_SWIG_wrapper *arg1 = 0 ;
  Polyhedron_3_SWIG_wrapper *arg2 = 0 ;
  Vector_3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Polyhedron_3_Facet_handle_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_Facet_handle_SWIG_wrapper & reference is null");
    return ;
  } 
  arg2 = *(Polyhedron_3_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  arg3 = *(Vector_3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Vector_3 & reference is null");
    return ;
  } 
  {
    try{
      compute_face_normal(*arg1,*arg2,*arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_compute_1face_1normals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< Vector_3 >::output > arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    arg2=boost::make_function_output_iterator( Container_writer<Vector_3,internal::Converter<Vector_3>::result_type>(jarg2,"LCGAL/Kernel/""Vector_3"";") );
  }
  {
    try{
      compute_face_normals(*arg1,arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_compute_1vertex_1normal_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Polyhedron_3_Vertex_handle_SWIG_wrapper *arg1 = 0 ;
  Polyhedron_3_SWIG_wrapper *arg2 = 0 ;
  Vector_3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Polyhedron_3_Vertex_handle_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_Vertex_handle_SWIG_wrapper & reference is null");
    return 0;
  } 
  arg2 = *(Polyhedron_3_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return 0;
  } 
  {
    try{
      result = compute_vertex_normal(*arg1,*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Vector_3 **)&jresult = new Vector_3((const Vector_3 &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_compute_1vertex_1normal_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  Polyhedron_3_Vertex_handle_SWIG_wrapper *arg1 = 0 ;
  Polyhedron_3_SWIG_wrapper *arg2 = 0 ;
  Vector_3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Polyhedron_3_Vertex_handle_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_Vertex_handle_SWIG_wrapper & reference is null");
    return ;
  } 
  arg2 = *(Polyhedron_3_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  arg3 = *(Vector_3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Vector_3 & reference is null");
    return ;
  } 
  {
    try{
      compute_vertex_normal(*arg1,*arg2,*arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_compute_1vertex_1normals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< Vector_3 >::output > arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    arg2=boost::make_function_output_iterator( Container_writer<Vector_3,internal::Converter<Vector_3>::result_type>(jarg2,"LCGAL/Kernel/""Vector_3"";") );
  }
  {
    try{
      compute_vertex_normals(*arg1,arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_connected_1component(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  Polyhedron_3_Facet_handle_SWIG_wrapper *arg1 = 0 ;
  Polyhedron_3_SWIG_wrapper *arg2 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::output > arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Polyhedron_3_Facet_handle_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_Facet_handle_SWIG_wrapper & reference is null");
    return ;
  } 
  arg2 = *(Polyhedron_3_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    arg3=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base>(jarg3,"LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;") );
  }
  {
    try{
      connected_component(*arg1,*arg2,arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jintArray JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_connected_1components(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  boost::shared_ptr< std::vector< int > > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return 0;
  } 
  {
    try{
      result = connected_components(*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  {
    const jsize size = result->size();
    jintArray jInts = jenv->NewIntArray(size);
    jenv->SetIntArrayRegion(jInts, 0, size, ((const jint*)&((*result)[0])));
    jresult=jInts;
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_keep_1large_1connected_1components(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try{
      result = (int)keep_large_connected_components(*arg1,arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_keep_1largest_1connected_1components(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try{
      result = (int)keep_largest_connected_components(*arg1,arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_keep_1connected_1components_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::input > arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_begin(jarg2,"(LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;)J");
    arg2=std::make_pair(it_begin,it_end);
  }
  {
    try{
      keep_connected_components(*arg1,arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_keep_1connected_1components_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2, jintArray jarg3) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  boost::shared_ptr< std::vector< int > > arg2 ;
  boost::shared_ptr< std::vector< int > > arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    boost::shared_ptr<std::vector<int> > res(new std::vector<int>());
    const jsize size = jenv->GetArrayLength(jarg2);
    res->reserve((const std::size_t) size);
    jboolean is_copy;
    jint* indices = jenv->GetIntArrayElements(jarg2, &is_copy);
    for (int i = 0 ; i < size ; i++){
      res->push_back(indices[i]);
    }
    jenv->ReleaseIntArrayElements(jarg2, indices, JNI_ABORT);
    arg2=res;
  }
  {
    boost::shared_ptr<std::vector<int> > res(new std::vector<int>());
    const jsize size = jenv->GetArrayLength(jarg3);
    res->reserve((const std::size_t) size);
    jboolean is_copy;
    jint* indices = jenv->GetIntArrayElements(jarg3, &is_copy);
    for (int i = 0 ; i < size ; i++){
      res->push_back(indices[i]);
    }
    jenv->ReleaseIntArrayElements(jarg3, indices, JNI_ABORT);
    arg3=res;
  }
  {
    try{
      keep_connected_components(*arg1,arg2,arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_remove_1connected_1components_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::input > arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_begin(jarg2,"(LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;)J");
    arg2=std::make_pair(it_begin,it_end);
  }
  {
    try{
      remove_connected_components(*arg1,arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_remove_1connected_1components_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2, jintArray jarg3) {
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  boost::shared_ptr< std::vector< int > > arg2 ;
  boost::shared_ptr< std::vector< int > > arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    boost::shared_ptr<std::vector<int> > res(new std::vector<int>());
    const jsize size = jenv->GetArrayLength(jarg2);
    res->reserve((const std::size_t) size);
    jboolean is_copy;
    jint* indices = jenv->GetIntArrayElements(jarg2, &is_copy);
    for (int i = 0 ; i < size ; i++){
      res->push_back(indices[i]);
    }
    jenv->ReleaseIntArrayElements(jarg2, indices, JNI_ABORT);
    arg2=res;
  }
  {
    boost::shared_ptr<std::vector<int> > res(new std::vector<int>());
    const jsize size = jenv->GetArrayLength(jarg3);
    res->reserve((const std::size_t) size);
    jboolean is_copy;
    jint* indices = jenv->GetIntArrayElements(jarg3, &is_copy);
    for (int i = 0 ; i < size ; i++){
      res->push_back(indices[i]);
    }
    jenv->ReleaseIntArrayElements(jarg3, indices, JNI_ABORT);
    arg3=res;
  }
  {
    try{
      remove_connected_components(*arg1,arg2,arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_face_1area(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jdouble jresult = 0 ;
  Polyhedron_3_Facet_handle_SWIG_wrapper *arg1 = 0 ;
  Polyhedron_3_SWIG_wrapper *arg2 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Polyhedron_3_Facet_handle_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_Facet_handle_SWIG_wrapper & reference is null");
    return 0;
  } 
  arg2 = *(Polyhedron_3_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return 0;
  } 
  {
    try{
      result = (double)face_area(*arg1,*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_area_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1, jlong jarg2, jobject jarg2_) {
  jdouble jresult = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::input > arg1 ;
  Polyhedron_3_SWIG_wrapper *arg2 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  {
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_begin(jarg1,"(LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;)J");
    arg1=std::make_pair(it_begin,it_end);
  }
  arg2 = *(Polyhedron_3_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return 0;
  } 
  {
    try{
      result = (double)area(arg1,*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_area_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return 0;
  } 
  {
    try{
      result = (double)area(*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_volume(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return 0;
  } 
  {
    try{
      result = (double)volume(*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_edge_1length(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jdouble jresult = 0 ;
  Polyhedron_3_Halfedge_handle_SWIG_wrapper *arg1 = 0 ;
  Polyhedron_3_SWIG_wrapper *arg2 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Polyhedron_3_Halfedge_handle_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_Halfedge_handle_SWIG_wrapper & reference is null");
    return 0;
  } 
  arg2 = *(Polyhedron_3_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return 0;
  } 
  {
    try{
      result = (double)edge_length(*arg1,*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_face_1border_1length(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jdouble jresult = 0 ;
  Polyhedron_3_Halfedge_handle_SWIG_wrapper *arg1 = 0 ;
  Polyhedron_3_SWIG_wrapper *arg2 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Polyhedron_3_Halfedge_handle_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_Halfedge_handle_SWIG_wrapper & reference is null");
    return 0;
  } 
  arg2 = *(Polyhedron_3_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return 0;
  } 
  {
    try{
      result = (double)face_border_length(*arg1,*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_bbox(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Polyhedron_3_SWIG_wrapper *arg1 = 0 ;
  Bbox_3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Polyhedron_3_SWIG_wrapper **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return 0;
  } 
  {
    try{
      result = bbox(*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Bbox_3 **)&jresult = new Bbox_3((const Bbox_3 &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_border_1halfedges(JNIEnv *jenv, jclass jcls, jobject jarg1, jlong jarg2, jobject jarg2_, jobject jarg3) {
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Facet_handle< Polyhedron_3_ > >::input > arg1 ;
  Polyhedron_3_SWIG_wrapper *arg2 = 0 ;
  SwigValueWrapper< Wrapper_iterator_helper< SWIG_Polyhedron_3::CGAL_Halfedge_handle< Polyhedron_3_ > >::output > arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  {
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_end;
    Input_iterator_wrapper<Polyhedron_3_Facet_handle_SWIG_wrapper,Polyhedron_3_Facet_handle_SWIG_wrapper::cpp_base> it_begin(jarg1,"(LCGAL/Polyhedron_3/Polyhedron_3_Facet_handle;)J");
    arg1=std::make_pair(it_begin,it_end);
  }
  arg2 = *(Polyhedron_3_SWIG_wrapper **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    arg3=boost::make_function_output_iterator( Container_writer<Polyhedron_3_Halfedge_handle_SWIG_wrapper,Polyhedron_3_Halfedge_handle_SWIG_wrapper::cpp_base>(jarg3,"LCGAL/Polyhedron_3/Polyhedron_3_Halfedge_handle;") );
  }
  {
    try{
      border_halfedges(arg1,*arg2,arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Polygon_1mesh_1processing_CGAL_1Polygon_1mesh_1processingJNI_polygon_1soup_1to_1polygon_1mesh_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jintArray jarg2, jlong jarg3, jobject jarg3_) {
  boost::shared_ptr< std::vector< EPIC_Kernel::Point_3 > > arg1 ;
  boost::shared_ptr< std::vector< std::vector< int > > > arg2 ;
  Polyhedron_3_SWIG_wrapper *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  {
    boost::shared_ptr<std::vector<EPIC_Kernel::Point_3> > res(new std::vector<EPIC_Kernel::Point_3>());
    const jsize size = jenv->GetArrayLength(jarg1) / 3;
    res->reserve((const std::size_t) size);
    jboolean is_copy;
    jdouble* points = jenv->GetDoubleArrayElements(jarg1, &is_copy);
    for (int i = 0 ; i < size ; i++){
      res->push_back(EPIC_Kernel::Point_3(points[i*3],points[i*3+1],points[i*3+2]));
    }
    jenv->ReleaseDoubleArrayElements(jarg1, points, JNI_ABORT);
    arg1=res;
  }
  {
    boost::shared_ptr<std::vector<std::vector<int> > > res(new std::vector<std::vector<int> >());
    const jsize size = jenv->GetArrayLength(jarg2) / 3;
    res->reserve((const std::size_t) size);
    jboolean is_copy;
    jint* indices = jenv->GetIntArrayElements(jarg2, &is_copy);
    for (int i = 0 ; i < size ; i++){
      res->push_back( std::vector<int>(3) );
      res->back()[i*3]=indices[i*3];
      res->back()[i*3+1]=indices[i*3+1];
      res->back()[i*3+2]=indices[i*3+2];
    }
    jenv->ReleaseIntArrayElements(jarg2, indices, JNI_ABORT);
    arg2=res;
  }
  arg3 = *(Polyhedron_3_SWIG_wrapper **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Polyhedron_3_SWIG_wrapper & reference is null");
    return ;
  } 
  {
    try{
      polygon_soup_to_polygon_mesh(arg1,arg2,*arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


#ifdef __cplusplus
}
#endif

