/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.1
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif



#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1,
  SWIG_JavaIOException,
  SWIG_JavaRuntimeException,
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError,
  SWIG_JavaIllegalStateException,
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { SWIG_JavaIllegalStateException, "java/lang/IllegalStateException" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1
#define  SWIG_IOError        	   -2
#define  SWIG_RuntimeError   	   -3
#define  SWIG_IndexError     	   -4
#define  SWIG_TypeError      	   -5
#define  SWIG_DivisionByZero 	   -6
#define  SWIG_OverflowError  	   -7
#define  SWIG_SyntaxError    	   -8
#define  SWIG_ValueError     	   -9
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12
#define  SWIG_NullReferenceError   -13




  #include <SWIG_CGAL/Java/exception.h>


SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <typeinfo>
#include <stdexcept>


#include <string>


#if !defined(SWIGPYTHON) && !defined(SWIGJAVA)
  #define SWIG_CGAL_NON_SUPPORTED_TARGET_LANGUAGE 1
#else
  #define SWIG_CGAL_NON_SUPPORTED_TARGET_LANGUAGE 0
#endif  

 
#include <SWIG_CGAL/Point_set_3/all_includes.h> 

 typedef Point_set_3_wrapper< CGAL_PS3 >  Point_set_3_SWIG_wrapper; 
 typedef SWIG_CGAL_Iterator<typename CGAL_PS3::const_iterator,int>  Point_set_3_iterator_SWIG_wrapper; 
 typedef SWIG_CGAL_Iterator<typename CGAL_PS3::Point_range::const_iterator,Point_3>  Point_set_3_Point_iterator_SWIG_wrapper; 
 typedef SWIG_CGAL_Iterator<typename CGAL_PS3::Vector_range::const_iterator,Vector_3>  Point_set_3_Vector_iterator_SWIG_wrapper; 
 typedef SWIG_CGAL_Iterator<Nested_iterator_helper<CGAL_PS3,int>::type,int>  Point_set_3_Int_iterator_SWIG_wrapper; 
 typedef SWIG_CGAL_Iterator<Nested_iterator_helper<CGAL_PS3,double>::type,double>  Point_set_3_Float_iterator_SWIG_wrapper; 
 typedef SWIG_Point_set_3::CGAL_Property_map<CGAL_PS3,Point_3>  Point_set_3_Point_map_SWIG_wrapper; 
 typedef SWIG_Point_set_3::CGAL_Property_map<CGAL_PS3,Vector_3>  Point_set_3_Vector_map_SWIG_wrapper; 
 typedef SWIG_Point_set_3::CGAL_Property_map<CGAL_PS3,int>  Point_set_3_Int_map_SWIG_wrapper; 
 typedef SWIG_Point_set_3::CGAL_Property_map<CGAL_PS3,double>  Point_set_3_Float_map_SWIG_wrapper; 

#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_new_1Point_1set_13_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jlong jresult = 0 ;
  bool arg1 ;
  Point_set_3_wrapper< CGAL_PS3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  {
    try{
      result = (Point_set_3_wrapper< CGAL_PS3 > *)new Point_set_3_wrapper< CGAL_PS3 >(arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_new_1Point_1set_13_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (Point_set_3_wrapper< CGAL_PS3 > *)new Point_set_3_wrapper< CGAL_PS3 >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_new_1Point_1set_13_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try{
      result = (Point_set_3_wrapper< CGAL_PS3 > *)new Point_set_3_wrapper< CGAL_PS3 >((std::string const &)*arg1);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1is_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (bool)(arg1)->is_empty();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (bool)(arg1)->empty();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1number_1of_1points(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (int)(arg1)->number_of_points();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (int)(arg1)->size();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1join(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Self arg2 ;
  Point_set_3_wrapper< CGAL_PS3 >::Self *argp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  argp2 = *(Point_set_3_wrapper< CGAL_PS3 >::Self **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Point_set_3_wrapper< CGAL_PS3 >::Self");
    return 0;
  }
  arg2 = *argp2; 
  {
    try{
      result = (bool)(arg1)->join(arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      (arg1)->clear();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1clear_1properties(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      (arg1)->clear_properties();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  int *arg2 = 0 ;
  int temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  {
    try{
      (arg1)->reserve((int const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1resize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  int *arg2 = 0 ;
  int temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  {
    try{
      (arg1)->resize((int const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jint JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1insert_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (int)(arg1)->insert();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1insert_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_3 *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  arg2 = *(Point_3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Point_3 const & reference is null");
    return 0;
  } 
  {
    try{
      result = (int)(arg1)->insert((Point_3 const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1insert_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_3 *arg2 = 0 ;
  Vector_3 *arg3 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  arg2 = *(Point_3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Point_3 const & reference is null");
    return 0;
  } 
  arg3 = *(Vector_3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Vector_3 const & reference is null");
    return 0;
  } 
  {
    try{
      result = (int)(arg1)->insert((Point_3 const &)*arg2,(Vector_3 const &)*arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1insert_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jint jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Self *arg2 = 0 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  arg2 = *(Point_set_3_wrapper< CGAL_PS3 >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Point_set_3_wrapper< CGAL_PS3 >::Self const & reference is null");
    return 0;
  } 
  arg3 = (int)jarg3; 
  {
    try{
      result = (int)(arg1)->insert((Point_set_3_wrapper< CGAL_PS3 >::Self const &)*arg2,arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1insert_1range(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdoubleArray jarg2) {
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  boost::shared_ptr< std::vector< EPIC_Kernel::Point_3 > > arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    boost::shared_ptr<std::vector<EPIC_Kernel::Point_3> > res(new std::vector<EPIC_Kernel::Point_3>());
    const jsize size = jenv->GetArrayLength(jarg2) / 3;
    res->reserve((const std::size_t) size);
    jboolean is_copy;
    jdouble* points = jenv->GetDoubleArrayElements(jarg2, &is_copy);
    for (int i = 0 ; i < size ; i++){
      res->push_back(EPIC_Kernel::Point_3(points[i*3],points[i*3+1],points[i*3+2]));
    }
    jenv->ReleaseDoubleArrayElements(jarg2, points, JNI_ABORT);
    arg2=res;
  }
  {
    try{
      (arg1)->insert_range(arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1indices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (arg1)->indices();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 >::iterator **)&jresult = new Point_set_3_wrapper< CGAL_PS3 >::iterator((const Point_set_3_wrapper< CGAL_PS3 >::iterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1point(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  int *arg2 = 0 ;
  int temp2 ;
  Point_3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  {
    try{
      result = (arg1)->point((int const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_3 **)&jresult = new Point_3((const Point_3 &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1normal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  int *arg2 = 0 ;
  int temp2 ;
  Vector_3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  {
    try{
      result = (arg1)->normal((int const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Vector_3 **)&jresult = new Vector_3((const Vector_3 &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1remove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  int *arg2 = 0 ;
  int temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  {
    try{
      (arg1)->remove((int const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1is_1removed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  int *arg2 = 0 ;
  int temp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  {
    try{
      result = (bool)(arg1)->is_removed((int const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1garbage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (arg1)->garbage();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 >::iterator **)&jresult = new Point_set_3_wrapper< CGAL_PS3 >::iterator((const Point_set_3_wrapper< CGAL_PS3 >::iterator &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1number_1of_1removed_1points(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (int)(arg1)->number_of_removed_points();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1garbage_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (int)(arg1)->garbage_size();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1has_1garbage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (bool)(arg1)->has_garbage();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1collect_1garbage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      (arg1)->collect_garbage();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1cancel_1removals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      (arg1)->cancel_removals();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1has_1int_1map(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try{
      result = (bool)(arg1)->has_int_map((std::string const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1add_1int_1map_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  std::string *arg2 = 0 ;
  int arg3 ;
  Point_set_3_wrapper< CGAL_PS3 >::Int_map result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (int)jarg3; 
  {
    try{
      result = (arg1)->add_int_map((std::string const &)*arg2,arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 >::Int_map **)&jresult = new Point_set_3_wrapper< CGAL_PS3 >::Int_map((const Point_set_3_wrapper< CGAL_PS3 >::Int_map &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1add_1int_1map_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  std::string *arg2 = 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Int_map result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try{
      result = (arg1)->add_int_map((std::string const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 >::Int_map **)&jresult = new Point_set_3_wrapper< CGAL_PS3 >::Int_map((const Point_set_3_wrapper< CGAL_PS3 >::Int_map &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1int_1map(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  std::string *arg2 = 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Int_map result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try{
      result = (arg1)->int_map((std::string const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 >::Int_map **)&jresult = new Point_set_3_wrapper< CGAL_PS3 >::Int_map((const Point_set_3_wrapper< CGAL_PS3 >::Int_map &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1remove_1int_1map(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Int_map arg2 ;
  Point_set_3_wrapper< CGAL_PS3 >::Int_map *argp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  argp2 = *(Point_set_3_wrapper< CGAL_PS3 >::Int_map **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Point_set_3_wrapper< CGAL_PS3 >::Int_map");
    return 0;
  }
  arg2 = *argp2; 
  {
    try{
      result = (bool)(arg1)->remove_int_map(arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1has_1float_1map(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try{
      result = (bool)(arg1)->has_float_map((std::string const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1add_1float_1map_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jdouble jarg3) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  std::string *arg2 = 0 ;
  double arg3 ;
  Point_set_3_wrapper< CGAL_PS3 >::Float_map result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (double)jarg3; 
  {
    try{
      result = (arg1)->add_float_map((std::string const &)*arg2,arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 >::Float_map **)&jresult = new Point_set_3_wrapper< CGAL_PS3 >::Float_map((const Point_set_3_wrapper< CGAL_PS3 >::Float_map &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1add_1float_1map_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  std::string *arg2 = 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Float_map result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try{
      result = (arg1)->add_float_map((std::string const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 >::Float_map **)&jresult = new Point_set_3_wrapper< CGAL_PS3 >::Float_map((const Point_set_3_wrapper< CGAL_PS3 >::Float_map &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1float_1map(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  std::string *arg2 = 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Float_map result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try{
      result = (arg1)->float_map((std::string const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 >::Float_map **)&jresult = new Point_set_3_wrapper< CGAL_PS3 >::Float_map((const Point_set_3_wrapper< CGAL_PS3 >::Float_map &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1remove_1float_1map(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Float_map arg2 ;
  Point_set_3_wrapper< CGAL_PS3 >::Float_map *argp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  argp2 = *(Point_set_3_wrapper< CGAL_PS3 >::Float_map **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Point_set_3_wrapper< CGAL_PS3 >::Float_map");
    return 0;
  }
  arg2 = *argp2; 
  {
    try{
      result = (bool)(arg1)->remove_float_map(arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1has_1normal_1map(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (bool)(arg1)->has_normal_map();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1add_1normal_1map(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Vector_map result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (arg1)->add_normal_map();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 >::Vector_map **)&jresult = new Point_set_3_wrapper< CGAL_PS3 >::Vector_map((const Point_set_3_wrapper< CGAL_PS3 >::Vector_map &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1normal_1map(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Vector_map result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (arg1)->normal_map();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 >::Vector_map **)&jresult = new Point_set_3_wrapper< CGAL_PS3 >::Vector_map((const Point_set_3_wrapper< CGAL_PS3 >::Vector_map &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1remove_1normal_1map(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (bool)(arg1)->remove_normal_map();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1point_1map(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Point_map result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (arg1)->point_map();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 >::Point_map **)&jresult = new Point_set_3_wrapper< CGAL_PS3 >::Point_map((const Point_set_3_wrapper< CGAL_PS3 >::Point_map &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1copy_1properties(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Self *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  arg2 = *(Point_set_3_wrapper< CGAL_PS3 >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Point_set_3_wrapper< CGAL_PS3 >::Self const & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->copy_properties((Point_set_3_wrapper< CGAL_PS3 >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jobjectArray JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1properties(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobjectArray jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  boost::shared_ptr< std::vector< std::string > > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = ((Point_set_3_wrapper< CGAL_PS3 > const *)arg1)->properties();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  {
    const jsize size = result->size();
    jclass myClass = jenv->FindClass("java/lang/String");
    jobjectArray jstrings = jenv->NewObjectArray(size, myClass, NULL);
    for (std::size_t i=0;i<result->size();++i){
      jstring str = jenv->NewStringUTF((*result)[i].c_str());
      jenv->SetObjectArrayElement(jstrings, i, str);
    }
    jresult=jstrings;
  }
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1info(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = (arg1)->info();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1range_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Int_map arg2 ;
  Point_set_3_wrapper< CGAL_PS3 >::Int_map *argp2 ;
  Point_set_3_wrapper< CGAL_PS3 >::Int_iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  argp2 = *(Point_set_3_wrapper< CGAL_PS3 >::Int_map **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Point_set_3_wrapper< CGAL_PS3 >::Int_map");
    return 0;
  }
  arg2 = *argp2; 
  {
    try{
      result = (arg1)->range(arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 >::Int_iterator **)&jresult = new Point_set_3_wrapper< CGAL_PS3 >::Int_iterator((const Point_set_3_wrapper< CGAL_PS3 >::Int_iterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1range_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Float_map arg2 ;
  Point_set_3_wrapper< CGAL_PS3 >::Float_map *argp2 ;
  Point_set_3_wrapper< CGAL_PS3 >::Float_iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  argp2 = *(Point_set_3_wrapper< CGAL_PS3 >::Float_map **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Point_set_3_wrapper< CGAL_PS3 >::Float_map");
    return 0;
  }
  arg2 = *argp2; 
  {
    try{
      result = (arg1)->range(arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 >::Float_iterator **)&jresult = new Point_set_3_wrapper< CGAL_PS3 >::Float_iterator((const Point_set_3_wrapper< CGAL_PS3 >::Float_iterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1points(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Point_iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = ((Point_set_3_wrapper< CGAL_PS3 > const *)arg1)->points();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 >::Point_iterator **)&jresult = new Point_set_3_wrapper< CGAL_PS3 >::Point_iterator((const Point_set_3_wrapper< CGAL_PS3 >::Point_iterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1normals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  Point_set_3_wrapper< CGAL_PS3 >::Vector_iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      result = ((Point_set_3_wrapper< CGAL_PS3 > const *)arg1)->normals();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_set_3_wrapper< CGAL_PS3 >::Vector_iterator **)&jresult = new Point_set_3_wrapper< CGAL_PS3 >::Vector_iterator((const Point_set_3_wrapper< CGAL_PS3 >::Vector_iterator &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1read(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try{
      (arg1)->read((std::string const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1write(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try{
      result = (bool)(arg1)->write((std::string const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_delete_1Point_1set_13(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Point_set_3_wrapper< CGAL_PS3 > *arg1 = (Point_set_3_wrapper< CGAL_PS3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Point_set_3_wrapper< CGAL_PS3 > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_new_1Point_1set_13_1iterator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *)new SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1iterator_1slow_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > **)&jarg1; 
  {
    try{
      result = (int)(arg1)->slow_next();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1iterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *) 0 ;
  int *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > **)&jarg1; 
  arg2 = *(int **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->next(*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1iterator_1clone_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *) 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > **)&jarg1; 
  {
    try{
      result = ((SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > const *)arg1)->deepcopy();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self **)&jresult = new SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self((const SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1iterator_1clone_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *) 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > **)&jarg1; 
  arg2 = *(SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self const & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->deepcopy((SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1iterator_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > **)&jarg1; 
  {
    try{
      result = (bool)(arg1)->hasNext();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1iterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *) 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > **)&jarg1; 
  arg2 = *(SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self const & reference is null");
    return 0;
  } 
  {
    try{
      result = (bool)((SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > const *)arg1)->operator ==((SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1iterator_1not_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *) 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > **)&jarg1; 
  arg2 = *(SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self const & reference is null");
    return 0;
  } 
  {
    try{
      result = (bool)((SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > const *)arg1)->operator !=((SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_delete_1Point_1set_13_1iterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::const_iterator,int > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_new_1Point_1set_13_1Point_1iterator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *)new SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Point_1iterator_1slow_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *) 0 ;
  Point_3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > **)&jarg1; 
  {
    try{
      result = (arg1)->slow_next();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_3 **)&jresult = new Point_3((const Point_3 &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Point_1iterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *) 0 ;
  Point_3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > **)&jarg1; 
  arg2 = *(Point_3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Point_3 & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->next(*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Point_1iterator_1clone_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *) 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > **)&jarg1; 
  {
    try{
      result = ((SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > const *)arg1)->deepcopy();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self **)&jresult = new SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self((const SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Point_1iterator_1clone_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *) 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > **)&jarg1; 
  arg2 = *(SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self const & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->deepcopy((SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Point_1iterator_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > **)&jarg1; 
  {
    try{
      result = (bool)(arg1)->hasNext();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Point_1iterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *) 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > **)&jarg1; 
  arg2 = *(SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self const & reference is null");
    return 0;
  } 
  {
    try{
      result = (bool)((SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > const *)arg1)->operator ==((SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Point_1iterator_1not_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *) 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > **)&jarg1; 
  arg2 = *(SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self const & reference is null");
    return 0;
  } 
  {
    try{
      result = (bool)((SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > const *)arg1)->operator !=((SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_delete_1Point_1set_13_1Point_1iterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Point_range::const_iterator,Point_3 > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_new_1Point_1set_13_1Vector_1iterator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *)new SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Vector_1iterator_1slow_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *) 0 ;
  Vector_3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > **)&jarg1; 
  {
    try{
      result = (arg1)->slow_next();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Vector_3 **)&jresult = new Vector_3((const Vector_3 &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Vector_1iterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *) 0 ;
  Vector_3 *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > **)&jarg1; 
  arg2 = *(Vector_3 **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Vector_3 & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->next(*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Vector_1iterator_1clone_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *) 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > **)&jarg1; 
  {
    try{
      result = ((SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > const *)arg1)->deepcopy();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self **)&jresult = new SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self((const SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Vector_1iterator_1clone_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *) 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > **)&jarg1; 
  arg2 = *(SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self const & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->deepcopy((SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Vector_1iterator_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > **)&jarg1; 
  {
    try{
      result = (bool)(arg1)->hasNext();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Vector_1iterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *) 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > **)&jarg1; 
  arg2 = *(SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self const & reference is null");
    return 0;
  } 
  {
    try{
      result = (bool)((SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > const *)arg1)->operator ==((SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Vector_1iterator_1not_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *) 0 ;
  SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > **)&jarg1; 
  arg2 = *(SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self const & reference is null");
    return 0;
  } 
  {
    try{
      result = (bool)((SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > const *)arg1)->operator !=((SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_delete_1Point_1set_13_1Vector_1iterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *arg1 = (SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SWIG_CGAL_Iterator< CGAL_PS3::Vector_range::const_iterator,Vector_3 > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_new_1Point_1set_13_1Int_1iterator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *)new SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Int_1iterator_1slow_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > **)&jarg1; 
  {
    try{
      result = (int)(arg1)->slow_next();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Int_1iterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *) 0 ;
  int *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > **)&jarg1; 
  arg2 = *(int **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "int & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->next(*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Int_1iterator_1clone_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *) 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > **)&jarg1; 
  {
    try{
      result = ((SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > const *)arg1)->deepcopy();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self **)&jresult = new SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self((const SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Int_1iterator_1clone_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *) 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > **)&jarg1; 
  arg2 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self const & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->deepcopy((SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Int_1iterator_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > **)&jarg1; 
  {
    try{
      result = (bool)(arg1)->hasNext();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Int_1iterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *) 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > **)&jarg1; 
  arg2 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self const & reference is null");
    return 0;
  } 
  {
    try{
      result = (bool)((SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > const *)arg1)->operator ==((SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Int_1iterator_1not_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *) 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > **)&jarg1; 
  arg2 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self const & reference is null");
    return 0;
  } 
  {
    try{
      result = (bool)((SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > const *)arg1)->operator !=((SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_delete_1Point_1set_13_1Int_1iterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,int >::type,int > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_new_1Point_1set_13_1Float_1iterator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *)new SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Float_1iterator_1slow_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > **)&jarg1; 
  {
    try{
      result = (double)(arg1)->slow_next();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Float_1iterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *) 0 ;
  double *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > **)&jarg1; 
  arg2 = *(double **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "double & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->next(*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Float_1iterator_1clone_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *) 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > **)&jarg1; 
  {
    try{
      result = ((SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > const *)arg1)->deepcopy();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self **)&jresult = new SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self((const SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Float_1iterator_1clone_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *) 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > **)&jarg1; 
  arg2 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self const & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->deepcopy((SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Float_1iterator_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > **)&jarg1; 
  {
    try{
      result = (bool)(arg1)->hasNext();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Float_1iterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *) 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > **)&jarg1; 
  arg2 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self const & reference is null");
    return 0;
  } 
  {
    try{
      result = (bool)((SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > const *)arg1)->operator ==((SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Float_1iterator_1not_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *) 0 ;
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > **)&jarg1; 
  arg2 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self const & reference is null");
    return 0;
  } 
  {
    try{
      result = (bool)((SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > const *)arg1)->operator !=((SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_delete_1Point_1set_13_1Float_1iterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *arg1 = (SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SWIG_CGAL_Iterator< Nested_iterator_helper< CGAL_PS3,double >::type,double > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_new_1Point_1set_13_1Point_1map(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > *)new SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Point_1map_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > *) 0 ;
  int arg2 ;
  Point_3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try{
      result = ((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > const *)arg1)->get(arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Point_3 **)&jresult = new Point_3((const Point_3 &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Point_1map_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > *) 0 ;
  int arg2 ;
  Point_3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(Point_3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Point_3 const & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->set(arg2,(Point_3 const &)*arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Point_1map_1is_1valid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > **)&jarg1; 
  {
    try{
      result = (bool)((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > const *)arg1)->is_valid();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Point_1map_1clone_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > *) 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 >::Self result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > **)&jarg1; 
  {
    try{
      result = ((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > const *)arg1)->deepcopy();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 >::Self **)&jresult = new SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 >::Self((const SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 >::Self &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Point_1map_1clone_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > *) 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 >::Self *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > **)&jarg1; 
  arg2 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 >::Self const & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->deepcopy((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_delete_1Point_1set_13_1Point_1map(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Point_3 > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_new_1Point_1set_13_1Vector_1map(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > *)new SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Vector_1map_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > *) 0 ;
  int arg2 ;
  Vector_3 result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try{
      result = ((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > const *)arg1)->get(arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(Vector_3 **)&jresult = new Vector_3((const Vector_3 &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Vector_1map_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > *) 0 ;
  int arg2 ;
  Vector_3 *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(Vector_3 **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Vector_3 const & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->set(arg2,(Vector_3 const &)*arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Vector_1map_1is_1valid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > **)&jarg1; 
  {
    try{
      result = (bool)((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > const *)arg1)->is_valid();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Vector_1map_1clone_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > *) 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 >::Self result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > **)&jarg1; 
  {
    try{
      result = ((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > const *)arg1)->deepcopy();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 >::Self **)&jresult = new SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 >::Self((const SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 >::Self &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Vector_1map_1clone_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > *) 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 >::Self *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > **)&jarg1; 
  arg2 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 >::Self const & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->deepcopy((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_delete_1Point_1set_13_1Vector_1map(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,Vector_3 > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_new_1Point_1set_13_1Int_1map(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > *)new SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Int_1map_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try{
      result = (int)((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > const *)arg1)->get(arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Int_1map_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > *) 0 ;
  int arg2 ;
  int *arg3 = 0 ;
  int temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > **)&jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (int)jarg3; 
  arg3 = &temp3; 
  {
    try{
      (arg1)->set(arg2,(int const &)*arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Int_1map_1is_1valid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > **)&jarg1; 
  {
    try{
      result = (bool)((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > const *)arg1)->is_valid();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Int_1map_1clone_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > *) 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int >::Self result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > **)&jarg1; 
  {
    try{
      result = ((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > const *)arg1)->deepcopy();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int >::Self **)&jresult = new SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int >::Self((const SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int >::Self &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Int_1map_1clone_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > *) 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int >::Self *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > **)&jarg1; 
  arg2 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int >::Self const & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->deepcopy((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_delete_1Point_1set_13_1Int_1map(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,int > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_new_1Point_1set_13_1Float_1map(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try{
      result = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > *)new SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double >();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Float_1map_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > *) 0 ;
  int arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try{
      result = (double)((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > const *)arg1)->get(arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Float_1map_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > *) 0 ;
  int arg2 ;
  double *arg3 = 0 ;
  double temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > **)&jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (double)jarg3; 
  arg3 = &temp3; 
  {
    try{
      (arg1)->set(arg2,(double const &)*arg3);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Float_1map_1is_1valid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > **)&jarg1; 
  {
    try{
      result = (bool)((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > const *)arg1)->is_valid();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Float_1map_1clone_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > *) 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double >::Self result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > **)&jarg1; 
  {
    try{
      result = ((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > const *)arg1)->deepcopy();
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
  *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double >::Self **)&jresult = new SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double >::Self((const SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double >::Self &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_Point_1set_13_1Float_1map_1clone_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > *) 0 ;
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double >::Self *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > **)&jarg1; 
  arg2 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double >::Self **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double >::Self const & reference is null");
    return ;
  } 
  {
    try{
      (arg1)->deepcopy((SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double >::Self const &)*arg2);
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


SWIGEXPORT void JNICALL Java_CGAL_Point_1set_13_CGAL_1Point_1set_13JNI_delete_1Point_1set_13_1Float_1map(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > *arg1 = (SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SWIG_Point_set_3::CGAL_Property_map< CGAL_PS3,double > **)&jarg1; 
  {
    try{
      delete arg1;
    }
    catch(std::exception& e){
      std::string error_msg("Error in SWIG_CGAL code. Here is the text of the C++ exception:\n");
      error_msg += e.what();
      if ( !throwJavaException(error_msg.c_str()) )
      throw; //rethrow exception that could not be thrown in java
    }
    catch(...){
      if ( !throwJavaException("Unknown error in SWIG_CGAL code") )
      throw; //rethrow exception that could not be thrown in java
    }
  }
}


#ifdef __cplusplus
}
#endif

